/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.kms.util;

import java.util.Properties;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.utility.Logger.inf.SJcLoggerInterface;
import sanproject.sn2.com.utility.SJcFileUty;
import sanproject.sn2.com.utility.fileuty.exception.SJcFileUtyParameterException;
import sanproject.sn2.kms.exception.SJkmsConfigUtyComException;
import sanproject.sn2.kms.util.SJkmsLogUtil;

public class SJkmsConfigUtyCom {
    private static final String LOG_FUNCTION = "Kms";
    private static final String LOG_TITLE = "SJkmsConfigUtyCom";
    private static final int productIDlength = 10;
    private static final String productIDpadStr = "0";

    private SJkmsConfigUtyCom() {
    }

    public static String convertProductID(String productID) {
        String ret = productID.trim();
        String productIDpad = "";
        for (int i = 0; i < 10 - ret.length(); ++i) {
            productIDpad = productIDpad + productIDpadStr;
        }
        ret = productIDpad + ret;
        return ret;
    }

    public static Properties loadProperties() {
        String LOG_SUBTITLE = "loadProperties";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "loadProperties", "start");
        Properties ret = null;
        try {
            SJcFileUty.decryptFile("kms\\setting\\", "Kms_Config.properties", "kms\\tmp\\", "Kms_Config_dec.properties");
            ret = SJcFileUty.loadProperties("kms\\tmp\\", "Kms_Config_dec.properties");
            SJcFileUty.deleteFile("kms\\tmp\\", "Kms_Config_dec.properties");
        }
        catch (SJcException ex) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "loadProperties", "Load Failed", ex);
            return null;
        }
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "loadProperties", "end");
        return ret;
    }

    public static void saveProperties(Properties prop) throws SJkmsConfigUtyComException, SJcException {
        String LOG_SUBTITLE = "saveProperties";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "saveProperties", "start");
        if (prop == null) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "saveProperties", "parameter is null");
            throw new SJcException();
        }
        try {
            SJcFileUty.saveProperties("kms\\tmp\\", "Kms_Config_dec.properties", prop);
            SJcFileUty.encryptFile("kms\\tmp\\", "Kms_Config_dec.properties", "kms\\setting\\", "Kms_Config.properties");
            SJcFileUty.deleteFile("kms\\tmp\\", "Kms_Config_dec.properties");
        }
        catch (SJcFileUtyParameterException ex) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "saveProperties", "Save Failed", ex);
            throw new SJcException();
        }
        catch (SJcException ex) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "saveProperties", "Save Failed", ex);
            throw new SJkmsConfigUtyComException();
        }
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "saveProperties", "end");
    }

    public static void clearProperties() {
        String LOG_SUBTITLE = "clearProperties()";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        try {
            SJcFileUty.deleteFile("kms\\setting\\", "Kms_Config.properties");
        }
        catch (SJcException ex) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "clearProperties()", "Clear Properties FileFailed", ex);
        }
        try {
            SJcFileUty.deleteFile("kms\\setting\\", "PrimaryServer.Kms.keystore");
            SJcFileUty.deleteFile("kms\\setting\\", "SecondaryServer.Kms.keystore");
        }
        catch (SJcException ex) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "clearProperties()", "Clear Keystore  Failed", ex);
        }
        try {
            SJcFileUty.deleteFile("kms\\setting\\", "PrimaryServer.Kms.truststore");
            SJcFileUty.deleteFile("kms\\setting\\", "SecondaryServer.Kms.truststore");
        }
        catch (SJcException ex) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "clearProperties()", "Clear Truststore Failed", ex);
        }
    }
}

