/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.model.data.lu;

import com.hitachi.sanproject.data.SanDataException;
import com.hitachi.sanproject.data.SanObject;
import java.util.ArrayList;
import sanproject.sn2.com.utility.SJcSecureUty;
import sanproject.sn2.model.SJmoUtility;
import sanproject.sn2.model.data.SJmoModelData_Base;
import sanproject.sn2.model.data.device.SJmoPortIndex;
import sanproject.sn2.model.data.inf.SJmoData_IF;
import sanproject.sn2.model.data.lu.SJmoIscsiTargetIndex;
import sanproject.sn2.model.data.util.SJmoDataUtility;
import sanproject.sn2.model.inf.SJmoKeyValueDefine_IF;

public class SJmoChapUserInfo
extends SJmoPortIndex
implements SJmoData_IF,
SJmoKeyValueDefine_IF {
    private static final long serialVersionUID = 5926957846583854478L;
    private String strUserName = "";
    private String strSecret = "";
    private ArrayList<SJmoIscsiTargetIndex> alIscsiTargets = new ArrayList();

    public SJmoChapUserInfo() {
    }

    public SJmoChapUserInfo(short portId, SanObject rmiChapUserInfo) {
        if (rmiChapUserInfo == null) {
            throw SJmoUtility.getException(201, 23, 107000, "SJmoChapUserInfo", "SJmoChapUserInfo");
        }
        try {
            this.sPort = portId;
            this.strUserName = rmiChapUserInfo.getString("UserId");
            this.setStrSecret(rmiChapUserInfo.getString("Secret"));
        }
        catch (SanDataException sdEx) {
            throw SJmoUtility.getException(201, 23, 107000, "SJmoChapUserInfo", "SJmoChapUserInfo");
        }
    }

    public String getStrUserName() {
        return this.strUserName;
    }

    public String getStrSecret() {
        if (null != this.strSecret && this.strSecret.length() != 0) {
            return SJcSecureUty.decryptStrToStr(this.strSecret);
        }
        return this.strSecret;
    }

    public ArrayList<SJmoIscsiTargetIndex> getAlIscsiTargets() {
        return this.alIscsiTargets;
    }

    public void setStrUserName(String strUserName) {
        this.strUserName = strUserName;
    }

    public void setStrSecret(String strSecret) {
        this.strSecret = null != strSecret && strSecret.length() != 0 ? SJcSecureUty.encryptStrToStr(strSecret) : strSecret;
    }

    public void setAlIscsiTargets(ArrayList<SJmoIscsiTargetIndex> alIscsiTargets) {
        this.alIscsiTargets = alIscsiTargets;
    }

    @Override
    public boolean isNumKey() {
        return false;
    }

    @Override
    public String toString() {
        return super.getIndexKey() + this.strUserName;
    }

    @Override
    public int compareTo(Object keyObj) {
        return this.toString().compareTo(keyObj.toString());
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        SJmoChapUserInfo retObj = (SJmoChapUserInfo)super.clone();
        retObj.setAlIscsiTargets(SJmoDataUtility.alDeepCopy(retObj.getAlIscsiTargets()));
        return retObj;
    }

    @Override
    public Object clone(byte byDataMode) throws CloneNotSupportedException {
        SJmoModelData_Base retObj = (SJmoModelData_Base)this.clone();
        retObj.setIDataMode(byDataMode);
        return retObj;
    }
}

