/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.model.data.replication.remote;

import sanproject.serverux.dataimpl.RMCPget1PathtoRCU;
import sanproject.sn2.model.SJmoUtility;
import sanproject.sn2.model.data.SJmoModelData_Base;
import sanproject.sn2.model.data.device.SJmoPortIndex;

public class SJmoRemoteReplicationRCUPathInfo
extends SJmoPortIndex {
    private static final long serialVersionUID = 3304456514124101790L;
    private int iRCUPortNo = -1;
    private int iPathStatus = -1;

    public SJmoRemoteReplicationRCUPathInfo() {
    }

    public SJmoRemoteReplicationRCUPathInfo(RMCPget1PathtoRCU rmiPathtoRcu) {
        if (rmiPathtoRcu == null) {
            throw SJmoUtility.getException(201, 23, 107000, this.getClass().getSimpleName(), "Constructor");
        }
        this.setSPort((short)rmiPathtoRcu.getMCUPortNo());
        this.setIRCUPortNo(rmiPathtoRcu.getRCUPortNo());
        this.setIPathStatus(rmiPathtoRcu.getPathStatus());
    }

    public int getIRCUPortNo() {
        return this.iRCUPortNo;
    }

    public int getIPathStatus() {
        return this.iPathStatus;
    }

    public void setIRCUPortNo(int portNo) {
        this.iRCUPortNo = portNo;
    }

    public void setIPathStatus(int pathStatus) {
        this.iPathStatus = pathStatus;
    }

    @Override
    public boolean isValidIndex() {
        boolean bRet = false;
        if (super.isValidIndex() && -1 < this.iRCUPortNo) {
            bRet = true;
        }
        return bRet;
    }

    @Override
    public int compareTo(Object keyObj) {
        int iRet = 0;
        if (keyObj instanceof SJmoRemoteReplicationRCUPathInfo) {
            try {
                iRet = super.compareTo(keyObj);
                if (iRet != 0) {
                    return iRet;
                }
                iRet = this.iRCUPortNo - ((SJmoRemoteReplicationRCUPathInfo)keyObj).iRCUPortNo;
                if (iRet != 0) {
                    return iRet;
                }
            }
            catch (NumberFormatException e) {
                iRet = this.toString().compareTo(keyObj.toString());
            }
        } else {
            iRet = this.toString().compareTo(keyObj.toString());
        }
        return iRet;
    }

    @Override
    public String toString() {
        StringBuffer sbRet = new StringBuffer();
        if (!this.isValidIndex()) {
            return sbRet.toString();
        }
        try {
            sbRet.append(super.toString());
            sbRet.append(SJmoUtility.itoh(this.iRCUPortNo, 2));
        }
        catch (Exception e) {
            SJmoUtility.putLogDetail(this.getClass().getSimpleName(), "toString", "Parameter is invalid.");
            sbRet = new StringBuffer();
        }
        return sbRet.toString();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    public Object clone(byte byDataMode) throws CloneNotSupportedException {
        SJmoModelData_Base retObj = (SJmoModelData_Base)this.clone();
        retObj.setIDataMode(byDataMode);
        return retObj;
    }
}

