/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.model.data.replication.remote;

import java.text.DateFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Date;
import sanproject.serverux.dataimpl.RMCPget1PairSummary;
import sanproject.sn2.model.SJmoUtility;
import sanproject.sn2.model.data.SJmoModelData_Base;
import sanproject.sn2.model.data.lu.SJmoLuIndex;
import sanproject.sn2.model.data.replication.SJmoReplicationPairVolInfo;
import sanproject.sn2.model.data.util.SJmoDataUtility;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;

public class SJmoTrueCopyPairVolInfo
extends SJmoReplicationPairVolInfo {
    private static final long serialVersionUID = -1115427481243528817L;
    private SJmoLuIndex pairLU = null;
    private int iPairStatus = -1;
    private int iSubPairStatus = -1;
    private BitSet typeBitSet = new BitSet(32);
    private String strPairSN = "";
    private int iPairSSID = -1;
    private int iCUFree = -1;
    private int iPairRCUID = -1;
    private int iPairControllerID = -1;
    private int iPriority = -1;
    private int iTracks = -1;
    private int iCtgId = -1;
    private Date daPairCreateTime = null;
    private Date daPairRenewTime = null;
    private long lPairCopyTime = -1L;
    private int iLockID = -1;
    private int iSSWS = -1;
    private int iLockStatus = -1;
    private BitSet behaviorBitSet = new BitSet(32);
    private String strHostPairStatus = "";
    private int iFormatinfo = -1;
    private int iQueu = -1;
    private int iVirtualVolEnable = -1;
    private String strVirtualDKCSN = "";
    private int iVirtualDKCModelID = -1;
    private int iVirtualPairLDEV = -1;
    private int iVirtualPairPort = -1;
    private int iVirtualPairSSID = -1;
    private int[] virtualPairOption = null;
    private String strIndexKey = "";

    public SJmoTrueCopyPairVolInfo() {
    }

    public SJmoTrueCopyPairVolInfo(RMCPget1PairSummary rmiPairSummary) {
        ParsePosition pos = new ParsePosition(0);
        SimpleDateFormat df = new SimpleDateFormat("MM/dd/yyyy hh:mm:ss");
        if (rmiPairSummary != null) {
            this.setLdevIndex(rmiPairSummary.PairLDKC, rmiPairSummary.PairCUNo, rmiPairSummary.PairLDEVNo);
            SJmoLuIndex luIndex = new SJmoLuIndex();
            luIndex.setSPort((short)rmiPairSummary.PairLU.PortNo);
            luIndex.setSHostGroup((short)rmiPairSummary.PairLU.GroupNo);
            luIndex.setILUN(rmiPairSummary.PairLU.LUN);
            this.setPairLU(luIndex);
            this.setIPairStatus(rmiPairSummary.PairStatus);
            this.setISubPairStatus(rmiPairSummary.SubPairStatus);
            this.setTypeBitSet(SJmoDataUtility.makeIntArrayToBitSet(new int[]{rmiPairSummary.Type}, true));
            this.setStrPairSN(rmiPairSummary.PairSN);
            this.setIPairSSID(rmiPairSummary.PairSSID);
            this.setICUFree(rmiPairSummary.CUFree);
            this.setIPairRCUID(rmiPairSummary.PairRCUID);
            this.setIPairControllerID(rmiPairSummary.PairControllerID);
            this.setIPriority(rmiPairSummary.Priority);
            this.setITracks(rmiPairSummary.Tracks);
            this.setICtgId(rmiPairSummary.Async & 0x3FF);
            if (rmiPairSummary.getPairCreateTime() != null) {
                Date daPairCreateTime = ((DateFormat)df).parse(rmiPairSummary.getPairCreateTime(), pos);
                if (pos.getErrorIndex() == -1) {
                    this.setDaPairCreateTime(daPairCreateTime);
                }
            } else {
                SJmoUtility.putLogDetail(this.getClass().getSimpleName(), "Constructor", "PairCreateTime is Null.");
            }
            if (rmiPairSummary.getPairRenewTime() != null) {
                pos.setIndex(0);
                Date daPairRenewTime = ((DateFormat)df).parse(rmiPairSummary.getPairRenewTime(), pos);
                if (pos.getErrorIndex() == -1) {
                    this.setDaPairRenewTime(daPairRenewTime);
                }
            } else {
                SJmoUtility.putLogDetail(this.getClass().getSimpleName(), "Constructor", "PairRenewTime is Null.");
            }
            String strPairCopyTime = rmiPairSummary.getPairCopyTime();
            if (strPairCopyTime != null) {
                String[] strAry = strPairCopyTime.split(":");
                if (strAry.length == 3 && strAry[0].length() != 0 && strAry[1].length() != 0 && strAry[2].length() != 0) {
                    try {
                        long lHour = Long.parseLong(strAry[0]);
                        long lMin = Long.parseLong(strAry[1]);
                        long lSec = Long.parseLong(strAry[2]);
                        long lPairCopyTime = lSec + lMin * 60L + lHour * 60L * 60L;
                        this.setLPairCopyTime(lPairCopyTime);
                    }
                    catch (NumberFormatException e) {
                        SJmoUtility.putLogDetail(this.getClass().getSimpleName(), "Constructor", "PairCopyTime is invalid. (" + rmiPairSummary.getPairCopyTime() + ")");
                    }
                }
            } else {
                SJmoUtility.putLogDetail(this.getClass().getSimpleName(), "Constructor", "PairCopyTime is Null.");
            }
        } else {
            throw SJmoUtility.getException(201, 23, 107000, this.getClass().getSimpleName(), "Constructor");
        }
        this.setILockID(rmiPairSummary.iLockID);
        this.setISSWS(rmiPairSummary.iSSWS);
        this.setILockStatus(rmiPairSummary.iLockStatus);
        this.setBehaviorBitSet(SJmoDataUtility.makeIntArrayToBitSet(new int[]{rmiPairSummary.PairOption.Behavior}, true));
        this.setStrHostPairStatus(rmiPairSummary.sHostPairStatus);
        this.setIFormatinfo(rmiPairSummary.Formatinfo);
        this.setIQueu(rmiPairSummary.Queu);
        this.setIVirtualVolEnable(rmiPairSummary.Virtual);
        this.setStrVirtualDKCSN(rmiPairSummary.PairSN_V);
        this.setIVirtualDKCModelID(rmiPairSummary.PairModel_V);
        this.setIVirtualPairLDEV(rmiPairSummary.PairLDEV_V);
        this.setIiVirtualPairPort(rmiPairSummary.PairPort_V);
        this.setIVirtualPairSSID(rmiPairSummary.PairSSID_V);
        this.setVirtualPairOption(rmiPairSummary.PairOption_V);
    }

    public SJmoLuIndex getPairLU() {
        return this.pairLU;
    }

    public int getIPairStatus() {
        return this.iPairStatus;
    }

    public int getISubPairStatus() {
        return this.iSubPairStatus;
    }

    public BitSet getTypeBitSet() {
        return this.typeBitSet;
    }

    public String getStrPairSN() {
        return this.strPairSN;
    }

    public int getIPairSSID() {
        return this.iPairSSID;
    }

    public int getICUFree() {
        return this.iCUFree;
    }

    public int getIPairRCUID() {
        return this.iPairRCUID;
    }

    public int getIPairControllerID() {
        return this.iPairControllerID;
    }

    public int getIPriority() {
        return this.iPriority;
    }

    public int getITracks() {
        return this.iTracks;
    }

    public int getICtgId() {
        return this.iCtgId;
    }

    public Date getDaPairCreateTime() {
        return this.daPairCreateTime;
    }

    public Date getDaPairRenewTime() {
        return this.daPairRenewTime;
    }

    public long getLPairCopyTime() {
        return this.lPairCopyTime;
    }

    public int getILockID() {
        return this.iLockID;
    }

    public int getISSWS() {
        return this.iSSWS;
    }

    public int getILockStatus() {
        return this.iLockStatus;
    }

    public BitSet getBehaviorBitSet() {
        return this.behaviorBitSet;
    }

    public String getStrHostPairStatus() {
        return this.strHostPairStatus;
    }

    public int getIFormatinfo() {
        return this.iFormatinfo;
    }

    public int getIQueu() {
        return this.iQueu;
    }

    public int getIVirtualVolEnable() {
        return this.iVirtualVolEnable;
    }

    public String getStrVirtualDKCSN() {
        return this.strVirtualDKCSN;
    }

    public int getIVirtualDKCModelID() {
        return this.iVirtualDKCModelID;
    }

    public int getIVirtualPairLDEV() {
        return this.iVirtualPairLDEV;
    }

    public int getIVirtualPairPort() {
        return this.iVirtualPairPort;
    }

    public int getIVirtualPairSSID() {
        return this.iVirtualPairSSID;
    }

    public int[] getVirtualPairOption() {
        return this.virtualPairOption;
    }

    @Override
    public void setSLdkc(short ldkc) {
        super.setSLdkc(ldkc);
        this.strIndexKey = "";
    }

    @Override
    public void setSCu(short cu) {
        super.setSCu(cu);
        this.strIndexKey = "";
    }

    @Override
    public void setSLdev(short sLdev) {
        super.setSLdev(sLdev);
        this.strIndexKey = "";
    }

    @Override
    public void setAlSVolIndex(ArrayList<? extends SJmoLdevIndex> alSVolIndex) {
        super.setAlSVolIndex(alSVolIndex);
        this.strIndexKey = "";
    }

    @Override
    public void setAlPVolIndex(ArrayList<? extends SJmoLdevIndex> alPVolIndex) {
        super.setAlPVolIndex(alPVolIndex);
        this.strIndexKey = "";
    }

    @Override
    public void setPVolIndex(SJmoLdevIndex volIndex) {
        super.setPVolIndex(volIndex);
        this.strIndexKey = "";
    }

    public void setPairLU(SJmoLuIndex pairLU) {
        this.pairLU = pairLU;
    }

    public void setIPairStatus(int pairStatus) {
        this.iPairStatus = pairStatus;
    }

    public void setISubPairStatus(int subPairStatus) {
        this.iSubPairStatus = subPairStatus;
    }

    public void setTypeBitSet(BitSet typeBitSet) {
        this.typeBitSet = typeBitSet;
    }

    public void setStrPairSN(String strPairSN) {
        this.strPairSN = strPairSN;
        this.strIndexKey = "";
    }

    public void setIPairSSID(int pairSSID) {
        this.iPairSSID = pairSSID;
    }

    public void setICUFree(int free) {
        this.iCUFree = free;
    }

    public void setIPairRCUID(int pairRCUID) {
        this.iPairRCUID = pairRCUID;
    }

    public void setIPairControllerID(int pairControllerID) {
        this.iPairControllerID = pairControllerID;
    }

    public void setIPriority(int priority) {
        this.iPriority = priority;
    }

    public void setITracks(int tracks) {
        this.iTracks = tracks;
    }

    public void setICtgId(int ctgId) {
        this.iCtgId = ctgId;
    }

    public void setDaPairCreateTime(Date daPairCreateTime) {
        this.daPairCreateTime = daPairCreateTime;
    }

    public void setDaPairRenewTime(Date daPairRenewTime) {
        this.daPairRenewTime = daPairRenewTime;
    }

    public void setLPairCopyTime(long pairCopyTime) {
        this.lPairCopyTime = pairCopyTime;
    }

    public void setILockID(int lockID) {
        this.iLockID = lockID;
    }

    public void setISSWS(int issws) {
        this.iSSWS = issws;
    }

    public void setILockStatus(int lockStatus) {
        this.iLockStatus = lockStatus;
    }

    public void setBehaviorBitSet(BitSet behaviorBitSet) {
        this.behaviorBitSet = behaviorBitSet;
    }

    public void setStrHostPairStatus(String strHostPairStatus) {
        this.strHostPairStatus = strHostPairStatus;
    }

    public void setIFormatinfo(int formatinfo) {
        this.iFormatinfo = formatinfo;
    }

    public void setIQueu(int queu) {
        this.iQueu = queu;
    }

    public void setIVirtualVolEnable(int iVirtualVolEnable) {
        this.iVirtualVolEnable = iVirtualVolEnable;
    }

    public void setStrVirtualDKCSN(String strVirtualDKCSN) {
        this.strVirtualDKCSN = strVirtualDKCSN;
    }

    public void setIVirtualDKCModelID(int iVirtualDKCModelID) {
        this.iVirtualDKCModelID = iVirtualDKCModelID;
    }

    public void setIVirtualPairLDEV(int iVirtualPairLDEV) {
        this.iVirtualPairLDEV = iVirtualPairLDEV;
    }

    public void setIiVirtualPairPort(int iVirtualPairPort) {
        this.iVirtualPairPort = iVirtualPairPort;
    }

    public void setIVirtualPairSSID(int iVirtualPairSSID) {
        this.iVirtualPairSSID = iVirtualPairSSID;
    }

    public void setVirtualPairOption(int[] virtualPairOption) {
        this.virtualPairOption = virtualPairOption;
    }

    public boolean isTypeBit(int iBitNum) {
        return this.typeBitSet.get(iBitNum);
    }

    public boolean isBehaviorBit(int iBitNum) {
        return this.behaviorBitSet.get(iBitNum);
    }

    private void allBitSetClone() {
        this.setTypeBitSet((BitSet)this.typeBitSet.clone());
        this.setBehaviorBitSet((BitSet)this.behaviorBitSet.clone());
    }

    @Override
    public int compareTo(Object keyObj) {
        int iRet = 0;
        if (keyObj instanceof SJmoTrueCopyPairVolInfo) {
            try {
                int iSn = Integer.parseInt(this.strPairSN);
                int iKeySN = Integer.parseInt(((SJmoTrueCopyPairVolInfo)keyObj).strPairSN);
                iRet = iSn - iKeySN;
                if (iRet != 0) {
                    return iRet;
                }
                iRet = this.getIndex() - ((SJmoTrueCopyPairVolInfo)keyObj).getIndex();
                if (iRet != 0) {
                    return iRet;
                }
                if (this.getPVolIndex() != null) {
                    iRet = this.getPVolIndex().getIndex() - ((SJmoTrueCopyPairVolInfo)keyObj).getPVolIndex().getIndex();
                }
            }
            catch (NumberFormatException e) {
                iRet = this.toString().compareTo(keyObj.toString());
            }
        } else {
            iRet = this.toString().compareTo(keyObj.toString());
        }
        return iRet;
    }

    @Override
    public String toString() {
        if (this.strIndexKey != null && this.strIndexKey.length() != 0) {
            return this.strIndexKey;
        }
        try {
            String strSn = SJmoUtility.itoh(Integer.parseInt(this.strPairSN), 8);
            String strPVolIndex = "";
            if (this.getPVolIndex() != null) {
                strPVolIndex = this.getPVolIndex().getIndexKey();
            }
            this.strIndexKey = strSn + this.getIndexKey() + strPVolIndex;
        }
        catch (NumberFormatException e) {
            SJmoUtility.putLogDetail(this.getClass().getSimpleName(), "toString", "strPairSN is invalid. (" + this.strPairSN + ")");
        }
        return this.strIndexKey;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        SJmoTrueCopyPairVolInfo retObj = (SJmoTrueCopyPairVolInfo)super.clone();
        retObj.allBitSetClone();
        return retObj;
    }

    @Override
    public Object clone(byte byDataMode) throws CloneNotSupportedException {
        SJmoModelData_Base retObj = (SJmoModelData_Base)this.clone();
        retObj.setIDataMode(byDataMode);
        return retObj;
    }
}

