/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.model.data.util;

import java.util.ArrayList;
import java.util.Collections;
import sanproject.serversx.data.RJiLDEVIndex;
import sanproject.serverux.dataimpl.HURget1ECTGrp;
import sanproject.serverux.dataimpl.HURget1JNLGinECTG;
import sanproject.serverux.dataimpl.HURgetECTGrps;
import sanproject.serverux.dataimpl.HURgetSystemOption;
import sanproject.serverux.dataimpl.RJiHAget1PairSummary;
import sanproject.serverux.dataimpl.RJiHURget1JNLG;
import sanproject.serverux.dataimpl.RJiHURget1PairInfo;
import sanproject.serverux.dataimpl.RJiHURgetJNLG1Mirror;
import sanproject.serverux.dataimpl.RJiHURgetPairsInfo;
import sanproject.serverux.dataimpl.RMCPget1LockID;
import sanproject.serverux.dataimpl.RMCPget1PairSummary;
import sanproject.serverux.dataimpl.RMCPgetAllLockID;
import sanproject.serverux.dataimpl.RMCPgetMRCUofCU;
import sanproject.sn2.model.SJmoUtility;
import sanproject.sn2.model.data.SJmoModelData_Base;
import sanproject.sn2.model.data.inf.SJmoDataIndex_IF;
import sanproject.sn2.model.data.inf.SJmoData_IF;
import sanproject.sn2.model.data.replication.SJmoReplicationPairVolInfo;
import sanproject.sn2.model.data.replication.SJmoReplicationPairVolPosInfo;
import sanproject.sn2.model.data.replication.remote.SJmoHAPairVolInfo;
import sanproject.sn2.model.data.replication.remote.SJmoQuorumDiskInfo;
import sanproject.sn2.model.data.replication.remote.SJmoRemoteReplicationLuPath;
import sanproject.sn2.model.data.replication.remote.SJmoRemoteReplicationMRCUInfo;
import sanproject.sn2.model.data.replication.remote.SJmoTrueCopyPairVolInfo;
import sanproject.sn2.model.data.replication.remote.SJmoUniversalReplicatorEXCTG;
import sanproject.sn2.model.data.replication.remote.SJmoUniversalReplicatorEXCTGJnlGrp;
import sanproject.sn2.model.data.replication.remote.SJmoUniversalReplicatorJnlGrp;
import sanproject.sn2.model.data.replication.remote.SJmoUniversalReplicatorJnlGrpMirror;
import sanproject.sn2.model.data.replication.remote.SJmoUniversalReplicatorPairVolInfo;
import sanproject.sn2.model.data.replication.remote.SJmoUniversalReplicatorSummary;
import sanproject.sn2.model.data.replication.remote.SJmoUniversalReplicatorSystemOptionInfo;
import sanproject.sn2.model.data.util.SJmoDataUtility;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;
import sanproject.sn2.model.inf.SJmoDataMacro_IF;

public class SJmoRemoteReplicationUtility {
    public static boolean isValidJnlGrpId(int iJnlGrpId) {
        return iJnlGrpId >= 0 && iJnlGrpId <= SJmoDataMacro_IF.NUM_MAX_RC_JNLG_ID;
    }

    public static boolean isValidMirrorId(int iMirrorId) {
        return iMirrorId >= 0 && iMirrorId <= 3;
    }

    public static boolean isValidExCtgId(int iExCtgId) {
        return iExCtgId >= 0 && iExCtgId <= 3;
    }

    public static SJmoDataIndex_IF[] makeTrueCopyPairVolInfoList(RMCPget1PairSummary[] rmi1PairSummaryList, SJmoReplicationPairVolPosInfo volPosInfo) {
        SJmoDataIndex_IF[] retList = new SJmoReplicationPairVolInfo[SJmoDataMacro_IF.MAX_EQIP_LDEV_LDKC];
        for (int iCnt = 0; iCnt < rmi1PairSummaryList.length; ++iCnt) {
            if (null != rmi1PairSummaryList[iCnt]) {
                if (rmi1PairSummaryList[iCnt].PairStatus == 0) continue;
                SJmoReplicationPairVolInfo pairVol = new SJmoReplicationPairVolInfo();
                pairVol.setLdevIndex(rmi1PairSummaryList[iCnt].sLDKC, rmi1PairSummaryList[iCnt].sCU, rmi1PairSummaryList[iCnt].sLDEV);
                SJmoTrueCopyPairVolInfo tCPairVol = new SJmoTrueCopyPairVolInfo(rmi1PairSummaryList[iCnt]);
                int iVolPosBitMap = volPosInfo.getIVolPosBitMap(pairVol);
                int iPairVolPosBitMap = SJmoRemoteReplicationUtility.iPairVolBitMap(iVolPosBitMap);
                pairVol.setIPairVolPos(iVolPosBitMap);
                tCPairVol.setIPairVolPos(iPairVolPosBitMap);
                if (SJmoDataUtility.chkAllBitOn(1, iVolPosBitMap) || SJmoDataUtility.chkAllBitOn(32, iVolPosBitMap)) {
                    pairVol.getAlSVolIndex().add(tCPairVol);
                    tCPairVol.setPVolIndex(pairVol);
                } else if (SJmoDataUtility.chkAllBitOn(2, iVolPosBitMap) || SJmoDataUtility.chkAllBitOn(64, iVolPosBitMap)) {
                    pairVol.setPVolIndex(tCPairVol);
                    tCPairVol.getAlSVolIndex().add(pairVol);
                }
                retList[pairVol.getIndex()] = pairVol;
                continue;
            }
            SJmoUtility.putLogDetail(SJmoRemoteReplicationUtility.class.getSimpleName(), "makeTrueCopyPairVolInfoList", "rmi1PairSummarySxList[" + iCnt + "] is null");
        }
        return retList;
    }

    public static SJmoDataIndex_IF[] makeMRCUofCUInfoList(RMCPgetMRCUofCU[] rmiMRCUList) {
        SJmoDataIndex_IF[] retMRCUList = new SJmoRemoteReplicationMRCUInfo[SJmoDataMacro_IF.CUMAX_LDKC];
        for (int iCnt = 0; iCnt < rmiMRCUList.length; ++iCnt) {
            if (null != rmiMRCUList[iCnt]) {
                SJmoRemoteReplicationMRCUInfo mrcuInfo = new SJmoRemoteReplicationMRCUInfo(rmiMRCUList[iCnt], iCnt);
                mrcuInfo.setSCu((short)iCnt);
                retMRCUList[iCnt] = mrcuInfo;
                continue;
            }
            SJmoUtility.putLogDetail(SJmoRemoteReplicationUtility.class.getSimpleName(), "makeMRCUofCUInfoList", "rmiMRCUList[" + iCnt + "] is null");
        }
        return retMRCUList;
    }

    public static SJmoDataIndex_IF[] makePairsInfoList(ArrayList<RJiHURget1PairInfo> rmiPairInfoList, SJmoReplicationPairVolPosInfo volPosInf) {
        SJmoDataIndex_IF[] retPairInfo = new SJmoReplicationPairVolInfo[SJmoDataMacro_IF.MAX_EQIP_LDEV_LDKC];
        if (rmiPairInfoList == null || volPosInf == null) {
            throw SJmoUtility.getException(201, 23, 107000, "makePairsInfoList", "Argument is null");
        }
        for (int iPiarCnt = 0; iPiarCnt < rmiPairInfoList.size(); ++iPiarCnt) {
            int ivolPosInfo;
            SJmoUniversalReplicatorPairVolInfo urPairInfo = new SJmoUniversalReplicatorPairVolInfo(rmiPairInfoList.get(iPiarCnt));
            ArrayList<SJmoUniversalReplicatorPairVolInfo> alURPairList = new ArrayList<SJmoUniversalReplicatorPairVolInfo>();
            SJmoReplicationPairVolInfo pairVolInfo = new SJmoReplicationPairVolInfo();
            if (urPairInfo.getPairStatus() == 0) continue;
            if (urPairInfo.getPairKind() == 0) {
                pairVolInfo.setLdevIndex(urPairInfo.getPVolLuPath().getSLdkc(), urPairInfo.getPVolLuPath().getSCu(), urPairInfo.getPVolLuPath().getSLdev());
                ivolPosInfo = volPosInf.getIVolPosBitMap(pairVolInfo.getIndex());
                pairVolInfo.setIPairVolPos(ivolPosInfo);
                if (!SJmoRemoteReplicationUtility.isURPVolPair(ivolPosInfo)) continue;
                if (SJmoRemoteReplicationUtility.isURPair(ivolPosInfo)) {
                    urPairInfo.setIPairVolPos(8192);
                } else if (SJmoRemoteReplicationUtility.isURMFPair(ivolPosInfo)) {
                    urPairInfo.setIPairVolPos(262144);
                }
                alURPairList.add(urPairInfo);
                pairVolInfo.setAlSVolIndex(alURPairList);
                urPairInfo.getAlPVolIndex().add(pairVolInfo);
                retPairInfo = SJmoRemoteReplicationUtility.setURPairVol(retPairInfo, pairVolInfo, pairVolInfo.getIndex());
                continue;
            }
            pairVolInfo.setLdevIndex(urPairInfo.getSVolLuPath().getSLdkc(), urPairInfo.getSVolLuPath().getSCu(), urPairInfo.getSVolLuPath().getSLdev());
            ivolPosInfo = volPosInf.getIVolPosBitMap(pairVolInfo.getIndex());
            pairVolInfo.setIPairVolPos(ivolPosInfo);
            if (!SJmoRemoteReplicationUtility.isURSVolPair(ivolPosInfo)) continue;
            if (SJmoRemoteReplicationUtility.isURPair(ivolPosInfo)) {
                urPairInfo.setIPairVolPos(4096);
            } else if (SJmoRemoteReplicationUtility.isURMFPair(ivolPosInfo)) {
                urPairInfo.setIPairVolPos(131072);
            }
            alURPairList.add(urPairInfo);
            pairVolInfo.setAlPVolIndex(alURPairList);
            urPairInfo.getAlSVolIndex().add(pairVolInfo);
            retPairInfo = SJmoRemoteReplicationUtility.setURPairVol(retPairInfo, pairVolInfo, pairVolInfo.getIndex());
        }
        return retPairInfo;
    }

    public static SJmoDataIndex_IF[] makeJnlGrp(ArrayList<RJiHURget1JNLG> rmiJnlGrpList) {
        SJmoDataIndex_IF[] retJnlGrp = new SJmoUniversalReplicatorJnlGrp[SJmoDataMacro_IF.NUM_MAX_RC_JNLG_ID + 1];
        if (rmiJnlGrpList == null) {
            throw SJmoUtility.getException(201, 23, 107000, "makeJnlGrp", "rmiJnlGrpList is null");
        }
        for (int iJnlGrpCnt = 0; iJnlGrpCnt < rmiJnlGrpList.size(); ++iJnlGrpCnt) {
            SJmoUniversalReplicatorJnlGrp jnlGrpdata = new SJmoUniversalReplicatorJnlGrp(rmiJnlGrpList.get(iJnlGrpCnt));
            retJnlGrp[jnlGrpdata.getIndex()] = jnlGrpdata;
        }
        return retJnlGrp;
    }

    public static ArrayList<SJmoUniversalReplicatorJnlGrpMirror> makeJnlGrpMirror(ArrayList<RJiHURgetJNLG1Mirror> rmiJnlGMirrorList) {
        ArrayList<SJmoUniversalReplicatorJnlGrpMirror> retMirrorList = new ArrayList<SJmoUniversalReplicatorJnlGrpMirror>();
        if (rmiJnlGMirrorList == null || rmiJnlGMirrorList.size() != 4) {
            throw SJmoUtility.getException(201, 23, 107000, "makeJnlGrpMirror", "rmiJnlGMirrorList is null or size Abnormalities");
        }
        for (int iCnt = 0; iCnt < rmiJnlGMirrorList.size(); ++iCnt) {
            SJmoUniversalReplicatorJnlGrpMirror jnlMirror = new SJmoUniversalReplicatorJnlGrpMirror(rmiJnlGMirrorList.get(iCnt));
            retMirrorList.add(jnlMirror);
        }
        return retMirrorList;
    }

    public static SJmoModelData_Base makeURSummary(RJiHURgetPairsInfo rmiPairInfoData) {
        if (rmiPairInfoData == null) {
            return new SJmoUniversalReplicatorSummary();
        }
        return new SJmoUniversalReplicatorSummary(rmiPairInfoData);
    }

    public static SJmoDataIndex_IF[] makeExCTGrp(HURgetECTGrps rmiCTGroup) {
        SJmoDataIndex_IF[] retExCTGroup = new SJmoUniversalReplicatorEXCTG[4];
        if (rmiCTGroup == null) {
            throw SJmoUtility.getException(201, 23, 107000, "makeExCTGrp", "rmiCTGroupList is null");
        }
        for (int ctgCnt = 0; ctgCnt < rmiCTGroup.ectgInfo.size(); ++ctgCnt) {
            SJmoUniversalReplicatorEXCTG exCTGdata = new SJmoUniversalReplicatorEXCTG((HURget1ECTGrp)rmiCTGroup.ectgInfo.get(ctgCnt));
            retExCTGroup[exCTGdata.getIndex()] = exCTGdata;
        }
        return retExCTGroup;
    }

    public static ArrayList<SJmoUniversalReplicatorEXCTGJnlGrp> makeExCTGJnlGrp(ArrayList<HURget1JNLGinECTG> rmiCTGJnlGList) {
        ArrayList<SJmoUniversalReplicatorEXCTGJnlGrp> retExCTGJnlList = new ArrayList<SJmoUniversalReplicatorEXCTGJnlGrp>();
        if (rmiCTGJnlGList == null) {
            throw SJmoUtility.getException(201, 23, 107000, "makeExCTGrp", "rmiCTGJnlGList is null");
        }
        for (int ctgCnt = 0; ctgCnt < rmiCTGJnlGList.size(); ++ctgCnt) {
            SJmoUniversalReplicatorEXCTGJnlGrp exCTGdata = new SJmoUniversalReplicatorEXCTGJnlGrp(rmiCTGJnlGList.get(ctgCnt));
            retExCTGJnlList.add(exCTGdata);
        }
        return retExCTGJnlList;
    }

    public static SJmoData_IF makeSystemOptionInfo(HURgetSystemOption rmiSystemOptionData) {
        SJmoUniversalReplicatorSystemOptionInfo retSysOption = null;
        if (rmiSystemOptionData == null) {
            throw SJmoUtility.getException(201, 23, 107000, "makeSystemOptionInfo", "rmiCTGroupList is null");
        }
        ArrayList reportSIMList = rmiSystemOptionData.getReportSIM();
        if (reportSIMList == null) {
            throw SJmoUtility.getException(201, 23, 107000, "makeSystemOptionInfo", "reportSIMList is null");
        }
        retSysOption = new SJmoUniversalReplicatorSystemOptionInfo(rmiSystemOptionData);
        return retSysOption;
    }

    public static boolean isURPVolPair(int iVolPosInfo) {
        return (iVolPosInfo & 0x1000) == 4096 || (iVolPosInfo & 0x20000) == 131072;
    }

    public static boolean isURSVolPair(int iVolPosInfo) {
        return (iVolPosInfo & 0x2000) == 8192 || (iVolPosInfo & 0x40000) == 262144;
    }

    public static boolean isURPair(int iVolPosInfo) {
        return (iVolPosInfo & 0x1000) == 4096 || (iVolPosInfo & 0x2000) == 8192;
    }

    public static boolean isURMFPair(int iVolPosInfo) {
        return (iVolPosInfo & 0x20000) == 131072 || (iVolPosInfo & 0x40000) == 262144;
    }

    public static SJmoDataIndex_IF[] setURPairVol(SJmoDataIndex_IF[] pairInfo, SJmoReplicationPairVolInfo setURPair, int iLdevIndex) {
        if (pairInfo[iLdevIndex] != null) {
            ArrayList<? extends SJmoLdevIndex> setList;
            SJmoReplicationPairVolInfo setPairInfo = (SJmoReplicationPairVolInfo)pairInfo[iLdevIndex];
            if (setURPair.getAlPVolIndex().size() != 0) {
                setList = setPairInfo.getAlPVolIndex();
                setList.add(setURPair.getAlPVolIndex().get(0));
                Collections.sort(setList);
                setPairInfo.setAlPVolIndex(setList);
            }
            if (setURPair.getAlSVolIndex().size() != 0) {
                setList = setPairInfo.getAlSVolIndex();
                setList.add(setURPair.getAlSVolIndex().get(0));
                Collections.sort(setList);
                setPairInfo.setAlSVolIndex(setList);
            }
        } else {
            pairInfo[iLdevIndex] = setURPair;
        }
        return pairInfo;
    }

    public static int iPairVolBitMap(int iBitMap) {
        int ret = 0;
        if (SJmoDataUtility.chkAllBitOn(1, iBitMap)) {
            ret |= 2;
        }
        if (SJmoDataUtility.chkAllBitOn(2, iBitMap)) {
            ret |= 1;
        }
        if (SJmoDataUtility.chkAllBitOn(32, iBitMap)) {
            ret |= 0x40;
        }
        if (SJmoDataUtility.chkAllBitOn(64, iBitMap)) {
            ret |= 0x20;
        }
        if (SJmoDataUtility.chkAllBitOn(1024, iBitMap)) {
            ret |= 0x800;
        }
        if (SJmoDataUtility.chkAllBitOn(2048, iBitMap)) {
            ret |= 0x400;
        }
        if (SJmoDataUtility.chkAllBitOn(0x4000000, iBitMap)) {
            ret |= 0x8000000;
        }
        if (SJmoDataUtility.chkAllBitOn(0x8000000, iBitMap)) {
            ret |= 0x4000000;
        }
        return ret;
    }

    public static RJiLDEVIndex[] getLdevArrangement(RJiLDEVIndex[] ldevIndex, int iStart, int iDemand) {
        RJiLDEVIndex[] retLdevIndex = null;
        if (ldevIndex != null && iStart >= 0 && iDemand > 0) {
            retLdevIndex = new RJiLDEVIndex[iDemand];
            for (int iCnt = 0; iCnt < iDemand; ++iCnt) {
                retLdevIndex[iCnt] = ldevIndex[iCnt + iStart];
            }
        } else {
            SJmoUtility.putLogDetail(SJmoRemoteReplicationUtility.class.getSimpleName(), "getLdevArrangement", "Argument is Abnormalities.");
        }
        return retLdevIndex;
    }

    public static boolean isPairVolInfo(ArrayList<? extends SJmoLdevIndex> alPairList, SJmoRemoteReplicationLuPath moLuPath, String strDeviceNumber, int iDevice) {
        boolean bRet = false;
        for (int cnt = 0; cnt < alPairList.size(); ++cnt) {
            if (!(alPairList.get(cnt) instanceof SJmoUniversalReplicatorPairVolInfo)) continue;
            SJmoUniversalReplicatorPairVolInfo pairInfo = (SJmoUniversalReplicatorPairVolInfo)alPairList.get(cnt);
            int iLuPathIdx = -1;
            iLuPathIdx = pairInfo.getPairKind() == 0 ? pairInfo.getSVolLuPath().getLuPath().getIndex() : pairInfo.getPVolLuPath().getLuPath().getIndex();
            if (moLuPath.getLuIndex() != iLuPathIdx || !strDeviceNumber.equals(pairInfo.getPairSN()) || iDevice != pairInfo.getModelId()) continue;
            bRet = true;
            break;
        }
        return bRet;
    }

    public static void replaceRemoteCopyPairVolinfo(SJmoReplicationPairVolInfo pairInfo, ArrayList<? extends SJmoLdevIndex> alPairVolList) {
        if (pairInfo == null || null == pairInfo.getAlPVolIndex() || null == pairInfo.getAlSVolIndex() || null == alPairVolList) {
            SJmoUtility.putLogDetail(SJmoRemoteReplicationUtility.class.getSimpleName(), "isRemoteCopyPairinfo", "Argument is Abnormalities.");
            return;
        }
        for (int icnt = 0; icnt < alPairVolList.size(); ++icnt) {
            int iPairVolcnt;
            SJmoLdevIndex ldix = alPairVolList.get(icnt);
            if (!(ldix instanceof SJmoTrueCopyPairVolInfo) && !(ldix instanceof SJmoUniversalReplicatorPairVolInfo)) continue;
            ArrayList<SJmoReplicationPairVolInfo> alPVolSetList = new ArrayList<SJmoReplicationPairVolInfo>();
            ArrayList<SJmoReplicationPairVolInfo> alSVolSetList = new ArrayList<SJmoReplicationPairVolInfo>();
            SJmoReplicationPairVolInfo alPairInfo = (SJmoReplicationPairVolInfo)ldix;
            ArrayList<? extends SJmoLdevIndex> alInsidePVolList = alPairInfo.getAlPVolIndex();
            ArrayList<? extends SJmoLdevIndex> alInsideSVolList = alPairInfo.getAlSVolIndex();
            for (iPairVolcnt = 0; iPairVolcnt < alInsidePVolList.size(); ++iPairVolcnt) {
                alPVolSetList.add(pairInfo);
            }
            for (iPairVolcnt = 0; iPairVolcnt < alInsideSVolList.size(); ++iPairVolcnt) {
                alSVolSetList.add(pairInfo);
            }
            alPairInfo.setAlPVolIndex(alPVolSetList);
            alPairInfo.setAlSVolIndex(alSVolSetList);
        }
    }

    public static SJmoDataIndex_IF[] makeHAPairVolInfoList(RJiHAget1PairSummary[] rmi1PairSummaryList, SJmoReplicationPairVolPosInfo volPosInfo) {
        SJmoDataIndex_IF[] retList = new SJmoReplicationPairVolInfo[SJmoDataMacro_IF.MAX_EQIP_LDEV_LDKC];
        for (int iCnt = 0; iCnt < rmi1PairSummaryList.length; ++iCnt) {
            if (null == rmi1PairSummaryList[iCnt] || rmi1PairSummaryList[iCnt].getPairStatus() == 0) continue;
            SJmoReplicationPairVolInfo pairVol = new SJmoReplicationPairVolInfo();
            pairVol.setSLdkc((short)(rmi1PairSummaryList[iCnt].getLDEV() >> 16 & 0xFF));
            pairVol.setSCu((short)(rmi1PairSummaryList[iCnt].getLDEV() >> 8 & 0xFF));
            pairVol.setSLdev((short)(rmi1PairSummaryList[iCnt].getLDEV() & 0xFF));
            SJmoHAPairVolInfo haPairVol = new SJmoHAPairVolInfo(rmi1PairSummaryList[iCnt]);
            int iVolPosBitMap = volPosInfo.getIVolPosBitMap(pairVol);
            int iPairVolPosBitMap = SJmoRemoteReplicationUtility.iPairVolBitMap(iVolPosBitMap);
            pairVol.setIPairVolPos(iVolPosBitMap);
            haPairVol.setIPairVolPos(iPairVolPosBitMap);
            if (SJmoDataUtility.chkAllBitOn(1024, iVolPosBitMap) || SJmoDataUtility.chkAllBitOn(0x4000000, iVolPosBitMap)) {
                pairVol.getAlSVolIndex().add(haPairVol);
                haPairVol.setPVolIndex(pairVol);
            } else if (SJmoDataUtility.chkAllBitOn(2048, iVolPosBitMap) || SJmoDataUtility.chkAllBitOn(0x8000000, iVolPosBitMap)) {
                pairVol.setPVolIndex(haPairVol);
                haPairVol.getAlSVolIndex().add(pairVol);
            }
            retList[pairVol.getIndex()] = pairVol;
        }
        return retList;
    }

    public static ArrayList<SJmoQuorumDiskInfo> makeQuorumDiskInfoList(RMCPgetAllLockID rmiAllQuorum) {
        ArrayList<SJmoQuorumDiskInfo> retQuorumDiskInfo = new ArrayList<SJmoQuorumDiskInfo>(128);
        ArrayList rmiQuorumList = rmiAllQuorum.lockIDInfoArray;
        for (RMCPget1LockID rmiQuorum : rmiQuorumList) {
            if (null == rmiQuorum) continue;
            SJmoQuorumDiskInfo quorumDiskInfo = new SJmoQuorumDiskInfo(rmiQuorum);
            retQuorumDiskInfo.add(quorumDiskInfo);
        }
        Collections.sort(retQuorumDiskInfo);
        retQuorumDiskInfo.trimToSize();
        return retQuorumDiskInfo;
    }
}

