/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.model.data.util;

import com.hitachi.sanproject.data.SanDataException;
import com.hitachi.sanproject.data.SanList;
import com.hitachi.sanproject.data.SanObject;
import com.hitachi.sanproject.rmi.SanResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import sanproject.serverux.data.PairStatusCU;
import sanproject.serverux.data.PairStatusLdev;
import sanproject.serverux.dataimpl.MRCFctgDetail;
import sanproject.serverux.dataimpl.MRCFgetPairInfEx;
import sanproject.serverux.dataimpl.MRCFgetPairLdev;
import sanproject.serverux.dataimpl.MRCFgetSnapshotSetName;
import sanproject.serverux.dataimpl.MRCFgetTiSnapshotPair;
import sanproject.serverux.dataimpl.RMCPCUofCUOption;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.model.SJmoException;
import sanproject.sn2.model.SJmoUtility;
import sanproject.sn2.model.data.replication.SJmoReplicationPairVolInfo;
import sanproject.sn2.model.data.replication.SJmoReplicationPairVolPosInfo;
import sanproject.sn2.model.data.replication.local.SJmoLocalReplicationConsistencyGroupInfo;
import sanproject.sn2.model.data.replication.local.SJmoLocalReplicationPairVolInfo;
import sanproject.sn2.model.data.replication.local.SJmoSnapshotSetInfo;
import sanproject.sn2.model.data.replication.local.SJmoTiPvolInfo;
import sanproject.sn2.model.data.replication.local.SJmoTiPvolStatus;
import sanproject.sn2.model.data.replication.local.SJmoTiSnapshotPair;
import sanproject.sn2.model.data.replication.remote.SJmoRemoteReplicationCuOptionInfo;
import sanproject.sn2.model.data.util.SJmoDataUtility;
import sanproject.sn2.model.data.util.SJmoLdevUtility;
import sanproject.sn2.model.data.util.SJmoRemoteReplicationUtility;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;
import sanproject.sn2.model.inf.SJmoDataMacro_IF;
import sanproject.sn2.model.inf.SJmoKeyValueDefine_IF;

public class SJmoReplicationUtility
implements SJmoKeyValueDefine_IF {
    public static HashMap<String, ?> makeLocalReplicationPairVolInfo(MRCFgetPairLdev[] rmiSiPairInfo, SanResponse tiPairsRes, SJmoTiPvolStatus tiPvolStatus) {
        SJmoLocalReplicationPairVolInfo[] pVolInfoList = new SJmoLocalReplicationPairVolInfo[SJmoDataMacro_IF.MAX_EQIP_LDEV_LDKC];
        ArrayList[] sVolInfoList = new ArrayList[SJmoDataMacro_IF.MAX_EQIP_LDEV_LDKC];
        HashMap<String, Object> pairVolInfoMap = new HashMap<String, Object>();
        ArrayList<SanObject> alNonPairInf = new ArrayList<SanObject>();
        if (tiPairsRes != null && tiPvolStatus != null) {
            try {
                SanList svolList = tiPairsRes.getList("SecondaryVolumes");
                for (SanObject svol : svolList) {
                    SJmoTiPvolInfo rootLdevInfo;
                    if (svol.getMember("TiPair") == null) {
                        alNonPairInf.add(svol);
                        continue;
                    }
                    SanObject tipair = svol.getObj("TiPair");
                    SJmoLocalReplicationPairVolInfo[] retList = SJmoReplicationUtility.makeModelObjctTiPair(tipair, rootLdevInfo = SJmoReplicationUtility.getTiRootLdevInfo(tipair, tiPvolStatus));
                    if (null != pVolInfoList[retList[0].getIndex()]) {
                        pVolInfoList[retList[0].getIndex()].setQsPVolData(retList[0]);
                    } else {
                        pVolInfoList[retList[0].getIndex()] = retList[0];
                    }
                    if (null != sVolInfoList[retList[1].getPVolIndex().getIndex()]) {
                        sVolInfoList[retList[1].getPVolIndex().getIndex()].add(retList[1]);
                        continue;
                    }
                    ArrayList<SJmoLocalReplicationPairVolInfo> alQsSVolList = new ArrayList<SJmoLocalReplicationPairVolInfo>();
                    alQsSVolList.add(retList[1]);
                    sVolInfoList[retList[1].getPVolIndex().getIndex()] = alQsSVolList;
                }
            }
            catch (SanDataException e) {
                SJctrLogUty.error("SJmoReplicationUtility", "getMessageId", e.getMessage());
                throw SJmoUtility.getException(201, 23, 107002, SJmoReplicationUtility.class.getSimpleName(), "makeLocalReplicationPairVolInfo");
            }
        }
        for (int iSiCnt = 0; iSiCnt < rmiSiPairInfo.length; ++iSiCnt) {
            SJmoLocalReplicationPairVolInfo pVolInfo = (SJmoLocalReplicationPairVolInfo)SJmoDataUtility.makeModelObject(rmiSiPairInfo[iSiCnt]);
            if (null != pVolInfoList[pVolInfo.getIndex()]) {
                pVolInfoList[pVolInfo.getIndex()].setSiPVolData(pVolInfo);
            } else {
                pVolInfoList[pVolInfo.getIndex()] = pVolInfo;
            }
            ArrayList<? extends SJmoLocalReplicationPairVolInfo> alSiSVolList = SJmoReplicationUtility.makeAlSiSVolInfo(rmiSiPairInfo[iSiCnt]);
            if (null != sVolInfoList[pVolInfo.getIndex()]) {
                sVolInfoList[pVolInfo.getIndex()].addAll(alSiSVolList);
                continue;
            }
            sVolInfoList[pVolInfo.getIndex()] = alSiSVolList;
        }
        pairVolInfoMap.put("STR_PVOL_LIST", pVolInfoList);
        pairVolInfoMap.put("STR_SVOL_LIST", sVolInfoList);
        pairVolInfoMap.put("STR_NONPAIR_LIST", alNonPairInf);
        return pairVolInfoMap;
    }

    public static SJmoTiPvolInfo getTiRootLdevInfo(SanObject tipair, SJmoTiPvolStatus tiPvolStatus) throws SanDataException {
        Object rtnRootInfo = null;
        Object[] tiPVolArray = tiPvolStatus.getTiPvolInfo();
        if (tipair == null || tiPvolStatus == null) {
            throw SJmoUtility.getException(201, 23, 107002, SJmoReplicationUtility.class.getSimpleName(), "getSanObjTiRootLdev");
        }
        int[] iPairRoot = tipair.getObj("RootLdev").getIntArray("Id");
        SJmoLdevIndex ldev = new SJmoLdevIndex();
        ldev.setLdevIndex((short)iPairRoot[0], (short)iPairRoot[1], (short)iPairRoot[2]);
        int index = Arrays.binarySearch(tiPVolArray, ldev);
        if (index >= 0) {
            rtnRootInfo = tiPVolArray[index];
        }
        return rtnRootInfo;
    }

    public static SJmoLocalReplicationPairVolInfo[] makeModelObjctTiPair(SanObject pairInfo, SJmoTiPvolInfo rootLdevInfo) {
        SJmoLocalReplicationPairVolInfo[] snapShotPairVolList = new SJmoLocalReplicationPairVolInfo[]{new SJmoLocalReplicationPairVolInfo(pairInfo, rootLdevInfo, true, false), new SJmoLocalReplicationPairVolInfo(pairInfo, rootLdevInfo, false, true)};
        return snapShotPairVolList;
    }

    public static ArrayList<? extends SJmoLocalReplicationPairVolInfo> makeAlSiSVolInfo(MRCFgetPairLdev siPairLdev) {
        ArrayList<SJmoLocalReplicationPairVolInfo> alPairVol = new ArrayList<SJmoLocalReplicationPairVolInfo>();
        if (null == siPairLdev || null == siPairLdev.getAlPairInf()) {
            SJmoUtility.putLogDetail(SJmoReplicationUtility.class.getSimpleName(), "makeAlSiSVolInfo", "siPairLdev is null");
            return alPairVol;
        }
        SJmoLdevIndex ldIdx = new SJmoLdevIndex();
        ldIdx.setLdevIndex(siPairLdev.getSLDKC(), siPairLdev.getSCU(), siPairLdev.getSLDEV());
        ArrayList alRmilSiSVolList = siPairLdev.getAlPairInf();
        for (int iSVolCnt = 0; iSVolCnt < alRmilSiSVolList.size(); ++iSVolCnt) {
            if (null != alRmilSiSVolList.get(iSVolCnt)) {
                MRCFgetPairInfEx pairInf = (MRCFgetPairInfEx)alRmilSiSVolList.get(iSVolCnt);
                if (pairInf.getKind() == 2) continue;
                SJmoLocalReplicationPairVolInfo modelPairInf = (SJmoLocalReplicationPairVolInfo)SJmoDataUtility.makeModelObject(pairInf);
                modelPairInf.setPVolIndex(ldIdx);
                alPairVol.add(modelPairInf);
                continue;
            }
            SJmoUtility.putLogDetail(SJmoReplicationUtility.class.getSimpleName(), "makeAlSiSVolInfo", "alRmilSiSVolList.get(" + iSVolCnt + ") == null");
        }
        return alPairVol;
    }

    public static SJmoLocalReplicationPairVolInfo[] setLocalReplicationSVolInfo(ArrayList<SJmoLocalReplicationPairVolInfo> alPairInfo, SJmoLocalReplicationPairVolInfo[] srcList) throws SJmoException {
        if (null == alPairInfo || null == srcList) {
            throw SJmoUtility.getException(201, 23, 107002, SJmoReplicationUtility.class.getSimpleName(), "setLocalReplicationSVolInfo");
        }
        for (int iCnt = 0; iCnt < alPairInfo.size(); ++iCnt) {
            if (null != alPairInfo.get(iCnt)) {
                SJmoLocalReplicationPairVolInfo modelPairInfo = alPairInfo.get(iCnt);
                if (null == srcList[modelPairInfo.getIndex()]) {
                    srcList[modelPairInfo.getIndex()] = modelPairInfo;
                    continue;
                }
                srcList[modelPairInfo.getIndex()].setSVolData(modelPairInfo);
                continue;
            }
            SJmoUtility.putLogDetail("SJmoReplicationUtility", "setLocalReplicationSVolInfo", "PairInfo = null. List Count = [" + iCnt + "]");
        }
        return srcList;
    }

    public static int[] makeVolPosBitMap(PairStatusCU[] rmiPairVolPos) {
        int[] iBitMapList = new int[SJmoDataMacro_IF.MAX_EQIP_LDEV_LDKC];
        for (int iCuCnt = 0; iCuCnt < rmiPairVolPos.length; ++iCuCnt) {
            if (null != rmiPairVolPos[iCuCnt]) {
                PairStatusLdev[] ldevList = (PairStatusLdev[])rmiPairVolPos[iCuCnt].get_LdevInformation();
                if (null != ldevList) {
                    for (int iLdevCnt = 0; iLdevCnt < ldevList.length; ++iLdevCnt) {
                        if (null != ldevList[iLdevCnt]) {
                            int iLdevIndex = SJmoLdevUtility.getLdevIndex((short)0, (short)iCuCnt, (short)iLdevCnt);
                            iBitMapList[iLdevIndex] = ldevList[iLdevCnt].getIPairStatus();
                            continue;
                        }
                        SJmoUtility.putLogDetail(SJmoReplicationUtility.class.getSimpleName(), "makeVolPosBitMap", "iCuCnt = " + iCuCnt + " ldevList[" + iLdevCnt + "] == null");
                    }
                    continue;
                }
                SJmoUtility.putLogDetail(SJmoReplicationUtility.class.getSimpleName(), "makeVolPosBitMap", "ldevList == null iCuCnt = " + iCuCnt);
                continue;
            }
            SJmoUtility.putLogDetail(SJmoReplicationUtility.class.getSimpleName(), "makeVolPosBitMap", "rmiPairVolPos[" + iCuCnt + "] == null");
        }
        return iBitMapList;
    }

    public static SJmoLocalReplicationConsistencyGroupInfo[] makeCtgDetailList(MRCFctgDetail[] rmiCtgDtlList) {
        SJmoLocalReplicationConsistencyGroupInfo[] retCtgDtlList = new SJmoLocalReplicationConsistencyGroupInfo[rmiCtgDtlList.length];
        for (int iCtgCnt = 0; iCtgCnt < rmiCtgDtlList.length; ++iCtgCnt) {
            if (null != rmiCtgDtlList[iCtgCnt]) {
                SJmoLocalReplicationConsistencyGroupInfo ctgInf;
                retCtgDtlList[ctgInf.getIndex()] = ctgInf = new SJmoLocalReplicationConsistencyGroupInfo(rmiCtgDtlList[iCtgCnt]);
                continue;
            }
            SJmoUtility.putLogDetail(SJmoReplicationUtility.class.getSimpleName(), "makeCtgDetailList", "rmiCtgDtlList[" + iCtgCnt + "] == null");
        }
        return retCtgDtlList;
    }

    public static SJmoTiPvolInfo[] makeTiPVolInfoList(SanResponse tiRootLdevRes) {
        ArrayList<SJmoTiPvolInfo> alTiPvolInfo = new ArrayList<SJmoTiPvolInfo>();
        if (tiRootLdevRes != null) {
            try {
                SanList rootLdevList = tiRootLdevRes.getList("RootLdevs");
                for (SanObject rootLdevObj : rootLdevList) {
                    if (rootLdevObj.getMember("RootLdevInfo") == null) continue;
                    SanObject rootLdevInfo = rootLdevObj.getObj("RootLdevInfo");
                    alTiPvolInfo.add(SJmoReplicationUtility.makeSJmoTiPvolInfo(rootLdevInfo, rootLdevObj.getIntArray("Id")));
                }
            }
            catch (SanDataException e) {
                SJmoUtility.putLog("makeTiPVolInfoList:SanDataExcepiton" + e.getMessage());
                throw SJmoUtility.getException(201, 23, 107002, "SJmoReplicationUtility", "makeTiPVolInfoList");
            }
        }
        SJmoTiPvolInfo[] retTiPvolInfo = new SJmoTiPvolInfo[alTiPvolInfo.size()];
        for (int iLpCnt = 0; iLpCnt < alTiPvolInfo.size(); ++iLpCnt) {
            retTiPvolInfo[iLpCnt] = (SJmoTiPvolInfo)alTiPvolInfo.get(iLpCnt);
        }
        return retTiPvolInfo;
    }

    public static SJmoTiPvolInfo makeSJmoTiPvolInfo(SanObject rootLdevInfo, int[] rootLdevId) throws SanDataException {
        SJmoTiPvolInfo info = new SJmoTiPvolInfo();
        if (rootLdevInfo == null || rootLdevId == null) {
            SJmoUtility.putLog("makeSJmoTiPvolInfo:rootLdevInfo or rootLdevId is null.");
            throw SJmoUtility.getException(201, 23, 107002, "SJmoReplicationUtility", "ERR_MSG_PARAM");
        }
        info.setPairnum(rootLdevInfo.getInt("PairNum"));
        info.setPsuenum(rootLdevInfo.getInt("SuspendErrorPairNum"));
        info.setBCascade(rootLdevInfo.getBoolean("Cascade"));
        SanObject objPool = rootLdevInfo.getObj("Pool");
        info.setPoolid(objPool.getInt("Id"));
        info.setPoolslt(objPool.getLong("UsedCapacity"));
        info.setSLdkc((short)rootLdevId[0]);
        info.setSCu((short)rootLdevId[1]);
        info.setSLdev((short)rootLdevId[2]);
        return info;
    }

    public static SJmoTiSnapshotPair[] makeTiSnapshotInfoList(MRCFgetTiSnapshotPair[] rmiTiSnapshotPair) {
        ArrayList<SJmoTiSnapshotPair> alTiSnapshotPair = new ArrayList<SJmoTiSnapshotPair>();
        for (int iCnt = 0; iCnt < rmiTiSnapshotPair.length; ++iCnt) {
            if (null != rmiTiSnapshotPair[iCnt]) {
                alTiSnapshotPair.add(new SJmoTiSnapshotPair(rmiTiSnapshotPair[iCnt]));
                continue;
            }
            SJmoUtility.putLogDetail(SJmoRemoteReplicationUtility.class.getSimpleName(), "makeTiSnapshotInfoList", "rmiTiSnapshotPair[" + iCnt + "] is null");
        }
        SJmoTiSnapshotPair[] retTiSnapshotPair = new SJmoTiSnapshotPair[alTiSnapshotPair.size()];
        for (int iLpCnt = 0; iLpCnt < alTiSnapshotPair.size(); ++iLpCnt) {
            retTiSnapshotPair[iLpCnt] = (SJmoTiSnapshotPair)alTiSnapshotPair.get(iLpCnt);
        }
        return retTiSnapshotPair;
    }

    public static SJmoRemoteReplicationCuOptionInfo[] makeCuOptionList(RMCPCUofCUOption[] rmiCuOptList) {
        SJmoRemoteReplicationCuOptionInfo[] retCuOptList = new SJmoRemoteReplicationCuOptionInfo[SJmoDataMacro_IF.CUMAX_LDKC];
        for (int iCuCnt = 0; iCuCnt < rmiCuOptList.length; ++iCuCnt) {
            if (iCuCnt >= retCuOptList.length) continue;
            if (null != rmiCuOptList[iCuCnt]) {
                SJmoRemoteReplicationCuOptionInfo cuOptInf;
                retCuOptList[iCuCnt] = cuOptInf = new SJmoRemoteReplicationCuOptionInfo(rmiCuOptList[iCuCnt], (short)iCuCnt);
                continue;
            }
            SJmoUtility.putLogDetail(SJmoReplicationUtility.class.getSimpleName(), "makeCuOptionList", "rmiCuOptList[" + iCuCnt + "] == null");
        }
        return retCuOptList;
    }

    public static boolean isValidLocalReplicationCtgId(int iCtgId) {
        boolean bRet = false;
        if (iCtgId >= 0 && iCtgId <= 2047) {
            bRet = true;
        }
        return bRet;
    }

    public static boolean isLocalReplicaPVol(SJmoReplicationPairVolInfo pairVolInfo) {
        boolean bRet = false;
        if (pairVolInfo.isVolPos(4)) {
            bRet = true;
        } else if (pairVolInfo.isVolPos(128)) {
            bRet = true;
        } else if (pairVolInfo.isVolPos(0x400000)) {
            bRet = true;
        }
        return bRet;
    }

    public static boolean isLocalReplicaSVol(SJmoReplicationPairVolInfo pairVolInfo) {
        boolean bRet = false;
        if (pairVolInfo.isVolPos(8)) {
            bRet = true;
        } else if (pairVolInfo.isVolPos(256)) {
            bRet = true;
        } else if (pairVolInfo.isVolPos(0x800000)) {
            bRet = true;
        }
        return bRet;
    }

    public static SJmoLocalReplicationPairVolInfo[] renewLocalReplicaPairInf(SJmoLocalReplicationPairVolInfo[] localPairInfList, SJmoReplicationPairVolPosInfo volPosInfo) {
        for (int iPairVolCnt = 0; iPairVolCnt < localPairInfList.length; ++iPairVolCnt) {
            if (null == localPairInfList[iPairVolCnt]) continue;
            localPairInfList[iPairVolCnt].setIPairVolPos(volPosInfo.getIVolPosBitMap(iPairVolCnt));
            if (!SJmoReplicationUtility.isLocalReplicaSVol(localPairInfList[iPairVolCnt])) {
                localPairInfList[iPairVolCnt].setPVolIndex(null);
            }
            if (!SJmoReplicationUtility.isLocalReplicaPVol(localPairInfList[iPairVolCnt])) {
                localPairInfList[iPairVolCnt].getAlSVolIndex().clear();
            }
            localPairInfList[iPairVolCnt].allFlgOff();
        }
        return localPairInfList;
    }

    public static SJmoLocalReplicationPairVolInfo getRenewLocalReplicaPVolInfo(SJmoLocalReplicationPairVolInfo pairInf, SJmoLocalReplicationPairVolInfo[] renewPairInfList, SJmoReplicationPairVolPosInfo volPosInfo) throws SJmoException {
        SJmoLocalReplicationPairVolInfo renewPairVolInfo = null;
        if (null == pairInf || null == renewPairInfList || null == volPosInfo) {
            throw SJmoUtility.getException(201, 23, 107002, SJmoReplicationUtility.class.getSimpleName(), "getRenewLocalReplicaPVolInfo param null");
        }
        if (null == renewPairInfList[pairInf.getIndex()]) {
            throw SJmoUtility.getException(201, 23, 107002, SJmoReplicationUtility.class.getSimpleName(), "getRenewLocalReplicaPVolInfo InValid Data");
        }
        ArrayList<? extends SJmoLdevIndex> modAlSvolIdx = new ArrayList<SJmoLdevIndex>();
        ArrayList<? extends SJmoLdevIndex> alSVolIdx = pairInf.getAlSVolIndex();
        modAlSvolIdx.addAll(renewPairInfList[pairInf.getIndex()].getAlSVolIndex());
        for (int iListCnt = 0; iListCnt < alSVolIdx.size(); ++iListCnt) {
            SJmoLdevIndex chkLdevIdx = alSVolIdx.get(iListCnt);
            int iPoint = Collections.binarySearch(renewPairInfList[pairInf.getIndex()].getAlSVolIndex(), chkLdevIdx);
            if (iPoint >= 0 || !SJmoDataUtility.chkAllBitOn(0x800000, volPosInfo.getIVolPosBitMap(chkLdevIdx.getIndex())) || SJmoReplicationUtility.sVolExist(chkLdevIdx, renewPairInfList)) continue;
            modAlSvolIdx.add(chkLdevIdx);
        }
        Collections.sort(modAlSvolIdx);
        try {
            renewPairVolInfo = (SJmoLocalReplicationPairVolInfo)renewPairInfList[pairInf.getIndex()].clone();
        }
        catch (Exception e) {
            e.printStackTrace();
            SJmoUtility.putLogDetail("SJmoReplicationUtility", "getRenewLocalReplicaPVolInfo", "pairInf clone failed." + e.toString());
            throw SJmoUtility.getException(201, 23, 107003, "getRenewLocalReplicaPVolInfo", "pairInf clone failed. " + e.toString());
        }
        renewPairVolInfo.setAlSVolIndex(modAlSvolIdx);
        return renewPairVolInfo;
    }

    public static SJmoLocalReplicationPairVolInfo modSVolIndex(SJmoLocalReplicationPairVolInfo pairInf, SJmoLocalReplicationPairVolInfo[] renewPairInfList, SJmoReplicationPairVolPosInfo volPosInfo) throws SJmoException {
        if (null == pairInf || null == renewPairInfList || null == volPosInfo) {
            throw SJmoUtility.getException(201, 23, 107002, SJmoReplicationUtility.class.getSimpleName(), "modSVolIndex param null");
        }
        ArrayList<SJmoLdevIndex> alRet = new ArrayList<SJmoLdevIndex>();
        ArrayList<? extends SJmoLdevIndex> alSrc = pairInf.getAlSVolIndex();
        for (int iSVolCnt = 0; iSVolCnt < alSrc.size(); ++iSVolCnt) {
            SJmoLdevIndex ldevIdx = alSrc.get(iSVolCnt);
            SJmoReplicationPairVolInfo chkPairVolInfo = new SJmoReplicationPairVolInfo();
            chkPairVolInfo.setIPairVolPos(volPosInfo.getIVolPosBitMap(ldevIdx.getIndex()));
            if (!SJmoReplicationUtility.isLocalReplicaSVol(chkPairVolInfo) || SJmoReplicationUtility.sVolExist(ldevIdx, renewPairInfList)) continue;
            alRet.add(ldevIdx);
        }
        pairInf.setAlSVolIndex(alRet);
        return pairInf;
    }

    public static boolean sVolExist(SJmoLdevIndex sVolIndex, SJmoLocalReplicationPairVolInfo[] checkList) throws SJmoException {
        boolean bExist = false;
        if (null == sVolIndex || null == checkList) {
            throw SJmoUtility.getException(201, 23, 107002, SJmoReplicationUtility.class.getSimpleName(), "sVolExist param null");
        }
        for (int iListCnt = 0; iListCnt < checkList.length; ++iListCnt) {
            int iPoint;
            if (null == checkList[iListCnt] || (iPoint = Collections.binarySearch(checkList[iListCnt].getAlSVolIndex(), sVolIndex)) < 0) continue;
            bExist = true;
            break;
        }
        return bExist;
    }

    public static boolean isValidSnapshotSetId(int iChkSnapshotSetId) {
        boolean bRet = false;
        if (iChkSnapshotSetId >= 0 && iChkSnapshotSetId <= 2047) {
            bRet = true;
        }
        return bRet;
    }

    public static SJmoSnapshotSetInfo[] makeSnapshotSetNameInfoList(MRCFgetSnapshotSetName[] rmiSnapshotSetNameList) {
        SJmoSnapshotSetInfo[] retSnapshotSetList = new SJmoSnapshotSetInfo[2048];
        for (int iCnt = 0; iCnt < rmiSnapshotSetNameList.length; ++iCnt) {
            if (null != rmiSnapshotSetNameList[iCnt]) {
                SJmoSnapshotSetInfo snapshotSetInf;
                retSnapshotSetList[snapshotSetInf.getIndex()] = snapshotSetInf = new SJmoSnapshotSetInfo(rmiSnapshotSetNameList[iCnt]);
                continue;
            }
            SJmoUtility.putLogDetail(SJmoReplicationUtility.class.getSimpleName(), "makeSnapshotSetNameInfoList", "rmiSnapshotSetNameList[" + iCnt + "] == null");
        }
        return retSnapshotSetList;
    }

    public static SJmoLocalReplicationPairVolInfo[] delNonPairInfo(SJmoLocalReplicationPairVolInfo[] renewPairInfoList, ArrayList<SanObject> alNonPair) throws SanDataException {
        for (int iCnt = 0; iCnt < alNonPair.size(); ++iCnt) {
            int iDelPoint;
            SJmoLocalReplicationPairVolInfo pVolInfo;
            SJmoLocalReplicationPairVolInfo nonPairInf;
            SJmoLdevIndex pVolIndex;
            SanObject sanObjSLdev = alNonPair.get(iCnt).getObj("Ldev");
            int[] iSvolId = sanObjSLdev.getIntArray("Id");
            int iLdevId = SJmoLdevUtility.getLdevIndex((short)iSvolId[0], (short)iSvolId[1], (short)iSvolId[2]);
            if (null == renewPairInfoList[iLdevId] || null == (pVolIndex = (nonPairInf = renewPairInfoList[iLdevId]).getPVolIndex()) || !pVolIndex.isValidIndex() || null == (pVolInfo = renewPairInfoList[pVolIndex.getIndex()]) || (iDelPoint = Collections.binarySearch(pVolInfo.getAlSVolIndex(), nonPairInf)) < 0) continue;
            pVolInfo.getAlSVolIndex().remove(iDelPoint);
            if (!pVolInfo.getAlSVolIndex().isEmpty() || null != pVolInfo.getPVolIndex() || pVolInfo.isVolPos(0x1000000) || pVolInfo.isVolPos(0x2000000)) continue;
            renewPairInfoList[pVolIndex.getIndex()] = null;
        }
        renewPairInfoList = SJmoReplicationUtility.qsPVolDataInvalid(renewPairInfoList);
        return renewPairInfoList;
    }

    public static SJmoLocalReplicationPairVolInfo[] qsPVolDataInvalid(SJmoLocalReplicationPairVolInfo[] renewPairInfoList) {
        SJmoLocalReplicationPairVolInfo qsPVolInValidData = new SJmoLocalReplicationPairVolInfo(0);
        qsPVolInValidData.setLPVolUsedPool(-1L);
        qsPVolInValidData.setISnapshotInfo(-1);
        for (int iCnt = 0; iCnt < renewPairInfoList.length; ++iCnt) {
            if (null == renewPairInfoList[iCnt] || !renewPairInfoList[iCnt].isVolPos(0x400000) || SJmoReplicationUtility.qsSVolExist(renewPairInfoList[iCnt], renewPairInfoList)) continue;
            renewPairInfoList[iCnt].setQsPVolData(qsPVolInValidData);
            renewPairInfoList[iCnt].allFlgOff();
        }
        return renewPairInfoList;
    }

    public static boolean qsSVolExist(SJmoLocalReplicationPairVolInfo chkPVolInfo, SJmoLocalReplicationPairVolInfo[] pairInfoList) {
        boolean bRet = false;
        ArrayList<? extends SJmoLdevIndex> alSVolInfo = chkPVolInfo.getAlSVolIndex();
        for (int iCnt = 0; iCnt < alSVolInfo.size(); ++iCnt) {
            SJmoLdevIndex ldevIdx = alSVolInfo.get(iCnt);
            if (null == pairInfoList[ldevIdx.getIndex()] || !pairInfoList[ldevIdx.getIndex()].isVolPos(0x800000)) continue;
            bRet = true;
            break;
        }
        return bRet;
    }

    public static void renewPvolInfo(SJmoLocalReplicationPairVolInfo chkPVolInfo, SJmoLocalReplicationPairVolInfo[] pairInfoList) {
        ArrayList<? extends SJmoLdevIndex> alSVolInfo = chkPVolInfo.getAlSVolIndex();
        for (int iCnt = 0; iCnt < chkPVolInfo.getAlSVolIndex().size(); ++iCnt) {
            int iIndex;
            SJmoLdevIndex ldevIdx = chkPVolInfo.getAlSVolIndex().get(iCnt);
            if (null != pairInfoList[ldevIdx.getIndex()] || (iIndex = Collections.binarySearch(alSVolInfo, ldevIdx)) < 0) continue;
            alSVolInfo.remove(iIndex);
        }
        chkPVolInfo.setAlSVolIndex(alSVolInfo);
    }

    public static void checkKeyValueErrorInfo(SanResponse res) {
        block5: {
            try {
                if (res == null) {
                    SJmoUtility.putLogDetail("SJmoLocalReplicationPairUpdate", "checkErrorInfo", "SanResponse is null");
                    throw SJmoUtility.getException(201, 23, 107002, SJmoReplicationUtility.class.getSimpleName(), "checkKeyValueErrorInfo");
                }
                SanObject errInfo = res.getObj("ErrorInfo");
                int[] msgIdList = errInfo.getIntArray("MessageId");
                if (msgIdList != null && msgIdList.length == 2) {
                    int funcModCode = msgIdList[0];
                    int errorCode = msgIdList[1];
                    if (errorCode != 0) {
                        SJmoUtility.putLogDetail("SJmoReplicationUtility", "checkKeyValueErrorInfo", "errorCode is invalid");
                        throw SJmoUtility.getException(funcModCode / 100, funcModCode % 100, errorCode, SJmoReplicationUtility.class.getSimpleName(), "checkKeyValueErrorInfo");
                    }
                    break block5;
                }
                SJmoUtility.putLogDetail("SJmoReplicationUtility", "checkKeyValueErrorInfo", "msgIdList is null or msgIdList length is invalid");
                throw SJmoUtility.getException(201, 23, 107002, SJmoReplicationUtility.class.getSimpleName(), "checkKeyValueErrorInfo");
            }
            catch (SanDataException e) {
                SJmoUtility.putLogDetail("SJmoReplicationUtility", "checkKeyValueErrorInfo", "SanDataException is occured");
                throw SJmoUtility.getException(201, 23, 107002, SJmoReplicationUtility.class.getSimpleName(), "checkKeyValueErrorInfo");
            }
        }
    }
}

