/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.model.data.volume;

import sanproject.serverux.dataimpl.RJiSSIDInfo;
import sanproject.sn2.model.SJmoException;
import sanproject.sn2.model.SJmoUtility;
import sanproject.sn2.model.data.SJmoModelData_Base;
import sanproject.sn2.model.data.inf.SJmoData_IF;
import sanproject.sn2.model.inf.SJmoDataMacro_IF;

public class SJmoSsidDetail
extends SJmoModelData_Base
implements SJmoData_IF {
    static final long serialVersionUID = -8360832606092876453L;
    private int iSSID = -1;
    private short sLdkc = (short)-1;
    private short sCU = (short)-1;
    private short sStartLDEV = (short)-1;
    private short sEndLDEV = (short)-1;
    private String strSsidKey = "";

    public int getSSID() {
        return this.iSSID;
    }

    public void setSSID(int issid) {
        this.iSSID = issid;
    }

    public short getLDKC() {
        return this.sLdkc;
    }

    public void setLDKC(short ldkc) {
        this.sLdkc = ldkc;
    }

    public short getCU() {
        return this.sCU;
    }

    public void setCU(short scu) {
        this.sCU = scu;
    }

    public short getStartLDEV() {
        return this.sStartLDEV;
    }

    public void setStartLDEV(short startLDEV) {
        this.sStartLDEV = startLDEV;
    }

    public short getEndLDEV() {
        return this.sEndLDEV;
    }

    public void setEndLDEV(short endLDEV) {
        this.sEndLDEV = endLDEV;
    }

    public SJmoSsidDetail() {
    }

    public SJmoSsidDetail(RJiSSIDInfo rmiData) throws SJmoException {
        if (null == rmiData) {
            throw SJmoUtility.getException(201, 23, 107000, "SJmoSsidDetail", "SJmoSsidDetail");
        }
        this.setAllData(rmiData);
    }

    public SJmoSsidDetail(byte byDataMode) {
        this.setIDataMode(byDataMode);
    }

    public void setAllData(RJiSSIDInfo rmiData) throws SJmoException {
        if (null == rmiData) {
            throw SJmoUtility.getException(201, 23, 107000, "SJmoSsidDetail", "setAllData");
        }
        this.setSSID(rmiData.getISSID());
        this.getKey();
        this.setLDKC(rmiData.getSLDKC());
        this.setCU(rmiData.getSCU());
        this.setStartLDEV(rmiData.getSStartLDEV());
        this.setEndLDEV(rmiData.getSEndLDEV());
    }

    public String getKey() {
        if (0 == this.strSsidKey.length()) {
            this.strSsidKey = this.makeKey();
        }
        return this.strSsidKey;
    }

    public boolean isValidKey() {
        boolean bRet = true;
        if (4 > this.iSSID || SJmoDataMacro_IF.NUM_MAX_SSID < this.iSSID) {
            bRet = false;
        }
        return bRet;
    }

    public String makeKey() {
        String strKey = new String("");
        if (this.isValidKey()) {
            strKey = SJmoUtility.itoh(this.getSSID(), 4);
        }
        return strKey;
    }

    @Override
    public int compareTo(Object KeyObj) {
        return this.getKey().compareTo(KeyObj.toString());
    }

    public String toString() {
        return this.getKey();
    }
}

