/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.modelrc.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.TreeMap;
import sanproject.sn2.model.SJmoUtility;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.kind.SJmoGetPortIscsiTargetInfo;
import sanproject.sn2.model.data.lu.SJmoIscsiTargetIndex;
import sanproject.sn2.model.data.lu.SJmoIscsiTargetInfo;
import sanproject.sn2.model.data.lu.SJmoPortIscsiTargetInfo;
import sanproject.sn2.modelrc.util.SJmoRscUtil;

public class SJmoRscUtilIscsiTarget
extends SJmoRscUtil {
    private HashMap<String, SJmoIscsiTargetInfo> m_iscsiTgInfo_MBase = new HashMap();
    private HashMap<String, SJmoIscsiTargetInfo> m_iscsiTgInfo_Rsv = new HashMap();
    private HashMap<String, SJmoIscsiTargetInfo> m_iscsiTgInfo_Diff = new HashMap();

    @Override
    public void setModelData(List lsModelData) {
        SJmoUtility.putLogDetail("SJmoRscUtilIscsiTarget", "setModelData", "start");
        if (!this.m_iscsiTgInfo_MBase.isEmpty()) {
            return;
        }
        try {
            List ptIscsiTgList = (List)lsModelData.get(0);
            for (SJmoPortIscsiTargetInfo ptIscsiTg : ptIscsiTgList) {
                ArrayList<SJmoIscsiTargetInfo> iscsiTgList = ptIscsiTg.getAlPortIscsiTarget();
                for (SJmoIscsiTargetInfo iscsiTg : iscsiTgList) {
                    this.m_iscsiTgInfo_MBase.put(iscsiTg.toString(), iscsiTg);
                }
            }
        }
        catch (Exception ex) {
            SJmoUtility.putLogDetail("SJmoRscUtilIscsiTarget", "setModelData", "internal err:" + ex.toString());
            throw SJmoUtility.getException(201, 23, 107021, "SJmoRscUtilIscsiTarget", "setModelData");
        }
    }

    @Override
    public void setRsvData(List lsRsvData) {
        try {
            List iscsiTgList = (List)lsRsvData.get(0);
            for (SJmoIscsiTargetInfo iscsiTg : iscsiTgList) {
                this.m_iscsiTgInfo_Rsv.put(iscsiTg.toString(), iscsiTg);
            }
        }
        catch (Exception ex) {
            SJmoUtility.putLogDetail("SJmoRscUtilIscsiTarget", "setRsvData", "internal err:" + ex.toString());
            throw SJmoUtility.getException(201, 23, 107021, "SJmoRscUtilIscsiTarget", "setRsvData");
        }
    }

    @Override
    public void delRsvData(List lsRsvData) {
        StringBuffer logBuff = new StringBuffer();
        try {
            List iscsiTgList = (List)lsRsvData.get(0);
            for (SJmoIscsiTargetInfo iscsiTg : iscsiTgList) {
                if (null != this.m_iscsiTgInfo_Rsv.remove(iscsiTg.toString())) continue;
                logBuff.append(iscsiTg.toString());
                logBuff.append(",");
            }
        }
        catch (Exception ex) {
            SJmoUtility.putLogDetail("SJmoRscUtilIscsiTarget", "delRsvData", "internal err:" + ex.toString());
            throw SJmoUtility.getException(201, 23, 107021, "SJmoRscUtilIscsiTarget", "delRsvData");
        }
        if (logBuff.length() > 0) {
            SJmoUtility.putLogDetail("SJmoRscUtilIscsiTarget", "delRsvData", "Search is failure:" + logBuff.toString());
        }
    }

    @Override
    public void clearRsvData() {
        SJmoUtility.putLogDetail("SJmoRscUtilIscsiTarget", "clearRsvData", "start");
        try {
            this.m_iscsiTgInfo_Rsv.clear();
        }
        catch (Exception exp) {
            SJmoUtility.putLogDetail("SJmoRscUtilIscsiTarget", "clearRsvData", "internal err:" + exp.toString());
            throw SJmoUtility.getException(201, 23, 107021, "SJmoRscUtilIscsiTarget", "clearRsvData");
        }
        SJmoUtility.putLogDetail("SJmoRscUtilIscsiTarget", "clearRsvData", "end");
    }

    @Override
    public List<List<SJmoIscsiTargetInfo>> getRsvData() {
        ArrayList<List<SJmoIscsiTargetInfo>> retList = new ArrayList<List<SJmoIscsiTargetInfo>>(1);
        ArrayList<SJmoIscsiTargetInfo> rsvList = new ArrayList<SJmoIscsiTargetInfo>(this.m_iscsiTgInfo_Rsv.values().size());
        rsvList.addAll(this.m_iscsiTgInfo_Rsv.values());
        Collections.sort(rsvList);
        retList.add(rsvList);
        return retList;
    }

    @Override
    public void setDiffData(List lsDiffData) {
        try {
            List iscsiTgList = (List)lsDiffData.get(0);
            for (SJmoIscsiTargetInfo iscsiTg : iscsiTgList) {
                this.m_iscsiTgInfo_Diff.put(iscsiTg.toString(), iscsiTg);
            }
        }
        catch (Exception ex) {
            SJmoUtility.putLogDetail("SJmoRscUtilIscsiTarget", "setDiffData", "internal err:" + ex.toString());
            throw SJmoUtility.getException(201, 23, 107021, "SJmoRscUtilIscsiTarget", "setDiffData");
        }
    }

    @Override
    public List<SJmoGetDirect> getNeccessityCls() {
        ArrayList<SJmoGetDirect> lsGetDirect = new ArrayList<SJmoGetDirect>(1);
        SJmoGetDirect getDirect = new SJmoGetDirect();
        SJmoGetPortIscsiTargetInfo getKind = new SJmoGetPortIscsiTargetInfo();
        getDirect.setGetKind(getKind);
        lsGetDirect.add(getDirect);
        return lsGetDirect;
    }

    public int chkIscsiTargetID(SJmoIscsiTargetIndex iscsiTgIndex) {
        int iResult = 3;
        if (iscsiTgIndex.isValidIndex()) {
            String IscsiTgKey = iscsiTgIndex.toString();
            if (!(this.m_iscsiTgInfo_MBase.containsKey(IscsiTgKey) || this.m_iscsiTgInfo_Rsv.containsKey(IscsiTgKey) || this.m_iscsiTgInfo_Diff.containsKey(IscsiTgKey))) {
                iResult = 0;
            }
        } else {
            SJmoUtility.putLogDetail("SJmoRscUtilIscsiTarget", "chkIscsiTargetID", "Paramater Error. PortID : " + iscsiTgIndex.getSPort() + "iSCSITargetID : " + iscsiTgIndex.getSIscsiTarget());
            throw SJmoUtility.getException(201, 23, 107022, "SJmoRscUtilIscsiTarget", "chkIscsiTargetID");
        }
        return iResult;
    }

    public int chkIscsiTargetID(short portId, short iscsiTargetId) {
        SJmoIscsiTargetIndex iscsiTgIndex = new SJmoIscsiTargetIndex();
        iscsiTgIndex.setSPort(portId);
        iscsiTgIndex.setSIscsiTarget(iscsiTargetId);
        return this.chkIscsiTargetID(iscsiTgIndex);
    }

    @Override
    protected List<List<SJmoPortIscsiTargetInfo>> getModelData() {
        SJmoUtility.putLogDetail("SJmoRscUtilIscsiTarget", "getModelData", "getModelData Start");
        TreeMap<Short, ArrayList<SJmoIscsiTargetInfo>> correctMap = new TreeMap<Short, ArrayList<SJmoIscsiTargetInfo>>();
        for (SJmoIscsiTargetInfo iscsiTgInfo : this.m_iscsiTgInfo_MBase.values()) {
            short portId = iscsiTgInfo.getSPort();
            ArrayList<SJmoIscsiTargetInfo> iscsiTgList = (ArrayList<SJmoIscsiTargetInfo>)correctMap.get(portId);
            if (null == iscsiTgList) {
                iscsiTgList = new ArrayList<SJmoIscsiTargetInfo>();
                correctMap.put(portId, iscsiTgList);
            }
            iscsiTgList.add(iscsiTgInfo);
        }
        ArrayList<SJmoPortIscsiTargetInfo> ptIscsiTgList = new ArrayList<SJmoPortIscsiTargetInfo>();
        for (Short portId : correctMap.keySet()) {
            SJmoPortIscsiTargetInfo ptIscsiTg = new SJmoPortIscsiTargetInfo();
            ptIscsiTg.setSPort(portId);
            ptIscsiTg.setAlPortIscsiTarget((ArrayList)correctMap.get(portId));
            ptIscsiTgList.add(ptIscsiTg);
        }
        ArrayList<List<SJmoPortIscsiTargetInfo>> lsModel = new ArrayList<List<SJmoPortIscsiTargetInfo>>(1);
        lsModel.add(ptIscsiTgList);
        SJmoUtility.putLogDetail("SJmoRscUtilIscsiTarget", "getModelData", "getModelData End");
        return lsModel;
    }
}

