/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.modelver;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import sanproject.common.Robj_interface_BASICVer;
import sanproject.common.Robj_interface_BASICVerLDEV;
import sanproject.common.Robj_interface_BASICVerLDEVPerCU;
import sanproject.common.Robj_interface_BASICVerLUPathPerPort;
import sanproject.common.Robj_interface_BASICVerPort;
import sanproject.common.Robj_interface_ConfVerID_06_01_00;
import sanproject.common.Robj_interface_ConfVerID_06_02_00;
import sanproject.common.Robj_interface_ConfVerID_06_02_01;
import sanproject.common.Robj_interface_ConfVerID_07_05_00;
import sanproject.common.Robj_interface_ConfVerID_08_01_00;
import sanproject.common.Robj_interface_ConfVerID_08_01_02;
import sanproject.common.Robj_interface_ODGDVerAllLDEV;
import sanproject.common.Robj_interface_ODGDVerLDEVPerCU;
import sanproject.common.Robj_interface_POOLVerAllPool;
import sanproject.common.Robj_interface_POOLVerPool;
import sanproject.common.Robj_interface_RJiPGIndex;
import sanproject.common.Robj_interface_VerLeaf;
import sanproject.serverux.dataimpl.AOUConfVer;
import sanproject.serverux.dataimpl.AOUConfVerAllLDEV;
import sanproject.serverux.dataimpl.AOUConfVerLDEVPerCU;
import sanproject.serverux.dataimpl.BASICVer;
import sanproject.serverux.dataimpl.BASICVerAllLDEV;
import sanproject.serverux.dataimpl.BASICVerAllLUPath;
import sanproject.serverux.dataimpl.BASICVerAllPG;
import sanproject.serverux.dataimpl.BASICVerAllPort;
import sanproject.serverux.dataimpl.BASICVerNormalPG;
import sanproject.serverux.dataimpl.BASICVerVirtualPG;
import sanproject.serverux.dataimpl.ConfVerDetailList;
import sanproject.serverux.dataimpl.ConfVerDetail_IN;
import sanproject.serverux.dataimpl.ConfVerDetail_OUT;
import sanproject.serverux.dataimpl.ConfVerSummary;
import sanproject.serverux.dataimpl.ConfVerSummary_IN;
import sanproject.serverux.dataimpl.ConfVerSummary_OUT;
import sanproject.serverux.dataimpl.DISKgetDKCDKUStatusInfo;
import sanproject.serverux.dataimpl.DKCSystemOptionEx;
import sanproject.serverux.dataimpl.EXDVer;
import sanproject.serverux.dataimpl.HAVer;
import sanproject.serverux.dataimpl.HAVerAllPair;
import sanproject.serverux.dataimpl.HURVer;
import sanproject.serverux.dataimpl.HURVerAllPair;
import sanproject.serverux.dataimpl.HURVerECTG;
import sanproject.serverux.dataimpl.HURVerPairPerCU;
import sanproject.serverux.dataimpl.HURVerSysOpt;
import sanproject.serverux.dataimpl.NICKNAMEVer;
import sanproject.serverux.dataimpl.NICKNAMEVerAllLDEV;
import sanproject.serverux.dataimpl.NICKNAMEVerAllPool;
import sanproject.serverux.dataimpl.NICKNAMEVerLDEVPerCU;
import sanproject.serverux.dataimpl.ODGDVer;
import sanproject.serverux.dataimpl.POOLVer;
import sanproject.serverux.dataimpl.RMCPVer;
import sanproject.serverux.dataimpl.RMCPVerAllPair;
import sanproject.serverux.dataimpl.SIVer;
import sanproject.serverux.dataimpl.SIVerAllPair;
import sanproject.serverux.dataimpl.UUIDVer;
import sanproject.serverux.dataimpl.UUIDVerAllLDEV;
import sanproject.serverux.dataimpl.UUIDVerLDEVPerCU;
import sanproject.serverux.dataimpl.VerBranch;
import sanproject.sn2.com.utility.SJcFileUty;
import sanproject.sn2.datasupplier.SJdsMethodInf;
import sanproject.sn2.datasupplier.SJdsSupplierAgent;
import sanproject.sn2.datasupplier.SJdsSupplierException;
import sanproject.sn2.datasupplier.SJdsSupplierMgr;
import sanproject.sn2.model.SJmoException;
import sanproject.sn2.model.SJmoModelMgr;
import sanproject.sn2.model.SJmoUtility;
import sanproject.sn2.model.inf.SJmoDataMacro_IF;
import sanproject.sn2.modelver.SJmoNoticeRenew;
import sanproject.sn2.modelver.SJmoVerCondition;
import sanproject.sn2.modelver.SJmoVerPoller;
import sanproject.sn2.modelver.data.SJmoDiffVerAou;
import sanproject.sn2.modelver.data.SJmoDiffVerBasic;
import sanproject.sn2.modelver.data.SJmoDiffVerHA;
import sanproject.sn2.modelver.data.SJmoDiffVerHur;
import sanproject.sn2.modelver.data.SJmoDiffVerNickname;
import sanproject.sn2.modelver.data.SJmoDiffVerOdgd;
import sanproject.sn2.modelver.data.SJmoDiffVerPool;
import sanproject.sn2.modelver.data.SJmoDiffVerRmcp;
import sanproject.sn2.modelver.data.SJmoDiffVerSi;
import sanproject.sn2.modelver.data.SJmoDiffVerUuid;
import sanproject.sn2.modelver.data.SJmoDiffVerUvm;
import sanproject.sn2.modelver.data.SJmoDiffVersion;
import sanproject.sn2.modelver.data.SJmoVersionData;

public class SJmoVersionMgr
implements Robj_interface_ConfVerID_06_01_00,
Robj_interface_ConfVerID_06_02_00,
Robj_interface_ConfVerID_06_02_01,
Robj_interface_ConfVerID_07_05_00,
Robj_interface_ConfVerID_08_01_00,
Robj_interface_ConfVerID_08_01_02 {
    private static SJmoVersionMgr m_VerMgr;
    private SJmoVerPoller m_Poller;
    private SJmoVerCondition m_Condition;
    private SJmoVersionData m_VerData;
    private SJmoVersionData m_VerData_ex;
    private int m_iRequest;
    private SJmoNoticeRenew m_NoticeRenew;
    private String m_strLog = null;
    private SJmoModelMgr m_MdlMgr = null;
    private int m_SvpConfRetry = 0;
    private boolean m_RetryVer = true;
    private int m_iRetryCnt = 0;
    private SJmoVersionData m_VerData_bak;
    private DKCSystemOptionEx m_SysOpt = null;
    private Object m_SysOptSyncObj = new Object();

    private SJmoVersionMgr() {
        this.m_Condition = new SJmoVerCondition();
        this.changeStatus(0);
    }

    public static SJmoVersionMgr getInstance() {
        if (null == m_VerMgr) {
            m_VerMgr = new SJmoVersionMgr();
        }
        return m_VerMgr;
    }

    public int initialize(boolean bModelRead) {
        SJmoUtility.putLogDetail("SJmoVersionMgr", "initialize", "VersionMgr initialize start.");
        int iRet = 0;
        int iStatus = 0;
        iStatus = this.m_Condition.getStatus();
        switch (iStatus) {
            case 0: {
                iRet = this.initVersionManager(bModelRead);
                break;
            }
            default: {
                SJmoUtility.putLogDetail("SJmoVersionMgr", "initialize", "Status Error(" + iStatus + ")");
                iRet = -1;
            }
        }
        SJmoUtility.putLogDetail("SJmoVersionMgr", "initialize", "VersionMgr initialize .");
        return iRet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int poller() {
        SJdsSupplierMgr SupMgr;
        int iRet = 0;
        int iStatus = 0;
        iStatus = this.changeStatus(2);
        switch (iStatus) {
            case 0: {
                iRet = this.waitVerInit();
                break;
            }
            case 2: {
                iRet = this.notifyVerDiffbyPoller();
                break;
            }
            case 8: {
                iRet = 3;
                break;
            }
            default: {
                SJmoUtility.putLogDetail("SJmoVersionMgr", "poller", "Status Error(" + iStatus + ")");
                iRet = -1;
            }
        }
        if (0 == iRet && null != this.m_MdlMgr && null != (SupMgr = this.m_MdlMgr.getSupplierMgr())) {
            SJmoException MdlErr;
            SJmoException sJmoException = MdlErr = this.m_MdlMgr.getModelException();
            synchronized (sJmoException) {
                int iErrLv = SJmoUtility.getModelErrLevel(MdlErr, SupMgr);
                if (1 != iErrLv && 2 != iErrLv) {
                    this.m_MdlMgr.delModelException();
                }
            }
        }
        return iRet;
    }

    private synchronized int waitVerInit() {
        int iRet = 0;
        int iRtry = 0;
        int iStatus = 0;
        for (iRtry = 0; iRtry < 200 && (iStatus = this.changeStatus(2)) != 2; ++iRtry) {
            try {
                this.wait(100L);
                continue;
            }
            catch (Exception exp) {
                SJmoUtility.putLogDetail("SJmoVersionMgr", "waitVerInit", "wait failed" + exp.toString());
                break;
            }
        }
        if (iStatus == 2) {
            iRet = this.notifyVerDiffbyPoller();
        } else {
            SJmoUtility.putLogDetail("SJmoVersionMgr", "waitVerInit", "VerStatus not INIT(" + iStatus + ").");
            iRet = -1;
        }
        return iRet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int refresh(int iRefKind) {
        SJdsSupplierMgr SupMgr;
        int iRet = 0;
        int iStatus = 0;
        iStatus = this.changeStatus(4);
        switch (iStatus) {
            case 4: {
                iRet = this.notifyVerDiffbyRefresh(iRefKind);
                break;
            }
            case 2: 
            case 3: 
            case 8: {
                iRet = this.recieveRefresh(iRefKind);
                break;
            }
            default: {
                this.m_MdlMgr.setRefreshException(201, 23, 107003);
                SJmoUtility.putLogDetail("SJmoVersionMgr", "refresh", "Refresh kind error");
                iRet = -1;
            }
        }
        if (0 == iRet && null != (SupMgr = this.m_MdlMgr.getSupplierMgr())) {
            SJmoException MdlErr;
            SJmoException sJmoException = MdlErr = this.m_MdlMgr.getModelException();
            synchronized (sJmoException) {
                int iErrLv = SJmoUtility.getModelErrLevel(MdlErr, SupMgr);
                if (1 != iErrLv && 2 != iErrLv) {
                    this.m_MdlMgr.delModelException();
                }
            }
        }
        return iRet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int refreshAll() {
        SJdsSupplierMgr SupMgr;
        int iRet = 0;
        int iStatus = 0;
        this.m_VerData.setBEnable(false);
        try {
            SJcFileUty.deleteFile("version", "VERDATA.obj");
        }
        catch (Exception exp) {
            SJmoUtility.putLogDetail("SJmoVersionMgr", "refreshAll", "delete Verfile failed");
        }
        iStatus = this.changeStatus(6);
        switch (iStatus) {
            case 6: {
                iRet = this.notifyVerDiffbyAllRefresh();
                break;
            }
            case 2: 
            case 3: 
            case 8: {
                iRet = this.recieveRefreshAll();
                break;
            }
            default: {
                this.m_MdlMgr.setRefreshException(201, 23, 107003);
                SJmoUtility.putLogDetail("SJmoVersionMgr", "refreshAll", "Refresh kind error.");
                iRet = -1;
            }
        }
        if (0 == iRet && null != (SupMgr = this.m_MdlMgr.getSupplierMgr())) {
            SJmoException MdlErr;
            SJmoException sJmoException = MdlErr = this.m_MdlMgr.getModelException();
            synchronized (sJmoException) {
                int iErrLv = SJmoUtility.getModelErrLevel(MdlErr, SupMgr);
                if (1 != iErrLv) {
                    this.m_MdlMgr.delModelException();
                }
            }
        }
        return iRet;
    }

    public void rsvResult(boolean bResult, boolean bStopRst, SJmoException moExp, boolean bUpdateTread, int iUpdReq) {
        SJmoUtility.putLogDetail("SJmoVersionMgr", "rsvResult", "Model update End (Reqest:" + iUpdReq + " Result:" + bResult + ")");
        int iStatus = 0;
        iStatus = this.m_Condition.getStatus();
        switch (iStatus) {
            case 8: {
                this.postProcessNotifyVersion(bResult, bStopRst, moExp, bUpdateTread, iUpdReq);
                break;
            }
            default: {
                if (this.m_iRequest != 0) {
                    if (this.m_Poller.isAlive()) {
                        this.m_Poller.startScadule();
                    } else {
                        this.m_Poller = new SJmoVerPoller(true);
                        this.m_Poller.start();
                    }
                    this.m_MdlMgr.setRefreshException(201, 23, 107003);
                }
                this.changeStatus(1);
                SJmoUtility.putLogDetail("SJmoVersionMgr", "rsvResult", "Status Error(" + iStatus + ")");
            }
        }
    }

    private int initVersionManager(boolean bModelRead) {
        SJmoUtility.putLogDetail("SJmoVersionMgr", "initVersionManager", "VersionMgr Initialize start.");
        int iRet = 0;
        int iRetry = 0;
        boolean bFnRet = true;
        this.m_SvpConfRetry = 0;
        this.m_Poller = new SJmoVerPoller(false);
        this.m_VerData = new SJmoVersionData();
        this.m_VerData_ex = new SJmoVersionData();
        this.m_VerData_bak = new SJmoVersionData();
        this.changeStatus(0);
        this.m_iRequest = -1;
        this.m_strLog = new String("");
        this.m_RetryVer = true;
        this.m_iRetryCnt = 0;
        try {
            this.m_MdlMgr = SJmoModelMgr.getModelMgr();
        }
        catch (SJmoException moExp) {
            SJmoUtility.putLogDetail("SJmoVersionMgr", "initialize", "ModelMgr getInstance failed");
        }
        try {
            SJcFileUty.deleteFile("version", "VersionObj.dbg");
        }
        catch (Exception exp) {
            SJmoUtility.putLogDetail("SJmoVersionMgr", "initialize", "delete oldfile failed");
        }
        this.m_VerData.setBEnable(false);
        if (bModelRead) {
            bFnRet = this.inputVersionData();
            if (bFnRet) {
                this.m_VerData.setBEnable(true);
            }
        } else {
            try {
                SJcFileUty.deleteFile("version", "VERDATA.obj");
            }
            catch (Exception exp) {
                SJmoUtility.putLogDetail("SJmoVersionMgr", "initialize", "delete Verfile failed");
            }
            SJmoUtility.putLogDetail("SJmoVersionMgr", "initialize", "Refresh All Execute");
            SJdsSupplierAgent supAgt = SJdsSupplierMgr.getSupplierMgr().getAgentOnce();
            bFnRet = this.refreshRMI(2, supAgt);
            if (!bFnRet) {
                iRet = -1;
            }
        }
        if (0 == iRet) {
            if (this.m_Poller != null) {
                for (iRetry = 0; iRetry < 5; ++iRetry) {
                    this.m_Poller.start();
                    if (this.m_Poller.isAlive()) break;
                }
                if (this.m_Poller.isAlive()) {
                    this.changeStatus(1);
                } else {
                    this.m_strLog = "initVersionManager:Polling not Start";
                    this.putLog(this.m_strLog);
                    iRet = -1;
                }
            } else {
                this.m_strLog = "initVersionManager:Polling class is not alive";
                this.putLog(this.m_strLog);
                iRet = -1;
            }
        }
        SJmoUtility.putLogDetail("SJmoVersionMgr", "initVersionManager", "VersionMgr Initialize end.");
        return iRet;
    }

    private int notifyVerDiffbyPoller() {
        SJmoUtility.putLogDetail("SJmoVersionMgr", "notifyVerDiffbyPoller", "VersionMgr poller start.");
        int iRet = 0;
        SJmoDiffVersion diffVer = null;
        Boolean bAll = new Boolean(false);
        boolean bAllflg = false;
        this.m_iRequest = 0;
        diffVer = this.checkVersion(0, bAll);
        if (diffVer != null) {
            if (this.m_iRequest == 0) {
                this.m_NoticeRenew = new SJmoNoticeRenew(diffVer, 0, bAllflg);
                this.m_SvpConfRetry = 0;
                this.m_NoticeRenew.start();
            } else {
                switch (this.m_iRequest) {
                    case 1: 
                    case 3: {
                        iRet = 1;
                        break;
                    }
                    case 2: {
                        iRet = 2;
                        break;
                    }
                    default: {
                        SJmoUtility.putLogDetail("SJmoVersionMgr", "notifyVerDiffbyPoller", "Request Kind Error");
                        iRet = -1;
                        break;
                    }
                }
            }
        } else {
            iRet = -1;
        }
        if (iRet == 0) {
            this.changeStatus(8);
        } else {
            this.changeStatus(1);
        }
        SJmoUtility.putLogDetail("SJmoVersionMgr", "notifyVerDiffbyPoller", "VersionMgr poller end(" + iRet + ").");
        return iRet;
    }

    private int notifyVerDiffbyRefresh(int iRefKind) {
        SJmoUtility.putLogDetail("SJmoVersionMgr", "notifyVerDiffbyRefresh", "VersionMgr refresh start(Request:" + iRefKind + ").");
        int iRet = 0;
        SJmoDiffVersion diffVer = null;
        Boolean bAll = new Boolean(false);
        boolean bAllflg = false;
        this.refSystemOption(true);
        DKCSystemOptionEx sysOpt = this.getSystemOption();
        this.m_iRetryCnt = 0;
        this.m_iRequest = iRefKind == 0 ? 1 : 3;
        if (SJmoVersionMgr.isRefreshForce(sysOpt, this.m_iRequest)) {
            this.m_VerData.setBEnable(false);
        }
        this.m_Poller.canselScadule();
        diffVer = this.checkVersion(this.m_iRequest, bAll);
        if (diffVer != null) {
            this.m_NoticeRenew = new SJmoNoticeRenew(diffVer, this.m_iRequest, bAllflg);
            this.m_NoticeRenew.start();
        } else {
            iRet = -1;
        }
        if (iRet == 0) {
            this.changeStatus(8);
        } else {
            this.changeStatus(1);
            if (this.m_Poller.isAlive()) {
                this.m_Poller.startScadule();
            } else {
                this.m_Poller = new SJmoVerPoller(true);
                this.m_Poller.start();
            }
        }
        SJmoUtility.putLogDetail("SJmoVersionMgr", "notifyVerDiffbyRefresh", "VersionMgr refresh end(" + iRet + ").");
        return iRet;
    }

    private int notifyVerDiffbyAllRefresh() {
        SJmoUtility.putLogDetail("SJmoVersionMgr", "notifyVerDiffbyAllRefresh", "VersionMgr refreshAll start.");
        int iRet = 0;
        SJmoDiffVersion diffVer = null;
        Boolean bAll = new Boolean(false);
        boolean bAllflg = false;
        this.refSystemOption(true);
        this.m_iRetryCnt = 0;
        this.m_iRequest = 2;
        this.m_Poller.canselScadule();
        diffVer = this.checkVersion(2, bAll);
        if (diffVer != null) {
            bAllflg = bAll;
            this.m_NoticeRenew = new SJmoNoticeRenew(diffVer, this.m_iRequest, bAllflg);
            this.m_NoticeRenew.start();
        } else {
            iRet = -1;
        }
        if (iRet == 0) {
            this.changeStatus(8);
        } else {
            this.changeStatus(1);
            if (this.m_Poller.isAlive()) {
                this.m_Poller.startScadule();
            } else {
                this.m_Poller = new SJmoVerPoller(true);
                this.m_Poller.start();
            }
        }
        SJmoUtility.putLogDetail("SJmoVersionMgr", "notifyVerDiffbyAllRefresh", "VersionMgr refreshAll end(" + iRet + ").");
        return iRet;
    }

    private synchronized int recieveRefresh(int iRefKind) {
        int iRet = 0;
        int iStatus = 0;
        int iWait = 0;
        this.m_iRequest = 1;
        for (iWait = 0; iWait < 100 && (iStatus = this.changeStatus(4)) != 4; ++iWait) {
            try {
                this.wait(100L);
                continue;
            }
            catch (Exception e) {
                SJmoUtility.putLogDetail("SJmoVersionMgr", "receiveRefresh", "Wait failed(" + e.toString() + ")");
                iRet = -1;
                break;
            }
        }
        if (iStatus == 4) {
            iRet = this.notifyVerDiffbyRefresh(iRefKind);
        } else {
            this.m_MdlMgr.setRefreshException(201, 23, 107026);
            SJmoUtility.putLogDetail("SJmoVersionMgr", "recieveRefresh", "VersionMgr,Status error");
            iRet = -1;
        }
        return iRet;
    }

    private synchronized int recieveRefreshAll() {
        int iRet = 0;
        int iStatus = 0;
        int iWait = 0;
        this.m_iRequest = 2;
        for (iWait = 0; iWait < 100 && (iStatus = this.changeStatus(6)) != 6; ++iWait) {
            try {
                this.wait(100L);
                continue;
            }
            catch (Exception e) {
                this.m_strLog = "recieveRefreshAll:wait failed(" + e.toString() + ")";
                this.putLog(this.m_strLog);
                iRet = -1;
                break;
            }
        }
        if (iStatus == 6) {
            iRet = this.notifyVerDiffbyAllRefresh();
        } else {
            this.m_MdlMgr.setRefreshException(201, 23, 107026);
            SJmoUtility.putLogDetail("SJmoVersionMgr", "recieveRefreshAll", "VersionMgr,Status error");
            iRet = -1;
        }
        return iRet;
    }

    private void postProcessNotifyVersion(boolean bResult, boolean bStopRst, SJmoException moExp, boolean bUpdateTread, int iUpdReq) {
        Boolean bAll = new Boolean(false);
        boolean bRestartPoller = false;
        boolean bRenewCont = false;
        SJmoModelMgr modelMgr = SJmoModelMgr.getModelMgr();
        boolean bRetry = false;
        this.changeStatus(9);
        if (bResult) {
            int iSvpStat = 1;
            try {
                iSvpStat = this.getSvpConfStat();
            }
            catch (SJmoException cnfExp) {
                String strDetail = "getSvpConfStat failed FuncID=" + cnfExp.getMsg().getFunctionID() + " ModuleID=" + cnfExp.getMsg().getModuleID() + " MsgID=" + cnfExp.getMsg().getMsgID();
                SJmoUtility.putLogDetail("SJmoVersionMgr", "postProcessNotifyVersion", strDetail);
            }
            if (1 != iSvpStat) {
                if (0 != iUpdReq) {
                    SJmoUtility.putLogDetail("SJmoVersionMgr", "postProcessNotifyVersion", "SVP config inconsistent. Req:" + iUpdReq);
                    this.m_VerData.setBEnable(false);
                    bRestartPoller = true;
                    modelMgr.setModelException(201, 23, 108004);
                } else if (3 > this.m_SvpConfRetry) {
                    this.m_VerData.setBEnable(false);
                    SJmoDiffVersion diffVer = this.checkVersion(0, bAll);
                    if (null != diffVer) {
                        this.m_NoticeRenew = new SJmoNoticeRenew(diffVer, 0, bAll);
                        this.m_NoticeRenew.start();
                        bRenewCont = true;
                        this.changeStatus(8);
                    } else {
                        SJmoUtility.putLogDetail("SJmoVersionMgr", "postProcessNotifyVersion", "recovery is failed(SJmoDiffVer is not able to make)");
                    }
                } else {
                    SJmoUtility.putLogDetail("SJmoVersionMgr", "postProcessNotifyVersion", "give up the recovery.");
                }
            } else {
                SJmoDiffVersion diffVer = null;
                diffVer = true == this.m_RetryVer ? this.checkVersion(4, bAll) : new SJmoDiffVersion();
                if (null != diffVer) {
                    if (diffVer.isVersionDiff()) {
                        bRetry = true;
                        if (0 != iUpdReq) {
                            bRetry = false;
                            bResult = false;
                            modelMgr.setModelException(201, 23, 107027);
                        }
                    } else {
                        this.m_MdlMgr.endThread(moExp, iUpdReq, bStopRst);
                        this.renewVerData();
                    }
                    if (bRetry) {
                        int iReqest = iUpdReq;
                        if (2 == iReqest) {
                            iReqest = 1;
                        }
                        this.m_NoticeRenew = new SJmoNoticeRenew(diffVer, iReqest, bAll);
                        this.m_NoticeRenew.start();
                        bRenewCont = true;
                        this.changeStatus(8);
                    } else if (iUpdReq != 0) {
                        bRestartPoller = true;
                    }
                } else {
                    if (iUpdReq != 0) {
                        if (iUpdReq == 2) {
                            this.m_VerData.setBEnable(false);
                        }
                        bRestartPoller = true;
                    }
                    this.m_MdlMgr.endThread(new SJmoException(), iUpdReq, bStopRst);
                    bResult = false;
                    SJmoUtility.putLogDetail("SJmoVersionMgr", "postProcessNotifyVersion", "Version information is illigal");
                }
            }
        } else {
            if (!bStopRst && iUpdReq != 0) {
                bRestartPoller = true;
            }
            if (bUpdateTread) {
                this.m_MdlMgr.endThread(moExp, iUpdReq, bStopRst);
            } else if (iUpdReq != 0) {
                this.m_MdlMgr.setRefreshException(201, 23, 107008);
            }
        }
        if (!bRenewCont) {
            if (bRestartPoller) {
                if (this.m_Poller.isAlive()) {
                    this.m_Poller.startScadule();
                } else {
                    this.m_Poller = new SJmoVerPoller(bRestartPoller);
                    this.m_Poller.start();
                }
            }
            if (bResult) {
                this.m_MdlMgr.delModelException();
            }
            if (!bStopRst && iUpdReq != 0) {
                this.m_MdlMgr.endRefresh();
            }
            this.m_iRequest = -1;
            this.changeStatus(1);
        }
    }

    private void renewVerData() {
        this.m_VerData_bak = new SJmoVersionData(this.m_VerData);
        if (null != this.m_VerData_ex.getVerSummary()) {
            this.m_VerData.setVerSummary(this.m_VerData_ex.getVerSummary());
        }
        if (null != this.m_VerData_ex.getVerBasic()) {
            this.m_VerData.setVerBasic(this.m_VerData_ex.getVerBasic());
        }
        if (null != this.m_VerData_ex.getVerAou()) {
            this.m_VerData.setVerAou(this.m_VerData_ex.getVerAou());
        }
        if (null != this.m_VerData_ex.getVerPool()) {
            this.m_VerData.setVerPool(this.m_VerData_ex.getVerPool());
        }
        if (null != this.m_VerData_ex.getVerOdgd()) {
            this.m_VerData.setVerOdgd(this.m_VerData_ex.getVerOdgd());
        }
        if (null != this.m_VerData_ex.getVerUvm()) {
            this.m_VerData.setVerUvm(this.m_VerData_ex.getVerUvm());
        }
        if (null != this.m_VerData_ex.getVerUuid()) {
            this.m_VerData.setVerUuid(this.m_VerData_ex.getVerUuid());
        }
        if (null != this.m_VerData_ex.getVerNickname()) {
            this.m_VerData.setVerNickname(this.m_VerData_ex.getVerNickname());
        }
        if (null != this.m_VerData_ex.getVerHur()) {
            this.m_VerData.setVerHur(this.m_VerData_ex.getVerHur());
        }
        if (null != this.m_VerData_ex.getVerSi()) {
            this.m_VerData.setVerSi(this.m_VerData_ex.getVerSi());
        }
        if (null != this.m_VerData_ex.getVerRmcp()) {
            this.m_VerData.setVerRmcp(this.m_VerData_ex.getVerRmcp());
        }
        if (null != this.m_VerData_ex.getVerHA()) {
            this.m_VerData.setVerHA(this.m_VerData_ex.getVerHA());
        }
        this.m_VerData.setBEnable(true);
        this.m_VerData_ex = new SJmoVersionData();
    }

    private SJmoDiffVersion checkVersion(int iRequest, Boolean bAll) {
        SJmoDiffVersion diffVer = null;
        boolean bRet = true;
        ConfVerSummary verSummary = null;
        ConfVerDetailList verDetailList = null;
        int[] iFuncID = null;
        BitSet bsFuncID = new BitSet();
        this.m_RetryVer = true;
        try {
            SJdsSupplierMgr supMgr = SJdsSupplierMgr.getSupplierMgr();
            SJdsSupplierAgent supAgnt = supMgr.getAgent();
            if (supAgnt != null) {
                if (3 != iRequest) {
                    bRet = this.refreshRMI(iRequest, supAgnt);
                }
                if (bRet && null != (verSummary = this.getVerSummary(iRequest, supAgnt))) {
                    SJmoUtility.putLogDetail(this.getClass().getSimpleName(), "checkVersion", "verSummary BASIC Ver =" + verSummary.getNVer(0x6010001));
                    SJmoUtility.putLogDetail(this.getClass().getSimpleName(), "checkVersion", "verSummary THIN_PROVISION Ver =" + verSummary.getNVer(369230081));
                    SJmoUtility.putLogDetail(this.getClass().getSimpleName(), "checkVersion", "verSummary RETENTION Ver =" + verSummary.getNVer(100728836));
                    SJmoUtility.putLogDetail(this.getClass().getSimpleName(), "checkVersion", "verSummary UVM Ver =" + verSummary.getNVer(0x16010000));
                    SJmoUtility.putLogDetail(this.getClass().getSimpleName(), "checkVersion", "verSummary UUID Ver =" + verSummary.getNVer(0x16010001));
                    SJmoUtility.putLogDetail(this.getClass().getSimpleName(), "checkVersion", "verSummary NICKNAME Ver =" + verSummary.getNVer(100728843));
                    SJmoUtility.putLogDetail(this.getClass().getSimpleName(), "checkVersion", "verSummary CACHE Ver =" + verSummary.getNVer(100728842));
                    SJmoUtility.putLogDetail(this.getClass().getSimpleName(), "checkVersion", "verSummary PPC Ver =" + verSummary.getNVer(369164290));
                    SJmoUtility.putLogDetail(this.getClass().getSimpleName(), "checkVersion", "verSummary REQ_REFRESH Ver =" + verSummary.getNVer(369164291));
                    SJmoUtility.putLogDetail(this.getClass().getSimpleName(), "checkVersion", "verSummary REMOTE_COPY_J Ver = " + verSummary.getNVer(100728840));
                    SJmoUtility.putLogDetail(this.getClass().getSimpleName(), "checkVersion", "verSummary RESOURCE_GROUP Ver = " + verSummary.getNVer(100794369));
                    SJmoUtility.putLogDetail(this.getClass().getSimpleName(), "checkVersion", "verSummary FCOE Ver = " + verSummary.getNVer(0x6020002));
                    SJmoUtility.putLogDetail(this.getClass().getSimpleName(), "checkVersion", "verSummary LOCAL_COPY Ver = " + verSummary.getNVer(100728837));
                    SJmoUtility.putLogDetail(this.getClass().getSimpleName(), "checkVersion", "verSummary REMOTE_COPY Ver = " + verSummary.getNVer(100728839));
                    SJmoUtility.putLogDetail(this.getClass().getSimpleName(), "checkVersion", "verSummary VIRTUAL_ID Ver = " + verSummary.getNVer(100794625));
                    SJmoUtility.putLogDetail(this.getClass().getSimpleName(), "checkVersion", "verSummary SNAPSHOT_SET Ver = " + verSummary.getNVer(117768193));
                    SJmoUtility.putLogDetail(this.getClass().getSimpleName(), "checkVersion", "verSummary HUVM Ver = " + verSummary.getNVer(0x8010001));
                    SJmoUtility.putLogDetail(this.getClass().getSimpleName(), "checkVersion", "verSummary HIGH_AVAILABILITY Ver = " + verSummary.getNVer(134283777));
                    SJmoUtility.putLogDetail(this.getClass().getSimpleName(), "checkVersion", "verSummary QUORUM_ID Ver = " + verSummary.getNVer(134283778));
                    if (iRequest == 4 && !this.checkVerSummary(this.m_VerData_ex.getVerSummary(), verSummary)) {
                        diffVer = new SJmoDiffVersion();
                        return diffVer;
                    }
                    if (null != this.m_VerData.getVerSummary() && this.m_VerData.getVerSummary().getNVer(369164291) != verSummary.getNVer(369164291)) {
                        SJmoUtility.putLogDetail("SJmoVersionMgr", "checkVersion", "REQ_REFRESH Ver Diff old:" + this.m_VerData.getVerSummary().getNVer(369164291) + ", new:" + verSummary.getNVer(369164291));
                        this.m_VerData.setBEnable(false);
                    }
                    if (null != (verDetailList = this.getVerDetail(iRequest, iFuncID = true == this.m_VerData.isBEnable() && null != this.m_VerData.getVerSummary() ? this.getVerDetailList(this.m_VerData.getVerSummary(), verSummary) : new int[]{0x6010001, 369230081, 100728835, 100728836, 100728843, 100728840, 0x16010000, 0x16010001, 100728837, 100728839, 134283777}, supAgnt))) {
                        this.m_VerData_ex.setVerSummary(verSummary);
                        this.setNewVerDetailData(iFuncID, verDetailList);
                        if (iRequest != 4) {
                            this.m_Condition.setStatus(this.m_Condition.getStatus() + 1);
                        }
                        diffVer = this.makeVerDiffList();
                        if (1 == iRequest && !diffVer.isVersionDiff()) {
                            this.m_RetryVer = false;
                        } else if (!SJmoVersionMgr.isRetryDataUpdate(this.getSystemOption(), iRequest)) {
                            this.m_RetryVer = false;
                        }
                    }
                }
            } else {
                SJmoUtility.putLogDetail("SJmoVersionMgr", "checkVersion", "Instance none ofSupplier Agent");
                this.m_MdlMgr.setModelException(201, 23, 107003);
            }
        }
        catch (SJmoException moExp) {
            SJmoUtility.putLogDetail("SJmoVersionMgr", "checkVersion", "Internal Error");
            this.m_MdlMgr.setRefreshException(201, 23, 107003);
        }
        return diffVer;
    }

    private int[] getVerDetailList(ConfVerSummary oldVerSum, ConfVerSummary newVerSum) {
        int[] iFuncID = null;
        ArrayList<Integer> alVerList = new ArrayList<Integer>();
        int iIndex = 0;
        SJmoUtility.putLogDetail("SJmoVersionMgr", "getVerDetailList", "BASIC VER OLD:" + oldVerSum.getNVer(0x6010001) + ",MEW:" + newVerSum.getNVer(0x6010001));
        alVerList.add(0x6010001);
        SJmoUtility.putLogDetail("SJmoVersionMgr", "getVerDetailList", "PROVISION VER OLD:" + oldVerSum.getNVer(369230081) + ",MEW:" + newVerSum.getNVer(369230081));
        if (oldVerSum.getNVer(369230081) != newVerSum.getNVer(369230081)) {
            alVerList.add(369230081);
        }
        SJmoUtility.putLogDetail("SJmoVersionMgr", "getVerDetailList", "POOL VER OLD:" + oldVerSum.getNVer(100728835) + ",MEW:" + newVerSum.getNVer(100728835));
        alVerList.add(100728835);
        SJmoUtility.putLogDetail("SJmoVersionMgr", "getVerDetailList", "RETENTION VER OLD:" + oldVerSum.getNVer(100728836) + ",MEW:" + newVerSum.getNVer(100728836));
        if (oldVerSum.getNVer(100728836) != newVerSum.getNVer(100728836)) {
            alVerList.add(100728836);
        }
        SJmoUtility.putLogDetail("SJmoVersionMgr", "getVerDetailList", "UVM VER OLD:" + oldVerSum.getNVer(0x16010000) + ",MEW:" + newVerSum.getNVer(0x16010000));
        if (oldVerSum.getNVer(0x16010000) != newVerSum.getNVer(0x16010000)) {
            alVerList.add(0x16010000);
        }
        SJmoUtility.putLogDetail("SJmoVersionMgr", "getVerDetailList", "UUID VER OLD:" + oldVerSum.getNVer(0x16010001) + ",MEW:" + newVerSum.getNVer(0x16010001));
        if (oldVerSum.getNVer(0x16010001) != newVerSum.getNVer(0x16010001)) {
            alVerList.add(0x16010001);
        }
        SJmoUtility.putLogDetail("SJmoVersionMgr", "getVerDetailList", "NICKNAME VER OLD:" + oldVerSum.getNVer(100728843) + ",MEW:" + newVerSum.getNVer(100728843));
        if (oldVerSum.getNVer(100728843) != newVerSum.getNVer(100728843)) {
            alVerList.add(100728843);
        }
        SJmoUtility.putLogDetail("SJmoVersionMgr", "getVerDetailList", "REMOTE_COPY_J VER OLD:" + oldVerSum.getNVer(100728840) + ",NEW:" + newVerSum.getNVer(100728840));
        if (oldVerSum.getNVer(100728840) != newVerSum.getNVer(100728840)) {
            alVerList.add(100728840);
        }
        SJmoUtility.putLogDetail("SJmoVersionMgr", "getVerDetailList", "LOCAL_COPY VER OLD:" + oldVerSum.getNVer(100728837) + ",NEW:" + newVerSum.getNVer(100728837));
        if (oldVerSum.getNVer(100728837) != newVerSum.getNVer(100728837)) {
            alVerList.add(100728837);
        }
        SJmoUtility.putLogDetail("SJmoVersionMgr", "getVerDetailList", "REMOTE_COPY VER OLD:" + oldVerSum.getNVer(100728839) + ",NEW:" + newVerSum.getNVer(100728839));
        if (oldVerSum.getNVer(100728839) != newVerSum.getNVer(100728839)) {
            alVerList.add(100728839);
        }
        SJmoUtility.putLogDetail("SJmoVersionMgr", "getVerDetailList", "HIGH_AVAILABILITY VER OLD:" + oldVerSum.getNVer(134283777) + ",NEW:" + newVerSum.getNVer(134283777));
        if (oldVerSum.getNVer(134283777) != newVerSum.getNVer(134283777)) {
            alVerList.add(134283777);
        }
        iFuncID = new int[alVerList.size()];
        Iterator iter = alVerList.iterator();
        while (iter.hasNext()) {
            iFuncID[iIndex] = (Integer)iter.next();
            ++iIndex;
        }
        SJmoUtility.putLogDetail("SJmoVersionMgr", "getVerDetailList", "DetailList Num:" + iFuncID.length);
        return iFuncID;
    }

    private void setNewVerDetailData(int[] iFuncID, ConfVerDetailList verDetailList) {
        int iLpCnt = 0;
        block13: for (iLpCnt = 0; iLpCnt < iFuncID.length; ++iLpCnt) {
            switch (iFuncID[iLpCnt]) {
                case 0x6010001: {
                    this.m_VerData_ex.setVerBasic((BASICVer)verDetailList.getConfVerDetail(0x6010001));
                    continue block13;
                }
                case 369230081: {
                    this.m_VerData_ex.setVerAou((AOUConfVer)verDetailList.getConfVerDetail(369230081));
                    continue block13;
                }
                case 100728835: {
                    this.m_VerData_ex.setVerPool((POOLVer)verDetailList.getConfVerDetail(100728835));
                    continue block13;
                }
                case 100728836: {
                    this.m_VerData_ex.setVerOdgd((ODGDVer)verDetailList.getConfVerDetail(100728836));
                    continue block13;
                }
                case 0x16010000: {
                    this.m_VerData_ex.setVerUvm((EXDVer)verDetailList.getConfVerDetail(0x16010000));
                    continue block13;
                }
                case 0x16010001: {
                    this.m_VerData_ex.setVerUuid((UUIDVer)verDetailList.getConfVerDetail(0x16010001));
                    continue block13;
                }
                case 100728843: {
                    this.m_VerData_ex.setVerNickname((NICKNAMEVer)verDetailList.getConfVerDetail(100728843));
                    continue block13;
                }
                case 100728840: {
                    this.m_VerData_ex.setVerHur((HURVer)verDetailList.getConfVerDetail(100728840));
                    continue block13;
                }
                case 100728837: {
                    this.m_VerData_ex.setVerSi((SIVer)verDetailList.getConfVerDetail(100728837));
                    continue block13;
                }
                case 100728839: {
                    this.m_VerData_ex.setVerRmcp((RMCPVer)verDetailList.getConfVerDetail(100728839));
                    continue block13;
                }
                case 134283777: {
                    this.m_VerData_ex.setVerHA((HAVer)verDetailList.getConfVerDetail(134283777));
                }
            }
        }
    }

    private SJmoDiffVersion makeVerDiffList() {
        SJmoDiffVersion diffVer = new SJmoDiffVersion();
        BitSet bsOldEqLDEV = null;
        BitSet bsOldPool = null;
        try {
            if (null != this.m_VerData.getVerBasic()) {
                bsOldEqLDEV = this.getOldEqLDEV(this.m_VerData.getVerBasic());
            }
            if (null != this.m_VerData.getVerPool()) {
                bsOldPool = this.getOldEqPool(this.m_VerData.getVerPool());
            }
            if (null != this.m_VerData_ex.getVerBasic()) {
                diffVer.setDiffVerBasic(this.makeVerBasic(this.m_VerData_ex.getVerBasic()));
                if (null != this.m_VerData_ex.getVerAou()) {
                    SJmoDiffVerAou diffVerAou = this.makeVerAou(this.m_VerData_ex.getVerAou());
                    if (null != diffVerAou) {
                        diffVer.setDiffVerAou(diffVerAou);
                    } else {
                        SJmoUtility.putLogDetail("SJmoVersionMgr", "makeVerDiffList", "diffVerAou is null");
                    }
                }
                if (null != this.m_VerData_ex.getVerPool()) {
                    SJmoDiffVerPool diffVerPool = this.makeVerPool(this.m_VerData_ex.getVerPool());
                    if (null != diffVerPool) {
                        diffVer.setDiffVerPool(diffVerPool);
                        SJmoUtility.putLogDetail("SJmoVersionMgr", "makeVerDiffList", "get Equip Inf(POOL:" + diffVer.getDiffVerPool().getBsEqPool().cardinality() + ")");
                    } else {
                        SJmoUtility.putLogDetail("SJmoVersionMgr", "makeVerDiffList", "diffVerPool is null");
                    }
                }
                if (null != this.m_VerData_ex.getVerOdgd()) {
                    diffVer.setDiffVerOdgd(this.makeVerOdgd(this.m_VerData_ex.getVerOdgd()));
                }
                if (null != this.m_VerData_ex.getVerUvm()) {
                    diffVer.setDiffVerUvm(this.makeVerUvm(this.m_VerData_ex.getVerUvm()));
                }
                if (null != this.m_VerData_ex.getVerUuid()) {
                    diffVer.setDiffVerUuid(this.makeVerUuid(this.m_VerData_ex.getVerUuid()));
                }
                if (null != this.m_VerData_ex.getVerNickname()) {
                    diffVer.setDiffVerNickname(this.makeDiffVerNickname(this.m_VerData_ex.getVerNickname()));
                }
                if (null != this.m_VerData_ex.getVerHur()) {
                    diffVer.setDiffVerHur(this.makeDiffVerHur(this.m_VerData_ex.getVerHur()));
                }
                if (null != this.m_VerData_ex.getVerSi()) {
                    diffVer.setDiffVerSi(this.makeDiffVerSi(this.m_VerData_ex.getVerSi()));
                }
                if (null != this.m_VerData_ex.getVerRmcp()) {
                    diffVer.setDiffVerRmcp(this.makeDiffVerRmcp(this.m_VerData_ex.getVerRmcp()));
                }
                if (null != this.m_VerData_ex.getVerHA()) {
                    diffVer.setDiffVerHA(this.makeDiffVerHA(this.m_VerData_ex.getVerHA()));
                }
                if (null == this.m_VerData.getVerSummary() || !this.m_VerData.isBEnable()) {
                    diffVer.setBDiffVerCache(true);
                    diffVer.setBDiffVerPpc(true);
                    diffVer.setBDiffVerRsg(true);
                    diffVer.setBDiffVerFcoe(true);
                    diffVer.setBDiffVerVirIDs(true);
                    diffVer.setBDiffVerSnapshotSet(true);
                    diffVer.setBDiffVerHuvm(true);
                    diffVer.setBDiffVerQuorum(true);
                } else {
                    if (this.m_VerData.getVerSummary().getNVer(100728842) != this.m_VerData_ex.getVerSummary().getNVer(100728842)) {
                        SJmoUtility.putLogDetail("SJmoVersionMgr", "makeVerDiffList", "CACHE Version Differrence old:" + this.m_VerData.getVerSummary().getNVer(100728842) + " new:" + this.m_VerData_ex.getVerSummary().getNVer(100728842));
                        diffVer.setBDiffVerCache(true);
                    }
                    if (this.m_VerData.getVerSummary().getNVer(369164290) != this.m_VerData_ex.getVerSummary().getNVer(369164290)) {
                        SJmoUtility.putLogDetail("SJmoVersionMgr", "makeVerDiffList", "PPC Version Differrence old:" + this.m_VerData.getVerSummary().getNVer(369164290) + " new:" + this.m_VerData_ex.getVerSummary().getNVer(369164290));
                        diffVer.setBDiffVerPpc(true);
                    }
                    if (this.m_VerData.getVerSummary().getNVer(100794369) != this.m_VerData_ex.getVerSummary().getNVer(100794369)) {
                        SJmoUtility.putLogDetail("SJmoVersionMgr", "makeVerDiffList", "RSG Version Differrence old:" + this.m_VerData.getVerSummary().getNVer(100794369) + " new:" + this.m_VerData_ex.getVerSummary().getNVer(100794369));
                        diffVer.setBDiffVerRsg(true);
                    }
                    if (this.m_VerData.getVerSummary().getNVer(0x6020002) != this.m_VerData_ex.getVerSummary().getNVer(0x6020002)) {
                        SJmoUtility.putLogDetail("SJmoVersionMgr", "makeVerDiffList", "FCOE Version Differrence old:" + this.m_VerData.getVerSummary().getNVer(0x6020002) + " new:" + this.m_VerData_ex.getVerSummary().getNVer(0x6020002));
                        diffVer.setBDiffVerFcoe(true);
                    }
                    if (this.m_VerData.getVerSummary().getNVer(100794625) != this.m_VerData_ex.getVerSummary().getNVer(100794625)) {
                        SJmoUtility.putLogDetail("SJmoVersionMgr", "makeVerDiffList", "VIRUALID Version Differrence old:" + this.m_VerData.getVerSummary().getNVer(100794625) + " new:" + this.m_VerData_ex.getVerSummary().getNVer(100794625));
                        diffVer.setBDiffVerVirIDs(true);
                    }
                    if (this.m_VerData.getVerSummary().getNVer(117768193) != this.m_VerData_ex.getVerSummary().getNVer(117768193)) {
                        SJmoUtility.putLogDetail("SJmoVersionMgr", "makeVerDiffList", "SNAPSHOT_SET Version Differrence old:" + this.m_VerData.getVerSummary().getNVer(117768193) + " new:" + this.m_VerData_ex.getVerSummary().getNVer(117768193));
                        diffVer.setBDiffVerSnapshotSet(true);
                    }
                    if (this.m_VerData.getVerSummary().getNVer(0x8010001) != this.m_VerData_ex.getVerSummary().getNVer(0x8010001)) {
                        SJmoUtility.putLogDetail("SJmoVersionMgr", "makeVerDiffList", "HUVM Version Differrence old:" + this.m_VerData.getVerSummary().getNVer(0x8010001) + " new:" + this.m_VerData_ex.getVerSummary().getNVer(0x8010001));
                        diffVer.setBDiffVerHuvm(true);
                    }
                    if (this.m_VerData.getVerSummary().getNVer(134283778) != this.m_VerData_ex.getVerSummary().getNVer(134283778)) {
                        SJmoUtility.putLogDetail("SJmoVersionMgr", "makeVerDiffList", "QUORUM_ID Version Differrence old:" + this.m_VerData.getVerSummary().getNVer(134283778) + " new:" + this.m_VerData_ex.getVerSummary().getNVer(134283778));
                        diffVer.setBDiffVerQuorum(true);
                    }
                }
                if (null != bsOldEqLDEV) {
                    this.makeEquipDiffCU(diffVer, bsOldEqLDEV);
                }
                if (null != bsOldPool) {
                    this.makeEquipDiffPool(diffVer, bsOldPool);
                }
                SJmoUtility.putLogDetail("SJmoVersionMgr", "makeVerDiffList", "get Equip Inf(CU:" + diffVer.getDiffVerBasic().getBsEqCU().cardinality() + ")");
                SJmoUtility.putLogDetail("SJmoVersionMgr", "makeVerDiffList", "get Equip Inf(LDEV:" + diffVer.getDiffVerBasic().getBsEqLDEV().cardinality() + ")");
                SJmoUtility.putLogDetail("SJmoVersionMgr", "makeVerDiffList", "get Equip Inf(PG:" + diffVer.getDiffVerBasic().getAlEqPG().size() + ")");
                SJmoUtility.putLogDetail("SJmoVersionMgr", "makeVerDiffList", "get Equip Inf(Port:" + diffVer.getDiffVerBasic().getBsEqPort().cardinality() + ")");
            }
        }
        catch (Exception exp) {
            SJmoUtility.putLogDetail("SJmoVersionMgr", "makeVerDiffList", "VerDiffList make Filed" + exp.toString());
            diffVer = null;
        }
        return diffVer;
    }

    private void makeEquipDiffCU(SJmoDiffVersion diffVer, BitSet bsOldEqLDEV) {
        int iLpCnt = 0;
        int iModNum = 0;
        if (null == diffVer.getDiffVerAou()) {
            diffVer.setDiffVerAou(new SJmoDiffVerAou());
        }
        if (null == diffVer.getDiffVerOdgd()) {
            diffVer.setDiffVerOdgd(new SJmoDiffVerOdgd());
        }
        if (null == diffVer.getDiffVerUuid()) {
            diffVer.setDiffVerUuid(new SJmoDiffVerUuid());
        }
        if (null == diffVer.getDiffVerNickname()) {
            diffVer.setDiffVerNickname(new SJmoDiffVerNickname());
        }
        if (null == diffVer.getDiffVerHur()) {
            diffVer.setDiffVerHur(new SJmoDiffVerHur());
        }
        for (iLpCnt = 0; iLpCnt < SJmoDataMacro_IF.MAX_EQIP_LDEV_LDKC; ++iLpCnt) {
            if (diffVer.getDiffVerBasic().getBsEqLDEV().get(iLpCnt) == bsOldEqLDEV.get(iLpCnt)) continue;
            diffVer.getDiffVerAou().getBsVerLDEVPerCU().set(iLpCnt / SJmoDataMacro_IF.MAX_LDEV_CU);
            diffVer.getDiffVerOdgd().getBsVerLDEVPerCU().set(iLpCnt / SJmoDataMacro_IF.MAX_LDEV_CU);
            diffVer.getDiffVerUuid().getBsVerLDEVPerCU().set(iLpCnt / SJmoDataMacro_IF.MAX_LDEV_CU);
            diffVer.getDiffVerNickname().getBsVerLDEVPerCU().set(iLpCnt / SJmoDataMacro_IF.MAX_LDEV_CU);
            ++iModNum;
        }
        SJmoUtility.putLogDetail("SJmoVersionMgr", "makeEquipDiffCU", "LDEV Eqip Mod Num:" + iModNum);
    }

    private void makeEquipDiffPool(SJmoDiffVersion diffVer, BitSet bsOldEqPool) {
        int iLpCnt = 0;
        if (null == diffVer.getDiffVerNickname()) {
            diffVer.setDiffVerNickname(new SJmoDiffVerNickname());
        }
        for (iLpCnt = 0; iLpCnt < SJmoDataMacro_IF.MAX_POOL_LDKC; ++iLpCnt) {
            if (diffVer.getDiffVerPool().getBsEqPool().get(iLpCnt) == bsOldEqPool.get(iLpCnt)) continue;
            diffVer.getDiffVerNickname().setBVerAllPool(true);
            SJmoUtility.putLogDetail("SJmoVersionMgr", "makeEquipDiffPool", "Pool Equip Mod");
            break;
        }
    }

    private SJmoDiffVerBasic makeVerBasic(BASICVer verBasic) {
        int iLpCnt = 0;
        int iLpCnt2 = 0;
        int iChk = 0;
        BASICVerAllLDEV verAllLdev = null;
        Robj_interface_BASICVerLDEVPerCU[] verCu = null;
        Robj_interface_BASICVerLDEV[] verLdev = null;
        BASICVerAllPG verAllPg = null;
        Robj_interface_VerLeaf[] verPg = null;
        Robj_interface_VerLeaf[] verNormalPg = null;
        Robj_interface_VerLeaf[] verVirtualPg = null;
        BASICVerAllPort verAllPort = null;
        Robj_interface_BASICVerPort[] verPort = null;
        BASICVerAllLUPath verAllLu = null;
        Robj_interface_BASICVerLUPathPerPort[] verPortLu = null;
        BASICVerAllLDEV oldVerAllLdev = null;
        Robj_interface_BASICVerLDEVPerCU[] oldVerCu = null;
        Robj_interface_BASICVerLDEV[] oldVerLdev = null;
        BASICVerAllPG oldVerAllPg = null;
        Object oldVerPg = null;
        Robj_interface_VerLeaf[] oldVerNormalPg = null;
        Robj_interface_VerLeaf[] oldVerVirtualPg = null;
        BASICVerAllPort oldVerAllPort = null;
        Robj_interface_BASICVerPort[] oldVerPort = null;
        BASICVerAllLUPath oldVerAllLu = null;
        Robj_interface_BASICVerLUPathPerPort[] oldVerPortLu = null;
        SJmoDiffVerBasic diffVerBasic = new SJmoDiffVerBasic();
        try {
            Robj_interface_VerLeaf[] verLeaf = this.m_VerData_ex.getVerBasic().getObjChildren();
            SJmoUtility.putLogDetail("SJmoVersionMgr", "makeVerBasic", "BASIC Version kind:" + verLeaf.length);
            BitSet bsEqLdev = new BitSet(SJmoDataMacro_IF.MAX_EQIP_LDEV_LDKC);
            BitSet bsEqCu = new BitSet(SJmoDataMacro_IF.CUMAX_LDKC);
            verAllLdev = (BASICVerAllLDEV)verLeaf[0];
            verCu = (Robj_interface_BASICVerLDEVPerCU[])verAllLdev.getObjChildren();
            for (iLpCnt = 0; iLpCnt < SJmoDataMacro_IF.CUMAX_LDKC; ++iLpCnt) {
                if (null == verCu[iLpCnt]) continue;
                bsEqCu.set(iLpCnt);
                verLdev = (Robj_interface_BASICVerLDEV[])verCu[iLpCnt].getObjChildren();
                for (iLpCnt2 = 0; iLpCnt2 < SJmoDataMacro_IF.MAX_LDEV_CU; ++iLpCnt2) {
                    if (null == verLdev[iLpCnt2]) continue;
                    bsEqLdev.set(iLpCnt * SJmoDataMacro_IF.MAX_LDEV_CU + iLpCnt2);
                }
            }
            ArrayList<Robj_interface_RJiPGIndex> alEqPg = new ArrayList<Robj_interface_RJiPGIndex>();
            verAllPg = (BASICVerAllPG)verLeaf[1];
            verPg = verAllPg.getObjChildren();
            for (iLpCnt = 0; iLpCnt < SJmoDataMacro_IF.MAX_PGNUM + 1; ++iLpCnt) {
                if (null == verPg[iLpCnt]) continue;
                if (verPg[iLpCnt] instanceof BASICVerNormalPG) {
                    alEqPg.add(((BASICVerNormalPG)verPg[iLpCnt]).getIndex());
                }
                if (!(verPg[iLpCnt] instanceof BASICVerVirtualPG)) continue;
                alEqPg.add(((BASICVerVirtualPG)verPg[iLpCnt]).getIndex());
            }
            Collections.sort(alEqPg);
            BitSet bsEqPort = new BitSet(SJmoDataMacro_IF.NUM_MAX_PORT_LDKC + 1);
            verAllPort = (BASICVerAllPort)verLeaf[2];
            verPort = (Robj_interface_BASICVerPort[])verAllPort.getObjChildren();
            for (iLpCnt = 0; iLpCnt < SJmoDataMacro_IF.NUM_MAX_PORT_LDKC + 1; ++iLpCnt) {
                if (null == verPort[iLpCnt]) continue;
                bsEqPort.set(iLpCnt);
            }
            if (null != this.m_VerData.getVerBasic() && this.m_VerData.isBEnable()) {
                if (this.m_VerData.getVerBasic().getNVer() != verBasic.getNVer() || this.m_VerData.getVerBasic().getNSummaryVer() != verBasic.getNSummaryVer()) {
                    SJmoUtility.putLogDetail("SJmoVersionMgr", "makeVerBasic", "BASIC Version  old:" + this.m_VerData.getVerBasic().getNVer() + " new:" + verBasic.getNVer());
                    SJmoUtility.putLogDetail("SJmoVersionMgr", "makeVerBasic", "BASIC SummaryVersion old:" + this.m_VerData.getVerBasic().getNSummaryVer() + " new:" + verBasic.getNSummaryVer());
                    diffVerBasic.setBBasicVer(true);
                    Robj_interface_VerLeaf[] oldVerLeaf = this.m_VerData.getVerBasic().getObjChildren();
                    if (oldVerLeaf[0].getNVer() != verLeaf[0].getNVer()) {
                        SJmoUtility.putLogDetail("SJmoVersionMgr", "makeVerBasic", "BASIC AllLDEV Version is Difference old:" + oldVerLeaf[0].getNVer() + ",new" + verLeaf[0].getNVer());
                        diffVerBasic.setBVerAllLdev(true);
                    }
                    oldVerAllLdev = (BASICVerAllLDEV)oldVerLeaf[0];
                    if (verAllLdev.getNSummaryVer() != oldVerAllLdev.getNSummaryVer()) {
                        diffVerBasic.setBVerAllLdev(true);
                        SJmoUtility.putLogDetail("SJmoVersionMgr", "makeVerBasic", "BASIC AllLDEV Summary Version is Difference old:" + oldVerAllLdev.getNSummaryVer() + ",new:" + verAllLdev.getNSummaryVer());
                        oldVerCu = (Robj_interface_BASICVerLDEVPerCU[])oldVerAllLdev.getObjChildren();
                        block12: for (iLpCnt = 0; iLpCnt < SJmoDataMacro_IF.CUMAX_LDKC; ++iLpCnt) {
                            iChk = this.chkVerDiff(oldVerCu[iLpCnt], verCu[iLpCnt]);
                            switch (iChk) {
                                case 1: {
                                    diffVerBasic.getBsVerLDEVPerCU().set(iLpCnt);
                                    if (oldVerCu[iLpCnt].getNSummaryVer() == verCu[iLpCnt].getNSummaryVer()) continue block12;
                                    oldVerLdev = (Robj_interface_BASICVerLDEV[])oldVerCu[iLpCnt].getObjChildren();
                                    verLdev = (Robj_interface_BASICVerLDEV[])verCu[iLpCnt].getObjChildren();
                                    for (iLpCnt2 = 0; iLpCnt2 < SJmoDataMacro_IF.MAX_LDEV_CU; ++iLpCnt2) {
                                        iChk = this.chkVerDiff(oldVerLdev[iLpCnt2], verLdev[iLpCnt2]);
                                        if (0 == iChk) continue;
                                        diffVerBasic.getBsVerLDEV().set(SJmoDataMacro_IF.MAX_LDEV_CU * iLpCnt + iLpCnt2);
                                    }
                                    continue block12;
                                }
                                case 2: {
                                    diffVerBasic.getBsVerLDEVPerCU().set(iLpCnt);
                                    verLdev = (Robj_interface_BASICVerLDEV[])verCu[iLpCnt].getObjChildren();
                                    for (iLpCnt2 = 0; iLpCnt2 < SJmoDataMacro_IF.MAX_LDEV_CU; ++iLpCnt2) {
                                        if (null == verLdev[iLpCnt2]) continue;
                                        diffVerBasic.getBsVerLDEV().set(SJmoDataMacro_IF.MAX_LDEV_CU * iLpCnt + iLpCnt2);
                                    }
                                    continue block12;
                                }
                                case 3: {
                                    diffVerBasic.getBsVerLDEVPerCU().set(iLpCnt);
                                    oldVerLdev = (Robj_interface_BASICVerLDEV[])oldVerCu[iLpCnt].getObjChildren();
                                    for (iLpCnt2 = 0; iLpCnt2 < SJmoDataMacro_IF.MAX_LDEV_CU; ++iLpCnt2) {
                                        if (null == oldVerLdev[iLpCnt2]) continue;
                                        diffVerBasic.getBsVerLDEV().set(SJmoDataMacro_IF.MAX_LDEV_CU * iLpCnt + iLpCnt2);
                                    }
                                    continue block12;
                                }
                                case 0: {
                                    if (null == oldVerCu[iLpCnt] || null == verCu[iLpCnt] || oldVerCu[iLpCnt].getNSummaryVer() == verCu[iLpCnt].getNSummaryVer()) continue block12;
                                    oldVerLdev = (Robj_interface_BASICVerLDEV[])oldVerCu[iLpCnt].getObjChildren();
                                    verLdev = (Robj_interface_BASICVerLDEV[])verCu[iLpCnt].getObjChildren();
                                    for (iLpCnt2 = 0; iLpCnt2 < SJmoDataMacro_IF.MAX_LDEV_CU; ++iLpCnt2) {
                                        iChk = this.chkVerDiff(oldVerLdev[iLpCnt2], verLdev[iLpCnt2]);
                                        if (0 == iChk) continue;
                                        diffVerBasic.getBsVerLDEV().set(SJmoDataMacro_IF.MAX_LDEV_CU * iLpCnt + iLpCnt2);
                                    }
                                    continue block12;
                                }
                            }
                        }
                    }
                    if (oldVerLeaf[1].getNVer() != verLeaf[1].getNVer()) {
                        SJmoUtility.putLogDetail("SJmoVersionMgr", "makeVerBasic", "BASIC AllPG Version is Differrence old:" + oldVerLeaf[1].getNVer() + ",new:" + verLeaf[1].getNVer());
                        diffVerBasic.setBVerAllPG(true);
                    }
                    verAllPg = (BASICVerAllPG)verLeaf[1];
                    oldVerAllPg = (BASICVerAllPG)oldVerLeaf[1];
                    if (verAllPg.getNSummaryVer() != oldVerAllPg.getNSummaryVer()) {
                        diffVerBasic.setBVerAllPG(true);
                        SJmoUtility.putLogDetail("SJmoVersionMgr", "makeVerBasic", "BASIC AllPG Summary Version is Difference old:" + oldVerAllPg.getNSummaryVer() + ",new:" + verAllPg.getNSummaryVer());
                        verNormalPg = verAllPg.getObjChildren();
                        oldVerNormalPg = oldVerAllPg.getObjChildren();
                        ArrayList<Robj_interface_RJiPGIndex> alNewVer = new ArrayList<Robj_interface_RJiPGIndex>();
                        HashMap<String, VerBranch> hNewVer = new HashMap<String, VerBranch>();
                        ArrayList<Robj_interface_RJiPGIndex> alOldVer = new ArrayList<Robj_interface_RJiPGIndex>();
                        HashMap<String, VerBranch> hOldVer = new HashMap<String, VerBranch>();
                        for (iLpCnt = 0; iLpCnt < 2048; ++iLpCnt) {
                            if (null != verNormalPg[iLpCnt]) {
                                BASICVerNormalPG verOnePG = (BASICVerNormalPG)verNormalPg[iLpCnt];
                                alNewVer.add(verOnePG.getIndex());
                                hNewVer.put(verOnePG.getIndex().toString(), verOnePG);
                            }
                            if (null == oldVerNormalPg[iLpCnt]) continue;
                            BASICVerNormalPG oldVerOnePG = (BASICVerNormalPG)oldVerNormalPg[iLpCnt];
                            alOldVer.add(oldVerOnePG.getIndex());
                            hOldVer.put(oldVerOnePG.getIndex().toString(), oldVerOnePG);
                        }
                        Collections.sort(alOldVer);
                        for (iLpCnt = 0; iLpCnt < alNewVer.size(); ++iLpCnt) {
                            int iSerch = Collections.binarySearch(alOldVer, alNewVer.get(iLpCnt));
                            if (0 <= iSerch) {
                                if (((BASICVerNormalPG)hNewVer.get(((Robj_interface_RJiPGIndex)alNewVer.get(iLpCnt)).toString())).getNVer() != ((BASICVerNormalPG)hOldVer.get(((Robj_interface_RJiPGIndex)alOldVer.get(iSerch)).toString())).getNVer()) {
                                    diffVerBasic.getAlVerNormalPG().add(alNewVer.get(iLpCnt));
                                }
                                if (((BASICVerNormalPG)hNewVer.get(((Robj_interface_RJiPGIndex)alNewVer.get(iLpCnt)).toString())).getNSummaryVer() != ((BASICVerNormalPG)hOldVer.get(((Robj_interface_RJiPGIndex)alOldVer.get(iSerch)).toString())).getNSummaryVer()) {
                                    diffVerBasic.getAlVerLDEVInNormalPG().add(alNewVer.get(iLpCnt));
                                }
                                alOldVer.remove(iSerch);
                                continue;
                            }
                            diffVerBasic.getAlVerNormalPG().add(alNewVer.get(iLpCnt));
                            diffVerBasic.getAlVerLDEVInNormalPG().add(alNewVer.get(iLpCnt));
                        }
                        for (iLpCnt = 0; iLpCnt < alOldVer.size(); ++iLpCnt) {
                            diffVerBasic.getAlVerNormalPG().add(alOldVer.get(iLpCnt));
                            diffVerBasic.getAlVerLDEVInNormalPG().add(alOldVer.get(iLpCnt));
                        }
                        Collections.sort(diffVerBasic.getAlVerNormalPG());
                        Collections.sort(diffVerBasic.getAlVerLDEVInNormalPG());
                        verVirtualPg = verAllPg.getObjChildren();
                        oldVerVirtualPg = oldVerAllPg.getObjChildren();
                        alNewVer = new ArrayList();
                        hNewVer.clear();
                        alOldVer = new ArrayList();
                        hOldVer.clear();
                        for (iLpCnt = 2048; iLpCnt < SJmoDataMacro_IF.MAX_PGNUM + 1; ++iLpCnt) {
                            if (null != verVirtualPg[iLpCnt]) {
                                BASICVerVirtualPG verVOnePG = (BASICVerVirtualPG)verVirtualPg[iLpCnt];
                                alNewVer.add(verVOnePG.getIndex());
                                hNewVer.put(verVOnePG.getIndex().toString(), verVOnePG);
                            }
                            if (null == oldVerVirtualPg[iLpCnt]) continue;
                            BASICVerVirtualPG oldVerVOnePG = (BASICVerVirtualPG)oldVerVirtualPg[iLpCnt];
                            alOldVer.add(oldVerVOnePG.getIndex());
                            hOldVer.put(oldVerVOnePG.getIndex().toString(), oldVerVOnePG);
                        }
                        Collections.sort(alOldVer);
                        for (iLpCnt = 0; iLpCnt < alNewVer.size(); ++iLpCnt) {
                            int iSerch = Collections.binarySearch(alOldVer, alNewVer.get(iLpCnt));
                            if (0 <= iSerch) {
                                if (((BASICVerVirtualPG)hNewVer.get(((Robj_interface_RJiPGIndex)alNewVer.get(iLpCnt)).toString())).getNVer() != ((BASICVerVirtualPG)hOldVer.get(((Robj_interface_RJiPGIndex)alOldVer.get(iSerch)).toString())).getNVer()) {
                                    diffVerBasic.getAlVerVirtualPG().add(alNewVer.get(iLpCnt));
                                }
                                if (((BASICVerVirtualPG)hNewVer.get(((Robj_interface_RJiPGIndex)alNewVer.get(iLpCnt)).toString())).getNSummaryVer() != ((BASICVerVirtualPG)hOldVer.get(((Robj_interface_RJiPGIndex)alOldVer.get(iSerch)).toString())).getNSummaryVer()) {
                                    diffVerBasic.getAlVerLDEVInVirtualPG().add(alNewVer.get(iLpCnt));
                                }
                                alOldVer.remove(iSerch);
                                continue;
                            }
                            diffVerBasic.getAlVerVirtualPG().add(alNewVer.get(iLpCnt));
                            diffVerBasic.getAlVerLDEVInVirtualPG().add(alNewVer.get(iLpCnt));
                        }
                        for (iLpCnt = 0; iLpCnt < alOldVer.size(); ++iLpCnt) {
                            diffVerBasic.getAlVerVirtualPG().add(alOldVer.get(iLpCnt));
                            diffVerBasic.getAlVerLDEVInVirtualPG().add(alOldVer.get(iLpCnt));
                        }
                        Collections.sort(diffVerBasic.getAlVerVirtualPG());
                        Collections.sort(diffVerBasic.getAlVerLDEVInVirtualPG());
                    }
                    if (oldVerLeaf[2].getNVer() != verLeaf[2].getNVer()) {
                        SJmoUtility.putLogDetail("SJmoVersionMgr", "makeVerBasic", "BASIC AllPort Version is Differenc old:" + oldVerLeaf[2].getNVer() + ",new:" + verLeaf[2].getNVer());
                        diffVerBasic.setBVerAllPort(true);
                    }
                    verAllPort = (BASICVerAllPort)verLeaf[2];
                    oldVerAllPort = (BASICVerAllPort)oldVerLeaf[2];
                    if (verAllPort.getNSummaryVer() != oldVerAllPort.getNSummaryVer()) {
                        SJmoUtility.putLogDetail("SJmoVersionMgr", "makeVerBasic", "BASIC AllPort Summary Version is Difference old:" + oldVerAllPort.getNSummaryVer() + ",new:" + verAllPort.getNSummaryVer());
                        verPort = (Robj_interface_BASICVerPort[])verAllPort.getObjChildren();
                        oldVerPort = (Robj_interface_BASICVerPort[])oldVerAllPort.getObjChildren();
                        for (iLpCnt = 0; iLpCnt < SJmoDataMacro_IF.NUM_MAX_PORT_LDKC + 1; ++iLpCnt) {
                            iChk = this.chkVerDiff(oldVerPort[iLpCnt], verPort[iLpCnt]);
                            if (0 == iChk) continue;
                            diffVerBasic.getBsVerPort().set(iLpCnt);
                        }
                    }
                    if (oldVerLeaf[3].getNVer() != verLeaf[3].getNVer()) {
                        SJmoUtility.putLogDetail("SJmoVersionMgr", "makeVerBasic", "BASIC AllPort LuPath Version is Difference old:" + oldVerLeaf[3].getNVer() + ",new:" + verLeaf[3].getNVer());
                        diffVerBasic.setBVerAllLUPath(true);
                    }
                    verAllLu = (BASICVerAllLUPath)verLeaf[3];
                    oldVerAllLu = (BASICVerAllLUPath)oldVerLeaf[3];
                    if (verAllLu.getNSummaryVer() != oldVerAllLu.getNSummaryVer()) {
                        SJmoUtility.putLogDetail("SJmoVersionMgr", "makeVerBasic", "BASIC AllLu Summary Version is Difference old:" + oldVerAllLu.getNSummaryVer() + ",new:" + verAllLu.getNSummaryVer());
                        verPortLu = (Robj_interface_BASICVerLUPathPerPort[])verAllLu.getObjChildren();
                        oldVerPortLu = (Robj_interface_BASICVerLUPathPerPort[])oldVerAllLu.getObjChildren();
                        for (iLpCnt = 0; iLpCnt < SJmoDataMacro_IF.NUM_MAX_PORT_LDKC + 1; ++iLpCnt) {
                            iChk = this.chkVerDiff(oldVerPortLu[iLpCnt], verPortLu[iLpCnt]);
                            if (0 == iChk) continue;
                            diffVerBasic.getBsVerLUPathPerPort().set(iLpCnt);
                        }
                    }
                    if (oldVerLeaf[4].getNVer() != verLeaf[4].getNVer()) {
                        SJmoUtility.putLogDetail("SJmoVersionMgr", "makeVerBasic", "BASIC AllLuse Version is Difference old:" + oldVerLeaf[4].getNVer() + ",new:" + verLeaf[4].getNVer());
                        diffVerBasic.setBVerAllLUSE(true);
                    }
                    if (oldVerLeaf[5].getNVer() != verLeaf[5].getNVer()) {
                        SJmoUtility.putLogDetail("SJmoVersionMgr", "makeVerBasic", "BASIC CHA Version is Difference old:" + oldVerLeaf[5].getNVer() + ",new:" + verLeaf[5].getNVer());
                        diffVerBasic.setBVerAllCHA(true);
                    }
                    if (oldVerLeaf[6].getNVer() != verLeaf[6].getNVer()) {
                        SJmoUtility.putLogDetail("SJmoVersionMgr", "makeVerBasic", "BASIC License Version is Difference old:" + oldVerLeaf[6].getNVer() + ",new:" + verLeaf[6].getNVer());
                        diffVerBasic.setBVerAllLisence(true);
                    }
                    if (oldVerLeaf[7].getNVer() != verLeaf[7].getNVer()) {
                        SJmoUtility.putLogDetail("SJmoVersionMgr", "makeVerBasic", "BASIC DKA Version is Difference old:" + oldVerLeaf[7].getNVer() + ",new:" + verLeaf[7].getNVer());
                        diffVerBasic.setBVerAllDKA(true);
                    }
                    if (oldVerLeaf[8].getNVer() != verLeaf[8].getNVer()) {
                        SJmoUtility.putLogDetail("SJmoVersionMgr", "makeVerBasic", "BASIC MPPCB Version is Difference old:" + oldVerLeaf[8].getNVer() + ",new:" + verLeaf[8].getNVer());
                        diffVerBasic.setBVerAllMPPCB(true);
                    }
                    if (oldVerLeaf[9].getNVer() != verLeaf[9].getNVer()) {
                        SJmoUtility.putLogDetail("SJmoVersionMgr", "makeVerBasic", "BASIC CACHE Version is Difference old:" + oldVerLeaf[9].getNVer() + ",new:" + verLeaf[9].getNVer());
                        diffVerBasic.setBVerAllCACHE(true);
                    }
                }
            } else {
                diffVerBasic.setAllVerDiffEnable();
                SJmoUtility.putLogDetail("SJmoVersionMgr", "makeVerBasic", "BasicVer is All Diff(Version Data is false)");
            }
            diffVerBasic.setBsEqCU(bsEqCu);
            diffVerBasic.setBsEqLDEV(bsEqLdev);
            diffVerBasic.setAlEqPG(alEqPg);
            diffVerBasic.setBsEqPort(bsEqPort);
        }
        catch (Exception exp) {
            SJmoUtility.putLogDetail("SJmoVersionMgr", "makeVerBasic", "makeBasicVerDiff is Failed:" + exp.getMessage());
        }
        return diffVerBasic;
    }

    private BitSet getOldEqLDEV(Robj_interface_BASICVer oldBasicVer) {
        BitSet bsOldEqLDEV = new BitSet(SJmoDataMacro_IF.MAX_EQIP_LDEV_LDKC);
        int iLpCnt = 0;
        int iLpCnt2 = 0;
        try {
            Robj_interface_VerLeaf[] verLeaf = oldBasicVer.getObjChildren();
            BASICVerAllLDEV verAllLdev = (BASICVerAllLDEV)verLeaf[0];
            Robj_interface_BASICVerLDEVPerCU[] verCu = (Robj_interface_BASICVerLDEVPerCU[])verAllLdev.getObjChildren();
            for (iLpCnt = 0; iLpCnt < SJmoDataMacro_IF.CUMAX_LDKC; ++iLpCnt) {
                if (null == verCu[iLpCnt]) continue;
                Robj_interface_BASICVerLDEV[] verLdev = (Robj_interface_BASICVerLDEV[])verCu[iLpCnt].getObjChildren();
                for (iLpCnt2 = 0; iLpCnt2 < SJmoDataMacro_IF.MAX_LDEV_CU; ++iLpCnt2) {
                    if (null == verLdev[iLpCnt2]) continue;
                    bsOldEqLDEV.set(iLpCnt * SJmoDataMacro_IF.MAX_LDEV_CU + iLpCnt2);
                }
            }
        }
        catch (Exception exp) {
            SJmoUtility.putLogDetail("SJmoVersionMgr", "getOldEqLDEV", "getOldEqLDEV is Failed:" + exp.toString());
        }
        return bsOldEqLDEV;
    }

    private BitSet getOldEqPool(POOLVer verPoolVer) {
        BitSet bsEqPool = new BitSet(SJmoDataMacro_IF.MAX_POOL_LDKC);
        int iLpCnt = 0;
        Robj_interface_POOLVerAllPool[] verAllPool = null;
        Robj_interface_POOLVerPool[] verPool = null;
        try {
            verAllPool = (Robj_interface_POOLVerAllPool[])verPoolVer.getObjChildren();
            if (null != verAllPool) {
                verPool = (Robj_interface_POOLVerPool[])verAllPool[0].getObjChildren();
                for (iLpCnt = 0; iLpCnt < SJmoDataMacro_IF.MAX_POOL_LDKC; ++iLpCnt) {
                    if (null == verPool[iLpCnt]) continue;
                    bsEqPool.set(iLpCnt);
                }
            }
        }
        catch (Exception exp) {
            SJmoUtility.putLogDetail("SJmoVersionMgr", "getOldEqPool", "getOldEqPool is Failed:" + exp.toString());
        }
        return bsEqPool;
    }

    private SJmoDiffVerAou makeVerAou(AOUConfVer verAou) {
        SJmoDiffVerAou diffVerAou = new SJmoDiffVerAou();
        int iLpCnt = 0;
        int iChk = 0;
        AOUConfVerAllLDEV[] verAllLdev = null;
        AOUConfVerLDEVPerCU[] verCu = null;
        AOUConfVerAllLDEV[] oldVerAllLdev = null;
        AOUConfVerLDEVPerCU[] oldVerCu = null;
        try {
            AOUConfVer oldVerAou = this.m_VerData.getVerAou();
            if (this.m_VerData.isBEnable() && null != oldVerAou) {
                if (oldVerAou.getNVer() != verAou.getNVer()) {
                    diffVerAou.setBAouVer(true);
                }
                if (oldVerAou.getNSummaryVer() != verAou.getNSummaryVer()) {
                    diffVerAou.setBAouVer(true);
                    verAllLdev = (AOUConfVerAllLDEV[])verAou.getObjChildren();
                    oldVerAllLdev = (AOUConfVerAllLDEV[])oldVerAou.getObjChildren();
                    if (oldVerAllLdev[0].getNVer() != verAllLdev[0].getNVer()) {
                        diffVerAou.setBVerAllLDEV(true);
                    }
                    if (oldVerAllLdev[0].getNSummaryVer() != verAllLdev[0].getNSummaryVer()) {
                        verCu = (AOUConfVerLDEVPerCU[])verAllLdev[0].getObjChildren();
                        oldVerCu = (AOUConfVerLDEVPerCU[])oldVerAllLdev[0].getObjChildren();
                        for (iLpCnt = 0; iLpCnt < SJmoDataMacro_IF.CUMAX_LDKC; ++iLpCnt) {
                            iChk = this.chkVerDiff(oldVerCu[iLpCnt], verCu[iLpCnt]);
                            if (0 == iChk) continue;
                            diffVerAou.getBsVerLDEVPerCU().set(iLpCnt);
                        }
                    }
                }
            } else {
                SJmoUtility.putLogDetail("SJmoVersionMgr", "makeVerAou", "AouVer is All Diff(Version Data is false)");
                diffVerAou.setAllVerDiffEnable();
            }
        }
        catch (Exception exp) {
            SJmoUtility.putLogDetail("SJmoVersionMgr", "makeVerAou", "makeAouVerDiff is Failed:" + exp.getMessage());
        }
        return diffVerAou;
    }

    private SJmoDiffVerPool makeVerPool(POOLVer verPoolVer) {
        SJmoDiffVerPool diffVerPool = new SJmoDiffVerPool();
        BitSet bsEqPool = new BitSet(SJmoDataMacro_IF.MAX_POOL_LDKC);
        int iLpCnt = 0;
        int iChk = 0;
        Robj_interface_POOLVerAllPool[] verAllPool = null;
        Robj_interface_POOLVerPool[] verPool = null;
        Robj_interface_POOLVerAllPool[] oldVerAllPool = null;
        Robj_interface_POOLVerPool[] oldVerPool = null;
        try {
            verAllPool = (Robj_interface_POOLVerAllPool[])verPoolVer.getObjChildren();
            if (null != verAllPool) {
                verPool = (Robj_interface_POOLVerPool[])verAllPool[0].getObjChildren();
                for (iLpCnt = 0; iLpCnt < SJmoDataMacro_IF.MAX_POOL_LDKC; ++iLpCnt) {
                    if (null == verPool[iLpCnt]) continue;
                    bsEqPool.set(iLpCnt);
                }
            }
            diffVerPool.setBsEqPool(bsEqPool);
            POOLVer oldPoolVer = this.m_VerData.getVerPool();
            if (this.m_VerData.isBEnable() && null != oldPoolVer) {
                if (oldPoolVer.getNVer() != verPoolVer.getNVer()) {
                    diffVerPool.setBPoolVer(true);
                }
                if (oldPoolVer.getNSummaryVer() != verPoolVer.getNSummaryVer()) {
                    verAllPool = (Robj_interface_POOLVerAllPool[])verPoolVer.getObjChildren();
                    oldVerAllPool = (Robj_interface_POOLVerAllPool[])oldPoolVer.getObjChildren();
                    if (oldVerAllPool[0].getNVer() != verAllPool[0].getNVer()) {
                        diffVerPool.setBVerAllPool(true);
                    }
                    if (oldVerAllPool[0].getNSummaryVer() != verAllPool[0].getNSummaryVer()) {
                        diffVerPool.setBVerAllPool(true);
                        verPool = (Robj_interface_POOLVerPool[])verAllPool[0].getObjChildren();
                        oldVerPool = (Robj_interface_POOLVerPool[])oldVerAllPool[0].getObjChildren();
                        for (iLpCnt = 0; iLpCnt < SJmoDataMacro_IF.MAX_POOL_LDKC; ++iLpCnt) {
                            iChk = this.chkVerDiff(oldVerPool[iLpCnt], verPool[iLpCnt]);
                            if (0 == iChk) continue;
                            diffVerPool.getBsVerPool().set(iLpCnt);
                        }
                    }
                }
            } else {
                SJmoUtility.putLogDetail("SJmoVersionMgr", "makeVerPool", "PoolVer is All Diff(Version Data is false)");
                diffVerPool.setAllVerDiffEnable();
            }
        }
        catch (Exception exp) {
            SJmoUtility.putLogDetail("SJmoVersionMgr", "makeVerPool", "makeVerPoolDiff is Failed:" + exp.getMessage());
        }
        return diffVerPool;
    }

    private SJmoDiffVerOdgd makeVerOdgd(ODGDVer verOdgd) {
        SJmoDiffVerOdgd diffVerOdgd = new SJmoDiffVerOdgd();
        int iLpCnt = 0;
        int iChk = 0;
        Robj_interface_ODGDVerAllLDEV verAllLdev = null;
        Robj_interface_ODGDVerLDEVPerCU[] verCu = null;
        Robj_interface_ODGDVerAllLDEV oldVerAllLdev = null;
        Robj_interface_ODGDVerLDEVPerCU[] oldVerCu = null;
        try {
            ODGDVer oldVerOdgd = this.m_VerData.getVerOdgd();
            if (this.m_VerData.isBEnable() && null != this.m_VerData.getVerOdgd()) {
                if (oldVerOdgd.getNVer() != verOdgd.getNVer()) {
                    SJmoUtility.putLogDetail("SJmoVersionMgr", "makeVerOdgd", "ODGD AllVer Version is Differrence old:" + oldVerOdgd.getNVer() + ",new:" + verOdgd.getNVer());
                    diffVerOdgd.setBOdgdVer(true);
                }
                if (oldVerOdgd.getNSummaryVer() != verOdgd.getNSummaryVer()) {
                    diffVerOdgd.setBOdgdVer(true);
                    SJmoUtility.putLogDetail("SJmoVersionMgr", "makeVerOdgd", "ODGD AllSummaryVer Version is Differrence old:" + oldVerOdgd.getNSummaryVer() + ",new:" + verOdgd.getNSummaryVer());
                    verAllLdev = (Robj_interface_ODGDVerAllLDEV)verOdgd.getObjChildren()[0];
                    oldVerAllLdev = (Robj_interface_ODGDVerAllLDEV)oldVerOdgd.getObjChildren()[0];
                    if (oldVerAllLdev.getNVer() != verAllLdev.getNVer()) {
                        SJmoUtility.putLogDetail("SJmoVersionMgr", "makeVerOdgd", "ODGD LDEVPerCUVer Version is Differrence old:" + oldVerAllLdev.getNVer() + ",new:" + verAllLdev.getNVer());
                        diffVerOdgd.setBVerAllLDEV(true);
                    }
                    if (oldVerAllLdev.getNSummaryVer() != verAllLdev.getNSummaryVer()) {
                        SJmoUtility.putLogDetail("SJmoVersionMgr", "makeVerOdgd", "ODGD LDEVPerCUVer Summary Version is Differrence old:" + oldVerAllLdev.getNSummaryVer() + ",new:" + verAllLdev.getNSummaryVer());
                        verCu = (Robj_interface_ODGDVerLDEVPerCU[])verAllLdev.getObjChildren();
                        oldVerCu = (Robj_interface_ODGDVerLDEVPerCU[])oldVerAllLdev.getObjChildren();
                        for (iLpCnt = 0; iLpCnt < SJmoDataMacro_IF.CUMAX_LDKC; ++iLpCnt) {
                            iChk = this.chkVerDiff(oldVerCu[iLpCnt], verCu[iLpCnt]);
                            if (0 == iChk) continue;
                            diffVerOdgd.getBsVerLDEVPerCU().set(iLpCnt);
                        }
                    }
                }
            } else {
                SJmoUtility.putLogDetail("SJmoVersionMgr", "makeVerOdgd", "OdgdVer is All Diff(Version Data is false)");
                diffVerOdgd.setAllVerDiffEnable();
            }
        }
        catch (Exception exp) {
            SJmoUtility.putLogDetail("SJmoVersionMgr", "makeVerOdgd", "makeVerOdgdDiff is Failed:" + exp.getMessage());
        }
        return diffVerOdgd;
    }

    private SJmoDiffVerUvm makeVerUvm(EXDVer verExd) {
        SJmoDiffVerUvm diffVerUvm = new SJmoDiffVerUvm();
        try {
            EXDVer oldVerExd = this.m_VerData.getVerUvm();
            if (null != oldVerExd && this.m_VerData.isBEnable()) {
                if (oldVerExd.getNVer() != verExd.getNVer()) {
                    SJmoUtility.putLogDetail("SJmoVersionMgr", "makeVerUvm", "UVM AllVer Version is Differrence old:" + oldVerExd.getNVer() + ",new:" + verExd.getNVer());
                    diffVerUvm.setBExdVer(true);
                }
                if (oldVerExd.getNSummaryVer() != verExd.getNSummaryVer()) {
                    SJmoUtility.putLogDetail("SJmoVersionMgr", "makeVerUvm", "UVM AllVer Summary Version is Differrence old:" + oldVerExd.getNSummaryVer() + ",new:" + verExd.getNSummaryVer());
                    diffVerUvm.setBExdVer(true);
                    Robj_interface_VerLeaf[] oldVerExdChild = oldVerExd.getObjChildren();
                    Robj_interface_VerLeaf[] verExdChild = verExd.getObjChildren();
                    if (oldVerExdChild[0].getNVer() != verExdChild[0].getNVer()) {
                        diffVerUvm.setBExdProfileVer(true);
                    }
                    if (oldVerExdChild[1].getNVer() != verExdChild[1].getNVer()) {
                        diffVerUvm.setBExdAllVolumeVer(true);
                    }
                }
            } else {
                diffVerUvm.setAllVerDiffEnable();
            }
        }
        catch (Exception exp) {
            SJmoUtility.putLogDetail("SJmoVersionMgr", "makeVerUvm", "makeVerUvm Failed:" + exp.toString());
        }
        return diffVerUvm;
    }

    private SJmoDiffVerUuid makeVerUuid(UUIDVer verUuid) {
        SJmoDiffVerUuid diffVerUuid = new SJmoDiffVerUuid();
        int iLpCnt = 0;
        int iChk = 0;
        UUIDVerAllLDEV verAllLdev = null;
        UUIDVerLDEVPerCU[] verLdevPerCu = null;
        UUIDVerAllLDEV oldVerAllLdev = null;
        UUIDVerLDEVPerCU[] oldVerLdevPerCu = null;
        try {
            UUIDVer oldVerUuid = this.m_VerData.getVerUuid();
            if (null != oldVerUuid && this.m_VerData.isBEnable()) {
                if (verUuid.getNVer() != oldVerUuid.getNVer()) {
                    SJmoUtility.putLogDetail("SJmoVersionMgr", "makeVerUuid", "UUID AllVer Version is Differrence old:" + oldVerUuid.getNVer() + ",new:" + verUuid.getNVer());
                    diffVerUuid.setBUuidVer(true);
                }
                if (verUuid.getNSummaryVer() != oldVerUuid.getNSummaryVer()) {
                    SJmoUtility.putLogDetail("SJmoVersionMgr", "makeVerUuid", "UUID AllVer SummaryVersion is Differrence old:" + oldVerUuid.getNSummaryVer() + ",new:" + verUuid.getNSummaryVer());
                    diffVerUuid.setBUuidVer(true);
                    verAllLdev = (UUIDVerAllLDEV)verUuid.getObjChildren()[0];
                    oldVerAllLdev = (UUIDVerAllLDEV)oldVerUuid.getObjChildren()[0];
                    if (verAllLdev.getNVer() != oldVerAllLdev.getNVer()) {
                        SJmoUtility.putLogDetail("SJmoVersionMgr", "makeVerUuid", "UUID AllLdevVer Version is Differrence old:" + oldVerAllLdev.getNVer() + ",new:" + verAllLdev.getNVer());
                        diffVerUuid.setBVerAllLdev(true);
                    }
                    if (verAllLdev.getNSummaryVer() != oldVerAllLdev.getNSummaryVer()) {
                        SJmoUtility.putLogDetail("SJmoVersionMgr", "makeVerUuid", "UUID AllLdevVer Summary Version is Differrence old:" + oldVerAllLdev.getNSummaryVer() + ",new:" + verAllLdev.getNSummaryVer());
                        verLdevPerCu = (UUIDVerLDEVPerCU[])verAllLdev.getObjChildren();
                        oldVerLdevPerCu = (UUIDVerLDEVPerCU[])oldVerAllLdev.getObjChildren();
                        for (iLpCnt = 0; iLpCnt < SJmoDataMacro_IF.CUMAX_LDKC; ++iLpCnt) {
                            iChk = this.chkVerDiff(oldVerLdevPerCu[iLpCnt], verLdevPerCu[iLpCnt]);
                            if (1 != iChk) continue;
                            diffVerUuid.getBsVerLDEVPerCU().set(iLpCnt);
                        }
                    }
                }
            } else {
                SJmoUtility.putLogDetail("SJmoVersionMgr", "makeVerUuid", "UuidVer is All Diff(Version Data is false)");
                diffVerUuid.setAllVerDiffEnable();
            }
        }
        catch (Exception exp) {
            SJmoUtility.putLogDetail("SJmoVersionMgr", "SJmoDiffVerUuid", "makeVerUuidDiff is Failed:" + exp.getMessage());
        }
        return diffVerUuid;
    }

    private SJmoDiffVerNickname makeDiffVerNickname(NICKNAMEVer verNickname) {
        SJmoDiffVerNickname diffVerNickname = new SJmoDiffVerNickname();
        int iLpCnt = 0;
        int iChk = 0;
        NICKNAMEVer oldVerNickname = null;
        NICKNAMEVerAllLDEV verAllLdev = null;
        NICKNAMEVerAllLDEV oldVerAllLdev = null;
        NICKNAMEVerLDEVPerCU[] verCu = null;
        NICKNAMEVerLDEVPerCU[] oldVerCu = null;
        NICKNAMEVerAllPool oldVerPool = null;
        NICKNAMEVerAllPool verPool = null;
        try {
            oldVerNickname = this.m_VerData.getVerNickname();
            if (null != oldVerNickname && this.m_VerData.isBEnable()) {
                if (oldVerNickname.getNVer() != verNickname.getNVer()) {
                    SJmoUtility.putLogDetail("SJmoVersionMgr", "makeDiffVerNickname", "NICKNAME AllVer Version is Differrence old:" + oldVerNickname.getNVer() + ",new:" + verNickname.getNVer());
                    diffVerNickname.setBVerNickName(true);
                }
                if (oldVerNickname.getNSummaryVer() != verNickname.getNSummaryVer()) {
                    SJmoUtility.putLogDetail("SJmoVersionMgr", "makeDiffVerNickname", "NICKNAME AllVer Summary Version is Differrence old:" + oldVerNickname.getNSummaryVer() + ",new:" + verNickname.getNSummaryVer());
                    diffVerNickname.setBVerNickName(true);
                    Robj_interface_VerLeaf[] oldVerLeaf = oldVerNickname.getObjChildren();
                    Robj_interface_VerLeaf[] verLeaf = verNickname.getObjChildren();
                    oldVerAllLdev = (NICKNAMEVerAllLDEV)oldVerLeaf[0];
                    verAllLdev = (NICKNAMEVerAllLDEV)verLeaf[0];
                    if (oldVerAllLdev.getNVer() != verAllLdev.getNVer()) {
                        SJmoUtility.putLogDetail("SJmoVersionMgr", "makeDiffVerNickname", "NICKNAME AllLdevVer Version is Differrence old:" + oldVerAllLdev.getNVer() + ",new:" + verAllLdev.getNVer());
                        diffVerNickname.setBVerAllLdev(true);
                    }
                    if (oldVerAllLdev.getNSummaryVer() != verAllLdev.getNSummaryVer()) {
                        SJmoUtility.putLogDetail("SJmoVersionMgr", "makeDiffVerNickname", "NICKNAME AllLdevVer Summary Version is Differrence old:" + oldVerAllLdev.getNSummaryVer() + ",new:" + verAllLdev.getNSummaryVer());
                        oldVerCu = (NICKNAMEVerLDEVPerCU[])oldVerAllLdev.getObjChildren();
                        verCu = (NICKNAMEVerLDEVPerCU[])verAllLdev.getObjChildren();
                        for (iLpCnt = 0; iLpCnt < SJmoDataMacro_IF.CUMAX_LDKC; ++iLpCnt) {
                            iChk = this.chkVerDiff(oldVerCu[iLpCnt], verCu[iLpCnt]);
                            if (1 != iChk) continue;
                            diffVerNickname.getBsVerLDEVPerCU().set(iLpCnt);
                        }
                    }
                    oldVerPool = (NICKNAMEVerAllPool)oldVerLeaf[1];
                    verPool = (NICKNAMEVerAllPool)verLeaf[1];
                    if (oldVerPool.getNVer() != verPool.getNVer()) {
                        diffVerNickname.setBVerAllPool(true);
                    }
                }
            } else {
                SJmoUtility.putLogDetail("SJmoVersionMgr", "makeVerNickname", "NicknameVer is All Diff(Version Data is false)");
                diffVerNickname.setAllVerDiffEnable();
            }
        }
        catch (Exception exp) {
            // empty catch block
        }
        return diffVerNickname;
    }

    private SJmoDiffVerHur makeDiffVerHur(HURVer verHur) {
        SJmoDiffVerHur diffVerHur = new SJmoDiffVerHur();
        HURVer oldVerHur = null;
        Object verJnlg = null;
        Object oldVerJnlg = null;
        Object ver256Jnlg = null;
        Object oldVer256Jnlg = null;
        HURVerAllPair verAllPair = null;
        HURVerAllPair oldVerAllPair = null;
        HURVerPairPerCU[] VerCu = null;
        HURVerPairPerCU[] oldVerCu = null;
        HURVerSysOpt verOpt = null;
        HURVerSysOpt oldVerOpt = null;
        HURVerECTG verEctg = null;
        HURVerECTG oldVerEctg = null;
        try {
            oldVerHur = this.m_VerData.getVerHur();
            if (this.m_VerData.isBEnable() && null != oldVerHur) {
                if (verHur.getNVer() != oldVerHur.getNVer()) {
                    SJmoUtility.putLogDetail("SJmoVersionMgr", "SJmoDiffVerHur", "REMOTE_COPY_J AllVer Version is Differrence old:" + oldVerHur.getNVer() + ",new:" + verHur.getNVer());
                    diffVerHur.setBHurVer(true);
                }
                if (verHur.getNSummaryVer() != oldVerHur.getNSummaryVer()) {
                    SJmoUtility.putLogDetail("SJmoVersionMgr", "SJmoDiffVerHur", "REMOTE_COPY_J AllSummaryVer Version is Differrence old:" + oldVerHur.getNSummaryVer() + ",new:" + verHur.getNSummaryVer());
                    diffVerHur.setBHurVer(true);
                    Robj_interface_VerLeaf[] verLeaf = verHur.getObjChildren();
                    Robj_interface_VerLeaf[] oldVerLeaf = oldVerHur.getObjChildren();
                    verAllPair = (HURVerAllPair)verLeaf[1];
                    oldVerAllPair = (HURVerAllPair)oldVerLeaf[1];
                    if (this.bDiffVerLeafCheck(verAllPair, oldVerAllPair, 1, 100728840) || this.bDiffVerBranchSummaryVerCheck(verAllPair, oldVerAllPair, 1, 100728840)) {
                        SJmoUtility.putLogDetail("SJmoVersionMgr", "SJmoDiffVerHur", "HURVerAllPair Version is Differrence old:" + oldVerAllPair.getNVer() + ",new:" + verAllPair.getNVer());
                        diffVerHur.setBVerAllPair(true);
                        VerCu = (HURVerPairPerCU[])verAllPair.getObjChildren();
                        oldVerCu = (HURVerPairPerCU[])oldVerAllPair.getObjChildren();
                        for (int iCu = 0; iCu < SJmoDataMacro_IF.CUMAX_LDKC; ++iCu) {
                            if (VerCu[iCu].getNVer() == oldVerCu[iCu].getNVer()) continue;
                            diffVerHur.getBsVerPairCU().set(iCu);
                        }
                    }
                    if (this.bDiffVerLeafCheck(verOpt = (HURVerSysOpt)verLeaf[2], oldVerOpt = (HURVerSysOpt)oldVerLeaf[2], 2, 100728840)) {
                        SJmoUtility.putLogDetail("SJmoVersionMgr", "SJmoDiffVerHur", "HURVerSysOpt Version is Differrence old:" + oldVerOpt.getNVer() + ",new:" + verOpt.getNVer());
                        diffVerHur.setBVerSysOpt(true);
                    }
                    if (this.bDiffVerLeafCheck(verEctg = (HURVerECTG)verLeaf[3], oldVerEctg = (HURVerECTG)oldVerLeaf[3], 3, 100728840)) {
                        SJmoUtility.putLogDetail("SJmoVersionMgr", "SJmoDiffVerHur", "HURVerECTG Version is Differrence old:" + oldVerEctg.getNVer() + ",new:" + verEctg.getNVer());
                        diffVerHur.setBVerEXCTG(true);
                    }
                }
            } else {
                SJmoUtility.putLogDetail("SJmoVersionMgr", "makeDiffVerHur", "HURVer is All Diff(Version Data is false)");
                diffVerHur.setAllVerDiffEnable();
            }
        }
        catch (Exception exp) {
            SJmoUtility.putLogDetail("SJmoVersionMgr", "makeDiffVerHur", "makeDiffVerHur is Failed:" + exp.getMessage());
        }
        return diffVerHur;
    }

    private SJmoDiffVerSi makeDiffVerSi(SIVer verSi) {
        SJmoDiffVerSi diffVerSi = new SJmoDiffVerSi();
        SIVer oldVerSi = null;
        try {
            oldVerSi = this.m_VerData.getVerSi();
            if (this.m_VerData.isBEnable() && oldVerSi != null) {
                if (verSi.getNSummaryVer() != oldVerSi.getNSummaryVer()) {
                    SJmoUtility.putLogDetail("SJmoVersionMgr", "makeDiffVerSi", "LOCAL_COPY AllSummaryVer Version is Differrence old:" + oldVerSi.getNSummaryVer() + ",new:" + verSi.getNSummaryVer());
                    diffVerSi.setBSIVer(true);
                    Robj_interface_VerLeaf[] verLeaf = verSi.getObjChildren();
                    Robj_interface_VerLeaf[] oldVerLeaf = oldVerSi.getObjChildren();
                    SIVerAllPair verSiAllPair = (SIVerAllPair)verLeaf[0];
                    SIVerAllPair oldVerSiAllPair = (SIVerAllPair)oldVerLeaf[0];
                    if (this.bDiffVerBranchSummaryVerCheck(verSiAllPair, oldVerSiAllPair, 0, 100728837)) {
                        diffVerSi.setBSIVerAllPair(true);
                        Robj_interface_VerLeaf[] verSiPairPerCu = verSiAllPair.getObjChildren();
                        Robj_interface_VerLeaf[] oldVerSiPairPerCu = oldVerSiAllPair.getObjChildren();
                        for (int iCuCnt = 0; iCuCnt < SJmoDataMacro_IF.CUMAX_LDKC; ++iCuCnt) {
                            if (verSiPairPerCu[iCuCnt].getNVer() == oldVerSiPairPerCu[iCuCnt].getNVer()) continue;
                            diffVerSi.getBsSIVerPairPerCU().set(iCuCnt);
                        }
                    } else if (this.bDiffVerLeafCheck(verSiAllPair, oldVerSiAllPair, 0, 100728837)) {
                        SJmoUtility.putLogDetail(this.getClass().getSimpleName(), "makeDiffVerSi", "SI AllPair Version illigal.");
                    }
                    diffVerSi.setBLocalReplicationCTGVer(this.bDiffVerLeafCheck(verLeaf[1], oldVerLeaf[1], 1, 100728837));
                    diffVerSi.setBSIVerOpenOption(this.bDiffVerLeafCheck(verLeaf[2], oldVerLeaf[2], 2, 100728837));
                    diffVerSi.setBSIVerMFOption(this.bDiffVerLeafCheck(verLeaf[3], oldVerLeaf[3], 3, 100728837));
                } else if (verSi.getNVer() != oldVerSi.getNVer()) {
                    SJmoUtility.putLogDetail(this.getClass().getSimpleName(), "makeDiffVerSi", "SIVer Version illigal");
                }
            } else {
                SJmoUtility.putLogDetail("SJmoVersionMgr", "makeDiffVerSi", "SIVer is All Diff(Version Data is false)");
                diffVerSi.setVerAllEnable();
            }
        }
        catch (Exception exp) {
            SJmoUtility.putLogDetail("SJmoVersionMgr", "makeDiffVerSi", "makeDiffVerSi is Failed:" + exp.toString());
        }
        return diffVerSi;
    }

    private SJmoDiffVerRmcp makeDiffVerRmcp(RMCPVer verRmcp) {
        SJmoDiffVerRmcp diffVerRmcp = new SJmoDiffVerRmcp();
        RMCPVer oldVerRmcp = null;
        try {
            oldVerRmcp = this.m_VerData.getVerRmcp();
            if (this.m_VerData.isBEnable() && oldVerRmcp != null) {
                if (verRmcp.getNSummaryVer() != oldVerRmcp.getNSummaryVer()) {
                    SJmoUtility.putLogDetail("SJmoVersionMgr", "makeDiffVerRmcp", "REMOTE_COPY AllSummaryVer Version is Differrence old:" + oldVerRmcp.getNSummaryVer() + ",new:" + verRmcp.getNSummaryVer());
                    diffVerRmcp.setBRMCPVer(true);
                    Robj_interface_VerLeaf[] verLeaf = verRmcp.getObjChildren();
                    Robj_interface_VerLeaf[] oldVerLeaf = oldVerRmcp.getObjChildren();
                    RMCPVerAllPair verRmcpAllPair = (RMCPVerAllPair)verLeaf[0];
                    RMCPVerAllPair oldVerRmcpAllPair = (RMCPVerAllPair)oldVerLeaf[0];
                    if (this.bDiffVerBranchSummaryVerCheck(verRmcpAllPair, oldVerRmcpAllPair, 0, 100728839)) {
                        Robj_interface_VerLeaf[] verRmcpPairPerCu = verRmcpAllPair.getObjChildren();
                        Robj_interface_VerLeaf[] oldVerRmcpPairPerCu = oldVerRmcpAllPair.getObjChildren();
                        for (int iCuCnt = 0; iCuCnt < SJmoDataMacro_IF.CUMAX_LDKC; ++iCuCnt) {
                            if (verRmcpPairPerCu[iCuCnt].getNVer() == oldVerRmcpPairPerCu[iCuCnt].getNVer()) continue;
                            diffVerRmcp.getBsRMCPVerPairPerCU().set(iCuCnt);
                        }
                    } else if (this.bDiffVerLeafCheck(verRmcpAllPair, oldVerRmcpAllPair, 0, 100728839)) {
                        SJmoUtility.putLogDetail(this.getClass().getSimpleName(), "makeDiffVerRmcp", "RemoteCopy AllPair Version illigal.");
                    }
                    diffVerRmcp.setBRMCPVerMRCU(this.bDiffVerLeafCheck(verLeaf[1], oldVerLeaf[1], 1, 100728839));
                    diffVerRmcp.setBRMCPVerOption(this.bDiffVerLeafCheck(verLeaf[2], oldVerLeaf[2], 2, 100728839));
                } else if (verRmcp.getNVer() != oldVerRmcp.getNVer()) {
                    SJmoUtility.putLogDetail("SJmoVersionMgr", "makeDiffVerRmcp", "RMCPVer Version illigal.");
                }
            } else {
                diffVerRmcp.setVerAllEnable();
            }
        }
        catch (Exception exp) {
            SJmoUtility.putLogDetail("SJmoVersionMgr", "makeDiffVerRmcp", "makeDiffVerRmcp is Failed:" + exp.toString());
        }
        return diffVerRmcp;
    }

    private SJmoDiffVerHA makeDiffVerHA(HAVer verHA) {
        SJmoDiffVerHA diffVerHA = new SJmoDiffVerHA();
        HAVer oldVerHA = null;
        try {
            oldVerHA = this.m_VerData.getVerHA();
            if (this.m_VerData.isBEnable() && oldVerHA != null) {
                if (verHA.getNSummaryVer() != oldVerHA.getNSummaryVer()) {
                    SJmoUtility.putLogDetail("SJmoVersionMgr", "makeDiffVerHA", "HIGH_AVAILABILITY AllSummaryVer Version is Differrence old:" + oldVerHA.getNSummaryVer() + ",new:" + verHA.getNSummaryVer());
                    diffVerHA.setBHAVer(true);
                    Robj_interface_VerLeaf[] verLeaf = verHA.getObjChildren();
                    Robj_interface_VerLeaf[] oldVerLeaf = oldVerHA.getObjChildren();
                    HAVerAllPair verHAAllPair = (HAVerAllPair)verLeaf[0];
                    HAVerAllPair oldVerHAAllPair = (HAVerAllPair)oldVerLeaf[0];
                    if (this.bDiffVerBranchSummaryVerCheck(verHAAllPair, oldVerHAAllPair, 0, 134283777)) {
                        Robj_interface_VerLeaf[] verHAPairPerCu = verHAAllPair.getObjChildren();
                        Robj_interface_VerLeaf[] oldVerHAPairPerCu = oldVerHAAllPair.getObjChildren();
                        for (int iCuCnt = 0; iCuCnt < SJmoDataMacro_IF.CUMAX_LDKC; ++iCuCnt) {
                            if (verHAPairPerCu[iCuCnt].getNVer() == oldVerHAPairPerCu[iCuCnt].getNVer()) continue;
                            diffVerHA.getBsHAVerPairPerCU().set(iCuCnt);
                        }
                    } else if (this.bDiffVerLeafCheck(verHAAllPair, oldVerHAAllPair, 0, 134283777)) {
                        SJmoUtility.putLogDetail(this.getClass().getSimpleName(), "makeDiffVerHA", "HighAvailability AllPair Version illigal.");
                    }
                    diffVerHA.setBHAVerOption(this.bDiffVerLeafCheck(verLeaf[1], oldVerLeaf[1], 1, 134283777));
                } else if (verHA.getNVer() != oldVerHA.getNVer()) {
                    SJmoUtility.putLogDetail("SJmoVersionMgr", "makeDiffVerHA", "HAVer Version illigal.");
                }
            } else {
                diffVerHA.setVerAllEnable();
            }
        }
        catch (Exception exp) {
            SJmoUtility.putLogDetail("SJmoVersionMgr", "makeDiffVerHA", "makeDiffVerHA is Failed:" + exp.toString());
        }
        return diffVerHA;
    }

    protected boolean bDiffVerLeafCheck(Robj_interface_VerLeaf verLeaf, Robj_interface_VerLeaf oldVerLeaf, int iVerLeaf_Index, int iVersionKind) {
        boolean bVerLeafDiff = false;
        if (verLeaf.getNVer() != oldVerLeaf.getNVer()) {
            switch (iVersionKind) {
                case 100728837: {
                    SJmoUtility.putLogDetail("SJmoVersionMgr", "bDiffSiVerLeaf", "SIVer is Diff: verSiLeaf[" + iVerLeaf_Index + "].getNVer()");
                    bVerLeafDiff = true;
                    break;
                }
                case 100728839: {
                    SJmoUtility.putLogDetail("SJmoVersionMgr", "bDiffRmcpVerLeaf", "RMCPVer is Diff: verRmcpLeaf[" + iVerLeaf_Index + "].getNVer()");
                    bVerLeafDiff = true;
                    break;
                }
                case 100728840: {
                    SJmoUtility.putLogDetail("SJmoVersionMgr", "bDiffHURVerLeaf", "HurVer is Diff: verHurLeaf[" + iVerLeaf_Index + "].getNVer()");
                    bVerLeafDiff = true;
                    break;
                }
                case 134283777: {
                    SJmoUtility.putLogDetail("SJmoVersionMgr", "bDiffHAVerLeaf", "HAVer is Diff: verHALeaf[" + iVerLeaf_Index + "].getNVer()");
                    bVerLeafDiff = true;
                    break;
                }
                default: {
                    SJmoUtility.putLogDetail("SJmoVersionMgr", "VersionKind", "iVersionKind: iVersionKind[" + iVersionKind + "]");
                }
            }
        }
        return bVerLeafDiff;
    }

    protected boolean bDiffVerBranchSummaryVerCheck(VerBranch verBrunch, VerBranch oldVerBranch, int iVerBranchIdx, int iVersionKind) {
        boolean bBranchDiff = false;
        if (verBrunch.getNSummaryVer() != oldVerBranch.getNSummaryVer()) {
            switch (iVersionKind) {
                case 100728837: {
                    SJmoUtility.putLogDetail(this.getClass().getSimpleName(), "bDiffVerBranchSummaryVerCheck", "SIVer Diff Branch Index = " + iVerBranchIdx);
                    bBranchDiff = true;
                    break;
                }
                case 100728839: {
                    SJmoUtility.putLogDetail(this.getClass().getSimpleName(), "bDiffVerBranchSummaryVerCheck", "RMCPVer Diff Branch Index = " + iVerBranchIdx);
                    bBranchDiff = true;
                    break;
                }
                case 100728840: {
                    SJmoUtility.putLogDetail(this.getClass().getSimpleName(), "bDiffVerBranchSummaryVerCheck", "HURVer Diff Branch Index = " + iVerBranchIdx);
                    bBranchDiff = true;
                    break;
                }
                case 134283777: {
                    SJmoUtility.putLogDetail(this.getClass().getSimpleName(), "bDiffVerBranchSummaryVerCheck", "HAVer Diff Branch Index = " + iVerBranchIdx);
                    bBranchDiff = true;
                    break;
                }
                default: {
                    SJmoUtility.putLogDetail(this.getClass().getSimpleName(), "bDiffVerBranchSummaryVerCheck", "iVersionKind illigal. iVersionKind = " + iVersionKind);
                }
            }
        }
        return bBranchDiff;
    }

    private int chkVerDiff(Robj_interface_VerLeaf oldVer, Robj_interface_VerLeaf newVer) {
        int iRet = 0;
        if (null != oldVer) {
            if (null != newVer) {
                if (oldVer.getNVer() != newVer.getNVer()) {
                    iRet = 1;
                }
            } else {
                iRet = 3;
            }
        } else if (null != newVer) {
            iRet = 2;
        }
        return iRet;
    }

    public void finish() {
        SJmoUtility.putLogDetail("SJmoVersionMgr", "finish", "The VersionMgr finish started");
        if (null != this.m_Poller) {
            SJmoUtility.putLogDetail("SJmoVersionMgr", "finish", "Polling stop demand");
            this.m_Poller.canselScadule();
            this.m_Poller = null;
        }
        this.m_Poller = new SJmoVerPoller(false);
        this.changeStatus(0);
        this.m_iRequest = -1;
        this.m_VerData = null;
        this.m_VerData_ex = null;
        this.m_NoticeRenew = null;
        this.m_strLog = null;
        this.m_MdlMgr = null;
        this.m_SvpConfRetry = 0;
        this.m_RetryVer = true;
        this.m_iRetryCnt = 0;
        this.m_SysOpt = null;
        this.m_SysOptSyncObj = null;
        SJmoUtility.putLogDetail("SJmoVersionMgr", "finish", "The VersionMgr finish ended");
    }

    private boolean inputVersionData() {
        boolean bRet = true;
        String strFilePath = "version";
        String strFileName = "VersionObj.dbg";
        try {
            this.m_VerData = (SJmoVersionData)SJcFileUty.loadFile2Class(strFilePath, "VERDATA.obj");
        }
        catch (Exception e) {
            this.m_strLog = "inputVersionData: File Read Error(" + e.toString() + ")";
            this.putLog(this.m_strLog);
            bRet = false;
        }
        if (bRet && this.m_VerData.getSVersion() != SJmoDataMacro_IF.MODELDATA_VERSION) {
            SJmoUtility.putLogDetail(this.getClass().getSimpleName(), "inputVersionData", "VersionData : " + this.m_VerData.getSVersion());
            SJmoUtility.putLogDetail(this.getClass().getSimpleName(), "inputVersionData", "Model : " + SJmoDataMacro_IF.MODELDATA_VERSION);
            bRet = false;
        }
        if (!bRet) {
            try {
                SJcFileUty.deleteFile(strFilePath, "VERDATA.obj");
            }
            catch (Exception e) {
                SJmoUtility.putLogDetail(this.getClass().getSimpleName(), "inputVersionData", "File Delete Error(" + e.toString() + ")");
            }
            this.m_VerData = new SJmoVersionData();
        }
        return bRet;
    }

    private void outputVersionData() {
        String strFilePath = "version";
        String strFileName = "VersionObj.dbg";
        try {
            SJcFileUty.saveClass2File(strFilePath, strFileName, this.m_VerData);
        }
        catch (Exception e) {
            this.m_strLog = "outputVersionData: File Write Error(" + e.toString() + ")";
            this.putLog(this.m_strLog);
        }
    }

    private void putLog(String strLog) {
        SJmoUtility.putLog(strLog);
    }

    public SJmoVerPoller getVerPoller() {
        return this.m_Poller;
    }

    public boolean refreshRMI(int iRequest, SJdsSupplierAgent supAgt) throws SJmoException {
        boolean bRet;
        block9: {
            bRet = true;
            int iRefreshRMIKind = -1;
            switch (iRequest) {
                case 2: {
                    iRefreshRMIKind = 1;
                    break;
                }
                case 0: 
                case 1: 
                case 4: 
                case 5: {
                    iRefreshRMIKind = 0;
                    break;
                }
                default: {
                    SJmoUtility.putLogDetail("SJmoVersionMgr", "refreshRMI", "Refresh kind is illigal");
                    throw SJmoUtility.getException(201, 23, 107003, "SJmoVersionMgr", "refreshRMI");
                }
            }
            try {
                SJdsMethodInf refMethodInf = new SJdsMethodInf("refreshUx");
                Class[] refArgs = new Class[]{SJmoDataMacro_IF.INT_CLASS};
                Object[] refParam = new Object[]{iRefreshRMIKind};
                refMethodInf.setInfo(refArgs, refParam, 0);
                supAgt.getServerInf(refMethodInf, true);
                SJmoUtility.putLogDetail("SJmoVersionMgr", "refreshRMI", "RMI Refresh end");
            }
            catch (SJdsSupplierException splExp) {
                bRet = false;
                SJmoUtility.putLogDetail("SJmoVersionMgr", "refreshRMI", "RMI I/F Error(SJdsSupplierException)");
                if (5 == iRequest) {
                    throw SJmoUtility.getException(Integer.parseInt(splExp.getMsg().getFunctionID()), Integer.parseInt(splExp.getMsg().getModuleID()), Integer.parseInt(splExp.getMsg().getMsgID()), "refreshRMI", "RMI I/F Error(SJdsSupplierException)");
                }
                if (this.isVerRequestOfRefresh(iRequest)) {
                    this.m_MdlMgr.setRefreshException(201, 23, 107009);
                }
            }
            catch (Exception jvExp) {
                bRet = false;
                SJmoUtility.putLogDetail("SJmoVersionMgr", "refreshRMI", "RMI I/F Error");
                if (!this.isVerRequestOfRefresh(iRequest)) break block9;
                this.m_MdlMgr.setRefreshException(201, 23, 107009);
            }
        }
        return bRet;
    }

    private ConfVerSummary getVerSummary(int iRequest, SJdsSupplierAgent supAgt) throws SJmoException {
        ConfVerSummary verSummary;
        block5: {
            verSummary = null;
            try {
                ConfVerSummary_IN sumInput = new ConfVerSummary_IN();
                ConfVerSummary_OUT sumOutput = (ConfVerSummary_OUT)supAgt.getDataInf(sumInput, false);
                if (null != sumOutput) {
                    verSummary = sumOutput.getDataObject();
                    SJmoUtility.putLogDetail("SJmoVersionMgr", "getVerSummary", "RMIGetSummaryVersion end");
                } else {
                    SJmoUtility.putLogDetail("SJmoVersionMgr", "getVerSummary", "RMI I/F Error");
                    if (this.isVerRequestOfRefresh(iRequest)) {
                        this.m_MdlMgr.setRefreshException(201, 23, 107008);
                    }
                }
            }
            catch (Exception jvExp) {
                SJmoUtility.putLogDetail("SJmoVersionMgr", "getVerSummary", "RMI I/F Error");
                if (!this.isVerRequestOfRefresh(iRequest)) break block5;
                this.m_MdlMgr.setRefreshException(201, 23, 107008);
            }
        }
        return verSummary;
    }

    private ConfVerDetailList getVerDetail(int iRequest, int[] iFuncID, SJdsSupplierAgent supAgt) throws SJmoException {
        ConfVerDetailList verDetailList;
        block5: {
            verDetailList = null;
            try {
                ConfVerDetail_IN detaInput = new ConfVerDetail_IN(iFuncID);
                SJmoUtility.putLogDetail("SJmoVersionMgr", "getVerDetail", "RMI GetDetailVersion start");
                ConfVerDetail_OUT dataOutput = (ConfVerDetail_OUT)supAgt.getDataInf(detaInput, false);
                if (null != dataOutput) {
                    verDetailList = dataOutput.getDataObject();
                    SJmoUtility.putLogDetail("SJmoVersionMgr", "getVerDetail", "RMIGetDetailVersion end");
                } else {
                    SJmoUtility.putLogDetail("SJmoVersionMgr", "getVerDetail", "RMI I/F Error");
                    if (this.isVerRequestOfRefresh(iRequest)) {
                        this.m_MdlMgr.setRefreshException(201, 23, 107008);
                    }
                }
            }
            catch (Exception jvExp) {
                SJmoUtility.putLogDetail("SJmoVersionMgr", "getVerDetail", "RMI I/F Error");
                SJmoUtility.putLogDetail("SJmoVersionMgr", "getVerSummary", "RMI I/F Error");
                if (!this.isVerRequestOfRefresh(iRequest)) break block5;
                this.m_MdlMgr.setRefreshException(201, 23, 107008);
            }
        }
        return verDetailList;
    }

    public int getVerStatus() {
        return this.m_Condition.getStatus();
    }

    private synchronized int changeStatus(int iStatus) {
        int iChangeStatus = 0;
        int iNowStatus = 0;
        iNowStatus = this.m_Condition.getStatus();
        switch (iStatus) {
            case 2: 
            case 4: 
            case 6: {
                if (1 != iNowStatus) break;
                this.m_Condition.setStatus(iStatus);
                break;
            }
            default: {
                this.m_Condition.setStatus(iStatus);
            }
        }
        iChangeStatus = this.m_Condition.getStatus();
        SJmoUtility.putLogDetail("SJmoVersionMgr", "changeStatus", "VerMgr Status:(Request:" + iStatus + " Now:" + iNowStatus + " New:" + iChangeStatus + ")");
        return iChangeStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renewRmiServer() throws SJmoException {
        SJdsSupplierMgr supMgr = SJdsSupplierMgr.getSupplierMgr();
        try {
            SJdsSupplierAgent supAgt = supMgr.getAgent();
            supAgt.lock("flex_users");
            try {
                SJdsMethodInf methInf = new SJdsMethodInf("refreshUx");
                Class[] refArgs = new Class[]{SJmoDataMacro_IF.INT_CLASS};
                Object[] refParam = new Object[]{1};
                methInf.setInfo(refArgs, refParam, 0);
                supAgt.getServerInf(methInf, false);
            }
            finally {
                supAgt.unlock();
            }
        }
        catch (SJdsSupplierException supExp) {
            SJmoUtility.putLogDetail("SJmoVersionMgr", "renewRmiServer", "function failed");
            throw supExp;
        }
    }

    public int getSvpConfRetry() {
        return this.m_SvpConfRetry;
    }

    public void setSvpConfRetry(int svpConfRetry) {
        this.m_SvpConfRetry = svpConfRetry;
    }

    public int getSvpConfStat() throws SJmoException {
        DISKgetDKCDKUStatusInfo statInfo = SJdsSupplierMgr.getSupplierMgr().getDkcDkuStatusInfoFromRMI();
        return statInfo.dkc.nDKCConfCheck;
    }

    private boolean isVerRequestOfRefresh(int iRequest) {
        boolean bRet = false;
        if (iRequest == 4) {
            if (this.m_iRequest == 2 || this.m_iRequest == 1 || this.m_iRequest == 3) {
                bRet = true;
            }
        } else if (iRequest == 2 || iRequest == 1 || iRequest == 3) {
            bRet = true;
        }
        return bRet;
    }

    private boolean checkVerSummary(ConfVerSummary oldSummary, ConfVerSummary newSummary) {
        if (null != oldSummary && null != newSummary) {
            if (oldSummary.getNVer(0x6010001) != newSummary.getNVer(0x6010001)) {
                return true;
            }
            if (oldSummary.getNVer(369230081) != newSummary.getNVer(369230081)) {
                return true;
            }
            if (oldSummary.getNVer(100728836) != newSummary.getNVer(100728836)) {
                return true;
            }
            if (oldSummary.getNVer(0x16010000) != newSummary.getNVer(0x16010000)) {
                return true;
            }
            if (oldSummary.getNVer(0x16010001) != newSummary.getNVer(0x16010001)) {
                return true;
            }
            if (oldSummary.getNVer(100728843) != newSummary.getNVer(100728843)) {
                return true;
            }
            if (oldSummary.getNVer(100728842) != newSummary.getNVer(100728842)) {
                return true;
            }
            if (oldSummary.getNVer(369164290) != newSummary.getNVer(369164290)) {
                return true;
            }
            if (oldSummary.getNVer(369164291) != newSummary.getNVer(369164291)) {
                return true;
            }
            if (oldSummary.getNVer(100794369) != newSummary.getNVer(100794369)) {
                return true;
            }
            if (oldSummary.getNVer(0x6020002) != newSummary.getNVer(0x6020002)) {
                return true;
            }
            if (oldSummary.getNVer(100794625) != newSummary.getNVer(100794625)) {
                return true;
            }
            if (oldSummary.getNVer(117768193) != newSummary.getNVer(117768193)) {
                return true;
            }
            if (oldSummary.getNVer(0x8010001) != newSummary.getNVer(0x8010001)) {
                return true;
            }
            if (oldSummary.getNVer(134283778) != newSummary.getNVer(134283778)) {
                return true;
            }
        } else {
            SJmoUtility.putLogDetail("SJmoVersionMgr", "checkVerSummary", "Param error");
        }
        return false;
    }

    public SJmoVersionData getOldVerData() {
        return this.m_VerData_bak;
    }

    public SJmoVersionData getVerData() {
        return this.m_VerData;
    }

    public static boolean isRefreshForce(DKCSystemOptionEx sysOptInfo, int iRequest) {
        boolean bRet = false;
        if (sysOptInfo == null) {
            SJmoUtility.putLogDetail("SJmoVersionMgr", "isRefreshForce", "sysOptInfo = null");
            return bRet;
        }
        switch (iRequest) {
            case 3: {
                if (!sysOptInfo.getBitSnSysOpt().get(1)) break;
                bRet = true;
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 4: {
                break;
            }
            default: {
                SJmoUtility.putLogDetail("SJmoVersionMgr", "isRefreshForce", "iRequest = " + iRequest);
            }
        }
        if (bRet) {
            SJmoUtility.putLogDetail("SJmoVersionMgr", "isRefreshForce", "Force Refresh");
        }
        return bRet;
    }

    public static boolean isDataPolling(DKCSystemOptionEx sysOptInfo, int iModelStatus) {
        boolean bRet = true;
        if (sysOptInfo == null) {
            SJmoUtility.putLogDetail("SJmoVersionMgr", "isDataPolling", "sysOptInfo = null");
            return bRet;
        }
        if (sysOptInfo.getBitSnSysOpt().get(2)) {
            switch (iModelStatus) {
                case 0: 
                case 2: 
                case 3: 
                case 4: {
                    bRet = false;
                    break;
                }
                case 1: {
                    break;
                }
                default: {
                    SJmoUtility.putLogDetail("SJmoVersionMgr", "isDataPolling", "iModelStatus = " + iModelStatus);
                }
            }
        }
        if (!bRet) {
            SJmoUtility.putLogDetail("SJmoVersionMgr", "isDataPolling", "Data Polling deterrence");
        }
        return bRet;
    }

    public static boolean isRetryDataUpdate(DKCSystemOptionEx sysOptInfo, int iRequest) {
        boolean bRet = true;
        if (sysOptInfo == null) {
            SJmoUtility.putLogDetail("SJmoVersionMgr", "isRetryDataUpdate", "sysOptInfo = null");
            return bRet;
        }
        switch (iRequest) {
            case 3: {
                if (!sysOptInfo.getBitSnSysOpt().get(1) && !sysOptInfo.getBitSnSysOpt().get(3)) break;
                bRet = false;
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 4: {
                if (!sysOptInfo.getBitSnSysOpt().get(3)) break;
                bRet = false;
                break;
            }
            default: {
                SJmoUtility.putLogDetail("SJmoVersionMgr", "isRetryDataUpdate", "iRequest = " + iRequest);
            }
        }
        if (!bRet) {
            SJmoUtility.putLogDetail("SJmoVersionMgr", "isRetryDataUpdate", "Retry DataUpdate deterrence");
        }
        return bRet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DKCSystemOptionEx getSystemOption() {
        try {
            Object object = this.m_SysOptSyncObj;
            synchronized (object) {
                return this.m_SysOpt;
            }
        }
        catch (Exception e) {
            SJmoUtility.putLogDetail("SJmoVersionMgr", "getSystemOption", e.toString());
            return this.m_SysOpt;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refSystemOption(boolean bRefresh) {
        try {
            Object object = this.m_SysOptSyncObj;
            synchronized (object) {
                DKCSystemOptionEx sysOpt = SJdsSupplierMgr.getSupplierMgr().getSystemOptionInfo(bRefresh);
                if (sysOpt == null) {
                    SJmoUtility.putLogDetail("SJmoVersionMgr", "refSystemOption", "sysOpt = null");
                }
                this.m_SysOpt = sysOpt;
            }
        }
        catch (Exception e) {
            SJmoUtility.putLogDetail("SJmoVersionMgr", "refSystemOption", e.toString());
            this.m_SysOpt = null;
        }
    }
}

