/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.rptdt.report.generator;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.velocity.VelocityContext;
import sanproject.sn2.rptdt.csv.SJdtCSVWrapperManager;
import sanproject.sn2.rptdt.csv.wrapper.SJdtCacheInfoCSVWrapper;
import sanproject.sn2.rptdt.csv.wrapper.SJdtDkcInfoCSVWrapper;
import sanproject.sn2.rptdt.csv.wrapper.SJdtHMPkInfoCSVWrapper;
import sanproject.sn2.rptdt.csv.wrapper.SJdtLdevCapaInfoCSVWrapper;
import sanproject.sn2.rptdt.csv.wrapper.SJdtLdevCountInfoCSVWrapper;
import sanproject.sn2.rptdt.csv.wrapper.SJdtMicroVersionCSVWrapper;
import sanproject.sn2.rptdt.csv.wrapper.SJdtPdevCapaInfoCSVWrapper;
import sanproject.sn2.rptdt.csv.wrapper.SJdtSysoptInfoCSVWrapper;
import sanproject.sn2.rptdt.exception.SJdtRPTDTException;
import sanproject.sn2.rptdt.report.SJdtReportGeneratorManager;
import sanproject.sn2.rptdt.report.generator.SJdtArrayglobalReportGenerator;

public class SJdtHMArrayglobalReportGenerator
extends SJdtArrayglobalReportGenerator {
    private static final String REPORT_NAME = "Arrayglobal";
    private static final String CONTENTS_BODY_VM_FILE_PATH = "/sanproject/sn2/rptdt/template/arrayglobal/vm/contentsBody_HMArrayglobal.vm";

    @Override
    public void generateContentsBody() throws SJdtRPTDTException {
        VelocityContext context = SJdtReportGeneratorManager.getVelocityContext();
        this.setFixedStr(context);
        this.setVariableStr(context);
        String generateFilePath = this.OUTPUT_HTML_DIR + this.getContentsBodyHtmlFileName();
        SJdtReportGeneratorManager.generateFile(context, CONTENTS_BODY_VM_FILE_PATH, generateFilePath);
    }

    @Override
    public void setFixedStr(VelocityContext context) {
        context.put("storageSystemType", (Object)SJdtReportGeneratorManager.getGuidanceValue("Arrayglobal.storageSystemType"));
        context.put("serialNumber", (Object)SJdtReportGeneratorManager.getGuidanceValue("Arrayglobal.serialNumber"));
        context.put("fullSerialNumber", (Object)SJdtReportGeneratorManager.getGuidanceValue("Arrayglobal.fullSerialNumber"));
        context.put("ipAddress", (Object)SJdtReportGeneratorManager.getGuidanceValue("Arrayglobal.ipAddress"));
        context.put("microProgramVersions", (Object)SJdtReportGeneratorManager.getGuidanceValue("Arrayglobal.microProgramVersions"));
        context.put("main", (Object)SJdtReportGeneratorManager.getGuidanceValue("Arrayglobal.main"));
        context.put("chb", (Object)SJdtReportGeneratorManager.getGuidanceValue("Arrayglobal.chb"));
        context.put("dkb", (Object)SJdtReportGeneratorManager.getGuidanceValue("Arrayglobal.dkb"));
        context.put("ramBoot", (Object)SJdtReportGeneratorManager.getGuidanceValue("Arrayglobal.ramBoot"));
        context.put("romBoot", (Object)SJdtReportGeneratorManager.getGuidanceValue("Arrayglobal.romBoot"));
        context.put("config", (Object)SJdtReportGeneratorManager.getGuidanceValue("Arrayglobal.config"));
        context.put("hdd", (Object)SJdtReportGeneratorManager.getGuidanceValue("Arrayglobal.hdd"));
        context.put("hddSvp", (Object)SJdtReportGeneratorManager.getGuidanceValue("Arrayglobal.hddSvp"));
        context.put("expander", (Object)SJdtReportGeneratorManager.getGuidanceValue("Arrayglobal.expander"));
        context.put("expanderDbf", (Object)SJdtReportGeneratorManager.getGuidanceValue("Arrayglobal.expanderDbf"));
        context.put("cmssd", (Object)SJdtReportGeneratorManager.getGuidanceValue("Arrayglobal.cmssd"));
        context.put("chbIscsi", (Object)SJdtReportGeneratorManager.getGuidanceValue("Arrayglobal.chbIscsi"));
        context.put("chbFc16g", (Object)SJdtReportGeneratorManager.getGuidanceValue("Arrayglobal.chbFc16g"));
        context.put("chbFc32g", (Object)SJdtReportGeneratorManager.getGuidanceValue("Arrayglobal.chbFc32g"));
        context.put("gum", (Object)SJdtReportGeneratorManager.getGuidanceValue("Arrayglobal.gum"));
        context.put("pum", (Object)SJdtReportGeneratorManager.getGuidanceValue("Arrayglobal.pum"));
        context.put("hnasfwinst", (Object)SJdtReportGeneratorManager.getGuidanceValue("Arrayglobal.hnasfwinst"));
        context.put("hnasfw", (Object)SJdtReportGeneratorManager.getGuidanceValue("Arrayglobal.hnasfw"));
        context.put("printoutTool", (Object)SJdtReportGeneratorManager.getGuidanceValue("Arrayglobal.printoutTool"));
        context.put("numberOfCus", (Object)SJdtReportGeneratorManager.getGuidanceValue("Arrayglobal.numberOfCus"));
        context.put("cacheSize", (Object)SJdtReportGeneratorManager.getGuidanceValue("Arrayglobal.cacheSize"));
        context.put("sharedMemorySize", (Object)SJdtReportGeneratorManager.getGuidanceValue("Arrayglobal.sharedMemorySize"));
        context.put("numberOfDkbs", (Object)SJdtReportGeneratorManager.getGuidanceValue("Arrayglobal.numberOfDkbs"));
        context.put("systemOptions", (Object)SJdtReportGeneratorManager.getGuidanceValue("Arrayglobal.systemOptions"));
        context.put("driveCapacity", (Object)SJdtReportGeneratorManager.getGuidanceValue("Arrayglobal.driveCapacity"));
        context.put("spareDriveCapacity", (Object)SJdtReportGeneratorManager.getGuidanceValue("Arrayglobal.spareDriveCapacity"));
        context.put("freeDriveCapacity", (Object)SJdtReportGeneratorManager.getGuidanceValue("Arrayglobal.freeDriveCapacity"));
        context.put("VolumeCapacity", (Object)SJdtReportGeneratorManager.getGuidanceValue("Arrayglobal.VolumeCapacity"));
        context.put("allocated", (Object)SJdtReportGeneratorManager.getGuidanceValue("Arrayglobal.allocated"));
        context.put("unallocated", (Object)SJdtReportGeneratorManager.getGuidanceValue("Arrayglobal.unallocated"));
        context.put("reserved", (Object)SJdtReportGeneratorManager.getGuidanceValue("Arrayglobal.reserved"));
        context.put("free", (Object)SJdtReportGeneratorManager.getGuidanceValue("Arrayglobal.free"));
        context.put("total", (Object)SJdtReportGeneratorManager.getGuidanceValue("Arrayglobal.total"));
        context.put("internalVolumes", (Object)SJdtReportGeneratorManager.getGuidanceValue("Arrayglobal.internalVolumes"));
        context.put("externalVolumes", (Object)SJdtReportGeneratorManager.getGuidanceValue("Arrayglobal.externalVolumes"));
        context.put("totalVolumes", (Object)SJdtReportGeneratorManager.getGuidanceValue("Arrayglobal.totalVolumes"));
        context.put("Allocated", (Object)SJdtReportGeneratorManager.getGuidanceValue("Arrayglobal.Allocated"));
        context.put("Unallocated", (Object)SJdtReportGeneratorManager.getGuidanceValue("Arrayglobal.Unallocated"));
        context.put("Reserved", (Object)SJdtReportGeneratorManager.getGuidanceValue("Arrayglobal.Reserved"));
        context.put("vvol", (Object)SJdtReportGeneratorManager.getGuidanceValue("Arrayglobal.vvol"));
        context.put("numberOfLdevs", (Object)SJdtReportGeneratorManager.getGuidanceValue("Arrayglobal.numberOfLdevs"));
    }

    @Override
    public void setVariableStr(VelocityContext context) {
        SJdtMicroVersionCSVWrapper microVersion = (SJdtMicroVersionCSVWrapper)SJdtCSVWrapperManager.getCsvWrapper("MicroVersion.csv");
        SJdtDkcInfoCSVWrapper dkcInfo = (SJdtDkcInfoCSVWrapper)SJdtCSVWrapperManager.getCsvWrapper("DkcInfo.csv");
        SJdtCacheInfoCSVWrapper cacheInfo = (SJdtCacheInfoCSVWrapper)SJdtCSVWrapperManager.getCsvWrapper("CacheInfo.csv");
        SJdtSysoptInfoCSVWrapper sysoptInfo = (SJdtSysoptInfoCSVWrapper)SJdtCSVWrapperManager.getCsvWrapper("SysoptInfo.csv");
        SJdtLdevCapaInfoCSVWrapper ldevCapaInfo = (SJdtLdevCapaInfoCSVWrapper)SJdtCSVWrapperManager.getCsvWrapper("LdevCapaInfo.csv");
        SJdtLdevCountInfoCSVWrapper ldevCountInfo = (SJdtLdevCountInfoCSVWrapper)SJdtCSVWrapperManager.getCsvWrapper("LdevCountInfo.csv");
        SJdtPdevCapaInfoCSVWrapper pdevCapaInfo = (SJdtPdevCapaInfoCSVWrapper)SJdtCSVWrapperManager.getCsvWrapper("PdevCapaInfo.csv");
        SJdtHMPkInfoCSVWrapper pkInfo = (SJdtHMPkInfoCSVWrapper)SJdtCSVWrapperManager.getCsvWrapper("PkInfo.csv");
        String[] dkcInfoRecord = dkcInfo.getRecord(0);
        String storageSystemType = dkcInfo.getValue(dkcInfoRecord, "Storage System Type");
        context.put("valueOfStorageSystemType", (Object)storageSystemType);
        String serialNumber = dkcInfo.getValue(dkcInfoRecord, "Serial Number#");
        context.put("serialNumber", (Object)SJdtReportGeneratorManager.getGuidanceValue("Arrayglobal.serialNumber"));
        context.put("valueOfSerialNumber", (Object)serialNumber);
        String ipAddress = dkcInfo.getValue(dkcInfoRecord, "IP Address");
        context.put("valueOfIpAddress", (Object)ipAddress);
        String numberOfCus = dkcInfo.getValue(dkcInfoRecord, "Number of CUs");
        context.put("valueOfNumberOfCus", (Object)numberOfCus);
        String[] microVersionRecord = microVersion.getRecord(0);
        String dkcmain = microVersion.getValue(microVersionRecord, "DKCMAIN");
        context.put("valueOfMain", (Object)dkcmain);
        String dkb = microVersion.getValue(microVersionRecord, "DKB");
        context.put("valueOfDkb", (Object)dkb);
        String ramBoot = microVersion.getValue(microVersionRecord, "RAM BOOT");
        context.put("valueOfRamBoot", (Object)ramBoot);
        String romBoot = microVersion.getValue(microVersionRecord, "ROM BOOT");
        context.put("valueOfRomBoot", (Object)romBoot);
        String config = microVersion.getValue(microVersionRecord, "Config");
        context.put("valueOfConfig", (Object)config);
        ArrayList<String> hdd = new ArrayList<String>();
        ArrayList<String> cmssd = new ArrayList<String>();
        ArrayList<String> expander = new ArrayList<String>();
        ArrayList<String> hnasfwlist = new ArrayList<String>(2);
        ArrayList<String> unihvisorlist = new ArrayList<String>(2);
        ArrayList<String> nasfwinstlist = new ArrayList<String>(2);
        for (int i = 0; i < microVersion.getCsvDataListSize(); ++i) {
            String hnasfw;
            String expanderStr;
            String cmssdStr;
            String hddStr = microVersion.getValue(i, "HDD");
            if (StringUtils.isNotEmpty((String)hddStr)) {
                hdd.add(hddStr);
            }
            if (StringUtils.isNotEmpty((String)(cmssdStr = microVersion.getValue(i, "CFM")))) {
                cmssd.add(cmssdStr);
            }
            if (StringUtils.isNotEmpty((String)(expanderStr = microVersion.getValue(i, "Expander")))) {
                expander.add(expanderStr);
            }
            if (StringUtils.isNotEmpty((String)(hnasfw = microVersion.getValue(i, "NASFW")))) {
                hnasfwlist.add(hnasfw);
            } else if (hnasfwlist.size() == 0) {
                hnasfwlist.add("");
            }
            String pum = microVersion.getValue(i, "Unified Hypervisor");
            if (StringUtils.isNotEmpty((String)pum)) {
                unihvisorlist.add(pum);
            } else if (unihvisorlist.size() == 0) {
                unihvisorlist.add("");
            }
            String hnasfwinst = microVersion.getValue(i, "NASFWINST");
            if (StringUtils.isNotEmpty((String)hnasfwinst)) {
                nasfwinstlist.add(hnasfwinst);
                continue;
            }
            if (nasfwinstlist.size() != 0) continue;
            nasfwinstlist.add("");
        }
        if (hdd.size() == 0) {
            hdd.add("");
        }
        if (cmssd.size() == 0) {
            cmssd.add("");
        }
        if (expander.size() == 0) {
            expander.add("");
        }
        context.put("valueOfHdd", hdd);
        context.put("valueOfCmssd", cmssd);
        context.put("valueOfExpander", expander);
        String chbIscsi = microVersion.getValue(microVersionRecord, "CHB(iSCSI)");
        context.put("valueOfChbIscsi", (Object)chbIscsi);
        String chbFc16g = microVersion.getValue(microVersionRecord, "CHB(FC16G)");
        context.put("valueOfChbFc16g", (Object)chbFc16g);
        String chbFc32g = microVersion.getValue(microVersionRecord, "CHB(FC32G)");
        context.put("valueOfChbFc32g", (Object)chbFc32g);
        String gum = microVersion.getValue(microVersionRecord, "GUM");
        context.put("valueOfGum", (Object)gum);
        context.put("valueOfPum", unihvisorlist);
        context.put("valueOfHnasfwinst", nasfwinstlist);
        context.put("valueOfHnasfw", hnasfwlist);
        context.put("valueOfHnasPackInst", (Object)pkInfo.isHnasPackInstall());
        String printoutTool = microVersion.getValue(microVersionRecord, "Printout Tool");
        context.put("valueOfPrintoutTool", (Object)printoutTool);
        List<String[]> cacheInfoRecordList = cacheInfo.getPrefixMatchedAllRecord("CTL", "Location");
        String cacheSize = cacheInfo.getSumSize(cacheInfoRecordList, "Cache Size(GB)");
        String sharedMemorySize = cacheInfo.getSumSizeDecimalPoint(cacheInfoRecordList, "SM Size(MB)");
        context.put("valueOfCacheSize", (Object)cacheSize);
        context.put("valueOfSharedMemorySize", (Object)sharedMemorySize);
        String numberOfDkifbs = dkcInfo.getValue(dkcInfoRecord, "Number of DKBs");
        context.put("valueOfNumberOfDkbs", (Object)numberOfDkifbs);
        ArrayList<String> systemOptions = new ArrayList<String>();
        for (int i = 0; i < sysoptInfo.getCsvDataListSize(); ++i) {
            systemOptions.add(sysoptInfo.getValue(i, "System Option On"));
        }
        context.put("valueOfSystemOptions", systemOptions);
        String[] pdevCapaInfoRecord = pdevCapaInfo.getMatchedOneRecord("Total Capacity(TB)", "PDEV Kind");
        String driveCapacity = pdevCapaInfo.getDriveCapacity(pdevCapaInfoRecord);
        context.put("valueOfDriveCapacity", (Object)driveCapacity);
        String spareDriveCapacity = pdevCapaInfo.getValue(pdevCapaInfoRecord, "Spare Drive");
        spareDriveCapacity = StringUtils.defaultIfEmpty((String)spareDriveCapacity, (String)"0");
        context.put("valueOfSpareDriveCapacity", (Object)spareDriveCapacity);
        String freeDriveCapacity = pdevCapaInfo.getValue(pdevCapaInfoRecord, "Free Drive");
        freeDriveCapacity = StringUtils.defaultIfEmpty((String)freeDriveCapacity, (String)"0");
        context.put("valueOfFreeDriveCapacity", (Object)freeDriveCapacity);
        String[] openInternalRecord = ldevCapaInfo.getMatchedOneRecord("Internal OPEN Volumes", "Volume Kind");
        String openInternalAllocated = ldevCapaInfo.getValue(openInternalRecord, "Allocated LDEV Capacity(GB)");
        context.put("valueOfInternalAllocated", (Object)openInternalAllocated);
        String openInternalUnallocated = ldevCapaInfo.getValue(openInternalRecord, "Unallocated LDEV Capacity(GB)");
        context.put("valueOfInternalUnallocated", (Object)openInternalUnallocated);
        String openInternalReserved = ldevCapaInfo.getValue(openInternalRecord, "Reserved Capacity(GB)");
        context.put("valueOfInternalReserved", (Object)openInternalReserved);
        String openInternalFree = ldevCapaInfo.getValue(openInternalRecord, "Free Space(GB)");
        context.put("valueOfInternalFree", (Object)openInternalFree);
        String openInternalTotal = ldevCapaInfo.getValue(openInternalRecord, "Total Capacity(GB)");
        context.put("valueOfInternalTotal", (Object)openInternalTotal);
        String[] openExternalRecord = ldevCapaInfo.getMatchedOneRecord("External OPEN Volumes", "Volume Kind");
        String openExternalAllocated = ldevCapaInfo.getValue(openExternalRecord, "Allocated LDEV Capacity(GB)");
        context.put("valueOfExternalAllocated", (Object)openExternalAllocated);
        String openExternalUnallocated = ldevCapaInfo.getValue(openExternalRecord, "Unallocated LDEV Capacity(GB)");
        context.put("valueOfExternalUnallocated", (Object)openExternalUnallocated);
        String openExternalReserved = ldevCapaInfo.getValue(openExternalRecord, "Reserved Capacity(GB)");
        context.put("valueOfExternalReserved", (Object)openExternalReserved);
        String openExternalFree = ldevCapaInfo.getValue(openExternalRecord, "Free Space(GB)");
        context.put("valueOfExternalFree", (Object)openExternalFree);
        String openExternalTotal = ldevCapaInfo.getValue(openExternalRecord, "Total Capacity(GB)");
        context.put("valueOfExternalTotal", (Object)openExternalTotal);
        String[] openTotalRecord = ldevCapaInfo.getMatchedOneRecord("Total OPEN Volumes", "Volume Kind");
        String openTotalAllocated = ldevCapaInfo.getValue(openTotalRecord, "Allocated LDEV Capacity(GB)");
        context.put("valueOfTotalAllocated", (Object)openTotalAllocated);
        String openTotalUnallocated = ldevCapaInfo.getValue(openTotalRecord, "Unallocated LDEV Capacity(GB)");
        context.put("valueOfTotalUnallocated", (Object)openTotalUnallocated);
        String openTotalReserved = ldevCapaInfo.getValue(openTotalRecord, "Reserved Capacity(GB)");
        context.put("valueOfTotalReserved", (Object)openTotalReserved);
        String openTotalFree = ldevCapaInfo.getValue(openTotalRecord, "Free Space(GB)");
        context.put("valueOfTotalFree", (Object)openTotalFree);
        String openTotalTotal = ldevCapaInfo.getValue(openTotalRecord, "Total Capacity(GB)");
        context.put("valueOfTotalTotal", (Object)openTotalTotal);
        String[] numLdevsInternalRecord = ldevCountInfo.getMatchedOneRecord("Internal Volumes", "Volume Kind");
        String numLdevsInternalOpenAllocated = ldevCountInfo.getValue(numLdevsInternalRecord, "Allocated OPEN LDEVs");
        context.put("valueOfNumLdevsInternalAllocated", (Object)numLdevsInternalOpenAllocated);
        String numLdevsInternalOpenUnallocated = ldevCountInfo.getValue(numLdevsInternalRecord, "Unallocated OPEN LDEVs");
        context.put("valueOfNumLdevsInternalUnallocated", (Object)numLdevsInternalOpenUnallocated);
        String numLdevsInternalOpenReserved = ldevCountInfo.getValue(numLdevsInternalRecord, "Reserved OPEN LDEVs");
        context.put("valueOfNumLdevsInternalReserved", (Object)numLdevsInternalOpenReserved);
        String numLdevsInternalVvol = ldevCountInfo.getValue(numLdevsInternalRecord, "V-VOL");
        if (numLdevsInternalVvol.equals("")) {
            numLdevsInternalVvol = "-";
        }
        context.put("valueOfNumLdevsInternalVvol", (Object)numLdevsInternalVvol);
        String numLdevsInternalTotal = ldevCountInfo.getValue(numLdevsInternalRecord, "Total(All LDEVs)");
        context.put("valueOfNumLdevsInternalTotal", (Object)numLdevsInternalTotal);
        String[] numLdevsExternalRecord = ldevCountInfo.getMatchedOneRecord("External Volumes", "Volume Kind");
        String numLdevsExternalOpenAllocated = ldevCountInfo.getValue(numLdevsExternalRecord, "Allocated OPEN LDEVs");
        context.put("valueOfNumLdevsExternalAllocated", (Object)numLdevsExternalOpenAllocated);
        String numLdevsExternalOpenUnallocated = ldevCountInfo.getValue(numLdevsExternalRecord, "Unallocated OPEN LDEVs");
        context.put("valueOfNumLdevsExternalUnallocated", (Object)numLdevsExternalOpenUnallocated);
        String numLdevsExternalOpenReserved = ldevCountInfo.getValue(numLdevsExternalRecord, "Reserved OPEN LDEVs");
        context.put("valueOfNumLdevsExternalReserved", (Object)numLdevsExternalOpenReserved);
        String numLdevsExternalVvol = ldevCountInfo.getValue(numLdevsExternalRecord, "V-VOL");
        if (numLdevsExternalVvol.equals("")) {
            numLdevsExternalVvol = "-";
        }
        context.put("valueOfNumLdevsExternalVvol", (Object)numLdevsExternalVvol);
        String numLdevsExternalTotal = ldevCountInfo.getValue(numLdevsExternalRecord, "Total(All LDEVs)");
        context.put("valueOfNumLdevsExternalTotal", (Object)numLdevsExternalTotal);
        String[] numLdevsTotalRecord = ldevCountInfo.getMatchedOneRecord("Total Volumes", "Volume Kind");
        String numLdevsTotalOpenAllocated = ldevCountInfo.getValue(numLdevsTotalRecord, "Allocated OPEN LDEVs");
        context.put("valueOfNumLdevsTotalAllocated", (Object)numLdevsTotalOpenAllocated);
        String numLdevsTotalOpenUnallocated = ldevCountInfo.getValue(numLdevsTotalRecord, "Unallocated OPEN LDEVs");
        context.put("valueOfNumLdevsTotalUnallocated", (Object)numLdevsTotalOpenUnallocated);
        String numLdevsTotalOpenReserved = ldevCountInfo.getValue(numLdevsTotalRecord, "Reserved OPEN LDEVs");
        context.put("valueOfNumLdevsTotalReserved", (Object)numLdevsTotalOpenReserved);
        String numLdevsTotalVvol = ldevCountInfo.getValue(numLdevsTotalRecord, "V-VOL");
        context.put("valueOfNumLdevsTotalVvol", (Object)numLdevsTotalVvol);
        String numLdevsTotalTotal = ldevCountInfo.getValue(numLdevsTotalRecord, "Total(All LDEVs)");
        context.put("valueOfNumLdevsTotalTotal", (Object)numLdevsTotalTotal);
    }
}

