/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.rptdt.report.generator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import sanproject.sn2.rptdt.csv.SJdtCSVWrapperManager;
import sanproject.sn2.rptdt.csv.wrapper.SJdtIscsiHostInfoCSVWrapper;
import sanproject.sn2.rptdt.csv.wrapper.SJdtIscsiTargetInfoCSVWrapper;
import sanproject.sn2.rptdt.csv.wrapper.SJdtLunPortInfoCSVWrapper;
import sanproject.sn2.rptdt.csv.wrapper.SJdtWwnInfoCSVWrapper;
import sanproject.sn2.rptdt.report.generator.SJdtTableReportGenerator;
import sanproject.sn2.rptdt.util.SJdtRPTDTDevice;

public class SJdtHostReportGenerator
extends SJdtTableReportGenerator {
    private static final String REPORT_NAME = "Host";
    private static final boolean IS_GRAPHIC_REPORT = false;
    private static final boolean USE_TABLE_SORT = true;
    private static final boolean USE_CONTENTS_FOOTER = false;
    private static final String[] HEADER_KEY_ARRAY = new String[]{"portLocation", "portInternalWwn", "portSecurity", "hostGroup", "hostMode", "hostModeOption", "hostName", "hbaWwn"};
    private static final String[] HM_HEADER_KEY_ARRAY = new String[]{"portLocation", "type", "portInternalWwn", "portSecurity", "hostGroupIscsiTargetAlias", "iscsiTargetName", "hostMode", "hostModeOption", "hostName", "hbaWwnIscsiName"};
    private static final int COLUMN_LENGTH = SJdtHostReportGenerator.getColumnLengthForKeySort(HEADER_KEY_ARRAY.length);
    private static final int HM_COLUMN_LENGTH = SJdtHostReportGenerator.getColumnLengthForKeySort(HM_HEADER_KEY_ARRAY.length);
    private static final String MENU_LINK_VIEW_KEY = "Common.menu.Host";
    private static final String EXPLANATION_KEY = "Common.explanation.Host";
    private static final String TABLE_HEADER_BASE_KEY = "Host.table.header";
    private static final String REPORT_FRAMESET_HTML_FILE_NAME = "Host.html";
    private static final String MENU_FRAMESET_HTML_FILE_NAME = "menuFrameset_Host.html";
    private static final String MENU_BODY_HTML_FILE_NAME = "menuBody_Host.html";
    private static final String CONTENTS_FRAMESET_HTML_FILE_NAME = "contentsFrameset_Host.html";
    private static final String CONTENTS_TITLE_HTML_FILE_NAME = "contentsTitle_Host.html";
    private static final String CONTENTS_BODY_HTML_FILE_NAME = "contentsBody_Host.html";

    @Override
    public String getReportName() {
        return REPORT_NAME;
    }

    @Override
    public boolean isGraphicReport() {
        return false;
    }

    @Override
    public boolean useTableSort() {
        return true;
    }

    @Override
    public boolean useContentsFooter() {
        return false;
    }

    @Override
    public String[] getTableHeaderKeyArray() {
        if (SJdtRPTDTDevice.isHmdev()) {
            return HM_HEADER_KEY_ARRAY;
        }
        return HEADER_KEY_ARRAY;
    }

    @Override
    public String getMenuLinkViewKey() {
        return MENU_LINK_VIEW_KEY;
    }

    @Override
    public String getExplanationKey() {
        return EXPLANATION_KEY;
    }

    @Override
    public String getTableHeaderBaseKey() {
        return TABLE_HEADER_BASE_KEY;
    }

    @Override
    public String getReportFramesetHtmlFileName() {
        return REPORT_FRAMESET_HTML_FILE_NAME;
    }

    @Override
    public String getMenuFramesetHtmlFileName() {
        return MENU_FRAMESET_HTML_FILE_NAME;
    }

    @Override
    public String getMenuBodyHtmlFileName() {
        return MENU_BODY_HTML_FILE_NAME;
    }

    @Override
    public String getContentsFramesetHtmlFileName() {
        return CONTENTS_FRAMESET_HTML_FILE_NAME;
    }

    @Override
    public String getContentsTitleHtmlFileName() {
        return CONTENTS_TITLE_HTML_FILE_NAME;
    }

    @Override
    public String getContentsBodyHtmlFileName() {
        return CONTENTS_BODY_HTML_FILE_NAME;
    }

    @Override
    public boolean isEnableSortKey() {
        return true;
    }

    @Override
    public List<String[]> getTableDataList() {
        ArrayList<String[]> tableDataList = new ArrayList<String[]>();
        SJdtWwnInfoCSVWrapper wwnInfo = (SJdtWwnInfoCSVWrapper)SJdtCSVWrapperManager.getCsvWrapper("WwnInfo.csv");
        SJdtLunPortInfoCSVWrapper lunPortInfo = (SJdtLunPortInfoCSVWrapper)SJdtCSVWrapperManager.getCsvWrapper("LunPortInfo.csv");
        SJdtIscsiTargetInfoCSVWrapper iscsiTagetInfo = (SJdtIscsiTargetInfoCSVWrapper)SJdtCSVWrapperManager.getCsvWrapper("IscsiTargetInfo.csv");
        SJdtIscsiHostInfoCSVWrapper iscsiHostInfo = (SJdtIscsiHostInfoCSVWrapper)SJdtCSVWrapperManager.getCsvWrapper("IscsiHostInfo.csv");
        List<String[]> csvDataList = wwnInfo.getCsvDataList();
        for (String[] wwnInfoRecord : csvDataList) {
            String iscsiTargetName;
            String packageType;
            String port;
            String[] oneRecord = null;
            oneRecord = SJdtRPTDTDevice.isHmdev() ? new String[HM_COLUMN_LENGTH] : new String[COLUMN_LENGTH];
            oneRecord[((Integer)SJdtHostReportGenerator.headerMap.get((Object)"portLocation")).intValue()] = port = wwnInfo.getValue(wwnInfoRecord, "Port");
            oneRecord[((Integer)SJdtHostReportGenerator.headerMap.get((Object)"type")).intValue()] = packageType = wwnInfo.getValue(wwnInfoRecord, "Package Type");
            oneRecord[((Integer)SJdtHostReportGenerator.headerMap.get((Object)"hostGroupIscsiTargetAlias")).intValue()] = wwnInfo.getValue(wwnInfoRecord, "Host Group");
            String hostMode = wwnInfo.getValue(wwnInfoRecord, "Host Mode");
            oneRecord[((Integer)SJdtHostReportGenerator.headerMap.get((Object)"hostMode")).intValue()] = hostMode.toUpperCase();
            oneRecord[((Integer)SJdtHostReportGenerator.headerMap.get((Object)"hostModeOption")).intValue()] = wwnInfo.getValue(wwnInfoRecord, "Host Mode Option");
            String[] lunPortInfoRecord = lunPortInfo.getMatchedOneRecord(port, "Port");
            if (!this.isIscsi(packageType)) {
                String wwn = wwnInfo.getValue(wwnInfoRecord, "WWN");
                if (!StringUtils.isNotEmpty((String)wwn)) continue;
                oneRecord[((Integer)SJdtHostReportGenerator.headerMap.get((Object)"hostName")).intValue()] = wwnInfo.getValue(wwnInfoRecord, "Nickname");
                String hbaWwn = wwnInfo.getValue(wwnInfoRecord, "WWN");
                oneRecord[((Integer)SJdtHostReportGenerator.headerMap.get((Object)"hbaWwnIscsiName")).intValue()] = hbaWwn.toUpperCase();
                String securitySwitch = lunPortInfo.getValue(lunPortInfoRecord, "Security Switch");
                oneRecord[((Integer)SJdtHostReportGenerator.headerMap.get((Object)"portSecurity")).intValue()] = this.getOnOffToDisplayStr(securitySwitch);
                String portInternalWwn = lunPortInfo.getValue(lunPortInfoRecord, "WWN");
                oneRecord[((Integer)SJdtHostReportGenerator.headerMap.get((Object)"portInternalWwn")).intValue()] = portInternalWwn.toUpperCase();
                oneRecord[((Integer)SJdtHostReportGenerator.headerMap.get((Object)"iscsiTargetName")).intValue()] = "-";
                tableDataList.add(oneRecord);
                continue;
            }
            String iscsiTargetId = wwnInfo.getValue(wwnInfoRecord, "Host Group#");
            List<String[]> iscsiTrgetListSpecifidPort = iscsiTagetInfo.getMatchedAllRecord(port, "Port");
            List<String[]> iscsiTrgetListSpecifidIscsiId = iscsiTagetInfo.getMatchedAllRecord(iscsiTargetId, "iSCSI Target ID", iscsiTrgetListSpecifidPort);
            String[] iscsiTargetInfoRecord = iscsiTagetInfo.getDefaultRecordValue();
            if (iscsiTrgetListSpecifidIscsiId.size() != 0) {
                iscsiTargetInfoRecord = iscsiTrgetListSpecifidIscsiId.get(0);
            }
            String securitySwitch = iscsiTagetInfo.getValue(iscsiTargetInfoRecord, "Security Switch");
            oneRecord[((Integer)SJdtHostReportGenerator.headerMap.get((Object)"portSecurity")).intValue()] = this.getOnOffToDisplayStr(securitySwitch);
            oneRecord[((Integer)SJdtHostReportGenerator.headerMap.get((Object)"portInternalWwn")).intValue()] = "-";
            oneRecord[((Integer)SJdtHostReportGenerator.headerMap.get((Object)"iscsiTargetName")).intValue()] = iscsiTargetName = iscsiTagetInfo.getValue(iscsiTargetInfoRecord, "iSCSI Target Name");
            List<String[]> iscsiHostListSpecifidPort = iscsiHostInfo.getMatchedAllRecord(port, "Port");
            List<String[]> iscsiHostListSpecifidIscsiId = iscsiHostInfo.getMatchedAllRecord(iscsiTargetId, "iSCSI Target ID", iscsiHostListSpecifidPort);
            for (String[] iscsiHostInfoRecord : iscsiHostListSpecifidIscsiId) {
                String hostName;
                String iscsiName = iscsiHostInfo.getValue(iscsiHostInfoRecord, "iSCSI Name");
                if (!StringUtils.isNotEmpty((String)iscsiName)) continue;
                oneRecord[((Integer)SJdtHostReportGenerator.headerMap.get((Object)"hostName")).intValue()] = hostName = iscsiHostInfo.getValue(iscsiHostInfoRecord, "Host Name");
                oneRecord[((Integer)SJdtHostReportGenerator.headerMap.get((Object)"hbaWwnIscsiName")).intValue()] = iscsiName;
                tableDataList.add(oneRecord);
            }
        }
        Comparator<Object> portLocationOrderByAsc = new Comparator<Object>(){
            private final int portLocationHeaderIndex = SJdtTableReportGenerator.headerMap.get("portLocation");

            @Override
            public int compare(Object record0, Object record1) {
                int result = 0;
                String port0 = ((String[])record0)[this.portLocationHeaderIndex];
                String port1 = ((String[])record1)[this.portLocationHeaderIndex];
                result = port0.compareTo(port1);
                return result;
            }
        };
        Collections.sort(tableDataList, portLocationOrderByAsc);
        return tableDataList;
    }
}

