/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.rptdt.report.generator;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import sanproject.sn2.rptdt.csv.SJdtCSVWrapperManager;
import sanproject.sn2.rptdt.csv.wrapper.SJdtIscsiHostInfoCSVWrapper;
import sanproject.sn2.rptdt.csv.wrapper.SJdtIscsiPortInfoCSVWrapper;
import sanproject.sn2.rptdt.csv.wrapper.SJdtLdevInfoCSVWrapper;
import sanproject.sn2.rptdt.csv.wrapper.SJdtLunInfoCSVWrapper;
import sanproject.sn2.rptdt.csv.wrapper.SJdtLunPortInfoCSVWrapper;
import sanproject.sn2.rptdt.csv.wrapper.SJdtPdevInfoCSVWrapper;
import sanproject.sn2.rptdt.csv.wrapper.SJdtPkInfoCSVWrapper;
import sanproject.sn2.rptdt.csv.wrapper.SJdtWwnInfoCSVWrapper;
import sanproject.sn2.rptdt.report.generator.SJdtTableReportGenerator;
import sanproject.sn2.rptdt.util.SJdtRPTDTDevice;

public class SJdtPortReportGenerator
extends SJdtTableReportGenerator {
    private static final String REPORT_NAME = "Port";
    private static final boolean IS_GRAPHIC_REPORT = false;
    private static final boolean USE_TABLE_SORT = true;
    private static final boolean USE_CONTENTS_FOOTER = false;
    private static final String[] HEADER_KEY_ARRAY = new String[]{"cha", "type", "portLocation", "portAttribute", "portInternalWwn", "fabric", "connectionType", "addressLoopId", "portSecurity", "speed", "resourceGroupName", "resourceGroupId", "numberOfHosts", "numberOfLuns", "numberOfLdevs", "numberOfPgs", "numberOfDkas"};
    private static final String[] HM_HEADER_KEY_ARRAY = new String[]{"chb", "type", "portLocation", "iscsiVirtualPortMode", "tcpPortNumber", "portInternalWwn", "fabric", "connectionType", "ipv4IpAddress", "ipv4SubnetMask", "ipv4DefaultGateway", "ipv6Mode", "ipv6LinkLocalAddress", "ipv6GlobalAdress", "ipv6GlobalAdress2", "ipv6AssignedDefaultGateway", "selectiveAck", "ethernetMtuSize", "keepAliveTimer", "vlanTaggingMode", "vlanId", "chapUserName", "isnsServerMode", "isnsServerIpAddress", "isnsServerTcpPortNumber", "addressLoopId", "portSecurity", "speed", "sfpDataTransferRate", "t10piMode", "resourceGroupName", "resourceGroupId", "numberOfHosts", "numberOfLuns", "numberOfLdevs", "numberOfPgs", "numberOfDkbs"};
    private static final int COLUMN_LENGTH = SJdtPortReportGenerator.getColumnLengthForKeySort(HEADER_KEY_ARRAY.length);
    private static final int HM_COLUMN_LENGTH = SJdtPortReportGenerator.getColumnLengthForKeySort(HM_HEADER_KEY_ARRAY.length);
    private static final String MENU_LINK_VIEW_KEY = "Common.menu.Port";
    private static final String EXPLANATION_KEY = "Common.explanation.Port";
    private static final String TABLE_HEADER_BASE_KEY = "Port.table.header";
    private static final String REPORT_FRAMESET_HTML_FILE_NAME = "Port.html";
    private static final String MENU_FRAMESET_HTML_FILE_NAME = "menuFrameset_Port.html";
    private static final String MENU_BODY_HTML_FILE_NAME = "menuBody_Port.html";
    private static final String CONTENTS_FRAMESET_HTML_FILE_NAME = "contentsFrameset_Port.html";
    private static final String CONTENTS_TITLE_HTML_FILE_NAME = "contentsTitle_Port.html";
    private static final String CONTENTS_BODY_HTML_FILE_NAME = "contentsBody_Port.html";

    @Override
    public String getReportName() {
        return REPORT_NAME;
    }

    @Override
    public boolean isGraphicReport() {
        return false;
    }

    @Override
    public boolean useTableSort() {
        return true;
    }

    @Override
    public boolean useContentsFooter() {
        return false;
    }

    @Override
    public String[] getTableHeaderKeyArray() {
        if (SJdtRPTDTDevice.isHmdev()) {
            return HM_HEADER_KEY_ARRAY;
        }
        return HEADER_KEY_ARRAY;
    }

    @Override
    public String getMenuLinkViewKey() {
        return MENU_LINK_VIEW_KEY;
    }

    @Override
    public String getExplanationKey() {
        return EXPLANATION_KEY;
    }

    @Override
    public String getTableHeaderBaseKey() {
        return TABLE_HEADER_BASE_KEY;
    }

    @Override
    public String getReportFramesetHtmlFileName() {
        return REPORT_FRAMESET_HTML_FILE_NAME;
    }

    @Override
    public String getMenuFramesetHtmlFileName() {
        return MENU_FRAMESET_HTML_FILE_NAME;
    }

    @Override
    public String getMenuBodyHtmlFileName() {
        return MENU_BODY_HTML_FILE_NAME;
    }

    @Override
    public String getContentsFramesetHtmlFileName() {
        return CONTENTS_FRAMESET_HTML_FILE_NAME;
    }

    @Override
    public String getContentsTitleHtmlFileName() {
        return CONTENTS_TITLE_HTML_FILE_NAME;
    }

    @Override
    public String getContentsBodyHtmlFileName() {
        return CONTENTS_BODY_HTML_FILE_NAME;
    }

    @Override
    public boolean isEnableSortKey() {
        return true;
    }

    @Override
    public List<String[]> getTableDataList() {
        ArrayList<String[]> tableDataList = new ArrayList<String[]>();
        SJdtPkInfoCSVWrapper pkInfo = (SJdtPkInfoCSVWrapper)SJdtCSVWrapperManager.getCsvWrapper("PkInfo.csv");
        SJdtLunInfoCSVWrapper lunInfo = (SJdtLunInfoCSVWrapper)SJdtCSVWrapperManager.getCsvWrapper("LunInfo.csv");
        SJdtWwnInfoCSVWrapper wwnInfo = (SJdtWwnInfoCSVWrapper)SJdtCSVWrapperManager.getCsvWrapper("WwnInfo.csv");
        SJdtLdevInfoCSVWrapper ldevInfo = (SJdtLdevInfoCSVWrapper)SJdtCSVWrapperManager.getCsvWrapper("LdevInfo.csv");
        SJdtPdevInfoCSVWrapper pdevInfo = (SJdtPdevInfoCSVWrapper)SJdtCSVWrapperManager.getCsvWrapper("PdevInfo.csv");
        SJdtLunPortInfoCSVWrapper lunPortInfo = (SJdtLunPortInfoCSVWrapper)SJdtCSVWrapperManager.getCsvWrapper("LunPortInfo.csv");
        SJdtIscsiPortInfoCSVWrapper iscsiPortInfo = (SJdtIscsiPortInfoCSVWrapper)SJdtCSVWrapperManager.getCsvWrapper("IscsiPortInfo.csv");
        SJdtIscsiHostInfoCSVWrapper iscsiHostInfo = (SJdtIscsiHostInfoCSVWrapper)SJdtCSVWrapperManager.getCsvWrapper("IscsiHostInfo.csv");
        List<String[]> csvDataList = null;
        String[] lunPortInfoRecord = null;
        String port = null;
        csvDataList = pkInfo.getCsvDataList();
        for (String[] pkInfoRecord : csvDataList) {
            List<String> dkaSet;
            List<String> eccGroupList;
            List<Object> ldevSet;
            List<String[]> lunInfoRecordList;
            String packageType;
            String[] oneRecord = null;
            if (SJdtRPTDTDevice.isHmdev()) {
                oneRecord = new String[HM_COLUMN_LENGTH];
                oneRecord[((Integer)SJdtPortReportGenerator.headerMap.get((Object)"chb")).intValue()] = pkInfo.getValue(pkInfoRecord, "CHB Location");
            } else {
                oneRecord = new String[COLUMN_LENGTH];
                oneRecord[((Integer)SJdtPortReportGenerator.headerMap.get((Object)"cha")).intValue()] = pkInfo.getValue(pkInfoRecord, "CHA Location");
            }
            oneRecord[((Integer)SJdtPortReportGenerator.headerMap.get((Object)"type")).intValue()] = packageType = pkInfo.getValue(pkInfoRecord, "Package Type");
            oneRecord[((Integer)SJdtPortReportGenerator.headerMap.get((Object)"portLocation")).intValue()] = port = pkInfo.getValue(pkInfoRecord, REPORT_NAME);
            lunPortInfoRecord = lunPortInfo.getMatchedOneRecord(port, REPORT_NAME);
            String portInternalWwn = lunPortInfo.getValue(lunPortInfoRecord, "WWN");
            if (!this.isIscsi(packageType)) {
                if (this.isUnified(packageType)) {
                    oneRecord[((Integer)SJdtPortReportGenerator.headerMap.get((Object)"portInternalWwn")).intValue()] = pkInfo.getValue(pkInfoRecord, "Port Internal WWN");
                    oneRecord[((Integer)SJdtPortReportGenerator.headerMap.get((Object)"resourceGroupName")).intValue()] = pkInfo.getValue(pkInfoRecord, "Resource Group Name (Port)");
                    oneRecord[((Integer)SJdtPortReportGenerator.headerMap.get((Object)"resourceGroupId")).intValue()] = pkInfo.getValue(pkInfoRecord, "Resource Group ID (Port)");
                } else {
                    oneRecord[((Integer)SJdtPortReportGenerator.headerMap.get((Object)"portInternalWwn")).intValue()] = pkInfo.getValue(pkInfoRecord, "Port Internal WWN").toUpperCase();
                    oneRecord[((Integer)SJdtPortReportGenerator.headerMap.get((Object)"resourceGroupName")).intValue()] = pkInfo.getValue(pkInfoRecord, "Resource Group Name (Port)");
                    oneRecord[((Integer)SJdtPortReportGenerator.headerMap.get((Object)"resourceGroupId")).intValue()] = pkInfo.getValue(pkInfoRecord, "Resource Group ID (Port)");
                }
                oneRecord[((Integer)SJdtPortReportGenerator.headerMap.get((Object)"iscsiVirtualPortMode")).intValue()] = "-";
                oneRecord[((Integer)SJdtPortReportGenerator.headerMap.get((Object)"tcpPortNumber")).intValue()] = "-";
                oneRecord[((Integer)SJdtPortReportGenerator.headerMap.get((Object)"ipv4IpAddress")).intValue()] = "-";
                oneRecord[((Integer)SJdtPortReportGenerator.headerMap.get((Object)"ipv4SubnetMask")).intValue()] = "-";
                oneRecord[((Integer)SJdtPortReportGenerator.headerMap.get((Object)"ipv4DefaultGateway")).intValue()] = "-";
                oneRecord[((Integer)SJdtPortReportGenerator.headerMap.get((Object)"ipv6Mode")).intValue()] = "-";
                oneRecord[((Integer)SJdtPortReportGenerator.headerMap.get((Object)"ipv6LinkLocalAddress")).intValue()] = "-";
                oneRecord[((Integer)SJdtPortReportGenerator.headerMap.get((Object)"ipv6GlobalAdress")).intValue()] = "-";
                oneRecord[((Integer)SJdtPortReportGenerator.headerMap.get((Object)"ipv6GlobalAdress2")).intValue()] = "-";
                oneRecord[((Integer)SJdtPortReportGenerator.headerMap.get((Object)"ipv6AssignedDefaultGateway")).intValue()] = "-";
                oneRecord[((Integer)SJdtPortReportGenerator.headerMap.get((Object)"selectiveAck")).intValue()] = "-";
                oneRecord[((Integer)SJdtPortReportGenerator.headerMap.get((Object)"ethernetMtuSize")).intValue()] = "-";
                oneRecord[((Integer)SJdtPortReportGenerator.headerMap.get((Object)"keepAliveTimer")).intValue()] = "-";
                oneRecord[((Integer)SJdtPortReportGenerator.headerMap.get((Object)"vlanTaggingMode")).intValue()] = "-";
                oneRecord[((Integer)SJdtPortReportGenerator.headerMap.get((Object)"vlanId")).intValue()] = "-";
                oneRecord[((Integer)SJdtPortReportGenerator.headerMap.get((Object)"chapUserName")).intValue()] = "-";
                oneRecord[((Integer)SJdtPortReportGenerator.headerMap.get((Object)"isnsServerMode")).intValue()] = "-";
                oneRecord[((Integer)SJdtPortReportGenerator.headerMap.get((Object)"isnsServerIpAddress")).intValue()] = "-";
                oneRecord[((Integer)SJdtPortReportGenerator.headerMap.get((Object)"isnsServerTcpPortNumber")).intValue()] = "-";
                if (StringUtils.isNotEmpty((String)portInternalWwn)) {
                    if (!pkInfo.isColumnExist("Port Internal WWN")) {
                        oneRecord[((Integer)SJdtPortReportGenerator.headerMap.get((Object)"resourceGroupName")).intValue()] = pkInfo.getValue(pkInfoRecord, "Resource Group Name (Port)");
                        oneRecord[((Integer)SJdtPortReportGenerator.headerMap.get((Object)"resourceGroupId")).intValue()] = pkInfo.getValue(pkInfoRecord, "Resource Group ID (Port)");
                        oneRecord[((Integer)SJdtPortReportGenerator.headerMap.get((Object)"portInternalWwn")).intValue()] = portInternalWwn.toUpperCase();
                    }
                    String fabric = lunPortInfo.getValue(lunPortInfoRecord, "Fabric");
                    oneRecord[((Integer)SJdtPortReportGenerator.headerMap.get((Object)"fabric")).intValue()] = fabric.toUpperCase();
                    oneRecord[((Integer)SJdtPortReportGenerator.headerMap.get((Object)"connectionType")).intValue()] = lunPortInfo.getValue(lunPortInfoRecord, "Connection");
                    String portAddress = lunPortInfo.getValue(lunPortInfoRecord, "Port Address");
                    String loopId = lunPortInfo.getValue(lunPortInfoRecord, "Loop ID");
                    oneRecord[((Integer)SJdtPortReportGenerator.headerMap.get((Object)"addressLoopId")).intValue()] = this.getDisplayAddressLoopId(portAddress, loopId);
                    String securitySwitch = lunPortInfo.getValue(lunPortInfoRecord, "Security Switch");
                    oneRecord[((Integer)SJdtPortReportGenerator.headerMap.get((Object)"portSecurity")).intValue()] = this.getOnOffToDisplayStr(securitySwitch);
                    oneRecord[((Integer)SJdtPortReportGenerator.headerMap.get((Object)"speed")).intValue()] = lunPortInfo.getValue(lunPortInfoRecord, "Channel Speed");
                    oneRecord[((Integer)SJdtPortReportGenerator.headerMap.get((Object)"sfpDataTransferRate")).intValue()] = pkInfo.getValue(pkInfoRecord, "SFP Data Transfer Rate");
                    oneRecord[((Integer)SJdtPortReportGenerator.headerMap.get((Object)"t10piMode")).intValue()] = pkInfo.getValue(pkInfoRecord, "T10 PI Mode");
                    int numberOfHosts = wwnInfo.getNumberOfHosts(port);
                    oneRecord[((Integer)SJdtPortReportGenerator.headerMap.get((Object)"numberOfHosts")).intValue()] = String.valueOf(numberOfHosts);
                    lunInfoRecordList = lunInfo.getLunsRecordList(port);
                    oneRecord[((Integer)SJdtPortReportGenerator.headerMap.get((Object)"numberOfLuns")).intValue()] = String.valueOf(lunInfoRecordList.size());
                    ldevSet = new ArrayList();
                    ldevSet = lunInfo.getLdevSet(lunInfoRecordList);
                    oneRecord[((Integer)SJdtPortReportGenerator.headerMap.get((Object)"numberOfLdevs")).intValue()] = String.valueOf(ldevSet.size());
                    eccGroupList = ldevInfo.getEccGroupValueSet(ldevSet);
                    oneRecord[((Integer)SJdtPortReportGenerator.headerMap.get((Object)"numberOfPgs")).intValue()] = String.valueOf(eccGroupList.size());
                    dkaSet = pdevInfo.getDkaValueSet(eccGroupList);
                    if (SJdtRPTDTDevice.isHmdev()) {
                        oneRecord[((Integer)SJdtPortReportGenerator.headerMap.get((Object)"numberOfDkbs")).intValue()] = String.valueOf(dkaSet.size());
                    } else {
                        oneRecord[((Integer)SJdtPortReportGenerator.headerMap.get((Object)"numberOfDkas")).intValue()] = String.valueOf(dkaSet.size());
                    }
                } else {
                    if (!pkInfo.isColumnExist("Port Internal WWN")) {
                        oneRecord[((Integer)SJdtPortReportGenerator.headerMap.get((Object)"resourceGroupName")).intValue()] = "-";
                        oneRecord[((Integer)SJdtPortReportGenerator.headerMap.get((Object)"resourceGroupId")).intValue()] = "-";
                        oneRecord[((Integer)SJdtPortReportGenerator.headerMap.get((Object)"portInternalWwn")).intValue()] = "-";
                    }
                    oneRecord[((Integer)SJdtPortReportGenerator.headerMap.get((Object)"fabric")).intValue()] = "-";
                    oneRecord[((Integer)SJdtPortReportGenerator.headerMap.get((Object)"connectionType")).intValue()] = "-";
                    oneRecord[((Integer)SJdtPortReportGenerator.headerMap.get((Object)"addressLoopId")).intValue()] = "-";
                    oneRecord[((Integer)SJdtPortReportGenerator.headerMap.get((Object)"portSecurity")).intValue()] = "-";
                    oneRecord[((Integer)SJdtPortReportGenerator.headerMap.get((Object)"speed")).intValue()] = "-";
                    oneRecord[((Integer)SJdtPortReportGenerator.headerMap.get((Object)"sfpDataTransferRate")).intValue()] = "-";
                    oneRecord[((Integer)SJdtPortReportGenerator.headerMap.get((Object)"t10piMode")).intValue()] = "-";
                    oneRecord[((Integer)SJdtPortReportGenerator.headerMap.get((Object)"numberOfHosts")).intValue()] = "-";
                    oneRecord[((Integer)SJdtPortReportGenerator.headerMap.get((Object)"numberOfLuns")).intValue()] = "-";
                    oneRecord[((Integer)SJdtPortReportGenerator.headerMap.get((Object)"numberOfLdevs")).intValue()] = "-";
                    oneRecord[((Integer)SJdtPortReportGenerator.headerMap.get((Object)"numberOfPgs")).intValue()] = "-";
                    if (SJdtRPTDTDevice.isHmdev()) {
                        oneRecord[((Integer)SJdtPortReportGenerator.headerMap.get((Object)"numberOfDkbs")).intValue()] = "-";
                    } else {
                        oneRecord[((Integer)SJdtPortReportGenerator.headerMap.get((Object)"numberOfDkas")).intValue()] = "-";
                    }
                }
            } else {
                String[] iscsiPortInfoRecord = iscsiPortInfo.getMatchedOneRecord(port, REPORT_NAME);
                String VportMode = iscsiPortInfo.getValue(iscsiPortInfoRecord, "Virtual Port Mode");
                oneRecord[((Integer)SJdtPortReportGenerator.headerMap.get((Object)"iscsiVirtualPortMode")).intValue()] = StringUtils.isNotEmpty((String)VportMode) ? iscsiPortInfo.getValue(iscsiPortInfoRecord, "Virtual Port Mode") : "-";
                if (VportMode.equals("Enabled")) {
                    oneRecord[((Integer)SJdtPortReportGenerator.headerMap.get((Object)"tcpPortNumber")).intValue()] = "-";
                    oneRecord[((Integer)SJdtPortReportGenerator.headerMap.get((Object)"ipv4IpAddress")).intValue()] = "-";
                    oneRecord[((Integer)SJdtPortReportGenerator.headerMap.get((Object)"ipv4SubnetMask")).intValue()] = "-";
                    oneRecord[((Integer)SJdtPortReportGenerator.headerMap.get((Object)"ipv4DefaultGateway")).intValue()] = "-";
                    oneRecord[((Integer)SJdtPortReportGenerator.headerMap.get((Object)"ipv6Mode")).intValue()] = "-";
                    oneRecord[((Integer)SJdtPortReportGenerator.headerMap.get((Object)"ipv6LinkLocalAddress")).intValue()] = "-";
                    oneRecord[((Integer)SJdtPortReportGenerator.headerMap.get((Object)"ipv6GlobalAdress")).intValue()] = "-";
                    oneRecord[((Integer)SJdtPortReportGenerator.headerMap.get((Object)"ipv6GlobalAdress2")).intValue()] = "-";
                    oneRecord[((Integer)SJdtPortReportGenerator.headerMap.get((Object)"ipv6AssignedDefaultGateway")).intValue()] = "-";
                    oneRecord[((Integer)SJdtPortReportGenerator.headerMap.get((Object)"selectiveAck")).intValue()] = "-";
                    oneRecord[((Integer)SJdtPortReportGenerator.headerMap.get((Object)"ethernetMtuSize")).intValue()] = "-";
                    oneRecord[((Integer)SJdtPortReportGenerator.headerMap.get((Object)"keepAliveTimer")).intValue()] = "-";
                    oneRecord[((Integer)SJdtPortReportGenerator.headerMap.get((Object)"vlanTaggingMode")).intValue()] = "-";
                    oneRecord[((Integer)SJdtPortReportGenerator.headerMap.get((Object)"vlanId")).intValue()] = "-";
                } else {
                    oneRecord[((Integer)SJdtPortReportGenerator.headerMap.get((Object)"tcpPortNumber")).intValue()] = iscsiPortInfo.getValue(iscsiPortInfoRecord, "TCP Port Number");
                    oneRecord[((Integer)SJdtPortReportGenerator.headerMap.get((Object)"ipv4IpAddress")).intValue()] = iscsiPortInfo.getValue(iscsiPortInfoRecord, "IPv4 | IP Address");
                    oneRecord[((Integer)SJdtPortReportGenerator.headerMap.get((Object)"ipv4SubnetMask")).intValue()] = iscsiPortInfo.getValue(iscsiPortInfoRecord, "IPv4 | Subnet Mask");
                    oneRecord[((Integer)SJdtPortReportGenerator.headerMap.get((Object)"ipv4DefaultGateway")).intValue()] = iscsiPortInfo.getValue(iscsiPortInfoRecord, "IPv4 | Default Gateway");
                    oneRecord[((Integer)SJdtPortReportGenerator.headerMap.get((Object)"ipv6Mode")).intValue()] = iscsiPortInfo.getValue(iscsiPortInfoRecord, "IPv6 | Mode");
                    oneRecord[((Integer)SJdtPortReportGenerator.headerMap.get((Object)"ipv6LinkLocalAddress")).intValue()] = iscsiPortInfo.getValue(iscsiPortInfoRecord, "IPv6 | Link Local Address");
                    oneRecord[((Integer)SJdtPortReportGenerator.headerMap.get((Object)"ipv6GlobalAdress")).intValue()] = iscsiPortInfo.getValue(iscsiPortInfoRecord, "IPv6 | Global Address");
                    oneRecord[((Integer)SJdtPortReportGenerator.headerMap.get((Object)"ipv6GlobalAdress2")).intValue()] = iscsiPortInfo.getValue(iscsiPortInfoRecord, "IPv6 | Global Address 2");
                    oneRecord[((Integer)SJdtPortReportGenerator.headerMap.get((Object)"ipv6AssignedDefaultGateway")).intValue()] = iscsiPortInfo.getValue(iscsiPortInfoRecord, "IPv6 | Assigned Default Gateway");
                    oneRecord[((Integer)SJdtPortReportGenerator.headerMap.get((Object)"selectiveAck")).intValue()] = iscsiPortInfo.getValue(iscsiPortInfoRecord, "Selective ACK");
                    oneRecord[((Integer)SJdtPortReportGenerator.headerMap.get((Object)"ethernetMtuSize")).intValue()] = iscsiPortInfo.getValue(iscsiPortInfoRecord, "Ethernet MTU Size(Byte) | MTU");
                    oneRecord[((Integer)SJdtPortReportGenerator.headerMap.get((Object)"keepAliveTimer")).intValue()] = iscsiPortInfo.getValue(iscsiPortInfoRecord, "Keep Alive Timer(sec.)");
                    oneRecord[((Integer)SJdtPortReportGenerator.headerMap.get((Object)"vlanTaggingMode")).intValue()] = iscsiPortInfo.getValue(iscsiPortInfoRecord, "VLAN | Tagging Mode");
                    oneRecord[((Integer)SJdtPortReportGenerator.headerMap.get((Object)"vlanId")).intValue()] = iscsiPortInfo.getValue(iscsiPortInfoRecord, "VLAN | ID");
                }
                oneRecord[((Integer)SJdtPortReportGenerator.headerMap.get((Object)"chapUserName")).intValue()] = iscsiPortInfo.getValue(iscsiPortInfoRecord, "CHAP User Name");
                oneRecord[((Integer)SJdtPortReportGenerator.headerMap.get((Object)"isnsServerMode")).intValue()] = iscsiPortInfo.getValue(iscsiPortInfoRecord, "iSNS Server | Mode");
                oneRecord[((Integer)SJdtPortReportGenerator.headerMap.get((Object)"isnsServerIpAddress")).intValue()] = iscsiPortInfo.getValue(iscsiPortInfoRecord, "iSNS Server | IP Address");
                oneRecord[((Integer)SJdtPortReportGenerator.headerMap.get((Object)"isnsServerTcpPortNumber")).intValue()] = iscsiPortInfo.getValue(iscsiPortInfoRecord, "iSNS Server | TCP Port Number");
                oneRecord[((Integer)SJdtPortReportGenerator.headerMap.get((Object)"resourceGroupName")).intValue()] = iscsiPortInfo.getValue(iscsiPortInfoRecord, "Resource Group Name (Port)");
                oneRecord[((Integer)SJdtPortReportGenerator.headerMap.get((Object)"resourceGroupId")).intValue()] = iscsiPortInfo.getValue(iscsiPortInfoRecord, "Resource Group ID (Port)");
                oneRecord[((Integer)SJdtPortReportGenerator.headerMap.get((Object)"portInternalWwn")).intValue()] = iscsiPortInfo.getValue(iscsiPortInfoRecord, "iSCSI Name");
                oneRecord[((Integer)SJdtPortReportGenerator.headerMap.get((Object)"fabric")).intValue()] = "-";
                oneRecord[((Integer)SJdtPortReportGenerator.headerMap.get((Object)"connectionType")).intValue()] = "-";
                oneRecord[((Integer)SJdtPortReportGenerator.headerMap.get((Object)"addressLoopId")).intValue()] = "-";
                String securitySwitch = lunPortInfo.getValue(lunPortInfoRecord, "Security Switch");
                oneRecord[((Integer)SJdtPortReportGenerator.headerMap.get((Object)"portSecurity")).intValue()] = this.getOnOffToDisplayStr(securitySwitch);
                oneRecord[((Integer)SJdtPortReportGenerator.headerMap.get((Object)"speed")).intValue()] = lunPortInfo.getValue(lunPortInfoRecord, "Channel Speed");
                oneRecord[((Integer)SJdtPortReportGenerator.headerMap.get((Object)"sfpDataTransferRate")).intValue()] = PACKAGETYPE_ISCSI[0].equals(packageType) ? pkInfo.getValue(pkInfoRecord, "SFP Data Transfer Rate") : "-";
                oneRecord[((Integer)SJdtPortReportGenerator.headerMap.get((Object)"t10piMode")).intValue()] = "-";
                List<String[]> iscsiHostListSpecifidPort = iscsiHostInfo.getMatchedAllRecord(port, REPORT_NAME);
                int cnt = 0;
                for (String[] iscsiHostInfoSpecifidPort : iscsiHostListSpecifidPort) {
                    if (!StringUtils.isNotEmpty((String)iscsiHostInfo.getValue(iscsiHostInfoSpecifidPort, "iSCSI Name"))) continue;
                    ++cnt;
                }
                oneRecord[((Integer)SJdtPortReportGenerator.headerMap.get((Object)"numberOfHosts")).intValue()] = String.valueOf(cnt);
                lunInfoRecordList = lunInfo.getLunsRecordList(port);
                oneRecord[((Integer)SJdtPortReportGenerator.headerMap.get((Object)"numberOfLuns")).intValue()] = String.valueOf(lunInfoRecordList.size());
                ldevSet = new ArrayList();
                ldevSet = lunInfo.getLdevSet(lunInfoRecordList);
                oneRecord[((Integer)SJdtPortReportGenerator.headerMap.get((Object)"numberOfLdevs")).intValue()] = String.valueOf(ldevSet.size());
                eccGroupList = ldevInfo.getEccGroupValueSet(ldevSet);
                oneRecord[((Integer)SJdtPortReportGenerator.headerMap.get((Object)"numberOfPgs")).intValue()] = String.valueOf(eccGroupList.size());
                dkaSet = pdevInfo.getDkaValueSet(eccGroupList);
                if (SJdtRPTDTDevice.isHmdev()) {
                    oneRecord[((Integer)SJdtPortReportGenerator.headerMap.get((Object)"numberOfDkbs")).intValue()] = String.valueOf(dkaSet.size());
                } else {
                    oneRecord[((Integer)SJdtPortReportGenerator.headerMap.get((Object)"numberOfDkas")).intValue()] = String.valueOf(dkaSet.size());
                }
            }
            tableDataList.add(oneRecord);
        }
        return tableDataList;
    }

    private String getDisplayAddressLoopId(String portAddress, String loopId) {
        StringBuilder sb = new StringBuilder();
        sb.append(portAddress.toUpperCase());
        sb.append("(").append(loopId).append(")");
        return sb.toString();
    }
}

