/*
 * Decompiled with CFR 0.152.
 */
package sanproject.serverux.data;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Vector;
import sanproject.common.Robj_interface_CRNoticeInfo;
import sanproject.common.Robj_interface_CRURLInfo;
import sanproject.serverux.data.GetRmiException;
import sanproject.serverux.data.JNIException;
import sanproject.serverux.data.RmiConObjInFile;
import sanproject.serverux.data.RmiConObjOutFile;
import sanproject.serverux.data.RmiObjImpl;
import sanproject.serverux.data.SANRmiException;
import sanproject.serverux.data.StringControl;
import sanproject.serverux.data.common_Obj;
import sanproject.serverux.dataimpl.CREffectiveInfo;
import sanproject.serverux.dataimpl.CREnvInfo;
import sanproject.serverux.dataimpl.CRNoticeInfo;
import sanproject.serverux.dataimpl.CRURLInfo;
import sanproject.serverux.dataimpl.CRgetURLInfo;

public class CRObj
extends common_Obj {
    protected static final int ON_DELETE = 1;
    protected static final int OFF_DELETE = 0;
    protected static final int LV_NO = 3;
    protected static final int LV_RELEASE = 2;
    protected static final int LV_DEBUG = 1;
    protected static final int LV_DETAIL = 0;
    private static final int LOG_MODE = 3;
    private static final int COUNT_URL = 33;
    private static final int COUNT_ENV = 1;
    private static final int COLUMN_LEN_URL = 11;
    private static final int COLUMN_LEN_ENV = 6;
    private static final String FUN_CR_URLI = "CR getChangeReportURLInfo";
    private static final String FUN_CR_ENV = "CR getChangeReportEnv";
    protected static final int RETRY_TO_FILE = 3;
    protected static final int SLEEP_TO_FILE = 2000;
    private static final String PATH_FILE = "..\\..\\config\\";
    private static final String PATH_DIFF = "..\\..\\diff\\";
    private static final String FILENAME_URL = "ChangeReportURLlist.csv";
    private static final String FILENAME_ENV = "ChangeReportEnv.csv";
    private static final int MIN_ID = 0;
    private static final int MAX_ID = 32;
    private static final int MIN_LEN_URL = 1;
    private static final int MAX_LEN_URL = 1024;
    private static final int MIN_LEN_USERID = 1;
    private static final int MAX_LEN_USERID = 25;
    private static final int MIN_LEN_PASS = 1;
    private static final int MAX_LEN_PASS = 25;
    private static final int MIN_LEN_VER = 0;
    private static final int MAX_LEN_VER = 256;
    private static final int POSITION_ID = 0;
    private static final int POSITION_URL = 1;
    private static final int POSITION_EFFECTIVE = 2;
    private static final int POSITION_UNLOCK = 3;
    private static final int POSITION_HRC_MRCF = 4;
    private static final int POSITION_HIHSM = 5;
    private static final int POSITION_RSIM = 6;
    private static final int POSITION_REBOOT = 7;
    private static final int POSITION_USER_ID = 8;
    private static final int POSITION_PASSWORD = 9;
    private static final int POSITION_VERSION = 10;
    private static final String ON = "1";
    private static final String OFF = "0";
    private static final String[] TYPES = new String[]{"Unlock", "Migration", "RSIM", "HRCorMRCF", "SvpReboot"};
    private static final int[] TYPES_POS = new int[]{3, 5, 6, 4, 7};
    private static final String SVP_DUAL_EXE = "WbCnfSt.exe";
    private static Vector m_VectorURL = new Vector(0);
    private static Vector m_VectorEnv = new Vector(0);
    private static CRgetURLInfo[] m_URL = null;
    private static CREnvInfo m_Env = null;

    public CRObj() {
        super(null);
        this.init();
    }

    public CRObj(RmiObjImpl rmiObjImpl) {
        super(rmiObjImpl);
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        try {
            Vector vector = m_VectorURL;
            synchronized (vector) {
                Vector vector2 = m_VectorEnv;
                synchronized (vector2) {
                    m_VectorURL.setSize(33);
                    this.initFileRetryer(m_VectorURL, FILENAME_URL);
                    this.resetURLInfo();
                    m_VectorEnv.setSize(1);
                    this.initFileRetryer(m_VectorEnv, FILENAME_ENV);
                    this.resetEnvInfo();
                }
            }
        }
        catch (JNIException jNIException) {
            String string = StringControl.getErrStack(jNIException);
            this.sysOut(3, string);
            throw new IllegalStateException(jNIException.getMessage());
        }
        catch (RuntimeException runtimeException) {
            String string = StringControl.getErrStack(runtimeException);
            this.sysOut(3, string);
            throw new IllegalStateException(runtimeException.getMessage());
        }
    }

    protected void initFileRetryer(Vector vector, String string) throws JNIException {
        boolean bl = false;
        int n = 4;
        for (int i = 0; i < n; ++i) {
            try {
                if (!this.initFile(vector, string)) {
                    throw this.newException("initFileRetryer() FileAccessError Dummy", 4001);
                }
                bl = true;
                break;
            }
            catch (JNIException jNIException) {
                if (i < 3) {
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (Exception exception) {}
                    continue;
                }
                throw this.newException("initFileRetryer() FileAccessError", 4001);
            }
        }
        if (!bl) {
            throw this.newException("initFileRetryer() FileAccessError", 4001);
        }
    }

    protected boolean initFile(Vector vector, String string) throws JNIException {
        boolean bl = false;
        this.sysOut(1, "initFile() vector: " + vector + ",filename " + string);
        try {
            RmiConObjInFile rmiConObjInFile = new RmiConObjInFile(PATH_FILE + string);
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ArrayList arrayList = rmiConObjInFile.getArrayList();
                this.sysOut(0, "initFile() in.getArrayList(): " + arrayList);
                if (vector.equals(m_VectorURL) && n == m_VectorURL.size()) {
                    if (arrayList == null) continue;
                    while (arrayList.size() < 11) {
                        arrayList.add("");
                    }
                    int n2 = Integer.parseInt((String)arrayList.get(0));
                    vector.set(n2, arrayList);
                    continue;
                }
                vector.set(i, arrayList);
            }
            rmiConObjInFile.clear();
            bl = true;
        }
        catch (GetRmiException getRmiException) {
            this.sysOut(1, "initFile() GetRmiException " + getRmiException.nErrData);
            if (getRmiException.nErrData == 4000) {
                this.createFile(0, PATH_FILE + string);
                bl = true;
            }
            bl = false;
        }
        this.sysOut(0, "initFile() vector.size(): " + vector.size());
        return bl;
    }

    protected boolean checkRange(int n, int n2, int n3) {
        return n2 <= n && n <= n3;
    }

    protected void checkNull(Object object) throws JNIException {
        if (object == null) {
            throw this.newException("checkNull() No Data", 5300);
        }
    }

    protected void checkID(int n) throws JNIException {
        if (!this.checkRange(n, 0, 32)) {
            throw this.newException("checkID() ID : " + n, 5301);
        }
    }

    protected void checkString(int n, String string) throws JNIException {
        boolean bl = false;
        this.checkNull(string);
        int n2 = string.length();
        switch (n) {
            case 1: {
                bl = this.checkRange(n2, 1, 1024);
                break;
            }
            case 8: {
                bl = this.checkRange(n2, 1, 25);
                break;
            }
            case 9: {
                bl = this.checkRange(n2, 1, 25);
                break;
            }
            case 10: {
                bl = this.checkRange(n2, 0, 256);
                break;
            }
            default: {
                throw this.newException("checkString() kind :" + n, 2005);
            }
        }
        if (!bl) {
            throw this.newException("checkString() kind :" + n, 3002);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CRgetURLInfo[] getChangeReportURLInfo() throws SANRmiException {
        String string = FUN_CR_URLI;
        CRgetURLInfo[] cRgetURLInfoArray = null;
        this.preProc(string);
        try {
            this.run(string);
            cRgetURLInfoArray = this.getURLInfo();
            this.runEnd(string);
        }
        catch (Exception exception) {
            this.exp(exception);
        }
        finally {
            this.postProc(string);
        }
        return cRgetURLInfoArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CREnvInfo getChangeReportEnv() throws SANRmiException {
        String string = FUN_CR_ENV;
        CREnvInfo cREnvInfo = null;
        this.preProc(string);
        try {
            this.run(string);
            cREnvInfo = this.getEnvInfo();
            this.runEnd(string);
        }
        catch (Exception exception) {
            this.exp(exception);
        }
        finally {
            this.postProc(string);
        }
        return cREnvInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CRgetURLInfo[] getURLInfo() {
        Vector vector = m_VectorURL;
        synchronized (vector) {
            return m_URL;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CREnvInfo getEnvInfo() {
        Vector vector = m_VectorEnv;
        synchronized (vector) {
            return m_Env;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetURLInfo() {
        Vector vector = m_VectorURL;
        synchronized (vector) {
            int n;
            int n2 = m_VectorURL.size();
            int n3 = 0;
            this.sysOut(0, "resetURLInfo() m_VectorURL.size(): " + n2);
            for (n = 0; n < n2; ++n) {
                Object e = m_VectorURL.get(n);
                if (e == null) continue;
                ++n3;
            }
            m_URL = new CRgetURLInfo[n3];
            n = 0;
            for (int i = 0; i < n2; ++i) {
                Object e = m_VectorURL.get(i);
                if (e == null) continue;
                ArrayList arrayList = (ArrayList)e;
                this.sysOut(0, "resetURLInfo() ArrayList: " + arrayList);
                CRObj.m_URL[n] = this.changeURL(arrayList);
                ++n;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetEnvInfo() {
        Vector vector = m_VectorEnv;
        synchronized (vector) {
        }
    }

    protected CRgetURLInfo changeURL(ArrayList arrayList) {
        this.sysOut(0, "changeURL() list: " + arrayList);
        CRgetURLInfo cRgetURLInfo = new CRgetURLInfo();
        cRgetURLInfo.entryID = Integer.parseInt((String)arrayList.get(0));
        cRgetURLInfo.noticeURL = (String)arrayList.get(1);
        cRgetURLInfo.userID = (String)arrayList.get(8);
        cRgetURLInfo.password = (String)arrayList.get(9);
        cRgetURLInfo.version = (String)arrayList.get(10);
        String string = (String)arrayList.get(2);
        cRgetURLInfo.effective = string.equals(ON);
        int n = TYPES.length;
        CRNoticeInfo[] cRNoticeInfoArray = new CRNoticeInfo[n];
        for (int i = 0; i < n; ++i) {
            cRNoticeInfoArray[i] = new CRNoticeInfo();
            cRNoticeInfoArray[i].type = TYPES[i];
            String string2 = (String)arrayList.get(TYPES_POS[i]);
            cRNoticeInfoArray[i].validity = string2.equals(ON);
        }
        cRgetURLInfo.noticeInfo = cRNoticeInfoArray;
        return cRgetURLInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reflectEffective(CREffectiveInfo cREffectiveInfo) throws JNIException {
        Vector vector = m_VectorURL;
        synchronized (vector) {
            m_VectorURL = this.setEffetive(m_VectorURL, cREffectiveInfo);
            this.resetURLInfo();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refrectURLInfoEntry(Robj_interface_CRURLInfo[] robj_interface_CRURLInfoArray) throws JNIException {
        Vector vector = m_VectorURL;
        synchronized (vector) {
            m_VectorURL = this.setURLEntry(m_VectorURL, robj_interface_CRURLInfoArray);
            this.resetURLInfo();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refrectURLInfoDelete(int[] nArray) throws JNIException {
        Vector vector = m_VectorURL;
        synchronized (vector) {
            m_VectorURL = this.setURLDelete(m_VectorURL, nArray);
            this.resetURLInfo();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refrectEnvInfo(CREnvInfo cREnvInfo) throws JNIException {
        Vector vector = m_VectorEnv;
        synchronized (vector) {
            m_VectorEnv = this.setEnv(m_VectorEnv, cREnvInfo);
            this.resetEnvInfo();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void makeURLInfo() throws JNIException {
        Vector vector = m_VectorURL;
        synchronized (vector) {
            this.makeFile(m_URL.length, m_VectorURL, FILENAME_URL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void makeEnvInfo() throws JNIException {
        Vector vector = m_VectorEnv;
        synchronized (vector) {
            this.makeFile(1, m_VectorEnv, FILENAME_ENV);
        }
    }

    private void makeFileRetryer(int n, Vector vector, String string) throws JNIException {
        boolean bl = false;
        int n2 = 4;
        for (int i = 0; i < n2; ++i) {
            try {
                if (!this.makeFile(n, vector, string)) {
                    throw this.newException("makeFileRetryer() FileAccessError Dummy", 4001);
                }
                bl = true;
                break;
            }
            catch (JNIException jNIException) {
                if (i < 3) {
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (Exception exception) {}
                    continue;
                }
                throw this.newException("makeFileRetryer() FileAccessError", 4001);
            }
        }
        if (!bl) {
            throw this.newException("makeFileRetryer() FileAccessError", 4001);
        }
    }

    private boolean makeFile(int n, Vector vector, String string) throws JNIException {
        this.sysOut(1, "makeFile() : " + n + " : " + string);
        this.sysOut(0, "makeFile() vector: " + vector);
        boolean bl = false;
        try {
            this.createFile(1, PATH_FILE + string);
            String string2 = StringControl.LN_SEP;
            RmiConObjOutFile rmiConObjOutFile = new RmiConObjOutFile(PATH_FILE + string);
            int n2 = vector.size();
            StringBuffer stringBuffer = new StringBuffer();
            int n3 = 1;
            for (int i = 0; i < n2; ++i) {
                Object e = vector.get(i);
                if (e == null) continue;
                ArrayList arrayList = (ArrayList)e;
                String string3 = arrayList.toString();
                string3 = string3.substring(1, string3.length() - 1);
                string3 = StringControl.replace(string3, " ", "");
                stringBuffer.append(string3);
                if (n3 >= n) continue;
                stringBuffer.append(string2);
                ++n3;
            }
            if (n > 0) {
                rmiConObjOutFile.putOneLine(stringBuffer.toString());
            }
            this.backupFile(string);
            bl = true;
        }
        catch (GetRmiException getRmiException) {
            this.sysOut(1, "makeFile() GetRmiException " + getRmiException.nErrData);
        }
        return bl;
    }

    protected Vector setEffetive(Vector vector, CREffectiveInfo cREffectiveInfo) throws JNIException {
        this.checkNull(cREffectiveInfo);
        this.checkID(cREffectiveInfo.entryID);
        int n = cREffectiveInfo.entryID;
        boolean bl = false;
        int n2 = vector.size();
        for (int i = 0; i < n2; ++i) {
            int n3;
            ArrayList arrayList = (ArrayList)vector.get(i);
            if (arrayList == null || n != (n3 = Integer.parseInt((String)arrayList.get(0)))) continue;
            bl = true;
            String string = cREffectiveInfo.effective ? ON : OFF;
            arrayList.set(2, string);
            vector.set(cREffectiveInfo.entryID, arrayList);
            break;
        }
        if (!bl) {
            throw this.newException("setEffetive() entryID : " + n, 5301);
        }
        return vector;
    }

    protected Vector setURLEntry(Vector vector, Robj_interface_CRURLInfo[] robj_interface_CRURLInfoArray) throws JNIException {
        this.sysOut(1, "setURLEntry() vector: " + vector);
        this.checkNull(robj_interface_CRURLInfoArray);
        boolean bl = false;
        int n = robj_interface_CRURLInfoArray.length;
        for (int i = 0; i < n; ++i) {
            CRURLInfo cRURLInfo = (CRURLInfo)robj_interface_CRURLInfoArray[i];
            this.checkNull(cRURLInfo);
            this.checkID(cRURLInfo.entryID);
            Object e = vector.get(cRURLInfo.entryID);
            ArrayList<String> arrayList = (ArrayList<String>)e;
            if (arrayList == null || arrayList.size() == 0) {
                bl = true;
                arrayList = new ArrayList<String>();
                this.setSizeArrayList(arrayList, 11);
                this.checkNull(cRURLInfo.noticeURL);
                this.checkNull(cRURLInfo.userID);
                this.checkNull(cRURLInfo.password);
                this.checkNull(cRURLInfo.version);
            }
            this.sysOut(0, "setURLEntry() list: " + arrayList);
            arrayList.set(0, String.valueOf(cRURLInfo.entryID));
            arrayList.set(2, OFF);
            if (cRURLInfo.noticeURL != null) {
                this.checkString(1, cRURLInfo.noticeURL);
                arrayList.set(1, cRURLInfo.noticeURL);
            }
            if (cRURLInfo.userID != null) {
                this.checkString(8, cRURLInfo.userID);
                arrayList.set(8, cRURLInfo.userID);
            }
            if (cRURLInfo.userID != null) {
                this.checkString(9, cRURLInfo.password);
                arrayList.set(9, cRURLInfo.password);
            }
            if (cRURLInfo.version != null) {
                this.checkString(10, cRURLInfo.version);
                arrayList.set(10, cRURLInfo.version);
            }
            Robj_interface_CRNoticeInfo[] robj_interface_CRNoticeInfoArray = cRURLInfo.noticeInfo;
            this.checkNull(robj_interface_CRNoticeInfoArray);
            int n2 = robj_interface_CRNoticeInfoArray.length;
            int n3 = TYPES.length;
            block1: for (int j = 0; j < n3; ++j) {
                if (bl) {
                    arrayList.set(TYPES_POS[j], ON);
                }
                for (int k = 0; k < n2; ++k) {
                    Robj_interface_CRNoticeInfo robj_interface_CRNoticeInfo = robj_interface_CRNoticeInfoArray[k];
                    this.checkNull(robj_interface_CRNoticeInfo);
                    if (!TYPES[j].equals(robj_interface_CRNoticeInfo.getType())) continue;
                    String string = robj_interface_CRNoticeInfo.isValidity() ? ON : OFF;
                    arrayList.set(TYPES_POS[j], string);
                    continue block1;
                }
            }
            vector.set(cRURLInfo.getEntryID(), arrayList);
        }
        return vector;
    }

    protected Vector setURLDelete(Vector vector, int[] nArray) throws JNIException {
        this.checkNull(nArray);
        boolean bl = false;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int n2 = nArray[i];
            this.checkID(n2);
            int n3 = vector.size();
            for (int j = 0; j < n3; ++j) {
                int n4;
                ArrayList arrayList = (ArrayList)vector.get(j);
                if (arrayList == null || n2 != (n4 = Integer.parseInt((String)arrayList.get(0)))) continue;
                bl = true;
                vector.set(n2, null);
                break;
            }
            if (bl) continue;
            throw this.newException("setURLDelete() entryID : " + n2, 5301);
        }
        return vector;
    }

    protected Vector setEnv(Vector vector, CREnvInfo cREnvInfo) throws JNIException {
        return vector;
    }

    private void backupFile(String string) throws JNIException {
        File file = new File(PATH_FILE + string);
        if (file.exists()) {
            FileInputStream fileInputStream = null;
            FileOutputStream fileOutputStream = null;
            try {
                fileInputStream = new FileInputStream(file);
                int n = fileInputStream.available();
                byte[] byArray = new byte[n];
                fileInputStream.read(byArray);
                File file2 = new File(PATH_DIFF);
                if (!file2.exists()) {
                    file2.mkdirs();
                }
                fileOutputStream = new FileOutputStream(PATH_DIFF + string);
                fileOutputStream.write(byArray);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw this.newException("backupFile() :" + string, 2005);
            }
            catch (IOException iOException) {
                throw this.newException("backupFile() :" + string, 4001);
            }
            finally {
                try {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                }
                catch (IOException iOException) {
                    this.sysOut(3, "backupFile() :" + iOException.getMessage());
                }
            }
        }
    }

    protected void execSvpDual() throws JNIException {
        try {
            Runtime runtime = Runtime.getRuntime();
            Process process = runtime.exec(SVP_DUAL_EXE);
        }
        catch (IOException iOException) {
            throw this.newException("execSvpDual() :process execute failed", 2005);
        }
    }

    private void setSizeArrayList(ArrayList arrayList, int n) {
        int n2;
        for (int i = n2 = arrayList.size(); i < n; ++i) {
            arrayList.add(null);
        }
    }

    protected void createFile(int n, String string) throws JNIException {
        boolean bl = false;
        int n2 = 4;
        for (int i = 0; i < n2; ++i) {
            try {
                File file = new File(string);
                if (n == 1) {
                    file.delete();
                }
                if (!file.createNewFile()) continue;
                bl = true;
                break;
            }
            catch (IOException iOException) {
                iOException.printStackTrace(System.out);
                if (i < 3) {
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (Exception exception) {}
                    continue;
                }
                throw this.newException("createFile() FileAccessError", 4001);
            }
        }
        if (!bl) {
            throw this.newException("createFile() FileAccessError", 4001);
        }
    }

    protected void sysOut(int n, Object object) {
        if (n >= 3) {
            System.out.println(object);
        }
    }

    protected JNIException newException(String string, int n) {
        return new JNIException(string, 1, n);
    }
}

