/*
 * Decompiled with CFR 0.152.
 */
package sanproject.serverux.sso.verification;

import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.Certificate;
import sanproject.serverux.sso.certificate.HpCmsCertificateException;
import sanproject.serverux.sso.certificate.HpCmsCertificateHandler;
import sanproject.serverux.sso.certificate.HpCmsKeyStoreNotFoundException;
import sanproject.serverux.sso.verification.HpCmsVerificationException;

public class HpCmsVerificationHandler {
    private static final char AMPERSAND = '&';
    private static final String ESCAPE_AMPERSAND = "%26";
    private static final String CERT_ALGORITHM = "SHA256withRSA";
    private static final String STRING_CODE = "US-ASCII";
    private static final String DELIMITER = ":";

    private HpCmsVerificationHandler() {
    }

    private static byte[] decode(String string) throws HpCmsVerificationException {
        int n = string.length();
        if (n % 2 > 0 || !string.matches("^[0-9a-fA-F]+$")) {
            throw new HpCmsVerificationException("cannot decode the token.");
        }
        byte[] byArray = new byte[n / 2];
        int n2 = 0;
        for (int i = 0; i < n; i += 2) {
            String string2 = string.substring(i, i + 2);
            Integer n3 = Integer.valueOf(string2, 16);
            byArray[n2++] = n3.byteValue();
        }
        return byArray;
    }

    private static String unescapeUrl(String string) {
        if (null == string) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '&') {
                stringBuffer.append(ESCAPE_AMPERSAND);
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static boolean verifyToken(String string, String string2, String string3, String string4, String string5, String string6) throws HpCmsVerificationException, HpCmsKeyStoreNotFoundException {
        boolean bl = false;
        try {
            StringBuffer stringBuffer = new StringBuffer(string2);
            stringBuffer.append(DELIMITER).append(string3);
            stringBuffer.append(DELIMITER).append(string4);
            stringBuffer.append(DELIMITER).append(string5);
            String string7 = HpCmsVerificationHandler.unescapeUrl(string6);
            stringBuffer.append(DELIMITER).append(string7);
            byte[] byArray = stringBuffer.toString().getBytes(STRING_CODE);
            Certificate certificate = HpCmsCertificateHandler.getCertificate(string3);
            Signature signature = Signature.getInstance(CERT_ALGORITHM);
            signature.initVerify(certificate);
            signature.update(byArray);
            byte[] byArray2 = HpCmsVerificationHandler.decode(string);
            bl = signature.verify(byArray2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new HpCmsVerificationException("cannot decode the string.", unsupportedEncodingException);
        }
        catch (HpCmsCertificateException hpCmsCertificateException) {
            throw new HpCmsVerificationException("cannot get the certificate.", hpCmsCertificateException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new HpCmsVerificationException("cannot construct the Signature object.", noSuchAlgorithmException);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new HpCmsVerificationException("cannot set the Certificate to Signature.", invalidKeyException);
        }
        catch (SignatureException signatureException) {
            throw new HpCmsVerificationException("cannot verify the Signature.", signatureException);
        }
        return bl;
    }
}

