/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.base.authentication.module.external.kerberos;

import java.util.Properties;
import sanproject.sn2.base.authentication.module.external.common.SJbaseConfigurationFactory;
import sanproject.sn2.base.authentication.module.external.common.SJbaseExternalConst;
import sanproject.sn2.base.authentication.module.external.kerberos.SJbaseKerberosConfiguration;
import sanproject.sn2.com.utility.Logger.inf.SJcLoggerInterface;
import sanproject.sn2.com.utility.SJcLogUty;

public class SJbaseKerberosConfigurationFactory
extends SJbaseConfigurationFactory
implements SJbaseExternalConst {
    private static SJcLoggerInterface logger = SJcLogUty.getLogger();
    private static final String module = "SJbaseKerberosConfigurationFactory";
    public static final String KERBEROS_BASE = "auth.kerberos";
    public static final String DEFAULT_REALM = "default_realm";
    public static final String DNS_LOOKUP_KDC = "dns_lookup_kdc";
    public static final String CLOCKSKEW = "clockskew";
    public static final String TIMEOUT = "timeout";
    public static final String REALM_NAME = "realm_name";
    public static final String REALM = "realm";
    public static final String KDC = "kdc";
    public static final String GRP_MAPPING = "auth.group.mapping";

    public SJbaseKerberosConfigurationFactory() {
    }

    public SJbaseKerberosConfigurationFactory(Properties properties) {
        super(properties);
    }

    public SJbaseKerberosConfiguration[] getConfigurations() {
        SJbaseKerberosConfiguration[] configs;
        String method = "getConfigurations";
        logger.info(module, method, "", "start");
        if (this.properties == null) {
            logger.info(module, method, "check the configuration file object ", "object does not exist");
            configs = new SJbaseKerberosConfiguration[]{};
        } else {
            String realm_nameList = this.properties.getProperty("auth.kerberos.realm_name");
            String tmpDns_Lookup_Kdc = this.properties.getProperty("auth.kerberos.dns_lookup_kdc");
            if (!(realm_nameList != null && realm_nameList.length() != 0 || tmpDns_Lookup_Kdc != null && tmpDns_Lookup_Kdc.length() != 0 && tmpDns_Lookup_Kdc.equalsIgnoreCase("true"))) {
                logger.info(module, method, "check the configuration file object ", "object value is invalid");
                configs = new SJbaseKerberosConfiguration[]{};
            } else {
                if (realm_nameList == null) {
                    this.properties.setProperty("auth.kerberos.realm_name", "");
                    realm_nameList = "";
                }
                String[] realm_nameListArry = realm_nameList.split(",");
                configs = new SJbaseKerberosConfiguration[realm_nameListArry.length];
                for (int i = 0; i < realm_nameListArry.length; ++i) {
                    SJbaseKerberosConfiguration tmpConf = new SJbaseKerberosConfiguration();
                    String tmpKdc = this.properties.getProperty("auth.kerberos." + realm_nameListArry[i] + "." + KDC);
                    String tmpRealm = this.properties.getProperty("auth.kerberos." + realm_nameListArry[i] + "." + REALM);
                    if (tmpDns_Lookup_Kdc == null || tmpDns_Lookup_Kdc.length() == 0) {
                        logger.info(module, method, "check the configuration file object ", "object value is invalid");
                        tmpConf.setDns_Lookup_Kdc("false");
                    } else if (tmpDns_Lookup_Kdc.equalsIgnoreCase("false") && (tmpKdc == null || tmpKdc.length() == 0 || tmpRealm == null || tmpRealm.length() == 0)) {
                        logger.info(module, method, "check the configuration file object ", "object value is invalid");
                        tmpConf.setDns_Lookup_Kdc("false");
                        tmpConf.setServerErrCode(10);
                    } else if (tmpDns_Lookup_Kdc.equalsIgnoreCase("true")) {
                        if (tmpKdc == null || tmpKdc.length() == 0 || tmpRealm == null || tmpRealm.length() == 0) {
                            tmpConf.setDns_Lookup_Kdc("true");
                        } else {
                            tmpConf.setDns_Lookup_Kdc("false");
                        }
                    } else {
                        logger.info(module, method, "check the configuration file object ", "object value is invalid");
                        tmpConf.setDns_Lookup_Kdc("false");
                    }
                    this.setDefaul_Realm(tmpConf);
                    this.setClockskew(tmpConf);
                    this.setTimeout(tmpConf);
                    this.setRealm_Name(tmpConf, realm_nameListArry[i]);
                    this.setRealm(tmpConf, realm_nameListArry[i]);
                    this.setKdc(tmpConf, realm_nameListArry[i]);
                    this.setGrpMapping(tmpConf);
                    logger.info(module, method, "finish constructing the configuration object", realm_nameListArry[i] + ":[" + i + "]");
                    configs[i] = tmpConf;
                }
            }
        }
        logger.info(module, method, "", "end");
        return configs;
    }

    public void setDefaul_Realm(SJbaseKerberosConfiguration conf) {
        String method = "setDefaul_Realm";
        logger.info(module, method, "", "start");
        String tmpDefaul_Realm = this.properties.getProperty("auth.kerberos.default_realm");
        if (tmpDefaul_Realm == null || tmpDefaul_Realm.length() == 0) {
            logger.info(module, method, "the value is invalid", DEFAULT_REALM);
            conf.setServerErrCode(10);
        } else {
            conf.setDefaul_Realm(tmpDefaul_Realm);
        }
        logger.info(module, method, "", "end");
    }

    public void setClockskew(SJbaseKerberosConfiguration conf) {
        int tmpClockskew;
        String method = "setClockskew";
        logger.info(module, method, "", "start");
        try {
            tmpClockskew = Integer.parseInt(this.properties.getProperty("auth.kerberos.clockskew"));
            if (tmpClockskew < 0 || tmpClockskew > 300) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException e) {
            logger.info(module, method, "the value is invalid", CLOCKSKEW);
            tmpClockskew = 300;
        }
        conf.setClockskew(tmpClockskew);
        logger.info(module, method, "", "end");
    }

    public void setTimeout(SJbaseKerberosConfiguration conf) {
        int tmpTimeout;
        String method = "setTimeout";
        logger.info(module, method, "", "start");
        try {
            tmpTimeout = Integer.parseInt(this.properties.getProperty("auth.kerberos.timeout"));
            if (tmpTimeout < 0 || tmpTimeout > 120) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException e) {
            logger.info(module, method, "the value is invalid", TIMEOUT);
            tmpTimeout = 10;
        }
        conf.setTimeout(tmpTimeout);
        logger.info(module, method, "", "end");
    }

    public void setRealm_Name(SJbaseKerberosConfiguration conf, String Realm_Name) {
        String method = "setRealm_Name";
        logger.info(module, method, "", "start");
        if (conf.getDns_Lookup_Kdc().equalsIgnoreCase("true")) {
            conf.setRealm_Name(Realm_Name);
        } else if (Realm_Name == null || Realm_Name.length() == 0) {
            logger.info(module, method, "the value is invalid", "server name");
            conf.setServerErrCode(10);
        } else {
            conf.setRealm_Name(Realm_Name);
        }
        logger.info(module, method, "", "end");
    }

    public void setRealm(SJbaseKerberosConfiguration conf, String Realm_Name) {
        String method = "setRealm";
        logger.info(module, method, "", "start");
        String tmpRealm = this.properties.getProperty("auth.kerberos." + Realm_Name + "." + REALM);
        if ((tmpRealm == null || tmpRealm.length() == 0) && conf.getDns_Lookup_Kdc().equalsIgnoreCase("false")) {
            logger.info(module, method, "the value is invalid", REALM);
            conf.setServerErrCode(10);
        } else {
            conf.setRealm(tmpRealm);
        }
        logger.info(module, method, "", "end");
    }

    public void setKdc(SJbaseKerberosConfiguration conf, String Realm_Name) {
        String method = "setKdc";
        logger.info(module, method, "", "start");
        String tmpKdc = this.properties.getProperty("auth.kerberos." + Realm_Name + "." + KDC);
        if ((tmpKdc == null || tmpKdc.length() == 0) && conf.getDns_Lookup_Kdc().equalsIgnoreCase("false")) {
            logger.info(module, method, "the value is invalid", KDC);
            conf.setServerErrCode(10);
        } else {
            conf.setKdc(tmpKdc);
        }
        logger.info(module, method, "", "end");
    }

    public void setGrpMapping(SJbaseKerberosConfiguration conf) {
        String method = "setGrpMapping";
        logger.info(module, method, "", "start");
        String tmpGrpMapping = this.properties.getProperty(GRP_MAPPING);
        if (tmpGrpMapping == null || tmpGrpMapping.length() == 0) {
            logger.info(module, method, "the value is invalid", "GroupMapping");
            conf.setGrpMapping("false");
        } else {
            conf.setGrpMapping(tmpGrpMapping);
        }
        logger.info(module, method, "", "end");
    }
}

