/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.base.authentication.module.external.radius;

import java.nio.ByteBuffer;
import sanproject.sn2.base.authentication.module.external.radius.SJbaseRadiusAttribute;
import sanproject.sn2.base.authentication.module.external.radius.SJbaseRadiusFormatException;
import sanproject.sn2.base.authentication.module.external.radius.SJbaseRadiusPacket;
import sanproject.sn2.com.utility.Logger.inf.SJcLoggerInterface;
import sanproject.sn2.com.utility.SJcLogUty;

public class SJbaseRadiusPacketParser {
    private static SJcLoggerInterface logger = SJcLogUty.getLogger();
    private static final String module = "SJbaseRadiusPacketParser";

    public SJbaseRadiusPacket parse(byte[] response) throws SJbaseRadiusFormatException {
        String method = "parse";
        logger.info(module, method, "", "start");
        if (response.length < 20) {
            logger.info(module, method, "conpare to the minimum length", "invalid");
            throw new SJbaseRadiusFormatException();
        }
        byte code = response[0];
        byte id = response[1];
        byte[] length = new byte[2];
        System.arraycopy(response, 2, length, 0, 2);
        short packetLength = ByteBuffer.wrap(length).getShort();
        byte[] authenticator = new byte[16];
        System.arraycopy(response, 4, authenticator, 0, 16);
        SJbaseRadiusPacket resPacket = new SJbaseRadiusPacket();
        resPacket.setCode(code);
        resPacket.setId(id);
        resPacket.setAuthenticator(authenticator);
        if (packetLength < 20 || response.length < packetLength) {
            logger.info(module, method, "check the packet length", "invalid");
            throw new SJbaseRadiusFormatException();
        }
        int pos = 20;
        int rest = packetLength - pos;
        while (rest != 0) {
            int tmpAttrLength;
            int tmpValueLength;
            if (rest < 3 || rest < (response[pos + 1] & 0xFF)) {
                logger.info(module, method, "check the length of attributes", "invalid");
                throw new SJbaseRadiusFormatException();
            }
            int tmpAttrType = response[pos++] & 0xFF;
            if ((tmpValueLength = (tmpAttrLength = response[pos++] & 0xFF) - 2) < 1) {
                throw new SJbaseRadiusFormatException();
            }
            byte[] tmpAttrValue = new byte[tmpValueLength];
            System.arraycopy(response, pos, tmpAttrValue, 0, tmpValueLength);
            SJbaseRadiusAttribute tmpAttr = SJbaseRadiusAttribute.create(tmpAttrType, tmpAttrValue);
            resPacket.putAttribute(tmpAttr);
            rest = packetLength - (pos += tmpValueLength);
        }
        logger.info(module, method, "", "end");
        return resPacket;
    }
}

