/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.com.utility.Logger;

import java.util.Timer;
import java.util.TimerTask;
import sanproject.sn2.base.system.inf.SJbasePluginInterface;
import sanproject.sn2.com.utility.LogTask.SJcLogTask;
import sanproject.sn2.com.utility.Logger.SJcLogTaskManagerStatus;
import sanproject.sn2.com.utility.Logger.inf.SJcLoggerInterface;
import sanproject.sn2.com.utility.SJcEnvUty;
import sanproject.sn2.com.utility.SJcLogUty;

public class SJcLogTaskManager
implements SJbasePluginInterface {
    private final String LOG_FUNCTION = "LoggerUtility";
    private final String LOG_TITLE = this.getClass().getSimpleName();
    private final String LOG_START = "Start.";
    private final String LOG_END = "End.";
    private final int DEFAULT_INTERVAL = 12;
    private final int DEFAULT_START = 1;
    private SJcLoggerInterface logger = SJcLogUty.getLogger("SN_System.log");
    private Timer timer = null;
    private SJcLogTaskManagerStatus status = new SJcLogTaskManagerStatus();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finish() {
        String Log_SubTitle = "finish";
        this.logger.info("LoggerUtility", this.LOG_TITLE, "finish", "Start.");
        this.status.setPhase(3);
        this.status.setFatal(false);
        try {
            if (this.timer != null) {
                this.timer.cancel();
            }
            this.logger.info("LoggerUtility", this.LOG_TITLE, "finish", "Log task stop. ");
            this.status.setPhase(4);
            this.status.setFatal(false);
        }
        catch (Exception ex) {
            this.logger.error("LoggerUtility", this.LOG_TITLE, "finish", "Exception occured.", ex);
        }
        finally {
            this.logger.info("LoggerUtility", this.LOG_TITLE, "finish", "End.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initialize(int sta) {
        String Log_SubTitle = "initialize";
        this.logger.info("LoggerUtility", this.LOG_TITLE, "initialize", "Start. - status:" + sta);
        this.status.setPhase(1);
        this.status.setFatal(false);
        try {
            int waitTime;
            int interval = SJcEnvUty.getProperty2int("SN_Log_CleanInterval", 12);
            if (interval == 0) {
                this.status.setPhase(2);
                this.status.setFatal(false);
                return;
            }
            if (interval < 0) {
                interval = 12;
            }
            if ((waitTime = SJcEnvUty.getProperty2int("SN_Log_CleanStartTime", 1)) < 0) {
                waitTime = 1;
            }
            long intervalMS = this.toMilliSecond(interval);
            long waitTimeMS = this.toMilliSecond(waitTime);
            SJcLogTask logTask = new SJcLogTask();
            Timer timer = new Timer(true);
            timer.schedule((TimerTask)logTask, waitTimeMS, intervalMS);
            this.logger.info("LoggerUtility", this.LOG_TITLE, "initialize", "Log task start. interval : " + intervalMS + ", waitTime : " + waitTimeMS);
            this.timer = timer;
            this.status.setPhase(2);
            this.status.setFatal(false);
        }
        catch (Exception ex) {
            this.logger.error("LoggerUtility", this.LOG_TITLE, "initialize", "Exception occured.", ex);
        }
        finally {
            this.logger.info("LoggerUtility", this.LOG_TITLE, "initialize", "End.");
        }
    }

    private long toMilliSecond(long time) {
        long result = time * 1000L * 60L * 60L;
        return result;
    }

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public boolean isEnable() {
        return true;
    }
}

