/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.com.utility.Logger;

import ch.qos.logback.core.rolling.FixedWindowRollingPolicy;
import ch.qos.logback.core.rolling.RolloverFailure;
import ch.qos.logback.core.rolling.helper.RenameUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import sanproject.sn2.com.SJcConst;

public class SJcRollingPolicy
extends FixedWindowRollingPolicy {
    private static final String ENCODE = "UTF-8";
    private static final String NUMBER_SYMBOL = "%i";
    private static final String LOG_EXT = ".log";
    private static final String LOG_REGEX = ".*";
    private static final String LOG_EXT_REGEX = "\\.log";
    private static final String DATE_FORMAT = "yyyyMMdd-HHmmss";
    private static final String SEARCH_EXT = ".";
    private static final String HISTORY_EXT = ".history";
    RenameUtil util = new RenameUtil();
    String historyMngFilePath = null;

    public void start() {
        super.start();
        this.util.setContext(this.context);
        this.historyMngFilePath = this.getHistroyMngFile();
    }

    public void rollover() throws RolloverFailure {
        List<File> listHistory = this.readHistory();
        listHistory = listHistory.size() == 0 ? this.serachHistroyFile() : this.mergeHistroyFile(listHistory);
        ArrayList<File> listNewHistory = new ArrayList<File>(listHistory);
        int logCount = listHistory.size();
        if (this.getMaxIndex() <= logCount) {
            for (File file : listHistory) {
                if (this.getMaxIndex() > logCount) break;
                boolean result = file.delete();
                if (result) {
                    listNewHistory.remove(file);
                }
                --logCount;
            }
        }
        String toName = this.getLogReplaceName();
        this.util.rename(this.getActiveFileName(), toName);
        listNewHistory.add(new File(toName));
        this.updateHistory(listNewHistory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<File> readHistory() {
        ArrayList<File> historyList = new ArrayList<File>();
        File historyMngFile = new File(this.historyMngFilePath);
        if (!historyMngFile.exists()) {
            return historyList;
        }
        BufferedReader br = null;
        try {
            br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(historyMngFile), ENCODE));
            String line = null;
            while ((line = br.readLine()) != null) {
                File historyFile = new File(this.concatFile(line));
                if (!historyFile.exists()) continue;
                historyList.add(historyFile);
            }
        }
        catch (Exception ex) {
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (Exception ex) {}
            }
        }
        return historyList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateHistory(List<File> listNewHistory) {
        File historyMngFile = new File(this.historyMngFilePath);
        BufferedWriter bw = null;
        try {
            bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(historyMngFile), ENCODE));
            for (File historyFile : listNewHistory) {
                bw.write(historyFile.getName());
                bw.newLine();
            }
        }
        catch (Exception ex) {
        }
        finally {
            if (bw != null) {
                try {
                    bw.close();
                }
                catch (Exception ex) {}
            }
        }
    }

    private String getHistroyMngFile() {
        String currentLog = this.getActiveFileName();
        int separatePosition = this.getExtPosition(currentLog);
        String historyFile = currentLog.substring(0, separatePosition) + HISTORY_EXT;
        return historyFile;
    }

    private List<File> serachHistroyFile() {
        List<File> historyList = new ArrayList<File>();
        String pattern = this.fileNamePattern.getPattern();
        pattern = pattern.replace("\\(", "(");
        pattern = pattern.replace("\\)", ")");
        File patternFile = new File(pattern);
        String patternName = patternFile.getName();
        String historyPattern = patternName.replace(NUMBER_SYMBOL, LOG_REGEX);
        historyPattern = historyPattern.replace(LOG_EXT, LOG_EXT_REGEX);
        File dirFile = new File(this.getDirName());
        File[] list = dirFile.listFiles(this.getFileRegexFilter(historyPattern));
        if (list != null) {
            Arrays.sort(list, new FileComparator());
            historyList = Arrays.asList(list);
        }
        return historyList;
    }

    private List<File> mergeHistroyFile(List<File> historyList) {
        ArrayList<File> mergeList = new ArrayList<File>(historyList);
        List<File> logList = this.serachHistroyFile();
        for (File logFile : logList) {
            if (historyList.contains(logFile)) continue;
            mergeList.add(logFile);
        }
        return mergeList;
    }

    private String getLogReplaceName() {
        File replaceFile;
        String pattern = this.fileNamePattern.getPattern();
        pattern = pattern.replace("\\(", "(");
        pattern = pattern.replace("\\)", ")");
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT);
        String dateString = sdf.format(new Date());
        String logReplaceName = pattern.replace(NUMBER_SYMBOL, dateString);
        int count = 0;
        while ((replaceFile = new File(logReplaceName)).exists()) {
            logReplaceName = pattern.replace(NUMBER_SYMBOL, dateString + "-" + ++count);
        }
        return logReplaceName;
    }

    private FilenameFilter getFileRegexFilter(String regex) {
        final String regex_ = regex;
        return new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                boolean ret = name.matches(regex_);
                return ret;
            }
        };
    }

    private String getDirName() {
        File currentLogFile = new File(this.getActiveFileName());
        String dirName = currentLogFile.getParent();
        return dirName;
    }

    private String concatFile(String file) {
        String result = this.getDirName();
        if (!result.endsWith(SJcConst.sjc_PathSeparator)) {
            result = result + SJcConst.sjc_PathSeparator;
        }
        result = result + file;
        return result;
    }

    private int getExtPosition(String name) {
        int extPosition = name.lastIndexOf(SEARCH_EXT);
        if (extPosition == -1) {
            extPosition = name.length();
        }
        return extPosition;
    }

    private class FileComparator
    implements Comparator<File> {
        private FileComparator() {
        }

        @Override
        public int compare(File o1, File o2) {
            long diff = o2.lastModified() - o1.lastModified();
            if (diff > 0L) {
                return -1;
            }
            if (diff == 0L) {
                return 0;
            }
            return 1;
        }
    }
}

