/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com;

import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sanproject.sn2.base.session.inf.SJbaseUserSessionInterface;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.SJcMessage;
import sanproject.sn2.controller.com.SJctrAuthorize;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrDialogDataController;
import sanproject.sn2.controller.com.SJctrDirectLaunchData;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrNotifyState;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.com.model.node.SJctrNodeData;
import sanproject.sn2.controller.topwindow.base.SJctrAdminTreeModel;
import sanproject.sn2.controller.topwindow.base.SJctrPerformanceTreeModel;
import sanproject.sn2.controller.topwindow.base.SJctrSubsystemTreeModel;
import sanproject.sn2.controller.topwindow.base.SJctrTopMenuModel;
import sanproject.sn2.controller.topwindow.base.SJctrTopWindowDC;
import sanproject.sn2.controller.topwindow.information.SJctrInformationDC;
import sanproject.sn2.controller.wizard.SJctrSubWizard;

public class SJctrDirectLauncher {
    protected SJctrLogUty logUty = new SJctrLogUty();
    static final String[][] mDispIdExchgTbl = SJctrDirectLaunchData.mDispIdExchgTbl;
    private static Map<String, Map<String, Object>> mDispIdExchgMap = null;
    private static final String DC_CLASS = "CLASS";
    public static final String TARGET_LIST_VIEW = "LIST_VIEW";
    public static final String TARGET_DIALOG = "DIALOG";
    public static final String TARGET_SUB_WIZARD = "SUB_WIZARD";
    public static final String PARENT_DISP_ID = "PARENT_DISP_ID";
    public static final String LOGICAL_PATH = "LOGICAL_PATH";
    public static final String AUTHORIZE_CLASS = "AUTHORIZE_CLASS";
    private static String INITIALID = "V1";
    private static Class<?> INITIALLISTVIEW = SJctrInformationDC.class;
    private static SJctrNotifyState INITIALTREE = SJctrDataController.NOTIFY_STATE.MOVE_LISTVIEW;
    private int OTHER_FUNCTION_MENU_MODE = 6;
    public static final String FNC_ID_BASE = "201";
    public static final String MDL_ID_CTRL = "22";
    public static final String MSG_ID_SYSTEM_RESOURCE_ERR = "205072";
    public static final String MSG_ID_ROLE_ERR = "205073";
    public static final String MSG_ID_PP_ERR = "205074";
    private Class<?> initialListView = INITIALLISTVIEW;
    private SJctrNotifyState initialTree = INITIALTREE;
    private Class<?> LaunchDc = SJctrInformationDC.class;
    private String LaunchType = "LIST_VIEW";
    private Map<String, List<?>> dispParam = null;
    private String nodePath = null;
    private Class<?> authorizeClass = null;
    private boolean dialogLaunch = false;
    private boolean wizardLaunch = false;
    private boolean wizardLaunchCallbackBackEnalbed;
    private boolean wizardLaunchCallbackApplyEnalbed;
    private boolean otherFunctionMenuMode = false;
    private boolean directLaunch = false;
    static final String WINID_KEY = "INITIAL_WINDOW_ID";
    static final String SELOBJ_KEY = "INITIAL_SELECTED_OBJECT";
    static final String DISABLE_MENU_KEY = "SUB_MENU_DISABLE";

    SJctrDirectLauncher() {
        this.logUty.setTitle(this.getClass().getSimpleName());
        if (mDispIdExchgMap == null) {
            mDispIdExchgMap = new HashMap<String, Map<String, Object>>();
            for (String[] elm : mDispIdExchgTbl) {
                Class<?> authCls;
                String logicalPath;
                String parentDispId;
                String clsName;
                String DispId;
                Class<?> cls;
                block16: {
                    cls = null;
                    DispId = elm[0];
                    clsName = elm[1];
                    parentDispId = elm[2];
                    logicalPath = elm[3];
                    String authClsName = elm[4];
                    authCls = null;
                    try {
                        cls = Class.forName(clsName);
                        if (authClsName == "") break block16;
                        authCls = Class.forName(authClsName);
                    }
                    catch (ClassNotFoundException ex) {
                        this.logUty.putlog("const", ex.toString());
                        continue;
                    }
                }
                String targetType = null;
                Object targetParam = null;
                if (SJctrSubsystemTreeModel.isContainsDC(clsName)) {
                    targetType = TARGET_LIST_VIEW;
                    targetParam = SJctrDataController.NOTIFY_STATE.MOVE_LISTVIEW;
                } else if (SJctrPerformanceTreeModel.isContainsDC(clsName)) {
                    targetType = TARGET_LIST_VIEW;
                    targetParam = SJctrDataController.NOTIFY_STATE.MOVE_PERFORMANCE;
                } else if (SJctrAdminTreeModel.isContainsDC(clsName)) {
                    targetType = TARGET_LIST_VIEW;
                    targetParam = SJctrDataController.NOTIFY_STATE.MOVE_ADMIN;
                } else if (SJctrDialogDataController.class.isAssignableFrom(cls)) {
                    targetType = TARGET_DIALOG;
                    targetParam = Collections.EMPTY_MAP;
                } else if (SJctrSubWizard.class.isAssignableFrom(cls)) {
                    targetType = TARGET_SUB_WIZARD;
                    targetParam = Collections.EMPTY_MAP;
                }
                if (targetType == null) continue;
                HashMap<String, Object> paramMap = new HashMap<String, Object>();
                paramMap.put(DC_CLASS, cls);
                paramMap.put(targetType, targetParam);
                if (parentDispId != "") {
                    paramMap.put(PARENT_DISP_ID, parentDispId);
                }
                if (logicalPath != "") {
                    paramMap.put(LOGICAL_PATH, logicalPath);
                }
                if (authCls != null) {
                    paramMap.put(AUTHORIZE_CLASS, authCls);
                }
                mDispIdExchgMap.put(DispId, paramMap);
            }
        }
    }

    void initialize(SJbaseUserSessionInterface us) {
        HashMap<String, Object> authObj = null;
        try {
            Map<String, Object> exchgMap;
            Object objDisableMenu;
            Object objPrm;
            authObj = us.getAuthObject();
            if (authObj == null) {
                return;
            }
            String dispId = null;
            Map prmList = Collections.EMPTY_MAP;
            Object objId = authObj.get(WINID_KEY);
            if (objId == null) {
                this.logUty.putlog("initialize", "INITIAL_SELECTED_OBJECT ID=null");
            } else {
                this.logUty.putlog("initialize", "INITIAL_SELECTED_OBJECT ID=" + objId.toString());
            }
            if (objId instanceof String) {
                dispId = (String)objId;
            }
            if ((objPrm = authObj.get(SELOBJ_KEY)) == null) {
                this.logUty.putlog("initialize", "INITIAL_SELECTED_OBJECT PRM=null");
            } else {
                this.logUty.putlog("initialize", "INITIAL_SELECTED_OBJECT PRM=" + objPrm.toString());
            }
            if (objPrm instanceof Map) {
                prmList = (Map)objPrm;
            }
            if ((objDisableMenu = authObj.get(DISABLE_MENU_KEY)) == null) {
                this.logUty.putlog("initialize", "SUB_MENU_DISABLE = null");
            } else {
                this.logUty.putlog("initialize", "SUB_MENU_DISABLE = " + objDisableMenu.toString());
            }
            if (objDisableMenu instanceof BitSet) {
                BitSet disableMenu = (BitSet)objDisableMenu;
                this.otherFunctionMenuMode = disableMenu.get(this.OTHER_FUNCTION_MENU_MODE);
            }
            if ((exchgMap = mDispIdExchgMap.get(dispId)) == null) {
                return;
            }
            this.LaunchDc = (Class)exchgMap.get(DC_CLASS);
            if (exchgMap.containsKey(TARGET_LIST_VIEW)) {
                this.LaunchType = TARGET_LIST_VIEW;
                this.initialListView = this.LaunchDc;
                this.initialTree = (SJctrDataController.NOTIFY_STATE)exchgMap.get(TARGET_LIST_VIEW);
                this.dispParam = prmList;
            } else if (exchgMap.containsKey(TARGET_DIALOG)) {
                this.LaunchType = TARGET_DIALOG;
                this.dispParam = prmList;
                this.setParentDispInfo(exchgMap);
                this.nodePath = (String)exchgMap.get(LOGICAL_PATH);
                this.authorizeClass = (Class)exchgMap.get(AUTHORIZE_CLASS);
                this.dialogLaunch = true;
            } else if (exchgMap.containsKey(TARGET_SUB_WIZARD)) {
                this.LaunchType = TARGET_SUB_WIZARD;
                this.dispParam = prmList;
                this.setParentDispInfo(exchgMap);
                this.nodePath = (String)exchgMap.get(LOGICAL_PATH);
                this.authorizeClass = (Class)exchgMap.get(AUTHORIZE_CLASS);
                this.wizardLaunch = true;
                Object back = authObj.get("CALLBACK_URL_BACK");
                this.wizardLaunchCallbackBackEnalbed = back instanceof String && !((String)back).isEmpty();
                Object apply = authObj.get("CALLBACK_URL_APPLY");
                this.wizardLaunchCallbackApplyEnalbed = apply instanceof String && !((String)apply).isEmpty();
            }
        }
        catch (Exception e) {
            this.logUty.putlog("initialize", e.toString());
        }
    }

    private void setParentDispInfo(Map<String, Object> exchgMap) {
        if (exchgMap.containsKey(PARENT_DISP_ID)) {
            String parentId = (String)exchgMap.get(PARENT_DISP_ID);
            if (!parentId.equals(INITIALID)) {
                Map<String, Object> parentMap = mDispIdExchgMap.get(parentId);
                Class parentClass = (Class)parentMap.get(DC_CLASS);
                SJctrDataController.NOTIFY_STATE tree = (SJctrDataController.NOTIFY_STATE)parentMap.get(TARGET_LIST_VIEW);
                this.initialListView = parentClass;
                this.initialTree = tree;
            }
        } else {
            this.logUty.putlog("setParentDispInfo", "PARENT_DISP_ID is not found");
        }
    }

    public Class<?> getInitialListView() {
        Class<?> ret = this.initialListView;
        this.initialListView = INITIALLISTVIEW;
        return ret;
    }

    public SJctrNotifyState getInitialTree() {
        SJctrNotifyState ret = this.initialTree;
        this.initialTree = INITIALTREE;
        return ret;
    }

    public Class<?> getInitialDc(String type) {
        Class<?> ret = null;
        if (this.LaunchType.equals(type)) {
            ret = this.LaunchDc;
            this.LaunchType = TARGET_LIST_VIEW;
        }
        return ret;
    }

    public Class<?> getLaunchDc() {
        return this.LaunchDc;
    }

    public String getNodePath() {
        return this.nodePath;
    }

    public Class<?> getAuthorizeClass() {
        return this.authorizeClass;
    }

    public Map<String, List<?>> getDisplayParam() {
        return this.dispParam;
    }

    public boolean isDialogLaunch() {
        return this.dialogLaunch;
    }

    public boolean isWizardLaunch() {
        return this.wizardLaunch;
    }

    public boolean isWizardLaunchCallbackBackEnalbed() {
        return this.wizardLaunchCallbackBackEnalbed;
    }

    public boolean isWizardLaunchCallbackApplyEnalbed() {
        return this.wizardLaunchCallbackApplyEnalbed;
    }

    public boolean isOtherFuncMenuMode() {
        return this.otherFunctionMenuMode;
    }

    public boolean isDirectLaunch() {
        return this.directLaunch;
    }

    public void setDirectLaunch(boolean direct) {
        this.directLaunch = direct;
    }

    public SJctrRelatedDispDataObject makeDirectLaunchDispData(SJctrDataController parentDc) {
        SJctrRelatedDispDataObject ret = null;
        if (!this.directLaunch) {
            return ret;
        }
        Class<?> dialog = this.getInitialDc(TARGET_DIALOG);
        Class<?> subWizard = this.getInitialDc(TARGET_SUB_WIZARD);
        if (dialog == null && subWizard == null) {
            return ret;
        }
        SJcMessage errMsg = null;
        errMsg = this.chkAuthorize(parentDc);
        if (errMsg == null) {
            Map<String, List<?>> param = null;
            param = parentDc.getDisplayParam(this);
            if (dialog != null) {
                ret = parentDc.createDialog(dialog, param);
            } else if (subWizard != null) {
                ret = parentDc.createWizard(subWizard, param);
            }
        } else {
            SJcException ex = new SJcException(errMsg);
            throw ex;
        }
        return ret;
    }

    public SJcMessage chkAuthorize(SJctrDataController dc) {
        SJcMessage msg = null;
        SJctrAuthorize auth = null;
        String nodePath = this.getNodePath();
        if (nodePath == null) {
            try {
                auth = (SJctrAuthorize)this.getAuthorizeClass().newInstance();
                auth.setContainer(dc.getOwner().getAuthorizeContainer());
            }
            catch (Exception e) {
                this.logUty.putlog("chkAuthorize", "newInstance NG");
            }
        } else {
            SJctrTopWindowDC topDC = dc.getTopWindow();
            SJctrTopMenuModel topMenu = (SJctrTopMenuModel)topDC.getDataObjectModel("COM_TOP_MENU");
            Map<String, SJctrNodeData> menuMap = topMenu.getNodePathToNodeDataMap();
            SJctrNodeData menuNode = menuMap.get(nodePath);
            auth = menuNode.getAuthorize();
        }
        if (auth == null) {
            this.logUty.putlog("chkAuthorize", "authorizeClass is null");
            msg = new SJcMessage(FNC_ID_BASE, MDL_ID_CTRL, MSG_ID_SYSTEM_RESOURCE_ERR);
            return msg;
        }
        if (!auth.chkResource()) {
            msg = new SJcMessage(FNC_ID_BASE, MDL_ID_CTRL, MSG_ID_SYSTEM_RESOURCE_ERR);
            this.logUty.putlog("chkAuthorize", "chkResource NG");
        } else if (!auth.chkRole()) {
            msg = new SJcMessage(FNC_ID_BASE, MDL_ID_CTRL, MSG_ID_ROLE_ERR);
            this.logUty.putlog("chkAuthorize", "chkRole NG");
        } else if (!auth.chkPP()) {
            msg = new SJcMessage(FNC_ID_BASE, MDL_ID_CTRL, MSG_ID_PP_ERR);
            this.logUty.putlog("chkAuthorize", "chkPP NG");
        }
        return msg;
    }
}

