/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com;

import com.hitachi.sanproject.data.SanDataException;
import com.hitachi.sanproject.rmi.SanRequest;
import com.hitachi.sanproject.rmi.SanResponse;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import sanproject.serverux.dataimpl.EncryptionKeyGenerationInfo;
import sanproject.serverux.dataimpl.EncryptionKeyInfoKEK;
import sanproject.serverux.dataimpl.GetEncryptionKeyGenerationInfo_IN;
import sanproject.serverux.dataimpl.GetEncryptionKeyGenerationInfo_OUT;
import sanproject.serverux.dataimpl.GetEncryptionKeyInfoKEK_IN;
import sanproject.serverux.dataimpl.GetEncryptionKeyInfoKEK_OUT;
import sanproject.sn2.base.session.SJbaseLoginEntry;
import sanproject.sn2.base.session.SJbaseUserSession;
import sanproject.sn2.base.session.SJbaseUserSessionManager;
import sanproject.sn2.base.session.inf.SJbaseUserSessionInterface;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.SJcMessage;
import sanproject.sn2.com.utility.Logger.SJcAuditLogApplyMultiLineElemCon;
import sanproject.sn2.com.utility.Logger.inf.SJcAuditLoggerInterface;
import sanproject.sn2.com.utility.SJcLogUty;
import sanproject.sn2.com.utility.SJcProductUty;
import sanproject.sn2.com.utility.SJcSingletonManagerUty;
import sanproject.sn2.com.utility.account.SJcRoleResourceContainer;
import sanproject.sn2.com.utility.guidance.inf.SJcGuidanceHandleInterface;
import sanproject.sn2.com.utility.message.inf.SJcMessageHandleInterface;
import sanproject.sn2.controller.com.SJctrApplyController;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrGuidIdDefinition;
import sanproject.sn2.controller.com.SJctrKeyValueErrorInfo;
import sanproject.sn2.controller.com.SJctrLicenseContainer;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrStringUtility;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.topwindow.encryption.SJctrEncDetail;
import sanproject.sn2.controller.topwindow.information.hardwares.SJctrInformationHardwaresSummaryModel;
import sanproject.sn2.controller.wizard.base.SJctrWizardWindowDC;
import sanproject.sn2.controller.wizard.encryption.com.SJctrEncryptionAuditLog;
import sanproject.sn2.controller.wizard.encryption.com.SJctrEncryptionDKAInitAC;
import sanproject.sn2.controller.wizard.encryption.com.SJctrEncryptionRekeyCekAC;
import sanproject.sn2.controller.wizard.encryption.editencryption.SJctrEditEncryptionPGDetail;
import sanproject.sn2.controller.wizard.encryption.kmip.autobackupkeys.SJctrAutoBackupKeysToServerAC;
import sanproject.sn2.controller.wizard.encryption.kmip.backupkeys.ctrl.SJctrBackupKeysToServerAuditLog;
import sanproject.sn2.controller.wizard.encryption.kmip.enviromentalset.data.SJctrConfiguration;
import sanproject.sn2.controller.wizard.encryption.kmip.enviromentalset.data.SJctrEditEnviromentalSetConfirmData;
import sanproject.sn2.controller.wizard.encryption.rekeykek.SJctrRekeyKekConfirmData;
import sanproject.sn2.datasupplier.SJdsSupplierAgent;
import sanproject.sn2.datasupplier.SJdsSupplierMgr;
import sanproject.sn2.kms.common.SJkmsBackupInfo;
import sanproject.sn2.kms.common.SJkmsConfiguration;
import sanproject.sn2.kms.util.SJkmsConfigUty;
import sanproject.sn2.model.SJmoDataChange;
import sanproject.sn2.model.SJmoGetAgent;
import sanproject.sn2.model.SJmoModelMgr;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetEncryptionKeyInfoMgr;
import sanproject.sn2.model.connector.kind.SJmoGetLdevStatusInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPgEncryptionInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPgLdevInfo;
import sanproject.sn2.model.connector.kind.SJmoGetSubsystemInfo;
import sanproject.sn2.model.connector.kind.SJmoGetThroughRmiData;
import sanproject.sn2.model.data.SJmoThroughRmiData;
import sanproject.sn2.model.data.device.SJmoPdevDetail;
import sanproject.sn2.model.data.system.SJmoEncryptionKeyGenerationInfo;
import sanproject.sn2.model.data.system.SJmoEncryptionKeyInfo;
import sanproject.sn2.model.data.system.SJmoEncryptionKeyInfoCEK;
import sanproject.sn2.model.data.system.SJmoEncryptionKeyInfoDEK;
import sanproject.sn2.model.data.system.SJmoEncryptionKeyInfoKEK;
import sanproject.sn2.model.data.system.SJmoRJiDkaInfo;
import sanproject.sn2.model.data.system.SJmoSubsystemInfo;
import sanproject.sn2.model.data.system.manager.SJmoEncryptionKeyInfoMgr;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;
import sanproject.sn2.model.data.volume.SJmoLdevStatusInfo;
import sanproject.sn2.model.data.volume.SJmoPgEncryptionInfo;
import sanproject.sn2.model.data.volume.SJmoPgLdevInfo;
import sanproject.sn2.model.inf.SJmoDataMacro_IF;

public class SJctrEncryptionKeysUtility
extends SJctrStringUtility
implements SJctrGuidIdDefinition {
    public static final String KEY_SUMMARY = "COM_SUMMARY";
    public static final String KEY_TABLE = "COM_TABLE";
    public static final String KEY_SPIN = "COM_NUM_OF_KEYS";
    public static final String KEY_ACTION_MENU = "COM_ACTION_MENU";
    public static final String KEY_SUMMARY_ACTION_MENU = "COM_SUMMARY_MENU";
    public static final String KEY_PASSWORD = "COM_PASSWORD";
    public static final String KEY_REENTER_PASSWORD = "COM_REENTER_PASSWORD";
    public static final String KEY_FILE_NAME = "COM_FILE_NAME";
    public static final String KEY_LABEL = "COM_LABEL";
    public static final String KEY_BROWSE_BTN = "COM_BROWSE_BTN";
    public static final String KEY_INITFLG = "COM_INITFLG";
    public static final String KEY_COL_ENC_KEYID = "COM_COL_KEY_ID";
    public static final String KEY_COL_ENC_UPDATE = "COM_COL_LAST_UPDATE";
    public static final String KEY_COL_ENC_TYPE = "COM_COL_TYPE";
    public static final String KEY_COL_NUM_OF_KEYS = "COM_COL_NUM_OF_KEYS";
    public static final String KEY_COL_ENC_CREATE_NUM = "COM_COL_NUM_CREATE";
    public static final String KEY_COL_ENC_BACKUP_NUM = "COM_COL_NUM_BACKUP";
    public static final String KEY_COL_ENC_USED_STAT = "COM_COL_USED";
    public static final String KEY_COL_ENC_ITEM = "COM_COL_ITEM";
    public static final String KEY_COL_ENC_VALUE = "COM_COL_VALUE";
    public static final String KEY_DEK = "COM_DEK";
    public static final String KEY_CEK = "COM_CEK";
    public static final String KEY_FREE = "COM_FREE";
    public static final String GUID_TAB_ENCRYPTION_KEY = "ENCRYPTION_KEYS";
    public static final String GUID_MAX_ALLOWED = "MAX_ALLOWED";
    public static final String GUID_BRACKET_L = "BRACKET_LEFT";
    public static final String GUID_BRACKET_R = "BRACKET_RIGHT";
    public static final String GUID_KEY_ID = "KEY_ID";
    public static final String GUID_CREATED = "CREATED";
    public static final String GUID_TYPE = "TYPE";
    public static final String GUID_NUM_OF_BACKUP = "NUM_OF_BACKUP";
    public static final String GUID_USED = "USED";
    public static final String GUID_ITEM = "ITEM";
    public static final String GUID_VALUE = "VALUE";
    public static final String GUID_FILENAME = "FILE_NAME";
    public static final String GUID_FREE = "FREE_CTG";
    public static final String GUID_DEK = "ENC_DEK";
    public static final String GUID_CEK = "ENC_CEK";
    public static final String GUID_KEK = "ENC_KEK";
    public static final String GUID_ASSIGNED = "ASSIGNED_TO";
    public static final String GUID_GENERATED = "GENERATED_ON";
    public static final String GUID_KMIP = "KMIP_MAPPING";
    public static final String GUID_DKC = "DISK_CONTROLLER";
    public static final String GUID_ATTRIBUTE = "ATTRIBUTE";
    public static final String GUID_KEY_NUM = "NUM_OF_ENCRYPTION_KEY";
    public static final String GUID_CREATEKEY = "CREATEKEY";
    public static final String GUID_DELETEKEY = "DELKEY";
    public static final String GUID_BACKUPKEY = "BACKUPKEY";
    public static final String GUID_ENTER_PASSWORD = "ENTER_PASSWORD";
    public static final String GUID_RESTOREKEY = "RESTOREKEY";
    public static final String GUID_SELECT_FILE = "SELECT_FILE";
    public static final String GUID_TITLE_REKEYKEK = "RE_KEY_KEK";
    public static final String GUID_REKEYCEK = "RE_KEY_CEK";
    public static final String GUID_BUTTON_INITENC = "INITIALIZE_ENC_SETTING";
    public static final Class<? extends SJmoGetKind_IF> KEY_CLASS_ENCRYPTION_MGR = SJmoGetEncryptionKeyInfoMgr.class;
    public static final Class<? extends SJmoGetKind_IF> KEY_CLASS_SUBSYSTEM_INFO = SJmoGetSubsystemInfo.class;
    public static final Class<? extends SJmoGetKind_IF> KEY_CLASS_PGENCRYPTION_INFO = SJmoGetPgEncryptionInfo.class;
    public static final Class<? extends SJmoGetKind_IF> KEY_CLASS_PGLDEV_INFO = SJmoGetPgLdevInfo.class;
    public static final Class<? extends SJmoGetKind_IF> KEY_CLASS_LDEVSTATUS_INFO = SJmoGetLdevStatusInfo.class;
    public static final String KEY_CREATE_KEYS = "KEY_CREATE_KEYS";
    public static final String KEY_DELETE_KEYS = "KEY_DELETE_KEYS";
    public static final String KEY_DISPID = "KEY_DISPID";
    public static final String KEYID = "KEYID";
    public static final String KEY_BACKUP_FILE_NAME = "KEY_BACKUP_FILE_NAME";
    public static final String KEY_BACKUP_PASSWORD = "KEY_BACKUP_PASSWORD";
    public static final String KEY_RESTORE_FILENAME = "KEY_RESTORE_FILENAME";
    public static final String KEY_RESTORE_PQSSWORD = "KEY_RESTORE_PQSSWORD";
    public static final String KEY_RESOTRE_DATA = "KEY_RESTORE_DATA";
    public static final Class KEY_CLASS_REKEYKEKCONFIRMDATA = SJctrRekeyKekConfirmData.class;
    public static final String KEY_AUTOBACKUP_DESCRIPTION = "KEY_AUTOBACKUP_DESCRIPTION";
    public static final int ERR_CVS_FUNC = 30;
    public static final int ERR_ENCRYPTION_FUNC = 101;
    public static final int ERR_HIC_MODULE = 5;
    public static final int ERR_ENCRYPTION_MODULE = 22;
    public static final int ERR_ENCRYPTION_NORMAL = 0;
    public static final int ERR_REP_ENCRYPTION_KEYS = 106039;
    public static final int ERR_ENCRYPTION_UNKNOWN_WIZ = 107001;
    public static final int ERR_ENCRYPTION_UNKNOWN_WIZ2 = 107002;
    public static final int ERR_ENCRYPTION_KEYS_NO_CREATED = 105196;
    public static final int ERR_ENCRYPTION_UNMATCH_PASSWORD = 106081;
    public static final int ERR_ENCRYPTION_TASK_INPROCESSING = 106082;
    public static final int ERR_ENCRYPTION_TASK_TIMEOUT = 106083;
    public static final int ERR_ENCRYPTION_FILESIZE_LARGE = 106084;
    public static final int ERR_ENCRYPTION_NO_BACKUPDATA = 105471;
    public static final int ERR_ENCRYPTION_NOT_BLOCKED = 106088;
    public static final int ERR_ENCRYPTION_NUM_FREEKEY_UNDER = 105495;
    public static final int ERR_ENCRYPTION_NOT_FREEKEY = 105494;
    public static final int ERROR_NONINIT = 105493;
    public static final int ERROR_DKC = 105497;
    public static final int ERROR_NONKEKDYNAMIC = 105498;
    public static final int ERROR_NONCEK = 105496;
    public static final int ERROR_KEK_ACQUISITION_FAILED = 105499;
    public static final int ERROR_INITNG = 105501;
    public static final int ERR_CREATEKEY_NG = 105504;
    public static final String DATE_FORMAT = "yyyy/MM/dd HH:mm:ss";
    public static final String BACKUP_FILE_SN = "SN";
    public static final String BACKUP_FILE_EXT = ".ekf";
    public static final int ENCKEY_COMMAND_DELETE = 0;
    public static final int ENCKEY_COMMAND_CREATE = 1;
    public static final int ENCRYPTION_LEAD_TIME = 7;
    public static final int TASK_WATCH_INTERVAL = 1000;
    public static final int TASK_WATCH_TIMEOUT = 900;
    public static final int ENC_BACKUP_MAX_SIZE = 7801680;
    public static final int ENC_MIN_INPUT_LENGTH = 6;
    public static final int ENC_MAX_INPUT_LENGTH = 255;
    public static final int ENC_SET = 1;
    public static final String STR_HAIFUN = "-";
    public static final int RAID_2D2D = 8194;
    public static final int RAID_6D1P = 8196;
    public static final int RAID_3D1P = 8197;
    public static final int RAID_7D1P = 8198;
    public static final int RAID_6D2P = 8199;
    public static final int RAID_14D2P = 8200;
    public static final int RAID_2D1P = 8201;
    public static final int RAID_4D1P = 8202;
    public static final int RAID_5D1P = 8203;
    public static final int RAID_8D1P = 8204;
    public static final int RAID_4D2P = 8205;
    public static final int RAID_8D2P = 8206;
    public static final int RAID_10D2P = 8207;
    public static final int RAID_12D2P = 8208;
    public static final int KEY_NUM_3 = 3;
    public static final int KEY_NUM_4 = 4;
    public static final int KEY_NUM_5 = 5;
    public static final int KEY_NUM_6 = 6;
    public static final int KEY_NUM_7 = 7;
    public static final int KEY_NUM_8 = 8;
    public static final int KEY_NUM_9 = 9;
    public static final int KEY_NUM_10 = 10;
    public static final int KEY_NUM_12 = 12;
    public static final int KEY_NUM_14 = 14;
    public static final int KEY_NUM_16 = 16;
    public static final int LDEV_BLOCKED = 2;
    public static final int LDEV_NOTHING = 0;
    public static final String STR_DKBID_00_DKBLOCATION = "DKB-1C";
    public static final String STR_DKBID_01_DKBLOCATION = "DKB-2C";
    public static final String STR_DKBID_00_CTLLOCATION = "CTL1";
    public static final String STR_DKBID_01_CTLLOCATION = "CTL2";
    public static final String STR_ASTERISK = "******";
    public static final String STR_PERIOD = ".";
    public static final String STR_COMMA = ",";
    public static final String STR_COMMA_SPACE = ", ";
    public static final String STR_UNDERBAR = "_";
    public static final String STR_RB_TIME = ":00";
    public static final String STR_FORMAT_NUMBER = "%02d";
    public static final String PATH_ENCTMP = "enctmp";
    public static final String ENC_PRP_FILENAME = "encpropfile";
    public static final String NO_DEL_KEEPTIME = "-1";
    public static final int INT_GENERATE_DKC = 0;
    public static final int INT_GENERATE_KMS_NOLOCK = 1;
    public static final int INT_GENERATE_KMS_LOCK = 2;
    public static final int INT_ENCKEY_KIND_FREE = 0;
    public static final int INT_ENCKEY_KIND_DEK = 1;
    public static final int INT_ENCKEY_KIND_CEK = 2;
    public static final int INT_ENCKEY_KIND_KEK_D = 3;
    public static final int INT_ENCKEY_KIND_KEK_S = 4;
    public static final int INT_ENCKEY_KIND_KEK_N = 5;
    public static final int INT_ENCKEY_KIND_DEK_CEK = 6;
    public static final int INT_ENCKEY_GENE_KMIP = 0;
    public static final int INT_ENCKEY_GENE_DKC = 1;
    public static final int INT_ENCKEY_CREATE_NUM = SJmoDataMacro_IF.NUM_MAX_ENCKEY_INTERNAL - 0 + 1;
    public static final int INT_ENCKEY_ENABLE = 1;
    public static final int INT_ENCKEY_DISABLE = 0;
    public static final int INT_ENC_INVALID = -1;
    public static final int INT_ENC_NOINIT = 0;
    public static final int INT_ENC_DKC = 1;
    public static final int INT_ENC_DKC_KMIP = 2;
    public static final int INT_ENC_KMIP_MODEOFF = 3;
    public static final int INT_ENC_KMIP_MODEON_LOCKOOF = 4;
    public static final int INT_ENC_KMIP_MODEON_LOCKON = 5;
    public static final int INT_ENCKEY_CREATE_KMIP = 0;
    public static final int INT_ENCKEY_CREATE_DKC = 1;
    public static final int INT_ENCKEY_CREATE_NO = -1;
    public static final int VIEW_NOT_INITIALIZE = 0;
    public static final int VIEW_ACQUISITION_FAILED = 1;
    public static final int VIEW_INITIALIZE = 2;
    public static final int INT_TEXT_MIN = 1;
    public static final int INT_TEXT_MAX = SJmoDataMacro_IF.NUM_MAX_ENCKEY_INTERNAL - 0 + 1;
    public static final int INT_DELETE_KEY = 0;
    public static final int INT_CREATE_KEY = 1;
    public static final int INT_CREATEKEY_NUM = SJmoDataMacro_IF.NUM_MAX_ENCKEY_INTERNAL + 1;
    public static final int INT_CREATE_ENCKEY_TWEAKKEY = 600;
    private static final SimpleDateFormat AUTO_TASKNAME_FORMAT = new SimpleDateFormat("yyyy-MM-dd'_'hh:mm aaa", Locale.ENGLISH);
    public static final String STR_REGLARBACKUP_ACTIONTYPE = ".*Regular Backup.*";

    public SJctrEncryptionKeysUtility(SJmoDataChange dc, SJcGuidanceHandleInterface ghi, SJcMessageHandleInterface mhi) {
        super(dc, ghi, mhi);
    }

    public static SJctrGetDirectWrapper createModelDirect(Class<? extends SJmoGetKind_IF> kindClass) {
        SJctrGetDirectWrapper reqData = null;
        try {
            SJmoGetDirect direct = new SJmoGetDirect();
            SJmoGetKind_IF kind = kindClass.newInstance();
            direct.setGetKind(kind);
            SJmoGetRange_IF range = null;
            direct.setGetRange(range);
            List filterList = Collections.emptyList();
            direct.setGetTermList(filterList);
            reqData = new SJctrGetDirectWrapper(direct);
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return reqData;
    }

    public static void createErrorDialog(int errorCode) {
        SJctrError error = new SJctrError(101, 22, errorCode);
        SJcException ex = error.createException();
        throw ex;
    }

    public String toMaxAllowedDisplay(int num, int max) {
        StringBuilder buf = new StringBuilder();
        buf.append(num);
        buf.append(' ');
        buf.append(this.guidanceHandle.getGuidance(GUID_BRACKET_L));
        buf.append(this.guidanceHandle.getGuidance(GUID_MAX_ALLOWED));
        buf.append(' ');
        buf.append(max);
        buf.append(this.guidanceHandle.getGuidance(GUID_BRACKET_R));
        return buf.toString();
    }

    public String makeBackupFileName(SJmoSubsystemInfo info) {
        String retValue = "";
        if (info != null) {
            StringBuilder buf = new StringBuilder();
            buf.append(SJctrInformationHardwaresSummaryModel.getSystemName(info));
            buf.append(BACKUP_FILE_SN);
            buf.append(info.getDKCSNAddString());
            buf.append(BACKUP_FILE_EXT);
            retValue = buf.toString();
        }
        return retValue;
    }

    public String toEncryptionKeyCreateNumDisplay(SJmoEncryptionKeyInfo info) {
        String retValue = "?";
        if (info != null) {
            int num = info.getIKeyCreateCount();
            retValue = num == -1 ? "" : SJctrComUtility.toDecString(num);
        }
        return retValue;
    }

    public String toEncryptionKeyBackupNumDisplay(SJmoEncryptionKeyInfo info) {
        String retValue = "?";
        if (info != null) {
            int num = info.getIKeyBackupCount();
            retValue = num == -1 ? "" : SJctrComUtility.toDecString(num);
        }
        return retValue;
    }

    public boolean checkStringLength(String strValue, int iMin, int iMax) {
        boolean bRtn = true;
        if (strValue.length() < iMin || strValue.length() > iMax) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkMaxString", "strValue Length Error");
            bRtn = false;
        }
        return bRtn;
    }

    public static void checkPgBlocked(List<SJmoPgEncryptionInfo> pgEncryptionList, List<SJmoPgLdevInfo> pgLdevList, List<SJmoLdevStatusInfo> ldevStatusList) {
        for (SJmoPgEncryptionInfo pgEncryption : pgEncryptionList) {
            if (pgEncryption.getEncrypt() != 1) continue;
            int idx = Collections.binarySearch(pgLdevList, pgEncryption);
            if (idx >= 0) {
                SJmoPgLdevInfo pgLdev = pgLdevList.get(idx);
                ArrayList ldevList = pgLdev.getAlLdevIndex();
                SJctrEncryptionKeysUtility.checkLdevBlocked(ldevList, ldevStatusList);
                continue;
            }
            SJctrLogUty.warn("SJctrEncryptionKeysUtility", "checkConstructData", "pgIndex not found");
            SJctrEncryptionKeysUtility.createErrorDialog(107001);
        }
    }

    public static void checkLdevBlocked(List<SJmoLdevIndex> ldevs, List<SJmoLdevStatusInfo> ldevStatusList) {
        for (SJmoLdevIndex ldev : ldevs) {
            int ldevIndex = Collections.binarySearch(ldevStatusList, ldev);
            if (ldevIndex >= 0) {
                SJmoLdevStatusInfo ldevStatus = ldevStatusList.get(ldevIndex);
                if (ldevStatus.getLDEVStatus() == 2 || ldevStatus.getLDEVStatus() == 0) continue;
                SJctrLogUty.warn("SJctrEncryptionKeysUtility", "checkLdevBlocked", "LdevStatus is not Blocked. ");
                SJctrEncryptionKeysUtility.createErrorDialog(106088);
                continue;
            }
            SJctrLogUty.warn("SJctrEncryptionKeysUtility", "checkLdevBlocked", "ldevIndex not found");
            SJctrEncryptionKeysUtility.createErrorDialog(107001);
        }
    }

    public static boolean kmsServerIsEnabled() {
        String type = SJkmsConfigUty.getType();
        if (!type.equals("kmip")) {
            return false;
        }
        boolean settingEnabled = false;
        List<SJkmsConfiguration> configList = SJkmsConfigUty.getConfiguration(type);
        for (SJkmsConfiguration config : configList) {
            if (!config.getServerName().equals("PrimaryServer")) continue;
            if (!config.getEnabled()) break;
            settingEnabled = true;
            break;
        }
        return settingEnabled;
    }

    public static int getKeyGeneration() throws SJcException {
        int rtn = 0;
        SJmoGetAgent mdAgt = SJmoModelMgr.getModelMgr().getDataAgent();
        GetEncryptionKeyGenerationInfo_IN kind = new GetEncryptionKeyGenerationInfo_IN();
        SJmoGetThroughRmiData getKind = new SJmoGetThroughRmiData(kind);
        SJmoGetDirect getDirect = new SJmoGetDirect(getKind, null, null);
        ArrayList<SJmoGetDirect> alParam = new ArrayList<SJmoGetDirect>();
        alParam.add(getDirect);
        List listRet = mdAgt.getDataInf(alParam);
        if (listRet != null && listRet.size() > 0) {
            ArrayList alRet = (ArrayList)listRet.get(0);
            if (alRet != null && alRet.size() > 0) {
                Object objTnl = alRet.get(0);
                if (objTnl instanceof SJmoThroughRmiData) {
                    SJmoThroughRmiData mdlTnl = (SJmoThroughRmiData)objTnl;
                    if (mdlTnl.getObjRmi() instanceof GetEncryptionKeyGenerationInfo_OUT) {
                        GetEncryptionKeyGenerationInfo_OUT wkOut = (GetEncryptionKeyGenerationInfo_OUT)mdlTnl.getObjRmi();
                        EncryptionKeyGenerationInfo info = wkOut.getObjEncKeyGenerationData();
                        rtn = info.getIEncKeyGenerationInfo();
                    } else {
                        SJctrEncryptionKeysUtility.createErrorDialog(107001);
                    }
                } else {
                    SJctrEncryptionKeysUtility.createErrorDialog(107001);
                }
            } else {
                SJctrEncryptionKeysUtility.createErrorDialog(107001);
            }
        } else {
            SJctrEncryptionKeysUtility.createErrorDialog(107001);
        }
        return rtn;
    }

    public static String getErrMsg(String[] errMsg) {
        String errServ = STR_HAIFUN;
        if (errMsg != null) {
            errServ = errMsg.length > 1 ? errMsg[0] + " " + errMsg[1] : errMsg[0];
        }
        return errServ;
    }

    public static List<SJctrEncDetail> createEncDetailList(SJmoEncryptionKeyInfoMgr encKeyInf, ArrayList<SJmoRJiDkaInfo> infoDkaList, List<SJmoPdevDetail> infoHDDList) {
        ArrayList<SJctrEncDetail> encList = new ArrayList<SJctrEncDetail>();
        ArrayList dekList = encKeyInf.getAlEncryptionKeyInfoDEK();
        for (int i = 0; i < dekList.size(); ++i) {
            SJmoEncryptionKeyInfoDEK encDEK = (SJmoEncryptionKeyInfoDEK)dekList.get(i);
            if (encDEK.getIKeyKind() == 6) continue;
            SJctrEncDetail infoDEK = new SJctrEncDetail();
            infoDEK.setEncInf(encDEK, infoDkaList, infoHDDList);
            encList.add(infoDEK);
        }
        ArrayList cekList = encKeyInf.getAlEncryptionKeyInfoCEK();
        for (int i = 0; i < cekList.size(); ++i) {
            SJmoEncryptionKeyInfoCEK encCEK = (SJmoEncryptionKeyInfoCEK)cekList.get(i);
            SJctrEncDetail infoCEK = new SJctrEncDetail();
            infoCEK.setEncInf(encCEK, infoDkaList, infoHDDList);
            encList.add(infoCEK);
        }
        ArrayList kekList = encKeyInf.getAlEncryptionKeyInfoKEK();
        for (int i = 0; i < kekList.size(); ++i) {
            SJmoEncryptionKeyInfoKEK encKEK = (SJmoEncryptionKeyInfoKEK)kekList.get(i);
            SJctrEncDetail infoKEK = new SJctrEncDetail();
            infoKEK.setEncInf(encKEK, infoDkaList, infoHDDList);
            encList.add(infoKEK);
        }
        return encList;
    }

    public static int getFreeKeyNum(List tableList) {
        int iNumCnt = 0;
        for (int i = 0; i < tableList.size(); ++i) {
            SJctrEditEncryptionPGDetail pgDetail = (SJctrEditEncryptionPGDetail)tableList.get(i);
            int iEnc = pgDetail.getEnckey();
            if (iEnc != 1) continue;
            int iRaid = pgDetail.getRaidLevel();
            int iPg = pgDetail.getPGScatteredList().size() + 1;
            int iNum = SJctrEncryptionKeysUtility.getNumReqKeys(iRaid, iPg);
            iNumCnt += iNum;
        }
        return iNumCnt;
    }

    public static int getDisabledFreeKeyNum(List tableList) {
        int iNumCnt = 0;
        for (int i = 0; i < tableList.size(); ++i) {
            SJctrEditEncryptionPGDetail pgDetail = (SJctrEditEncryptionPGDetail)tableList.get(i);
            int iEnc = pgDetail.getEnckey();
            if (iEnc != 0) continue;
            int iRaid = pgDetail.getRaidLevel();
            int iPg = pgDetail.getPGScatteredList().size() + 1;
            int iNum = SJctrEncryptionKeysUtility.getNumReqKeys(iRaid, iPg);
            iNumCnt += iNum;
        }
        return iNumCnt;
    }

    public static int getNumReqKeys(int iRaidLevel, int iPG) {
        int rtn = 0;
        switch (iRaidLevel) {
            case 8194: {
                rtn = 4;
                break;
            }
            case 8197: {
                rtn = 4;
                break;
            }
            case 8196: {
                rtn = 7;
                break;
            }
            case 8198: {
                rtn = 8;
                break;
            }
            case 8199: {
                rtn = 8;
                break;
            }
            case 8200: {
                rtn = 16;
                break;
            }
            case 8201: {
                rtn = 3;
                break;
            }
            case 8202: {
                rtn = 5;
                break;
            }
            case 8203: {
                rtn = 6;
                break;
            }
            case 8204: {
                rtn = 9;
                break;
            }
            case 8205: {
                rtn = 6;
                break;
            }
            case 8206: {
                rtn = 10;
                break;
            }
            case 8207: {
                rtn = 12;
                break;
            }
            case 8208: {
                rtn = 14;
                break;
            }
        }
        return rtn *= iPG;
    }

    public static void chkEncInit(List keyInfoList) {
        SJmoEncryptionKeyInfoMgr keyInfo;
        SJmoEncryptionKeyGenerationInfo geneInf;
        if (keyInfoList.size() > 0 && (geneInf = (keyInfo = (SJmoEncryptionKeyInfoMgr)keyInfoList.get(0)).getGenerationInfo()).getIEncKeyGenerationInfo() == 0) {
            SJctrEncryptionKeysUtility.createErrorDialog(0);
        }
    }

    public static String[] getStrServ_Reply(SJcMessage msg) {
        String[] rtnStr = new String[2];
        if (msg == null) {
            return rtnStr;
        }
        int md_ID = Integer.parseInt(msg.getModuleID());
        rtnStr[0] = "(" + msg.getFunctionID() + SJctrComUtility.toPaddingZeroString(md_ID, 2) + STR_HAIFUN + msg.getMsgID() + ")";
        rtnStr[1] = SJctrEncryptionKeysUtility.getErrMsg(msg.getMeansure_argument());
        return rtnStr;
    }

    public static EncryptionKeyInfoKEK[] getEncKeyKEK() throws SJcException {
        EncryptionKeyInfoKEK[] infoList = new EncryptionKeyInfoKEK[1];
        SJmoGetAgent mdAgt = SJmoModelMgr.getModelMgr().getDataAgent();
        GetEncryptionKeyInfoKEK_IN kind = new GetEncryptionKeyInfoKEK_IN();
        SJmoGetThroughRmiData getKind = new SJmoGetThroughRmiData(kind);
        SJmoGetDirect getDirect = new SJmoGetDirect(getKind, null, null);
        ArrayList<SJmoGetDirect> alParam = new ArrayList<SJmoGetDirect>();
        alParam.add(getDirect);
        List listRet = mdAgt.getDataInf(alParam);
        if (listRet != null && listRet.size() > 0) {
            ArrayList alRet = (ArrayList)listRet.get(0);
            if (alRet != null && alRet.size() > 0) {
                Object objTnl = alRet.get(0);
                if (objTnl instanceof SJmoThroughRmiData) {
                    SJmoThroughRmiData mdlTnl = (SJmoThroughRmiData)objTnl;
                    if (mdlTnl.getObjRmi() instanceof GetEncryptionKeyInfoKEK_OUT) {
                        GetEncryptionKeyInfoKEK_OUT wkOut = (GetEncryptionKeyInfoKEK_OUT)mdlTnl.getObjRmi();
                        infoList = wkOut.getDataObject();
                    } else {
                        SJctrEncryptionKeysUtility.createErrorDialog(107001);
                    }
                } else {
                    SJctrEncryptionKeysUtility.createErrorDialog(107001);
                }
            } else {
                SJctrEncryptionKeysUtility.createErrorDialog(107001);
            }
        } else {
            SJctrEncryptionKeysUtility.createErrorDialog(107001);
        }
        return infoList;
    }

    public static boolean isKekKey(List<SJmoEncryptionKeyInfoMgr> mgrList) {
        int keyGenerate;
        SJmoEncryptionKeyInfoMgr mgr;
        SJmoEncryptionKeyGenerationInfo geneInfo;
        boolean rtn = true;
        if (mgrList == null || mgrList.size() <= 0) {
            SJctrEncryptionKeysUtility.createErrorDialog(107001);
        }
        if ((geneInfo = (mgr = mgrList.get(0)).getGenerationInfo()) != null && ((keyGenerate = geneInfo.getIEncKeyGenerationInfo()) == 4 || keyGenerate == 3 || keyGenerate == 5)) {
            if (mgr.getAlEncryptionKeyInfoKEK().size() <= 0) {
                rtn = false;
            } else {
                ArrayList keyKEKList = mgr.getAlEncryptionKeyInfoKEK();
                SJmoEncryptionKeyInfoKEK keyKEKInfo = (SJmoEncryptionKeyInfoKEK)keyKEKList.get(0);
                if (keyKEKInfo.getIKeyKind() == 5) {
                    rtn = false;
                }
            }
        }
        return rtn;
    }

    public static void chkKekKey(List<SJmoEncryptionKeyInfoMgr> mgrList) {
        if (!SJctrEncryptionKeysUtility.isKekKey(mgrList)) {
            SJctrEncryptionKeysUtility.createErrorDialog(105499);
        }
    }

    public static SJctrError createError(SJcMessage msg) {
        SJctrError rtn = new SJctrError(Integer.parseInt(msg.getFunctionID()), Integer.parseInt(msg.getModuleID()), Integer.parseInt(msg.getMsgID()));
        rtn.setMsgArgument(msg.getMsg_argument());
        rtn.setMeansureArgument(msg.getMeansure_argument());
        return rtn;
    }

    public static void addResotreAC(SJctrWizardWindowDC wizard, SJctrRelatedDispDataObject related) {
        SJctrEncryptionRekeyCekAC RekeyCekAc = new SJctrEncryptionRekeyCekAC();
        wizard.addConfirmData(RekeyCekAc, related);
        SJctrEncryptionDKAInitAC DKAInitAc = new SJctrEncryptionDKAInitAC();
        wizard.addConfirmData(DKAInitAc, related);
    }

    public static String toRegularBackupTimeDisplay(List<Integer> iRBTimeList, String delimiter) {
        ArrayList<String> strRBTimeList = new ArrayList<String>();
        boolean flg = false;
        int time = -1;
        int num = -1;
        for (int i = 0; i < iRBTimeList.size(); ++i) {
            StringBuffer buf = new StringBuffer();
            buf.append(String.format(STR_FORMAT_NUMBER, iRBTimeList.get(i)));
            buf.append(STR_RB_TIME);
            for (int j = i + 1; j < iRBTimeList.size() && (time = iRBTimeList.get(num = j - 1) + 1) == iRBTimeList.get(j); ++j) {
                flg = true;
            }
            if (flg) {
                buf.append(STR_HAIFUN);
                if (time == iRBTimeList.get(iRBTimeList.size() - 1)) {
                    num = iRBTimeList.size() - 1;
                }
                buf.append(String.format(STR_FORMAT_NUMBER, iRBTimeList.get(num)));
                buf.append(STR_RB_TIME);
                i = num;
            }
            strRBTimeList.add(buf.toString());
            flg = false;
        }
        String rtn = SJctrEncryptionKeysUtility.toAppendStr(strRBTimeList, delimiter);
        return rtn;
    }

    public static String createRegularBackupSchedule(List<Integer> iRBTimeList) {
        ArrayList<String> strRBTimeList = new ArrayList<String>();
        for (int i = 0; i < iRBTimeList.size(); ++i) {
            strRBTimeList.add(String.format(STR_FORMAT_NUMBER, iRBTimeList.get(i)));
        }
        String rtn = SJctrEncryptionKeysUtility.toAppendStr(strRBTimeList, STR_COMMA);
        return rtn;
    }

    public static String toAppendStr(List<String> strList, String delimiter) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < strList.size(); ++i) {
            if (i > 0) {
                buf.append(delimiter);
            }
            buf.append(strList.get(i));
        }
        return buf.toString();
    }

    public static SJbaseUserSessionInterface createSessionForRegularBackup(String userID, String pass) {
        SJbaseUserSessionManager manager = (SJbaseUserSessionManager)SJcSingletonManagerUty.getInstance(SJbaseUserSessionManager.class);
        SJbaseLoginEntry loginEntry = new SJbaseLoginEntry();
        loginEntry.setUserid(userID);
        loginEntry.setPassword(pass);
        loginEntry.setLoginType("NOR");
        String lang = SJctrEncryptionKeysUtility.getLanguageType();
        loginEntry.setLang(lang);
        SJbaseUserSessionInterface session = manager.loginForRegularBackup(loginEntry);
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isUserEnabled(String userID, String pass) {
        boolean rtn = false;
        SJbaseUserSessionInterface session = null;
        try {
            session = SJctrEncryptionKeysUtility.createSessionForRegularBackup(userID, pass);
            rtn = true;
        }
        catch (Exception e) {
            SJctrLogUty.warn("SJctrEncryptionKeysUtility", "isUserEnabled", "user error");
        }
        finally {
            if (session != null) {
                session.logoutForRegularBackup();
            }
        }
        return rtn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isRegularBackupAuthEnabled(String userID, String pass) {
        boolean rtn = true;
        SJbaseUserSessionInterface session = null;
        try {
            session = SJctrEncryptionKeysUtility.createSessionForRegularBackup(userID, pass);
            SJctrUserController uc = new SJctrUserController();
            uc.initialize(session);
            rtn = SJctrEncryptionKeysUtility.isRegularBackupAuthEnabled(uc);
        }
        catch (Exception e) {
            SJctrLogUty.warn("SJctrEncryptionKeysUtility", "isRegularBackupAuthEnabled", "Authorize error");
            rtn = false;
        }
        finally {
            if (session != null) {
                session.logoutForRegularBackup();
            }
        }
        return rtn;
    }

    public static boolean isRegularBackupAuthEnabled(SJctrUserController uc) {
        boolean rtn = true;
        try {
            SJcRoleResourceContainer container = uc.getAuthorizeContainer().getRoleResourceContainer();
            rtn &= container.checkAuthority(22);
            rtn &= container.checkAuthority(23);
        }
        catch (Exception e) {
            SJctrLogUty.warn("SJctrEncryptionKeysUtility", "isRegularBackupAuthEnabled", "Authorize error");
            rtn = false;
        }
        return rtn;
    }

    public static String getLanguageType() {
        String lang = SJcProductUty.getLanguageList();
        if (lang.equals("AUTO")) {
            lang = "EN";
        }
        return lang;
    }

    public static void checkFreeKeys(int func, int module, int error, int iFree, int iNum_Select) {
        if (0 > iFree - iNum_Select) {
            SJctrError errorExp = new SJctrError(func, module, error);
            SJcException exp = errorExp.createException();
            throw exp;
        }
    }

    public static String createAutoBackupComment(String comment) {
        StringBuilder buf = new StringBuilder();
        buf.append(comment.replace(" ", ""));
        buf.append(AUTO_TASKNAME_FORMAT.format(new Date()));
        String defTaskName = buf.toString();
        return defTaskName;
    }

    public static SJctrAutoBackupKeysToServerAC createAutoBackupAC(SJctrUserController uc, SJkmsBackupInfo backupInfo) {
        SJctrRelatedDispDataObject wizardWindowRelateDisp = uc.getRelatedDispData(SJctrWizardWindowDC.class);
        SJctrWizardWindowDC dc = (SJctrWizardWindowDC)uc.getDataController(wizardWindowRelateDisp);
        ArrayList<SJkmsBackupInfo> commentList = new ArrayList<SJkmsBackupInfo>();
        commentList.add(backupInfo);
        dc.getProxy().putCache("COM_DESCRIPTION", commentList);
        backupInfo.setKmipModeFlg(true);
        if (uc.getAuthorizeContainer() != null) {
            backupInfo.setUserEnabled(true);
            backupInfo.setUserRole(SJctrEncryptionKeysUtility.isRegularBackupAuthEnabled(uc));
            SJctrLicenseContainer licenseContainer = uc.getAuthorizeContainer().getLisenceContainer();
            boolean lisence = licenseContainer.checkPP(SJctrLicenseContainer.PPID_ENCRYPTION);
            backupInfo.setBackupLisence(lisence);
        }
        String strNo = SJcProductUty.getSerialNumber();
        SJctrAutoBackupKeysToServerAC ac = new SJctrAutoBackupKeysToServerAC(strNo, backupInfo);
        SJctrBackupKeysToServerAuditLog log = new SJctrBackupKeysToServerAuditLog((SJbaseUserSession)uc.getUserSession());
        ac.setCreateKeysAdtLog(log);
        return ac;
    }

    public static SanResponse getEncDataFromRmiIf(String funcId) {
        SanResponse responseData = null;
        try {
            SJdsSupplierAgent agent = SJdsSupplierMgr.getSupplierMgr().getAgent();
            SanRequest direct = agent.newRequest(funcId);
            responseData = agent.getDataInf(direct, false);
            SJctrKeyValueErrorInfo keyValueInf = new SJctrKeyValueErrorInfo(responseData);
            if (keyValueInf.hasLowerNodeError() || keyValueInf.isOverAll()) {
                SJctrLogUty.error("SJctrEncryptionKeysUtility", "getEncDataFromRmiIf", "request failed");
                throw keyValueInf.createError().createException();
            }
        }
        catch (SanDataException e) {
            SJctrLogUty.warn("SJctrEncryptionKeysUtility", "getEncDataFromRmiIf", "Unexpected error");
            SJctrEncryptionKeysUtility.createErrorDialog(107001);
        }
        return responseData;
    }

    public static void SetBackupSuccessData(boolean backupFlg, String new_Uuid) throws SanDataException {
        try {
            SJdsSupplierAgent agent = SJdsSupplierMgr.getSupplierMgr().getAgent();
            SanRequest direct = agent.newRequest("MNTupdateBackupSuccessFlagOfEncryptionKey");
            direct.putBoolean("BackupSuccessFlag", backupFlg);
            direct.putString("BackupUuid", new_Uuid);
            SanResponse responseData = agent.getDataInf(direct, false);
            SJctrKeyValueErrorInfo keyValueInf = new SJctrKeyValueErrorInfo(responseData);
            if (keyValueInf.hasLowerNodeError() || keyValueInf.isOverAll()) {
                SJctrLogUty.error("SJctrEncryptionKeysUtility", "SetBackupSuccessData", "request failed");
                throw keyValueInf.createError().createException();
            }
        }
        catch (SJcException e) {
            SJctrLogUty.warn("SJctrEncryptionKeysUtility", "SetBackupSuccessData", "set SucceededFlg failed.");
            throw e;
        }
    }

    public static void executeSetSucceededFlg(boolean backupFlg, String new_Uuid, SJctrError result, SJctrApplyController ac) throws SanDataException {
        SJcException setDataException = null;
        try {
            SJctrEncryptionKeysUtility.SetBackupSuccessData(backupFlg, new_Uuid);
        }
        catch (SJcException e) {
            SJctrLogUty.warn("SJctrEncryptionKeysUtility", "executeSetSucceededFlg", "set SucceededFlg failed.");
            setDataException = e;
            ac.setError(SJctrError.parseError(e));
        }
        result = ac.getError();
        if (setDataException != null) {
            throw setDataException;
        }
    }

    public static void setEncryptionKeyDeletion(SJctrConfiguration data) throws Exception {
        try {
            SJctrLogUty.info("SJctrEncryptionKeysUtility", "setEncryptionKeyDeletion", "change PS OFF option start.");
            SJdsSupplierAgent agent = SJdsSupplierMgr.getSupplierMgr().getAgent();
            SanRequest direct = agent.newRequest("MNTupdateEncryptionKeyDeletionAtPSOFF");
            direct.putBoolean("EncryptionKeyDeletion", data.isPsOff());
            SanResponse responseData = agent.getDataInf(direct, false);
            SJctrKeyValueErrorInfo keyValueInf = new SJctrKeyValueErrorInfo(responseData);
            if (keyValueInf.hasLowerNodeError() || keyValueInf.isOverAll()) {
                SJctrLogUty.info("SJctrEncryptionKeysUtility", "setEncryptionKeyDeletion", "request failed");
                throw keyValueInf.createError().createException();
            }
            SJctrLogUty.info("SJctrEncryptionKeysUtility", "setEncryptionKeyDeletion", "change PS OFF option end.");
        }
        catch (Exception e) {
            SJctrLogUty.info("SJctrEncryptionKeysUtility", "setEncryptionKeyDeletion", "set Encryption Key Deletion faild.");
            throw e;
        }
    }

    public static void clearRegularBackupSettings(SJctrEditEnviromentalSetConfirmData conData, SJctrEncryptionAuditLog adtLog, String TaskName) {
        SJctrEncryptionKeysUtility.clearRegularBackupSettings(conData, adtLog, TaskName, false);
    }

    public static void clearRegularBackupSettings(SJctrEditEnviromentalSetConfirmData conData, SJctrEncryptionAuditLog adtLog, String TaskName, boolean bForceFlg) {
        SJctrError result = new SJctrError(0, 0, 0);
        if (SJctrEncryptionKeysUtility.isNeedClearRegBkSettings(conData) || bForceFlg) {
            SJctrConfiguration data;
            block3: {
                data = SJctrEncryptionKeysUtility.createClearRegBkSettings(conData);
                conData.setPrimConfig(data);
                try {
                    SJctrLogUty.info("SJctrEncryptionKeysUtility", "clearRegularBackupSettings", "Regular backup settings clear start.");
                    SJkmsConfigUty.setConfiguration("kmip", conData.getConfList());
                }
                catch (SJcException ex) {
                    SJctrLogUty.info("SJctrEncryptionKeysUtility", "clearRegularBackupSettings", "Regular backup settings clear failed.");
                    SJcMessage msg = ex.getMsg();
                    if (msg == null) break block3;
                    result.setFunc(Integer.parseInt(msg.getFunctionID()));
                    result.setModule(Integer.parseInt(msg.getModuleID()));
                    result.setError(Integer.parseInt(msg.getMsgID()));
                    result.setMeansureArgument(msg.getMeansure_argument());
                    result.setMsgArgument(msg.getMsg_argument());
                }
            }
            SJctrEncryptionKeysUtility.createClearRegBkSettingAdtLog(result, data, adtLog, TaskName);
        }
    }

    public static SJctrConfiguration createClearRegBkSettings(SJctrEditEnviromentalSetConfirmData conData) {
        SJctrConfiguration data = conData.getPrimConfig();
        data.setRegularbackupEnabled(false);
        data.setRegularbackupUserid("");
        data.setRegularbackupPasswd("");
        data.setRegularbackupSchedule("");
        data.setRegularBackupTime(new ArrayList<Integer>());
        return data;
    }

    public static boolean isNeedClearRegBkSettings(SJctrEditEnviromentalSetConfirmData conData) {
        boolean rtn = false;
        SJctrConfiguration data = conData.getPrimConfig();
        SJmoEncryptionKeyGenerationInfo oldPolicy = data.getOldPolicy();
        if (oldPolicy.getIEncKeyGenerationInfo() <= 1 && data.getRegularbackupEnabled()) {
            rtn = true;
        }
        return rtn;
    }

    public static void createClearRegBkSettingAdtLog(SJctrError result, SJctrConfiguration data, SJctrEncryptionAuditLog adtLog, String TaskName) {
        SJctrLogUty.info("SJctrEncryptionKeysUtility", "createClearRegBkSettingAdtLog", "Output Clear Regular Backup Settings Start.");
        SJcAuditLoggerInterface adtLogger = SJcLogUty.getAuditLogger();
        adtLog.setPrintData(data);
        adtLog.setPrintDataForSub(data);
        SJcAuditLogApplyMultiLineElemCon adtLogCont_IF = adtLog.createMultiLineElemCon();
        adtLogCont_IF.setTaskName(TaskName);
        String adtResult = "Success";
        SJcMessage adtMessage = null;
        if (result.getError() != 0) {
            adtResult = "Error";
            adtMessage = result.createException().getMsg();
            adtMessage.setModuleID(SJctrComUtility.toPaddingZeroString(result.getModule(), 2));
        }
        adtLogCont_IF.setOperationResult(adtResult);
        adtLogCont_IF.setOperationErrorCode(adtMessage);
        adtLogger.putLog(adtLogCont_IF);
        SJctrLogUty.info("SJctrEncryptionKeysUtility", "createClearRegBkSettingAdtLog", "AuditLog Output End.");
    }
}

