/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com;

import java.util.ArrayList;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrDialogDataController;
import sanproject.sn2.controller.com.SJctrFileUploadInterface;
import sanproject.sn2.controller.com.data.SJctrDataObject;
import sanproject.sn2.controller.com.model.SJctrButtonDataModel;
import sanproject.sn2.controller.com.model.SJctrSimpleDataModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.com.model.event.SJctrObjectSetListener;
import sanproject.sn2.controller.wizard.SJctrWizardDataController;

public class SJctrFileUploadDataController
extends SJctrDialogDataController {
    protected static final int DISP_ID = 0x3000004;
    public static final String KEY_FILE_LIST = "COM_FILE_LIST";
    public static final String KEY_CLOSE = "COM_CLOSE";
    private SJctrFileUploadInterface fileUpload = null;

    public SJctrFileUploadDataController() throws SJcException {
        super(0x3000004);
        this.initDataModel();
    }

    private void initDataModel() {
        SJctrButtonDataModel close = new SJctrButtonDataModel();
        close.setReceiveOnly();
        close.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                SJctrFileUploadDataController.this.logUty.putlog("selectChanged", "close");
                SJctrFileUploadDataController.this.close();
            }
        });
        this.addDataObjectModel(KEY_CLOSE, close);
    }

    @Override
    protected SJctrSimpleDataModel createRootDataModel() {
        SJctrSimpleDataModel root = super.createRootDataModel();
        root.addObjectSetListener(new SJctrObjectSetListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void doAction(Object setObject) {
                ArrayList fileList = SJctrFileUploadDataController.this.getFileList(setObject);
                if (fileList == null) {
                    return;
                }
                try {
                    SJctrFileUploadDataController.this.getLogUty().putlog("doAction", "filename:" + fileList);
                    SJctrFileUploadDataController.this.fileUpload.fileUpload(fileList);
                }
                finally {
                    SJctrFileUploadDataController.this.logUty.putlog(SJctrFileUploadDataController.KEY_FILE_LIST, "close");
                    SJctrFileUploadDataController.this.close();
                }
            }
        });
        return root;
    }

    private void close() {
        this.fireMessageEvent(SJctrWizardDataController.WIZ_MSG.CLOSE);
    }

    public void setFileUpload(SJctrFileUploadInterface obj) {
        this.fileUpload = obj;
    }

    private ArrayList<String> getFileList(Object setObject) {
        if (!(setObject instanceof SJctrDataObject)) {
            this.getLogUty().putlog("getFileList", "setObject=" + setObject);
            return null;
        }
        SJctrDataObject dataObj = (SJctrDataObject)setObject;
        if (!dataObj.getDataMap().containsKey(KEY_FILE_LIST)) {
            this.getLogUty().putlog("getFileList", "COM_FILE_LIST is unregistered");
            return null;
        }
        Object fileList = dataObj.getData(KEY_FILE_LIST);
        if (!(fileList instanceof ArrayList)) {
            this.getLogUty().putlog("getFileList", "fileList=" + fileList);
            return null;
        }
        return (ArrayList)fileList;
    }
}

