/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import sanproject.common.Robj_interface_RJiInputHAPairParam;
import sanproject.common.Robj_interface_RJiLDEVIndex;
import sanproject.serversx.data.RJiLDEVIndex;
import sanproject.serverux.dataimpl.RJiHAget1PairSummary;
import sanproject.serverux.dataimpl.RJiHAgetHistoryLog;
import sanproject.serverux.dataimpl.RJiHAgetPair;
import sanproject.serverux.dataimpl.RJiHAgetPair_IN;
import sanproject.serverux.dataimpl.RJiHAgetPair_OUT;
import sanproject.serverux.dataimpl.RJiHAsetLU;
import sanproject.serverux.dataimpl.RJiInputHAPairParam;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.utility.guidance.inf.SJcGuidanceHandleInterface;
import sanproject.sn2.com.utility.message.inf.SJcMessageHandleInterface;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrGuidIdDefinition;
import sanproject.sn2.controller.com.SJctrLdevUtility;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrRemoteReplicationUtility;
import sanproject.sn2.controller.com.SJctrReplicationUtility;
import sanproject.sn2.controller.com.SJctrResourceGroupUtility;
import sanproject.sn2.controller.com.SJctrRsgUtility;
import sanproject.sn2.controller.com.column.SJctrCapacityColumn;
import sanproject.sn2.controller.com.column.SJctrColumn;
import sanproject.sn2.controller.com.model.SJctrTableDataModel;
import sanproject.sn2.controller.topwindow.arraygroup.com.SJctrArrayGroupUtility;
import sanproject.sn2.controller.wizard.lunm.com.SJctrPortLunTableKey;
import sanproject.sn2.controller.wizard.replication.com.SJctrHaCtgInfo;
import sanproject.sn2.controller.wizard.replication.com.SJctrHaDataMacro;
import sanproject.sn2.controller.wizard.replication.com.SJctrRemoteReplicationDataMacro;
import sanproject.sn2.controller.wizard.replication.remote.createpairs.ha.SJctrCreateHaPairVolInfo;
import sanproject.sn2.controller.wizard.replication.remote.viewpairsyncrate.SJctrGetRJiHaPair;
import sanproject.sn2.controller.wizard.replication.viewhistories.remote.SJctrRemoteHistoriesHaInfo;
import sanproject.sn2.model.SJmoDataChange;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetClprInfo;
import sanproject.sn2.model.connector.kind.SJmoGetHAPairVolInfoMgr;
import sanproject.sn2.model.connector.kind.SJmoGetHUVMVirtualDkc;
import sanproject.sn2.model.connector.kind.SJmoGetHUVMVirtualLdev;
import sanproject.sn2.model.connector.kind.SJmoGetLdevDetail;
import sanproject.sn2.model.connector.kind.SJmoGetLdevNicknameInfo;
import sanproject.sn2.model.connector.kind.SJmoGetQuorumDiskInfo;
import sanproject.sn2.model.connector.kind.SJmoGetSsidDetail;
import sanproject.sn2.model.connector.kind.SJmoGetSubsystemInfo;
import sanproject.sn2.model.data.SJmoThroughRmiData;
import sanproject.sn2.model.data.huvm.SJmoHUVMVirtualDkc;
import sanproject.sn2.model.data.huvm.SJmoHUVMVirtualLdev;
import sanproject.sn2.model.data.huvm.SJmoHUVMvboxIndex;
import sanproject.sn2.model.data.lu.SJmoLuIndex;
import sanproject.sn2.model.data.lu.SJmoPortLunDetail;
import sanproject.sn2.model.data.lu.SJmoPortLunInfo;
import sanproject.sn2.model.data.replication.SJmoQuorumDiskIndex;
import sanproject.sn2.model.data.replication.SJmoReplicationPairVolInfo;
import sanproject.sn2.model.data.replication.remote.SJmoHAPairVolInfo;
import sanproject.sn2.model.data.replication.remote.SJmoQuorumDiskInfo;
import sanproject.sn2.model.data.replication.remote.SJmoRemoteReplicationRCUInfo;
import sanproject.sn2.model.data.replication.remote.manager.SJmoHAPairVolInfoMgr;
import sanproject.sn2.model.data.replication.remote.manager.SJmoRemoteReplicationMRCUInfoMgr;
import sanproject.sn2.model.data.rsg.SJmoRSGgetAllRsgs;
import sanproject.sn2.model.data.rsg.SJmoRSGgetRsg;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;
import sanproject.sn2.model.data.volume.SJmoSsidDetail;
import sanproject.sn2.sn2com.utility.SJsncProductModelUty;

public class SJctrHaUtility
extends SJctrRemoteReplicationUtility
implements SJctrGuidIdDefinition {
    private static final String LOG_TITLE = SJctrHaUtility.class.getSimpleName();

    public SJctrHaUtility(SJmoDataChange dc, SJcGuidanceHandleInterface ghi, SJcMessageHandleInterface mhi) {
        super(dc, ghi, mhi);
    }

    public String getLocalPairPositionString(SJmoHAPairVolInfo haPairInfo) {
        String ret = "?";
        if (null != haPairInfo) {
            if (SJctrHaUtility.isPvol(haPairInfo)) {
                ret = this.guidanceHandle.getGuidance("SECONDARY");
            } else if (SJctrHaUtility.isSvol(haPairInfo)) {
                ret = this.guidanceHandle.getGuidance("PRIMARY");
            } else {
                SJctrLogUty.error(LOG_TITLE, "getLocalPairPositionString", "SJmoHAPairVolInfo.iPairVolPos is invalid.");
            }
        }
        return ret;
    }

    public String getLocalIoModeString(SJmoHAPairVolInfo haPairInfo) {
        String ret = "?";
        if (null != haPairInfo) {
            int ioMode = haPairInfo.getIIOMode();
            if (0 == ioMode) {
                ret = this.guidanceHandle.getGuidance("MIRROR_READ_REMOTE");
            } else if (1 == ioMode) {
                ret = this.guidanceHandle.getGuidance("MIRROR_READ_LOCAL");
            } else if (2 == ioMode) {
                ret = this.guidanceHandle.getGuidance("IO_MODE_LOCAL");
            } else if (3 == ioMode) {
                ret = this.guidanceHandle.getGuidance("IO_MODE_BLOCK");
            } else if (4 == ioMode) {
                ret = this.guidanceHandle.getGuidance("IO_MODE_REMOTE");
            } else {
                SJctrLogUty.error(LOG_TITLE, "getLocalIoModeString", "SJmoHAPairVolInfo.iIOMode is invalid.");
            }
        }
        return ret;
    }

    public String getHaStatusString(SJmoHAPairVolInfo haPairInfo) {
        String ret = "?";
        if (null != haPairInfo) {
            int status = SJctrHaUtility.getHaPairStatus(haPairInfo);
            int initStatus = haPairInfo.getIInitialSetting();
            switch (status) {
                case 0: {
                    ret = this.guidanceHandle.getGuidance("ST_SMPL");
                    break;
                }
                case 1: {
                    if (initStatus == 1) {
                        ret = this.guidanceHandle.getGuidance("ST_INIT") + " / " + this.guidanceHandle.getGuidance("ST_COPY");
                        break;
                    }
                    ret = this.guidanceHandle.getGuidance("ST_COPY");
                    break;
                }
                case 2: {
                    ret = this.guidanceHandle.getGuidance("ST_PAIR");
                    break;
                }
                case 3: 
                case 4: {
                    ret = this.guidanceHandle.getGuidance("ST_PSUS");
                    break;
                }
                case 5: {
                    ret = this.guidanceHandle.getGuidance("ST_SSUS");
                    break;
                }
                case 6: 
                case 8: 
                case 9: 
                case 80: {
                    ret = this.guidanceHandle.getGuidance("ST_PSUE");
                    break;
                }
                case 256: {
                    ret = this.guidanceHandle.getGuidance("ST_SSWS");
                    break;
                }
                default: {
                    SJctrLogUty.error(LOG_TITLE, "getHaStatusString", "SJmoHAPairVolInfo.iPairStatus is invalid.");
                }
            }
        }
        return ret;
    }

    public String getHaStatusStringWithSplitType(SJmoHAPairVolInfo haPairInfo) {
        String splitTypeKey;
        String ret = this.getHaStatusString(haPairInfo);
        Map<Integer, String> splitTypeMap = SJctrRemoteReplicationDataMacro.GUID_SUSP_TYPE_MAP_HA;
        if (null != splitTypeMap && null != (splitTypeKey = splitTypeMap.get(SJctrHaUtility.getHaPairStatus(haPairInfo)))) {
            ret = ret + this.guidanceHandle.getGuidance(splitTypeKey);
        }
        return ret;
    }

    public String getFailureFactorString(SJmoHAPairVolInfo haPairInfo) {
        String ret = "?";
        if (null != haPairInfo) {
            int iHAErrInf = haPairInfo.getIObstacle();
            switch (iHAErrInf) {
                case 0: {
                    ret = "";
                    break;
                }
                case 1: {
                    ret = this.guidanceHandle.getGuidance("FAILURE_FACTOR_LOCAL_VOL");
                    break;
                }
                case 2: {
                    ret = this.guidanceHandle.getGuidance("FAILURE_FACTOR_REMOTE_PATH");
                    break;
                }
                case 3: 
                case 4: {
                    ret = this.guidanceHandle.getGuidance("FAILURE_FACTOR_QUORUM_DISK");
                    break;
                }
                case 5: 
                case 6: {
                    ret = this.guidanceHandle.getGuidance("FAILURE_FACTOR_INTERNAL_ERROR");
                    break;
                }
                case 7: {
                    ret = this.guidanceHandle.getGuidance("FAILURE_FACTOR_NOT_FAILURE");
                    break;
                }
                case 8: {
                    ret = this.guidanceHandle.getGuidance("FAILURE_FACTOR_REMOTE_VOL");
                    break;
                }
                case 9: {
                    ret = this.guidanceHandle.getGuidance("FAILURE_FACTOR_REMOTE_UNIDENTIFIED");
                    break;
                }
                default: {
                    SJctrLogUty.error(LOG_TITLE, "getFailureFactorString", "SJmoHAPairVolInfo.iHAErrInf is invalid.");
                }
            }
        }
        return ret;
    }

    public String getRemoteModelSerialString(SJmoHAPairVolInfo haPairInfo) {
        String ret = "? / ?";
        if (null != haPairInfo) {
            int iPairModel = haPairInfo.getIPairModel();
            String strPairSN = haPairInfo.getStrPairSN();
            ret = this.getModelSNoString(iPairModel, strPairSN);
        }
        return ret;
    }

    public String getPortNameString(SJmoHAPairVolInfo haPairInfo) {
        short sPort;
        int iPairModel;
        Map<Short, String> remotePortIDMap;
        String portName;
        String ret = "?";
        if (null != haPairInfo && null != (portName = (remotePortIDMap = SJctrHaUtility.getPortNameMap(iPairModel = haPairInfo.getIPairModel())).get(sPort = haPairInfo.getPairLU().getSPort()))) {
            ret = this.getRemotePortName(portName);
        }
        return ret;
    }

    public String getHgIdString(SJmoHAPairVolInfo haPairInfo) {
        String ret = "?";
        if (null != haPairInfo) {
            short sHostGroup = haPairInfo.getPairLU().getSHostGroup();
            ret = SJctrComUtility.toHexString(sHostGroup, 2, true);
        }
        return ret;
    }

    public String getLunIdString(SJmoHAPairVolInfo haPairInfo, boolean isLunDec) {
        String ret = "?";
        if (null != haPairInfo) {
            int iLUN = haPairInfo.getPairLU().getILUN();
            ret = isLunDec ? Integer.toString(iLUN) : SJctrComUtility.toHexString(iLUN, 4, true);
        }
        return ret;
    }

    public String getPathGrpIdString(SJmoHAPairVolInfo haPairInfo) {
        String ret = "?";
        if (null != haPairInfo) {
            int iPathGroup = haPairInfo.getIPathGroup();
            ret = SJctrComUtility.toHexString(iPathGroup, 2, true);
        }
        return ret;
    }

    public String getMirrorIdString(SJmoHAPairVolInfo haPairInfo) {
        String ret = "?";
        if (null != haPairInfo) {
            int iMirror = haPairInfo.getIMuNo();
            ret = Integer.toString(iMirror);
        }
        return ret;
    }

    public String getQuorumDiskIdString(SJmoHAPairVolInfo haPairInfo) {
        String ret = "?";
        if (null != haPairInfo) {
            if (haPairInfo.isQuorumDisabled()) {
                ret = "";
            } else {
                int iQuorumID = haPairInfo.getIQuorumID();
                ret = SJctrComUtility.toHexString(iQuorumID, 2, true);
            }
        }
        return ret;
    }

    public String getQuorumDiskIdLdevIDString(SJmoHAPairVolInfo haPairInfo, List<SJmoQuorumDiskInfo> quorumDiskList, SJctrLdevUtility ldevUtil) {
        String ret = "?";
        String strQuorumID = this.getQuorumDiskIdString(haPairInfo);
        String strLdevID = this.getQuorumLdevIDString(haPairInfo, quorumDiskList, ldevUtil);
        ret = strQuorumID + "(" + strLdevID + ")";
        return ret;
    }

    public String getQuorumLdevIDString(SJmoHAPairVolInfo haPairInfo, List<SJmoQuorumDiskInfo> quorumDiskList, SJctrLdevUtility ldevUtil) {
        String ret = "?:?:?";
        if (null != haPairInfo) {
            if (quorumDiskList == null || quorumDiskList.size() == 0) {
                return ret;
            }
            SJmoQuorumDiskInfo serchInfo = new SJmoQuorumDiskInfo();
            int iQuorumID = haPairInfo.getIQuorumID();
            serchInfo.setIQuorumDiskID(iQuorumID);
            Collections.sort(quorumDiskList);
            int index = Collections.binarySearch(quorumDiskList, serchInfo);
            if (index >= 0 && ldevUtil != null) {
                SJmoQuorumDiskInfo quorumInfo = quorumDiskList.get(index);
                if (SJctrHaUtility.isQuorumLess(quorumInfo.getIQuorumOption())) {
                    ret = "-";
                } else {
                    SJmoLdevIndex ldevIndex = quorumDiskList.get(index).getQuorumLdevIndex();
                    ret = ldevUtil.toLdevDisplay(ldevIndex);
                }
            }
        }
        return ret;
    }

    public String getQuorumLdevIDString(int quorumId, List<SJmoQuorumDiskInfo> quorumDiskList, SJctrLdevUtility ldevUtil) {
        String ret = "?:?:?";
        if (quorumDiskList == null || quorumDiskList.size() == 0) {
            return ret;
        }
        SJmoQuorumDiskInfo serchInfo = new SJmoQuorumDiskInfo();
        serchInfo.setIQuorumDiskID(quorumId);
        Collections.sort(quorumDiskList);
        int index = Collections.binarySearch(quorumDiskList, serchInfo);
        if (index >= 0 && ldevUtil != null) {
            SJmoQuorumDiskInfo quorumInfo = quorumDiskList.get(index);
            if (SJctrHaUtility.isQuorumLess(quorumInfo.getIQuorumOption())) {
                ret = "-";
            } else {
                SJmoLdevIndex ldevIndex = quorumDiskList.get(index).getQuorumLdevIndex();
                ret = ldevUtil.toLdevDisplay(ldevIndex);
            }
        }
        return ret;
    }

    public String getCopyTypeString(SJmoHAPairVolInfo haPairInfo) {
        String ret = "?";
        if (null != haPairInfo) {
            ret = this.guidanceHandle.getGuidance("HA");
        }
        return ret;
    }

    public String getCopyTypeHaString(SJmoReplicationPairVolInfo pairVolInfo) {
        String ret = "?";
        if (pairVolInfo != null) {
            ret = pairVolInfo.isVolPos(2048) ? this.guidanceHandle.getGuidance("SECONDARY") : (pairVolInfo.isVolPos(1024) ? this.guidanceHandle.getGuidance("PRIMARY") : "-");
        }
        return ret;
    }

    public String getDeleteModeString(SJmoHAPairVolInfo haPairInfo, int cmbDeleteMode) {
        String rtn = "?";
        if (haPairInfo != null) {
            rtn = !SJctrHaUtility.isSuspend(haPairInfo) ? this.getDeleteModeString(1) : this.getDeleteModeString(cmbDeleteMode);
        }
        return rtn;
    }

    public String getVolumeAccessString(int volumeAccess) {
        String rtn = "?";
        if (0 == volumeAccess) {
            rtn = this.guidanceHandle.getGuidance("ENABLE");
        } else if (1 == volumeAccess) {
            rtn = this.guidanceHandle.getGuidance("DISABLE");
        }
        return rtn;
    }

    public String getCopyPaceString(SJmoHAPairVolInfo haPairInfo) {
        String ret = "?";
        if (null != haPairInfo) {
            int track = haPairInfo.getICopyPace();
            ret = String.valueOf(track);
        } else {
            SJctrLogUty.error(this.getClass().getSimpleName(), "getCopyPaceString", "Argument is null.");
        }
        return ret;
    }

    public String getCopyPaceStringWithUnit(SJmoHAPairVolInfo haPairInfo, SJctrComUtility comUty) {
        String ret = "?";
        if (comUty != null && !(ret = this.getCopyPaceString(haPairInfo)).equals("?") && !ret.equals("-")) {
            ret = ret + " " + comUty.getGuidance("TRACKS");
        }
        return ret;
    }

    public String getVirtualModelSerialString(SJmoHUVMVirtualDkc virtualDkcInfo, SJctrRsgUtility rsgUtil) {
        String ret = "? / ?";
        if (null != virtualDkcInfo && rsgUtil != null) {
            ret = rsgUtil.toDispStringVssModelSerialNo(virtualDkcInfo);
        }
        return ret;
    }

    public String getVirtualLdevIdString(SJmoHUVMVirtualLdev virtualLdevInfo, SJctrRsgUtility rsgUtil, SJctrComUtility comUty) {
        String ret = "?";
        if (null != virtualLdevInfo && rsgUtil != null && comUty != null) {
            ret = rsgUtil.toDispStringVssLdevID(virtualLdevInfo, comUty.getLdevUtility());
        }
        return ret;
    }

    public String getVirtualDeviceNameString(SJmoHUVMVirtualLdev virtualLdevInfo, SJctrRsgUtility rsgUtil, SJctrLdevUtility ldevUtil) {
        String ret = "?";
        if (null != virtualLdevInfo && rsgUtil != null && ldevUtil != null) {
            ret = rsgUtil.toDispStringVssDeviceName(virtualLdevInfo, ldevUtil);
        }
        return ret;
    }

    public String getVirtualSSIDString(SJmoHUVMVirtualLdev virtualLdevInfo, SJctrRsgUtility rsgUtil) {
        String ret = "?";
        if (null != virtualLdevInfo && rsgUtil != null) {
            ret = rsgUtil.toDispStringVssSsid(virtualLdevInfo);
        }
        return ret;
    }

    public String getPairCopyTimeString(RJiHAget1PairSummary rmiPair) {
        String ret = "-";
        if (null == rmiPair) {
            return "?";
        }
        String pairCopyTime = rmiPair.getCopyCompleteTime();
        if (pairCopyTime.equals("Too long time.")) {
            ret = pairCopyTime;
        } else {
            int status = rmiPair.getPairStatus();
            if (rmiPair.getAttr() == 1 && status == 2) {
                ret = SJctrHaUtility.convertPairCopyTime(pairCopyTime);
            }
        }
        return ret;
    }

    public String getInitialCopyTypeStringFromHaPair(SJctrCreateHaPairVolInfo pairInfo) {
        String ret = "?";
        if (null != pairInfo) {
            switch (pairInfo.getInitCopyType()) {
                case 0: {
                    ret = this.guidanceHandle.getGuidance("NONE");
                    break;
                }
                case 1: {
                    ret = this.guidanceHandle.getGuidance("INIT_CP_TYPE_ENTIRE_VOL");
                    break;
                }
            }
        }
        return ret;
    }

    public String getHaCtgIdString(SJctrHaCtgInfo haCtgInfo) {
        String ret = "?";
        if (haCtgInfo != null) {
            int ctgId = SJctrHaUtility.getHaCtgIdNumber(haCtgInfo);
            switch (ctgId) {
                case -3: {
                    ret = "?";
                    break;
                }
                default: {
                    ret = SJctrComUtility.toHexString(ctgId, 3, true);
                }
            }
        }
        return ret;
    }

    public static int getHaCtgIdNumber(SJctrHaCtgInfo haCtgInfo) {
        int ret = -3;
        if (haCtgInfo != null) {
            ret = haCtgInfo.getCtgId();
        }
        return ret;
    }

    public String getHaCtgUsageString(SJctrHaCtgInfo haCtgInfo) {
        String ret = "?";
        if (haCtgInfo != null) {
            int usage = SJctrHaUtility.getHaCtgUsageNumber(haCtgInfo);
            switch (usage) {
                case -3: {
                    ret = "?";
                    break;
                }
                default: {
                    ret = this.getUsageString(usage);
                }
            }
        }
        return ret;
    }

    public static int getHaCtgUsageNumber(SJctrHaCtgInfo haCtgInfo) {
        int usage;
        int ret = -3;
        if (haCtgInfo != null && (usage = haCtgInfo.getUsage()) >= 0) {
            ret = usage;
        }
        return ret;
    }

    public String getUsageString(int usage) {
        String ret = "?";
        switch (usage) {
            case 0: {
                ret = this.guidanceHandle.getGuidance("FREE");
                break;
            }
            case 1: {
                ret = this.guidanceHandle.getGuidance("USED_CTG");
            }
        }
        return ret;
    }

    public String getHaCtgStatusString(SJctrHaCtgInfo haCtgInfo) {
        String ret = "?";
        if (haCtgInfo != null) {
            int status = SJctrHaUtility.getHaCtgStatusNumber(haCtgInfo);
            switch (status) {
                case -1: {
                    ret = "";
                    break;
                }
                case -3: {
                    ret = "?";
                    break;
                }
                case 0: {
                    List<SJmoHAPairVolInfo> gadPairVolList = haCtgInfo.getGadPairVolList();
                    int checkPairStatus = SJctrHaUtility.checkMixedPairStatus(gadPairVolList);
                    if (checkPairStatus == 0) {
                        ret = this.getHaStatusString(gadPairVolList.get(0));
                        break;
                    }
                    if (checkPairStatus != 1) break;
                    ret = this.guidanceHandle.getGuidance("MIXED");
                    break;
                }
                default: {
                    ret = this.getHaCtgStatusString(status);
                }
            }
        }
        return ret;
    }

    public static int getHaCtgStatusNumber(SJctrHaCtgInfo haCtgInfo) {
        int ret = -3;
        if (haCtgInfo != null) {
            if (haCtgInfo.getUsage() == 0) {
                ret = -1;
            } else {
                int status = haCtgInfo.getStatus();
                if (status >= 0) {
                    ret = status;
                }
            }
        }
        return ret;
    }

    public String getHaCtgQuorumDiskIdString(SJctrHaCtgInfo haCtgInfo) {
        String ret = "?";
        if (haCtgInfo != null) {
            int quorumId = SJctrHaUtility.getHaCtgQuorumDiskIdNumber(haCtgInfo);
            switch (quorumId) {
                case -1: {
                    ret = "";
                    break;
                }
                case -3: {
                    ret = "?";
                    break;
                }
                default: {
                    ret = SJctrComUtility.toHexString(quorumId, 2, true);
                }
            }
        }
        return ret;
    }

    public String getHaCtgQuorumLDEVString(SJctrHaCtgInfo haCtgInfo, List<SJmoQuorumDiskInfo> quorumDiskList, SJctrLdevUtility ldevUtil) {
        String ret = "?(?:?:?)";
        if (haCtgInfo != null) {
            int quorumId = SJctrHaUtility.getHaCtgQuorumDiskIdNumber(haCtgInfo);
            switch (quorumId) {
                case -1: {
                    ret = "";
                    break;
                }
                case -3: {
                    ret = "?";
                    break;
                }
                default: {
                    String strQuorumID = SJctrComUtility.toHexString(quorumId, 2, true);
                    String strLdevID = this.getQuorumLdevIDString(quorumId, quorumDiskList, ldevUtil);
                    ret = strQuorumID + "(" + strLdevID + ")";
                }
            }
        }
        return ret;
    }

    public static int getHaCtgQuorumDiskIdNumber(SJctrHaCtgInfo haCtgInfo) {
        int ret = -3;
        if (haCtgInfo != null) {
            ret = haCtgInfo.getUsage() == 0 ? -1 : SJctrHaUtility.getQuorumDiskIdNumber(haCtgInfo.isQuorumDiskDisable(), haCtgInfo.getQuorumDiskId());
        }
        return ret;
    }

    public String getHaCtgMirrorIdString(SJctrHaCtgInfo haCtgInfo) {
        String ret = "?";
        if (haCtgInfo != null) {
            int mirrorId = SJctrHaUtility.getHaCtgMirrorIdNumber(haCtgInfo);
            switch (mirrorId) {
                case -1: {
                    ret = "";
                    break;
                }
                case -3: {
                    ret = "?";
                    break;
                }
                default: {
                    ret = Integer.toString(mirrorId);
                }
            }
        }
        return ret;
    }

    public static int getHaCtgMirrorIdNumber(SJctrHaCtgInfo haCtgInfo) {
        int ret = -3;
        if (haCtgInfo != null) {
            ret = haCtgInfo.getUsage() == 0 ? -1 : haCtgInfo.getMirrorId();
        }
        return ret;
    }

    public String getHaCtgVirtualStorageMachineString(SJctrHaCtgInfo haCtgInfo, SJctrRsgUtility rsgUty) {
        String ret = "?";
        if (haCtgInfo != null) {
            if (haCtgInfo.getUsage() == 0) {
                ret = "";
            } else if (rsgUty != null) {
                SJmoHUVMVirtualDkc wkDkc = haCtgInfo.getVirtualDkc();
                ret = rsgUty.toDispStringVssModelSerialNo(wkDkc);
            }
        }
        return ret;
    }

    public String getHaCtgNumberOfPairsString(SJctrHaCtgInfo haCtgInfo) {
        String ret = "?";
        if (haCtgInfo != null) {
            int numOfPairs = SJctrHaUtility.getHaCtgNumberOfPairsNumber(haCtgInfo);
            switch (numOfPairs) {
                case -3: {
                    ret = "?";
                    break;
                }
                default: {
                    ret = Integer.toString(numOfPairs);
                }
            }
        }
        return ret;
    }

    public static int getHaCtgNumberOfPairsNumber(SJctrHaCtgInfo haCtgInfo) {
        int numOfPairs;
        int ret = -3;
        if (haCtgInfo != null && (numOfPairs = haCtgInfo.getNumOfPairs()) >= 0) {
            ret = numOfPairs;
        }
        return ret;
    }

    public String getHaCtgStatusString(int status) {
        String ret = "?";
        switch (status) {
            case 0: {
                ret = "";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                ret = this.guidanceHandle.getGuidance("ST_S_SUSPENDING");
                break;
            }
            case 64: 
            case 65: {
                ret = this.guidanceHandle.getGuidance("ST_S_DELETING");
                break;
            }
            case 128: 
            case 129: {
                ret = this.guidanceHandle.getGuidance("ST_S_RESYNCING");
                break;
            }
            case 192: 
            case 193: 
            case 255: {
                ret = this.guidanceHandle.getGuidance("ST_S_UNKNOWN");
            }
        }
        return ret;
    }

    public static int getQuorumDiskIdNumber(boolean isQuorumDisabled, int quorumId) {
        int ret = -3;
        ret = isQuorumDisabled ? -1 : quorumId;
        return ret;
    }

    public String getCtgIdString(SJmoHAPairVolInfo haPairInfo) {
        String ret = "?";
        if (haPairInfo != null) {
            int ctgId = SJctrHaUtility.getCtgIdNumber(haPairInfo);
            switch (ctgId) {
                case -1: {
                    ret = "";
                    break;
                }
                case -3: {
                    ret = "?";
                    break;
                }
                default: {
                    ret = SJctrComUtility.toHexString(ctgId, 3, true);
                }
            }
        }
        return ret;
    }

    public static int getCtgIdNumber(SJmoHAPairVolInfo haPairInfo) {
        int ret = -3;
        if (haPairInfo != null) {
            ret = haPairInfo.hasGroup() ? haPairInfo.getIGroup() : -1;
        }
        return ret;
    }

    public String getCopyPaceString(SJctrHaCtgInfo haPairInfo) {
        String ret = "?";
        if (null != haPairInfo) {
            int track = haPairInfo.getCopyPace();
            ret = String.valueOf(track);
        }
        return ret;
    }

    public String getLocalProvTypeStrFromHist(SJctrRemoteHistoriesHaInfo gadinfo) {
        String ret = "?";
        if (null != gadinfo) {
            ret = !SJctrHaUtility.isQuorumCode(gadinfo) && !SJctrHaUtility.isCTGCode(gadinfo) ? this.getProvTypeStringFromHist(gadinfo.getLocalProvisioningType()) : "-";
        }
        return ret;
    }

    public String getRemoteProvTypeStrFromHist(SJctrRemoteHistoriesHaInfo gadinfo) {
        String ret = "?";
        if (null != gadinfo) {
            ret = !SJctrHaUtility.isQuorumCode(gadinfo) && !SJctrHaUtility.isCTGCode(gadinfo) ? this.getProvTypeStringFromHist(gadinfo.getRemoteProvisioningType()) : "-";
        }
        return ret;
    }

    private String getProvTypeStringFromHist(int provType) {
        String ret = "?";
        int ptype = provType & 0xF000;
        if (ptype == 0) {
            ret = this.guidanceHandle.getGuidance("BASIC_VOL");
        } else if (ptype == 16384) {
            ret = this.guidanceHandle.getGuidance("AOU-VVOL");
        } else if (ptype == 32768) {
            ret = this.guidanceHandle.getGuidance("EXTERNAL_VOL");
        } else {
            SJctrLogUty.error("SJctrHaUtility", "getProvTypeStringFromHist", "provType:" + provType + " provType is invalid.");
        }
        return ret;
    }

    public static int getPairStatusIconId(SJmoHAPairVolInfo haPairInfo) {
        int icon = 16431;
        if (null != haPairInfo) {
            int iPairStatus = SJctrHaUtility.getHaPairStatus(haPairInfo);
            switch (iPairStatus) {
                case 1: {
                    icon = 16406;
                    break;
                }
                case 2: {
                    icon = 16403;
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    icon = 16404;
                    break;
                }
                case 6: 
                case 8: 
                case 9: 
                case 80: 
                case 256: {
                    icon = 16405;
                    break;
                }
                default: {
                    SJctrLogUty.error(LOG_TITLE, "getPairStatusIconId", "SJmoHAPairVolInfo.iPairStatus is invalid.");
                }
            }
        }
        return icon;
    }

    public static int getCtgStatusIconId(SJctrHaCtgInfo haCtgInfo) {
        int ret = 16431;
        if (haCtgInfo != null) {
            int status = SJctrHaUtility.getHaCtgStatusNumber(haCtgInfo);
            switch (status) {
                case -1: {
                    ret = 12295;
                    break;
                }
                case -3: {
                    ret = 16431;
                    break;
                }
                case 0: {
                    List<SJmoHAPairVolInfo> gadPairVolList = haCtgInfo.getGadPairVolList();
                    int checkPairStatus = SJctrHaUtility.checkMixedPairStatus(gadPairVolList);
                    if (checkPairStatus == 0) {
                        ret = SJctrHaUtility.getPairStatusIconId(gadPairVolList.get(0));
                        break;
                    }
                    if (checkPairStatus != 1) break;
                    ret = 16430;
                    break;
                }
                default: {
                    ret = SJctrHaUtility.getCtgStatusIconId(status);
                }
            }
        }
        return ret;
    }

    public static int getCtgStatusIconId(int status) {
        int icon = 16431;
        switch (status) {
            case 0: {
                icon = 12295;
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                icon = 16405;
                break;
            }
            case 64: 
            case 65: {
                icon = 16409;
                break;
            }
            case 128: 
            case 129: {
                icon = 16406;
                break;
            }
            case 192: 
            case 193: 
            case 255: {
                icon = 16431;
            }
        }
        return icon;
    }

    public String getCtgPairPositionString(SJctrHaCtgInfo gadCtgInfo) {
        String ret = "?";
        if (null != gadCtgInfo) {
            if (gadCtgInfo.getUsage() == 1) {
                List<SJmoHAPairVolInfo> gadPairVolList = gadCtgInfo.getGadPairVolList();
                HashSet<Integer> pairPositionSet = new HashSet<Integer>();
                for (SJmoHAPairVolInfo gadPairVol : gadPairVolList) {
                    if (SJctrHaUtility.isSvol(gadPairVol)) {
                        pairPositionSet.add(0);
                        continue;
                    }
                    if (SJctrHaUtility.isPvol(gadPairVol)) {
                        pairPositionSet.add(1);
                        continue;
                    }
                    pairPositionSet.add(-1);
                }
                if (pairPositionSet.size() == 1) {
                    ret = this.getLocalPairPositionString(gadPairVolList.get(0));
                } else if (pairPositionSet.size() > 1) {
                    ret = this.guidanceHandle.getGuidance("MIXED");
                }
            } else {
                ret = "";
            }
        }
        return ret;
    }

    public String getCtgIoModeString(SJctrHaCtgInfo gadCtgInfo) {
        String ret = "?";
        if (null != gadCtgInfo) {
            if (gadCtgInfo.getUsage() == 1) {
                List<SJmoHAPairVolInfo> gadPairVolList = gadCtgInfo.getGadPairVolList();
                HashSet<Integer> ioModeSet = new HashSet<Integer>();
                for (SJmoHAPairVolInfo gadPairVol : gadPairVolList) {
                    ioModeSet.add(gadPairVol.getIIOMode());
                }
                if (ioModeSet.size() == 1) {
                    ret = this.getLocalIoModeString(gadPairVolList.get(0));
                } else if (ioModeSet.size() > 1) {
                    ret = this.guidanceHandle.getGuidance("MIXED");
                }
            } else {
                ret = "";
            }
        }
        return ret;
    }

    public static SJmoHAPairVolInfoMgr getSJmoHAPairVolInfoMgr(SJctrDataController dc) {
        List<?> retInfoList = SJctrHaUtility.getCache(dc, SJmoGetHAPairVolInfoMgr.class);
        if (null == retInfoList) {
            dc.getLogUty().putlog("getSJmoHAPairVolInfoMgr", "HA pair manager list is null.");
            SJctrError err = new SJctrError(210, 22, 107001);
            throw err.createException();
        }
        if (0 == retInfoList.size()) {
            dc.getLogUty().putlog("getSJmoHAPairVolInfoMgr", "Size of HA pair manager list is zero.");
            SJctrError err = new SJctrError(210, 22, 107001);
            throw err.createException();
        }
        SJmoHAPairVolInfoMgr retInfo = (SJmoHAPairVolInfoMgr)retInfoList.get(0);
        if (null == retInfo) {
            dc.getLogUty().putlog("getSJmoHAPairVolInfoMgr", "HA pair manager is null.");
            SJctrError err = new SJctrError(210, 22, 107001);
            throw err.createException();
        }
        return retInfo;
    }

    public static void chkCacheHaPairsDetailData(SJctrDataController dc) {
        SJctrReplicationUtility.getSJmoLdevDetail(dc);
        SJctrReplicationUtility.getSJmoLdevNicknameInfo(dc);
        SJctrReplicationUtility.getSJmoClprInfo(dc);
        SJctrReplicationUtility.getSJmoPortLunInfo(dc);
        SJctrHaUtility.getSJmoSubsystemInfo(dc);
        SJctrHaUtility.getSJmoSsidDetail(dc);
    }

    public static List<SJmoHAPairVolInfo> checkAndGetExistHaPairInfo(List<SJmoHAPairVolInfo> checkList, SJmoHAPairVolInfoMgr haPairInfoMgr) throws SJcException {
        if (checkList == null || haPairInfoMgr == null) {
            SJctrLogUty.error(LOG_TITLE, "checkAndGetExistHaPairInfo", "Argument is invalid");
            SJctrError err = new SJctrError(210, 22, 107001);
            throw err.createException();
        }
        ArrayList<SJmoHAPairVolInfo> retList = new ArrayList<SJmoHAPairVolInfo>(checkList.size());
        for (SJmoHAPairVolInfo remoteVol : checkList) {
            SJmoReplicationPairVolInfo localVol = SJctrHaUtility.getLocalVolume(remoteVol);
            if (localVol == null) {
                SJctrLogUty.error(LOG_TITLE, "checkAndGetExistHaPairInfo", "Local volume is null");
                SJctrError err = new SJctrError(210, 22, 206502);
                throw err.createException();
            }
            SJmoReplicationPairVolInfo modelLocalVol = haPairInfoMgr.getHAPairVolInfo(localVol);
            if (modelLocalVol == null) {
                SJctrLogUty.error(LOG_TITLE, "checkAndGetExistHaPairInfo", "Local volume is not exist in the Model");
                SJctrError err = new SJctrError(210, 22, 206502);
                throw err.createException();
            }
            ArrayList<? extends SJmoLdevIndex> modelRemoteVolList = null;
            modelRemoteVolList = SJctrHaUtility.isPvol(remoteVol) ? modelLocalVol.getAlPVolIndex() : modelLocalVol.getAlSVolIndex();
            Collections.sort(modelRemoteVolList);
            int index = Collections.binarySearch(modelRemoteVolList, remoteVol);
            if (index < 0) {
                SJctrLogUty.error(LOG_TITLE, "checkAndGetExistHaPairInfo", "Remote volume is not exist in the Model");
                SJctrError err = new SJctrError(210, 22, 206502);
                throw err.createException();
            }
            SJmoHAPairVolInfo modelRemoteVol = (SJmoHAPairVolInfo)modelRemoteVolList.get(index);
            try {
                retList.add((SJmoHAPairVolInfo)modelRemoteVol.clone());
            }
            catch (CloneNotSupportedException e) {
                SJctrLogUty.error(LOG_TITLE, "checkAndGetExistHaPairInfo", "Catch CloneNotSupportedException.");
                SJctrError err = new SJctrError(210, 22, 107001);
                throw err.createException();
            }
        }
        return retList;
    }

    public static List<SJctrHaCtgInfo> getTargetHaCtgInfo(List<SJctrHaCtgInfo> targetCtgsList, List<SJmoHAPairVolInfo> haPairsList, List<SJmoHUVMVirtualLdev> virtualLdevsList, List<SJmoHUVMVirtualDkc> virtualDkcList) {
        if (targetCtgsList == null || haPairsList == null || virtualLdevsList == null || virtualDkcList == null) {
            SJctrLogUty.error(LOG_TITLE, "getTargetHaCtgInfo", "Argument is invalid.");
            throw SJctrHaUtility.createRemoteReplicationException(107001);
        }
        ArrayList<SJmoHUVMVirtualLdev> sortableVirtualLdevsList = new ArrayList<SJmoHUVMVirtualLdev>(virtualLdevsList);
        ArrayList<SJmoHUVMVirtualDkc> sortableVirtualDkcList = new ArrayList<SJmoHUVMVirtualDkc>(virtualDkcList);
        Collections.sort(sortableVirtualLdevsList);
        Collections.sort(sortableVirtualDkcList);
        ArrayList<SJctrHaCtgInfo> retList = new ArrayList<SJctrHaCtgInfo>(targetCtgsList.size());
        for (SJctrHaCtgInfo targetCtg : targetCtgsList) {
            SJctrHaCtgInfo ctgInfo = SJctrHaUtility.getHaCtgInfo(targetCtg.getCtgId(), haPairsList, sortableVirtualLdevsList, sortableVirtualDkcList);
            retList.add(ctgInfo);
        }
        return retList;
    }

    public static List<SJmoHAPairVolInfo> getExistHaPairInfo(List<SJmoHAPairVolInfo> checkList, SJmoHAPairVolInfoMgr haPairInfoMgr) throws SJcException {
        if (checkList == null || haPairInfoMgr == null) {
            SJctrLogUty.error(LOG_TITLE, "getExistHaPairInfo", "Argument is invalid");
            SJctrError err = new SJctrError(210, 22, 107001);
            throw err.createException();
        }
        ArrayList<SJmoHAPairVolInfo> retList = new ArrayList<SJmoHAPairVolInfo>(checkList.size());
        for (SJmoHAPairVolInfo remoteVol : checkList) {
            SJmoReplicationPairVolInfo localVol = SJctrHaUtility.getLocalVolume(remoteVol);
            if (localVol == null) {
                SJctrLogUty.error(LOG_TITLE, "getExistHaPairInfo", "Local volume is null");
                SJctrError err = new SJctrError(210, 22, 206502);
                throw err.createException();
            }
            SJmoReplicationPairVolInfo modelLocalVol = haPairInfoMgr.getHAPairVolInfo(localVol);
            if (modelLocalVol == null) {
                SJctrLogUty.error(LOG_TITLE, "getExistHaPairInfo", "Local volume is not exist in the Model");
                continue;
            }
            ArrayList<? extends SJmoLdevIndex> modelRemoteVolList = null;
            modelRemoteVolList = SJctrHaUtility.isPvol(remoteVol) ? modelLocalVol.getAlPVolIndex() : modelLocalVol.getAlSVolIndex();
            Collections.sort(modelRemoteVolList);
            int index = Collections.binarySearch(modelRemoteVolList, remoteVol);
            if (index < 0) {
                SJctrLogUty.error(LOG_TITLE, "getExistHaPairInfo", "Remote volume is not exist in the Model");
                continue;
            }
            SJmoHAPairVolInfo modelRemoteVol = (SJmoHAPairVolInfo)modelRemoteVolList.get(index);
            try {
                retList.add((SJmoHAPairVolInfo)modelRemoteVol.clone());
            }
            catch (CloneNotSupportedException e) {
                SJctrLogUty.error(LOG_TITLE, "getExistHaPairInfo", "Catch CloneNotSupportedException.");
                SJctrError err = new SJctrError(210, 22, 107001);
                throw err.createException();
            }
        }
        return retList;
    }

    public static void setCacheHaPairDetailData(Map<String, List<?>> needDataMap, SJctrDataController dc) {
        needDataMap.put(SJmoGetLdevDetail.class.getName(), SJctrHaUtility.getCache(dc, SJmoGetLdevDetail.class));
        needDataMap.put(SJmoGetLdevNicknameInfo.class.getName(), SJctrHaUtility.getCache(dc, SJmoGetLdevNicknameInfo.class));
        needDataMap.put(SJmoGetClprInfo.class.getName(), SJctrHaUtility.getCache(dc, SJmoGetClprInfo.class));
        needDataMap.put(SJmoGetSubsystemInfo.class.getName(), SJctrHaUtility.getCache(dc, SJmoGetSubsystemInfo.class));
        needDataMap.put(SJmoGetSsidDetail.class.getName(), SJctrHaUtility.getCache(dc, SJmoGetSsidDetail.class));
    }

    public static void setCacheHaPairVirtualDetailData(Map<String, List<?>> needDataMap, SJctrDataController dc) {
        if (dc == null) {
            SJctrLogUty.error(LOG_TITLE, "setCacheHaPairVirtualDetailData", "Argument is invalid.");
            throw SJctrHaUtility.createRemoteReplicationException(107001);
        }
        needDataMap.put(SJmoGetLdevDetail.class.getName(), SJctrHaUtility.getCache(dc, SJmoGetLdevDetail.class));
        needDataMap.put(SJmoGetLdevNicknameInfo.class.getName(), SJctrHaUtility.getCache(dc, SJmoGetLdevNicknameInfo.class));
        needDataMap.put(SJmoGetClprInfo.class.getName(), SJctrHaUtility.getCache(dc, SJmoGetClprInfo.class));
        needDataMap.put(SJmoGetSubsystemInfo.class.getName(), SJctrHaUtility.getCache(dc, SJmoGetSubsystemInfo.class));
        needDataMap.put(SJmoGetSsidDetail.class.getName(), SJctrHaUtility.getCache(dc, SJmoGetSsidDetail.class));
        needDataMap.put(SJmoGetHUVMVirtualDkc.class.getName(), SJctrHaUtility.getCache(dc, SJmoGetHUVMVirtualDkc.class));
        needDataMap.put(SJmoGetHUVMVirtualLdev.class.getName(), SJctrHaUtility.getCache(dc, SJmoGetHUVMVirtualLdev.class));
    }

    public static int checkSuspendHaPairStatus(List<SJmoHAPairVolInfo> pairExist) {
        int rtn = 0;
        if (pairExist != null) {
            for (SJmoHAPairVolInfo pairinfo : pairExist) {
                if (SJctrHaUtility.checkSuspendHaPairStatusSuspend(pairinfo)) {
                    rtn |= 2;
                    continue;
                }
                rtn |= 1;
            }
        }
        return rtn;
    }

    public static boolean checkSuspendHaPairStatusSuspend(SJmoHAPairVolInfo pairinfo) {
        if (pairinfo == null) {
            SJctrLogUty.error(LOG_TITLE, "checkSuspendHaPairStatusSuspend", "Argument is invalid.");
            throw SJctrHaUtility.createRemoteReplicationException(107001);
        }
        boolean rtn = false;
        int pairStatus = SJctrHaUtility.getHaPairStatus(pairinfo);
        if (SJctrHaUtility.isSvol(pairinfo)) {
            if (SJctrHaDataMacro.SUSPEND_PAIR_STATUS_SUSPEND_PRIMARY.contains(pairStatus)) {
                rtn = true;
            }
        } else if (SJctrHaUtility.isPvol(pairinfo) && SJctrHaDataMacro.SUSPEND_PAIR_STATUS_SUSPEND_SECONDARY.contains(pairStatus)) {
            rtn = true;
        }
        return rtn;
    }

    public static boolean checkHaPairStatusSSWS(SJmoHAPairVolInfo pairinfo) {
        if (pairinfo == null) {
            SJctrLogUty.error(LOG_TITLE, "checkHaPairStatusSSWS", "Argument is invalid.");
            throw SJctrHaUtility.createRemoteReplicationException(107001);
        }
        boolean rtn = false;
        int pairStatus = pairinfo.getIPairStatus();
        int ssws = pairinfo.getISSWS();
        if (SJctrHaDataMacro.HA_PAIR_STATUS_SSWS.contains(pairStatus) && ssws == 1) {
            rtn = true;
        }
        return rtn;
    }

    public static int getHaPairStatus(SJmoHAPairVolInfo haPairInfo) {
        int ret = -1;
        if (null != haPairInfo) {
            ret = SJctrHaUtility.checkHaPairStatusSSWS(haPairInfo) ? 256 : haPairInfo.getIPairStatus();
        }
        return ret;
    }

    public static boolean checkResyncHaPairStatus(List<SJmoHAPairVolInfo> pairinfoList) {
        if (pairinfoList == null || pairinfoList.size() == 0) {
            return false;
        }
        boolean rtn = true;
        for (SJmoHAPairVolInfo pairinfo : pairinfoList) {
            if (pairinfo == null) {
                rtn = false;
                break;
            }
            int pairStatus = SJctrHaUtility.getHaPairStatus(pairinfo);
            int iIoMode = pairinfo.getIIOMode();
            rtn = SJctrHaUtility.isSvol(pairinfo) ? SJctrHaDataMacro.RESYNC_PVOL_PERMISSION_STATUS_HA.contains(pairStatus) && 2 == iIoMode : SJctrHaDataMacro.RESYNC_SVOL_PERMISSION_STATUS_HA.contains(pairStatus);
            if (rtn) continue;
            break;
        }
        return rtn;
    }

    public static List<SJmoHUVMVirtualDkc> getSJmoHUVMVirtualDkc(SJctrDataController dc) {
        List<SJmoHUVMVirtualDkc> retInfoList = SJctrHaUtility.getCache(dc, SJmoGetHUVMVirtualDkc.class);
        if (null == retInfoList) {
            dc.getLogUty().putlog("SJmoHUVMVirtualDkc", "Information of Remote Replication HUVM Virtual DKC List is null.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        if (0 == retInfoList.size()) {
            dc.getLogUty().putlog("getSJmoHUVMVirtualLdev", "Size of Remote Replication HUVM Virtual DKC List is zero.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        return retInfoList;
    }

    public static Robj_interface_RJiLDEVIndex[] createPairDetailParam(List<SJmoHAPairVolInfo> pairList) {
        Robj_interface_RJiLDEVIndex[] ret = new Robj_interface_RJiLDEVIndex[pairList.size()];
        for (int i = 0; i < pairList.size(); ++i) {
            SJmoHAPairVolInfo hapair = pairList.get(i);
            SJmoReplicationPairVolInfo localVol = SJctrHaUtility.getLocalVolume(hapair);
            ret[i] = new RJiLDEVIndex();
            ret[i].setLDEVIndex(localVol.getSLdkc(), localVol.getSCu(), localVol.getSLdev());
        }
        return ret;
    }

    public String getHaSyncrateString(SJmoHAPairVolInfo pairinfo) {
        String ret = "?";
        if (pairinfo != null) {
            ret = SJctrHaUtility.isCheckViewSyncRateHaPairStatus(pairinfo) ? (pairinfo.isQueue() ? this.guidanceHandle.getGuidance("QUEUING") : Integer.toString(pairinfo.getICorrespondRate())) : "-";
        }
        return ret;
    }

    public static boolean isCheckViewSyncRateHaPairStatus(SJmoHAPairVolInfo pairinfo) {
        boolean ret = false;
        int status = SJctrHaUtility.getHaPairStatus(pairinfo);
        if (SJctrHaDataMacro.VIEW_SYNC_RATE_COLUMN_STATUS_HA.contains(status)) {
            ret = true;
        }
        return ret;
    }

    public static ArrayList<SJmoHAPairVolInfo> getHaPairVolInfoList(SJmoHAPairVolInfoMgr haPairMgr, SJctrResourceGroupUtility rsgUty, List<SJmoLdevDetail> ldevDetails) {
        SJmoReplicationPairVolInfo[] localPairInfoList;
        ArrayList<SJmoHAPairVolInfo> retList = new ArrayList<SJmoHAPairVolInfo>();
        List<SJmoLdevIndex> enableVolList = SJctrReplicationUtility.getEnableResourceLdevList(rsgUty);
        for (SJmoReplicationPairVolInfo localPairInfo : localPairInfoList = haPairMgr.getHAPairVolInfoList()) {
            if (null == localPairInfo || 0 > Collections.binarySearch(enableVolList, localPairInfo) || !SJctrReplicationUtility.checkViewPair(localPairInfo, ldevDetails)) continue;
            ArrayList<? extends SJmoLdevIndex> pRemotePairInfoList = localPairInfo.getAlPVolIndex();
            for (SJmoLdevIndex sJmoLdevIndex : pRemotePairInfoList) {
                retList.add((SJmoHAPairVolInfo)sJmoLdevIndex);
            }
            ArrayList<? extends SJmoLdevIndex> sRemotePairInfoList = localPairInfo.getAlSVolIndex();
            for (SJmoLdevIndex sJmoLdevIndex : sRemotePairInfoList) {
                retList.add((SJmoHAPairVolInfo)sJmoLdevIndex);
            }
        }
        return retList;
    }

    public static ArrayList<SJmoHAPairVolInfo> getHaPairVolInfoListNoResourceCheck(SJmoHAPairVolInfoMgr haPairMgr, List<SJmoLdevDetail> ldevDetails) {
        SJmoReplicationPairVolInfo[] localPairInfoList;
        if (haPairMgr == null || ldevDetails == null) {
            SJctrLogUty.error(LOG_TITLE, "getHaPairVolInfoListNoResourceCheck", "Argument is invalid.");
            throw SJctrHaUtility.createRemoteReplicationException(107001);
        }
        ArrayList<SJmoHAPairVolInfo> retList = new ArrayList<SJmoHAPairVolInfo>();
        for (SJmoReplicationPairVolInfo localPairInfo : localPairInfoList = haPairMgr.getHAPairVolInfoList()) {
            if (localPairInfo == null || !SJctrReplicationUtility.checkViewPair(localPairInfo, ldevDetails)) continue;
            ArrayList<? extends SJmoLdevIndex> pRemotePairInfoList = localPairInfo.getAlPVolIndex();
            for (SJmoLdevIndex sJmoLdevIndex : pRemotePairInfoList) {
                retList.add((SJmoHAPairVolInfo)sJmoLdevIndex);
            }
            ArrayList<? extends SJmoLdevIndex> sRemotePairInfoList = localPairInfo.getAlSVolIndex();
            for (SJmoLdevIndex sJmoLdevIndex : sRemotePairInfoList) {
                retList.add((SJmoHAPairVolInfo)sJmoLdevIndex);
            }
        }
        return retList;
    }

    public static SJmoReplicationPairVolInfo getLocalVolume(SJmoHAPairVolInfo haPairInfo) {
        if (haPairInfo == null) {
            SJctrLogUty.error(LOG_TITLE, "getLocalVolume", "Argument is null.");
            SJctrError err = new SJctrError(210, 22, 107001);
            throw err.createException();
        }
        SJmoReplicationPairVolInfo localVol = null;
        if (SJctrHaUtility.isSvol(haPairInfo)) {
            localVol = (SJmoReplicationPairVolInfo)haPairInfo.getAlPVolIndex().get(0);
        } else if (SJctrHaUtility.isPvol(haPairInfo)) {
            localVol = (SJmoReplicationPairVolInfo)haPairInfo.getAlSVolIndex().get(0);
        } else {
            SJctrLogUty.error(LOG_TITLE, "getLocalVolume", "SJmoHAPairVolInfo.iPairVolPos is invalid.");
        }
        return localVol;
    }

    public static boolean isPvol(SJmoHAPairVolInfo haPairInfo) {
        if (null == haPairInfo) {
            SJctrLogUty.error(LOG_TITLE, "isPvol", "Argument is null");
            return false;
        }
        return haPairInfo.isVolPos(1024);
    }

    public static boolean isSvol(SJmoHAPairVolInfo haPairInfo) {
        if (null == haPairInfo) {
            SJctrLogUty.error(LOG_TITLE, "isSvol", "Argument is null");
            return false;
        }
        return haPairInfo.isVolPos(2048);
    }

    public static void checkPairPortRsg(List<SJmoHAPairVolInfo> haPairInfoList, SJmoRemoteReplicationMRCUInfoMgr mrcuInfoMgr, SJctrResourceGroupUtility rsgUty) {
        if (null == haPairInfoList || null == mrcuInfoMgr || null == rsgUty) {
            SJctrLogUty.error(LOG_TITLE, "checkPairPortRsg", "Arguments is invalid");
            throw SJctrHaUtility.createRemoteReplicationException(107001);
        }
        for (SJmoHAPairVolInfo haPairInfo : haPairInfoList) {
            SJctrHaUtility.checkPairPortRsg(haPairInfo, mrcuInfoMgr, rsgUty);
        }
    }

    public static void checkPairPortRsg(SJmoHAPairVolInfo haPairInfo, SJmoRemoteReplicationMRCUInfoMgr mrcuInfoMgr, SJctrResourceGroupUtility rsgUty) {
        SJmoRemoteReplicationRCUInfo rcuInfo;
        if (null == haPairInfo || null == mrcuInfoMgr || null == rsgUty) {
            SJctrLogUty.error(LOG_TITLE, "checkPairPortRsg", "Argument is invalid");
            throw SJctrHaUtility.createRemoteReplicationException(107001);
        }
        if (SJctrHaUtility.isSvol(haPairInfo) && !SJctrHaUtility.hasRcuPortRs(rcuInfo = SJctrHaUtility.getPairRcuInfo(haPairInfo, mrcuInfoMgr), rsgUty)) {
            SJctrLogUty.error(LOG_TITLE, "checkPairPortRsg", "Pair RCU Port is not authorized.");
            throw SJctrHaUtility.createRemoteReplicationException(206150);
        }
    }

    public static SJmoRemoteReplicationRCUInfo getPairRcuInfo(SJmoHAPairVolInfo haPairInfo, SJmoRemoteReplicationMRCUInfoMgr mrcuInfoMgr) {
        if (null == haPairInfo || null == mrcuInfoMgr) {
            SJctrLogUty.error(LOG_TITLE, "getPairRcuInfo", "Argument is invalid");
            throw SJctrHaUtility.createRemoteReplicationException(107001);
        }
        SJmoReplicationPairVolInfo localVol = SJctrHaUtility.getLocalVolume(haPairInfo);
        if (null == localVol) {
            SJctrLogUty.error(LOG_TITLE, "getPairRcuInfo", "Failed to get local volume");
            throw SJctrHaUtility.createRemoteReplicationException(107001);
        }
        return SJctrHaUtility.getRcuInfo(true, localVol.getSLdkc(), localVol.getSCu(), haPairInfo.getSCu(), haPairInfo.getIPairModel(), haPairInfo.getStrPairSN(), haPairInfo.getIPathGroup(), mrcuInfoMgr);
    }

    public static int getPairPortAttribute(SJmoHAPairVolInfo haPair) {
        int attribute = -1;
        if (SJctrHaUtility.isPvol(haPair)) {
            attribute = 4;
        } else if (SJctrHaUtility.isSvol(haPair)) {
            attribute = 5;
        }
        return attribute;
    }

    public static boolean isAuthorizedQuorumDisk(SJmoHAPairVolInfo haPairInfo, List<SJmoQuorumDiskInfo> allQuorumInfoList, List<? extends SJmoLdevIndex> rsgLdevDetailList) {
        SJmoLdevIndex quorumLdevIndex;
        if (haPairInfo == null || allQuorumInfoList == null || rsgLdevDetailList == null) {
            SJctrLogUty.error(LOG_TITLE, "isAuthorized", "Argument is null.");
            throw SJctrHaUtility.createRemoteReplicationException(107001);
        }
        int iQuorumId = haPairInfo.getIQuorumID();
        SJmoQuorumDiskIndex index = new SJmoQuorumDiskIndex();
        index.setIQuorumDiskID((short)iQuorumId);
        int target = Collections.binarySearch(allQuorumInfoList, index);
        if (target < 0) {
            SJctrLogUty.error(LOG_TITLE, "isAuthorizedQuorumDisk", "Failed to get Quorum Disk.");
            throw SJctrHaUtility.createRemoteReplicationException(107001);
        }
        SJmoQuorumDiskInfo quorumDiskInfo = allQuorumInfoList.get(target);
        if (1 == quorumDiskInfo.getIRegist() && !SJctrHaUtility.isQuorumLess(quorumDiskInfo.getIQuorumOption()) && Collections.binarySearch(rsgLdevDetailList, quorumLdevIndex = quorumDiskInfo.getQuorumLdevIndex()) < 0) {
            SJctrLogUty.error(LOG_TITLE, "isAuthorizedQuorumDisk", "Quorum Disk is not authorized.");
            throw SJctrHaUtility.createRemoteReplicationException(206155);
        }
        return true;
    }

    public static boolean isContainSuspend(List<SJmoHAPairVolInfo> haPairInfoList) {
        boolean ret = false;
        for (SJmoHAPairVolInfo haPairInfo : haPairInfoList) {
            if (!SJctrHaUtility.isSuspend(haPairInfo)) continue;
            ret = true;
            break;
        }
        return ret;
    }

    public static boolean isContainNonSuspend(List<SJmoHAPairVolInfo> haPairInfoList) {
        boolean ret = false;
        for (SJmoHAPairVolInfo haPairInfo : haPairInfoList) {
            if (SJctrHaUtility.isSuspend(haPairInfo)) continue;
            ret = true;
            break;
        }
        return ret;
    }

    public static boolean isSuspend(SJmoHAPairVolInfo haPairInfo) {
        boolean ret = false;
        if (null != haPairInfo) {
            int iPairStatus = SJctrHaUtility.getHaPairStatus(haPairInfo);
            int iIoMode = haPairInfo.getIIOMode();
            ret = SJctrHaUtility.isSvol(haPairInfo) ? SJctrHaDataMacro.HA_PAIR_STATUS_SUSPEND_PRIMARY.contains(iPairStatus) && 3 != iIoMode && 4 != iIoMode : SJctrHaDataMacro.HA_PAIR_STATUS_SUSPEND_SECONDARY.contains(iPairStatus);
        }
        return ret;
    }

    public static boolean isOnlyCopy(List<SJmoHAPairVolInfo> haPairInfoList) {
        if (haPairInfoList == null) {
            SJctrLogUty.error(LOG_TITLE, "isOnlyCopy", "Argument is null.");
            throw SJctrHaUtility.createRemoteReplicationException(107001);
        }
        boolean ret = true;
        for (SJmoHAPairVolInfo haPairInfo : haPairInfoList) {
            int pairStatus = SJctrHaUtility.getHaPairStatus(haPairInfo);
            if (pairStatus == 1) continue;
            ret = false;
            break;
        }
        return ret;
    }

    public static void setCapacityUnit(SJctrTableDataModel table) {
        if (table == null) {
            SJctrLogUty.error(LOG_TITLE, "setCapacityUnit", "Argument is null.");
            throw SJctrHaUtility.createRemoteReplicationException(107001);
        }
        Set<String> keySet = table.getAllColumnKeySet();
        for (String key : keySet) {
            SJctrColumn column = table.getColumnInfo(key);
            if (!(column instanceof SJctrCapacityColumn)) continue;
            table.setCapacityFlg(true);
            table.setDpVolumeFlg(false);
            table.setOpenVolumeFlg(true);
            table.setMainframeVolumeFlg(false);
            return;
        }
    }

    public String getQuorumDiskIdString(SJmoQuorumDiskInfo quorumDiskInfo) {
        String ret = "?";
        if (null != quorumDiskInfo) {
            int iQuorumDiskID = quorumDiskInfo.getIQuorumDiskID();
            ret = SJctrComUtility.toHexString(iQuorumDiskID, 2, true);
        }
        return ret;
    }

    public static void setCacheQuorumDisksDetailData(Map<String, List<?>> needDataMap, SJctrDataController dc) {
        needDataMap.put(SJmoGetLdevDetail.class.getName(), SJctrHaUtility.getCache(dc, SJmoGetLdevDetail.class));
        needDataMap.put(SJmoGetLdevNicknameInfo.class.getName(), SJctrHaUtility.getCache(dc, SJmoGetLdevNicknameInfo.class));
        needDataMap.put(SJmoGetClprInfo.class.getName(), SJctrHaUtility.getCache(dc, SJmoGetClprInfo.class));
    }

    public static ArrayList<SJmoQuorumDiskInfo> getQuorumDisksInfoList(List<SJmoQuorumDiskInfo> quorumDisksInfoList, SJctrResourceGroupUtility rsgUty) {
        ArrayList<SJmoQuorumDiskInfo> retList = new ArrayList<SJmoQuorumDiskInfo>();
        List<SJmoLdevIndex> enableVolList = SJctrReplicationUtility.getEnableResourceLdevList(rsgUty);
        for (SJmoQuorumDiskInfo quorumDisksInfo : quorumDisksInfoList) {
            if (null == quorumDisksInfo || !SJctrHaUtility.isQuorumLess(quorumDisksInfo.getIQuorumOption()) && 0 > Collections.binarySearch(enableVolList, quorumDisksInfo.getQuorumLdevIndex())) continue;
            retList.add(quorumDisksInfo);
        }
        return retList;
    }

    public static ArrayList<SJmoQuorumDiskInfo> getQuorumDisksInfoRegisteredList(List<SJmoQuorumDiskInfo> quorumDiskInfoList, SJctrResourceGroupUtility rsgUty) {
        ArrayList<SJmoQuorumDiskInfo> registeredQuorumDiskInfoList = new ArrayList<SJmoQuorumDiskInfo>();
        for (SJmoQuorumDiskInfo quorumDiskInfo : quorumDiskInfoList) {
            if (1 != quorumDiskInfo.getIRegist()) continue;
            registeredQuorumDiskInfoList.add(quorumDiskInfo);
        }
        ArrayList<SJmoQuorumDiskInfo> retList = SJctrHaUtility.getQuorumDisksInfoList(registeredQuorumDiskInfoList, rsgUty);
        return retList;
    }

    public static List<SJmoQuorumDiskInfo> getSJmoQuorumDiskInfo(SJctrDataController dc) {
        List<SJmoQuorumDiskInfo> retInfoList = SJctrHaUtility.getCache(dc, SJmoGetQuorumDiskInfo.class);
        if (null == retInfoList) {
            dc.getLogUty().putlog("getSJmoQuorumDiskInfo", "Information of Remote Replication Ha Quorum Disks List is null.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        return retInfoList;
    }

    public String getModelSerialString(SJmoQuorumDiskInfo quorumInfo) {
        String ret = "? / ?";
        if (null != quorumInfo) {
            int iCtrlID = quorumInfo.getICtrlID();
            String strSN = quorumInfo.getStrSN();
            ret = this.getModelSNoString(iCtrlID, strSN);
        }
        return ret;
    }

    public static List<SJmoHUVMVirtualLdev> getSJmoHUVMVirtualLdev(SJctrDataController dc) {
        List<SJmoHUVMVirtualLdev> retInfoList = SJctrHaUtility.getCache(dc, SJmoGetHUVMVirtualLdev.class);
        if (null == retInfoList) {
            dc.getLogUty().putlog("getSJmoHUVMVirtualLdev", "Information of Remote Replication HUVM Virtual LDEV List is null.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        return retInfoList;
    }

    public static List<SJmoQuorumDiskInfo> checkAndGetExistQuorumInfo(List<SJmoQuorumDiskInfo> checkList, List<SJmoQuorumDiskInfo> allQuorumInfo) throws SJcException {
        if (null == checkList || null == allQuorumInfo) {
            SJctrLogUty.error("SJctrHaUtility", "checkAndGetExistQuorumInfo", "Check data is invalid");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        ArrayList<SJmoQuorumDiskInfo> retList = new ArrayList<SJmoQuorumDiskInfo>();
        Collections.sort(allQuorumInfo);
        for (SJmoQuorumDiskInfo selectedQuorum : checkList) {
            int index = Collections.binarySearch(allQuorumInfo, selectedQuorum);
            if (0 <= index) {
                SJmoQuorumDiskInfo target = allQuorumInfo.get(index);
                if (target.getIRegist() == 1) {
                    retList.add(target);
                    continue;
                }
                SJctrLogUty.error("SJctrHaUtility", "checkAndGetExistQuorumInfo", "quorum disk is not a registered state");
                SJctrError err = new SJctrError(210, 22, 206511);
                SJcException exp = err.createException();
                throw exp;
            }
            SJctrLogUty.error("SJctrHaUtility", "checkAndGetExistQuorumInfo", "Check list data is different from Quorum Disk list.");
            SJctrError err = new SJctrError(210, 22, 206511);
            SJcException exp = err.createException();
            throw exp;
        }
        return retList;
    }

    public static boolean isHuvmReserve(SJmoHUVMVirtualLdev virtualLdev) {
        boolean hAReserveFlg = false;
        short sVattrHuvm = virtualLdev.getSVAttrHuvm();
        if ((sVattrHuvm & 0xA000) == 40960) {
            hAReserveFlg = true;
        }
        return hAReserveFlg;
    }

    public static RJiHAget1PairSummary[] getHAPairSummaryInfo(SJctrDataController dc, List<SJmoHAPairVolInfo> pairlist) {
        List<SJmoThroughRmiData> rmiData = SJctrHaUtility.getViewPairModelDirect(dc, pairlist);
        RJiHAget1PairSummary[] summaryInfo = SJctrHaUtility.getHAPairSummaryInfo(rmiData);
        if (null == summaryInfo) {
            SJctrLogUty.error(LOG_TITLE, "getHAPairSummaryInfo", "summaryInfo is null.");
            throw SJctrHaUtility.createRemoteReplicationException(107001);
        }
        return summaryInfo;
    }

    public static List<SJmoThroughRmiData> getViewPairModelDirect(SJctrDataController dc, List<SJmoHAPairVolInfo> pairlist) {
        HashSet<SJctrGetDirectWrapper> set = new HashSet<SJctrGetDirectWrapper>();
        RJiInputHAPairParam inputParam = (RJiInputHAPairParam)SJctrHaUtility.createRmiParam(pairlist);
        RJiHAgetPair_IN pairRate = new RJiHAgetPair_IN(inputParam);
        SJctrGetRJiHaPair kindGetHaPair = new SJctrGetRJiHaPair(pairRate);
        SJmoGetRange_IF rangeGetHaPair = null;
        ArrayList filterGetHaPair = new ArrayList();
        SJmoGetDirect directGetHaPair = new SJmoGetDirect(kindGetHaPair, rangeGetHaPair, filterGetHaPair);
        SJctrGetDirectWrapper wrapperGetHaPair = new SJctrGetDirectWrapper(directGetHaPair);
        wrapperGetHaPair.setCacheMode(false);
        set.add(wrapperGetHaPair);
        SJctrLogUty.info(LOG_TITLE, "getViewPairModelDirect", "Number of Pair = " + pairlist.size());
        Map<SJctrGetDirectWrapper, List<?>> map = dc.getProxy().getDataInf(set);
        List<SJmoThroughRmiData> hapairinfo = map.get(wrapperGetHaPair);
        return hapairinfo;
    }

    public static RJiHAget1PairSummary[] getHAPairSummaryInfo(List<SJmoThroughRmiData> rmiData) {
        RJiHAgetPair_OUT pairRateInfo = (RJiHAgetPair_OUT)rmiData.get(0).getObjRmi();
        RJiHAgetPair pairRate = (RJiHAgetPair)pairRateInfo.getDataObject();
        RJiHAget1PairSummary[] summaryInfo = (RJiHAget1PairSummary[])pairRate.get_PairSummary();
        return summaryInfo;
    }

    public static Robj_interface_RJiInputHAPairParam createRmiParam(List<SJmoHAPairVolInfo> pairList) {
        RJiInputHAPairParam pairParam = new RJiInputHAPairParam();
        if (null == pairList || 0 == pairList.size()) {
            SJctrLogUty.error(LOG_TITLE, "createRmiParam", "pairList is null or size zero.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        Robj_interface_RJiLDEVIndex[] param = SJctrHaUtility.createPairDetailParam(pairList);
        pairParam.setLDEVs(param);
        pairParam.setPP((short)1);
        return pairParam;
    }

    public static RJiHAsetLU getLocalRJiHAsetLU(SJmoLdevIndex ldevIndex, Map<Integer, List<SJmoPortLunDetail>> portLunMap) {
        RJiHAsetLU lu = new RJiHAsetLU();
        if (ldevIndex != null && portLunMap != null) {
            List<SJmoPortLunDetail> portLunDetailList = portLunMap.get(ldevIndex.getIndex());
            if (portLunDetailList != null && portLunDetailList.size() != 0) {
                SJmoPortLunDetail detail = portLunDetailList.get(0);
                lu.setHostGroup(detail.getSHostGroup());
                lu.setLUN(detail.getSLUN());
                lu.setPort(detail.getSPort());
            }
            lu.setLDKC(0);
            lu.setCU(ldevIndex.getSCu());
            lu.setLDEV(ldevIndex.getSLdev());
        }
        return lu;
    }

    public static RJiHAsetLU getRemoteRJiHAsetLU(SJmoHAPairVolInfo volInfo) {
        RJiHAsetLU lu = new RJiHAsetLU();
        if (volInfo != null) {
            SJmoLuIndex luIndex = volInfo.getPairLU();
            if (luIndex != null) {
                lu.setHostGroup(luIndex.getSHostGroup());
                lu.setLUN(luIndex.getILUN());
                lu.setPort(luIndex.getSPort());
            }
            lu.setLDKC(0);
            lu.setCU(volInfo.getSCu());
            lu.setLDEV(volInfo.getSLdev());
        }
        return lu;
    }

    public static boolean isUsedHAPairVol(List<SJmoLdevDetail> ldevlist, SJmoHAPairVolInfoMgr haPairMgr) {
        boolean result = false;
        if (null == ldevlist || 0 == ldevlist.size() || null == haPairMgr) {
            return result;
        }
        for (SJmoLdevDetail ldev : ldevlist) {
            SJmoReplicationPairVolInfo haPairVolInfo = haPairMgr.getHAPairVolInfo(ldev);
            if (null == haPairVolInfo) continue;
            result = true;
            break;
        }
        return result;
    }

    public static Map<Integer, List<SJmoPortLunDetail>> getLDEVLUPathMap(SJctrDataController dc) {
        List<SJmoPortLunInfo> portLunList = SJctrReplicationUtility.getSJmoPortLunInfo(dc);
        List<SJmoLdevDetail> ldevDetailList = SJctrReplicationUtility.getSJmoLdevDetail(dc);
        return SJctrReplicationUtility.createLDEVLUPathMap(portLunList, ldevDetailList);
    }

    public static void chkCacheForceDeleteHaPairsDetailData(SJctrDataController dc) {
        SJctrReplicationUtility.getSJmoLdevNicknameInfo(dc);
        SJctrReplicationUtility.getSJmoClprInfo(dc);
        SJctrReplicationUtility.getSJmoPortLunInfo(dc);
        SJctrHaUtility.getSJmoSubsystemInfo(dc);
        SJctrHaUtility.getSJmoSsidDetail(dc);
    }

    public static void setCacheForceDeleteHaPairDetailData(Map<String, List<?>> needDataMap, SJctrDataController dc) {
        needDataMap.put(SJmoGetLdevDetail.class.getName(), SJctrHaUtility.getCache(dc, SJmoGetLdevDetail.class));
        needDataMap.put(SJmoGetLdevNicknameInfo.class.getName(), SJctrHaUtility.getCache(dc, SJmoGetLdevNicknameInfo.class));
        needDataMap.put(SJmoGetClprInfo.class.getName(), SJctrHaUtility.getCache(dc, SJmoGetClprInfo.class));
        needDataMap.put(SJmoGetSubsystemInfo.class.getName(), SJctrHaUtility.getCache(dc, SJmoGetSubsystemInfo.class));
        needDataMap.put(SJmoGetSsidDetail.class.getName(), SJctrHaUtility.getCache(dc, SJmoGetSsidDetail.class));
    }

    public static RJiHAget1PairSummary getRmiPairRelatedModelPair(List<RJiHAget1PairSummary> rmiPairList, SJmoHAPairVolInfo remoteVol) {
        if (null == rmiPairList || null == remoteVol) {
            SJctrLogUty.error(LOG_TITLE, "getRmiPairRelatedModelPair", "Argument is null.");
            throw SJctrHaUtility.createRemoteReplicationException(107001);
        }
        SJmoReplicationPairVolInfo localVol = SJctrHaUtility.getLocalVolume(remoteVol);
        boolean bPvol = false;
        if (SJctrHaUtility.isSvol(remoteVol)) {
            bPvol = true;
        }
        RJiHAget1PairSummary ret = null;
        for (RJiHAget1PairSummary rmiPair : rmiPairList) {
            if (bPvol && rmiPair.getAttr() != 1 || !bPvol && rmiPair.getAttr() != 2) {
                SJctrLogUty.info(SJctrHaUtility.class.getSimpleName(), "getRmiPairRelatedModelPair ###Pair Position is invalid###", "rmiPair.getAttr()=" + rmiPair.getAttr() + ":isPvol(haPair)=" + SJctrHaUtility.isPvol(remoteVol));
                continue;
            }
            if (localVol.getIndex() == rmiPair.getLDEV()) {
                ret = rmiPair;
                break;
            }
            SJctrLogUty.info(SJctrHaUtility.class.getSimpleName(), "getRmiPairRelatedModelPair ###LDEV ID is invalid###", "rmiPair.getLDEV()=" + rmiPair.getLDEV() + ":localVol.getIndex()=" + localVol.getIndex());
        }
        return ret;
    }

    public static List<SJmoSsidDetail> getSJmoSsidDetail(SJctrDataController dc) {
        List<SJmoSsidDetail> retInfoList = SJctrHaUtility.getCache(dc, SJmoGetSsidDetail.class);
        if (null == retInfoList) {
            dc.getLogUty().putlog("getSJmoSsidDetail", "Information of SSID List is null.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        return retInfoList;
    }

    public static int getLocalExistenceSsid(SJmoLdevIndex ldev, List<SJmoSsidDetail> ssidDetailList) {
        int iSsid = -1;
        if (ldev == null || ssidDetailList == null) {
            return iSsid;
        }
        for (int i = 0; i < ssidDetailList.size(); ++i) {
            SJmoSsidDetail ssidDetail = ssidDetailList.get(i);
            if (ssidDetail.getLDKC() != ldev.getSLdkc() || ssidDetail.getCU() != ldev.getSCu() || ssidDetail.getStartLDEV() > ldev.getSLdev() || ssidDetail.getEndLDEV() < ldev.getSLdev()) continue;
            iSsid = ssidDetail.getSSID();
            break;
        }
        return iSsid;
    }

    public static String toPaddingZeroSerialNumber2(int digit, String sn) {
        while (sn.length() < digit) {
            sn = "0" + sn;
        }
        return sn;
    }

    public String getCopyTimeString(SJctrRemoteHistoriesHaInfo haInfo) {
        String ret = "?";
        if (haInfo != null) {
            ret = !SJctrHaUtility.isQuorumCode(haInfo) ? (SJctrHaUtility.isValidCopyTime(haInfo) ? (haInfo.getCopyTimeL() >= 0L ? haInfo.getCopyTime() : "-") : "-") : "-";
        }
        return ret;
    }

    public static boolean isQuorumCode(SJctrRemoteHistoriesHaInfo haInfo) {
        int code;
        boolean ret = false;
        if (null != haInfo && (16384 <= (code = haInfo.getDescriptionCode()) && code <= 16639 || 16640 <= code && code <= 16895)) {
            ret = true;
        }
        return ret;
    }

    public static boolean isCTGCode(SJctrRemoteHistoriesHaInfo haInfo) {
        boolean ret = false;
        if (null != haInfo) {
            int code = haInfo.getDescriptionCode();
            if (8192 <= code && code <= 8447) {
                ret = true;
            } else if (8448 <= code && code <= 8703) {
                ret = true;
            } else if (8704 <= code && code <= 8959) {
                ret = true;
            } else if (8960 <= code && code <= 9215) {
                ret = true;
            } else if (9216 <= code && code <= 9471) {
                ret = true;
            } else if (9472 <= code && code <= 9727) {
                ret = true;
            } else if (9728 <= code && code <= 9983) {
                ret = true;
            } else if (9984 <= code && code <= 10239) {
                ret = true;
            } else if (10240 <= code && code <= 10495) {
                ret = true;
            }
        }
        return ret;
    }

    public String getLocalPairPositionString(SJctrRemoteHistoriesHaInfo haInfo) {
        String ret = "?";
        if (null != haInfo) {
            if (!SJctrHaUtility.isQuorumCode(haInfo) && !SJctrHaUtility.isCTGCode(haInfo)) {
                if ((haInfo.getPairPosition() & 0xF) == 0) {
                    ret = this.guidanceHandle.getGuidance("PRIMARY");
                } else if ((haInfo.getPairPosition() & 0xF) == 1) {
                    ret = this.guidanceHandle.getGuidance("SECONDARY");
                } else {
                    SJctrLogUty.error(LOG_TITLE, "getLocalPairPositionString", "RjiHAgetHistoryLog.iLdevAttr is invalid.");
                }
            } else {
                ret = "-";
            }
        }
        return ret;
    }

    public String getRemoteModelSerialString(SJctrRemoteHistoriesHaInfo haInfo) {
        RJiHAgetHistoryLog histLog;
        String ret = "? / ?";
        if (null != haInfo && null != (histLog = haInfo.getHAgetHistoryLog())) {
            int iPairModel = histLog.getModel();
            String strPairSN = histLog.getSN();
            ret = this.getModelSNoString(iPairModel, strPairSN);
        }
        return ret;
    }

    public String getVirtualModelSerialString(SJctrRemoteHistoriesHaInfo haInfo) {
        RJiHAgetHistoryLog histLog;
        String ret = "? / ?";
        if (null != haInfo && null != (histLog = haInfo.getHAgetHistoryLog())) {
            if (SJctrHaUtility.isQuorumCode(haInfo)) {
                ret = "- / -";
            } else {
                int iPairModel = histLog.getModel_V();
                String strPairSN = histLog.getSN_V();
                ret = this.getVssModelSNoString(iPairModel, strPairSN);
            }
        }
        return ret;
    }

    public String getMirrorIdString(SJctrRemoteHistoriesHaInfo haInfo) {
        String ret = "?";
        if (null != haInfo) {
            if (SJctrHaUtility.isQuorumCode(haInfo)) {
                ret = "-";
            } else {
                int iMirror = haInfo.getMirrorID();
                ret = Integer.toString(iMirror);
            }
        }
        return ret;
    }

    public String getQuorumDiskIdString(SJctrRemoteHistoriesHaInfo haInfo) {
        String ret = "?";
        if (null != haInfo) {
            if (haInfo.isQuorumEnable()) {
                int iQuorumID = haInfo.getQuorumID();
                ret = SJctrComUtility.toHexString(iQuorumID, 2, true);
            } else {
                ret = "";
            }
        }
        return ret;
    }

    public String getCtgIdString(SJctrRemoteHistoriesHaInfo haInfo) {
        String ret = "?";
        if (haInfo != null) {
            int ctgId = SJctrHaUtility.getCtgIdNumber(haInfo);
            switch (ctgId) {
                case -1: {
                    ret = "";
                    break;
                }
                case -2: {
                    ret = "-";
                    break;
                }
                case -3: {
                    ret = "?";
                    break;
                }
                default: {
                    ret = SJctrComUtility.toHexString(ctgId, 3, true);
                }
            }
        }
        return ret;
    }

    public static int getCtgIdNumber(SJctrRemoteHistoriesHaInfo haInfo) {
        int ret = -3;
        if (haInfo != null) {
            ret = !SJctrHaUtility.isQuorumCode(haInfo) ? (haInfo.isCtgEnable() ? haInfo.getCtgID() : -1) : -2;
        }
        return ret;
    }

    public static boolean isValidCopyTime(SJctrRemoteHistoriesHaInfo haInfo) {
        boolean ret = false;
        if (haInfo != null) {
            int code = haInfo.getDescriptionCode();
            if ((haInfo.getPairPosition() & 0xF) == 0 && 768 <= code && code <= 1023) {
                ret = true;
            }
        }
        return ret;
    }

    public String getCtgStatusString(SJmoHAPairVolInfo pairVolInfo) {
        String ret = "?";
        if (null != pairVolInfo) {
            if (!pairVolInfo.hasGroup()) {
                ret = "";
            }
            ret = this.getHaCtgStatusString(pairVolInfo.getIGroupStatus());
        }
        return ret;
    }

    public static boolean checkSelectedPairsSvol(List<SJmoHAPairVolInfo> selectedPairsList) {
        boolean ret = false;
        if (selectedPairsList != null && selectedPairsList.size() > 0) {
            boolean topPairPosition = SJctrHaUtility.isSvol(selectedPairsList.get(0));
            for (SJmoHAPairVolInfo pairVolInfo : selectedPairsList) {
                ret = topPairPosition && SJctrHaUtility.isSvol(pairVolInfo);
            }
        }
        return ret;
    }

    public static void chkCacheHaCtgsDetailData(SJctrDataController dc) {
        if (dc == null) {
            SJctrLogUty.error(LOG_TITLE, "chkCacheHaCtgsDetailData", "Argument is invalid.");
            throw SJctrHaUtility.createRemoteReplicationException(107001);
        }
        SJctrHaUtility.getSJmoHAPairVolInfoMgr(dc);
        SJctrReplicationUtility.getSJmoLdevDetail(dc);
        SJctrReplicationUtility.getSJmoPortLunInfo(dc);
        SJctrHaUtility.getSJmoSubsystemInfo(dc);
        SJctrHaUtility.getSJmoSsidDetail(dc);
        SJctrHaUtility.getSJmoHUVMVirtualLdev(dc);
        SJctrHaUtility.getSJmoHUVMVirtualDkc(dc);
        SJctrReplicationUtility.getSJmoRSGgetAllRsgs(dc);
    }

    public static ArrayList<SJctrHaCtgInfo> getHaCtgInfoList(SJmoHAPairVolInfoMgr haPairMgr, List<SJmoLdevDetail> ldevDetailsList, List<SJmoHUVMVirtualLdev> virtualLdevsList, List<SJmoHUVMVirtualDkc> virtualDkcList) {
        if (haPairMgr == null || ldevDetailsList == null || virtualLdevsList == null || virtualDkcList == null) {
            SJctrLogUty.error(LOG_TITLE, "getHaCtgInfoList", "Argument is invalid.");
            throw SJctrHaUtility.createRemoteReplicationException(107001);
        }
        ArrayList<SJctrHaCtgInfo> retList = new ArrayList();
        ArrayList<SJmoHAPairVolInfo> haPairsList = SJctrHaUtility.getHaPairVolInfoListNoResourceCheck(haPairMgr, ldevDetailsList);
        retList = SJctrHaUtility.getHaCtgInfoList(haPairsList, virtualLdevsList, virtualDkcList);
        return retList;
    }

    public static ArrayList<SJctrHaCtgInfo> getHaCtgInfoList(List<SJmoHAPairVolInfo> haPairsList, List<SJmoHUVMVirtualLdev> virtualLdevsList, List<SJmoHUVMVirtualDkc> virtualDkcList) {
        if (haPairsList == null || virtualLdevsList == null || virtualDkcList == null) {
            SJctrLogUty.error(LOG_TITLE, "getHaCtgInfoList", "Argument is invalid.");
            throw SJctrHaUtility.createRemoteReplicationException(107001);
        }
        ArrayList<SJmoHUVMVirtualLdev> sortableVirtualLdevsList = new ArrayList<SJmoHUVMVirtualLdev>(virtualLdevsList);
        ArrayList<SJmoHUVMVirtualDkc> sortableVirtualDkcList = new ArrayList<SJmoHUVMVirtualDkc>(virtualDkcList);
        Collections.sort(sortableVirtualLdevsList);
        Collections.sort(sortableVirtualDkcList);
        ArrayList<SJctrHaCtgInfo> retList = new ArrayList<SJctrHaCtgInfo>();
        int maxGadCtgNum = SJctrHaUtility.getMaxGadCtgNum();
        for (int i = 0; i < maxGadCtgNum; ++i) {
            SJctrHaCtgInfo ctgInfo = SJctrHaUtility.getHaCtgInfo(i, haPairsList, sortableVirtualLdevsList, sortableVirtualDkcList);
            retList.add(ctgInfo);
        }
        return retList;
    }

    public static int getMaxGadCtgNum() {
        int maxGadCtgNum = 256;
        if (SJctrDataController.isHM()) {
            int iHMKind = SJsncProductModelUty.getProductModel();
            switch (iHMKind) {
                case 20: {
                    maxGadCtgNum = 16;
                    break;
                }
                case 40: {
                    maxGadCtgNum = 64;
                    break;
                }
                case 60: {
                    maxGadCtgNum = 128;
                }
            }
        }
        return maxGadCtgNum;
    }

    public static SJctrHaCtgInfo getHaCtgInfo(int ctgId, List<SJmoHAPairVolInfo> haPairsList, List<SJmoHUVMVirtualLdev> virtualLdevsList, List<SJmoHUVMVirtualDkc> virtualDkcList) {
        if (haPairsList == null || virtualLdevsList == null || virtualDkcList == null) {
            SJctrLogUty.error(LOG_TITLE, "getHaCtgInfo", "Argument is invalid.");
            throw SJctrHaUtility.createRemoteReplicationException(107001);
        }
        SJctrHaCtgInfo ctgInfo = new SJctrHaCtgInfo();
        ArrayList<SJmoHAPairVolInfo> targetHaPairsList = SJctrHaUtility.getTargetCtgHAPairVolInfoList(ctgId, haPairsList);
        ctgInfo.setCtgId(ctgId);
        if (targetHaPairsList.size() > 0) {
            SJmoHAPairVolInfo targetHaPair = (SJmoHAPairVolInfo)targetHaPairsList.get(0);
            SJmoHUVMVirtualDkc virtualDkc = SJctrHaUtility.getTargetVirtualDkcInfo(targetHaPair, virtualLdevsList, virtualDkcList);
            ctgInfo.setUsage(1);
            ctgInfo.setStatus(targetHaPair.getIGroupStatus());
            ctgInfo.setQuorumDiskDisable(targetHaPair.isQuorumDisabled());
            ctgInfo.setQuorumDiskId(targetHaPair.getIQuorumID());
            ctgInfo.setMirrorId(targetHaPair.getIMuNo());
            ctgInfo.setNumOfPairs(targetHaPairsList.size());
            if (SJctrHaUtility.isSvol(targetHaPair)) {
                ctgInfo.setLocalPairPosition(0);
            } else if (SJctrHaUtility.isPvol(targetHaPair)) {
                ctgInfo.setLocalPairPosition(1);
            }
            ctgInfo.setVirtualDkc(virtualDkc);
            ctgInfo.setGadPairVolList(targetHaPairsList);
        }
        return ctgInfo;
    }

    public static SJmoHUVMVirtualDkc getTargetVirtualDkcInfo(SJmoHAPairVolInfo haPair, List<SJmoHUVMVirtualLdev> virtualLdevsList, List<SJmoHUVMVirtualDkc> virtualDkcList) {
        SJmoHUVMVirtualLdev huvmVirtualLdev;
        SJmoHUVMvboxIndex vBoxIndex;
        int targetDkc;
        int targetLdev;
        if (haPair == null || virtualLdevsList == null || virtualDkcList == null) {
            SJctrLogUty.error(LOG_TITLE, "getTargetVirtualDkcInfo", "Argument is invalid.");
            throw SJctrHaUtility.createRemoteReplicationException(107001);
        }
        SJmoHUVMVirtualDkc ret = null;
        SJmoReplicationPairVolInfo localVol = SJctrHaUtility.getLocalVolume(haPair);
        if (localVol != null && (targetLdev = Collections.binarySearch(virtualLdevsList, localVol)) >= 0 && (targetDkc = Collections.binarySearch(virtualDkcList, vBoxIndex = (huvmVirtualLdev = virtualLdevsList.get(targetLdev)).getVBoxIndex())) >= 0) {
            SJmoHUVMVirtualDkc huvmVirtualDkc;
            ret = huvmVirtualDkc = virtualDkcList.get(targetDkc);
        }
        return ret;
    }

    public static ArrayList<SJmoHAPairVolInfo> getTargetCtgHAPairVolInfoList(SJctrHaCtgInfo haCtg, List<SJmoHAPairVolInfo> haPairsList) {
        if (haCtg == null || haPairsList == null) {
            SJctrLogUty.error(LOG_TITLE, "getTargetCtgHAPairVolInfoList", "Argument is invalid.");
            throw SJctrHaUtility.createRemoteReplicationException(107001);
        }
        int ctgId = haCtg.getCtgId();
        ArrayList<SJmoHAPairVolInfo> retList = SJctrHaUtility.getTargetCtgHAPairVolInfoList(ctgId, haPairsList);
        return retList;
    }

    public static ArrayList<SJmoHAPairVolInfo> getTargetCtgHAPairVolInfoList(int ctgId, List<SJmoHAPairVolInfo> haPairsList) {
        if (haPairsList == null) {
            SJctrLogUty.error(LOG_TITLE, "getTargetCtgHAPairVolInfoList", "Argument is invalid.");
            throw SJctrHaUtility.createRemoteReplicationException(107001);
        }
        ArrayList<SJmoHAPairVolInfo> retList = new ArrayList<SJmoHAPairVolInfo>();
        for (int i = 0; i < haPairsList.size(); ++i) {
            SJmoHAPairVolInfo haPair = haPairsList.get(i);
            if (!haPair.hasGroup() || haPair.getIGroup() != ctgId) continue;
            retList.add(haPair);
        }
        return retList;
    }

    public static ArrayList<SJmoHAPairVolInfo> getTargetCtgTopHAPairVolInfoList(List<SJctrHaCtgInfo> haCtgsList, List<SJmoHAPairVolInfo> haPairsList) {
        if (haCtgsList == null || haPairsList == null) {
            SJctrLogUty.error(LOG_TITLE, "getTargetCtgTopHAPairVolInfoList", "Argument is invalid.");
            throw SJctrHaUtility.createRemoteReplicationException(107001);
        }
        ArrayList<SJmoHAPairVolInfo> retList = new ArrayList<SJmoHAPairVolInfo>();
        for (int i = 0; i < haCtgsList.size(); ++i) {
            SJctrHaCtgInfo haCtg = haCtgsList.get(i);
            SJmoHAPairVolInfo topHAPairVolInfo = SJctrHaUtility.getTargetCtgTopHAPairVolInfo(haCtg, haPairsList);
            if (topHAPairVolInfo == null) continue;
            retList.add(topHAPairVolInfo);
        }
        return retList;
    }

    public static SJmoHAPairVolInfo getTargetCtgTopHAPairVolInfo(SJctrHaCtgInfo haCtg, List<SJmoHAPairVolInfo> haPairsList) {
        if (haCtg == null || haPairsList == null) {
            SJctrLogUty.error(LOG_TITLE, "getTargetCtgTopHAPairVolInfo", "Argument is invalid.");
            throw SJctrHaUtility.createRemoteReplicationException(107001);
        }
        int ctgId = haCtg.getCtgId();
        SJmoHAPairVolInfo retInfo = SJctrHaUtility.getTargetCtgTopHAPairVolInfo(ctgId, haPairsList);
        return retInfo;
    }

    public static SJmoHAPairVolInfo getTargetCtgTopHAPairVolInfo(int ctgId, List<SJmoHAPairVolInfo> haPairsList) {
        if (haPairsList == null) {
            SJctrLogUty.error(LOG_TITLE, "getTargetCtgTopHAPairVolInfo", "Argument is invalid.");
            throw SJctrHaUtility.createRemoteReplicationException(107001);
        }
        SJmoHAPairVolInfo retInfo = null;
        for (int i = 0; i < haPairsList.size(); ++i) {
            SJmoHAPairVolInfo haPair = haPairsList.get(i);
            if (!haPair.hasGroup() || haPair.getIGroup() != ctgId) continue;
            retInfo = haPair;
            break;
        }
        return retInfo;
    }

    public static boolean checkRsgHaPairs(List<SJmoHAPairVolInfo> haPairsList, SJctrResourceGroupUtility rsgUty) {
        if (haPairsList == null || rsgUty == null) {
            SJctrLogUty.error(LOG_TITLE, "checkRsgHaPairs", "Argument is invalid.");
            throw SJctrHaUtility.createRemoteReplicationException(107001);
        }
        boolean ret = true;
        ArrayList<SJmoReplicationPairVolInfo> localVolList = new ArrayList<SJmoReplicationPairVolInfo>();
        for (int i = 0; i < haPairsList.size(); ++i) {
            SJmoHAPairVolInfo haPair = haPairsList.get(i);
            SJmoReplicationPairVolInfo localVol = SJctrHaUtility.getLocalVolume(haPair);
            localVolList.add(localVol);
        }
        List<SJmoLdevIndex> ldevList = rsgUty.extractLdev(localVolList);
        if (ldevList.size() != localVolList.size()) {
            ret = false;
        }
        return ret;
    }

    public static boolean checkExistHaPairInHaCtgs(List<SJctrHaCtgInfo> haCtgsList) {
        if (haCtgsList == null) {
            SJctrLogUty.error(LOG_TITLE, "checkExistHaPairInHaCtgs", "Argument is invalid.");
            throw SJctrHaUtility.createRemoteReplicationException(107001);
        }
        boolean ret = false;
        for (int i = 0; i < haCtgsList.size(); ++i) {
            SJctrHaCtgInfo haCtg = haCtgsList.get(i);
            if (haCtg.getUsage() == 0) {
                ret = false;
                break;
            }
            ret = true;
        }
        return ret;
    }

    public static boolean checkEnableSuspendHaCtgStatus(List<SJctrHaCtgInfo> haCtgsList) {
        if (haCtgsList == null) {
            SJctrLogUty.error(LOG_TITLE, "checkEnableSuspendHaCtgStatus", "Argument is invalid.");
            throw SJctrHaUtility.createRemoteReplicationException(107001);
        }
        boolean ret = false;
        for (int i = 0; i < haCtgsList.size(); ++i) {
            SJctrHaCtgInfo haCtg = haCtgsList.get(i);
            int ctgTatus = haCtg.getStatus();
            boolean isEnableResync = SJctrHaDataMacro.SUSPEND_PERMISSION_STATUS_HA_CTG.contains(ctgTatus);
            if (!isEnableResync) {
                ret = false;
                break;
            }
            ret = true;
        }
        return ret;
    }

    public static boolean checkEnableResyncHaCtgStatus(List<SJctrHaCtgInfo> haCtgsList) {
        if (haCtgsList == null) {
            SJctrLogUty.error(LOG_TITLE, "checkEnableResyncHaCtgStatus", "Argument is invalid.");
            throw SJctrHaUtility.createRemoteReplicationException(107001);
        }
        boolean ret = true;
        for (int i = 0; i < haCtgsList.size(); ++i) {
            SJctrHaCtgInfo haCtg = haCtgsList.get(i);
            int ctgTatus = haCtg.getStatus();
            boolean isEnableResync = SJctrHaDataMacro.RESYNC_PERMISSION_STATUS_HA_CTG.contains(ctgTatus);
            if (!isEnableResync) {
                ret = false;
                break;
            }
            ret = true;
        }
        return ret;
    }

    public static List<SJmoHUVMVirtualDkc> getVirtualDkcInfoList(List<SJctrPortLunTableKey> portLunInfoList, SJctrDataController dc) {
        if (portLunInfoList == null || dc == null) {
            SJctrLogUty.error(LOG_TITLE, "getVirtualDkcInfoList", "Argument is invalid.");
            throw SJctrHaUtility.createRemoteReplicationException(107001);
        }
        ArrayList<SJmoHUVMVirtualDkc> targetVDkcInfoList = new ArrayList<SJmoHUVMVirtualDkc>();
        List<SJmoRSGgetAllRsgs> allRsgsList = SJctrReplicationUtility.getSJmoRSGgetAllRsgs(dc);
        List<SJmoHUVMVirtualDkc> vDkcInfoList = SJctrHaUtility.getSJmoHUVMVirtualDkc(dc);
        for (SJctrPortLunTableKey portLunInfo : portLunInfoList) {
            SJmoHUVMVirtualDkc vDkcInfo = SJctrHaUtility.getVirtualDkcInfo(portLunInfo, vDkcInfoList, SJctrReplicationUtility.checkSJmoRSGgetAllRsgsInfo(dc, allRsgsList), dc);
            if (vDkcInfo == null) continue;
            targetVDkcInfoList.add(vDkcInfo);
        }
        if (targetVDkcInfoList.size() > 0) {
            Collections.sort(targetVDkcInfoList);
        }
        return targetVDkcInfoList;
    }

    public static SJmoHUVMVirtualDkc getVirtualDkcInfo(SJctrPortLunTableKey portLunInfo, List<SJmoHUVMVirtualDkc> vDkcInfoList, SJmoRSGgetAllRsgs allRsgs, SJctrDataController dc) {
        SJmoHUVMvboxIndex targetIndex;
        int vBoxIndex;
        SJmoRSGgetRsg rsg;
        if (portLunInfo == null || vDkcInfoList == null || allRsgs == null || dc == null) {
            SJctrLogUty.error(LOG_TITLE, "getVirtualDkcInfo", "Argument is invalid.");
            throw SJctrHaUtility.createRemoteReplicationException(107001);
        }
        SJmoHUVMVirtualDkc targetVDkcInfo = null;
        SJmoLdevIndex ldevIndex = new SJmoLdevIndex();
        SJmoPortLunDetail portLunDetail = portLunInfo.getPortLunDetail();
        if (portLunDetail != null) {
            ldevIndex.setLdevIndex(portLunDetail.getSLDKC(), portLunDetail.getSCU(), portLunDetail.getSLDEV());
        }
        if ((rsg = SJctrArrayGroupUtility.getBelongToRsg(ldevIndex, allRsgs.getRsgs())) != null && (vBoxIndex = Collections.binarySearch(vDkcInfoList, targetIndex = rsg.getRsgInfo().getVboxIndex())) >= 0) {
            targetVDkcInfo = vDkcInfoList.get(vBoxIndex);
        }
        return targetVDkcInfo;
    }

    public static int getVolumeAccessFromHaPairVolInfo(SJmoHAPairVolInfo pairInfo, int selectedDeleteMode, int selectedVolumeAccess) {
        if (pairInfo == null) {
            SJctrLogUty.error(LOG_TITLE, "getVolumeAccessFromHaPairVolInfo", "HA PairInfo is null.");
            return 1;
        }
        int volumeAccess = 1;
        volumeAccess = SJctrHaUtility.isSuspend(pairInfo) ? selectedVolumeAccess : (pairInfo.getIPairStatus() == 1 ? SJctrHaUtility.getVolumeAccessForCopy(pairInfo) : SJctrHaUtility.getVolumeAccessForNotSuspendOrCopy(selectedDeleteMode, selectedVolumeAccess));
        return volumeAccess;
    }

    private static int getVolumeAccessForCopy(SJmoHAPairVolInfo pairInfo) {
        if (pairInfo == null) {
            SJctrLogUty.error(LOG_TITLE, "getVolumeAccessForCopy", "HA PairInfo is null.");
            throw SJctrHaUtility.createRemoteReplicationException(107001);
        }
        int volumeAccess = 1;
        if (SJctrHaUtility.isSvol(pairInfo)) {
            volumeAccess = 0;
        } else if (SJctrHaUtility.isPvol(pairInfo)) {
            volumeAccess = 1;
        }
        return volumeAccess;
    }

    private static int getVolumeAccessForNotSuspendOrCopy(int selectedDeleteMode, int selectedVolumeAccess) {
        int volumeAccess = 1;
        if (selectedDeleteMode == 0) {
            volumeAccess = 1;
        } else if (selectedDeleteMode == 1) {
            volumeAccess = selectedVolumeAccess;
        }
        return volumeAccess;
    }

    public static void setOldTaskNothingData(SJctrDataController dc) {
        List<?> quorumDiskInfoList;
        List<?> virtualLdevInfoList;
        List<?> virtualDkcInfoList = SJctrHaUtility.getCache(dc, SJmoGetHUVMVirtualDkc.class);
        if (null == virtualDkcInfoList) {
            dc.getProxy().putCache(SJmoGetHUVMVirtualDkc.class, new ArrayList(0));
        }
        if (null == (virtualLdevInfoList = SJctrHaUtility.getCache(dc, SJmoGetHUVMVirtualLdev.class))) {
            dc.getProxy().putCache(SJmoGetHUVMVirtualLdev.class, new ArrayList(0));
        }
        if (null == (quorumDiskInfoList = SJctrHaUtility.getCache(dc, SJmoGetQuorumDiskInfo.class))) {
            dc.getProxy().putCache(SJmoGetQuorumDiskInfo.class, new ArrayList(0));
        }
    }

    public static int getMaxAddPairNumHA() {
        int maxAddPairNumHa = 685280;
        if (SJctrDataController.isHM()) {
            int iHMKind = SJsncProductModelUty.getProductModel();
            switch (iHMKind) {
                case 20: {
                    maxAddPairNumHa = 2048;
                    break;
                }
                case 40: {
                    maxAddPairNumHa = 4096;
                    break;
                }
                case 60: {
                    maxAddPairNumHa = 16384;
                }
            }
        }
        return maxAddPairNumHa;
    }

    public static int checkMixedPairStatus(List<SJmoHAPairVolInfo> gadPairVolList) {
        if (gadPairVolList == null) {
            SJctrLogUty.error(LOG_TITLE, "checkMixedPairStatus", "GAD Pair List is invalid.");
            throw SJctrHaUtility.createRemoteReplicationException(107001);
        }
        int ret = -1;
        HashSet<Integer> pairStatusSet = new HashSet<Integer>();
        for (SJmoHAPairVolInfo gadPairVol : gadPairVolList) {
            int pairStatus = SJctrHaUtility.getHaPairStatus(gadPairVol);
            if (pairStatus == 1) {
                int initialSetting = gadPairVol.getIInitialSetting();
                pairStatus |= initialSetting << 16;
            }
            pairStatusSet.add(pairStatus);
        }
        if (pairStatusSet.size() == 1) {
            ret = 0;
        } else if (pairStatusSet.size() > 1) {
            ret = 1;
        }
        return ret;
    }

    public String getAluaModeString(SJmoLdevDetail ldevDetail) {
        String ret = "?";
        if (null != ldevDetail) {
            ret = ldevDetail.getBAluaMode() ? this.guidanceHandle.getGuidance("ENABLED") : this.guidanceHandle.getGuidance("DISABLED");
        }
        return ret;
    }

    public String getAccessModeBlkQDString(SJmoHAPairVolInfo pairInfo, SJmoQuorumDiskInfo quorumInfo) {
        String ret = "?";
        if (null != pairInfo && null != quorumInfo) {
            if (SJctrHaUtility.isQuorumLess(quorumInfo.getIQuorumOption())) {
                ret = "-";
            } else {
                switch (pairInfo.getIBlockadeMode()) {
                    case 16: {
                        ret = this.guidanceHandle.getGuidance("PAIR_OPERATING_MODE_SUSPEND");
                        break;
                    }
                    case 32: {
                        ret = this.guidanceHandle.getGuidance("PAIR_OPERATING_MODE_ACTIVE_STANDBY");
                        break;
                    }
                    case 33: {
                        ret = this.guidanceHandle.getGuidance("PAIR_OPERATING_MODE_ACTIVE_ACTIVE");
                        break;
                    }
                    case 0: {
                        ret = "-";
                        break;
                    }
                    default: {
                        ret = "?";
                    }
                }
            }
        }
        return ret;
    }

    public String getBlkRmPathMonSecString(SJmoQuorumDiskInfo quorumDiskInfo) {
        String ret = "?";
        if (quorumDiskInfo != null) {
            int blkRmPathMonSec = SJctrHaUtility.getBlkRMPathMonSecNumber(quorumDiskInfo);
            switch (blkRmPathMonSec) {
                case -3: {
                    ret = "?";
                    break;
                }
                case -2: {
                    ret = "-";
                    break;
                }
                default: {
                    ret = Integer.toString(blkRmPathMonSec);
                }
            }
        }
        return ret;
    }

    public static int getBlkRMPathMonSecNumber(SJmoQuorumDiskInfo quorumDiskInfo) {
        int ret = -3;
        int enableBit = quorumDiskInfo.getIReadResGuaranteedTimeBit();
        if (null != quorumDiskInfo) {
            ret = (enableBit & 1) == 1 || (enableBit & 3) == 3 ? quorumDiskInfo.getIReadResGuaranteedTime() : -2;
        }
        return ret;
    }

    public static boolean isAllSupportActActQuorumDisk(List<SJmoQuorumDiskInfo> checkQuorumDisksInfoList) {
        boolean bSupport = true;
        int iSupportBit = 0;
        for (SJmoQuorumDiskInfo qInfo : checkQuorumDisksInfoList) {
            iSupportBit = qInfo.getIReadResGuaranteedTimeBit();
            if ((iSupportBit & 1) == 1) continue;
            bSupport = false;
            break;
        }
        return bSupport;
    }

    public static boolean isQuorumLess(int quorumOption) {
        boolean ret = false;
        if ((quorumOption & 2) == 2) {
            ret = true;
        }
        return ret;
    }

    public static boolean isQuorumLessFromHist(SJctrRemoteHistoriesHaInfo haInfo) {
        boolean ret = false;
        if (null != haInfo && SJctrHaUtility.isQuorumCode(haInfo) && haInfo.getLocalLdevIndex().getIndex() == 65535) {
            ret = true;
        }
        return ret;
    }

    public static SJmoQuorumDiskInfo getQuorumInfoFromHaCtgInfo(SJctrHaCtgInfo haCtgInfo, List<SJmoQuorumDiskInfo> quorumInfoList) {
        SJmoQuorumDiskInfo quorumInfo = null;
        SJmoQuorumDiskInfo searchInfo = new SJmoQuorumDiskInfo();
        searchInfo.setIQuorumDiskID(haCtgInfo.getQuorumDiskId());
        ArrayList<SJmoQuorumDiskInfo> sortableQuorumInfo = new ArrayList<SJmoQuorumDiskInfo>(quorumInfoList);
        Collections.sort(sortableQuorumInfo);
        int index = Collections.binarySearch(sortableQuorumInfo, searchInfo);
        if (index >= 0) {
            quorumInfo = (SJmoQuorumDiskInfo)sortableQuorumInfo.get(index);
        }
        return quorumInfo;
    }

    public static SJmoQuorumDiskInfo getQuorumInfoFromHaPairInfo(SJmoHAPairVolInfo haPairInfo, List<SJmoQuorumDiskInfo> quorumInfoList) {
        SJmoQuorumDiskInfo quorumInfo = null;
        SJmoQuorumDiskInfo searchInfo = new SJmoQuorumDiskInfo();
        searchInfo.setIQuorumDiskID(haPairInfo.getIQuorumID());
        ArrayList<SJmoQuorumDiskInfo> sortableQuorumInfo = new ArrayList<SJmoQuorumDiskInfo>(quorumInfoList);
        Collections.sort(sortableQuorumInfo);
        int index = Collections.binarySearch(sortableQuorumInfo, searchInfo);
        if (index >= 0) {
            quorumInfo = (SJmoQuorumDiskInfo)sortableQuorumInfo.get(index);
        }
        return quorumInfo;
    }
}

