/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com;

import edu.emory.mathcs.backport.java.util.Collections;
import java.lang.ref.WeakReference;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.Format;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Comparator;
import java.util.List;
import java.util.WeakHashMap;
import sanproject.serverux.dataimpl.AuditUserInfo;
import sanproject.serverux.dataimpl.PPKget1PPInfo;
import sanproject.sn2.base.session.SJbaseUserSession;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.utility.SJcSessionUty;
import sanproject.sn2.com.utility.account.SJcRoleResourceContainer;
import sanproject.sn2.com.utility.guidance.inf.SJcGuidanceHandleInterface;
import sanproject.sn2.com.utility.message.inf.SJcMessageHandleInterface;
import sanproject.sn2.controller.com.SJctrAuthorizeContainer;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrGuidIdDefinition;
import sanproject.sn2.controller.com.SJctrGuidance;
import sanproject.sn2.controller.com.SJctrStringUtility;
import sanproject.sn2.controller.com.SJctrSystemParamContainer;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.controller.wizard.license.com.SJctr1PPInfo;
import sanproject.sn2.controller.wizard.license.com.SJctrLicenseKeyDataMacro;
import sanproject.sn2.controller.wizard.license.com.SJctrPPIDAscendingComparator;
import sanproject.sn2.datasupplier.SJdsSupplierAgent;
import sanproject.sn2.datasupplier.SJdsSupplierException;
import sanproject.sn2.datasupplier.SJdsSupplierMgr;
import sanproject.sn2.model.SJmoDataChange;
import sanproject.sn2.model.data.system.SJmoPPKget1PPInfo;

public class SJctrPPLicenseUtility
extends SJctrStringUtility
implements SJctrGuidIdDefinition {
    public static final String BLANC_DISPLAY = "";
    public static final String UNIT_TB = "TB";
    public static final int GB_TO_TB_DIVISION = 1024;
    public static final BigDecimal GB_TO_TB_BASE = new BigDecimal(1024);
    private static final Format TB_CHANGE_FORMAT = new DecimalFormat("0.00");
    private static final int CAPACITY_UNLIMITED = -1;
    public static final long VALUE_UNLIMITED = 0x80000000L;
    public static final long VALUE_BLANC = -2147483649L;
    public static final long VALUE_BAR = -2147483650L;
    public static final long VALUE_QUESTION = -2147483651L;
    private static WeakHashMap<String, WeakReference<String>> SIMPLE_NUMBER = new WeakHashMap(256);
    private static WeakHashMap<String, WeakReference<String>> CAPACITY = new WeakHashMap(256);
    private static WeakHashMap<String, WeakReference<String>> LICENSE_STATUS = new WeakHashMap();
    private static WeakHashMap<String, WeakReference<String>> LICENSE_KEYTYPE = new WeakHashMap();

    public SJctrPPLicenseUtility(SJmoDataChange dc, SJcGuidanceHandleInterface ghi, SJcMessageHandleInterface mhi) {
        super(dc, ghi, mhi);
    }

    public String toLicenseStatusDisplay(SJmoPPKget1PPInfo ppInfo, boolean bSetingFlg) {
        String ret = "?";
        if (ppInfo != null) {
            int status = ppInfo.getIStatus();
            ret = this.toLicenseStatusDisplay(status, bSetingFlg);
        }
        return ret;
    }

    public String toLicenseStatusDisplay(PPKget1PPInfo ppInfo, boolean bSetingFlg) {
        String ret = "?";
        if (ppInfo != null) {
            int status = ppInfo.getStatus();
            ret = this.toLicenseStatusDisplay(status, bSetingFlg);
        }
        return ret;
    }

    public String toLicenseStatusDisplay(int status, boolean bSetingFlg) {
        String str = "?";
        switch (status) {
            case 1: {
                if (bSetingFlg) {
                    str = this.guidanceHandle.getGuidance("LICENSE", "INSTALL");
                    break;
                }
                str = this.guidanceHandle.getGuidance("LICENSE", "INSTALLED");
                break;
            }
            case 2: {
                if (bSetingFlg) {
                    str = this.guidanceHandle.getGuidance("LICENSE", "NOT_INSTALL");
                    break;
                }
                str = this.guidanceHandle.getGuidance("LICENSE", "NOT_INSTALLED");
                break;
            }
            case 3: {
                str = this.guidanceHandle.getGuidance("LICENSE", "GRACE_PERIOD");
                break;
            }
            case 4: {
                str = this.guidanceHandle.getGuidance("LICENSE", "NOT_ENOUGH");
                break;
            }
            case 5: {
                str = this.guidanceHandle.getGuidance("LICENSE", "EXPIRED");
                break;
            }
            case 8: {
                if (bSetingFlg) {
                    str = this.guidanceHandle.getGuidance("LICENSE", "INSTALL_DISABLE");
                    break;
                }
                str = this.guidanceHandle.getGuidance("LICENSE", "INSTALLED_DISABLE");
                break;
            }
        }
        return this.getCache(str, LICENSE_STATUS);
    }

    public static int getLicenseStatusIconId(SJmoPPKget1PPInfo ppInfo) {
        int icon = 12294;
        if (ppInfo == null) {
            return icon;
        }
        int status = ppInfo.getIStatus();
        switch (status) {
            case 1: {
                icon = 16423;
                break;
            }
            case 2: {
                icon = 16422;
                break;
            }
            case 3: {
                icon = 16424;
                break;
            }
            case 4: 
            case 5: {
                icon = 16426;
                break;
            }
            case 8: {
                icon = 16425;
            }
        }
        return icon;
    }

    public String toLicenseKeyTypeDisplay(SJmoPPKget1PPInfo ppInfo) {
        String ret = "?";
        if (ppInfo != null) {
            int keyType = ppInfo.getIKeyKind();
            int status = ppInfo.getIStatus();
            ret = this.toLicenseKeyTypeDisplay(keyType, status);
        }
        return ret;
    }

    public String toLicenseKeyTypeDisplay(PPKget1PPInfo ppInfo) {
        String ret = "?";
        if (ppInfo != null) {
            int keyType = ppInfo.getKeyKind();
            int status = ppInfo.getStatus();
            ret = this.toLicenseKeyTypeDisplay(keyType, status);
        }
        return ret;
    }

    public String toLicenseKeyTypeDisplay(int keyType, int status) {
        String str = "?";
        if (status == 2) {
            str = keyType == 1 ? this.guidanceHandle.getGuidance("LICENSE", "LICENSE_TYPE_TEMPORARY") : BLANC_DISPLAY;
            return str;
        }
        switch (keyType) {
            case 1: {
                str = this.guidanceHandle.getGuidance("LICENSE", "LICENSE_TYPE_TEMPORARY");
                break;
            }
            case 2: {
                str = this.guidanceHandle.getGuidance("LICENSE", "LICENSE_TYPE_PERMANENT");
                break;
            }
            case 3: {
                str = this.guidanceHandle.getGuidance("LICENSE", "LICENSE_TYPE_EMERGENCY");
                break;
            }
            case 4: {
                str = this.guidanceHandle.getGuidance("LICENSE", "LICENSE_TYPE_ENTERPRISE");
                break;
            }
            case 7: {
                str = this.guidanceHandle.getGuidance("LICENSE", "LICENSE_TYPE_TERM");
                break;
            }
            case 8: {
                str = this.guidanceHandle.getGuidance("LICENSE", "LICENSE_TYPE_METER");
                break;
            }
        }
        return this.getCache(str, LICENSE_KEYTYPE);
    }

    public static String toPreamblePPDisplay(PPKget1PPInfo ppInfo) {
        if (ppInfo == null) {
            return "?";
        }
        ArrayList relPPNameList = ppInfo.getRelPpName();
        StringBuffer buf = new StringBuffer();
        for (String relPPName : relPPNameList) {
            if (buf.length() != 0) {
                buf.append(",");
            }
            buf.append(relPPName);
        }
        return buf.toString();
    }

    public String getPermitedCapacityDisplay(SJmoPPKget1PPInfo ppInfo) {
        String ret = "?";
        if (ppInfo != null) {
            int status = ppInfo.getIStatus();
            int permitCap = ppInfo.getIPermitVol();
            ret = this.getPermitedCapacityDisplay(status, permitCap);
        }
        return ret;
    }

    public String getPermitedCapacityDisplay(PPKget1PPInfo ppInfo) {
        String ret = "?";
        if (ppInfo != null) {
            int status = ppInfo.getStatus();
            int permitCap = ppInfo.getPermitVol();
            ret = this.getPermitedCapacityDisplay(status, permitCap);
        }
        return ret;
    }

    public String getPermitedCapacityDisplay(int status, int permitCap) {
        String str = "?";
        if (status == 2) {
            str = BLANC_DISPLAY;
        } else if (permitCap == 0) {
            str = BLANC_DISPLAY;
        } else if (permitCap == -1) {
            str = this.guidanceHandle.getGuidance("UNLIMITED");
        } else if (0 < permitCap) {
            str = SJctrComUtility.toDecString(permitCap);
        }
        return this.getCache(str, SIMPLE_NUMBER);
    }

    public String getUsedCapaciryDisplay(SJmoPPKget1PPInfo ppInfo) {
        String ret = "?";
        if (ppInfo != null) {
            int status = ppInfo.getIStatus();
            int accountType = ppInfo.getIAccountType();
            long usedCapa = ppInfo.getIUsedCapa();
            ret = this.getUsedCapaciryDisplay(status, accountType, usedCapa);
        }
        return ret;
    }

    public String getUsedCapaciryDisplay(PPKget1PPInfo ppInfo) {
        String ret = "?";
        if (ppInfo != null) {
            int status = ppInfo.getStatus();
            int accountType = ppInfo.getAccountType();
            long usedCapa = ppInfo.getUsedCapa();
            ret = this.getUsedCapaciryDisplay(status, accountType, usedCapa);
        }
        return ret;
    }

    public String getUsedCapaciryDisplay(int status, int accountType, long usedCapa) {
        String str = "?";
        str = status == 2 ? BLANC_DISPLAY : (accountType == 4 ? SJctrPPLicenseUtility.changeGBtoTBString(usedCapa) : "-");
        return this.getCache(str, CAPACITY);
    }

    public String getMeterRemainingDisplay(SJmoPPKget1PPInfo ppInfo) {
        String ret = "?";
        if (ppInfo != null) {
            int status = ppInfo.getIStatus();
            int keyType = ppInfo.getIKeyKind();
            long meterCapa = ppInfo.getLPermDiffCapa();
            ret = this.getMeterRemainingDisplay(status, keyType, meterCapa);
        }
        return ret;
    }

    public String getMeterRemainingDisplay(PPKget1PPInfo ppInfo) {
        String ret = "?";
        if (ppInfo != null) {
            int status = ppInfo.getStatus();
            int keyType = ppInfo.getKeyKind();
            long meterCapa = ppInfo.getLPermDiffCapa();
            ret = this.getMeterRemainingDisplay(status, keyType, meterCapa);
        }
        return ret;
    }

    public String getMeterRemainingDisplay(int status, int keyType, long meterCapa) {
        String str = "?";
        if (status == 2) {
            str = BLANC_DISPLAY;
        } else if (keyType == 8) {
            long meterCapa_TB = meterCapa / 1024L;
            str = SJctrComUtility.toDecString(meterCapa_TB);
        } else {
            str = "-";
        }
        return this.getCache(str, SIMPLE_NUMBER);
    }

    public String getTermDisplay(SJmoPPKget1PPInfo ppInfo) {
        String ret = "?";
        if (ppInfo != null) {
            int status = ppInfo.getIStatus();
            int keyType = ppInfo.getIKeyKind();
            int deterDays = ppInfo.getIDeterDays();
            int expireDays = ppInfo.getIExpireDays();
            long meterCapa = ppInfo.getLPermDiffCapa();
            ret = this.getTermDisplay(status, keyType, deterDays, expireDays, meterCapa);
        }
        return ret;
    }

    public String getTermDisplay(PPKget1PPInfo ppInfo) {
        String ret = "?";
        if (ppInfo != null) {
            int status = ppInfo.getStatus();
            int keyType = ppInfo.getKeyKind();
            int deterDays = ppInfo.getDeterDays();
            int expireDays = ppInfo.getExpireDays();
            long meterCapa = ppInfo.getLPermDiffCapa();
            ret = this.getTermDisplay(status, keyType, deterDays, expireDays, meterCapa);
        }
        return ret;
    }

    public String getTermDisplay(int status, int keyType, int deterDays, int expireDays, long meterCapa) {
        String str = "?";
        if (status == 2) {
            if (keyType == 1) {
                if (expireDays < 0) {
                    expireDays = 0;
                }
                str = SJctrComUtility.toDecString(expireDays);
            } else {
                str = BLANC_DISPLAY;
            }
        } else if (status == 5) {
            if (deterDays < 0) {
                deterDays = 0;
            }
            str = SJctrComUtility.toDecString(deterDays);
        } else if (status == 3) {
            if (expireDays < 0) {
                expireDays = 0;
            }
            str = SJctrComUtility.toDecString(expireDays);
        } else if (expireDays > 0) {
            str = SJctrComUtility.toDecString(expireDays);
        } else if (deterDays > 0) {
            str = SJctrComUtility.toDecString(deterDays);
        } else {
            int term = 0;
            switch (keyType) {
                case 2: 
                case 4: {
                    str = "-";
                    break;
                }
                case 1: 
                case 3: {
                    str = SJctrComUtility.toDecString(term);
                    break;
                }
                case 7: {
                    if (status == 1) {
                        str = SJctrComUtility.toDecString(term);
                        break;
                    }
                    str = BLANC_DISPLAY;
                    break;
                }
                case 8: {
                    if (meterCapa <= 0L) {
                        str = SJctrComUtility.toDecString(term);
                        break;
                    }
                    str = BLANC_DISPLAY;
                    break;
                }
                default: {
                    str = "?";
                }
            }
        }
        return this.getCache(str, SIMPLE_NUMBER);
    }

    public static long getPermitedCapacityValue(SJmoPPKget1PPInfo ppInfo) {
        long ret = -2147483651L;
        if (ppInfo != null) {
            int status = ppInfo.getIStatus();
            int permitCap = ppInfo.getIPermitVol();
            ret = SJctrPPLicenseUtility.getPermitedCapacityValue(status, permitCap);
        }
        return ret;
    }

    public static long getPermitedCapacityValue(PPKget1PPInfo ppInfo) {
        long ret = -2147483651L;
        if (ppInfo != null) {
            int status = ppInfo.getStatus();
            int permitCap = ppInfo.getPermitVol();
            ret = SJctrPPLicenseUtility.getPermitedCapacityValue(status, permitCap);
        }
        return ret;
    }

    public static long getPermitedCapacityValue(int status, int permitCap) {
        long ret = -2147483651L;
        ret = status == 2 ? -2147483649L : (permitCap == 0 ? -2147483649L : (permitCap == -1 ? 0x80000000L : (permitCap < -1 ? -2147483651L : (long)permitCap)));
        return ret;
    }

    public static long getUsedCapaciryValue(SJmoPPKget1PPInfo ppInfo) {
        long ret = -2147483651L;
        if (ppInfo != null) {
            int status = ppInfo.getIStatus();
            int accountType = ppInfo.getIAccountType();
            long usedCapa = ppInfo.getIUsedCapa();
            ret = SJctrPPLicenseUtility.getUsedCapaciryValue(status, accountType, usedCapa);
        }
        return ret;
    }

    public static long getUsedCapaciryValue(PPKget1PPInfo ppInfo) {
        long ret = -2147483651L;
        if (ppInfo != null) {
            int status = ppInfo.getStatus();
            int accountType = ppInfo.getAccountType();
            long usedCapa = ppInfo.getUsedCapa();
            ret = SJctrPPLicenseUtility.getUsedCapaciryValue(status, accountType, usedCapa);
        }
        return ret;
    }

    public static long getUsedCapaciryValue(int status, int accountType, long usedCapa) {
        long ret = -2147483651L;
        ret = status == 2 ? -2147483649L : (accountType == 4 ? SJctrPPLicenseUtility.getdispCapacityVolue(usedCapa) : -2147483650L);
        return ret;
    }

    public static long getMeterRemainingValue(SJmoPPKget1PPInfo ppInfo) {
        long ret = -2147483651L;
        if (ppInfo != null) {
            int status = ppInfo.getIStatus();
            int keyType = ppInfo.getIKeyKind();
            long meterCapa = ppInfo.getLPermDiffCapa();
            ret = SJctrPPLicenseUtility.getMeterRemainingValue(status, keyType, meterCapa);
        }
        return ret;
    }

    public static long getMeterRemainingValue(PPKget1PPInfo ppInfo) {
        long ret = -2147483651L;
        if (ppInfo != null) {
            int status = ppInfo.getStatus();
            int keyType = ppInfo.getKeyKind();
            long meterCapa = ppInfo.getLPermDiffCapa();
            ret = SJctrPPLicenseUtility.getMeterRemainingValue(status, keyType, meterCapa);
        }
        return ret;
    }

    public static long getMeterRemainingValue(int status, int keyType, long meterCapa) {
        long ret = -2147483651L;
        ret = status == 2 ? -2147483649L : (keyType == 8 ? meterCapa / 1024L : -2147483650L);
        return ret;
    }

    public static long getTermValue(SJmoPPKget1PPInfo ppInfo) {
        long ret = -2147483651L;
        if (ppInfo != null) {
            int status = ppInfo.getIStatus();
            int keyType = ppInfo.getIKeyKind();
            int deterDays = ppInfo.getIDeterDays();
            int expireDays = ppInfo.getIExpireDays();
            long meterCapa = ppInfo.getLPermDiffCapa();
            ret = SJctrPPLicenseUtility.getTermValue(status, keyType, deterDays, expireDays, meterCapa);
        }
        return ret;
    }

    public static long getTermValue(PPKget1PPInfo ppInfo) {
        long ret = -2147483651L;
        if (ppInfo != null) {
            int status = ppInfo.getStatus();
            int keyType = ppInfo.getKeyKind();
            int deterDays = ppInfo.getDeterDays();
            int expireDays = ppInfo.getExpireDays();
            long meterCapa = ppInfo.getLPermDiffCapa();
            ret = SJctrPPLicenseUtility.getTermValue(status, keyType, deterDays, expireDays, meterCapa);
        }
        return ret;
    }

    public static long getTermValue(int status, int keyType, int deterDays, int expireDays, long meterCapa) {
        long ret = -2147483651L;
        if (status == 2) {
            if (keyType == 1) {
                if (expireDays < 0) {
                    expireDays = 0;
                }
                ret = expireDays;
            } else {
                ret = -2147483649L;
            }
        } else if (status == 5) {
            if (deterDays < 0) {
                deterDays = 0;
            }
            ret = deterDays;
        } else if (status == 3) {
            if (expireDays < 0) {
                expireDays = 0;
            }
            ret = expireDays;
        } else if (expireDays > 0) {
            ret = expireDays;
        } else if (deterDays > 0) {
            ret = deterDays;
        } else {
            int term = 0;
            switch (keyType) {
                case 2: 
                case 4: {
                    ret = -2147483650L;
                    break;
                }
                case 1: 
                case 3: {
                    ret = term;
                    break;
                }
                case 7: {
                    if (status == 1) {
                        ret = term;
                        break;
                    }
                    ret = -2147483649L;
                    break;
                }
                case 8: {
                    if (meterCapa <= 0L) {
                        ret = term;
                        break;
                    }
                    ret = -2147483649L;
                    break;
                }
                default: {
                    ret = -2147483651L;
                }
            }
        }
        return ret;
    }

    public static String changeGBtoTBString(long gbCapa) {
        return SJctrPPLicenseUtility.changeGBtoTBString(gbCapa, false);
    }

    public static String changeGBtoTBString(long gbCapa, boolean addUnit) {
        StringBuffer strBuf = new StringBuffer();
        BigDecimal gb_capa = new BigDecimal(gbCapa);
        BigDecimal tb_capa = gb_capa.divide(GB_TO_TB_BASE, 2, RoundingMode.UP);
        strBuf.append(TB_CHANGE_FORMAT.format(tb_capa));
        if (addUnit) {
            strBuf.append(" TB");
        }
        return strBuf.toString();
    }

    public static long getdispCapacityVolue(long gbCapa) {
        BigDecimal gb_capa = new BigDecimal(gbCapa);
        BigDecimal tb_capa = gb_capa.divide(GB_TO_TB_BASE, 2, RoundingMode.UP);
        BigDecimal baseDecimal = new BigDecimal(100);
        BigDecimal decimal = tb_capa.multiply(baseDecimal);
        BigDecimal max = new BigDecimal(Long.MAX_VALUE);
        BigDecimal value = max.min(decimal);
        long retValue = value.longValue();
        return retValue;
    }

    public static SJctr1PPInfo chgCtrPPInfo(SJmoPPKget1PPInfo ppInfo) {
        SJctr1PPInfo rmiPPInfo = null;
        if (ppInfo != null) {
            rmiPPInfo = new SJctr1PPInfo();
            rmiPPInfo.setPPKget1PPInfo(ppInfo.getStrPPName(), ppInfo.getStrPPID(), ppInfo.getStrLicenseType(), BLANC_DISPLAY, 0, ppInfo.getIStatus(), ppInfo.getIKeyKind(), ppInfo.getIAccountType(), ppInfo.getIPermitVol(), ppInfo.getIUsedCapa(), ppInfo.getIExpireDays(), ppInfo.getIDeterDays(), ppInfo.getIPreInstall(), ppInfo.getLSN(), ppInfo.getIBaseCapa(), ppInfo.getIIncCapa(), ppInfo.getIRelPpCnt(), ppInfo.getAlRelPpName(), ppInfo.getIUpdate(), ppInfo.getIErrCode(), ppInfo.getLInstTime(), ppInfo.getLCustomerID(), ppInfo.getLSeqNum(), ppInfo.getLTermDays(), ppInfo.getLPermDiffCapa(), ppInfo.getIBackKeyKind(), new ArrayList(), new ArrayList());
        }
        return rmiPPInfo;
    }

    public static PPKget1PPInfo[] clonePPKget1PPInfoArray(PPKget1PPInfo[] ppInfoArray) {
        PPKget1PPInfo[] retArray = new PPKget1PPInfo[ppInfoArray.length];
        for (int index = 0; index < ppInfoArray.length; ++index) {
            PPKget1PPInfo clonePPInfo;
            PPKget1PPInfo ppInfo = ppInfoArray[index];
            retArray[index] = clonePPInfo = SJctrPPLicenseUtility.clonePPKget1PPInfo(ppInfo);
        }
        return retArray;
    }

    public static PPKget1PPInfo clonePPKget1PPInfo(PPKget1PPInfo ppInfo) {
        PPKget1PPInfo clonePPInfo = new PPKget1PPInfo();
        clonePPInfo.setPPKget1PPInfo(ppInfo.getPPName(), ppInfo.getPPID(), ppInfo.getLicenseType(), ppInfo.getReserve(), ppInfo.getInstall(), ppInfo.getStatus(), ppInfo.getKeyKind(), ppInfo.getAccountType(), ppInfo.getPermitVol(), ppInfo.getUsedCapa(), ppInfo.getExpireDays(), ppInfo.getDeterDays(), ppInfo.getPreInstall(), ppInfo.getSN(), ppInfo.getBaseCapa(), ppInfo.getIncCapa(), ppInfo.getRelPpCnt(), ppInfo.getRelPpName(), ppInfo.getUpdate(), ppInfo.getErrCode(), ppInfo.getLInstTime(), ppInfo.getLCustomerID(), ppInfo.getLSeqNum(), ppInfo.getLTermDays(), ppInfo.getLPermDiffCapa(), ppInfo.getIBackKeyKind(), ppInfo.getlicenseCounter(), ppInfo.getportableLicenseList());
        return clonePPInfo;
    }

    public static PPKget1PPInfo[] updatePPInfo(PPKget1PPInfo[] orgPPInfoArray, List<SJctr1PPInfo> updataList) {
        PPKget1PPInfo[] retArray = new PPKget1PPInfo[orgPPInfoArray.length];
        SJctrPPIDAscendingComparator comp = new SJctrPPIDAscendingComparator();
        Collections.sort(updataList, (Comparator)comp);
        for (int index = 0; index < orgPPInfoArray.length; ++index) {
            PPKget1PPInfo setData;
            PPKget1PPInfo orgPPInfo = orgPPInfoArray[index];
            int search = Collections.binarySearch(updataList, (Object)orgPPInfo);
            if (search < 0) {
                retArray[index] = orgPPInfo;
                continue;
            }
            SJctr1PPInfo updateInfo = updataList.get(search);
            retArray[index] = setData = updateInfo.getRmiData();
        }
        return retArray;
    }

    public static String getGuidanceKeyString(String screenId, String partsId) {
        SJctrGuidance guid = new SJctrGuidance(screenId, partsId);
        return guid.getGuidanceId();
    }

    public static boolean checkQueueingLicenseTask(SJctrUserController uc) {
        boolean ret = false;
        List<SJctrGuidance> queueingList = uc.getQueueBox().getQueueingTaskActNameList();
        for (SJctrGuidance actName : queueingList) {
            if (!SJctrLicenseKeyDataMacro.LICENSE_GUID_SET.contains(actName.getGuidanceId())) continue;
            ret = true;
            break;
        }
        return ret;
    }

    public static void setAuditUserInfo(SJctrUserController uc) {
        SJbaseUserSession us = (SJbaseUserSession)uc.getUserSession();
        AuditUserInfo userInfo = new AuditUserInfo();
        userInfo.setStrTaskName(BLANC_DISPLAY);
        userInfo.setStrGlblSessionID(us.getSessionID());
        userInfo.setStrUserName(us.getUserName());
        userInfo.setStrIPaddress(SJcSessionUty.getIPAddress(us));
        userInfo.setIConnectionID(us.getSessionIdentificationID());
        int interfaceId = 0;
        SJctrAuthorizeContainer ac = uc.getAuthorizeContainer();
        SJctrSystemParamContainer spc = ac.getSystemParamContainer();
        if (spc.isLocalHost()) {
            interfaceId = 1;
        }
        SJcRoleResourceContainer roleResource = us.getRoleResourceInfo();
        boolean[] rsgMap = roleResource.getResourceGroup();
        BitSet rsgBitSet = new BitSet(rsgMap.length);
        for (int index = 0; index < rsgMap.length; ++index) {
            if (!rsgMap[index]) continue;
            rsgBitSet.set(index);
        }
        SJdsSupplierAgent supplier = SJdsSupplierMgr.getSupplierMgr().getAgent();
        try {
            supplier.lock(userInfo, interfaceId, rsgBitSet);
        }
        catch (SJdsSupplierException chkSplExp) {
            SJctrError error = new SJctrError(4, 22, 205052);
            SJcException exp = error.createException();
            throw exp;
        }
    }

    public static void modifyUnLock() {
        SJdsSupplierAgent supplier = SJdsSupplierMgr.getSupplierMgr().getAgent();
        supplier.unlock();
    }
}

