/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com.column;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sanproject.sn2.controller.com.SJctrCapacityUtility;
import sanproject.sn2.controller.com.SJctrLdevUtility;
import sanproject.sn2.controller.com.column.SJctrCapacityColumn;
import sanproject.sn2.controller.wizard.lunm.com.SJctrLdevDetailLUSEInfo;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.kind.SJmoGetLdevDetail;
import sanproject.sn2.model.connector.kind.SJmoGetLdevLuseInfo;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;
import sanproject.sn2.model.data.volume.SJmoLdevLuseInfo;

public class SJctrCapacityColumnFromLdevDetail
extends SJctrCapacityColumn {
    protected Map<Object, SJctrLdevDetailLUSEInfo> luseDataMap = Collections.emptyMap();

    public SJctrCapacityColumnFromLdevDetail(String key) {
        super(key);
    }

    @Override
    public List<?> getNeedModelData(Object index, Map<Class<?>, List<?>> modelData) {
        SJctrLdevDetailLUSEInfo ldevDtlLuse = null;
        List<SJmoLdevDetail> ldevDetailList = modelData.get(SJmoGetLdevDetail.class);
        List<SJmoLdevLuseInfo> ldevLuseList = modelData.get(SJmoGetLdevLuseInfo.class);
        ldevDtlLuse = SJctrLdevUtility.getLdevDetailLUListSEInfo((SJmoLdevDetail)index, ldevDetailList, ldevLuseList);
        long ldevSize = ((SJmoLdevDetail)index).getLLDEVLBASize();
        if (ldevSize != ldevDtlLuse.getLTotalLBASize()) {
            if (this.luseDataMap.size() == 0) {
                int initialCapacity = ldevLuseList.size() * 4 / 3 + 1;
                this.luseDataMap = new HashMap<Object, SJctrLdevDetailLUSEInfo>(initialCapacity);
            }
            this.luseDataMap.put(index, ldevDtlLuse);
        }
        ArrayList<SJctrLdevDetailLUSEInfo> list = new ArrayList<SJctrLdevDetailLUSEInfo>();
        list.add(ldevDtlLuse);
        return list;
    }

    @Override
    public List<Class<? extends SJmoGetKind_IF>> getNeedModelKind() {
        ArrayList<Class<? extends SJmoGetKind_IF>> list = new ArrayList<Class<? extends SJmoGetKind_IF>>();
        list.add(SJmoGetLdevDetail.class);
        list.add(SJmoGetLdevLuseInfo.class);
        return list;
    }

    @Override
    public String toDispString(List<?> dataList) {
        String select = this.getUnitSelect();
        SJctrCapacityUtility.UNIT unit = select.length() == 0 ? (this.hasOpenVolume ? SJctrCapacityUtility.UNIT.GB : SJctrCapacityUtility.UNIT.CYL) : SJctrCapacityUtility.UNIT.valueOf(select);
        SJctrLdevDetailLUSEInfo ldevDetail = (SJctrLdevDetailLUSEInfo)dataList.get(0);
        SJctrCapacityUtility util = this.getTable().getComUtility().getCapacityUtility();
        StringBuilder buf = new StringBuilder(util.toString(ldevDetail.getLTotalLBASize(), unit, ldevDetail.getIEmulationType()));
        buf.append(" ");
        buf.append(util.getUnitString(unit));
        return buf.toString();
    }

    @Override
    protected long getNumber(Map<String, Object> dat) {
        SJmoLdevDetail ldevDetail = (SJmoLdevDetail)this.getPrimaryKeyObject(dat);
        long capacity = ldevDetail.getLLDEVLBASize();
        SJctrLdevDetailLUSEInfo luseData = this.luseDataMap.get(ldevDetail);
        if (luseData != null) {
            capacity = luseData.getLTotalLBASize();
        }
        return capacity;
    }

    @Override
    public boolean hasMainframeVolume(Map<Class<?>, List<?>> basicData) {
        List<?> list = basicData.get(SJmoGetLdevDetail.class);
        for (SJmoLdevDetail ldevDetail : list) {
            this.hasMainframeVolume |= SJctrLdevUtility.isMFVolume(ldevDetail);
            if (!this.hasMainframeVolume) continue;
            break;
        }
        return this.hasMainframeVolume;
    }

    @Override
    public boolean hasOpenVolume(Map<Class<?>, List<?>> basicData) {
        List<?> list = basicData.get(SJmoGetLdevDetail.class);
        for (SJmoLdevDetail ldevDetail : list) {
            this.hasOpenVolume |= SJctrLdevUtility.isOpenVolume(ldevDetail);
            if (!this.hasOpenVolume) continue;
            break;
        }
        return this.hasOpenVolume;
    }

    @Override
    protected long getCylinderNumber(Map<String, Object> dat) {
        int emuType = this.getEmulationType(dat);
        long block = this.getNumber(dat);
        SJctrCapacityUtility capaUtil = this.getTable().getComUtility().getCapacityUtility();
        long cylinder = capaUtil.toCylValue(block, emuType);
        return cylinder;
    }

    protected int getEmulationType(Map<String, Object> dat) {
        SJmoLdevDetail ldevDetail = (SJmoLdevDetail)this.getPrimaryKeyObject(dat);
        int emuType = ldevDetail.getIEmulationType();
        return emuType;
    }
}

