/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com.column;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrResourceGroupUtility;
import sanproject.sn2.controller.com.SJctrRsgUtility;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.controller.com.column.SJctrColumn;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.kind.SJmoGetHUVMVirtualDkc;
import sanproject.sn2.model.connector.kind.SJmoGetRSGgetAllRsgs;
import sanproject.sn2.model.data.device.SJmoPortIndex;
import sanproject.sn2.model.data.huvm.SJmoHUVMVirtualDkc;
import sanproject.sn2.model.data.huvm.SJmoHUVMvboxIndex;
import sanproject.sn2.model.data.rsg.SJmoRSGgetAllRsgs;
import sanproject.sn2.model.data.rsg.SJmoRSGgetRsg;

public class SJctrVirtualStorageSystemColumnFromPortIndex
extends SJctrColumn {
    public static final String GUID_MDL_SN = "MODEL_SN";

    public SJctrVirtualStorageSystemColumnFromPortIndex(String key) {
        super(key);
        this.setPartsId(GUID_MDL_SN);
    }

    @Override
    public List<Class<? extends SJmoGetKind_IF>> getNeedModelKind() {
        ArrayList<Class<? extends SJmoGetKind_IF>> list = new ArrayList<Class<? extends SJmoGetKind_IF>>();
        list.add(SJmoGetRSGgetAllRsgs.class);
        list.add(SJmoGetHUVMVirtualDkc.class);
        return list;
    }

    @Override
    public List<?> getNeedModelData(Object index, Map<Class<?>, List<?>> basicData) {
        ArrayList ret = new ArrayList();
        SJmoPortIndex portIndex = (SJmoPortIndex)index;
        List<?> allRsgsList = basicData.get(SJmoGetRSGgetAllRsgs.class);
        if (allRsgsList == null || allRsgsList.size() <= 0) {
            return ret;
        }
        SJctrDataController dc = this.getTable().getDataController();
        SJctrUserController uc = dc.getOwner();
        SJctrResourceGroupUtility rsgUtil = new SJctrResourceGroupUtility(uc, (SJmoRSGgetAllRsgs)allRsgsList.get(0));
        SJmoRSGgetRsg rsg = rsgUtil.getRsgFromPort(portIndex);
        if (rsg == null) {
            return ret;
        }
        SJmoHUVMvboxIndex targetIndex = rsg.getRsgInfo().getVboxIndex();
        List<?> VboxList = basicData.get(SJmoGetHUVMVirtualDkc.class);
        if (targetIndex == null || VboxList == null || VboxList.size() <= 0) {
            return ret;
        }
        int vBoxIndex = Collections.binarySearch(VboxList, targetIndex);
        if (vBoxIndex >= 0) {
            ret.add(VboxList.get(vBoxIndex));
        }
        return ret;
    }

    @Override
    public String toDispString(List<?> dataList) {
        SJctrRsgUtility rsgUtil = this.getTable().getComUtility().getRsgUtility();
        SJmoHUVMVirtualDkc vDkc = null;
        if (dataList != null && dataList.size() > 0) {
            vDkc = (SJmoHUVMVirtualDkc)dataList.get(0);
        }
        return rsgUtil.toDispStringVssModelSerialNo(vDkc);
    }
}

