/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com.column.iscsi;

import java.util.ArrayList;
import java.util.List;
import sanproject.sn2.controller.com.SJctrIscsiUtility;
import sanproject.sn2.controller.com.SJctrPortUtility;
import sanproject.sn2.controller.com.column.SJctrColumn;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.kind.SJmoGetPortDetail;
import sanproject.sn2.model.data.device.SJmoPortDetail;

public class SJctrISNSTCPIPAddrColumnFromPortDetail
extends SJctrColumn {
    public SJctrISNSTCPIPAddrColumnFromPortDetail(String key) {
        super(key);
        this.setPartsId("IP_ADDR");
    }

    @Override
    public List<Class<? extends SJmoGetKind_IF>> getNeedModelKind() {
        ArrayList<Class<? extends SJmoGetKind_IF>> list = new ArrayList<Class<? extends SJmoGetKind_IF>>();
        list.add(SJmoGetPortDetail.class);
        return list;
    }

    @Override
    public String toDispString(List<?> dataList) {
        SJmoPortDetail portDtl = (SJmoPortDetail)dataList.get(0);
        if (!SJctrPortUtility.isIscsiPort(portDtl)) {
            return SJctrPortUtility.STR_HYPHEN;
        }
        if (!portDtl.getBIsnsServerMode()) {
            return SJctrPortUtility.STR_HYPHEN;
        }
        if (portDtl.getIIsnsIpType() == SJctrPortUtility.KEY_ISNS_TYPE_V6) {
            return SJctrIscsiUtility.getIpv6AddrString(portDtl.getIIsnsV6Address());
        }
        if (portDtl.getIIsnsIpType() == SJctrPortUtility.KEY_ISNS_TYPE_V4) {
            return SJctrPortUtility.toDispIPv4(portDtl.getIIsnsV4Address());
        }
        return "?";
    }
}

