/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com.column.replication.com;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrRemoteReplicationUtility;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.controller.com.column.SJctrColumn;
import sanproject.sn2.controller.wizard.replication.com.SJctrGetLDEVLUPathInfo;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.data.lu.SJmoPortLunDetail;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;

public abstract class SJctrLunIdColumnFromLdevIndex
extends SJctrColumn {
    private Map<Integer, List<SJmoPortLunDetail>> ldevLUPathInfoMap = null;
    private boolean bDecDisplay = false;

    public SJctrLunIdColumnFromLdevIndex(String key) {
        super(key);
    }

    protected abstract SJmoLdevIndex getTargetLdevIndex(Object var1);

    @Override
    public void initGuidance(SJctrComUtility util) {
        super.initGuidance(util);
        this.setLabel(util.getGuidance("LUN_ID"));
        SJctrUserController uc = this.getTable().getDataController().getOwner();
        this.bDecDisplay = SJctrRemoteReplicationUtility.isLunDec(uc.getUserSession());
    }

    @Override
    public List<Class<? extends SJmoGetKind_IF>> getNeedModelKind() {
        ArrayList<Class<? extends SJmoGetKind_IF>> list = new ArrayList<Class<? extends SJmoGetKind_IF>>();
        return list;
    }

    @Override
    public List<?> getNeedModelData(Object index, Map<Class<?>, List<?>> modelData) {
        SJmoLdevIndex volIndex;
        SJmoPortLunDetail portLunDtl;
        ArrayList<SJmoPortLunDetail> retList = new ArrayList<SJmoPortLunDetail>();
        if (this.ldevLUPathInfoMap == null) {
            this.ldevLUPathInfoMap = (Map)modelData.get(SJctrGetLDEVLUPathInfo.class).get(0);
        }
        if ((portLunDtl = SJctrRemoteReplicationUtility.getDisplayLunDetailInfo(volIndex = this.getTargetLdevIndex(index), this.ldevLUPathInfoMap)) != null) {
            retList.add(portLunDtl);
        }
        return retList;
    }

    @Override
    public int getSortType() {
        return 1;
    }

    @Override
    public int getFilterType() {
        return 0;
    }

    @Override
    public String getInputFormat() {
        String format = "^([0-9A-Fa-f]{1,4})$";
        if (this.bDecDisplay) {
            format = "^\\d{1,19}$";
        }
        return format;
    }

    @Override
    public long getNumber(Map<String, Object> dat) {
        long number = -1L;
        SJmoLdevIndex volIndex = this.getTargetLdevIndex(this.getPrimaryKeyObject(dat));
        SJmoPortLunDetail portLunDtl = SJctrRemoteReplicationUtility.getDisplayLunDetailInfo(volIndex, this.ldevLUPathInfoMap);
        if (portLunDtl != null) {
            number = portLunDtl.getSLUN();
        }
        return number;
    }

    @Override
    public String toDispString(List<?> dataList) {
        String ret = "-";
        if (!dataList.isEmpty()) {
            SJmoPortLunDetail portLunDtl = (SJmoPortLunDetail)dataList.get(0);
            ret = portLunDtl != null ? (this.bDecDisplay ? String.valueOf(portLunDtl.getSLUN()) : SJctrComUtility.toHexString(portLunDtl.getSLUN(), 4, true)) : "?";
        }
        return ret;
    }
}

