/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com.column.uvm;

import edu.emory.mathcs.backport.java.util.Collections;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sanproject.sn2.controller.com.SJctrLdevUtility;
import sanproject.sn2.controller.com.column.SJctrColumn;
import sanproject.sn2.controller.com.comparator.SJctrLdevIndexComparator;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.kind.SJmoGetExDVirtualPgInfo;
import sanproject.sn2.model.connector.kind.SJmoGetExdVolumeInfoMgr;
import sanproject.sn2.model.data.exdevice.SJmoExDPgInfo;
import sanproject.sn2.model.data.exdevice.SJmoExDVirtualPgInfo;
import sanproject.sn2.model.data.exdevice.SJmoExdVolumeInfo;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;
import sanproject.sn2.model.data.volume.SJmoPgIndex;

public class SJctrTopLdevIDColumnFromExdVolumeInfo
extends SJctrColumn {
    protected HashMap<Object, SJmoLdevIndex> ldevIndexMap = null;

    public SJctrTopLdevIDColumnFromExdVolumeInfo(String key) {
        super(key);
        this.setPartsId("TOP_LDEV_ID");
    }

    @Override
    public List<Class<? extends SJmoGetKind_IF>> getNeedModelKind() {
        ArrayList<Class<? extends SJmoGetKind_IF>> list = new ArrayList<Class<? extends SJmoGetKind_IF>>();
        list.add(SJmoGetExdVolumeInfoMgr.class);
        list.add(SJmoGetExDVirtualPgInfo.class);
        return list;
    }

    @Override
    public List<?> getNeedModelData(Object index, Map<Class<?>, List<?>> modelData) {
        SJmoExDPgInfo exdPGInfo;
        ArrayList<SJmoLdevIndex> list = new ArrayList<SJmoLdevIndex>();
        SJmoExdVolumeInfo volumeInfo = (SJmoExdVolumeInfo)index;
        SJmoExDVirtualPgInfo vpginfo = (SJmoExDVirtualPgInfo)modelData.get(SJmoGetExDVirtualPgInfo.class).get(0);
        ArrayList exdVpgList = vpginfo.getAlVpgForExd();
        SJmoPgIndex pgIndex = new SJmoPgIndex();
        pgIndex.setFB4(volumeInfo.getRmiExdVolumeInfo().getIFB4());
        pgIndex.setPG(volumeInfo.getRmiExdVolumeInfo().getIPG());
        SJmoLdevIndex ldev = null;
        int searchId = Collections.binarySearch((List)exdVpgList, (Object)pgIndex);
        if (searchId >= 0 && (exdPGInfo = (SJmoExDPgInfo)exdVpgList.get(searchId)).getSNumOfLdev() != 0) {
            ldev = exdPGInfo.getStartLdevId();
            if (this.ldevIndexMap == null) {
                this.ldevIndexMap = new HashMap(this.getTable().getRowCount());
            }
            this.ldevIndexMap.put(index, ldev);
        }
        list.add(ldev);
        return list;
    }

    @Override
    public String toDispString(List<?> dataList) {
        String ret = "";
        SJmoLdevIndex ldev = (SJmoLdevIndex)dataList.get(0);
        if (ldev != null) {
            SJctrLdevUtility util = this.getTable().getComUtility().getLdevUtility();
            ret = util.toLdevDisplay(ldev);
        }
        return ret;
    }

    @Override
    protected Comparator<Object> createObjectComparator() {
        return new SJctrLdevIndexComparator(){

            @Override
            public int compare(Object o1, Object o2) {
                boolean result = false;
                SJmoLdevIndex ldev1 = this.getCompareValue(o1);
                SJmoLdevIndex ldev2 = this.getCompareValue(o2);
                return super.compare(ldev1, ldev2);
            }

            private SJmoLdevIndex getCompareValue(Object obj) {
                SJmoLdevIndex ldev;
                if (!(obj instanceof SJmoLdevIndex)) {
                    ldev = SJctrTopLdevIDColumnFromExdVolumeInfo.this.ldevIndexMap.get(obj);
                    if (ldev == null) {
                        ldev = new SJmoLdevIndex();
                    }
                } else {
                    ldev = (SJmoLdevIndex)obj;
                }
                return ldev;
            }
        };
    }

    @Override
    public int getFilterType() {
        return 16;
    }

    @Override
    public String getInputFormat() {
        return "^(00):([0-9A-Fa-f]{2}):([0-9A-Fa-f]{2})$";
    }
}

