/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import sanproject.sn2.base.session.inf.SJbaseUserSessionInterface;
import sanproject.sn2.controller.SJctrControllerManager;
import sanproject.sn2.controller.com.SJctrAuthorizeContainer;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrDirectLauncher;
import sanproject.sn2.controller.com.SJctrEnvironmentalUtility;
import sanproject.sn2.controller.com.SJctrLicenseContainer;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.controller.com.data.SJctrNestedListDataObject;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.event.SJctrEventListener;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.com.model.event.SJctrObjectSetListener;
import sanproject.sn2.controller.com.model.node.SJctrNodeData;

public abstract class SJctrNestedListDataModel
extends SJctrDataObjectModel<SJctrNestedListDataObject> {
    public static final String KEY_LABEL = "label";
    public static final String KEY_NAME = "name";
    public static final String KEY_LINK = "link";
    public static final String KEY_ENABLE = "enabled";
    public static final String KEY_SELECTED = "COM_SELECTED";
    public static final String KEY_EXPANDED = "COM_EXPANDED";
    public static final String KEY_CHILDREN = "children";
    public static final String KEY_ICON = "COM_ICON";
    public static final String CTRL_OBJECT = "CTRL_OBJECT";
    public static final String CTRL_SEL_LISTENER = "CTRL_SEL_LISTENER";
    public static final String DELIMITER = "\t";
    protected static final int DEFAULT_LIST_DATA_SIZE = 10;
    private static final int DEFAULT_SEL_ROW_SIZE = 1;
    private final Map<String, HashMap<String, Object>> itemMap;
    private boolean multiSelect;
    private Set<String> selectSet;
    private Map<String, SJctrNodeData> logicalPathToNodeDataMap;
    private Map<String, SJctrNodeData> nodePathToNodeDataMap;
    public static final String HIDE_HM = "HIDE_HM";
    public static final String HIDE_RAID = "HIDE_RAID";
    public static final String NEED_LICENSE_SN = "NEED_LICENSE_SN";
    public static final String SECONDARY_WINDOW = "SECONDARY_WINDOW";
    public static final String HIDE_NOR_BASIC = "HIDE_NOR_BASIC";
    public static final String HIDE_HIC = "HIDE_HIC";
    public static final String HIDE_NOR_BASIC_SECONDARY_WINDOW = "HIDE_NOR_BASIC_SECONDARY_WINDOW";
    public static final String HIDE_OTHER_FUNC_MENU_MODE = "HIDE_OTHER_FUNC_MENU_MODE";

    public static boolean isEnable(SJctrNestedListDataObject nestList) {
        Integer enable = nestList.visible();
        return enable.equals(SJctrNestedListDataObject.VISIBLE_ACTIVE);
    }

    public static boolean isVisible(SJctrNestedListDataObject nestList) {
        Integer visible = nestList.visible();
        return !visible.equals(SJctrNestedListDataObject.VISIBLE_INVISIBLE);
    }

    public static boolean setEnable(SJctrNestedListDataObject nestList, boolean flg) {
        Integer enable = flg ? SJctrNestedListDataObject.VISIBLE_ACTIVE : SJctrNestedListDataObject.VISIBLE_INACTIVE;
        boolean result = !nestList.visible().equals(enable);
        nestList.visible(enable);
        return result;
    }

    public static boolean setVisible(SJctrNestedListDataObject nestList, boolean flg) {
        Integer visible = flg ? SJctrNestedListDataObject.VISIBLE_ACTIVE : SJctrNestedListDataObject.VISIBLE_INVISIBLE;
        boolean result = !nestList.visible().equals(visible);
        nestList.visible(visible);
        return result;
    }

    public static boolean setState(SJctrNestedListDataObject nestList, Integer state) {
        boolean result = !nestList.visible().equals(state);
        nestList.visible(state);
        return result;
    }

    public SJctrNestedListDataModel() {
        this(10);
    }

    public SJctrNestedListDataModel(int size) {
        SJctrNestedListDataObject manageData = (SJctrNestedListDataObject)this.getManageData();
        manageData.setRow(new ArrayList<HashMap<String, Object>>(1));
        manageData.listData(new ArrayList<HashMap<String, Object>>(size));
        this.itemMap = new HashMap<String, HashMap<String, Object>>((size * 4 + 2) / 3);
        this.multiSelect = false;
        this.selectSet = new HashSet<String>(1);
        this.logicalPathToNodeDataMap = new LinkedHashMap<String, SJctrNodeData>();
        this.nodePathToNodeDataMap = new LinkedHashMap<String, SJctrNodeData>(size);
        this.initListener();
    }

    @Override
    public void initGuidance(SJctrComUtility util) {
        super.initGuidance(util);
        this.initLogicalNode();
    }

    protected void initLogicalNode() {
    }

    public Map<String, SJctrNodeData> getLogicalPathToNodeDataMap() {
        return this.logicalPathToNodeDataMap;
    }

    public List<SJctrNodeData> getNodeDataChilde(SJctrNodeData nodeData) {
        ArrayList<SJctrNodeData> childeList = new ArrayList<SJctrNodeData>();
        for (SJctrNodeData value : this.getLogicalPathToNodeDataMap().values()) {
            if (value.getParentNode() != nodeData) continue;
            childeList.add(value);
        }
        return childeList;
    }

    public void addNodeData(SJctrNodeData nodeData) {
        String logicalPath = nodeData.getLogicalPath();
        this.getLogicalPathToNodeDataMap().put(logicalPath, nodeData);
        nodeData.setDataModel(this);
        SJctrNodeData parentNodeData = null;
        int lastIndex = logicalPath.lastIndexOf(DELIMITER);
        if (lastIndex >= 0) {
            String parentPath = logicalPath.substring(0, lastIndex);
            parentNodeData = this.getLogicalPathToNodeDataMap().get(parentPath);
        }
        nodeData.setParentNode(parentNodeData);
    }

    public Map<String, SJctrNodeData> getNodePathToNodeDataMap() {
        return this.nodePathToNodeDataMap;
    }

    private void initListener() {
        this.addObjectSetListener(new SJctrObjectSetListener(){

            @Override
            public void doAction(Object setObject) {
                if (setObject instanceof SJctrNestedListDataObject) {
                    SJctrNestedListDataModel.this.setVisibleAction((SJctrNestedListDataObject)setObject);
                }
            }
        });
        this.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                SJctrNestedListDataModel.this.selectChangedNodeData(event);
            }
        });
    }

    protected void selectChangedNodeData(SJctrItemSelectEvent<?> event) {
        String key = (String)event.getChangeObject();
        SJctrNodeData nodeData = this.getNodePathToNodeDataMap().get(key);
        if (nodeData == null) {
            return;
        }
        SJctrItemSelectListener selectListener = nodeData.getSelectListener();
        if (selectListener == null) {
            return;
        }
        selectListener.selectChanged(event);
    }

    private void setVisibleAction(SJctrNestedListDataObject setObject) {
        if (!setObject.getDataMap().containsKey("COM_VISIBLE")) {
            return;
        }
        if (SJctrNestedListDataModel.setState((SJctrNestedListDataObject)this.getManageData(), setObject.visible())) {
            this.fireItemStateChanged();
        }
    }

    public void addItem(String name) {
        String label = name.substring(name.lastIndexOf(DELIMITER) + 1);
        this.addItem(name, label);
    }

    public void addItem(String name, String label) {
        HashMap<String, Object> item = this.createItem(name, label);
        this.addItem(item);
    }

    public boolean addItem(HashMap<String, Object> item) {
        if (item == null) {
            return false;
        }
        String name = Item.getName(item);
        if (this.getItem(name) != null) {
            return false;
        }
        this.itemMap.put(name, item);
        ArrayList<HashMap<String, Object>> itemList = this.getItemList(name);
        itemList.add(item);
        return true;
    }

    public boolean addItem(HashMap<String, Object> item, SJctrNodeData nodeData, Object ... args) {
        if (!this.addItem(item)) {
            return false;
        }
        String name = Item.getName(item);
        this.getNodePathToNodeDataMap().put(name, nodeData);
        nodeData.getNodePathToArgsMap().put(name, args);
        return true;
    }

    public boolean addItem(SJctrNodeData nodeData, Object ... args) {
        HashMap<String, Object> item = this.createItem(nodeData, args);
        return this.addItem(item, nodeData, args);
    }

    public void addItemSelectListener(SJctrItemSelectListener listener) {
        this.addEventListener(listener);
    }

    public boolean addSelection(List<String> nameList) {
        boolean result = false;
        if (this.multiSelect) {
            result = true;
            for (String name : nameList) {
                if (this.selectSet.contains(name)) continue;
                result &= this.setSelectionName(name);
            }
        }
        return result;
    }

    public boolean addSelection(String name) {
        boolean result = false;
        if (this.multiSelect) {
            if (!this.selectSet.contains(name)) {
                result = this.setSelectionName(name);
            }
        } else {
            result = this.setSelection(name);
        }
        return result;
    }

    public boolean addSelectionToRoot(List<String> nameList) {
        boolean result = false;
        if (this.multiSelect) {
            result = true;
            for (String name : nameList) {
                if (this.selectSet.contains(name)) continue;
                result &= this.setSelectionToRootName(name);
            }
        }
        return result;
    }

    public void clearSelection() {
        for (String name : this.selectSet) {
            this.clearSelection(name);
        }
    }

    public void clearSelection(String name) {
        this.logUty.putlog("clearSelection", "Select clear : " + name);
        this.selectSet.remove(name);
        boolean result = Item.setSelect((Map<String, Object>)this.itemMap.get(name), false);
        if (result) {
            this.fireItemSelected(name);
        }
    }

    public String getSelection() {
        String retString;
        block0: {
            String name;
            retString = null;
            Iterator<String> i$ = this.selectSet.iterator();
            if (!i$.hasNext()) break block0;
            retString = name = i$.next();
        }
        return retString;
    }

    public List<String> getSelectionList() {
        ArrayList<String> list = new ArrayList<String>(this.selectSet);
        return list;
    }

    public void removeAllItems() {
        SJctrNestedListDataObject nestedList = (SJctrNestedListDataObject)this.getManageData();
        nestedList.listData().clear();
        this.itemMap.clear();
        this.selectSet.clear();
        for (SJctrNodeData nodeData : this.getLogicalPathToNodeDataMap().values()) {
            nodeData.clear();
        }
        this.getNodePathToNodeDataMap().clear();
    }

    public void removeItem(String name) {
        if (this.itemMap.containsKey(name)) {
            HashMap<String, Object> item = this.getItem(name);
            ArrayList<HashMap<String, Object>> itemList = Item.getList(item);
            if (itemList != null) {
                while (itemList.size() > 0) {
                    HashMap<String, Object> childItem = itemList.get(0);
                    this.removeItem(Item.getName(childItem));
                }
            }
            this.itemMap.remove(name);
            this.selectSet.remove(name);
            SJctrNodeData nodeData = this.getNodePathToNodeDataMap().remove(name);
            if (nodeData != null) {
                nodeData.getNodePathToArgsMap().remove(name);
            }
            itemList = this.getItemList(name);
            int size = itemList.size();
            for (int i = 0; i < size; ++i) {
                HashMap<String, Object> item2 = itemList.get(i);
                if (!name.equals(Item.getName(item2))) continue;
                itemList.remove(i);
                break;
            }
        }
    }

    public void removeSelectionItem() {
        for (String name : this.getSelectionList()) {
            this.removeItem(name);
        }
    }

    public SJctrItemSelectListener setItemSelectListener(String name, SJctrItemSelectListener listener) {
        HashMap<String, Object> item = this.getItem(name);
        return Item.setItemSelectListener(item, listener);
    }

    public Object setItemObject(String name, Object obj) {
        HashMap<String, Object> item = this.getItem(name);
        return Item.setObject(item, obj);
    }

    public void setMultiSelect(boolean flg) {
        this.multiSelect = flg;
    }

    public boolean isMultiSelect() {
        return this.multiSelect;
    }

    public boolean setSelection(String name) {
        boolean result = false;
        if (!this.selectSet.contains(name)) {
            this.clearSelection();
            result = this.setSelectionName(name);
        }
        return result;
    }

    public boolean setSelectionToRoot(String name) {
        boolean result = false;
        if (!this.selectSet.contains(name)) {
            this.clearSelection();
            result = this.setSelectionToRootName(name);
        }
        return result;
    }

    protected HashMap<String, Object> createItem(String name, String label) {
        HashMap<String, Object> item = new HashMap<String, Object>();
        item.put(KEY_NAME, name);
        item.put(KEY_LABEL, label);
        return item;
    }

    protected HashMap<String, Object> createItem(String name, String label, int iconId) {
        HashMap<String, Object> item = this.createItem(name, label);
        item.put(KEY_ICON, iconId);
        return item;
    }

    public HashMap<String, Object> createItem(SJctrNodeData nodeData, Object ... args) {
        String name = nodeData.getNodePath(args);
        String label = nodeData.createLabel(args);
        int iconID = nodeData.createIconID(args);
        HashMap<String, Object> item = iconID <= 0 ? this.createItem(name, label) : this.createItem(name, label, iconID);
        return item;
    }

    @Override
    protected SJctrNestedListDataObject createManageData() {
        return new SJctrNestedListDataObject();
    }

    protected void fireItemSelected(String name) {
        HashMap<String, Object> item;
        SJctrItemSelectListener selectListener;
        SJctrItemSelectEvent<String> event = null;
        this.setDirty();
        if (this.isEnableListener() && (selectListener = Item.getItemSelectListener(item = this.getItem(name))) != null) {
            event = new SJctrItemSelectEvent<String>(this, name, this.selectSet.contains(name));
            selectListener.selectChanged(event);
        }
        for (SJctrEventListener listener : this.getEventListeners()) {
            if (!(listener instanceof SJctrItemSelectListener)) continue;
            if (event == null) {
                event = new SJctrItemSelectEvent<String>(this, name, this.selectSet.contains(name));
            }
            ((SJctrItemSelectListener)listener).selectChanged(event);
        }
    }

    public Map<String, HashMap<String, Object>> getItemMap() {
        return this.itemMap;
    }

    public HashMap<String, Object> getItem(String name) {
        return this.itemMap.get(name);
    }

    private ArrayList<HashMap<String, Object>> getItemList(String name) {
        ArrayList<HashMap<String, Object>> retList;
        int endIndex = name.lastIndexOf(DELIMITER);
        if (endIndex > 0) {
            HashMap<String, Object> item;
            String parentName = name.substring(0, endIndex);
            if (!this.itemMap.containsKey(parentName)) {
                this.addItem(parentName);
            }
            if ((retList = Item.getList(item = this.getItem(parentName))) == null) {
                retList = new ArrayList(10);
                item.put(KEY_CHILDREN, retList);
            }
        } else {
            retList = ((SJctrNestedListDataObject)this.getManageData()).listData();
        }
        return retList;
    }

    protected boolean setSelectionName(String name) {
        this.logUty.putlog("setSelectionName", "Select : " + name);
        HashMap<String, Object> item = this.getItem(name);
        boolean result = Item.setSelect(item, true);
        if (result) {
            this.selectSet.add(name);
            this.fireItemSelected(name);
        } else if (item == null) {
            this.getLogUty().putlog("setSelectionName", "failed:itemName=" + name + " is null");
        } else {
            this.getLogUty().putlog("setSelectionName", "failed:itemName=" + name + "," + Item.isSelect(item));
        }
        return result;
    }

    private boolean setSelectionToRootName(String name) {
        if (this.selectSet.contains(name)) {
            return false;
        }
        String selectName = name;
        int index = name.length();
        boolean result = true;
        while (!this.setSelectionName(selectName)) {
            result = false;
            if ((index = name.lastIndexOf(DELIMITER, index - 1)) >= 0 && !this.selectSet.contains(selectName = name.substring(0, index))) continue;
            break;
        }
        return result;
    }

    public void setEnable(boolean flg) {
        SJctrNestedListDataObject nestList = (SJctrNestedListDataObject)this.getManageData();
        boolean result = SJctrNestedListDataModel.setEnable(nestList, flg);
        if (result) {
            this.fireItemStateChanged();
        }
    }

    public void setVisible(boolean flg) {
        SJctrNestedListDataObject nestList = (SJctrNestedListDataObject)this.getManageData();
        boolean result = SJctrNestedListDataModel.setVisible(nestList, flg);
        if (result) {
            this.fireItemStateChanged();
        }
    }

    @Override
    protected void makeDataObject() {
        this.initNode();
    }

    protected void initNode() {
    }

    public boolean chkAdaptiveOpt(SJctrNodeData nodeData) {
        boolean ret = true;
        List<String> opt = nodeData.getNodeAdaptiveOpt();
        if (opt == null) {
            return ret;
        }
        SJctrUserController uc = this.getDataController().getOwner();
        SJctrAuthorizeContainer ac = uc.getAuthorizeContainer();
        boolean svp = ac.getSystemParamContainer().isLocalHost();
        boolean sn = ac.getLisenceContainer().checkPP(SJctrLicenseContainer.PPID_SN);
        boolean norBasic = ac.getSystemParamContainer().isNorBasic();
        boolean hic = ac.getSystemParamContainer().isLaunchHiCommand();
        SJctrDirectLauncher dl = uc.getDirectLauncher();
        boolean otherFuncMenuMode = dl.isOtherFuncMenuMode();
        Iterator<String> ite = opt.iterator();
        while (ret && ite.hasNext()) {
            SJbaseUserSessionInterface us;
            String key = ite.next();
            if (key.equals(HIDE_HM)) {
                if (!SJctrControllerManager.isHM()) continue;
                ret = false;
                continue;
            }
            if (key.equals(HIDE_RAID)) {
                if (!SJctrControllerManager.isRAID()) continue;
                ret = false;
                continue;
            }
            if (key.equals(NEED_LICENSE_SN)) {
                if (svp || sn) continue;
                ret = false;
                continue;
            }
            if (key.equals(SECONDARY_WINDOW)) {
                if (svp || otherFuncMenuMode) continue;
                us = uc.getUserSession();
                ret = SJctrEnvironmentalUtility.isSecondaryWindows(us);
                continue;
            }
            if (key.equals(HIDE_NOR_BASIC)) {
                ret = !norBasic;
                continue;
            }
            if (key.equals(HIDE_HIC)) {
                ret = !hic;
                continue;
            }
            if (key.equals(HIDE_NOR_BASIC_SECONDARY_WINDOW)) {
                if (!norBasic || svp || otherFuncMenuMode) continue;
                us = uc.getUserSession();
                ret = SJctrEnvironmentalUtility.isSecondaryWindows(us);
                continue;
            }
            if (!key.equals(HIDE_OTHER_FUNC_MENU_MODE)) continue;
            ret = !otherFuncMenuMode;
        }
        return ret;
    }

    static abstract class Item {
        private final Map<String, Object> item;

        static boolean containsExpand(Map<String, Object> item) {
            boolean result = false;
            if (item != null) {
                result = item.containsKey(SJctrNestedListDataModel.KEY_EXPANDED);
            }
            return result;
        }

        static boolean containsSelect(Map<String, Object> item) {
            boolean result = false;
            if (item != null) {
                result = item.containsKey(SJctrNestedListDataModel.KEY_SELECTED);
            }
            return result;
        }

        public static String getLabel(Map<String, Object> item) {
            String retString = null;
            if (item != null) {
                retString = (String)item.get(SJctrNestedListDataModel.KEY_LABEL);
            }
            return retString;
        }

        static ArrayList<HashMap<String, Object>> getList(HashMap<String, Object> item) {
            ArrayList retList = null;
            if (item != null) {
                retList = (ArrayList)item.get(SJctrNestedListDataModel.KEY_CHILDREN);
            }
            return retList;
        }

        public static SJctrItemSelectListener getItemSelectListener(Map<String, Object> item) {
            SJctrItemSelectListener retListener = null;
            if (item != null) {
                retListener = (SJctrItemSelectListener)item.get(SJctrNestedListDataModel.CTRL_SEL_LISTENER);
            }
            return retListener;
        }

        public static String getName(Map<String, Object> item) {
            String retString = null;
            if (item != null) {
                retString = (String)item.get(SJctrNestedListDataModel.KEY_NAME);
            }
            return retString;
        }

        public static Object getObject(Map<String, Object> item) {
            return item.get(SJctrNestedListDataModel.CTRL_OBJECT);
        }

        public static boolean isEnable(Map<String, Object> item) {
            boolean result = false;
            if (item != null) {
                result = Boolean.TRUE.equals(item.get(SJctrNestedListDataModel.KEY_ENABLE));
            }
            return result;
        }

        static boolean isExpand(Map<String, Object> item) {
            boolean result = false;
            if (item != null) {
                result = Boolean.TRUE.equals(item.get(SJctrNestedListDataModel.KEY_EXPANDED));
            }
            return result;
        }

        static boolean isSelect(Map<String, Object> item) {
            boolean result = false;
            if (item != null) {
                result = Boolean.TRUE.equals(item.get(SJctrNestedListDataModel.KEY_SELECTED));
            }
            return result;
        }

        public static boolean setLabel(Map<String, Object> item, String label) {
            if (item == null) {
                return false;
            }
            Object oldLabel = item.put(SJctrNestedListDataModel.KEY_LABEL, label);
            if (oldLabel == null) {
                return true;
            }
            return !oldLabel.equals(label);
        }

        public static boolean setList(Map<String, Object> item, ArrayList<HashMap<String, Object>> list) {
            if (item == null) {
                return false;
            }
            item.put(SJctrNestedListDataModel.KEY_CHILDREN, list);
            return true;
        }

        public static boolean setEnable(Map<String, Object> item, boolean flg) {
            if (item == null) {
                return false;
            }
            Object oldFlg = item.put(SJctrNestedListDataModel.KEY_ENABLE, flg);
            if (oldFlg == null) {
                return true;
            }
            return !oldFlg.equals(flg);
        }

        static boolean setExpand(Map<String, Object> item, boolean flg) {
            if (item == null) {
                return false;
            }
            Object oldFlg = item.put(SJctrNestedListDataModel.KEY_EXPANDED, flg);
            if (oldFlg == null) {
                return true;
            }
            if (!(oldFlg instanceof Boolean)) {
                return false;
            }
            return !oldFlg.equals(flg);
        }

        static SJctrItemSelectListener setItemSelectListener(Map<String, Object> item, SJctrItemSelectListener listener) {
            if (item == null) {
                return null;
            }
            return (SJctrItemSelectListener)item.put(SJctrNestedListDataModel.CTRL_SEL_LISTENER, listener);
        }

        static boolean setLink(Map<String, Object> item, boolean flg) {
            if (item == null) {
                return false;
            }
            Object oldFlg = item.put(SJctrNestedListDataModel.KEY_LINK, flg);
            if (oldFlg == null) {
                return true;
            }
            return !oldFlg.equals(flg);
        }

        static Object setObject(Map<String, Object> item, Object obj) {
            if (item == null) {
                return null;
            }
            return item.put(SJctrNestedListDataModel.CTRL_OBJECT, obj);
        }

        static boolean setSelect(Map<String, Object> item, boolean flg) {
            if (item == null) {
                return false;
            }
            Object oldFlg = item.put(SJctrNestedListDataModel.KEY_SELECTED, flg);
            if (oldFlg == null) {
                return true;
            }
            if (!(oldFlg instanceof Boolean)) {
                return false;
            }
            return !oldFlg.equals(flg);
        }

        public Item(Map<String, Object> map) {
            this.item = map;
        }

        public String getLabel() {
            return Item.getLabel(this.item);
        }

        public String getName() {
            return Item.getName(this.item);
        }

        public boolean isEnable() {
            return Item.isEnable(this.item);
        }

        public boolean isSelect() {
            return Item.isSelect(this.item);
        }

        public void setEnable(boolean flg) {
            this.item.put(SJctrNestedListDataModel.KEY_ENABLE, flg);
        }

        public boolean setSelect(boolean flg) {
            return Item.setSelect(this.item, flg);
        }

        boolean isExpand() {
            return Item.isExpand(this.item);
        }

        boolean setExpand(boolean flg) {
            return Item.setExpand(this.item, flg);
        }

        boolean setLink(boolean flg) {
            return Item.setLink(this.item, flg);
        }
    }
}

