/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.topwindow.base;

import edu.emory.mathcs.backport.java.util.Arrays;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import sanproject.sn2.com.utility.account.SJcRoleResourceContainer;
import sanproject.sn2.controller.com.SJctrAuthorizeContainer;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrLicenseContainer;
import sanproject.sn2.controller.com.SJctrMainteRoleUtility;
import sanproject.sn2.controller.com.SJctrSystemParamContainer;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.controller.com.data.SJctrSelectableDataObject;
import sanproject.sn2.controller.com.model.SJctrButtonDataModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.topwindow.base.SJctrAuditLogStatusDC;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.kind.SJmoGetSubsystemStatusMgr;
import sanproject.sn2.model.data.system.SJmoSubsystemStatusMgr;

public class SJctrAuditLogModel
extends SJctrButtonDataModel {
    public static final String KEY_ICON = "COM_ICON";
    public static final String KEY_TOOLTIP = "COM_TOOLTIP";
    public static final String KEY_SELECTED = "COM_SELECTED";
    public static final String AUDITLOG = "AUDITLOG";
    public static final String TOOLTIPSVP = "AUDIT_TOOLTIP_SVP";
    public static final String TOOLTIPDKC = "AUDIT_TOOLTIP_DKC";
    public static final String NORMAL2 = "NORMAL2";
    public static final String WARNING = "STS_WARNING";
    public static final String WRAPAROUND = "WRAPAROUND";
    private static final int SELECTED = 1;
    private static final int NON_SELECTED = 0;
    private boolean flgCheckAuditlog = false;
    private boolean flgAuditlogChecked = false;
    private String labelAuditLog = "";
    private String labelTooltipSvp = "";
    private String labelTooltipDkc = "";
    private String labelNormal = "";
    private String labelWarning = "";
    private String labelWraparound = "";
    private static int[] mStatusTable = new int[]{-1, 1, 6, 7};
    private static int[] mIconTable = new int[]{12294, 16389, 16390, 16391};
    private String[] mLabelTable;

    public SJctrAuditLogModel() {
        this.initListener();
    }

    private void initListener() {
        this.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                ArrayList<Class<SJctrAuditLogStatusDC>> list = new ArrayList<Class<SJctrAuditLogStatusDC>>();
                list.add(SJctrAuditLogStatusDC.class);
                SJctrAuditLogModel.this.fireMessageEvent(SJctrDataController.NOTIFY_STATE.MAKE_DIALOG_EX, list);
            }
        });
    }

    @Override
    public void initGuidance(SJctrComUtility util) {
        super.initGuidance(util);
        this.labelAuditLog = util.getGuidance(AUDITLOG);
        this.setLabel(this.labelAuditLog);
        this.labelTooltipSvp = util.getGuidance(TOOLTIPSVP);
        this.labelTooltipDkc = util.getGuidance(TOOLTIPDKC);
        this.labelNormal = util.getGuidance(NORMAL2);
        this.labelWarning = util.getGuidance(WARNING);
        this.labelWraparound = util.getGuidance(WRAPAROUND);
        String[] labelTable = new String[]{"?", this.labelNormal, this.labelWarning, this.labelWraparound};
        this.mLabelTable = labelTable;
    }

    @Override
    protected void makeModelDirect() {
        SJmoGetDirect direct = new SJmoGetDirect();
        direct.setGetKind(new SJmoGetSubsystemStatusMgr());
        this.directList.add(new SJctrGetDirectWrapper(direct, false));
    }

    @Override
    protected void makeDataObject() {
        boolean authority = this.chkAuthority();
        this.setVisible(authority);
        if (!authority) {
            return;
        }
        int statusAuditLog = -1;
        int statusSvp = -1;
        int statusDkc = -1;
        int usageSvp = -1;
        int usageDkc = -1;
        List<SJmoGetSubsystemStatusMgr> datalist = this.getBasicDataList(SJmoGetSubsystemStatusMgr.class);
        if (datalist.size() == 0) {
            this.getLogUty().putlog("getBasicDataList", "SJmoSubsystemStatusMgr is null");
        } else {
            SJmoSubsystemStatusMgr mgr = (SJmoSubsystemStatusMgr)((Object)datalist.get(0));
            statusAuditLog = mgr.getAuditLogStatus();
            statusSvp = mgr.getSvpAuditLogStatus();
            usageSvp = mgr.getSvpAuditLogUsage();
            statusDkc = mgr.getDkcAuditLogStatus();
            usageDkc = mgr.getDkcAuditLogUsage();
        }
        SJctrSelectableDataObject viewData = (SJctrSelectableDataObject)this.getManageData();
        int icon = this.getIconType(statusAuditLog);
        viewData.setData(KEY_ICON, icon);
        String strSvpStatus = this.getStatusLabel(statusSvp);
        String strSvpUsage = this.usageToStinrg(usageSvp);
        String strDkcStatus = this.getStatusLabel(statusDkc);
        String strDkcUsage = this.usageToStinrg(usageDkc);
        MessageFormat formTooltipSvp = new MessageFormat(this.labelTooltipSvp);
        String[] argSvp = new String[]{strSvpUsage, strSvpStatus};
        String strTooltipSvp = formTooltipSvp.format(argSvp);
        MessageFormat formTooltipDkc = new MessageFormat(this.labelTooltipDkc);
        String[] argDkc = new String[]{strDkcUsage, strDkcStatus};
        String strTooltipDkc = formTooltipDkc.format(argDkc);
        String strTooltip = "";
        strTooltip = this.getDataController().getOwner().getAuthorizeContainer().getSystemParamContainer().isLocalHost() ? strTooltipSvp : strTooltipSvp + "\n" + strTooltipDkc;
        viewData.setData(KEY_TOOLTIP, strTooltip);
        int intSelected = this.chkAuditLogProperties(statusAuditLog);
        this.getLogUty().putlog("chkAuditLogProperties", "COM_SELECTED=" + intSelected);
        viewData.setData(KEY_SELECTED, intSelected);
    }

    private boolean chkAuthority() {
        boolean ret;
        block7: {
            block6: {
                if (this.isNorBasic()) {
                    return false;
                }
                ret = false;
                SJctrDataController dc = this.getDataController();
                SJctrUserController uc = dc.getOwner();
                SJctrAuthorizeContainer ac = uc.getAuthorizeContainer();
                SJcRoleResourceContainer rr = ac.getRoleResourceContainer();
                SJctrLicenseContainer lc = ac.getLisenceContainer();
                SJctrSystemParamContainer spc = ac.getSystemParamContainer();
                boolean st_read = rr.checkAuthority(32);
                boolean host = spc.isLocalHost();
                if (!host) {
                    st_read = st_read && lc.checkPP(SJctrLicenseContainer.PPID_SN);
                }
                boolean au_read = rr.checkAuthority(18);
                boolean au_set = rr.checkAuthority(19);
                if (st_read && (au_read || au_set)) {
                    ret = true;
                }
                SJctrMainteRoleUtility roleUtil = new SJctrMainteRoleUtility();
                roleUtil.setContainer(ac);
                int role = roleUtil.isMainteRole();
                if (role == 1) break block6;
                if (role != 2) break block7;
            }
            ret = false;
        }
        return ret;
    }

    private boolean isNorBasic() {
        SJctrDataController dc = this.getDataController();
        SJctrUserController uc = dc.getOwner();
        SJctrAuthorizeContainer ac = uc.getAuthorizeContainer();
        SJctrSystemParamContainer spc = ac.getSystemParamContainer();
        return spc.isNorBasic();
    }

    String usageToStinrg(int usage) {
        String ret;
        if (usage >= 0 && usage <= 100) {
            ret = String.valueOf(usage);
        } else {
            this.getLogUty().putlog("usageToStinrg", "Invalid value of Audit Log usage:" + usage);
            ret = "?";
        }
        return ret;
    }

    private int indexOfStatus(int status) {
        int ret = Arrays.binarySearch((int[])mStatusTable, (int)status);
        if (ret < 0) {
            this.getLogUty().putlog("indexOfStatus", "Unknown status:" + status);
            ret = 0;
        }
        return ret;
    }

    int getIconType(int status) {
        int index = this.indexOfStatus(status);
        return mIconTable[index];
    }

    String getStatusLabel(int status) {
        int index = this.indexOfStatus(status);
        return this.mLabelTable[index];
    }

    protected int chkAuditLogProperties(int statusAuditLog) {
        int ret = 0;
        if (this.getDataController().getOwner().getAuthorizeContainer().getSystemParamContainer().isLaunchHiCommand()) {
            return ret;
        }
        if (this.flgCheckAuditlog & !this.flgAuditlogChecked) {
            this.flgAuditlogChecked = true;
            if (statusAuditLog == 6 || statusAuditLog == 7) {
                ret = 1;
            }
        }
        return ret;
    }

    public void setCheckAuditlog() {
        this.flgCheckAuditlog = true;
    }
}

