/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.topwindow.ldev;

import java.util.ArrayList;
import java.util.List;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.data.SJctrDataObject;
import sanproject.sn2.controller.com.model.SJctrSimpleDataModel;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetSubsystemCapacity;
import sanproject.sn2.model.data.system.SJmoSubsystemCapacity;

public abstract class SJctrSubLdevSummaryModel
extends SJctrSimpleDataModel {
    public static final String COM_INTERNAL_CAP = "COM_INTERNAL_CAP";
    public static final String COM_EXTERNAL_CAP = "COM_EXTERNAL_CAP";
    public static final String COM_INTERNAL_NUM = "COM_INTERNAL_NUM";
    public static final String COM_EXTERNAL_NUM = "COM_EXTERNAL_NUM";

    @Override
    protected void makeDataObject() {
        List<SJmoGetSubsystemCapacity> ldevSummary = this.getBasicDataList(SJmoGetSubsystemCapacity.class);
        this.makeSummary(ldevSummary);
    }

    @Override
    protected void makeModelDirect() {
        SJmoGetSubsystemCapacity kind = new SJmoGetSubsystemCapacity();
        SJmoGetRange_IF range = null;
        ArrayList filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        this.directList.add(new SJctrGetDirectWrapper(direct));
    }

    private void makeSummary(List<?> ldevSummary) {
        long internalCapacity = 0L;
        long externalCapacity = 0L;
        int internalNum = 0;
        int externalNum = 0;
        if (ldevSummary.size() > 0) {
            SJmoSubsystemCapacity summary = (SJmoSubsystemCapacity)ldevSummary.get(0);
            internalCapacity = this.getInternalCapacity(summary);
            externalCapacity = this.getExternalCapacity(summary);
            internalNum = this.getInternalNum(summary);
            externalNum = this.getExternalNum(summary);
        }
        Object summaryData = this.getManageData();
        ((SJctrDataObject)summaryData).setData(COM_INTERNAL_CAP, SJctrComUtility.toDecString(internalCapacity));
        ((SJctrDataObject)summaryData).setData(COM_EXTERNAL_CAP, SJctrComUtility.toDecString(externalCapacity));
        ((SJctrDataObject)summaryData).setData(COM_INTERNAL_NUM, SJctrComUtility.toDecString(internalNum));
        ((SJctrDataObject)summaryData).setData(COM_EXTERNAL_NUM, SJctrComUtility.toDecString(externalNum));
    }

    protected abstract long getInternalCapacity(SJmoSubsystemCapacity var1);

    protected abstract long getExternalCapacity(SJmoSubsystemCapacity var1);

    protected abstract int getInternalNum(SJmoSubsystemCapacity var1);

    protected abstract int getExternalNum(SJmoSubsystemCapacity var1);
}

