/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.topwindow.license.licensekeys;

import java.util.ArrayList;
import java.util.List;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrPPLicenseUtility;
import sanproject.sn2.controller.com.data.SJctrDataObject;
import sanproject.sn2.controller.com.model.SJctrSimpleDataModel;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetLicenseDetail;
import sanproject.sn2.model.data.system.SJmoLicenseDetail;
import sanproject.sn2.model.data.system.SJmoPPKget1PPInfo;

public class SJctrLicenseKeysSummaryModel
extends SJctrSimpleDataModel {
    public static final String KEY_MNT_CAP = "COM_MNT_CAP";
    public static final String KEY_INSTALLED = "COM_INSTALLED";
    public static final String KEY_NOT_INSTALLED = "COM_NOT_INSTALLED";
    public static final String KEY_GRACE_PERIOD = "COM_GRACE_PERIOD";
    public static final String KEY_NOT_ENOUGH = "COM_NOT_ENOUGH";
    public static final String KEY_EXPIRED = "COM_EXPIRED";
    public static final String KEY_INSTALLED_DIS = "COM_INSTALLED_DIS";
    String strMountCapa = "?";
    String strPPNum_Install = "?";
    String strPPNum_NotInstall = "?";
    String strPPNum_GracePeriod = "?";
    String strPPNum_NotEnough = "?";
    String strPPNum_Expired = "?";
    String strPPNum_Disable = "?";

    @Override
    public void makeDataObject() {
        List<SJmoGetLicenseDetail> list = this.getBasicDataList(SJmoGetLicenseDetail.class);
        if (list != null && !list.isEmpty()) {
            SJmoLicenseDetail licenseDtl = (SJmoLicenseDetail)((Object)list.get(0));
            this.setEquipCapacityDisplay(licenseDtl);
            ArrayList ppInfoDtl = licenseDtl.getPpl1ppinfo();
            this.setCountPPNum(ppInfoDtl);
        }
        Object summaryData = this.getManageData();
        ((SJctrDataObject)summaryData).setData(KEY_MNT_CAP, this.strMountCapa);
        ((SJctrDataObject)summaryData).setData(KEY_INSTALLED, this.strPPNum_Install);
        ((SJctrDataObject)summaryData).setData(KEY_NOT_INSTALLED, this.strPPNum_NotInstall);
        ((SJctrDataObject)summaryData).setData(KEY_GRACE_PERIOD, this.strPPNum_GracePeriod);
        ((SJctrDataObject)summaryData).setData(KEY_NOT_ENOUGH, this.strPPNum_NotEnough);
        ((SJctrDataObject)summaryData).setData(KEY_EXPIRED, this.strPPNum_Expired);
        ((SJctrDataObject)summaryData).setData(KEY_INSTALLED_DIS, this.strPPNum_Disable);
    }

    @Override
    protected void makeModelDirect() {
        SJmoGetLicenseDetail kind = new SJmoGetLicenseDetail();
        SJmoGetRange_IF range = null;
        ArrayList filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        this.directList.add(new SJctrGetDirectWrapper(direct));
    }

    private void setEquipCapacityDisplay(SJmoLicenseDetail licenseDtl) {
        long equipCapa = licenseDtl.getLdevSize();
        if (equipCapa >= 0L) {
            this.strMountCapa = SJctrPPLicenseUtility.changeGBtoTBString(equipCapa, true);
        }
    }

    private void setCountPPNum(ArrayList<SJmoPPKget1PPInfo> ppDtlList) {
        int ppNum_Install = 0;
        int ppNum_NotInstall = 0;
        int ppNum_GracePeriod = 0;
        int ppNum_NotEnough = 0;
        int ppNum_Expired = 0;
        int ppNum_Disable = 0;
        for (SJmoPPKget1PPInfo ppDtl : ppDtlList) {
            int preInst = ppDtl.getIPreInstall();
            if (preInst != 0) continue;
            int status = ppDtl.getIStatus();
            switch (status) {
                case 1: {
                    ++ppNum_Install;
                    break;
                }
                case 2: {
                    ++ppNum_NotInstall;
                    break;
                }
                case 3: {
                    ++ppNum_GracePeriod;
                    break;
                }
                case 4: {
                    ++ppNum_NotEnough;
                    break;
                }
                case 5: {
                    ++ppNum_Expired;
                    break;
                }
                case 8: {
                    ++ppNum_Disable;
                    break;
                }
            }
        }
        this.strPPNum_Install = SJctrComUtility.toDecString(ppNum_Install);
        this.strPPNum_NotInstall = SJctrComUtility.toDecString(ppNum_NotInstall);
        this.strPPNum_GracePeriod = SJctrComUtility.toDecString(ppNum_GracePeriod);
        this.strPPNum_NotEnough = SJctrComUtility.toDecString(ppNum_NotEnough);
        this.strPPNum_Expired = SJctrComUtility.toDecString(ppNum_Expired);
        this.strPPNum_Disable = SJctrComUtility.toDecString(ppNum_Disable);
    }
}

