/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.topwindow.monitor;

import java.util.ArrayList;
import java.util.List;
import sanproject.serverux.data.MonMonitoringInfoLDKC;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrNotifyState;
import sanproject.sn2.controller.com.data.SJctrDataObject;
import sanproject.sn2.controller.com.model.SJctrSimpleDataModel;
import sanproject.sn2.controller.wizard.monitor.optmon.com.SJctrOptionMonitorGuidance;
import sanproject.sn2.controller.wizard.monitor.optmon.com.SJctrOptionMonitorUtility;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetLdevDetail;
import sanproject.sn2.model.connector.kind.SJmoGetMonMonitoringInfoLDKC;
import sanproject.sn2.model.connector.kind.SJmoGetPPCALLPortWWNInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortDetail;
import sanproject.sn2.model.data.SJmoThroughRmiData;

public class SJctrPerformanceMonitorSummaryModel
extends SJctrSimpleDataModel {
    public static final String KEY_MON_SWITCH = "COM_MON_SWITCH";
    public static final String KEY_INTERVAL = "COM_INTERVAL";
    public static final String KEY_NUM_MON_CUS = "COM_NUM_MON_CUS";
    public static final String KEY_NUM_MON_LDEVS = "COM_NUM_MON_LDEVS";
    public static final String KEY_NUM_MON_WWNS = "COM_NUM_MON_WWNS";
    public static final String KEY_MON_SPM = "COM_MON_SPM";
    public static final String KEY_MON_PRM = "COM_MON_PRM";
    public static final String KEY_EDIT_MON_SW = "COM_EDIT_MON_SW";

    @Override
    protected void makeModelDirect() {
        SJmoGetKind_IF kind = new SJmoGetMonMonitoringInfoLDKC();
        SJmoGetRange_IF range = null;
        ArrayList filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        this.directList.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetLdevDetail();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        this.directList.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPPCALLPortWWNInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        this.directList.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPortDetail();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        this.directList.add(new SJctrGetDirectWrapper(direct));
    }

    @Override
    public void makeDataObject() {
        List<SJmoGetMonMonitoringInfoLDKC> rmiData = this.getBasicDataList(SJmoGetMonMonitoringInfoLDKC.class);
        if (null == rmiData) {
            this.logUty.putlog("getMonMonitoringInfoLDKC", "RMIData of monitor options is null.");
            return;
        }
        if (rmiData.size() == 0) {
            this.logUty.putlog("getMonMonitoringInfoLDKC", "Size of RMIData data list is zero.");
            return;
        }
        MonMonitoringInfoLDKC monInfo = (MonMonitoringInfoLDKC)((SJmoThroughRmiData)((Object)rmiData.get(0))).getObjRmi();
        if (null == monInfo) {
            this.logUty.putlog("getMonMonitoringInfoLDKC", "Information of monitor options is null.");
            return;
        }
        List<SJmoGetLdevDetail> ldevDetails = this.getBasicDataList(SJmoGetLdevDetail.class);
        if (null == ldevDetails) {
            this.logUty.putlog("getSJmoPortHostGroupInfo", "Information of WWNs registered to LUN Manager is null.");
            return;
        }
        List<SJmoGetPPCALLPortWWNInfo> portWwnInfos = this.getBasicDataList(SJmoGetPPCALLPortWWNInfo.class);
        if (null == portWwnInfos) {
            this.logUty.putlog("getPPCALLPortWWNInfo", "Information of monitored WWNs is null.");
            return;
        }
        List<SJmoGetPortDetail> portDetails = this.getBasicDataList(SJmoGetPortDetail.class);
        if (null == portDetails) {
            this.logUty.putlog("getSJmoPortDetail", "Information of port detail is null.");
            return;
        }
        Object dataObj = this.getManageData();
        String monSwStr = "";
        String intervalStr = SJctrOptionMonitorGuidance.getMonitorGuidanceStr(this.getComUtility(), SJctrOptionMonitorGuidance.BAR);
        if (monInfo.isStatus()) {
            monSwStr = SJctrOptionMonitorGuidance.getMonitorGuidanceStr(this.getComUtility(), SJctrOptionMonitorGuidance.ENABLED);
            intervalStr = monInfo.getInterval() / 60 + " " + SJctrOptionMonitorGuidance.getMonitorGuidanceStr(this.getComUtility(), SJctrOptionMonitorGuidance.MIN);
        } else {
            monSwStr = SJctrOptionMonitorGuidance.getMonitorGuidanceStr(this.getComUtility(), SJctrOptionMonitorGuidance.DISABLED);
        }
        ((SJctrDataObject)dataObj).setData(KEY_MON_SWITCH, monSwStr);
        ((SJctrDataObject)dataObj).setData(KEY_INTERVAL, intervalStr);
        int monCuCount = SJctrOptionMonitorUtility.getMonitoringCUCount(monInfo);
        ((SJctrDataObject)dataObj).setData(KEY_NUM_MON_CUS, Integer.toString(monCuCount));
        int monLdevCount = SJctrOptionMonitorUtility.getMonitoringLDEVCount(monInfo, ldevDetails);
        ((SJctrDataObject)dataObj).setData(KEY_NUM_MON_LDEVS, Integer.toString(monLdevCount));
        int monWwnCount = SJctrOptionMonitorUtility.getMonitoringWWNCount(portWwnInfos, portDetails);
        ((SJctrDataObject)dataObj).setData(KEY_NUM_MON_WWNS, Integer.toString(monWwnCount));
    }

    public static enum MON_SUMMARY_MSG implements SJctrNotifyState
    {
        SELECT_MON_PFM;

    }
}

