/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.topwindow.portcondition;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import sanproject.serverux.dataimpl.DKCgetAllPortLEDStatus;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrDialogDataController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrPortUtility;
import sanproject.sn2.controller.com.SJctrResourceGroupUtility;
import sanproject.sn2.controller.com.data.SJctrDataObject;
import sanproject.sn2.controller.com.model.SJctrButtonDataModel;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.topwindow.base.authorize.SJctrExportAuthorize;
import sanproject.sn2.controller.topwindow.portcondition.SJctrDKCDataModel;
import sanproject.sn2.controller.topwindow.portcondition.SJctrDKCKgetPortLEDStatusInfo;
import sanproject.sn2.controller.topwindow.portcondition.SJctrGetDKCgetAllPortLEDStatus;
import sanproject.sn2.controller.topwindow.portcondition.SJctrPortConditionInfo;
import sanproject.sn2.controller.topwindow.portcondition.SJctrPortConditionMgr;
import sanproject.sn2.controller.topwindow.portcondition.SJctrPortConditionTabModel;
import sanproject.sn2.controller.topwindow.portcondition.SJctrPortConditionTableModel;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetChaDetail;
import sanproject.sn2.model.connector.kind.SJmoGetPortAttributeInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortDetail;
import sanproject.sn2.model.connector.kind.SJmoGetRSGgetAllRsgs;
import sanproject.sn2.model.data.SJmoThroughRmiData;
import sanproject.sn2.model.data.device.SJmoChaDetail;
import sanproject.sn2.model.data.device.SJmoPortAttributeInfo;
import sanproject.sn2.model.data.device.SJmoPortDetail;
import sanproject.sn2.model.data.device.SJmoPortIndex;
import sanproject.sn2.model.data.rsg.SJmoRSGgetAllRsgs;

public class SJctrPortConditionDC
extends SJctrDialogDataController {
    public static final int DISP_ID = 34664453;
    public static final String KEY_TAB_PROPERTY = "COM_TAB_PROPERTY";
    public static final String KEY_DKC0 = "COM_DKC0";
    public static final String KEY_TABLE_DKC0 = "COM_TABLE_DKC0";
    public static final String KEY_DKC1 = "COM_DKC1";
    public static final String KEY_TABLE_DKC1 = "COM_TABLE_DKC1";
    public static final String KEY_BTN_REFRESH = "COM_BTN_REFRESH";
    public static final String KEY_EXPORT = "COM_EXPORT";
    private List<SJmoPortDetail> portDetailList = null;
    private List<SJmoRSGgetAllRsgs> rsgDetailList = null;
    private List<?> portLEDStatusDataList = null;
    private List<SJmoChaDetail> chaDetailList = null;
    private List<SJmoPortAttributeInfo> portAttributeList = null;
    private SJctrPortConditionMgr portConditionMgr = null;
    private SJctrPortConditionTableModel DKC0TableDataModel = null;
    private SJctrPortConditionTableModel DKC1TableDataModel = null;
    private final String STR_EXPORT = "Export";

    public SJctrPortConditionDC() throws SJcException {
        super(34664453);
        this.initDataModel();
    }

    private void initDataModel() {
        this.addDataObjectModel(KEY_TAB_PROPERTY, new SJctrPortConditionTabModel());
        this.addDataObjectModel(KEY_DKC0, new SJctrDKCDataModel());
        this.DKC0TableDataModel = new SJctrPortConditionTableModel();
        this.addDataObjectModel(KEY_TABLE_DKC0, this.DKC0TableDataModel);
        SJctrButtonDataModel exportButton0 = new SJctrButtonDataModel();
        this.addDataObjectModel(KEY_EXPORT, exportButton0);
        exportButton0.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                if (event.isSelect()) {
                    SJctrPortConditionDC.this.exportAction("DKC0", SJctrPortConditionDC.KEY_TABLE_DKC0);
                }
            }
        });
        SJctrDataObjectModel<? extends SJctrDataObject> dkc0 = this.getDataObjectModel(KEY_DKC0);
        dkc0.addDataModel(KEY_EXPORT, exportButton0);
        this.addDataObjectModel(KEY_DKC1, new SJctrDKCDataModel());
        this.DKC1TableDataModel = new SJctrPortConditionTableModel();
        this.addDataObjectModel(KEY_TABLE_DKC1, this.DKC1TableDataModel);
        SJctrButtonDataModel exportButton1 = new SJctrButtonDataModel();
        this.addDataObjectModel(KEY_EXPORT, exportButton1);
        exportButton1.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                if (event.isSelect()) {
                    SJctrPortConditionDC.this.exportAction("DKC1", SJctrPortConditionDC.KEY_TABLE_DKC1);
                }
            }
        });
        SJctrDataObjectModel<? extends SJctrDataObject> dkc1 = this.getDataObjectModel(KEY_DKC1);
        dkc1.addDataModel(KEY_EXPORT, exportButton1);
        SJctrButtonDataModel button = new SJctrButtonDataModel();
        this.addDataObjectModel(KEY_BTN_REFRESH, button);
        button.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                SJctrPortConditionDC.this.refreshAction();
            }
        });
        this.addDataObjectModel("COM_FOOTER", new SJctrFooterDataModel(SJctrFooterDataModel.BGO_CLOSE));
    }

    private boolean chkAuthority() {
        boolean ret = true;
        SJctrExportAuthorize auth = new SJctrExportAuthorize();
        auth.setContainer(this.getOwner().getAuthorizeContainer());
        ret &= auth.chkPP();
        return ret &= auth.chkRole();
    }

    @Override
    public boolean checkConstructData() {
        boolean ret = true;
        this.portDetailList = this.getCache(SJmoGetPortDetail.class);
        this.rsgDetailList = this.getCache(SJmoGetRSGgetAllRsgs.class);
        this.portLEDStatusDataList = this.getCache(SJctrGetDKCgetAllPortLEDStatus.class);
        this.chaDetailList = this.getCache(SJmoGetChaDetail.class);
        this.portAttributeList = this.getCache(SJmoGetPortAttributeInfo.class);
        this.checkModelRmiData(this.portDetailList, this.rsgDetailList, this.portLEDStatusDataList, this.chaDetailList, this.portAttributeList);
        return ret;
    }

    private void checkModelRmiData(List<SJmoPortDetail> portDetailList, List<SJmoRSGgetAllRsgs> rsgDetailList, List<?> portLEDStatusDataList, List<SJmoChaDetail> chaDetailList, List<SJmoPortAttributeInfo> portAttributeList) {
        if (portDetailList == null) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkConstructData", "portDetailList is not found");
            SJctrError err = new SJctrError(211, 22, 207001);
            SJcException exp = err.createException();
            throw exp;
        }
        if (rsgDetailList == null || rsgDetailList.isEmpty()) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkConstructData", "rsgDetailList is not found");
            SJctrError err = new SJctrError(211, 22, 207001);
            SJcException exp = err.createException();
            throw exp;
        }
        if (portLEDStatusDataList == null || portLEDStatusDataList.isEmpty()) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkConstructData", "portLEDStatusDataList is not found");
            SJctrError err = new SJctrError(211, 22, 207001);
            SJcException exp = err.createException();
            throw exp;
        }
        if (chaDetailList == null) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkConstructData", "chaDetailList is not found");
            SJctrError err = new SJctrError(211, 22, 207001);
            SJcException exp = err.createException();
            throw exp;
        }
        if (portAttributeList == null) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkConstructData", "portAttributeList is not found");
            SJctrError err = new SJctrError(211, 22, 207001);
            SJcException exp = err.createException();
            throw exp;
        }
    }

    @Override
    public void makeDataModel() {
        this.portConditionMgr = new SJctrPortConditionMgr();
        this.createDispData();
        super.makeDataModel();
    }

    private void createDispData() {
        ArrayList<SJmoPortDetail> portDetailDKC0List = new ArrayList<SJmoPortDetail>();
        ArrayList<SJmoPortDetail> portDetailDKC1List = new ArrayList<SJmoPortDetail>();
        for (SJmoPortDetail portDetail : this.portDetailList) {
            SJctrPortConditionInfo portConditionInfo = this.portConditionMgr.getPortConditionInfo(portDetail);
            if (portConditionInfo == null) {
                SJctrLogUty.warn(this.getClass().getSimpleName(), "createDispData", "portConditionInfo is not found");
                SJctrError err = new SJctrError(211, 22, 207001);
                SJcException exp = err.createException();
                throw exp;
            }
            if (portConditionInfo.getSDKCNum() == SJctrPortConditionMgr.DKC_NUMBER_0.shortValue()) {
                portDetailDKC0List.add(portDetail);
                continue;
            }
            portDetailDKC1List.add(portDetail);
        }
        Collections.sort(portDetailDKC0List);
        Collections.sort(portDetailDKC1List);
        SJctrResourceGroupUtility rsgUtil = new SJctrResourceGroupUtility(this.getOwner(), this.rsgDetailList.get(0));
        List<SJmoPortIndex> resourcePortIndexList = rsgUtil.extractPort(this.portDetailList);
        Collections.sort(resourcePortIndexList);
        SJmoThroughRmiData rmiObj = (SJmoThroughRmiData)this.portLEDStatusDataList.get(0);
        DKCgetAllPortLEDStatus[] portLEDStatusInfo = (DKCgetAllPortLEDStatus[])rmiObj.getObjRmi();
        if (portLEDStatusInfo == null) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "createDispData", "portLEDStatusInfo is not found");
            SJctrError err = new SJctrError(211, 22, 207001);
            SJcException exp = err.createException();
            throw exp;
        }
        ArrayList<SJctrDKCKgetPortLEDStatusInfo> portLEDStatusInfoList = new ArrayList<SJctrDKCKgetPortLEDStatusInfo>(portLEDStatusInfo.length);
        for (int index = 0; index < portLEDStatusInfo.length; ++index) {
            if (portLEDStatusInfo[index].nLEDStatus == 0) continue;
            SJctrDKCKgetPortLEDStatusInfo portLEDInfo = new SJctrDKCKgetPortLEDStatusInfo(portLEDStatusInfo[index]);
            portLEDStatusInfoList.add(portLEDInfo);
        }
        Collections.sort(portLEDStatusInfoList);
        SJctrPortConditionTabModel tab = (SJctrPortConditionTabModel)this.getDataObjectModel(KEY_TAB_PROPERTY);
        tab.initData(portDetailDKC1List);
        SJctrDKCDataModel DKC0DataModel = (SJctrDKCDataModel)this.getDataObjectModel(KEY_DKC0);
        SJctrDKCDataModel DKC1DataModel = (SJctrDKCDataModel)this.getDataObjectModel(KEY_DKC1);
        DKC0DataModel.setCreateDKCData(portDetailDKC0List, resourcePortIndexList, portLEDStatusInfoList, SJctrPortConditionMgr.CHANAME_DKC0_LIST, this.portConditionMgr, this.chaDetailList);
        DKC1DataModel.setCreateDKCData(portDetailDKC1List, resourcePortIndexList, portLEDStatusInfoList, SJctrPortConditionMgr.CHANAME_DKC1_LIST, this.portConditionMgr, this.chaDetailList);
        this.DKC0TableDataModel.setTableKeyList(portDetailDKC0List);
        this.DKC0TableDataModel.setBasicData(SJctrPortUtility.RESOURCE_PORT_CLASS, resourcePortIndexList);
        this.DKC0TableDataModel.setBasicData(SJctrPortUtility.PORT_LED_STATUS_CLASS, portLEDStatusInfoList);
        this.DKC0TableDataModel.setBasicData(SJctrPortUtility.KEY_CLASS_CHA_DETAIL, this.chaDetailList);
        this.DKC0TableDataModel.setBasicData(SJctrPortUtility.KEY_CLASS_PORT_ATTRIBUTE, this.portAttributeList);
        this.DKC1TableDataModel.setTableKeyList(portDetailDKC1List);
        this.DKC1TableDataModel.setBasicData(SJctrPortUtility.RESOURCE_PORT_CLASS, resourcePortIndexList);
        this.DKC1TableDataModel.setBasicData(SJctrPortUtility.PORT_LED_STATUS_CLASS, portLEDStatusInfoList);
        this.DKC1TableDataModel.setBasicData(SJctrPortUtility.KEY_CLASS_CHA_DETAIL, this.chaDetailList);
        this.DKC1TableDataModel.setBasicData(SJctrPortUtility.KEY_CLASS_PORT_ATTRIBUTE, this.portAttributeList);
        boolean auth = this.chkAuthority();
        SJctrButtonDataModel exportButton0 = (SJctrButtonDataModel)DKC0DataModel.getDataModel(KEY_EXPORT);
        exportButton0.setEnable(auth);
        SJctrButtonDataModel exportButton1 = (SJctrButtonDataModel)DKC1DataModel.getDataModel(KEY_EXPORT);
        exportButton1.setEnable(auth);
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        Set<SJctrGetDirectWrapper> set = super.getModelDirect();
        SJmoGetKind_IF kind = new SJmoGetPortDetail();
        SJmoGetRange_IF range = null;
        ArrayList filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetRSGgetAllRsgs();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJctrGetDKCgetAllPortLEDStatus();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetChaDetail();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPortAttributeInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        return set;
    }

    private void updateModelRMIData() {
        HashSet<SJctrGetDirectWrapper> wrapperSet = new HashSet<SJctrGetDirectWrapper>();
        SJctrGetDirectWrapper portDetailDirectWrapper = null;
        SJctrGetDirectWrapper resourceDirectWrapper = null;
        SJctrGetDirectWrapper portLEDDirectWrapper = null;
        SJctrGetDirectWrapper chaDetailDirectWrapper = null;
        SJctrGetDirectWrapper portAttributeDirectWrapper = null;
        SJmoGetKind_IF kind = new SJmoGetPortDetail();
        SJmoGetRange_IF range = null;
        ArrayList filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        portDetailDirectWrapper = new SJctrGetDirectWrapper(direct);
        portDetailDirectWrapper.setCacheMode(false);
        wrapperSet.add(portDetailDirectWrapper);
        kind = new SJmoGetRSGgetAllRsgs();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        resourceDirectWrapper = new SJctrGetDirectWrapper(direct);
        resourceDirectWrapper.setCacheMode(false);
        wrapperSet.add(resourceDirectWrapper);
        kind = new SJctrGetDKCgetAllPortLEDStatus();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        portLEDDirectWrapper = new SJctrGetDirectWrapper(direct);
        portLEDDirectWrapper.setCacheMode(false);
        wrapperSet.add(portLEDDirectWrapper);
        kind = new SJmoGetChaDetail();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        chaDetailDirectWrapper = new SJctrGetDirectWrapper(direct);
        chaDetailDirectWrapper.setCacheMode(false);
        wrapperSet.add(chaDetailDirectWrapper);
        kind = new SJmoGetPortAttributeInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        portAttributeDirectWrapper = new SJctrGetDirectWrapper(direct);
        portAttributeDirectWrapper.setCacheMode(false);
        wrapperSet.add(portAttributeDirectWrapper);
        Map<SJctrGetDirectWrapper, List<?>> dataMap = this.getProxy().getDataInf(wrapperSet);
        this.portDetailList = dataMap.get(portDetailDirectWrapper);
        this.rsgDetailList = dataMap.get(resourceDirectWrapper);
        this.portLEDStatusDataList = dataMap.get(portLEDDirectWrapper);
        this.chaDetailList = dataMap.get(chaDetailDirectWrapper);
        this.portAttributeList = dataMap.get(portAttributeDirectWrapper);
        this.checkModelRmiData(this.portDetailList, this.rsgDetailList, this.portLEDStatusDataList, this.chaDetailList, this.portAttributeList);
    }

    private void refreshAction() {
        List<Object> beforeDKC0selectRowData = this.DKC0TableDataModel.getSelectedRowData();
        List<Object> beforeDKC1selectRowData = this.DKC1TableDataModel.getSelectedRowData();
        this.updateModelRMIData();
        this.createDispData();
        super.makeDataModel();
        this.setDirtyAll();
        List<Object> afterDKC0AllRowData = this.DKC0TableDataModel.getAllRowData();
        List<Object> afterDKC1AllRowData = this.DKC1TableDataModel.getAllRowData();
        ArrayList<Object> DKC0refreshSelectInfoList = new ArrayList<Object>();
        for (Object DKC0selectObj : beforeDKC0selectRowData) {
            int DKC0Index = Collections.binarySearch(afterDKC0AllRowData, DKC0selectObj);
            if (DKC0Index < 0) continue;
            DKC0refreshSelectInfoList.add(DKC0selectObj);
        }
        ArrayList<Object> DKC1refreshSelectInfoList = new ArrayList<Object>();
        for (Object DKC1selectObj : beforeDKC1selectRowData) {
            int DKC1Index = Collections.binarySearch(afterDKC1AllRowData, DKC1selectObj);
            if (DKC1Index < 0) continue;
            DKC1refreshSelectInfoList.add(DKC1selectObj);
        }
        this.DKC0TableDataModel.setRowSelectionList(DKC0refreshSelectInfoList);
        this.DKC1TableDataModel.setRowSelectionList(DKC1refreshSelectInfoList);
    }

    private void exportAction(String tabKey, String tableKey) {
        String tabLabel = null;
        SJctrPortConditionTabModel tab = (SJctrPortConditionTabModel)this.getDataObjectModel(KEY_TAB_PROPERTY);
        if (tab != null) {
            HashMap<String, Object> item = tab.getItem(tabKey);
            tabLabel = (String)item.get("label");
        }
        SJctrPortConditionTableModel table = (SJctrPortConditionTableModel)this.getDataObjectModel(tableKey);
        table.tabName = tabLabel;
        String defaultFileName = "";
        defaultFileName = this.getComUtility().getGuidance("PORT_CONDITION");
        defaultFileName = defaultFileName + "-" + tabLabel + "Export";
        defaultFileName = SJctrComUtility.getTsvFileName(defaultFileName);
        ArrayList<Object> param = new ArrayList<Object>();
        param.add(table);
        param.add(defaultFileName);
        this.fireMessageEvent(SJctrDataController.NOTIFY_STATE.MAKE_EXPORT, param);
    }
}

