/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.topwindow.report;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import sanproject.serverux.dataimpl.REPORTReportInfo;
import sanproject.serverux.dataimpl.REPORTgetReportHistory;
import sanproject.serverux.dataimpl.REPORTgetReportHistory_OUT;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrAuthorizeContainer;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrErrorColumnData;
import sanproject.sn2.controller.com.SJctrErrorDataController;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.SJctrTableDataModel;
import sanproject.sn2.controller.com.model.event.SJctrMessageEvent;
import sanproject.sn2.controller.com.model.event.SJctrMessageEventListener;
import sanproject.sn2.controller.topwindow.report.SJctrGetReportInfo;
import sanproject.sn2.controller.topwindow.report.SJctrReportActionMenuModel;
import sanproject.sn2.controller.topwindow.report.SJctrReportDeleteAuthorize;
import sanproject.sn2.controller.topwindow.report.SJctrReportDownload;
import sanproject.sn2.controller.topwindow.report.SJctrReportInfoData;
import sanproject.sn2.controller.topwindow.report.SJctrReportInfoDispDC;
import sanproject.sn2.controller.topwindow.report.SJctrReportSummaryModel;
import sanproject.sn2.controller.topwindow.report.SJctrReportTableModel;
import sanproject.sn2.controller.topwindow.report.com.SJctrReportDef;
import sanproject.sn2.controller.wizard.report.createreport.SJctrCreateReportSubWizard;
import sanproject.sn2.controller.wizard.report.deletereport.SJctrDeleteReportSubWizard;
import sanproject.sn2.model.SJmoGetAgent;
import sanproject.sn2.model.SJmoModelMgr;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.data.SJmoThroughRmiData;

public class SJctrReportDC
extends SJctrDataController {
    public static final String KEY_TABLE = "COM_TABLE";
    public static final String KEY_SUMMARY = "COM_SUMMARY";
    public static final String KEY_ACTION_MENU = "COM_ACTION_MENU";
    private static final int LIST_ELEMNT_ONE = 1;
    public ArrayList<SJctrReportInfoData> mDspReportList;

    public SJctrReportDC() throws SJcException {
        this(5120);
        this.initDataObjectModel();
        this.initListener();
    }

    protected SJctrReportDC(int dispID) throws SJcException {
        super(dispID);
    }

    private void initDataObjectModel() {
        this.getLogUty().putlog("SJctrReportsDC", "initDataObjectModel Start");
        this.addDataObjectModel(KEY_SUMMARY, new SJctrReportSummaryModel());
        this.addDataObjectModel(KEY_TABLE, new SJctrReportTableModel());
        this.addDataObjectModel(KEY_ACTION_MENU, new SJctrReportActionMenuModel());
        this.mDspReportList = null;
        this.getLogUty().putlog("SJctrReportsDC", "initDataObjectModel End");
    }

    public List<SJctrReportInfoData> getReportList() {
        this.getLogUty().putlog("SJctrReportsDC", "getReportList Start");
        if (this.mDspReportList == null) {
            this.mDspReportList = this.getReportData();
        } else {
            this.getLogUty().putlog("SJctrReportsDC", "getReportList Data AllReady!");
        }
        this.getLogUty().putlog("SJctrReportsDC", "getReportList End");
        return this.mDspReportList;
    }

    private void initListener() {
        this.addMessageEventListener(SJctrReportDef.REPORT_CONTROL_MSG.MAKE_DETAIL, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                Object obj = event.getNofifyObject();
                if (obj instanceof List) {
                    Class class1;
                    List list = (List)obj;
                    SJctrReportInfoData reportInfo = (SJctrReportInfoData)list.get(1);
                    if (!SJctrReportDC.this.isAvailableReport(reportInfo)) {
                        SJctrReportDC.this.getLogUty().putlog("SJctrReportDC", "Display authority none:" + reportInfo.getUserId());
                        throw new SJcException(String.valueOf(205), String.valueOf(22), "105310");
                    }
                    String pReport = reportInfo.getMReportHtml();
                    String pDir = reportInfo.getReportDir();
                    Class dcClass = class1 = (Class)list.get(0);
                    SJctrUserController uc = SJctrReportDC.this.getOwner();
                    SJctrRelatedDispDataObject relatedDisp = uc.createRelatedDispData(dcClass);
                    SJctrReportInfoDispDC infoDisp = (SJctrReportInfoDispDC)uc.getDataController(relatedDisp);
                    if (pReport == null || pReport == "") {
                        throw new SJcException("201", "22", "107021");
                    }
                    if (pDir == null || pDir == "") {
                        throw new SJcException("201", "22", "107021");
                    }
                    try {
                        infoDisp.initDataObjectModel(pReport, pDir);
                    }
                    catch (SJcException e) {
                        uc.removeRelatedDispData(infoDisp.getuId());
                        throw e;
                    }
                    SJctrReportDC.this.addUpdateDisp(relatedDisp);
                }
            }
        });
        this.addMessageEventListener(SJctrReportDef.REPORT_CONTROL_MSG.BTN_DELETE, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrReportDC.this.makeDeleteReport(event, dstModel);
            }
        });
        this.addMessageEventListener(SJctrReportDef.REPORT_CONTROL_MSG.BTN_CREATE, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrReportDC.this.makeCreateReport(event, dstModel);
            }
        });
        this.addMessageEventListener(SJctrReportDef.REPORT_CONTROL_MSG.RTN_DOWMLOAD, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrReportDC.this.makeDownloadReport(event, dstModel);
            }
        });
    }

    private ArrayList<SJctrReportInfoData> getTableSelData() {
        SJctrTableDataModel table = (SJctrTableDataModel)this.getDataObjectModel(KEY_TABLE);
        List<Object> selectedRowList = table.getSelectedRowData();
        if (selectedRowList.size() == 0) {
            this.getLogUty().putlog("getTableSelData", "not selected");
        }
        ArrayList<SJctrReportInfoData> selectReportList = new ArrayList<SJctrReportInfoData>();
        for (int i = 0; i < selectedRowList.size(); ++i) {
            SJctrReportInfoData selectData = (SJctrReportInfoData)selectedRowList.get(i);
            selectReportList.add(selectData);
        }
        return selectReportList;
    }

    private void makeDownloadReport(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        this.getLogUty().putlog("SJctrReportsDC", "makeDownloadReport Start");
        SJctrTableDataModel table = (SJctrTableDataModel)this.getDataObjectModel(KEY_TABLE);
        List<Object> selectedRowList = table.getSelectedRowData();
        SJctrReportInfoData selectData = (SJctrReportInfoData)selectedRowList.get(0);
        if (!this.isAvailableReport(selectData)) {
            this.getLogUty().putlog("SJctrReportDC", "Operation authority none:" + selectData.getUserId());
            throw new SJcException(String.valueOf(205), String.valueOf(22), "105310");
        }
        SJctrReportDownload makeDownload = new SJctrReportDownload();
        makeDownload.setFileName(selectData.getReportTgz());
        makeDownload.setMiddleDir(selectData.getReportDir());
        Object obj = event.getNofifyObject();
        if (!(obj instanceof List)) {
            this.getLogUty().putlog("SJctrReportsDC", "makeDownloadReport Parameter Error(Not List)");
            return;
        }
        List list = (List)obj;
        SJctrDataObjectModel exportDataModel = (SJctrDataObjectModel)list.get(0);
        makeDownload.setExportDataModel(exportDataModel);
        if (list.size() > 1) {
            String defaultFileName = (String)list.get(1);
            makeDownload.setDefaultFileName(defaultFileName);
        }
        SJctrRelatedDispDataObject related = this.createFileDownload(makeDownload);
        this.addUpdateDisp(related);
        this.getLogUty().putlog("SJctrReportsDC", "makeDownloadReport End");
    }

    private void makeDeleteReport(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        this.getLogUty().putlog("SJctrReportsDC", "makeDeleteReport Start");
        SJctrTableDataModel table = (SJctrTableDataModel)this.getDataObjectModel(KEY_TABLE);
        List<Object> selectedRowList = table.getSelectedRowData();
        ArrayList<SJctrErrorColumnData> errList = new ArrayList<SJctrErrorColumnData>(selectedRowList.size());
        boolean result = true;
        for (Object selectData : selectedRowList) {
            SJctrReportInfoData reportInfo = (SJctrReportInfoData)selectData;
            if (this.isAvailableReport(reportInfo)) continue;
            this.getLogUty().putlog("SJctrReportDC", "Operation authority none:ReportName=" + reportInfo.getName() + "UserID=" + reportInfo.getUserId());
            result = false;
            SJctrError err = new SJctrError(205, 22, Integer.parseInt("105310"));
            SJctrErrorColumnData errData = new SJctrErrorColumnData(reportInfo, err);
            errList.add(errData);
        }
        if (!result) {
            SJctrRelatedDispDataObject rel = this.createDialog(SJctrErrorDataController.class, null);
            SJctrErrorDataController errDc = (SJctrErrorDataController)this.getOwner().getDataController(rel);
            errDc.setParameter(table, errList);
            SJctrError representErrorInfo = errDc.getRepresentativeError(errList);
            SJcException exp = representErrorInfo.createException();
            exp.setErrDisp(rel);
            throw exp;
        }
        HashMap param = new HashMap();
        param.put("KEY_SELECT_REPORT_DATA", this.getTableSelData());
        SJctrRelatedDispDataObject wizardRelated = this.createWizard(SJctrDeleteReportSubWizard.class, param);
        this.addUpdateDisp(wizardRelated);
        this.getLogUty().putlog("SJctrReportsDC", "makeDeleteReport End");
    }

    private void makeCreateReport(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        this.getLogUty().putlog("SJctrReportsDC", "makeCreateReport Start");
        SJctrRelatedDispDataObject wizardRelated = this.createWizard(SJctrCreateReportSubWizard.class, null);
        this.addUpdateDisp(wizardRelated);
        this.getLogUty().putlog("SJctrReportsDC", "makeCreateReport End");
    }

    private SJcException setErrorListParameterSet(SJctrUserController uc, List<SJctrReportInfoData> errReportList, int error_code) {
        SJctrTableDataModel etable = (SJctrTableDataModel)this.getDataObjectModel(KEY_TABLE);
        ArrayList<SJctrErrorColumnData> errlist = new ArrayList<SJctrErrorColumnData>();
        SJctrError err_Top = new SJctrError(205, 22, error_code);
        for (SJctrReportInfoData Report_err : errReportList) {
            SJctrError err_detail = new SJctrError(205, 22, error_code);
            SJctrErrorColumnData errData = new SJctrErrorColumnData(Report_err, err_detail);
            errlist.add(errData);
        }
        SJctrRelatedDispDataObject rel = this.createDialog(SJctrErrorDataController.class, null);
        SJctrErrorDataController errDc = (SJctrErrorDataController)uc.getDataController(rel);
        errDc.setParameter(etable, errlist);
        SJcException exp = err_Top.createException();
        exp.setErrDisp(rel);
        return exp;
    }

    private ArrayList<SJctrReportInfoData> getReportData() {
        this.getLogUty().putlog("SJctrReportsDC", "getReportData Start");
        ArrayList<SJctrReportInfoData> rptList = new ArrayList<SJctrReportInfoData>(0);
        ArrayList<SJmoGetDirect> listDirect = new ArrayList<SJmoGetDirect>();
        SJctrGetReportInfo kind = new SJctrGetReportInfo();
        SJmoGetRange_IF range = null;
        List filterList = null;
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        listDirect.add(direct);
        SJmoGetAgent agent = SJmoModelMgr.getModelMgr().getDataAgent();
        List getList = agent.getDataInf(listDirect);
        List throughRmiList = (List)getList.get(0);
        SJmoThroughRmiData throughRmi = (SJmoThroughRmiData)throughRmiList.get(0);
        REPORTgetReportHistory_OUT rptObj = (REPORTgetReportHistory_OUT)throughRmi.getObjRmi();
        REPORTgetReportHistory reportHistory = rptObj.getDataObject();
        REPORTReportInfo[] reportList = reportHistory.getReportList();
        int iNumber = reportHistory.getIResult();
        for (int ii = 0; ii < iNumber; ++ii) {
            SJctrReportInfoData dReport = new SJctrReportInfoData();
            dReport.setId(ii);
            dReport.setReportDir(reportList[ii].getOutputDir());
            dReport.setName(reportList[ii].getSzReportName());
            dReport.setUserId(reportList[ii].getSzUserName());
            dReport.setSubmitTime(reportList[ii].getSzStartTime());
            rptList.add(dReport);
        }
        if (iNumber == 0) {
            rptList = null;
        }
        this.getLogUty().putlog("SJctrReportsDC", "getReportData End GetData=[" + iNumber + "]");
        return rptList;
    }

    private ArrayList<SJctrReportInfoData> getReportDataDummy() {
        ArrayList<SJctrReportInfoData> dmmyList = new ArrayList<SJctrReportInfoData>(0);
        dmmyList = null;
        return dmmyList;
    }

    private boolean isAvailableReport(SJctrReportInfoData reportInfo) {
        String reportUserId;
        SJctrReportDeleteAuthorize reportDeleteAuthorize = new SJctrReportDeleteAuthorize();
        SJctrAuthorizeContainer container_new = this.getOwner().getAuthorizeContainer();
        reportDeleteAuthorize.setContainer(container_new);
        if (reportDeleteAuthorize.chkRole()) {
            return true;
        }
        String userId = this.getOwner().getUserSession().getUserID();
        return userId.equals(reportUserId = reportInfo.getUserId());
    }
}

