/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.topwindow.tasks;

import java.util.List;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.data.SJctrDataObject;
import sanproject.sn2.controller.com.model.SJctrSimpleDataModel;
import sanproject.sn2.controller.topwindow.tasks.SJctrDispTaskInfo;
import sanproject.sn2.controller.topwindow.tasks.SJctrTasksDC;

public class SJctrTasksSummaryModel
extends SJctrSimpleDataModel {
    public static final String KEY_COMPLETED_NUM = "COM_COMPLETED_NUM";
    public static final String KEY_SUSPENDED_NUM = "COM_SUSPENDED_NUM";
    public static final String KEY_IN_PROGRESS_NUM = "COM_IN_PROGRESS_NUM";
    public static final String KEY_FAILED_NUM = "COM_FAILED_NUM";
    public static final String KEY_WAITING_NUM = "COM_WAITING_NUM";
    public static final String KEY_ABORTED_NUM = "COM_ABORTED_NUM";

    @Override
    public void makeDataObject() {
    }

    @Override
    protected void makeModelDirect() {
    }

    @Override
    public Object getDataObject(SJctrDataObject inputObject) {
        this.makeSummary();
        return super.getDataObject(inputObject);
    }

    protected void makeSummary() {
        int cntWaiting = 0;
        int cntSuspend = 0;
        int cntInprogress = 0;
        int cntComplete = 0;
        int cntFailed = 0;
        int cntAbort = 0;
        SJctrTasksDC dc = (SJctrTasksDC)this.getDataController();
        List<SJctrDispTaskInfo> taskList = dc.getTaskList();
        for (SJctrDispTaskInfo task : taskList) {
            switch (task.getStatus()) {
                case 0: {
                    break;
                }
                case 1: {
                    ++cntWaiting;
                    break;
                }
                case 2: {
                    ++cntSuspend;
                    break;
                }
                case 256: 
                case 257: 
                case 258: {
                    ++cntInprogress;
                    break;
                }
                case 512: {
                    ++cntComplete;
                    break;
                }
                case 513: 
                case 514: {
                    ++cntFailed;
                    break;
                }
            }
        }
        Object summaryData = this.getManageData();
        ((SJctrDataObject)summaryData).setData(KEY_COMPLETED_NUM, SJctrComUtility.toDecString(cntComplete));
        ((SJctrDataObject)summaryData).setData(KEY_SUSPENDED_NUM, SJctrComUtility.toDecString(cntSuspend));
        ((SJctrDataObject)summaryData).setData(KEY_IN_PROGRESS_NUM, SJctrComUtility.toDecString(cntInprogress));
        ((SJctrDataObject)summaryData).setData(KEY_FAILED_NUM, SJctrComUtility.toDecString(cntFailed));
        ((SJctrDataObject)summaryData).setData(KEY_WAITING_NUM, SJctrComUtility.toDecString(cntWaiting));
        ((SJctrDataObject)summaryData).setData(KEY_ABORTED_NUM, SJctrComUtility.toDecString(cntAbort));
    }

    @Override
    public void initGuidance(SJctrComUtility util) {
        super.initGuidance(util);
    }
}

