/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.account.deleteusergroups;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.utility.account.exception.SJcCommunicationErrorException;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrErrorColumnData;
import sanproject.sn2.controller.com.SJctrErrorTableModel;
import sanproject.sn2.controller.com.comparator.SJctrErrorColumnDataComparator;
import sanproject.sn2.controller.wizard.SJctrConfirmDataController;
import sanproject.sn2.controller.wizard.account.com.SJctrAccountDataMacro;
import sanproject.sn2.controller.wizard.account.com.SJctrAccountInfoUty;
import sanproject.sn2.controller.wizard.account.com.SJctrUserGrpInfoDetail;
import sanproject.sn2.controller.wizard.account.com.SJctrUserGrpsSelectData;
import sanproject.sn2.controller.wizard.account.deleteusergroups.SJctrDeleteUserGrpsConfirmTableModel;

public class SJctrDeleteUserGrpsConfirmDC
extends SJctrConfirmDataController {
    protected static final int DISP_ID = 17870969;
    private static final String COM_TABLE_SEL = "COM_TABLE";

    public SJctrDeleteUserGrpsConfirmDC() {
        super(17870969);
        this.initDataModel();
    }

    @Override
    public boolean checkStartData() {
        String strLogSubTitle = "checkStartData";
        this.getLogUty().putlog(strLogSubTitle, "start");
        SJctrError errInfo = null;
        List<?> dat = this.getCache(SJctrAccountDataMacro.WIZARD_DELETEUSERGRPS_SELECT_DATA);
        if (!this.checkContactData(dat, SJctrAccountDataMacro.WIZARD_DELETEUSERGRPS_SELECT_DATA)) {
            SJctrError err = new SJctrError(2, 22, 107010);
            SJcException exception = err.createException();
            throw exception;
        }
        SJctrUserGrpsSelectData userGrpsSelectData = (SJctrUserGrpsSelectData)dat.get(0);
        List<SJctrUserGrpInfoDetail> userGrpInfoDetailList = userGrpsSelectData.getUserGrpInfoDetailList();
        if (userGrpInfoDetailList == null || userGrpInfoDetailList.isEmpty()) {
            this.getLogUty().putlog(strLogSubTitle, "[Logic Error]Contact Data (User Group Info Detail List) is Empty", null, 40000);
            SJctrError err = new SJctrError(2, 22, 107010);
            SJcException exception = err.createException();
            throw exception;
        }
        int userGrpNum = userGrpInfoDetailList.size();
        String[] userGrpNames = new String[userGrpNum];
        for (int i = 0; i < userGrpNum; ++i) {
            userGrpNames[i] = userGrpInfoDetailList.get(i).getGroupName();
        }
        Map<String, SJctrUserGrpInfoDetail> userGrpInfoDetailMap = null;
        try {
            userGrpInfoDetailMap = SJctrAccountInfoUty.getUserGrpInfoDetailList(userGrpNames, this);
        }
        catch (SJcCommunicationErrorException e) {
            this.getLogUty().putlog(strLogSubTitle, "[Communication Error]getUserGrpInfoDetailList() is failed(" + e.getClass().getSimpleName() + ")", null, 40000);
            SJctrError err = new SJctrError(201, 22, 208003);
            SJcException exception = err.createException();
            throw exception;
        }
        catch (SJcException e) {
            this.getLogUty().putlog(strLogSubTitle, "[Logic Error]getUserInfoDetailList() is failed (" + e.getClass().getSimpleName() + ")", null, 40000);
            SJctrError err = new SJctrError(2, 22, 107010);
            SJcException exception = err.createException();
            throw exception;
        }
        ArrayList<SJctrErrorColumnData> errList = new ArrayList<SJctrErrorColumnData>(userGrpNum);
        for (int i = 0; i < userGrpNum; ++i) {
            String userGrpName = userGrpNames[i];
            SJctrUserGrpInfoDetail userGrpInfoDetail = userGrpInfoDetailMap.get(userGrpName);
            if (userGrpInfoDetail != null) continue;
            this.getLogUty().putlog(strLogSubTitle, "[Logic Error]userGrpInfo is null(" + userGrpName + ")", null, 40000);
            SJctrError error = new SJctrError(2, 22, 107014);
            if (errInfo == null) {
                errInfo = error;
            }
            if (errInfo.getError() != 107014) continue;
            SJctrErrorColumnData errData = new SJctrErrorColumnData(userGrpInfoDetailList.get(i), error);
            errList.add(errData);
        }
        ArrayList<SJctrUserGrpInfoDetail> availableUserGrplist = new ArrayList<SJctrUserGrpInfoDetail>();
        for (String strUserGrpName : userGrpNames) {
            availableUserGrplist.add(userGrpInfoDetailMap.get(strUserGrpName));
        }
        SJctrUserGrpsSelectData userGrpsData = new SJctrUserGrpsSelectData();
        userGrpsData.setUserGrpInfoDetailList(availableUserGrplist);
        ArrayList<SJctrUserGrpsSelectData> list = new ArrayList<SJctrUserGrpsSelectData>();
        list.add(userGrpsData);
        this.putCache(SJctrAccountDataMacro.WIZARD_DELETEUSERS_SELECT_DATA, list);
        this.getLogUty().putlog(strLogSubTitle, "end");
        return true;
    }

    private void initDataModel() {
        this.addDataObjectModel(COM_TABLE_SEL, new SJctrDeleteUserGrpsConfirmTableModel());
    }

    @Override
    public Map<String, List<?>> getConfirmData() {
        HashMap map = new HashMap();
        List<?> confirmDataList = this.getCache(SJctrAccountDataMacro.WIZARD_DELETEUSERGRPS_SELECT_DATA);
        map.put(SJctrAccountDataMacro.WIZARD_DELETEUSERGRPS_SELECT_DATA, confirmDataList);
        Map<String, List<?>> result = SJctrConfirmDataController.mapkeyClassToString(map);
        return result;
    }

    @Override
    public void getConfirmWithStatus(List<Object> destErrorList) throws SJcException {
        String strLogSubTitle = "getConfirmWithStatus";
        try {
            this.getLogUty().putlog(strLogSubTitle, "start");
            List cfrmErrorList = (List)destErrorList.get(0);
            List applyErrorList = (List)cfrmErrorList.get(0);
            List<?> dat = this.getCache(SJctrAccountDataMacro.WIZARD_DELETEUSERGRPS_SELECT_DATA);
            SJctrUserGrpsSelectData userGrpsData = (SJctrUserGrpsSelectData)dat.get(0);
            List<SJctrUserGrpInfoDetail> userGrpInfoDetailList = userGrpsData.getUserGrpInfoDetailList();
            ArrayList<SJctrUserGrpInfoDetail> err_userGrpInfoList = new ArrayList<SJctrUserGrpInfoDetail>();
            ArrayList<SJctrErrorColumnData> errList = new ArrayList<SJctrErrorColumnData>();
            for (int i = 0; i < userGrpInfoDetailList.size(); ++i) {
                if (((SJctrError)applyErrorList.get(i)).getError() == 0) continue;
                SJctrUserGrpInfoDetail userGrpInfoDetail = userGrpInfoDetailList.get(i);
                err_userGrpInfoList.add(userGrpInfoDetail);
                SJctrError err = new SJctrError(((SJctrError)applyErrorList.get(i)).getFunc(), ((SJctrError)applyErrorList.get(i)).getModule(), ((SJctrError)applyErrorList.get(i)).getError());
                SJctrErrorColumnData errColumn = new SJctrErrorColumnData(userGrpInfoDetail, err);
                errList.add(errColumn);
            }
            userGrpsData.setUserGrpInfoDetailList(err_userGrpInfoList);
            ArrayList<SJctrUserGrpsSelectData> list = new ArrayList<SJctrUserGrpsSelectData>();
            list.add(userGrpsData);
            this.getProxy().putCache(SJctrAccountDataMacro.WIZARD_DELETEUSERGRPS_SELECT_DATA, list);
            SJctrDeleteUserGrpsConfirmTableModel table = (SJctrDeleteUserGrpsConfirmTableModel)this.getDataObjectModel(COM_TABLE_SEL);
            table.makeDataModel();
            SJctrErrorTableModel errTable = new SJctrErrorTableModel();
            this.addDataObjectModel(COM_TABLE_SEL, errTable);
            errTable.initialize(table, errList, new SJctrErrorColumnDataComparator());
            this.getLogUty().putlog(strLogSubTitle, "end");
        }
        catch (Exception e) {
            this.getLogUty().putlog(strLogSubTitle, "[Logic Error]getConfirmWithStatus is failed", e, 40000);
            throw new SJcException();
        }
    }

    public boolean checkContactData(List<?> dat, Class<?> cls) {
        String strLogSubTitle = "checkContactData";
        this.getLogUty().putlog(strLogSubTitle, "start");
        if (dat == null || dat.isEmpty()) {
            this.getLogUty().putlog(strLogSubTitle, "[Logic Error]Contact Data List is Empty", null, 40000);
            return false;
        }
        Object obj = dat.get(0);
        if (obj == null) {
            this.getLogUty().putlog(strLogSubTitle, "[Logic Error]Contact Data (" + cls.getSimpleName() + ") is Empty", null, 40000);
            return false;
        }
        if (!obj.getClass().equals(cls)) {
            this.getLogUty().putlog(strLogSubTitle, "[Logic Error]Contact Data is illegal Class", null, 40000);
            return false;
        }
        this.getLogUty().putlog(strLogSubTitle, "end");
        return true;
    }
}

