/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.account.extauth.com;

import java.io.File;
import java.io.Serializable;
import java.util.HashMap;
import sanproject.sn2.base.authentication.module.external.common.SJbaseConfiguration;
import sanproject.sn2.base.authentication.module.external.common.SJbaseGroupConfiguration;
import sanproject.sn2.base.authentication.module.external.kerberos.SJbaseKerberosConfiguration;
import sanproject.sn2.base.authentication.module.external.ldap.SJbaseLdapConfiguration;
import sanproject.sn2.base.authentication.module.external.ldapgetgroup.SJbaseLdapGroupConfiguration;
import sanproject.sn2.base.authentication.module.external.radius.SJbaseRadiusConfiguration;
import sanproject.sn2.base.authentication.module.external.radius.SJbaseRadiusConfigurationFactory;
import sanproject.sn2.controller.com.SJctrExtAuthServerUtility;
import sanproject.sn2.controller.wizard.account.extauth.com.config.SJctrConfiguration;
import sanproject.sn2.controller.wizard.account.extauth.com.config.SJctrGroupConfiguration;
import sanproject.sn2.controller.wizard.account.extauth.com.config.SJctrKerberosConfiguration;
import sanproject.sn2.controller.wizard.account.extauth.com.config.SJctrLdapConfiguration;
import sanproject.sn2.controller.wizard.account.extauth.com.config.SJctrLdapGroupConfiguration;
import sanproject.sn2.controller.wizard.account.extauth.com.config.SJctrRadiusConfiguration;

public class SJctrExtAuthServerInfo
implements Serializable,
Comparable<SJctrExtAuthServerInfo> {
    public static String SERVER_TYPE_NOTHING = "Nothing";
    public static String SERVER_TYPE_LDAP = "ldap";
    public static String SERVER_TYPE_RADIUS = "radius";
    public static String SERVER_TYPE_KERBEROS = "kerberos";
    public static String KEY_SERVER_PRIMARY = "PrimaryServer";
    public static String KEY_SERVER_SECONDARY = "SecondaryServer";
    public static String PROTOCOL_LDAP = "ldap";
    public static String PROTOCOL_LDAPS = "ldaps";
    public static String PROTOCOL_STARTTLS = "starttls";
    public static String PROTOCOL_PAP = "PAP";
    public static String PROTOCOL_CHAP = "CHAP";
    public static final String[] RADIUS_ATTR_INFO = SJbaseRadiusConfigurationFactory.RADIUS_ATTRS;
    public static final String RADIUS_ATTR_IDENTIFIER = RADIUS_ATTR_INFO[0];
    public static final String RADIUS_ATTR_IPv4 = RADIUS_ATTR_INFO[1];
    public static final String RADIUS_ATTR_IPv6 = RADIUS_ATTR_INFO[2];
    public static String BLANK = "";
    public static int INVALID_VALUE = -1;
    public static int EXTAUTH_NO_ERR = 0;
    public static String TRUE_DEF = "true";
    public static String FALSE_DEF = "false";
    public static int PORT_MIN = 1;
    public static int PORT_MAX = 65535;
    public static int TIMEOUT_MIN = 1;
    public static int TIMEOUT_MAX = 120;
    public static int RETRY_TIMES_MIN = 1;
    public static int RETRY_TIMES_MAX = 50;
    public static int RETRY_INTERVAL_MIN = 1;
    public static int RETRY_INTERVAL_MAX = 60;
    public static int CLOCKSKEW_MIN = 1;
    public static int CLOCKSKEW_MAX = 300;
    public static String LDAP_DNS_LOOKUP_DEF = "false";
    public static String LDAP_DOMAINNAME_DEF = BLANK;
    public static String LDAP_HOSTNAME_DEF = BLANK;
    public static String LDAP_PROTOCOL_DEF = PROTOCOL_STARTTLS;
    public static String LDAP_SEARCH_DN_DEF = BLANK;
    public static String LDAP_SEARCH_USERS_DN_DEF = BLANK;
    public static String LDAP_USER_ATTR_DEF = "sAMAccountName";
    public static int LDAP_PORT_NUMBER_DEF = 389;
    public static int LDAP_RETRY_INTERVAL_DEF = 1;
    public static int LDAP_RETRY_TIMES_DEF = 3;
    public static int LDAP_TIMEOUT_DEF = 10;
    public static byte[] RADIUS_SECRET_DEF = new byte[0];
    public static String RADIUS_HOSTNAME_DEF = BLANK;
    public static String RADIUS_PROTOCOL_DEF = PROTOCOL_PAP;
    public static int RADIUS_PORT_NUMBER_DEF = 1812;
    public static int RADIUS_RETRY_TIMES_DEF = 3;
    public static int RADIUS_TIMEOUT_DEF = 10;
    public static String KERBEROS_DNS_LOOKUP_DEF = "false";
    public static String KERBEROS_DEFAULT_REALM_DEF = BLANK;
    public static String KERBEROS_REALM_DEF = BLANK;
    public static String KERBEROS_REALM_NAME_DEF = BLANK;
    public static String KERBEROS_KDC_DEF = ":88";
    public static int KERBEROS_CLOCKSKEW_DEF = 300;
    public static int KERBEROS_TIMEOUT_DEF = 10;
    private String type = SERVER_TYPE_NOTHING;
    private SJctrConfiguration pri_config = null;
    private SJctrConfiguration sec_config = null;
    private SJctrGroupConfiguration pri_group_config = null;
    private SJctrGroupConfiguration sec_group_config = null;
    private String certifyFullPathName = BLANK;

    public void setConfiguration(SJbaseConfiguration config, String priority) {
        SJctrConfiguration data = null;
        if (config != null) {
            if (this.isServerTypeLdap()) {
                SJctrLdapConfiguration ldap;
                data = ldap = new SJctrLdapConfiguration((SJbaseLdapConfiguration)config);
            } else if (this.isServerTypeRadius()) {
                SJctrRadiusConfiguration radius = new SJctrRadiusConfiguration((SJbaseRadiusConfiguration)config);
                data = radius;
            } else if (this.isServerTypeKerberos()) {
                SJctrKerberosConfiguration kerberos = new SJctrKerberosConfiguration((SJbaseKerberosConfiguration)config);
                data = kerberos;
            } else if (this.isServerTypeNothing()) {
                // empty if block
            }
        }
        if (SJctrExtAuthServerUtility.isPrimaryServer(priority)) {
            this.pri_config = data;
        } else if (SJctrExtAuthServerUtility.isSecondaryServer(priority)) {
            this.sec_config = data;
        }
    }

    public void setGroupConfiguration(SJbaseGroupConfiguration group_config, String priority) {
        SJctrLdapGroupConfiguration data = null;
        if (group_config != null && !this.isServerTypeNothing()) {
            SJctrLdapGroupConfiguration group_ldap;
            data = group_ldap = new SJctrLdapGroupConfiguration((SJbaseLdapGroupConfiguration)group_config);
        }
        if (SJctrExtAuthServerUtility.isPrimaryServer(priority)) {
            this.pri_group_config = data;
        } else if (SJctrExtAuthServerUtility.isSecondaryServer(priority)) {
            this.sec_group_config = data;
        }
    }

    public void setServerType(String type) {
        this.type = type;
    }

    public String getServerType() {
        return this.type;
    }

    public boolean isServerTypeLdap() {
        boolean ret = false;
        if (SJctrExtAuthServerUtility.isServerTypeLdap(this.type)) {
            ret = true;
        }
        return ret;
    }

    public boolean isServerTypeRadius() {
        boolean ret = false;
        if (SJctrExtAuthServerUtility.isServerTypeRadius(this.type)) {
            ret = true;
        }
        return ret;
    }

    public boolean isServerTypeKerberos() {
        boolean ret = false;
        if (SJctrExtAuthServerUtility.isServerTypeKerberos(this.type)) {
            ret = true;
        }
        return ret;
    }

    public boolean isServerTypeNothing() {
        boolean ret = false;
        if (this.type.equals(SERVER_TYPE_NOTHING)) {
            ret = true;
        }
        return ret;
    }

    public void setCertifyFullPathName(String fullPathName) {
        this.certifyFullPathName = fullPathName;
    }

    public String getCertifyFileName() {
        String ret = BLANK;
        File file = new File(this.certifyFullPathName);
        ret = file.getName();
        return ret;
    }

    public SJbaseConfiguration getConfiguration(String key) {
        SJbaseConfiguration ret = null;
        if (SJctrExtAuthServerUtility.isPrimaryServer(key)) {
            if (this.pri_config != null) {
                ret = this.pri_config.makeBaseConfig();
            }
        } else if (SJctrExtAuthServerUtility.isSecondaryServer(key) && this.sec_config != null) {
            ret = this.sec_config.makeBaseConfig();
        }
        return ret;
    }

    public HashMap<String, SJbaseConfiguration> getConfigurationMap() {
        HashMap<String, SJbaseConfiguration> ret = new HashMap<String, SJbaseConfiguration>();
        SJbaseConfiguration pri = null;
        if (this.pri_config != null) {
            pri = this.pri_config.makeBaseConfig();
        }
        SJbaseConfiguration sec = null;
        if (this.sec_config != null) {
            sec = this.sec_config.makeBaseConfig();
        }
        ret.put(KEY_SERVER_PRIMARY, pri);
        ret.put(KEY_SERVER_SECONDARY, sec);
        return ret;
    }

    public SJbaseGroupConfiguration getGroupConfiguration(String key) {
        SJbaseGroupConfiguration ret = null;
        if (SJctrExtAuthServerUtility.isPrimaryServer(key)) {
            if (this.pri_group_config != null) {
                ret = this.pri_group_config.makeBaseConfig();
            }
        } else if (SJctrExtAuthServerUtility.isSecondaryServer(key) && this.sec_group_config != null) {
            ret = this.sec_group_config.makeBaseConfig();
        }
        return ret;
    }

    public HashMap<String, SJbaseGroupConfiguration> getGroupConfigurationMap() {
        HashMap<String, SJbaseGroupConfiguration> ret = new HashMap<String, SJbaseGroupConfiguration>();
        SJbaseGroupConfiguration pri = null;
        if (this.pri_group_config != null) {
            pri = this.pri_group_config.makeBaseConfig();
        }
        SJbaseGroupConfiguration sec = null;
        if (this.sec_group_config != null) {
            sec = this.sec_group_config.makeBaseConfig();
        }
        ret.put(KEY_SERVER_PRIMARY, pri);
        ret.put(KEY_SERVER_SECONDARY, sec);
        return ret;
    }

    @Override
    public int compareTo(SJctrExtAuthServerInfo obj) {
        return obj.getServerType().compareToIgnoreCase(this.type);
    }

    public SJbaseLdapConfiguration getDefaultLdapConfig() {
        SJbaseLdapConfiguration config = new SJbaseLdapConfiguration();
        config.setDnsLookup(LDAP_DNS_LOOKUP_DEF);
        config.setDomainName(LDAP_DOMAINNAME_DEF);
        config.setHost(LDAP_HOSTNAME_DEF);
        config.setPort(LDAP_PORT_NUMBER_DEF);
        config.setProtocol(LDAP_PROTOCOL_DEF);
        config.setRetryInterval(LDAP_RETRY_INTERVAL_DEF);
        config.setRetryTimes(LDAP_RETRY_TIMES_DEF);
        config.setSearchDN(LDAP_SEARCH_DN_DEF);
        config.setSearchUserDN(LDAP_SEARCH_USERS_DN_DEF);
        config.setSearchUserPassword(BLANK);
        config.setServerErrCode(EXTAUTH_NO_ERR);
        config.setServerName(BLANK);
        config.setTimeout(LDAP_TIMEOUT_DEF);
        config.setUserAttr(LDAP_USER_ATTR_DEF);
        return config;
    }

    public SJbaseRadiusConfiguration getDefaultRadiusConfig() {
        SJbaseRadiusConfiguration config = new SJbaseRadiusConfiguration();
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put(RADIUS_ATTR_IDENTIFIER, BLANK);
        config.setAttributes(attributes);
        config.setHost(RADIUS_HOSTNAME_DEF);
        config.setPort(RADIUS_PORT_NUMBER_DEF);
        config.setProtocol(RADIUS_PROTOCOL_DEF);
        config.setRetryTimes(RADIUS_RETRY_TIMES_DEF);
        config.setSecret(RADIUS_SECRET_DEF);
        config.setServerErrCode(EXTAUTH_NO_ERR);
        config.setServerName(BLANK);
        config.setTimeout(RADIUS_TIMEOUT_DEF);
        return config;
    }

    public SJbaseKerberosConfiguration getDefaultKerberosConfig() {
        SJbaseKerberosConfiguration config = new SJbaseKerberosConfiguration();
        config.setClockskew(KERBEROS_CLOCKSKEW_DEF);
        config.setDefaul_Realm(KERBEROS_DEFAULT_REALM_DEF);
        config.setDns_Lookup_Kdc(KERBEROS_DNS_LOOKUP_DEF);
        config.setKdc(KERBEROS_KDC_DEF);
        config.setRealm(KERBEROS_REALM_DEF);
        config.setRealm_Name(KERBEROS_REALM_NAME_DEF);
        config.setServerErrCode(EXTAUTH_NO_ERR);
        config.setTimeout(KERBEROS_TIMEOUT_DEF);
        return config;
    }

    public SJbaseLdapGroupConfiguration getDefaultGroupLdapConfig() {
        SJbaseLdapGroupConfiguration config = new SJbaseLdapGroupConfiguration();
        config.setDnsLookup(LDAP_DNS_LOOKUP_DEF);
        config.setDomainName(LDAP_DOMAINNAME_DEF);
        config.setHost(LDAP_HOSTNAME_DEF);
        config.setPort(LDAP_PORT_NUMBER_DEF);
        config.setProtocol(LDAP_PROTOCOL_DEF);
        config.setRetryInterval(LDAP_RETRY_INTERVAL_DEF);
        config.setRetryTimes(LDAP_RETRY_TIMES_DEF);
        config.setSearchDN(LDAP_SEARCH_DN_DEF);
        config.setSearchUserDN(LDAP_SEARCH_USERS_DN_DEF);
        config.setSearchUserPassword(BLANK);
        config.setServerErrCode(EXTAUTH_NO_ERR);
        config.setTimeout(LDAP_TIMEOUT_DEF);
        return config;
    }

    public SJbaseLdapConfiguration copyLdapConfig(SJbaseLdapConfiguration conf) {
        SJbaseLdapConfiguration config = new SJbaseLdapConfiguration();
        config.setDnsLookup(conf.getDnsLookup());
        config.setDomainName(conf.getDomainName());
        config.setHost(conf.getHost());
        config.setPort(conf.getPort());
        config.setProtocol(conf.getProtocol());
        config.setRetryInterval(conf.getRetryInterval());
        config.setRetryTimes(conf.getRetryTimes());
        config.setSearchDN(conf.getSearchDN());
        config.setSearchUserDN(conf.getSearchUserDN());
        config.setSearchUserPassword(conf.getSearchUserPassword());
        config.setServerErrCode(conf.getServerErrCode());
        config.setServerName(conf.getSearverName());
        config.setTimeout(conf.getTimeout());
        config.setUserAttr(conf.getUserAttr());
        return config;
    }

    public SJbaseRadiusConfiguration copyRadiusConfig(SJbaseRadiusConfiguration conf) {
        SJbaseRadiusConfiguration config = new SJbaseRadiusConfiguration();
        config.setAttributes(conf.getAttributes());
        config.setHost(conf.getHost());
        config.setPort(conf.getPort());
        config.setProtocol(conf.getProtocol());
        config.setRetryTimes(conf.getRetryTimes());
        config.setSecret(conf.getSecret());
        config.setServerErrCode(conf.getServerErrCode());
        config.setServerName(conf.getSearverName());
        config.setTimeout(conf.getTimeout());
        return config;
    }

    public SJbaseKerberosConfiguration copyKerberosConfig(SJbaseKerberosConfiguration conf) {
        SJbaseKerberosConfiguration config = new SJbaseKerberosConfiguration();
        config.setClockskew(conf.getClockskew());
        config.setDefaul_Realm(config.getDefaul_Realm());
        config.setDns_Lookup_Kdc(conf.getDns_Lookup_Kdc());
        config.setKdc(conf.getKdc());
        config.setRealm(conf.getRealm());
        config.setRealm_Name(conf.getRealm_Name());
        config.setServerErrCode(conf.getServerErrCode());
        config.setTimeout(conf.getTimeout());
        return config;
    }

    public SJbaseLdapGroupConfiguration copyLdapGroupConfig(SJbaseLdapGroupConfiguration conf) {
        SJbaseLdapGroupConfiguration config = new SJbaseLdapGroupConfiguration();
        config.setDnsLookup(conf.getDnsLookup());
        config.setDomainName(conf.getDomainName());
        config.setHost(conf.getHost());
        config.setPort(conf.getPort());
        config.setProtocol(conf.getProtocol());
        config.setRetryInterval(conf.getRetryInterval());
        config.setRetryTimes(conf.getRetryTimes());
        config.setSearchDN(conf.getSearchDN());
        config.setSearchUserDN(conf.getSearchUserDN());
        config.setSearchUserPassword(conf.getSearchUserPassword());
        config.setServerErrCode(conf.getServerErrCode());
        config.setTimeout(conf.getTimeout());
        return config;
    }
}

