/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.account.extauth.selectserver;

import java.util.ArrayList;
import java.util.HashMap;
import sanproject.sn2.base.authentication.module.external.common.SJbaseConfiguration;
import sanproject.sn2.base.authentication.module.external.file.SJbaseExternalFile;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrActionDefine;
import sanproject.sn2.controller.com.model.SJctrButtonDataModel;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.event.SJctrMessageEvent;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.SJctrWizardDataController;
import sanproject.sn2.controller.wizard.account.extauth.com.SJctrExtAuthServerInfo;
import sanproject.sn2.controller.wizard.account.extauth.selectserver.SJctrSelectServerDataModel;
import sanproject.sn2.controller.wizard.account.extauth.selectserver.SJctrUnusedServerConfirmData;

public class SJctrSelectServerDC
extends SJctrWizardDataController {
    private static final int DISP_ID = 0x100C010;
    public static final String TITLE = "SELECT_SERVER";
    SJbaseExternalFile config = null;
    String selectServerType = SJctrExtAuthServerInfo.SERVER_TYPE_NOTHING;
    SJctrSelectServerDataModel selectServerDataModel = null;
    private static final SJctrActionDefine[] ACT_SETUP_SERVER_LDAP = new SJctrActionDefine[]{SJctrActionDefine.ACT_SETUP_SERVER_LDAP};
    private static final SJctrActionDefine[] ACT_SETUP_SERVER_RADIUS = new SJctrActionDefine[]{SJctrActionDefine.ACT_SETUP_SERVER_RADIUS};
    private static final SJctrActionDefine[] ACT_SETUP_SERVER_KERBEROS = new SJctrActionDefine[]{SJctrActionDefine.ACT_SETUP_SERVER_KERBEROS};
    public static int RESULT_NORMAL = 0;

    public SJctrSelectServerDC() throws SJcException {
        super(0x100C010);
        this.initDataModel();
    }

    @Override
    public String getDispName() {
        return this.getComUtility().getGuidance("COMMON", TITLE);
    }

    private void initDataModel() {
        this.addDataObjectModel("COM_EXTSRVINF", new SJctrSelectServerDataModel());
        this.addDataObjectModel("COM_FOOTER", new SJctrFooterDataModel());
    }

    @Override
    public void makeDataModel() {
        super.makeDataModel();
        SJctrFooterDataModel footer = (SJctrFooterDataModel)this.getDataObjectModel("COM_FOOTER");
        SJctrButtonDataModel finishButton = footer.getFooterButtonObject(SJctrFooterDataModel.Button.FINISH);
        finishButton.setChangeCheck(false);
    }

    @Override
    protected void updateFooter() {
        super.updateFooter();
        SJctrFooterDataModel footer = (SJctrFooterDataModel)this.getDataObjectModel("COM_FOOTER");
        footer.setEnableButton(SJctrFooterDataModel.Button.NEXT, true);
    }

    @Override
    public boolean checkStartData() {
        SJbaseConfiguration config_data;
        boolean ret = true;
        this.config = new SJbaseExternalFile();
        String type = this.config.getType();
        HashMap<String, SJbaseConfiguration> config_map = this.config.getConfiguration(type);
        if (config_map != null && (config_data = config_map.get(SJctrExtAuthServerInfo.KEY_SERVER_PRIMARY)) != null) {
            this.selectServerType = this.config.getType();
        }
        return ret;
    }

    @Override
    public boolean checkConstructData() {
        boolean ret = true;
        this.selectServerDataModel = (SJctrSelectServerDataModel)this.getDataObjectModel("COM_EXTSRVINF");
        this.selectServerDataModel.selectRadioButton(this.selectServerType);
        return ret;
    }

    @Override
    public boolean checkEndData() {
        boolean ret = true;
        String type = this.selectServerDataModel.getServerType();
        SJctrExtAuthServerInfo extAuthServerInfo = new SJctrExtAuthServerInfo();
        extAuthServerInfo.setServerType(type);
        ArrayList<SJctrUnusedServerConfirmData> confirmDataList = new ArrayList<SJctrUnusedServerConfirmData>(1);
        SJctrUnusedServerConfirmData confirmData = new SJctrUnusedServerConfirmData(extAuthServerInfo);
        confirmDataList.add(confirmData);
        this.putCache(SJctrUnusedServerConfirmData.UNUSED_SERVER_CONFIRM_DATA, confirmDataList);
        return ret;
    }

    @Override
    protected void nextEvent(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        SJctrFooterDataModel footer = (SJctrFooterDataModel)this.getDataObjectModel("COM_FOOTER");
        if (this.selectServerDataModel.isSelectLdap()) {
            this.logUty.putlog("selectNextTask", "Select ExtAuth Server -> Setup LDAP Server");
            footer.initNextTask(ACT_SETUP_SERVER_LDAP);
        } else if (this.selectServerDataModel.isSelectRadius()) {
            this.logUty.putlog("selectNextTask", "Select ExtAuth Server -> Setup RADIUS Server");
            footer.initNextTask(ACT_SETUP_SERVER_RADIUS);
        } else if (this.selectServerDataModel.isSelectKerberos()) {
            this.logUty.putlog("selectNextTask", "Select ExtAuth Server -> Setup Kerberos Server");
            footer.initNextTask(ACT_SETUP_SERVER_KERBEROS);
        } else {
            footer.initNextTask(ACT_SETUP_SERVER_LDAP);
        }
        super.nextEvent(event, dstModel);
    }

    @Override
    public void selectNextTask(SJctrActionDefine action) {
        this.logUty.putlog("selectNextTask", "Select ExtAuth Server ->" + ((Object)((Object)action)).getClass().getSimpleName());
    }
}

