/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.account.rsg.editrsg;

import java.util.ArrayList;
import java.util.List;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrRsgUtility;
import sanproject.sn2.controller.com.model.SJctrTextBoxDataModel;
import sanproject.sn2.controller.com.model.event.SJctrTextBoxEvent;
import sanproject.sn2.controller.com.model.event.SJctrTextChangeListener;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.account.rsg.com.SJctrRsgInfo;
import sanproject.sn2.controller.wizard.account.rsg.creatersgs.SJctrCreateRsgsDC;
import sanproject.sn2.controller.wizard.account.rsg.editrsg.SJctrEditRsgConfirmData;
import sanproject.sn2.model.data.rsg.SJmoRSGInfo;
import sanproject.sn2.model.data.rsg.SJmoRSGgetRsg;

public class SJctrEditRsgDC
extends SJctrCreateRsgsDC {
    protected static final int DISP_ID = 0x1001121;
    protected static final String DISP_TITLE = "EDIT_RES_GRP";
    protected static final String KEY_INPUT_RSG_NAME = "COM_INPUT_RSG_NAME";

    public SJctrEditRsgDC() throws SJcException {
        super(0x1001121);
        this.initDataModel();
    }

    @Override
    public String getDispName() {
        String dispName = this.getComUtility().getGuidance(DISP_TITLE);
        return dispName;
    }

    @Override
    protected void initDataModel() {
        final SJctrTextBoxDataModel rsgNameTextBox = new SJctrTextBoxDataModel();
        rsgNameTextBox.setValue("");
        rsgNameTextBox.setVisible(true);
        this.addDataObjectModel(KEY_INPUT_RSG_NAME, rsgNameTextBox);
        rsgNameTextBox.addTextChangeListener(new SJctrTextChangeListener(){

            @Override
            public void textChanged(SJctrTextBoxEvent event) {
                rsgNameTextBox.setChangeCheck(true);
                SJctrEditRsgDC.this.setFinishChangeCheck(true);
            }
        });
        this.addDataObjectModel("COM_FOOTER", new SJctrFooterDataModel());
    }

    @Override
    public boolean checkStartData() {
        boolean ret = true;
        List<?> viewDataList = this.getProxy().getCache(SJctrRsgInfo.class);
        if (null == viewDataList) {
            this.logUty.putlog("checkStartData", "Inherited list data is null.");
            SJctrError err = new SJctrError(207, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        if (0 == viewDataList.size()) {
            this.logUty.putlog("checkStartData", "Size of inherited list data is zero.");
            SJctrError err = new SJctrError(207, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        SJctrRsgInfo viewData = (SJctrRsgInfo)viewDataList.get(0);
        if (null == viewData) {
            this.logUty.putlog("checkStartData", "Information of selected RSG is null.");
            SJctrError err = new SJctrError(207, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        return ret;
    }

    @Override
    public boolean checkConstructData() {
        try {
            ArrayList rsgInfoList = (ArrayList)SJctrRsgUtility.getRsgListInfo(this);
            List<?> viewDataList = this.getProxy().getCache(SJctrRsgInfo.class);
            SJctrRsgInfo viewData = (SJctrRsgInfo)viewDataList.get(0);
            SJmoRSGgetRsg editRsgInfo = SJctrRsgUtility.getRsgInfoByRsgId(viewData.getRsgInfo().getRsgInfo().getRsgId(), rsgInfoList);
            if (null == editRsgInfo) {
                this.getLogUty().putlog("checkConstructData", "The resource group to edit does not exist.");
                SJctrError err = new SJctrError(207, 22, 105303);
                SJcException exp = err.createException();
                throw exp;
            }
            if (SJctrRsgUtility.isSysRsg(editRsgInfo.getRsgInfo())) {
                this.getLogUty().putlog("checkConstructData", "Selected RSG is System RSG.");
                throw SJctrRsgUtility.makeException(205171);
            }
            SJctrTextBoxDataModel rsgNameTextBox = (SJctrTextBoxDataModel)this.getDataObjectModel(KEY_INPUT_RSG_NAME);
            rsgNameTextBox.setValue(viewData.getRsgInfo().getRsgInfo().getRsgName());
            rsgNameTextBox.setLabel(this.getComUtility().getGuidance("DISP_RES_GRP_NAME_MAX_CHAR"));
        }
        catch (SJcException e) {
            throw SJctrRsgUtility.convRsgLogicalErr(e, 107002);
        }
        return true;
    }

    @Override
    public boolean checkEndData() {
        try {
            SJctrTextBoxDataModel rsgNameTextBox = (SJctrTextBoxDataModel)this.getDataObjectModel(KEY_INPUT_RSG_NAME);
            String rsgName = rsgNameTextBox.getValue();
            List<?> viewDataList = this.getProxy().getCache(SJctrRsgInfo.class);
            SJctrRsgInfo viewData = (SJctrRsgInfo)viewDataList.get(0);
            SJmoRSGgetRsg editRsgInfo = viewData.getRsgInfo();
            if (rsgName.equals(editRsgInfo.getRsgInfo().getRsgName())) {
                this.getLogUty().putlog("checkEndData", "Resource group name is not edited.");
                SJctrError err = new SJctrError(207, 22, 105287);
                SJcException exp = err.createException();
                throw exp;
            }
            if (SJctrRsgUtility.isInvalidRsgName(rsgName)) {
                this.getLogUty().putlog("checkEndData", "Resource group name is invalid.");
                SJctrError err = new SJctrError(207, 22, 105283);
                SJcException exp = err.createException();
                throw exp;
            }
            ArrayList rsgInfoList = (ArrayList)SJctrRsgUtility.getRsgListInfo(this);
            if (SJctrRsgUtility.isDuplicateRsgName(rsgName, rsgInfoList)) {
                this.getLogUty().putlog("checkEndData", "Resource group name is duplicating.");
                SJctrError err = new SJctrError(207, 22, 105284);
                SJcException exp = err.createException();
                throw exp;
            }
            SJctrEditRsgConfirmData confirmData = new SJctrEditRsgConfirmData();
            SJmoRSGInfo rsgInfo = new SJmoRSGInfo();
            rsgInfo.setRsgName(rsgName);
            rsgInfo.setRsgId(editRsgInfo.getRsgInfo().getRsgId());
            rsgInfo.setVboxIndex(editRsgInfo.getRsgInfo().getVboxIndex());
            SJmoRSGgetRsg setRsg = new SJmoRSGgetRsg();
            setRsg.setRsgInfo(rsgInfo);
            setRsg.setVdevs(editRsgInfo.getVdevs());
            setRsg.setLdevs(editRsgInfo.getLdevs());
            setRsg.setPorts(editRsgInfo.getPorts());
            setRsg.setHostGrps(editRsgInfo.getHostGrps());
            SJctrRsgInfo setRsgInfo = new SJctrRsgInfo(setRsg);
            ArrayList<SJctrRsgInfo> confirmList = new ArrayList<SJctrRsgInfo>();
            confirmList.add(setRsgInfo);
            confirmData.setEditRsgInfo(confirmList);
            confirmData.setNeedData(this);
            ArrayList<SJctrEditRsgConfirmData> confirmDataList = new ArrayList<SJctrEditRsgConfirmData>();
            confirmDataList.add(confirmData);
            this.putCache(SJctrEditRsgConfirmData.class, confirmDataList);
            this.setFinishChangeCheck(false);
        }
        catch (SJcException e) {
            throw SJctrRsgUtility.convRsgLogicalErr(e, 107003);
        }
        return true;
    }
}

