/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.account.rsg.editvirtualmng;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrLicenseContainer;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrRsgUtility;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.controller.com.model.SJctrComboBoxDataModel;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.SJctrRadioButtonGroupDataModel;
import sanproject.sn2.controller.com.model.SJctrTextBoxDataModel;
import sanproject.sn2.controller.com.model.event.SJctrMessageEvent;
import sanproject.sn2.controller.com.model.event.SJctrMessageEventListener;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.account.rsg.com.SJctrRsgInfo;
import sanproject.sn2.controller.wizard.account.rsg.com.SJctrRsgLdevInfo;
import sanproject.sn2.controller.wizard.account.rsg.creatersgs.SJctrCreateRsgsDC;
import sanproject.sn2.controller.wizard.account.rsg.editvirtualmng.SJctrEditVirtualManageSetConfirmData;
import sanproject.sn2.controller.wizard.account.rsg.editvirtualmng.SJctrEditVirtualManageSetConst;
import sanproject.sn2.controller.wizard.account.rsg.editvirtualmng.model.SJctrInitialVirtualLDEVIdDataModel;
import sanproject.sn2.controller.wizard.account.rsg.editvirtualmng.model.SJctrVirtualConfigurationDataModel;
import sanproject.sn2.controller.wizard.account.rsg.editvirtualmng.model.SJctrVirtualManageSettingDataModel;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetHUVMVirtualDkc;
import sanproject.sn2.model.connector.kind.SJmoGetHUVMVirtualLdev;
import sanproject.sn2.model.connector.kind.SJmoGetLdevDetail;
import sanproject.sn2.model.connector.kind.SJmoGetRSGgetAllRsgs;
import sanproject.sn2.model.data.huvm.SJmoHUVMVirtualLdev;
import sanproject.sn2.model.data.huvm.SJmoHUVMvboxIndex;
import sanproject.sn2.model.data.rsg.SJmoRSGgetRsg;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;
import sanproject.sn2.model.inf.SJmoDataMacro_IF;

public class SJctrEditVirtualManageSetDC
extends SJctrCreateRsgsDC {
    protected static final int DISP_ID = 0x1102001;
    protected static final String DISP_TITLE = "EDIT_VIRTUAL_MANAGE_SET";
    private int enableOperation = 0;

    public SJctrEditVirtualManageSetDC() {
        super(0x1102001);
        this.initDataModel();
        this.initListener();
    }

    @Override
    public String getDispName() {
        return this.getComUtility().getGuidance(DISP_TITLE);
    }

    @Override
    protected void initDataModel() {
        SJctrVirtualManageSettingDataModel virtualManageSetModel = new SJctrVirtualManageSettingDataModel();
        this.addDataObjectModel("COM_VIRTUAL_MANAGE_SET_AREA", virtualManageSetModel);
        SJctrInitialVirtualLDEVIdDataModel initVirtualLDEV = new SJctrInitialVirtualLDEVIdDataModel();
        this.addDataObjectModel("COM_INIT_VIRTUAL_LDEV_AREA", initVirtualLDEV);
        SJctrVirtualConfigurationDataModel virtualConfig = new SJctrVirtualConfigurationDataModel();
        this.addDataObjectModel("COM_VIRTUAL_CONFIG_AREA", virtualConfig);
        this.addDataObjectModel("COM_FOOTER", new SJctrFooterDataModel());
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        Set<SJctrGetDirectWrapper> set = super.getModelDirect();
        SJmoGetKind_IF kind = new SJmoGetRSGgetAllRsgs();
        SJmoGetRange_IF range = null;
        ArrayList filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetLdevDetail();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetHUVMVirtualDkc();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetHUVMVirtualLdev();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        return set;
    }

    @Override
    public boolean checkStartData() {
        boolean ret = true;
        List<?> viewDataList = this.getProxy().getCache(SJctrRsgInfo.class);
        if (viewDataList == null) {
            this.logUty.putlog("checkStartData", "Inherited list data is null.");
            SJctrError err = new SJctrError(207, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        if (viewDataList.size() == 0) {
            this.logUty.putlog("checkStartData", "Size of inherited list data is zero.");
            SJctrError err = new SJctrError(207, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        return ret;
    }

    @Override
    protected void initListener() {
        this.addMessageEventListener(SJctrEditVirtualManageSetConst.EDIT_VIRTUAL_MANAGE_SET_MSG.SELECT_VIRTUAL_MANAGE_SET, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrEditVirtualManageSetDC.this.setEnableEventListner(false);
                SJctrEditVirtualManageSetDC.this.makeVirtualLdevIdDataModel();
                SJctrEditVirtualManageSetDC.this.makeVirtualConfigrationDataModel();
                SJctrEditVirtualManageSetDC.this.setEnableEventListner(true);
            }
        });
        this.addMessageEventListener(SJctrEditVirtualManageSetConst.EDIT_VIRTUAL_MANAGE_SET_MSG.SELECT_VIRTUAL_CONFIG, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrEditVirtualManageSetDC.this.setEnableEventListner(false);
                SJctrEditVirtualManageSetDC.this.makeVirtualConfigrationInfoDataModel();
                SJctrEditVirtualManageSetDC.this.setEnableEventListner(true);
            }
        });
    }

    @Override
    public boolean checkConstructData() {
        try {
            SJctrUserController uc = this.getOwner();
            List<Object> info = new ArrayList();
            info = this.getProxy().getCache(SJctrRsgInfo.class.getName());
            if (null == info) {
                uc.getLogUty().putlog("checkConstructData", "Information of SJctrRsgInfo is null.");
                SJctrError err = new SJctrError(207, 22, 107001);
                SJcException exp = err.createException();
                throw exp;
            }
            if (info.size() == 0) {
                uc.getLogUty().putlog("checkConstructData", "Size of SJctrRsgInfo data list is zero.");
                SJctrError err = new SJctrError(207, 22, 107001);
                SJcException exp = err.createException();
                throw exp;
            }
            SJmoRSGgetRsg rsgInfo = ((SJctrRsgInfo)info.get(0)).getRsgInfo();
            ArrayList rsgInfoList = (ArrayList)SJctrRsgUtility.getRsgListInfo(this);
            SJmoRSGgetRsg targetRsgInfo = SJctrRsgUtility.getRsgInfoByRsgId(rsgInfo.getRsgInfo().getRsgId(), rsgInfoList);
            if (null == targetRsgInfo) {
                uc.getLogUty().putlog("checkConstructData", "The resource group to edit does not exist.");
                SJctrError err = new SJctrError(207, 22, 105303);
                SJcException exp = err.createException();
                throw exp;
            }
            if (SJctrRsgUtility.isSysRsg(targetRsgInfo.getRsgInfo())) {
                this.getLogUty().putlog("checkConstructData", "Selected RSG is System RSG.");
                throw SJctrRsgUtility.makeException(205173);
            }
            ArrayList<SJmoLdevIndex> checkLdevList = rsgInfo.getLdevs();
            if (checkLdevList.size() > 0) {
                List<SJmoLdevDetail> ldevDetailList = SJctrRsgUtility.getSJmoLdevDetail(this);
                List<SJmoHUVMVirtualLdev> vLdevList = SJctrRsgUtility.getSJmoHUVMVirtualLdev(this);
                List<SJctrRsgLdevInfo> exLdevInfoList = SJctrRsgUtility.createRsgLdevInfoList(checkLdevList, ldevDetailList, vLdevList);
                this.enableOperation = this.getEnableOperation(exLdevInfoList);
                if (this.enableOperation != 0 && this.enableOperation != 255) {
                    this.enableOperation = this.isEnableReserveVirtualLdevId(this.enableOperation, exLdevInfoList);
                }
                if (this.enableOperation == 0) {
                    uc.getLogUty().putlog("checkConstructData", "Selected ldev can not execute(combination error).");
                    SJctrError err = new SJctrError(207, 22, 205113);
                    SJcException exp = err.createException();
                    throw exp;
                }
                if (this.enableOperation == 255) {
                    uc.getLogUty().putlog("checkConstructData", "Selected ldev can not execute(LDEV is invalid).");
                    SJctrError err = new SJctrError(207, 22, 107001);
                    SJcException exp = err.createException();
                    throw exp;
                }
                this.enableOperation = this.getEnableOperationByLdevState(exLdevInfoList, this.enableOperation);
                this.putCache("KEY_SELECTED_LDEV", exLdevInfoList);
            }
        }
        catch (SJcException e) {
            throw SJctrRsgUtility.convRsgLogicalErr(e, 107002);
        }
        return true;
    }

    private int getEnableOperation(List<SJctrRsgLdevInfo> ldevInfoList) {
        int enableOperation = 0;
        for (int i = 0; i < ldevInfoList.size(); ++i) {
            boolean isVirtualLdevInfoSet;
            boolean isVirtualLdevIdSameLdevId;
            boolean isVirtualLdevIdReserve;
            boolean isVdkcNumberZero;
            SJctrRsgLdevInfo checkLdev = ldevInfoList.get(i);
            boolean isVirtualLdevHuvmOn = SJctrRsgUtility.isVirtualLdevHuvmOn(checkLdev.getVLDEV());
            int enableOperation1Ldev = this.getEnableOperation1Ldev(isVirtualLdevHuvmOn, isVdkcNumberZero = !SJctrRsgUtility.isVdkcNumberNotZero(checkLdev.getVLDEV()), isVirtualLdevIdReserve = SJctrRsgUtility.isVirtualLdevIdReserve(checkLdev.getVLDEV()), isVirtualLdevIdSameLdevId = SJctrRsgUtility.isVirtualLdevIdSameLdevId(checkLdev.getVLDEV()), isVirtualLdevInfoSet = SJctrRsgUtility.isVirtualLdevInfoSet(checkLdev.getVLDEV()));
            if (enableOperation1Ldev == 0 || enableOperation1Ldev == 255) {
                return enableOperation1Ldev;
            }
            if (i == 0) {
                enableOperation = enableOperation1Ldev;
                continue;
            }
            enableOperation &= enableOperation1Ldev;
        }
        return enableOperation;
    }

    private int getEnableOperation1Ldev(boolean isVirtualLdevHuvmOn, boolean isVdkcNumberZero, boolean isVirtualLdevIdReserve, boolean isVirtualLdevIdSameLdevId, boolean isVirtualLdevInfoSet) {
        int enableOperation = 0;
        enableOperation = isVirtualLdevHuvmOn ? (isVdkcNumberZero ? this.getEnableOperationHuvmOnVdkc0(isVirtualLdevIdReserve, isVirtualLdevIdSameLdevId, isVirtualLdevInfoSet) : this.getEnableOperationHuvmOnVdkcNot0(isVirtualLdevIdReserve, isVirtualLdevIdSameLdevId, isVirtualLdevInfoSet)) : this.getEnableOperationHuvmOff(isVirtualLdevIdReserve, isVirtualLdevIdSameLdevId, isVirtualLdevInfoSet);
        return enableOperation;
    }

    private int getEnableOperationHuvmOnVdkc0(boolean isVirtualLdevIdReserve, boolean isVirtualLdevIdSameLdevId, boolean isVirtualLdevInfoSet) {
        int enableOperation = 0;
        if (isVirtualLdevIdReserve) {
            if (isVirtualLdevIdSameLdevId) {
                if (isVirtualLdevInfoSet) {
                    enableOperation = 255;
                } else {
                    enableOperation |= 0x10;
                    enableOperation |= 2;
                }
            } else if (isVirtualLdevInfoSet) {
                enableOperation |= 0x40;
                enableOperation |= 0x100;
            } else {
                enableOperation |= 0x20;
                enableOperation |= 0x10;
            }
        } else if (isVirtualLdevInfoSet) {
            enableOperation = 255;
        } else {
            enableOperation |= 8;
            enableOperation |= 0x80;
            enableOperation |= 4;
        }
        return enableOperation;
    }

    private int getEnableOperationHuvmOnVdkcNot0(boolean isVirtualLdevIdReserve, boolean isVirtualLdevIdSameLdevId, boolean isVirtualLdevInfoSet) {
        int enableOperation = 0;
        if (isVirtualLdevIdReserve) {
            if (isVirtualLdevInfoSet) {
                enableOperation |= 0x40;
                enableOperation |= 0x100;
            } else {
                enableOperation |= 0x20;
                enableOperation |= 0x10;
            }
        } else if (isVirtualLdevInfoSet) {
            enableOperation = 255;
        } else {
            enableOperation |= 8;
            enableOperation |= 0x80;
        }
        return enableOperation;
    }

    private int getEnableOperationHuvmOff(boolean isVirtualLdevIdReserve, boolean isVirtualLdevIdSameLdevId, boolean isVirtualLdevInfoSet) {
        int enableOperation = 0;
        enableOperation = isVirtualLdevIdReserve ? (isVirtualLdevIdSameLdevId ? (enableOperation |= 1) : 255) : 255;
        return enableOperation;
    }

    private int isEnableReserveVirtualLdevId(int enableOperation, List<SJctrRsgLdevInfo> rsgLdevInfoList) {
        if (!((enableOperation & 8) != 8 && (enableOperation & 0x80) != 128 || this.isEnableReserveVirtualLdevIDHuvmOn(rsgLdevInfoList))) {
            enableOperation &= 0xFFFFFFF7;
            enableOperation &= 0xFFFFFF7F;
        }
        if ((enableOperation & 4) == 4 && !this.isEnableReserveVirtualLdevIDHuvmOff(rsgLdevInfoList)) {
            enableOperation &= 0xFFFFFFFB;
        }
        return enableOperation;
    }

    private boolean isEnableReserveVirtualLdevIDHuvmOn(List<SJctrRsgLdevInfo> ldevInfoList) {
        boolean ret = true;
        SJmoHUVMvboxIndex vBoxIndex = ldevInfoList.get(0).getVLDEV().getVBoxIndex();
        Set<Integer> useVLdevIndexList = SJctrRsgUtility.createUseVLdevIndexListVdkc(this, vBoxIndex);
        int interval = 1;
        int baseCuLdev = SJctrEditVirtualManageSetDC.getCuLdev(0, 0);
        baseCuLdev -= interval;
        for (int i = 0; i < ldevInfoList.size(); ++i) {
            if ((baseCuLdev = SJctrEditVirtualManageSetDC.getNextIndex(baseCuLdev, interval, useVLdevIndexList, ldevInfoList.get(i))) != -1) continue;
            ret = false;
            break;
        }
        return ret;
    }

    private boolean isEnableReserveVirtualLdevIDHuvmOff(List<SJctrRsgLdevInfo> ldevInfoList) {
        boolean ret = true;
        SJmoHUVMvboxIndex vBoxIndex = ldevInfoList.get(0).getVLDEV().getVBoxIndex();
        Set<Integer> useVLdevIndexList = SJctrRsgUtility.createUseVLdevIndexListVdkc(this, vBoxIndex);
        for (int i = 0; i < ldevInfoList.size(); ++i) {
            SJctrRsgLdevInfo targetLdev = ldevInfoList.get(i);
            int ldevIndex = SJctrEditVirtualManageSetDC.getCuLdev(targetLdev.getSCu(), targetLdev.getSLdev());
            if (!useVLdevIndexList.contains(ldevIndex)) continue;
            ret = false;
            break;
        }
        return ret;
    }

    private int getEnableOperationByLdevState(List<SJctrRsgLdevInfo> ldevInfoList, int enableOperation) {
        int code;
        int firstError = 0;
        SJctrUserController uc = this.getOwner();
        SJctrLicenseContainer lc = uc.getAuthorizeContainer().getLisenceContainer();
        if ((enableOperation & 1) == 1) {
            code = SJctrRsgUtility.checkOperationHuvmOn(ldevInfoList, lc);
            enableOperation = this.checkOperationEnableCheckError(code, 1, enableOperation);
            firstError = this.checkOperationEnableFirstError(code, firstError);
        }
        if ((enableOperation & 2) == 2) {
            code = SJctrRsgUtility.checkOperationHuvmOff(ldevInfoList);
            enableOperation = this.checkOperationEnableCheckError(code, 2, enableOperation);
            firstError = this.checkOperationEnableFirstError(code, firstError);
        }
        if ((enableOperation & 4) == 4) {
            code = SJctrRsgUtility.checkOperationVirtualLdevIdReserveHuvmOff(ldevInfoList);
            enableOperation = this.checkOperationEnableCheckError(code, 4, enableOperation);
            firstError = this.checkOperationEnableFirstError(code, firstError);
        }
        if ((enableOperation & 0x80) == 128) {
            code = SJctrRsgUtility.checkOperationVirtualLdevIdReserveVirtualLdevInfoSet(ldevInfoList);
            enableOperation = this.checkOperationEnableCheckError(code, 128, enableOperation);
            firstError = this.checkOperationEnableFirstError(code, firstError);
        }
        if ((enableOperation & 0x100) == 256) {
            code = SJctrRsgUtility.checkOperationVirtualLdevIdReleaseVirtualLdevInfoRemove(ldevInfoList);
            enableOperation = this.checkOperationEnableCheckError(code, 256, enableOperation);
            firstError = this.checkOperationEnableFirstError(code, firstError);
        }
        if ((enableOperation & 8) == 8) {
            code = SJctrRsgUtility.checkOperationVirtualLdevIdReserve(ldevInfoList);
            enableOperation = this.checkOperationEnableCheckError(code, 8, enableOperation);
            firstError = this.checkOperationEnableFirstError(code, firstError);
        }
        if ((enableOperation & 0x10) == 16) {
            code = SJctrRsgUtility.checkOperationVirtualLdevIdRelease(ldevInfoList);
            enableOperation = this.checkOperationEnableCheckError(code, 16, enableOperation);
            firstError = this.checkOperationEnableFirstError(code, firstError);
        }
        if ((enableOperation & 0x20) == 32) {
            code = SJctrRsgUtility.checkOperationVirtualLdevInfoSet(ldevInfoList);
            enableOperation = this.checkOperationEnableCheckError(code, 32, enableOperation);
            firstError = this.checkOperationEnableFirstError(code, firstError);
        }
        if ((enableOperation & 0x40) == 64) {
            code = SJctrRsgUtility.checkOperationVirtualLdevInfoRemove(ldevInfoList);
            enableOperation = this.checkOperationEnableCheckError(code, 64, enableOperation);
            firstError = this.checkOperationEnableFirstError(code, firstError);
        }
        if (enableOperation == 0) {
            uc.getLogUty().putlog("getEnableOperationByLdevState", "Selected ldev can not execute(LDEV is invalid).");
            SJctrError err = new SJctrError(207, 22, this.getErrorToMessageCode(firstError));
            SJcException exp = err.createException();
            throw exp;
        }
        return enableOperation;
    }

    private int checkOperationEnableCheckError(int code, int targetOperation, int enableOperation) {
        if (code != 0) {
            enableOperation &= ~targetOperation;
        }
        return enableOperation;
    }

    private int checkOperationEnableFirstError(int code, int error) {
        if (code != 0 && error == 0) {
            error = code;
        }
        return error;
    }

    private int getErrorToMessageCode(int code) {
        int error = 0;
        switch (code) {
            case 4: {
                error = 205112;
                break;
            }
            case 8: {
                error = 205111;
                break;
            }
            case 16: {
                error = 205105;
                break;
            }
            case 32: {
                error = 205110;
                break;
            }
            case 64: {
                error = 205100;
                break;
            }
            case 16384: {
                error = 205108;
                break;
            }
            case 32768: {
                error = 205109;
                break;
            }
            case 65536: {
                error = 205107;
            }
        }
        return error;
    }

    @Override
    public void makeDataModel() {
        this.setEnableEventListner(false);
        super.makeDataModel();
        this.makeVirtualManageSetComboBoxDataModel(this.enableOperation);
        this.makeVirtualLdevIdDataModel();
        this.makeVirtualConfigrationDataModel();
        this.setEnableEventListner(true);
    }

    private void makeVirtualManageSetComboBoxDataModel(int enableOperation) {
        SJctrVirtualManageSettingDataModel virtualMngSetModel = this.getVirtualManageSettingDataModel();
        SJctrComboBoxDataModel comboBoxModel = virtualMngSetModel.getVirtualManageSetComboBoxDataModel();
        comboBoxModel.addItem("");
        if ((enableOperation & 8) == 8 || (enableOperation & 0x80) == 128 || (enableOperation & 0x20) == 32 || (enableOperation & 0x40) == 64) {
            comboBoxModel.addItem(String.valueOf(0), this.getComUtility().getGuidance("ENABLE"));
        }
        if ((enableOperation & 1) == 1 || (enableOperation & 0x10) == 16 || (enableOperation & 0x100) == 256) {
            comboBoxModel.addItem(String.valueOf(1), this.getComUtility().getGuidance("ENABLE_NOT_SET"));
        }
        if ((enableOperation & 2) == 2 || (enableOperation & 4) == 4) {
            comboBoxModel.addItem(String.valueOf(2), this.getComUtility().getGuidance("DISABLE"));
        }
        comboBoxModel.setSelection("");
    }

    private void makeVirtualLdevIdDataModel() {
        SJctrVirtualManageSettingDataModel virtualMngSetModel = this.getVirtualManageSettingDataModel();
        SJctrComboBoxDataModel virtualMngSetcomboBoxModel = virtualMngSetModel.getVirtualManageSetComboBoxDataModel();
        String selectedVirtualMngSet = virtualMngSetcomboBoxModel.getSelection();
        List<Object> ldevInfoList = new ArrayList();
        ldevInfoList = this.getProxy().getCache("KEY_SELECTED_LDEV");
        SJctrInitialVirtualLDEVIdDataModel virtualLdevIdModel = this.getInitialVirtualLDEVIdDataModel();
        SJctrTextBoxDataModel ldkcTextBoxModel = virtualLdevIdModel.getLdkcTextDataModel();
        SJctrComboBoxDataModel cuComboBoxModel = virtualLdevIdModel.getCuSelectDataModel();
        SJctrComboBoxDataModel devComboBoxModel = virtualLdevIdModel.getDevSelectDataModel();
        SJctrComboBoxDataModel intervalComboBoxModel = virtualLdevIdModel.getIntervalSelectDataModel();
        boolean isEnable = false;
        if (selectedVirtualMngSet.equals(String.valueOf(0))) {
            if ((this.enableOperation & 8) == 8 || (this.enableOperation & 0x80) == 128) {
                int i;
                ldkcTextBoxModel.setValue("00");
                for (i = 0; i <= 254; ++i) {
                    cuComboBoxModel.addItem(SJctrComUtility.toHexString(i, 2, true));
                }
                cuComboBoxModel.setSelectedIndex(0);
                for (i = 0; i <= 255; ++i) {
                    devComboBoxModel.addItem(SJctrComUtility.toHexString(i, 2, true));
                }
                devComboBoxModel.setSelectedIndex(0);
                for (i = 0; i <= 255; ++i) {
                    intervalComboBoxModel.addItem(String.valueOf(i));
                }
                intervalComboBoxModel.setSelectedIndex(0);
                isEnable = true;
            } else if ((this.enableOperation & 0x20) == 32 || (this.enableOperation & 0x40) == 64) {
                if (ldevInfoList.size() > 1) {
                    ldkcTextBoxModel.setValue("");
                    cuComboBoxModel.setSelection("");
                    devComboBoxModel.setSelection("");
                    intervalComboBoxModel.setSelection("");
                    isEnable = false;
                } else {
                    SJmoHUVMVirtualLdev vLdevInfo = ((SJctrRsgLdevInfo)ldevInfoList.get(0)).getVLDEV();
                    SJmoLdevIndex vLdevIndex = vLdevInfo.getVirtualLdev();
                    short ldkcNo = vLdevIndex.getSLdkc();
                    ldkcTextBoxModel.setValue(SJctrComUtility.toHexString(ldkcNo, 2, true));
                    short cuNo = vLdevIndex.getSCu();
                    cuComboBoxModel.addItem(SJctrComUtility.toHexString(cuNo, 2, true));
                    short devNo = vLdevIndex.getSLdev();
                    devComboBoxModel.addItem(SJctrComUtility.toHexString(devNo, 2, true));
                    intervalComboBoxModel.setSelection("");
                    isEnable = false;
                }
            }
        } else {
            cuComboBoxModel.removeAllItems();
            devComboBoxModel.removeAllItems();
            intervalComboBoxModel.removeAllItems();
            ldkcTextBoxModel.setValue("");
            cuComboBoxModel.setSelection("");
            devComboBoxModel.setSelection("");
            intervalComboBoxModel.setSelection("");
            isEnable = false;
        }
        ldkcTextBoxModel.setEnable(false);
        cuComboBoxModel.setEnable(isEnable);
        devComboBoxModel.setEnable(isEnable);
        intervalComboBoxModel.setEnable(isEnable);
        virtualLdevIdModel.setDirtyAll();
    }

    private void makeVirtualConfigrationDataModel() {
        SJctrVirtualManageSettingDataModel virtualMngSetModel = this.getVirtualManageSettingDataModel();
        SJctrComboBoxDataModel virtualMngSetcomboBoxModel = virtualMngSetModel.getVirtualManageSetComboBoxDataModel();
        String selectedVirtualMngSet = virtualMngSetcomboBoxModel.getSelection();
        SJctrVirtualConfigurationDataModel virtualConfigurationModel = this.getVirtualConfigurationDataModel();
        SJctrRadioButtonGroupDataModel virtualConfigRadioModel = virtualConfigurationModel.getVirtualConfigurationRadioDataModel();
        this.makeVirtualConfigrationRadioButtonDataModel(selectedVirtualMngSet, virtualConfigRadioModel);
        this.makeVirtualConfigrationInfoDataModel();
    }

    private void makeVirtualConfigrationInfoDataModel() {
        SJctrVirtualManageSettingDataModel virtualMngSetModel = this.getVirtualManageSettingDataModel();
        SJctrComboBoxDataModel virtualMngSetcomboBoxModel = virtualMngSetModel.getVirtualManageSetComboBoxDataModel();
        String selectedVirtualMngSet = virtualMngSetcomboBoxModel.getSelection();
        SJctrVirtualConfigurationDataModel virtualConfigurationModel = this.getVirtualConfigurationDataModel();
        SJctrRadioButtonGroupDataModel virtualConfigRadioModel = virtualConfigurationModel.getVirtualConfigurationRadioDataModel();
        String selectedVirtualConfig = virtualConfigRadioModel.getSelect();
        SJctrComboBoxDataModel emuTypeSelectDataModel = virtualConfigurationModel.getEmuTypeSelectDataModel();
        this.makeEmulationTypeComboBoxDataModel(selectedVirtualMngSet, selectedVirtualConfig, emuTypeSelectDataModel);
        SJctrRadioButtonGroupDataModel cvsSettingRadio = virtualConfigurationModel.getCvsSettingRadioDataModel();
        this.makeCVSSettingsRadioButtonDataModel(selectedVirtualMngSet, selectedVirtualConfig, cvsSettingRadio);
        SJctrTextBoxDataModel numOfConcatLdevText = virtualConfigurationModel.getNumOfConcatLdevTextDataModel();
        this.makeNumOfConcatLdevTextBoxDataModel(selectedVirtualMngSet, selectedVirtualConfig, numOfConcatLdevText);
        SJctrTextBoxDataModel ssidText = virtualConfigurationModel.getSsidTextDataModel();
        this.makeSSIDTextBoxDataModel(selectedVirtualMngSet, selectedVirtualConfig, ssidText);
    }

    private void makeVirtualConfigrationRadioButtonDataModel(String selectedVirtualMngSet, SJctrRadioButtonGroupDataModel virtualConfigRadioModel) {
        String selectedItem = "";
        boolean isEnableSpecifyRadio = false;
        boolean isEnableNotSetRadio = false;
        if (selectedVirtualMngSet.equals(String.valueOf(0))) {
            if ((this.enableOperation & 8) == 8 || (this.enableOperation & 0x80) == 128) {
                selectedItem = "COM_VIRTUAL_CONFIG_NOTSET";
                isEnableSpecifyRadio = true;
                isEnableNotSetRadio = true;
            } else if ((this.enableOperation & 0x20) == 32) {
                selectedItem = "COM_VIRTUAL_CONFIG_SPECIFY";
                isEnableSpecifyRadio = true;
                isEnableNotSetRadio = false;
            } else if ((this.enableOperation & 0x40) == 64) {
                selectedItem = "COM_VIRTUAL_CONFIG_NOTSET";
                isEnableSpecifyRadio = false;
                isEnableNotSetRadio = true;
            }
        }
        virtualConfigRadioModel.add("COM_VIRTUAL_CONFIG_SPECIFY");
        virtualConfigRadioModel.add("COM_VIRTUAL_CONFIG_NOTSET");
        virtualConfigRadioModel.setSelect(selectedItem);
        virtualConfigRadioModel.setEnable("COM_VIRTUAL_CONFIG_SPECIFY", isEnableSpecifyRadio);
        virtualConfigRadioModel.setEnable("COM_VIRTUAL_CONFIG_NOTSET", isEnableNotSetRadio);
        virtualConfigRadioModel.setDirtyAll();
    }

    private void makeEmulationTypeComboBoxDataModel(String selectedVirtualMngSet, String selectedVirtualConfig, SJctrComboBoxDataModel emuTypeSelectDataModel) {
        String selectedItem = "";
        boolean isEnable = false;
        emuTypeSelectDataModel.removeAllItems();
        if (selectedVirtualMngSet.equals(String.valueOf(0)) && selectedVirtualConfig != null && selectedVirtualConfig.equals("COM_VIRTUAL_CONFIG_SPECIFY")) {
            this.createEmulationTypeComboBoxDataModel(emuTypeSelectDataModel);
            selectedItem = "";
            isEnable = true;
        }
        emuTypeSelectDataModel.setSelection(selectedItem);
        emuTypeSelectDataModel.setEnable(isEnable);
        emuTypeSelectDataModel.setDirty();
    }

    private void createEmulationTypeComboBoxDataModel(SJctrComboBoxDataModel model) {
        model.addItem("");
        model.addItem(String.valueOf(659), this.getComUtility().getGuidance("OPEN3"));
        model.addItem(String.valueOf(664), this.getComUtility().getGuidance("OPEN8"));
        model.addItem(String.valueOf(665), this.getComUtility().getGuidance("OPEN9"));
        model.addItem(String.valueOf(663), this.getComUtility().getGuidance("OPENE"));
        model.addItem(String.valueOf(643), this.getComUtility().getGuidance("OPENK"));
        model.addItem(String.valueOf(576), this.getComUtility().getGuidance("OPENL"));
        model.addItem(String.valueOf(625), this.getComUtility().getGuidance("OPENV"));
    }

    private void makeCVSSettingsRadioButtonDataModel(String selectedVirtualMngSet, String selectedVirtualConfig, SJctrRadioButtonGroupDataModel cvsSettingRadio) {
        String selectedItem = "";
        boolean isEnableEnableRadio = false;
        boolean isEnableDisableRadio = false;
        if (selectedVirtualMngSet.equals(String.valueOf(0)) && selectedVirtualConfig != null && selectedVirtualConfig.equals("COM_VIRTUAL_CONFIG_SPECIFY")) {
            selectedItem = "";
            isEnableEnableRadio = true;
            isEnableDisableRadio = true;
        }
        cvsSettingRadio.add("COM_CVS_SETTINGS_ENABLE");
        cvsSettingRadio.add("COM_CVS_SETTINGS_DISABLE");
        cvsSettingRadio.setSelect(selectedItem);
        cvsSettingRadio.setEnable("COM_CVS_SETTINGS_ENABLE", isEnableEnableRadio);
        cvsSettingRadio.setEnable("COM_CVS_SETTINGS_DISABLE", isEnableDisableRadio);
        cvsSettingRadio.setDirty();
    }

    private void makeNumOfConcatLdevTextBoxDataModel(String selectedVirtualMngSet, String selectedVirtualConfig, SJctrTextBoxDataModel numOfConcatLdevText) {
        String value = "";
        String min = "";
        String max = "";
        boolean isEnable = false;
        if (selectedVirtualMngSet.equals(String.valueOf(0)) && selectedVirtualConfig != null && selectedVirtualConfig.equals("COM_VIRTUAL_CONFIG_SPECIFY")) {
            value = "";
            min = "1";
            max = "36";
            isEnable = true;
        }
        numOfConcatLdevText.setValue(value);
        numOfConcatLdevText.setMin(min);
        numOfConcatLdevText.setMax(max);
        numOfConcatLdevText.setEnable(isEnable);
        numOfConcatLdevText.setDirty();
    }

    private void makeSSIDTextBoxDataModel(String selectedVirtualMngSet, String selectedVirtualConfig, SJctrTextBoxDataModel ssidText) {
        String value = "";
        String min = "";
        String max = "";
        boolean isEnable = false;
        if (selectedVirtualMngSet.equals(String.valueOf(0)) && selectedVirtualConfig != null && selectedVirtualConfig.equals("COM_VIRTUAL_CONFIG_SPECIFY")) {
            value = "";
            min = "0004";
            max = "FFFE";
            isEnable = true;
        }
        ssidText.setValue(value);
        ssidText.setMin(min);
        ssidText.setMax(max);
        ssidText.setEnable(isEnable);
        ssidText.setDirty();
    }

    private void setEnableEventListner(boolean flg) {
        SJctrVirtualManageSettingDataModel virtualMngSetModel = this.getVirtualManageSettingDataModel();
        SJctrInitialVirtualLDEVIdDataModel virtualLdevIdModel = this.getInitialVirtualLDEVIdDataModel();
        SJctrVirtualConfigurationDataModel virtualConfigurationModel = this.getVirtualConfigurationDataModel();
        SJctrComboBoxDataModel virtualMngSetComboBoxModel = virtualMngSetModel.getVirtualManageSetComboBoxDataModel();
        SJctrComboBoxDataModel cuComboBoxModel = virtualLdevIdModel.getCuSelectDataModel();
        SJctrComboBoxDataModel devComboBoxModel = virtualLdevIdModel.getDevSelectDataModel();
        SJctrComboBoxDataModel intervalComboBoxModel = virtualLdevIdModel.getIntervalSelectDataModel();
        SJctrRadioButtonGroupDataModel virtualConfigRadioModel = virtualConfigurationModel.getVirtualConfigurationRadioDataModel();
        SJctrComboBoxDataModel emuTypeSelectDataModel = virtualConfigurationModel.getEmuTypeSelectDataModel();
        SJctrRadioButtonGroupDataModel cvsSettingRadio = virtualConfigurationModel.getCvsSettingRadioDataModel();
        SJctrTextBoxDataModel numOfConcatLdevText = virtualConfigurationModel.getNumOfConcatLdevTextDataModel();
        SJctrTextBoxDataModel ssidText = virtualConfigurationModel.getSsidTextDataModel();
        virtualMngSetComboBoxModel.setEnableListener(flg);
        virtualConfigRadioModel.setEnableListener(flg);
        emuTypeSelectDataModel.setEnableListener(flg);
        cvsSettingRadio.setEnableListener(flg);
        numOfConcatLdevText.setEnableListener(flg);
        ssidText.setEnableListener(flg);
        cuComboBoxModel.setEnableListener(flg);
        devComboBoxModel.setEnableListener(flg);
        intervalComboBoxModel.setEnableListener(flg);
    }

    @Override
    public boolean checkEndData() {
        try {
            SJctrEditVirtualManageSetConfirmData confirmData = new SJctrEditVirtualManageSetConfirmData();
            List<SJctrRsgLdevInfo> ldevInfoList = this.getCache("KEY_SELECTED_LDEV");
            int ope = this.getExecuteOperationCode();
            confirmData.setOperation(ope);
            ArrayList<SJctrRsgLdevInfo> basicDataList = new ArrayList();
            switch (ope) {
                case 4: {
                    basicDataList = this.SetBasicDataListOpeHuvmOffReserveId(ldevInfoList);
                    break;
                }
                case 8: {
                    basicDataList = this.SetBasicDataListOpeReserveId(ldevInfoList);
                    break;
                }
                case 32: {
                    basicDataList = this.SetBasicDataListOpeSetLdevInfo(ldevInfoList);
                    break;
                }
                case 2: 
                case 64: {
                    basicDataList = this.SetBasicDataListOpeNotSetLdevInfo(ldevInfoList);
                    break;
                }
                case 128: {
                    basicDataList = this.SetBasicDataListOpeReseveIdSetLdevInfo(ldevInfoList);
                    break;
                }
                case 1: 
                case 16: 
                case 256: {
                    basicDataList = this.SetBasicDataListOpeOther(ldevInfoList);
                    break;
                }
                default: {
                    SJctrLogUty.info(this.getClass().getName(), "checkEndData", "Operation Number Invalid. Number = " + ope + ". Configurable operation =" + this.enableOperation);
                    SJctrError err = new SJctrError(207, 22, 107001);
                    SJcException exp = err.createException();
                    throw exp;
                }
            }
            Collections.sort(basicDataList);
            confirmData.setEditVLdevInfoList(basicDataList);
            confirmData.setNeedData(this);
            ArrayList<SJctrEditVirtualManageSetConfirmData> confirmDataList = new ArrayList<SJctrEditVirtualManageSetConfirmData>();
            confirmDataList.add(confirmData);
            this.putCache(SJctrEditVirtualManageSetConfirmData.class, confirmDataList);
            SJctrRsgUtility.setFinishChangeCheck(this, false);
        }
        catch (SJcException e) {
            throw SJctrRsgUtility.convRsgLogicalErr(e, 107003);
        }
        return true;
    }

    private List<SJctrRsgLdevInfo> SetBasicDataListOpeReseveIdSetLdevInfo(List<SJctrRsgLdevInfo> ldevInfoList) {
        int iNumOfConcatLdev;
        ArrayList<SJctrRsgLdevInfo> dataList = new ArrayList<SJctrRsgLdevInfo>();
        SJctrVirtualConfigurationDataModel vConfDataModel = this.getVirtualConfigurationDataModel();
        int iEmulation = Integer.parseInt(vConfDataModel.getEmuTypeSelectDataModel().getSelection());
        String strCvs = vConfDataModel.getCvsSettingRadioDataModel().getSelect();
        boolean bCvs = false;
        if (strCvs.equals("COM_CVS_SETTINGS_ENABLE")) {
            bCvs = true;
        }
        if ((iNumOfConcatLdev = Integer.valueOf(vConfDataModel.getNumOfConcatLdevTextDataModel().getValue()).intValue()) <= 1) {
            iNumOfConcatLdev = 0;
        }
        int iSsid = Integer.parseInt(vConfDataModel.getSsidTextDataModel().getValue(), 16);
        List<SJmoLdevIndex> vLdevIndexList = this.getVLdevSttingList(ldevInfoList);
        if (ldevInfoList.size() != vLdevIndexList.size()) {
            SJctrError err = new SJctrError(207, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        for (int i = 0; i < ldevInfoList.size(); ++i) {
            SJctrRsgLdevInfo info = new SJctrRsgLdevInfo(ldevInfoList.get(i));
            info.getVLDEV().setVirtualLdev(vLdevIndexList.get(i));
            info.getVLDEV().setSVInfflag((short)1);
            info.getVLDEV().setIVEmulation(iEmulation);
            info.getVLDEV().setVCvs(bCvs);
            info.getVLDEV().setByVLuse((byte)iNumOfConcatLdev);
            info.getVLDEV().setIVSsid(iSsid);
            dataList.add(info);
        }
        return dataList;
    }

    private List<SJctrRsgLdevInfo> SetBasicDataListOpeNotSetLdevInfo(List<SJctrRsgLdevInfo> ldevInfoList) {
        ArrayList<SJctrRsgLdevInfo> dataList = new ArrayList<SJctrRsgLdevInfo>();
        for (SJctrRsgLdevInfo ldevInfo : ldevInfoList) {
            SJctrRsgLdevInfo info = new SJctrRsgLdevInfo(ldevInfo);
            info.getVLDEV().setVirtualLdev(ldevInfo.getVLDEV().getVirtualLdev());
            dataList.add(info);
        }
        return dataList;
    }

    private List<SJctrRsgLdevInfo> SetBasicDataListOpeReserveId(List<SJctrRsgLdevInfo> ldevInfoList) {
        ArrayList<SJctrRsgLdevInfo> dataList = new ArrayList<SJctrRsgLdevInfo>();
        List<SJmoLdevIndex> vLdevIndexList = this.getVLdevSttingList(ldevInfoList);
        if (ldevInfoList.size() != vLdevIndexList.size()) {
            SJctrLogUty.info(this.getClass().getName(), "SetBasicDataListOpeReserveId", "Different size.");
            SJctrError err = new SJctrError(207, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        for (int i = 0; i < ldevInfoList.size(); ++i) {
            SJctrRsgLdevInfo info = new SJctrRsgLdevInfo(ldevInfoList.get(i));
            info.getVLDEV().setVirtualLdev(vLdevIndexList.get(i));
            dataList.add(info);
        }
        return dataList;
    }

    private List<SJmoLdevIndex> getVLdevSttingList(List<SJctrRsgLdevInfo> ldevInfoList) {
        ArrayList<SJmoLdevIndex> ldevIndexList = new ArrayList<SJmoLdevIndex>();
        SJctrInitialVirtualLDEVIdDataModel vLDEVIdDataModel = this.getInitialVirtualLDEVIdDataModel();
        int iVInitDkc = Integer.parseInt(vLDEVIdDataModel.getLdkcTextDataModel().getValue(), 16);
        int iVInitCu = Integer.parseInt(vLDEVIdDataModel.getCuSelectDataModel().getSelection(), 16);
        int iVInitLdev = Integer.parseInt(vLDEVIdDataModel.getDevSelectDataModel().getSelection(), 16);
        int iInterval = Integer.valueOf(vLDEVIdDataModel.getIntervalSelectDataModel().getSelection());
        SJmoHUVMvboxIndex vBoxIndex = ldevInfoList.get(0).getVLDEV().getVBoxIndex();
        Set<Integer> useVLdevIndexList = SJctrRsgUtility.createUseVLdevIndexListVdkc(this, vBoxIndex);
        int baseCuLdev = SJctrEditVirtualManageSetDC.getCuLdev(iVInitCu, iVInitLdev);
        baseCuLdev -= ++iInterval;
        int assinLdevNum = 0;
        for (int i = 0; i < ldevInfoList.size(); ++i) {
            if ((baseCuLdev = SJctrEditVirtualManageSetDC.getNextIndex(baseCuLdev, iInterval, useVLdevIndexList, ldevInfoList.get(i))) == -1) {
                int restLdevNum = ldevInfoList.size() - assinLdevNum;
                String[] msgArgument = new String[]{Integer.toString(restLdevNum)};
                SJctrLogUty.info(this.getClass().getName(), "getVLdevSttingList", "Selected ldev can not assign virtual LDEV ID.");
                SJctrError err = new SJctrError(207, 22, 205120);
                err.setMsgArgument(msgArgument);
                SJcException exp = err.createException();
                throw exp;
            }
            ++assinLdevNum;
            SJmoLdevIndex ldevIndex = new SJmoLdevIndex();
            ldevIndex.setSLdkc((short)iVInitDkc);
            iVInitLdev = baseCuLdev % (SJmoDataMacro_IF.NUM_MAX_LDEV_CU + 1);
            ldevIndex.setSCu((short)(baseCuLdev / (SJmoDataMacro_IF.NUM_MAX_LDEV_CU + 1)));
            ldevIndex.setSLdev((short)iVInitLdev);
            ldevIndexList.add(ldevIndex);
        }
        return ldevIndexList;
    }

    private static int getNextIndex(int baseIndex, int interval, Set<Integer> usedVLdevIndexList, SJctrRsgLdevInfo truthLdev) {
        int truthIndev;
        boolean bDefaultVdkc = SJctrRsgUtility.isVdkcNumberNotZero(truthLdev.getVLDEV());
        if ((baseIndex += interval) > SJmoDataMacro_IF.NUM_MAX_VIRTUAL_LDEV_LDKC) {
            return -1;
        }
        for (int i = 0; i <= SJmoDataMacro_IF.NUM_MAX_VIRTUAL_LDEV_LDKC && (usedVLdevIndexList.contains(baseIndex) || !bDefaultVdkc && (truthIndev = SJctrEditVirtualManageSetDC.getCuLdev(truthLdev.getSCu(), truthLdev.getSLdev())) == baseIndex); ++i) {
            if (++baseIndex <= SJmoDataMacro_IF.NUM_MAX_VIRTUAL_LDEV_LDKC) continue;
            baseIndex = -1;
            break;
        }
        if (baseIndex != -1) {
            usedVLdevIndexList.add(baseIndex);
        }
        return baseIndex;
    }

    public static int getCuLdev(int cu, int ldev) {
        return cu * (SJmoDataMacro_IF.NUM_MAX_LDEV_CU + 1) + ldev;
    }

    private List<SJctrRsgLdevInfo> SetBasicDataListOpeSetLdevInfo(List<SJctrRsgLdevInfo> ldevInfoList) {
        int iNumOfConcatLdev;
        ArrayList<SJctrRsgLdevInfo> dataList = new ArrayList<SJctrRsgLdevInfo>();
        SJctrVirtualConfigurationDataModel vConfDataModel = this.getVirtualConfigurationDataModel();
        int iEmulation = Integer.parseInt(vConfDataModel.getEmuTypeSelectDataModel().getSelection());
        String strCvs = vConfDataModel.getCvsSettingRadioDataModel().getSelect();
        boolean bCvs = false;
        if (strCvs.equals("COM_CVS_SETTINGS_ENABLE")) {
            bCvs = true;
        }
        if ((iNumOfConcatLdev = Integer.valueOf(vConfDataModel.getNumOfConcatLdevTextDataModel().getValue()).intValue()) <= 1) {
            iNumOfConcatLdev = 0;
        }
        int iSsid = Integer.parseInt(vConfDataModel.getSsidTextDataModel().getValue(), 16);
        for (SJctrRsgLdevInfo ldevInfo : ldevInfoList) {
            SJctrRsgLdevInfo info = new SJctrRsgLdevInfo(ldevInfo);
            SJmoHUVMVirtualLdev vLdevInfo = ldevInfo.getVLDEV();
            info.getVLDEV().setVirtualLdev(vLdevInfo.getVirtualLdev());
            info.getVLDEV().setSVInfflag((short)1);
            info.getVLDEV().setIVEmulation(iEmulation);
            info.getVLDEV().setVCvs(bCvs);
            info.getVLDEV().setByVLuse((byte)iNumOfConcatLdev);
            info.getVLDEV().setIVSsid(iSsid);
            dataList.add(info);
        }
        return dataList;
    }

    private List<SJctrRsgLdevInfo> SetBasicDataListOpeHuvmOffReserveId(List<SJctrRsgLdevInfo> ldevInfoList) {
        ArrayList<SJctrRsgLdevInfo> dataList = new ArrayList<SJctrRsgLdevInfo>();
        for (SJctrRsgLdevInfo ldevInfo : ldevInfoList) {
            SJctrRsgLdevInfo info = new SJctrRsgLdevInfo(ldevInfo);
            info.getVLDEV().setVirtualLdev(ldevInfo);
            dataList.add(info);
        }
        return dataList;
    }

    private List<SJctrRsgLdevInfo> SetBasicDataListOpeOther(List<SJctrRsgLdevInfo> ldevInfoList) {
        ArrayList<SJctrRsgLdevInfo> ldevList = new ArrayList<SJctrRsgLdevInfo>();
        for (SJctrRsgLdevInfo ldevInfo : ldevInfoList) {
            SJctrRsgLdevInfo info = new SJctrRsgLdevInfo(ldevInfo);
            ldevList.add(info);
        }
        return ldevList;
    }

    private int getExecuteOperationCode() {
        int ret = 0;
        SJctrVirtualManageSettingDataModel virtualMngSetModel = this.getVirtualManageSettingDataModel();
        SJctrComboBoxDataModel virtualMngSetcomboBoxModel = virtualMngSetModel.getVirtualManageSetComboBoxDataModel();
        String selectedVirtualMngSet = virtualMngSetcomboBoxModel.getSelection();
        if (selectedVirtualMngSet.equals(String.valueOf(0))) {
            ret = this.getEnableCaseExecuteOperationCode();
        } else if (selectedVirtualMngSet.equals(String.valueOf(1))) {
            ret = this.getEnableNotSetCaseExecuteOperationCode();
        } else if (selectedVirtualMngSet.equals(String.valueOf(2))) {
            ret = this.getDisableCaseExecuteOperationCode();
        }
        return ret;
    }

    private int getEnableCaseExecuteOperationCode() {
        int ret = 0;
        SJctrVirtualConfigurationDataModel virtualConfigurationModel = this.getVirtualConfigurationDataModel();
        SJctrRadioButtonGroupDataModel virtualConfigRadioModel = virtualConfigurationModel.getVirtualConfigurationRadioDataModel();
        String selectedVirtualConfig = "";
        if (virtualConfigRadioModel != null) {
            selectedVirtualConfig = virtualConfigRadioModel.getSelect();
        }
        if (selectedVirtualConfig.equals("COM_VIRTUAL_CONFIG_SPECIFY")) {
            if ((this.enableOperation & 0x20) == 32) {
                ret = 32;
            } else if ((this.enableOperation & 0x80) == 128) {
                ret = 128;
            }
        } else if (selectedVirtualConfig.equals("COM_VIRTUAL_CONFIG_NOTSET")) {
            if ((this.enableOperation & 8) == 8) {
                ret = 8;
            } else if ((this.enableOperation & 0x40) == 64) {
                ret = 64;
            }
        }
        return ret;
    }

    private int getEnableNotSetCaseExecuteOperationCode() {
        int ret = 0;
        if ((this.enableOperation & 1) == 1) {
            ret = 1;
        } else if ((this.enableOperation & 0x10) == 16) {
            ret = 16;
        } else if ((this.enableOperation & 0x100) == 256) {
            ret = 256;
        }
        return ret;
    }

    private int getDisableCaseExecuteOperationCode() {
        int ret = 0;
        if ((this.enableOperation & 2) == 2) {
            ret = 2;
        } else if ((this.enableOperation & 4) == 4) {
            ret = 4;
        }
        return ret;
    }

    private SJctrVirtualManageSettingDataModel getVirtualManageSettingDataModel() {
        return (SJctrVirtualManageSettingDataModel)this.getDataObjectModel("COM_VIRTUAL_MANAGE_SET_AREA");
    }

    private SJctrInitialVirtualLDEVIdDataModel getInitialVirtualLDEVIdDataModel() {
        return (SJctrInitialVirtualLDEVIdDataModel)this.getDataObjectModel("COM_INIT_VIRTUAL_LDEV_AREA");
    }

    private SJctrVirtualConfigurationDataModel getVirtualConfigurationDataModel() {
        return (SJctrVirtualConfigurationDataModel)this.getDataObjectModel("COM_VIRTUAL_CONFIG_AREA");
    }
}

