/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.arraygroup.createpgs.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import sanproject.sn2.controller.com.SJctrPdevUtility;
import sanproject.sn2.controller.com.model.SJctrComboBoxDataModel;
import sanproject.sn2.model.data.device.SJmoPdevDetail;

public class SJctrCreatePGsDriveKindModel
extends SJctrComboBoxDataModel {
    private static final String[] displayOrders = new String[]{"SSD(FMC)/-/", "SSD(FMD)/-/", "SSD(MLC)/-/", "SSD/-/", "SAS/15krpm/", "SAS/10krpm/", "SAS/7.2krpm/"};
    private List<Set<String>> driveTypeCodes = new ArrayList<Set<String>>();

    public Set<String> getInputDriveTypeCodes() {
        int index = this.getSelectedIndex();
        if (0 <= index && index < this.driveTypeCodes.size()) {
            return this.driveTypeCodes.get(index);
        }
        return Collections.emptySet();
    }

    public void refreshData(List<SJmoPdevDetail> pdevDetails) {
        SJctrPdevUtility pdevUtility = this.getComUtility().getPdevUtility();
        this.removeAllItems();
        this.driveTypeCodes.clear();
        TreeMap<String, HashSet<String>> map = new TreeMap<String, HashSet<String>>(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                int order1 = this.getOrder(o1);
                int order2 = this.getOrder(o2);
                return order1 - order2;
            }

            public int getOrder(String o) {
                for (int i = 0; i < displayOrders.length; ++i) {
                    if (!o.startsWith(displayOrders[i])) continue;
                    if (o.endsWith("GB")) {
                        Double order = Double.valueOf(o.substring(displayOrders[i].length(), o.length() - 2));
                        Double number = (double)(i * 10000) + order;
                        return number.intValue();
                    }
                    if (o.endsWith("TB")) {
                        Double order = Double.valueOf(o.substring(displayOrders[i].length(), o.length() - 2));
                        Double number = (double)(i * 10000 + 1000) + order * 10.0;
                        return number.intValue();
                    }
                    return i * 10000;
                }
                return (displayOrders.length + 1) * 10000;
            }
        });
        for (SJmoPdevDetail pdev : pdevDetails) {
            String driveTypeCode = pdev.getHDDKind();
            String driveKind = pdevUtility.getStrDriveKind(driveTypeCode);
            HashSet<String> list = (HashSet<String>)map.get(driveKind);
            if (list == null) {
                list = new HashSet<String>();
                map.put(driveKind, list);
            }
            list.add(driveTypeCode);
        }
        for (String key : map.keySet()) {
            this.addItem(key);
            this.driveTypeCodes.add((Set<String>)map.get(key));
        }
        this.setSelectedIndex(-1);
    }
}

