/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.arraygroup.editcopybackmode.cntl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrErrorColumnData;
import sanproject.sn2.controller.com.SJctrErrorDataController;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrNotifyState;
import sanproject.sn2.controller.com.SJctrPoolUtility;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.com.model.SJctrButtonDataModel;
import sanproject.sn2.controller.com.model.SJctrCheckBoxAreaDataModel;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.com.model.event.SJctrMessageEvent;
import sanproject.sn2.controller.com.model.event.SJctrMessageEventListener;
import sanproject.sn2.controller.topwindow.arraygroup.com.SJctrArrayGroupUtility;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.SJctrWizardDataController;
import sanproject.sn2.controller.wizard.arraygroup.com.SJctrNFLdevInPGInfo;
import sanproject.sn2.controller.wizard.arraygroup.com.SJctrParityGroupUtility;
import sanproject.sn2.controller.wizard.arraygroup.createpgs.model.SJctrCreatePGsAutoCopyBackModel;
import sanproject.sn2.controller.wizard.arraygroup.editcopybackmode.SJctrEditCBMSubWizard;
import sanproject.sn2.controller.wizard.arraygroup.editcopybackmode.cntl.SJctrEditPGApplyParam;
import sanproject.sn2.controller.wizard.arraygroup.editcopybackmode.model.SJctrEditCBMData;
import sanproject.sn2.controller.wizard.arraygroup.editcopybackmode.model.SJctrEditPGsVirtModeModel;
import sanproject.sn2.controller.wizard.cvs.createldevs.basic.data.SJctrPGDetail;
import sanproject.sn2.controller.wizard.encryption.com.SJctrEncryptionKeyDef;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetDCRInfo;
import sanproject.sn2.model.connector.kind.SJmoGetHDPRelationbyPool;
import sanproject.sn2.model.connector.kind.SJmoGetLdevDetail;
import sanproject.sn2.model.connector.kind.SJmoGetLdevGuardInfo;
import sanproject.sn2.model.connector.kind.SJmoGetLdevNicknameInfo;
import sanproject.sn2.model.connector.kind.SJmoGetLdevStatusInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPdevDetail;
import sanproject.sn2.model.connector.kind.SJmoGetPgDetail;
import sanproject.sn2.model.connector.kind.SJmoGetPgEncryptionInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPgLdevInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPgScatteredInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPoolDetail;
import sanproject.sn2.model.connector.kind.SJmoGetPoolVolDetail;
import sanproject.sn2.model.connector.kind.SJmoGetRSGgetAllRsgs;
import sanproject.sn2.model.connector.kind.SJmoGetVdevDetail;
import sanproject.sn2.model.data.device.SJmoPdevDetail;
import sanproject.sn2.model.data.group.SJmoHDPRelationByPool;
import sanproject.sn2.model.data.group.SJmoPoolDetail;
import sanproject.sn2.model.data.group.SJmoPoolIndex;
import sanproject.sn2.model.data.group.SJmoPoolVolDetail;
import sanproject.sn2.model.data.rsg.SJmoRSGgetAllRsgs;
import sanproject.sn2.model.data.volume.SJmoDCRInfo;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;
import sanproject.sn2.model.data.volume.SJmoLdevGuardInfo;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;
import sanproject.sn2.model.data.volume.SJmoLdevNicknameInfo;
import sanproject.sn2.model.data.volume.SJmoLdevStatusInfo;
import sanproject.sn2.model.data.volume.SJmoPgDetail;
import sanproject.sn2.model.data.volume.SJmoPgEncryptionInfo;
import sanproject.sn2.model.data.volume.SJmoPgIndex;
import sanproject.sn2.model.data.volume.SJmoPgLdevInfo;
import sanproject.sn2.model.data.volume.SJmoPgScatteredInfo;
import sanproject.sn2.model.data.volume.SJmoVdevDetail;

public class SJctrEditCBMDC
extends SJctrWizardDataController {
    public static final int DISP_ID = 0x1101991;
    private static final String KEY_CBM_INF = "COM_COPYBACKMODE";
    private static final String KEY_VM_INF = "COM_VIRTUALIZATION";
    private SJctrCheckBoxAreaDataModel virtModeCheckBox;
    private SJctrEditPGsVirtModeModel virtModeModel;
    private SJctrCheckBoxAreaDataModel autoCopybackCheckBox;
    private SJctrCreatePGsAutoCopyBackModel pgAutoCopyBackModel;
    private SJctrFooterDataModel footer;
    private Map<SJmoPgDetail, Short> poolIdMap = new TreeMap<SJmoPgDetail, Short>();
    private List<SJctrPGDetail> selectedPgs;
    private boolean isCopybackValueSame;
    private int defaultCopybackValue;
    private boolean isVMValueSame;
    private boolean defaultVMValue;

    public SJctrEditCBMDC() {
        super(0x1101991);
        this.initDataModel();
        this.initListener();
    }

    @Override
    public String getDispName() {
        return this.getComUtility().getGuidance("PG", "EDIT_CBM");
    }

    @Override
    public boolean checkConstructData() {
        List<SJmoPgDetail> selectedIndexes = this.getPGIndexListFromCache();
        if (selectedIndexes.isEmpty()) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkConstructData", "No row is selected");
            throw SJctrParityGroupUtility.createPgInternalException();
        }
        List<SJmoPgScatteredInfo> scattered = SJctrParityGroupUtility.getCache(this, SJmoGetPgScatteredInfo.class);
        List<SJmoPgDetail> pgDetails = SJctrParityGroupUtility.getCache(this, SJmoGetPgDetail.class);
        List<SJmoLdevDetail> ldevDtls = SJctrParityGroupUtility.getCache(this, SJmoGetLdevDetail.class);
        List<SJmoHDPRelationByPool> hdpRelationByPools = SJctrParityGroupUtility.getCache(this, SJmoGetHDPRelationbyPool.class);
        List<SJmoLdevStatusInfo> pgLdevStatusInfos = SJctrParityGroupUtility.getCache(this, SJmoGetLdevStatusInfo.class);
        List pgLdevInfos = SJctrParityGroupUtility.getCache(this, SJmoGetPgLdevInfo.class);
        List<SJmoPdevDetail> pdevDetails = SJctrParityGroupUtility.getCache(this, SJmoGetPdevDetail.class);
        List<SJmoVdevDetail> vdevDetailList = SJctrParityGroupUtility.getCache(this, SJmoGetVdevDetail.class);
        List<SJmoLdevNicknameInfo> ldevNameList = SJctrParityGroupUtility.getCache(this, SJmoGetLdevNicknameInfo.class);
        List<SJmoDCRInfo> dcrList = SJctrParityGroupUtility.getCache(this, SJctrPoolUtility.KEY_CLASS_LDEV_DCR);
        List<SJmoLdevGuardInfo> druList = SJctrParityGroupUtility.getCache(this, SJctrPoolUtility.KEY_CLASS_LDEV_GUARD);
        SJctrPoolUtility poolUtil = this.getComUtility().getPoolUtility();
        TreeMap<Integer, SJctrPGDetail> map = new TreeMap<Integer, SJctrPGDetail>();
        ArrayList<SJctrErrorColumnData> errExtPgColumnList = new ArrayList<SJctrErrorColumnData>();
        boolean checkedE = true;
        boolean checkedD = true;
        Collections.sort(selectedIndexes);
        for (SJmoPgDetail pg : selectedIndexes) {
            SJctrPGDetail pgDetail = new SJctrPGDetail(pg.getFB4(), pg.getPG());
            pgDetail.setPGScatteredList(scattered);
            pgDetail.setBasicDataList(pgDetails, vdevDetailList, ldevDtls, ldevNameList);
            pgDetail.setPDEVList(pdevDetails);
            map.put(pg.getIndex(), pgDetail);
            if (SJctrParityGroupUtility.isExternal(pg)) {
                SJctrError error = SJctrParityGroupUtility.createPgError(205130);
                SJctrErrorColumnData errColumn = new SJctrErrorColumnData(pg, error);
                errExtPgColumnList.add(errColumn);
                continue;
            }
            if (!pg.getBVirtSupport()) {
                checkedE = false;
                checkedD = false;
                continue;
            }
            if (!pgDetail.getPdevStatusCheck(0)) {
                checkedE = false;
                checkedD = false;
                continue;
            }
            SJmoPgLdevInfo pgLdevInfo = (SJmoPgLdevInfo)SJctrParityGroupUtility.findList(pgLdevInfos, pg);
            ArrayList<SJmoLdevIndex> allLdevs = new ArrayList<SJmoLdevIndex>();
            allLdevs.addAll(pgLdevInfo.getAlLdevIndex());
            ArrayList pgScatList = pgDetail.getPGScatteredList();
            for (int j = 0; j < pgScatList.size(); ++j) {
                SJmoPgIndex pgScatIndex = (SJmoPgIndex)pgScatList.get(j);
                SJmoPgLdevInfo pgScatLdevInfo = (SJmoPgLdevInfo)SJctrParityGroupUtility.findList(pgLdevInfos, pgScatIndex);
                allLdevs.addAll(pgScatLdevInfo.getAlLdevIndex());
            }
            Collections.sort(allLdevs);
            if (allLdevs == null || allLdevs.isEmpty()) continue;
            if (!SJctrParityGroupUtility.checkLDEVStatus(allLdevs, pgLdevStatusInfos)) {
                checkedE = false;
                checkedD = false;
                continue;
            }
            List<SJmoLdevDetail> ldevDetailList = SJctrParityGroupUtility.getChangeListType(allLdevs, ldevDtls);
            HashSet<Short> poolIdSet = new HashSet<Short>();
            for (SJmoLdevDetail ldevDetail : ldevDetailList) {
                if (!poolUtil.checkEnable(ldevDetail, poolIdSet)) {
                    checkedE = false;
                }
                if (!ldevDetail.getBVirtSpaceUsed()) continue;
                checkedD = false;
            }
            if (!poolUtil.checkEnableCreatePool(ldevDetailList, dcrList, druList)) {
                checkedE = false;
            }
            if (poolIdSet.size() != 1) continue;
            if (!poolUtil.checkDPVol(hdpRelationByPools, (Short)poolIdSet.iterator().next())) {
                checkedE = false;
            }
            this.poolIdMap.put(pg, (Short)poolIdSet.iterator().next());
        }
        if (errExtPgColumnList.size() > 0) {
            this.output_errorList(errExtPgColumnList);
        }
        if (!checkedE && !checkedD) {
            this.virtModeCheckBox.setEnableCheckBox(false);
            this.virtModeModel.setEnable(false);
        } else {
            this.virtModeModel.setEnableRadioButton(checkedE);
            this.virtModeModel.setDisableRadioButton(checkedD);
        }
        this.selectedPgs = new ArrayList<SJctrPGDetail>();
        this.selectedPgs.addAll(map.values());
        this.isVMValueSame = true;
        this.defaultVMValue = this.selectedPgs.get(0).getBVirtMode();
        this.isCopybackValueSame = true;
        this.defaultCopybackValue = this.selectedPgs.get(0).getCopybackMode();
        for (SJctrPGDetail selected : this.selectedPgs) {
            this.isVMValueSame &= selected.getBVirtMode() == this.defaultVMValue;
            this.isCopybackValueSame &= selected.getCopybackMode() == this.defaultCopybackValue;
        }
        if (this.isVMValueSame) {
            this.virtModeModel.setInputVirtModeValue(this.defaultVMValue);
        }
        if (this.isCopybackValueSame) {
            this.pgAutoCopyBackModel.setInputCopybackValue(this.defaultCopybackValue);
        }
        return true;
    }

    @Override
    protected void updateFooter() {
        super.updateFooter();
        int value = this.pgAutoCopyBackModel.getInputAutoCopyBackValue();
        int vmValue = this.virtModeModel.getInputVirtModeValue();
        boolean vmChecked = this.virtModeCheckBox.isSelectCheckBox();
        boolean autoCopybackChecked = this.autoCopybackCheckBox.isSelectCheckBox();
        boolean enabled = true;
        if (!autoCopybackChecked && !vmChecked) {
            enabled = false;
        } else if (vmChecked && vmValue == -1) {
            enabled = false;
        } else if (autoCopybackChecked && value == -1) {
            enabled = false;
        }
        this.footer.setEnableButton(SJctrFooterDataModel.Button.FINISH, enabled);
        this.footer.setDirtyAll();
    }

    private List<SJmoPgDetail> getPGIndexListFromCache() {
        List allRsgsList;
        List<SJmoPgIndex> pgIndexes = SJctrParityGroupUtility.getModifiableCache(this, "KEY_SELECT_PG_INDEX");
        List pgDetails = SJctrParityGroupUtility.getCache(this, SJmoGetPgDetail.class);
        List<SJmoPgDetail> ret = new ArrayList<SJmoPgDetail>();
        ArrayList<SJctrErrorColumnData> errPGList = new ArrayList<SJctrErrorColumnData>();
        for (SJmoPgIndex index : pgIndexes) {
            int pgIndex = Collections.binarySearch(pgDetails, index);
            if (pgIndex >= 0) {
                ret.add((SJmoPgDetail)pgDetails.get(pgIndex));
                continue;
            }
            SJctrError error = SJctrParityGroupUtility.createPgError(205155);
            SJctrErrorColumnData errColumn = new SJctrErrorColumnData(index, error);
            errPGList.add(errColumn);
        }
        if (!errPGList.isEmpty()) {
            this.output_errorList(errPGList);
        }
        if ((allRsgsList = SJctrParityGroupUtility.getCache(this, SJmoGetRSGgetAllRsgs.class)).size() > 0) {
            ret = SJctrArrayGroupUtility.extractAvailablePgList(ret, (SJmoRSGgetAllRsgs)allRsgsList.get(0), this.getOwner());
        }
        return ret;
    }

    @Override
    public boolean checkEndData() {
        boolean autoCopybackChecked;
        int inputAutoCopyBackValue = this.pgAutoCopyBackModel.getInputAutoCopyBackValue();
        ArrayList<SJctrPGDetail> clonePgDtlList = null;
        clonePgDtlList = new ArrayList<SJctrPGDetail>(this.selectedPgs.size());
        for (int i = 0; i < this.selectedPgs.size(); ++i) {
            SJctrPGDetail pgDetail = this.selectedPgs.get(i);
            SJctrPGDetail wkPg = new SJctrPGDetail();
            wkPg.setPGDetailEx(pgDetail);
            clonePgDtlList.add(wkPg);
        }
        boolean vmChecked = this.virtModeCheckBox.isSelectCheckBox();
        if (vmChecked) {
            int vmValue = this.virtModeModel.getInputVirtModeValue();
            boolean bVMValue = vmValue == 1;
            for (SJctrPGDetail selected : clonePgDtlList) {
                selected.setBVirtMode(bVMValue);
            }
        }
        if (autoCopybackChecked = this.autoCopybackCheckBox.isSelectCheckBox()) {
            for (SJctrPGDetail selected : clonePgDtlList) {
                selected.setCopybackMode(inputAutoCopyBackValue);
            }
        }
        SJctrEditCBMData confirmData = new SJctrEditCBMData();
        confirmData.setPgDetailList(clonePgDtlList);
        List<SJctrEditCBMData> confirmDataList = Arrays.asList(confirmData);
        this.putCache(SJctrEditCBMData.class, confirmDataList);
        SJctrEditPGApplyParam applyparam = new SJctrEditPGApplyParam();
        applyparam.setVirtMode(vmChecked);
        applyparam.setCopyBackMode(autoCopybackChecked);
        ArrayList<SJctrEditPGApplyParam> applyDataList = new ArrayList<SJctrEditPGApplyParam>();
        applyDataList.add(applyparam);
        this.putCache(SJctrEditCBMSubWizard.EDIT_PG_APPLYPARAM, applyDataList);
        return true;
    }

    private void initDataModel() {
        this.virtModeCheckBox = new SJctrCheckBoxAreaDataModel();
        this.addDataObjectModel("COM_VIRTUALIZATION_CHECKBOX", this.virtModeCheckBox);
        this.virtModeModel = new SJctrEditPGsVirtModeModel();
        this.addDataObjectModel(KEY_VM_INF, this.virtModeModel);
        this.autoCopybackCheckBox = new SJctrCheckBoxAreaDataModel();
        this.addDataObjectModel("COM_AUTO_COPYBACK_CHECKBOX", this.autoCopybackCheckBox);
        this.pgAutoCopyBackModel = new SJctrCreatePGsAutoCopyBackModel();
        this.addDataObjectModel(KEY_CBM_INF, this.pgAutoCopyBackModel);
        this.footer = new SJctrFooterDataModel();
        this.addDataObjectModel("COM_FOOTER", this.footer);
    }

    private void initListener() {
        SJctrButtonDataModel button = new SJctrButtonDataModel();
        this.addDataObjectModel("COM_ADD", button);
        button.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                SJctrEditCBMDC.this.updateFooter();
            }
        });
        this.addMessageEventListener(NOTIFY_EDIT_PGS.DIAROGOK, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrLogUty.info(this.getClass().getSimpleName(), " virtModeMixedDialogAction ", " START");
                boolean finishFlg = SJctrEditCBMDC.this.virtModeMixedDialogAction(event, dstModel);
                SJctrLogUty.info(this.getClass().getSimpleName(), " virtModeMixedDialogAction ", " END");
                if (!finishFlg) {
                    SJctrEditCBMDC.this.checkEndData();
                    SJctrEditCBMDC.this.finishEvent(event, dstModel);
                }
            }
        });
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        Set<SJctrGetDirectWrapper> set = super.getModelDirect();
        set.add(this.createGetDirectWrapper(new SJmoGetPgDetail()));
        set.add(this.createGetDirectWrapper(new SJmoGetRSGgetAllRsgs()));
        set.add(this.createGetDirectWrapper(new SJmoGetPgScatteredInfo()));
        set.add(this.createGetDirectWrapper(new SJmoGetHDPRelationbyPool()));
        set.add(this.createGetDirectWrapper(new SJmoGetLdevDetail()));
        set.add(this.createGetDirectWrapper(new SJmoGetLdevStatusInfo()));
        set.add(this.createGetDirectWrapper(new SJmoGetPgLdevInfo()));
        set.add(this.createGetDirectWrapper(new SJmoGetPdevDetail()));
        set.add(this.createGetDirectWrapper(new SJmoGetVdevDetail()));
        set.add(this.createGetDirectWrapper(new SJmoGetLdevNicknameInfo()));
        set.add(this.createGetDirectWrapper(new SJmoGetPoolDetail()));
        set.add(this.createGetDirectWrapper(new SJmoGetDCRInfo()));
        set.add(this.createGetDirectWrapper(new SJmoGetLdevGuardInfo()));
        set.add(this.createGetDirectWrapper(new SJmoGetPoolVolDetail()));
        set.add(this.createGetDirectWrapper(new SJmoGetPgEncryptionInfo()));
        return set;
    }

    private SJctrGetDirectWrapper createGetDirectWrapper(SJmoGetKind_IF kind) {
        SJmoGetRange_IF range = null;
        List filterList = Collections.emptyList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        return new SJctrGetDirectWrapper(direct);
    }

    public void output_errorList(ArrayList<SJctrErrorColumnData> errColumnList) {
        SJctrRelatedDispDataObject errDisp = this.createDialog(SJctrErrorDataController.class, null);
        SJctrUserController uc = this.getWizardWindow().getOwner();
        SJctrErrorDataController errDC = (SJctrErrorDataController)uc.getDataController(errDisp);
        errDC.setParameter(this.getWizardWindow().getParentDC().getDataObjectModel("COM_TABLE"), errColumnList);
        SJctrErrorColumnData errColumnData = errColumnList.get(0);
        SJctrError error = errColumnData.getError();
        SJctrError errorExp = new SJctrError(error.getFunc(), error.getModule(), error.getError());
        SJcException exp = errorExp.createException();
        exp.setErrDisp(errDisp);
        throw exp;
    }

    @Override
    public boolean checkFinishData(SJctrMessageEvent msgEvent, SJctrDataObjectModel<?> dstModel) {
        boolean flg = false;
        if (this.poolIdMap.size() <= 0) {
            return super.checkFinishData(msgEvent, dstModel);
        }
        List poolDetailList = SJctrParityGroupUtility.getCache(this, SJmoGetPoolDetail.class);
        if (poolDetailList.isEmpty()) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkFinishData", "SJmoGetPoolDetail is null");
            throw SJctrParityGroupUtility.createPgInternalException();
        }
        if (this.virtModeModel.getInputVirtModeValue() != 2) {
            for (Map.Entry<SJmoPgDetail, Short> entry : this.poolIdMap.entrySet()) {
                SJmoPgDetail pgdetail = entry.getKey();
                if (pgdetail.getBVirtMode()) continue;
                Short poolId = entry.getValue();
                SJmoPoolIndex poolIndex = new SJmoPoolIndex();
                poolIndex.setPoolId(poolId.shortValue());
                SJmoPoolDetail poolDtl = (SJmoPoolDetail)SJctrParityGroupUtility.findList(poolDetailList, poolIndex);
                long lPoolFmcActualPages = poolDtl.getLPoolFmcActualPages();
                long lPoolFmcActualUsedSubBlocks = poolDtl.getLPoolFmcActualUsedSubBlocks();
                long lPageSize = poolDtl.getPageSize();
                SJctrLogUty.info(this.getClass().getSimpleName(), "checkFinishData", "lPoolFmcActualPages=" + lPoolFmcActualPages);
                SJctrLogUty.info(this.getClass().getSimpleName(), "checkFinishData", "lPoolFmcActualUsedSubBlocks=" + lPoolFmcActualUsedSubBlocks);
                SJctrLogUty.info(this.getClass().getSimpleName(), "checkFinishData", "lPageSize=" + lPageSize);
                double dRatio = 0.0;
                if (lPoolFmcActualPages > 0L && lPageSize > 0L) {
                    dRatio = (double)lPoolFmcActualUsedSubBlocks / ((double)lPoolFmcActualPages * (double)lPageSize * 2.0) * 100.0;
                    SJctrLogUty.info(this.getClass().getSimpleName(), "checkFinishData", "dRatio=" + dRatio);
                }
                if (!(dRatio >= 90.0)) continue;
                flg = true;
                break;
            }
        }
        if (flg) {
            SJctrItemSelectListener listner = new SJctrItemSelectListener(){

                @Override
                public void selectChanged(SJctrItemSelectEvent<?> event) {
                    SJctrEditCBMDC.this.fireMessageEvent(NOTIFY_EDIT_PGS.DIAROGOK);
                }
            };
            SJctrRelatedDispDataObject related = SJctrParityGroupUtility.createOkCancelMsgDialog(205197, listner, this);
            this.addUpdateDisp(related);
            return true;
        }
        return this.virtModeMixedDialogAction(msgEvent, dstModel);
    }

    private boolean virtModeMixedDialogAction(final SJctrMessageEvent msgEvent, final SJctrDataObjectModel<?> dstModel) {
        boolean bVirtMode = this.virtModeModel.getInputVirtModeValue() == 1;
        List<SJmoPgEncryptionInfo> allSJmoPgEncList = SJctrParityGroupUtility.getCache(this, SJctrEncryptionKeyDef.KEY_CLASS_PGENCRYPTIONINFO);
        List<SJmoLdevDetail> ldevDtlList = SJctrParityGroupUtility.getCache(this, SJmoGetLdevDetail.class);
        List<SJmoHDPRelationByPool> hdpRelationByPools = SJctrParityGroupUtility.getCache(this, SJctrPoolUtility.KEY_CLASS_HDP_RELATION_BY_POOL);
        List<SJmoLdevStatusInfo> pgLdevStatusInfos = SJctrParityGroupUtility.getCache(this, SJctrPoolUtility.KEY_CLASS_LDEV_STATUS);
        List<SJmoPgLdevInfo> pgLdevInfos = SJctrParityGroupUtility.getCache(this, SJctrPoolUtility.KEY_CLASS_PGLDEV_INFO);
        List<SJmoPdevDetail> pdevDetails = SJctrParityGroupUtility.getCache(this, SJctrPoolUtility.KEY_CLASS_PDEV_DETAIL);
        List<SJmoDCRInfo> dcrList = SJctrParityGroupUtility.getCache(this, SJctrPoolUtility.KEY_CLASS_LDEV_DCR);
        List<SJmoLdevGuardInfo> druList = SJctrParityGroupUtility.getCache(this, SJctrPoolUtility.KEY_CLASS_LDEV_GUARD);
        List<SJmoPgScatteredInfo> pgScatteredInfos = SJctrParityGroupUtility.getCache(this, SJctrPoolUtility.KEY_CLASS_PGSCATTERED_INF);
        List<SJmoVdevDetail> vdevDetailList = SJctrParityGroupUtility.getCache(this, SJctrPoolUtility.KEY_CLASS_VDEV_DETAIL);
        List<SJmoLdevNicknameInfo> ldevNameList = SJctrParityGroupUtility.getCache(this, SJctrPoolUtility.KEY_CLASS_LDEVNAME_INFO);
        SJctrNFLdevInPGInfo pgInfo = new SJctrNFLdevInPGInfo();
        pgInfo.setPgEncryptionInfos(allSJmoPgEncList);
        pgInfo.setComUtil(this.getComUtility());
        pgInfo.setPgLdevInfos(pgLdevInfos);
        pgInfo.setPdevDetails(pdevDetails);
        pgInfo.setPgLdevStatusInfos(pgLdevStatusInfos);
        pgInfo.setDcrInfos(dcrList);
        pgInfo.setLdevGuardInfos(druList);
        pgInfo.setLdevDetails(ldevDtlList);
        pgInfo.setHdpRelationByPools(hdpRelationByPools);
        pgInfo.setPgScatteredInfos(pgScatteredInfos);
        pgInfo.setDcName(SJctrNFLdevInPGInfo.ENUM_DC_NAME.EDIT_PG);
        for (Map.Entry<SJmoPgDetail, Short> entry : this.poolIdMap.entrySet()) {
            SJmoPgDetail pgdetail = entry.getKey();
            List poolDetailList = SJctrParityGroupUtility.getCache(this, SJmoGetPoolDetail.class);
            List<SJmoPoolVolDetail> poolVolDtlList = SJctrParityGroupUtility.getCache(this, SJmoGetPoolVolDetail.class);
            List<SJmoPgDetail> pgDtlList = SJctrParityGroupUtility.getCache(this, SJmoGetPgDetail.class);
            Short poolId = entry.getValue();
            SJmoPoolIndex poolIndex = new SJmoPoolIndex();
            poolIndex.setPoolId(poolId.shortValue());
            SJmoPoolDetail poolDtl = (SJmoPoolDetail)SJctrParityGroupUtility.findList(poolDetailList, poolIndex);
            Set<SJmoPgDetail> pgSet = SJctrParityGroupUtility.getPgDtlFromPool(poolDtl, poolVolDtlList, ldevDtlList, pgDtlList);
            if (!SJctrParityGroupUtility.checkNfOnlyPgList(pgSet, pgInfo)) continue;
            for (SJmoPgDetail pgDtlFromPool : pgSet) {
                boolean checkSelectedPGs = false;
                for (SJctrPGDetail selected : this.selectedPgs) {
                    if (!pgDtlFromPool.getIndexKey().equals(selected.getIndexKey())) continue;
                    checkSelectedPGs = true;
                    break;
                }
                if (checkSelectedPGs || pgDtlFromPool.getBVirtMode() == bVirtMode) continue;
                SJctrPGDetail pgDetail = new SJctrPGDetail(pgDtlFromPool.getFB4(), pgDtlFromPool.getPG());
                pgDetail.setPGScatteredList(pgScatteredInfos);
                pgDetail.setBasicDataList(pgDtlList, vdevDetailList, ldevDtlList, ldevNameList);
                pgDetail.setPDEVList(pdevDetails);
                if (!pgDetail.isScTopPG()) continue;
                SJctrItemSelectListener listner = new SJctrItemSelectListener(){

                    @Override
                    public void selectChanged(SJctrItemSelectEvent<?> event) {
                        SJctrEditCBMDC.this.checkEndData();
                        SJctrEditCBMDC.this.finishEvent(msgEvent, dstModel);
                    }
                };
                SJctrRelatedDispDataObject related = SJctrParityGroupUtility.createOkMsgDialog(206349, listner, this);
                this.addUpdateDisp(related);
                return true;
            }
        }
        return super.checkFinishData(msgEvent, dstModel);
    }

    public static enum NOTIFY_EDIT_PGS implements SJctrNotifyState
    {
        DIAROGOK;

    }
}

