/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.cvs.comdialog.changeldevsetting;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrDialogDataController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrNotifyState;
import sanproject.sn2.controller.com.SJctrResourceGroupUtility;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.event.SJctrMessageEvent;
import sanproject.sn2.controller.com.model.event.SJctrMessageEventListener;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.cvs.com.SJctrCVSMacro;
import sanproject.sn2.controller.wizard.cvs.com.SJctrCVSUtility;
import sanproject.sn2.controller.wizard.cvs.com.SJctrLDEVDetail;
import sanproject.sn2.controller.wizard.cvs.comdialog.changeldevsetting.SJctrChangeLDEVIDData;
import sanproject.sn2.controller.wizard.cvs.comdialog.changeldevsetting.SJctrChangeLDEVNameData;
import sanproject.sn2.controller.wizard.cvs.comdialog.changeldevsetting.SJctrChangeLDEVSettingLDEVIDDataModel;
import sanproject.sn2.controller.wizard.cvs.comdialog.changeldevsetting.SJctrChangeLDEVSettingLDEVNameDataModel;
import sanproject.sn2.controller.wizard.cvs.comdialog.changeldevsetting.SJctrChangeLDEVSettingMPPKGDataModel;
import sanproject.sn2.controller.wizard.cvs.comdialog.changeldevsetting.SJctrChangeLDEVSettingT10PIRadioDataModel;
import sanproject.sn2.controller.wizard.cvs.comdialog.changeldevsetting.SJctrChangeLDEVSettingViewLDEVIDButtonModel;
import sanproject.sn2.controller.wizard.cvs.comdialog.viewldevid.SJctrViewLDEVIDDC;
import sanproject.sn2.controller.wizard.cvs.createldevs.base.com.SJctrCreateLDEVsDef;
import sanproject.sn2.model.data.volume.SJmoLdevNicknameInfo;
import sanproject.sn2.model.data.volume.SJmoSsidSummary;
import sanproject.sn2.modelrc.util.SJmoRscUtilLdev;
import sanproject.sn2.modelrc.util.SJmoRscUtilSsid;

public class SJctrChangeLDEVSettingDC
extends SJctrDialogDataController
implements SJctrCreateLDEVsDef,
SJctrCVSMacro {
    public SJctrChangeLDEVSettingDC() throws SJcException {
        super(33595410);
        this.initDataModel();
        this.initListener();
    }

    @Override
    public String getDispName() {
        return this.getComUtility().getGuidance("CVS", "CHANGE_LDEV_SETTING");
    }

    private void initDataModel() {
        this.addDataObjectModel("COM_LDEVNAME", new SJctrChangeLDEVSettingLDEVNameDataModel());
        this.addDataObjectModel("COM_LDEVID", new SJctrChangeLDEVSettingLDEVIDDataModel());
        this.addDataObjectModel("COM_MPPKGGRP", new SJctrChangeLDEVSettingMPPKGDataModel());
        this.addDataObjectModel("COM_T10PIGRP", new SJctrChangeLDEVSettingT10PIRadioDataModel());
        this.addDataObjectModel("COM_FOOTER", new SJctrFooterDataModel(SJctrFooterDataModel.BGO_OKCANCEL));
        this.addDataObjectModel("COM_LDEV_BTN", new SJctrChangeLDEVSettingViewLDEVIDButtonModel());
    }

    private void initListener() {
        this.addMessageEventListener(NOTIFY_CHANGE_LDEV.VIEW_LDEVID, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrChangeLDEVSettingDC.this.getLogUty().putlog("[SJctrChangeLDEVSettingDC]", "[ViewLDEVIDButtonAction]:START");
                SJctrChangeLDEVSettingDC.this.ViewLDEVIDButtonAction();
                SJctrChangeLDEVSettingDC.this.getLogUty().putlog("[SJctrChangeLDEVSettingDC]", "[ViewLDEVIDButtonAction]:END");
            }
        });
    }

    @Override
    public boolean checkStartData() {
        boolean bRet = true;
        List<?> changeLDEVID = this.getCache("CHANGE_LDEVID");
        List<?> changeLdevName = this.getCache("CHANGE_LDEVNAME");
        if (changeLDEVID == null || changeLDEVID.size() == 0) {
            if (changeLdevName == null || changeLdevName.size() == 0) {
                bRet = false;
                this.getLogUty().putlog("checkStartData", "changeLDEVID and changeLdevName not found", null, 40000);
            } else {
                bRet = this.checkStartData_LdevName();
            }
        } else {
            bRet = this.checkStartData_ALL();
        }
        if (!bRet) {
            SJctrCVSUtility.output_Error(30, 22, 105133);
        }
        return bRet;
    }

    private boolean checkStartData_ALL() {
        boolean bRet = true;
        List<?> changeLDEVIDList = this.getCache("CHANGE_LDEVID");
        Object changeLDEVIDObj = changeLDEVIDList.get(0);
        if (!(changeLDEVIDObj instanceof SJctrChangeLDEVIDData)) {
            SJctrCVSUtility.output_Error(30, 22, 105248);
        }
        SJctrChangeLDEVIDData changeLDEVID = (SJctrChangeLDEVIDData)changeLDEVIDList.get(0);
        List<?> ldevDetailList = changeLDEVID.getSelectLdevDetailList();
        List<?> cuLdevIdInfoList = changeLDEVID.getSelectCuLdevIdList();
        List<?> ssidsummarylist = changeLDEVID.getSelectSsidSummaryList();
        List<?> ssidDetailList = changeLDEVID.getSelectSsidDetailList();
        List<?> allDKCInfoList = changeLDEVID.getSelectAllDKCInfoList();
        SJctrResourceGroupUtility rsgUty = changeLDEVID.getRsgUty();
        List<?> vldevList = changeLDEVID.getVLdevList();
        if (ldevDetailList == null || ldevDetailList.size() == 0) {
            bRet = false;
            this.getLogUty().putlog("checkStartData_ALL", "ldevDetailList not found", null, 40000);
        }
        if (cuLdevIdInfoList == null || cuLdevIdInfoList.size() == 0) {
            bRet = false;
            this.getLogUty().putlog("checkStartData_ALL", "cuLdevIdInfoList not found", null, 40000);
        }
        if (ssidsummarylist == null || ssidsummarylist.size() == 0) {
            bRet = false;
            this.getLogUty().putlog("checkStartData_ALL", "ssidsummarylist not found", null, 40000);
        }
        if (ssidDetailList == null) {
            bRet = false;
            this.getLogUty().putlog("checkStartData_ALL", "ssidDetailList not found", null, 40000);
        }
        if (allDKCInfoList == null) {
            bRet = false;
            this.getLogUty().putlog("checkStartData_ALL", "allDKCInfoList not found", null, 40000);
        }
        if (rsgUty == null) {
            bRet = false;
            this.getLogUty().putlog("checkStartData_ALL", "rsgUty not found", null, 40000);
        }
        if (vldevList == null) {
            bRet = false;
            this.getLogUty().putlog("checkStartData_ALL", "vldevList not found", null, 40000);
        }
        if (bRet) {
            this.checkConstructData_ALL();
        }
        return bRet;
    }

    private boolean checkStartData_LdevName() {
        SJctrChangeLDEVNameData changeLdevName;
        List<?> ldevNameList;
        boolean bRet = true;
        List<?> changeLdevNameList = this.getCache("CHANGE_LDEVNAME");
        Object changeLdevNameObj = changeLdevNameList.get(0);
        if (!(changeLdevNameObj instanceof SJctrChangeLDEVNameData)) {
            SJctrCVSUtility.output_Error(30, 22, 105248);
        }
        if ((ldevNameList = (changeLdevName = (SJctrChangeLDEVNameData)changeLdevNameList.get(0)).getLdevNameList()) == null || ldevNameList.size() == 0) {
            bRet = false;
            this.getLogUty().putlog("checkStartData_LdevName", "ldevNameList not found", null, 40000);
        }
        return bRet;
    }

    public int getTransition() {
        int iTransition = 0;
        List<?> changeLDEVID = this.getCache("CHANGE_LDEVID");
        List<?> changeLdevName = this.getCache("CHANGE_LDEVNAME");
        if (changeLDEVID == null || changeLDEVID.size() == 0) {
            if (changeLdevName == null || changeLdevName.size() == 0) {
                this.getLogUty().putlog("checkTransition", "changeLDEVID and changeLdevName not found", null, 40000);
                SJctrCVSUtility.output_Error(30, 22, 105133);
            } else {
                iTransition = 1;
            }
        } else {
            iTransition = 2;
        }
        return iTransition;
    }

    @Override
    public boolean checkConstructData() {
        boolean bRet = true;
        int iTransition = this.getTransition();
        if (iTransition != 2) {
            this.checkConstructData_LdevName();
        }
        return bRet;
    }

    private void checkConstructData_ALL() {
        List<?> changeLDEVIDList = this.getCache("CHANGE_LDEVID");
        SJctrChangeLDEVIDData changeLDEVID = (SJctrChangeLDEVIDData)changeLDEVIDList.get(0);
        List<?> ldevDetailList = changeLDEVID.getSelectLdevDetailList();
        for (int i = 0; i < ldevDetailList.size(); ++i) {
            SJctrLDEVDetail checkLdevDetail = null;
            SJctrLDEVDetail ldevDetail = (SJctrLDEVDetail)ldevDetailList.get(i);
            String emulationTypeName = this.getComUtility().getCVSUtility().getEmulationTypeName(ldevDetail.getIEmulationType());
            int targetEmuTypeFlg = this.getComUtility().getCVSUtility().getEmuTypeGroup(emulationTypeName);
            String checkEmulationTypeName = "";
            int checkEmulationTypeFlg = 0;
            if (i == 0) continue;
            checkLdevDetail = (SJctrLDEVDetail)ldevDetailList.get(i - 1);
            checkEmulationTypeName = this.getComUtility().getCVSUtility().getEmulationTypeName(checkLdevDetail.getIEmulationType());
            checkEmulationTypeFlg = this.getComUtility().getCVSUtility().getEmuTypeGroup(checkEmulationTypeName);
            if (targetEmuTypeFlg == checkEmulationTypeFlg) continue;
            this.getLogUty().putlog("checkConstructData", "Emulation Type is not the same", null, 40000);
            SJctrCVSUtility.output_Error(30, 22, 105160);
        }
    }

    private void checkConstructData_LdevName() {
    }

    @Override
    public boolean checkEndData() {
        boolean bRet = true;
        int iTransition = this.getTransition();
        bRet = iTransition == 2 ? this.checkEndData_ALL() : this.checkEndData_LdevName();
        return bRet;
    }

    private boolean checkEndData_ALL() {
        boolean bRet = true;
        List<?> changeLDEVIDDataList = this.getCache("CHANGE_LDEVID");
        SJctrChangeLDEVIDData changeLDEVIDData = (SJctrChangeLDEVIDData)changeLDEVIDDataList.get(0);
        List<?> ldevDetailList = changeLDEVIDData.getSelectLdevDetailList();
        List<?> cuLdevIdInfoList = changeLDEVIDData.getSelectCuLdevIdList();
        SJctrResourceGroupUtility rsgUty = changeLDEVIDData.getRsgUty();
        boolean bChkLDEVName = this.getLDEVNameModel().checkBoxLdevName();
        boolean bChkLDEVID = this.getLDEVIDModel().checkBoxLDEVID();
        boolean bChkMPPKG = this.getMPPKGModel().checkBoxMPPKG();
        boolean bChkT10PI = this.getT10PIModel().checkBox();
        ArrayList<SJctrLDEVDetail> newLdevIdList = new ArrayList<SJctrLDEVDetail>();
        if (!(bChkLDEVName || bChkLDEVID || bChkMPPKG || bChkT10PI)) {
            bRet = false;
        }
        if (bRet && bChkLDEVName) {
            bRet = this.getLDEVNameModel().checkLDEVName(ldevDetailList.size());
        }
        if (bRet && bChkLDEVID) {
            bRet = this.checkLDEVID(ldevDetailList, cuLdevIdInfoList, newLdevIdList, rsgUty);
        }
        if (bRet && bChkMPPKG) {
            bRet = this.checkMPBlade();
        }
        if (bRet && bChkT10PI) {
            bRet = this.checkT10PI();
        }
        if (bRet && newLdevIdList.size() == 0) {
            for (int i = 0; i < ldevDetailList.size(); ++i) {
                SJctrLDEVDetail ldevDetail = (SJctrLDEVDetail)ldevDetailList.get(i);
                newLdevIdList.add(ldevDetail);
            }
        }
        ArrayList newLdevDetailList = null;
        if (bRet) {
            newLdevDetailList = this.newLdevDetailList(newLdevIdList, ldevDetailList);
        }
        if (bRet && bChkLDEVID) {
            bRet = this.checkMargeSSID(newLdevDetailList);
        }
        if (bRet && bChkLDEVName) {
            bRet = this.getLDEVNameModel().margeLdevName(newLdevDetailList);
        }
        if (bRet && bChkMPPKG) {
            this.margeMPPKG(newLdevDetailList);
        }
        if (bRet && bChkT10PI) {
            this.margeT10PI(newLdevDetailList);
        }
        if (bRet) {
            this.makeOutput(newLdevDetailList, ldevDetailList);
        }
        bRet = true;
        return bRet;
    }

    private boolean checkEndData_LdevName() {
        boolean bRet = true;
        SJctrChangeLDEVNameData outputLdevNameData = new SJctrChangeLDEVNameData();
        ArrayList<SJmoLdevNicknameInfo> newLdevNameList = new ArrayList<SJmoLdevNicknameInfo>();
        List<?> changeLDEVNameList = this.getCache("CHANGE_LDEVNAME");
        SJctrChangeLDEVNameData changeLDEVName = (SJctrChangeLDEVNameData)changeLDEVNameList.get(0);
        boolean bChkLDEVName = this.getLDEVNameModel().checkBoxLdevName();
        if (bChkLDEVName) {
            bRet = this.getLDEVNameModel().checkLDEVName(changeLDEVName.getLdevNameList().size());
        }
        if (bRet) {
            this.makeLDEVNameListClone(newLdevNameList, changeLDEVName.getLdevNameList());
            outputLdevNameData.setLdevNameList(newLdevNameList);
        }
        if (bRet && bChkLDEVName) {
            bRet = this.getLDEVNameModel().margeLdevName_LdevName(newLdevNameList);
        }
        if (bRet) {
            this.makeOutput_LdevName(outputLdevNameData);
        }
        bRet = true;
        return bRet;
    }

    private void makeLDEVNameListClone(ArrayList newLdevNameList, List<?> oldLdevNameList) {
        for (int i = 0; i < oldLdevNameList.size(); ++i) {
            SJmoLdevNicknameInfo ldevNameInfo = (SJmoLdevNicknameInfo)oldLdevNameList.get(i);
            try {
                newLdevNameList.add(ldevNameInfo.clone());
                continue;
            }
            catch (Exception e) {
                this.getLogUty().putlog("checkEndData_LdevName", "Clone making failure", null, 40000);
                SJctrCVSUtility.output_Error(30, 22, 105171);
            }
        }
    }

    private SJctrChangeLDEVSettingLDEVNameDataModel getLDEVNameModel() {
        SJctrChangeLDEVSettingLDEVNameDataModel ldevNameModel = null;
        ldevNameModel = (SJctrChangeLDEVSettingLDEVNameDataModel)this.getDataObjectModel("COM_LDEVNAME");
        return ldevNameModel;
    }

    private SJctrChangeLDEVSettingLDEVIDDataModel getLDEVIDModel() {
        SJctrChangeLDEVSettingLDEVIDDataModel ldevIdModel = null;
        ldevIdModel = (SJctrChangeLDEVSettingLDEVIDDataModel)this.getDataObjectModel("COM_LDEVID");
        return ldevIdModel;
    }

    private SJctrChangeLDEVSettingMPPKGDataModel getMPPKGModel() {
        SJctrChangeLDEVSettingMPPKGDataModel mppkgModel = null;
        mppkgModel = (SJctrChangeLDEVSettingMPPKGDataModel)this.getDataObjectModel("COM_MPPKGGRP");
        return mppkgModel;
    }

    private boolean checkLDEVID(List<?> ldevDetailList, List cuLdevIdInfoList, List newLdevIdList, SJctrResourceGroupUtility rsgUty) {
        boolean bRet = true;
        List<?> changeLDEVIDDataList = this.getCache("CHANGE_LDEVID");
        SJctrChangeLDEVIDData changeLDEVIDData = (SJctrChangeLDEVIDData)changeLDEVIDDataList.get(0);
        SJmoRscUtilLdev ldevUtl = (SJmoRscUtilLdev)changeLDEVIDData.getRscLdevList().get(0);
        ldevUtl.clearRsvData();
        if (!this.getLDEVIDModel().chkSelectData()) {
            bRet = false;
            SJctrCVSUtility.output_Error(30, 22, 105148);
        }
        SJctrLDEVDetail ldevDetail = (SJctrLDEVDetail)ldevDetailList.get(0);
        String sEmu = this.getComUtility().getDataChangeTable().getEmulationTypeName(ldevDetail.getIEmulationType());
        int iEmuGroup = this.getComUtility().getDataChangeTable().getEmuGroup(sEmu);
        int iEmu = this.getComUtility().getCVSUtility().getEmu(sEmu);
        if (!this.getLDEVIDModel().checkLDEVID(ldevDetailList.size(), iEmuGroup, cuLdevIdInfoList, newLdevIdList, iEmu, ldevUtl, rsgUty, changeLDEVIDData.getITseAttribute(), changeLDEVIDData.getVLdevList())) {
            bRet = false;
            int iErrorCnt = ldevDetailList.size() - newLdevIdList.size();
            String[] msgArg = new String[]{Integer.toString(iErrorCnt)};
            SJctrError err = new SJctrError(30, 22, 105132);
            SJcException exp = err.createException();
            exp.getMsg().setMsg_argument(msgArg);
            throw exp;
        }
        return bRet;
    }

    private boolean checkMPBlade() {
        boolean bRet = true;
        if (this.getMPPKGModel().getMPPKGDataModel().getSelection().equals("Space")) {
            bRet = false;
            SJctrCVSUtility.output_Error(30, 22, 105148);
        }
        return bRet;
    }

    private boolean checkT10PI() {
        boolean rtn = false;
        if (this.getT10PIModel().getT10PIDataModel().getSelect() == null) {
            SJctrCVSUtility.output_Error(30, 22, 105459);
        }
        if (this.getT10PIModel().getT10PIDataModel().getSelect().equals("")) {
            SJctrCVSUtility.output_Error(30, 22, 105459);
        }
        String string = this.getT10PIModel().getT10PIDataModel().getSelect();
        this.getT10PIModel().getT10PIDataModel();
        if (string.equals("COM_DUMMY")) {
            SJctrCVSUtility.output_Error(30, 22, 105459);
        }
        rtn = true;
        return rtn;
    }

    private ArrayList newLdevDetailList(List newLdevIdList, List ldevDetailList) {
        ArrayList<SJctrLDEVDetail> newLdevDetailList = new ArrayList<SJctrLDEVDetail>();
        for (int i = 0; i < newLdevIdList.size(); ++i) {
            SJctrLDEVDetail newLdevDetail = (SJctrLDEVDetail)newLdevIdList.get(i);
            SJctrLDEVDetail oldLdevdetail = (SJctrLDEVDetail)ldevDetailList.get(i);
            SJctrLDEVDetail listInLdevDetail = new SJctrLDEVDetail();
            listInLdevDetail.setDetailExData(oldLdevdetail);
            listInLdevDetail.setLdevIndex(newLdevDetail.getSLdkc(), newLdevDetail.getSCu(), newLdevDetail.getSLdev());
            newLdevDetailList.add(listInLdevDetail);
        }
        return newLdevDetailList;
    }

    private boolean checkMargeSSID(List newLdevDetailList) {
        boolean bRet = true;
        List<?> changeLDEVIDDataList = this.getCache("CHANGE_LDEVID");
        SJctrChangeLDEVIDData changeLDEVIDData = (SJctrChangeLDEVIDData)changeLDEVIDDataList.get(0);
        List<?> ssidSummaryList = changeLDEVIDData.getSelectSsidSummaryList();
        SJmoSsidSummary ssidSummary = (SJmoSsidSummary)ssidSummaryList.get(0);
        ArrayList ssidDetailList = changeLDEVIDData.getSelectSsidDetailList();
        SJmoRscUtilSsid SsidUtl = (SJmoRscUtilSsid)changeLDEVIDData.getRscSsidList().get(0);
        SsidUtl.clearRsvData();
        for (int i = 0; i < newLdevDetailList.size(); ++i) {
            SJctrLDEVDetail newLdevDetail = (SJctrLDEVDetail)newLdevDetailList.get(i);
            int iSsidNumber = SJctrCVSUtility.getSSID(newLdevDetail.getSLdkc(), newLdevDetail.getSCu(), newLdevDetail.getSLdev(), ssidDetailList);
            if (iSsidNumber == 0) {
                iSsidNumber = SJctrCVSUtility.getSpaceSSID(0, ssidDetailList, SsidUtl, newLdevDetail);
            }
            if (iSsidNumber == -1) {
                SJctrCVSUtility.output_Error(30, 22, 105131);
            }
            newLdevDetail.setISSID(iSsidNumber);
            if (SJctrCVSUtility.getSSID(newLdevDetail.getSLdkc(), newLdevDetail.getSCu(), newLdevDetail.getSLdev(), ssidDetailList) != 0) continue;
            ssidDetailList = SJctrCVSUtility.setSSID(newLdevDetail.getSLdkc(), newLdevDetail.getSCu(), newLdevDetail.getSLdev(), newLdevDetail.getISSID(), ssidDetailList, ssidSummary.getSSIDBoundary());
        }
        return bRet;
    }

    private void margeMPPKG(List newLdevDetailList) {
        int iMPBladeID = this.getMPPKGModel().getMPPKGDataModel().getSelectionMpBladeData();
        for (int i = 0; i < newLdevDetailList.size(); ++i) {
            SJctrLDEVDetail newLdevDetail = (SJctrLDEVDetail)newLdevDetailList.get(i);
            newLdevDetail.setByCurrentMPBladeID((byte)iMPBladeID);
        }
    }

    private void margeT10PI(List newLdevDetailList) {
        boolean bT10pi = this.getT10PIModel().getT10PIDataModel().isEnable();
        for (int i = 0; i < newLdevDetailList.size(); ++i) {
            SJctrLDEVDetail newLdevDetail = (SJctrLDEVDetail)newLdevDetailList.get(i);
            newLdevDetail.setBT10pi(bT10pi);
        }
    }

    private void makeOutput(List newLdevDetailList, List ldevDetailList) {
        ArrayList<List> outputDataList = new ArrayList<List>();
        outputDataList.add(ldevDetailList);
        outputDataList.add(newLdevDetailList);
        this.putCache("KEY_DD12_DIALOG_OUT", outputDataList);
    }

    private void makeOutput_LdevName(SJctrChangeLDEVNameData outputLdevNameData) {
        ArrayList<SJctrChangeLDEVNameData> outputDataList = new ArrayList<SJctrChangeLDEVNameData>();
        outputDataList.add(outputLdevNameData);
        this.putCache("KEY_DD12_DIALOG_OUT_LDEVNAME", outputDataList);
    }

    private void ViewLDEVIDButtonAction() {
        List<?> changeLDEVIDList = this.getCache("CHANGE_LDEVID");
        SJctrChangeLDEVIDData changeLDEVID = (SJctrChangeLDEVIDData)changeLDEVIDList.get(0);
        List<?> cuLdevIdInfoList = changeLDEVID.getSelectCuLdevIdList();
        List<?> ldevDetailList = changeLDEVID.getSelectLdevDetailList();
        SJctrResourceGroupUtility rsgUty = changeLDEVID.getRsgUty();
        ArrayList<SJctrResourceGroupUtility> rsg = new ArrayList<SJctrResourceGroupUtility>();
        rsg.add(rsgUty);
        HashMap map = new HashMap();
        List<String> emu = this.getEmuTypeNameList(ldevDetailList);
        map.put("EMUTYPE_DATA", emu);
        map.put("CU_LDEVID_INFO_DATA", cuLdevIdInfoList);
        List<?> changeLDEVIDDataList = this.getCache("CHANGE_LDEVID");
        SJctrChangeLDEVIDData changeLDEVIDData = (SJctrChangeLDEVIDData)changeLDEVIDDataList.get(0);
        map.put("KEY_STR_VIEWLDEVID_UTL", changeLDEVIDData.getRscLdevList());
        ArrayList<String> Cu = new ArrayList<String>(1);
        Cu.add("00");
        map.put("KEY_CU_DATA", Cu);
        map.put("RSG_DATA", rsg);
        ArrayList<Integer> tseList = new ArrayList<Integer>();
        int iTseAttri = SJctrCVSUtility.getTseAttribute_LdevDetail(ldevDetailList);
        tseList.add(iTseAttri);
        map.put("KEY_SEL_TSEATTRI", tseList);
        List<?> vldevList = changeLDEVID.getVLdevList();
        map.put("KEY_VSS_LDEV_DATA", vldevList);
        SJctrRelatedDispDataObject relatedObj = this.createDialog(SJctrViewLDEVIDDC.class, map);
        this.addUpdateDisp(relatedObj);
    }

    private List<String> getEmuTypeNameList(List<?> ldevDetailList) {
        ArrayList<String> emu = new ArrayList<String>();
        HashMap<String, String> emuMap = new HashMap<String, String>();
        String emulationTypeName = "";
        for (int i = 0; i < ldevDetailList.size(); ++i) {
            SJctrLDEVDetail ldevDetail = (SJctrLDEVDetail)ldevDetailList.get(i);
            emulationTypeName = this.getComUtility().getCVSUtility().getEmulationTypeName(ldevDetail.getIEmulationType());
            if (emuMap.get(emulationTypeName) == null) {
                emuMap.put(emulationTypeName, emulationTypeName);
                emu.add(emulationTypeName);
                continue;
            }
            if (((String)emuMap.get(emulationTypeName)).equals(emulationTypeName)) continue;
            emuMap.put(emulationTypeName, emulationTypeName);
            emu.add(emulationTypeName);
        }
        return emu;
    }

    private SJctrChangeLDEVSettingT10PIRadioDataModel getT10PIModel() {
        return (SJctrChangeLDEVSettingT10PIRadioDataModel)this.getDataObjectModel("COM_T10PIGRP");
    }

    public static enum NOTIFY_CHANGE_LDEV implements SJctrNotifyState
    {
        VIEW_LDEVID;

    }
}

