/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.cvs.comdialog.editssid;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrDialogDataController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrNotifyState;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.event.SJctrMessageEvent;
import sanproject.sn2.controller.com.model.event.SJctrMessageEventListener;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.cvs.com.SJctrCVSMacro;
import sanproject.sn2.controller.wizard.cvs.com.SJctrCVSUtility;
import sanproject.sn2.controller.wizard.cvs.com.SJctrSSIDDetail;
import sanproject.sn2.controller.wizard.cvs.comdialog.changessid.SJctrChangeSSIDDC;
import sanproject.sn2.controller.wizard.cvs.comdialog.editssid.SJctrChangeSSIDButtonModel;
import sanproject.sn2.controller.wizard.cvs.comdialog.editssid.SJctrEditSSIDTableModel;
import sanproject.sn2.controller.wizard.cvs.createldevs.base.com.SJctrCreateLDEVsDef;
import sanproject.sn2.controller.wizard.cvs.createldevs.base.model.SJctrCreateLDEVsBaseTableModel;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;
import sanproject.sn2.model.data.volume.SJmoSsidDetail;
import sanproject.sn2.model.data.volume.SJmoSsidSummary;
import sanproject.sn2.modelrc.util.SJmoRscUtilSsid;

public class SJctrEditSSIDDC
extends SJctrDialogDataController
implements SJctrCreateLDEVsDef,
SJctrCVSMacro {
    public List<SJmoSsidSummary> ssidSummary = null;
    public List<SJmoSsidDetail> ssidDetail = null;
    public List<SJmoSsidDetail> ssidDetailWk = null;
    public List<SJctrCreateLDEVsBaseTableModel> createTable = null;

    public SJctrEditSSIDDC() throws SJcException {
        super(33595449);
        this.initDataModel();
        this.initListener();
    }

    @Override
    public String getDispName() {
        return this.getComUtility().getGuidance("CVS", "DISP_EDIT_SSID");
    }

    private void initDataModel() {
        this.addDataObjectModel("COM_TABLE", new SJctrEditSSIDTableModel());
        this.addDataObjectModel("COM_CHGSSID_BTN", new SJctrChangeSSIDButtonModel());
        this.addDataObjectModel("COM_FOOTER", new SJctrFooterDataModel(SJctrFooterDataModel.BGO_OKCANCEL));
    }

    @Override
    public boolean checkStartData() {
        boolean ret = true;
        List<?> targetList = this.getCache("SSID_SUMMARY_DATA");
        List<?> targetList2 = this.getCache("SSID_DETAIL_DATA");
        List<?> targetList3 = this.getCache("KEY_CREATE_TABLE_DATA");
        List<?> SSIDList = this.getCache("KEY_STR_CHANGESSID_UTL");
        if (targetList == null || targetList2 == null || targetList3 == null) {
            ret = false;
        }
        if (ret) {
            this.ssidSummary = targetList;
            this.ssidDetail = targetList2;
            this.ssidDetailWk = new ArrayList<SJmoSsidDetail>();
            for (SJmoSsidDetail ssid : this.ssidDetail) {
                SJmoSsidDetail createSsidDetail = null;
                try {
                    createSsidDetail = (SJmoSsidDetail)ssid.clone();
                }
                catch (Exception e) {
                    this.getLogUty().putlog("EditLDEVs", "SJmoLdevDetail clone fail", e, 20000);
                    ret = false;
                    break;
                }
                this.ssidDetailWk.add(createSsidDetail);
            }
        }
        if (SSIDList == null) {
            ret = false;
        } else if (SSIDList.size() == 0) {
            ret = false;
        }
        if (!ret) {
            SJctrCVSUtility.output_Error(200, 22, 105133);
        }
        return ret;
    }

    @Override
    public boolean checkEndData() {
        boolean ret = true;
        SJctrError headErr = new SJctrError(0, 0, 0);
        ArrayList<List<SJmoSsidDetail>> outList = new ArrayList<List<SJmoSsidDetail>>();
        outList.add(this.ssidDetailWk);
        this.putCache("KEY_DD39_DIALOG_OUT", outList);
        SJctrLogUty.debug(this.getClass().getSimpleName(), "checkEndData", "return = " + ret);
        return ret;
    }

    private void initListener() {
        this.addMessageEventListener(NOTIFY_EDIT_SSID.CHANGE_SSID, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrEditSSIDDC.this.enterChangeSSIDAction();
            }
        });
        this.addMessageEventListener(SJctrDialogDataController.DIALOG_MSG.EXIT, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                Object notifyObj = event.getNofifyObject();
                if (notifyObj instanceof Map) {
                    Map map = (Map)notifyObj;
                    SJctrEditSSIDDC.this.exitChangeSSIDAction(map);
                }
            }
        });
    }

    private void enterChangeSSIDAction() {
        HashMap map = new HashMap();
        SJctrEditSSIDTableModel selectTable = (SJctrEditSSIDTableModel)this.getDataObjectModel("COM_TABLE");
        List<Object> addList = selectTable.getSelectedRowData();
        ArrayList<SJctrSSIDDetail> selectSsidList = new ArrayList<SJctrSSIDDetail>(addList.size());
        for (Object rowObj : addList) {
            SJctrSSIDDetail ssid = (SJctrSSIDDetail)rowObj;
            if (!ssid.getNewSSID().equals("Yes")) {
                SJctrError err = new SJctrError(30, 22, 105182);
                SJcException exp = err.createException();
                throw exp;
            }
            selectSsidList.add(ssid);
        }
        map.put("SELECT_SSID_DATA", selectSsidList);
        map.put("KEY_STR_CHANGESSID_UTL", this.getCache("KEY_STR_CHANGESSID_UTL"));
        SJctrRelatedDispDataObject relatedObj = this.createDialog(SJctrChangeSSIDDC.class, map);
        this.addUpdateDisp(relatedObj);
    }

    private void exitChangeSSIDAction(Map<String, List<?>> carryMap) {
        List<?> carrySsidList = carryMap.get("KEY_DD40_DIALOG_OUT");
        if (carrySsidList == null || carrySsidList.size() == 0) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "exitChangeSSIDAction", "KEY_DD40_DIALOG_OUT Not Found!!");
            return;
        }
        SJctrSSIDDetail startSsid = (SJctrSSIDDetail)carrySsidList.get(0);
        int iSSID = startSsid.getSSID();
        SJctrEditSSIDTableModel selectTable = (SJctrEditSSIDTableModel)this.getDataObjectModel("COM_TABLE");
        int[] iSelList = selectTable.getSelectedRows();
        ArrayList tableListAll = (ArrayList)selectTable.getAllRowData();
        ArrayList tableListSrt = (ArrayList)selectTable.getSelectedRowData();
        boolean[] bSSIDList = new boolean[65535];
        for (int i = 0; i < tableListAll.size(); ++i) {
            SJctrSSIDDetail ssid = (SJctrSSIDDetail)tableListAll.get(i);
            boolean bSel = false;
            for (int j = 0; j < tableListSrt.size(); ++j) {
                SJctrSSIDDetail wkSsid = (SJctrSSIDDetail)tableListSrt.get(j);
                if (ssid.getLDKC() != wkSsid.getLDKC() || ssid.getCU() != wkSsid.getCU() || ssid.getStartLDEV() != wkSsid.getStartLDEV()) continue;
                bSel = true;
                break;
            }
            if (bSel || ssid.getSSID() < 0) continue;
            bSSIDList[ssid.getSSID()] = true;
        }
        ArrayList<SJctrSSIDDetail> freeSSID = new ArrayList<SJctrSSIDDetail>();
        for (int i = iSSID; i < 65535; ++i) {
            if (bSSIDList[i]) continue;
            SJctrSSIDDetail ssid = new SJctrSSIDDetail();
            ssid.setSSID(i);
            freeSSID.add(ssid);
        }
        List<?> wkSSIDList = this.getCache(KEY_CLASS_SSID_UTIL);
        SJmoRscUtilSsid wkSsidUsc = (SJmoRscUtilSsid)wkSSIDList.get(0);
        wkSsidUsc.clearRsvData();
        ArrayList wktableList = (ArrayList)selectTable.getSelectedRowDataOrder();
        for (int i = 0; i < wktableList.size(); ++i) {
            SJctrSSIDDetail ssidDetail = (SJctrSSIDDetail)wktableList.get(i);
            for (int j = 0; j < freeSSID.size(); ++j) {
                int chgSsid = ((SJctrSSIDDetail)freeSSID.get(j)).getSSID();
                SJmoLdevIndex ssidLdev = new SJmoLdevIndex();
                ssidLdev.setLdevIndex(ssidDetail.getLDKC(), ssidDetail.getCU(), ssidDetail.getStartLDEV());
                int iChk = wkSsidUsc.chkSsid(chgSsid, ssidLdev);
                if (iChk != 1) continue;
                freeSSID.remove(j);
            }
        }
        if (freeSSID.size() < iSelList.length) {
            int iErrorCnt = iSelList.length - freeSSID.size();
            String[] msgArg = new String[]{Integer.toString(iErrorCnt)};
            SJctrError err = new SJctrError(30, 22, 105473);
            SJcException exp = err.createException();
            exp.getMsg().setMsg_argument(msgArg);
            throw exp;
        }
        ArrayList tableList = (ArrayList)selectTable.removeSelectedRowData();
        block5: for (int i = 0; i < tableList.size(); ++i) {
            SJctrSSIDDetail ssidDetail = (SJctrSSIDDetail)tableList.get(i);
            ssidDetail.setSSID(((SJctrSSIDDetail)freeSSID.get(i)).getSSID());
            ArrayList<SJctrSSIDDetail> ary = new ArrayList<SJctrSSIDDetail>();
            ary.add(ssidDetail);
            selectTable.addRowData(ary, iSelList[i]);
            selectTable.setSortColumn(null, Boolean.TRUE);
            for (int j = 0; j < this.ssidDetailWk.size(); ++j) {
                SJmoSsidDetail wkSsid = this.ssidDetailWk.get(j);
                if (ssidDetail.getLDKC() != wkSsid.getLDKC() || ssidDetail.getCU() != wkSsid.getCU() || ssidDetail.getStartLDEV() != wkSsid.getStartLDEV()) continue;
                this.ssidDetailWk.set(j, ssidDetail);
                continue block5;
            }
        }
        selectTable.addRowSelectionList(tableList);
        selectTable.doRefresh("COM_COL_SSID");
    }

    public static enum NOTIFY_EDIT_SSID implements SJctrNotifyState
    {
        CHANGE_SSID;

    }
}

