/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.editalert.settings.tab.email.model;

import sanproject.sn2.controller.com.SJctrIpAddrUtility;
import sanproject.sn2.controller.com.model.SJctrRadioButtonGroupDataModel;
import sanproject.sn2.controller.com.model.SJctrSimpleDataModel;
import sanproject.sn2.controller.com.model.SJctrTextBoxDataModel;
import sanproject.sn2.controller.wizard.editalert.com.SJctrEditAlertDef;
import sanproject.sn2.controller.wizard.editalert.com.SJctrEditAlertValidator;
import sanproject.sn2.controller.wizard.editalert.settings.com.SJctrAlertDataModel;

public class SJctrEmailSettingsMailServerModel
extends SJctrSimpleDataModel
implements SJctrEditAlertDef,
SJctrAlertDataModel {
    private SJctrTextBoxDataModel textModel;
    private SJctrRadioButtonGroupDataModel radioModel;

    public SJctrEmailSettingsMailServerModel() {
        this.initDataModel();
    }

    private void initDataModel() {
        this.textModel = new SJctrTextBoxDataModel();
        this.addDataModel("COM_TEXT", this.textModel);
        this.radioModel = new SJctrRadioButtonGroupDataModel();
        this.addDataModel("COM_RADIO", this.radioModel);
    }

    @Override
    public void setEnableAll(boolean flag) {
        this.textModel.setEnable(flag);
        this.radioModel.setEnable(flag);
    }

    public void setServerText(String text) {
        this.textModel.setValue(text);
    }

    public String getServerText() {
        return this.textModel.getValue();
    }

    public void setServerType(int type) {
        switch (type) {
            case 1: {
                this.radioModel.setSelect("COM_IDENTIFIER");
                break;
            }
            case 2: {
                this.radioModel.setSelect("COM_IPV4");
                break;
            }
            default: {
                this.radioModel.setSelect("COM_IPV6");
            }
        }
    }

    public int getServerType() {
        if (this.radioModel.isSelect("COM_IDENTIFIER")) {
            return 1;
        }
        if (this.radioModel.isSelect("COM_IPV4")) {
            return 2;
        }
        return 3;
    }

    public boolean chkData() {
        String text = this.textModel.getValue();
        if (this.radioModel.isSelect("COM_IDENTIFIER")) {
            SJctrEditAlertValidator.validateIdentifier(text);
        } else if (this.radioModel.isSelect("COM_IPV4")) {
            new SJctrIpAddrUtility.IPv4().chkRegex(text);
        } else {
            new SJctrIpAddrUtility.IPv6().chkRegex(text);
        }
        return true;
    }

    @Override
    public void updateDataModel() {
        this.radioModel.add("COM_IDENTIFIER", this.getComUtility().getGuidance("IDENTIFIER"));
        this.radioModel.add("COM_IPV4", this.getComUtility().getGuidance("IPV4"));
        this.radioModel.add("COM_IPV6", this.getComUtility().getGuidance("IPV6"));
    }
}

