/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.encryption.kmip.autobackupkeys;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import sanproject.serverux.dataimpl.SetEncryptionKeyBackup_IN;
import sanproject.serverux.dataimpl.SetEncryptionKeyBackup_OUT;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.SJcMessage;
import sanproject.sn2.com.utility.Logger.SJcAuditLogApplyElemCon;
import sanproject.sn2.com.utility.Logger.inf.SJcAuditLoggerInterface;
import sanproject.sn2.com.utility.SJcLogUty;
import sanproject.sn2.controller.com.SJctrApplyController;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrEncryptionKeysUtility;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.wizard.encryption.com.SJctrCreateKMSInfo;
import sanproject.sn2.controller.wizard.encryption.com.SJctrEncryptionAuditLogUty;
import sanproject.sn2.controller.wizard.encryption.com.SJctrEncryptionKeyDef;
import sanproject.sn2.controller.wizard.encryption.kmip.autobackupkeys.SJctrAutoDeleteBackupServerAuditLog;
import sanproject.sn2.controller.wizard.encryption.kmip.backupkeys.ctrl.SJctrBackupKeysToServerAuditLog;
import sanproject.sn2.controller.wizard.encryption.kmip.delbackserver.SJctrDeleteBackupServerConfirmData;
import sanproject.sn2.datasupplier.SJdsSupplierAgent;
import sanproject.sn2.kms.common.SJkmsBackupInfo;
import sanproject.sn2.kms.common.SJkmsCreateInfo;
import sanproject.sn2.kms.common.SJkmsDeleteInfo;
import sanproject.sn2.kms.common.SJkmsReferInfo;
import sanproject.sn2.kms.exception.SJkmsCommunicationException;
import sanproject.sn2.kms.util.SJkmsCommunicationUty;
import sanproject.sn2.kms.util.SJkmsPasswordUty;

public class SJctrAutoBackupKeysToServerAC
extends SJctrApplyController
implements SJctrEncryptionKeyDef {
    private String product_Num = "";
    protected SJkmsBackupInfo backup_Info = null;
    private byte[] passwd = null;
    protected SJctrEncryptionAuditLogUty.SJctrBackRestoreAuditLog backRestAudit = null;
    private SJctrAutoDeleteBackupServerAuditLog deleteAdtLog = null;
    private SJctrError deleteResult = new SJctrError(0, 0, 0);
    private SJctrError setSucceededFlgResult = new SJctrError(0, 0, 0);
    private boolean backupFlg = false;
    private String new_Uuid = null;
    private SJkmsBackupInfo backup_ResultInfo = null;
    protected SJctrEncryptionAuditLogUty.EncryptionOperation backupAdtTitle = SJctrEncryptionAuditLogUty.EncryptionOperation.BACKUPKEYS_TO_SERVER_AUTO;
    private SJctrBackupKeysToServerAuditLog adtLog = null;

    public SJctrAutoBackupKeysToServerAC(String productNum, SJkmsBackupInfo backupInfo) {
        this.product_Num = productNum;
        this.backup_Info = backupInfo;
    }

    @Override
    public ArrayList<?> getSetList() {
        SetEncryptionKeyBackup_IN backup_Pass = new SetEncryptionKeyBackup_IN();
        ArrayList<SetEncryptionKeyBackup_IN> setList = new ArrayList<SetEncryptionKeyBackup_IN>();
        SJkmsCreateInfo kmsData = new SJkmsCreateInfo();
        SJctrCreateKMSInfo data = new SJctrCreateKMSInfo();
        try {
            kmsData = SJkmsPasswordUty.getPassword(this.product_Num);
        }
        catch (SJcException ex) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "getSetList", "failed getPassword.");
            data = this.setCreateKMSInfo(null, ex);
            this.createCreateKeysAuditLog(ex, data);
            throw ex;
        }
        data = this.setCreateKMSInfo(kmsData, null);
        this.createCreateKeysAuditLog(null, data);
        this.passwd = kmsData.getCreateDataDEK();
        String Str_pass = "";
        Str_pass = SJkmsPasswordUty.convertPasswordtoStr(this.passwd);
        backup_Pass.setStrPassword(Str_pass);
        setList.add(backup_Pass);
        return setList;
    }

    @Override
    protected void applyStart(SJdsSupplierAgent supplier) {
        try {
            ArrayList<?> setList = this.getSetList();
            this.executeBackup(setList, supplier);
            SJctrEncryptionKeysUtility.executeSetSucceededFlg(this.backupFlg, this.new_Uuid, this.setSucceededFlgResult, this);
            this.executeBackupDelete();
        }
        catch (Exception e) {
            SJctrLogUty.info(this.getClass().getSimpleName(), "applyStart", "exception", e);
            SJctrError error = SJctrError.parseError(e);
            this.setError(error);
        }
    }

    @Override
    public int getLeadTime() {
        int iBackupLeadTime = 15;
        int iSize_1 = 1;
        int iSize_2 = (iSize_1 - iSize_1 / 2) / 30 * 15;
        int iDeleteLeadTime = iSize_2 + iSize_1 / 30 + 5;
        int iBackupSuccessFlugTime = 2;
        return iBackupLeadTime + iDeleteLeadTime + iBackupSuccessFlugTime;
    }

    public void setBackRestAdtLog(SJctrEncryptionAuditLogUty.SJctrBackRestoreAuditLog backRestAudit) {
        this.backRestAudit = backRestAudit;
    }

    public void setDeleteAdtLog(SJctrAutoDeleteBackupServerAuditLog adtLog) {
        this.deleteAdtLog = adtLog;
    }

    public void setCreateKeysAdtLog(SJctrBackupKeysToServerAuditLog adtLog) {
        this.adtLog = adtLog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeBackup(ArrayList<?> setList, SJdsSupplierAgent supplier) {
        SJctrLogUty.info(this.getClass().getSimpleName(), "executeBackup", "Apply Start!!(Backup Keys to Server)");
        Object resultObject = supplier.applyStart(this.getLockId(), setList);
        SJctrLogUty.info(this.getClass().getSimpleName(), "executeBackup", "Apply End!!(Backup Keys to Server)");
        SetEncryptionKeyBackup_OUT out = null;
        out = (SetEncryptionKeyBackup_OUT)resultObject;
        byte[] backupData = null;
        backupData = out.getByKeyData();
        String taskName = null;
        taskName = super.getTaskName();
        this.backup_Info.setBackupDataDEK(backupData);
        this.backup_Info.setBackuptaskName(taskName);
        this.backup_Info.setBackupDataPASSWD(this.passwd);
        this.backup_Info.setRegularBackup(true);
        SJkmsBackupInfo backupResult = null;
        SJkmsCommunicationException error = null;
        try {
            backupResult = SJkmsCommunicationUty.backup(this.product_Num, this.backup_Info);
            this.backupFlg = true;
            this.new_Uuid = backupResult.getUUID();
        }
        catch (SJkmsCommunicationException e) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "executeBackup", "backup failed.");
            error = e;
            backupResult = this.backup_Info;
            backupResult.setUUID("-");
        }
        finally {
            this.backup_ResultInfo = backupResult;
            SJcAuditLogApplyElemCon elemCon = SJctrEncryptionAuditLogUty.putEncKeysAuditoLog(this.backupAdtTitle, taskName, backupResult, this.backRestAudit, (SJcException)error);
            SJcAuditLoggerInterface adtLogger = SJcLogUty.getAuditLogger();
            adtLogger.putLog(elemCon);
            if (error != null) {
                super.setError(SJctrError.parseError(error));
                throw error;
            }
            super.setError(new SJctrError(0, 0, 0));
        }
    }

    private void executeBackupDelete() {
        SJctrDeleteBackupServerConfirmData conData = new SJctrDeleteBackupServerConfirmData();
        ArrayList<SJkmsReferInfo> referList = new ArrayList<SJkmsReferInfo>();
        List<Object> delList = new ArrayList();
        SJcException delException = null;
        try {
            List<Object> referListWk = new ArrayList();
            referListWk = SJkmsCommunicationUty.refer(this.product_Num);
            delList = SJkmsCommunicationUty.deleteRegularBackup(this.product_Num, this.backup_ResultInfo);
            for (SJkmsDeleteInfo sJkmsDeleteInfo : delList) {
                for (SJkmsReferInfo sJkmsReferInfo : referListWk) {
                    if (!sJkmsDeleteInfo.getUUID().equals(sJkmsReferInfo.getUUID())) continue;
                    referList.add(sJkmsReferInfo);
                }
            }
        }
        catch (SJcException ex) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "executeBackupDelete", "delete failed.");
            delException = ex;
            SJcMessage msg = delException.getMsg();
            SJkmsReferInfo sJkmsReferInfo = new SJkmsReferInfo();
            sJkmsReferInfo.setUUID("?");
            sJkmsReferInfo.setBackupComment("?");
            Date date = new Date();
            sJkmsReferInfo.setBackupDate(date);
            sJkmsReferInfo.setRegularBackup(true);
            referList.add(sJkmsReferInfo);
            SJkmsDeleteInfo sJkmsDeleteInfo = new SJkmsDeleteInfo();
            sJkmsDeleteInfo.setUUID("?");
            sJkmsDeleteInfo.setMsg(msg);
            delList.add(sJkmsDeleteInfo);
        }
        conData.setreferList(referList);
        conData.setDelList(delList);
        for (SJctrError err : conData.getErrList()) {
            if (err.getError() == 0) continue;
            this.deleteResult = err;
            break;
        }
        this.createDeleteAdtLog(this.deleteResult, conData);
        if (this.deleteResult.getError() != 0) {
            super.setError(this.deleteResult);
            throw this.deleteResult.createException();
        }
        super.setError(new SJctrError(0, 0, 0));
    }

    private void createDeleteAdtLog(SJctrError result, SJctrDeleteBackupServerConfirmData conData) {
        SJctrLogUty.info(this.getClass().getSimpleName(), "createDeleteAdtLog", "AuditLog Output start.");
        SJcAuditLoggerInterface adtLogger = SJcLogUty.getAuditLogger();
        this.deleteAdtLog.setPrintData(conData);
        SJcAuditLogApplyElemCon adtLogCont_IF = this.deleteAdtLog.createElemCon();
        adtLogCont_IF.setTaskName(this.getTaskName());
        String adtResult = "Success";
        SJcMessage adtMessage = null;
        if (result.getError() != 0) {
            adtResult = "Error";
            adtMessage = result.createException().getMsg();
            adtMessage.setModuleID(SJctrComUtility.toPaddingZeroString(result.getModule(), 2));
        }
        adtLogCont_IF.setOperationResult(adtResult);
        adtLogCont_IF.setOperationErrorCode(adtMessage);
        adtLogger.putLog(adtLogCont_IF);
        SJctrLogUty.info(this.getClass().getSimpleName(), "createDeleteAdtLog", "AuditLog Output end.");
    }

    private void createCreateKeysAuditLog(SJcException err, SJctrCreateKMSInfo data) {
        SJcLogUty.getLogger().info("[ENC]", "SJctrAutoBackupKeysToServerAC", "createCreateKeysAuditLog", "AuditLog Output start.");
        SJcAuditLoggerInterface SJcLogger2 = SJcLogUty.getAuditLogger();
        this.adtLog.setPrintData(data);
        SJcAuditLogApplyElemCon adtLogCont_IF = this.adtLog.createElemCon();
        adtLogCont_IF.setTaskName(this.getTaskName());
        String resultInfo = "Success";
        SJcMessage errMsg = null;
        if (err != null && err.getMsg() != null) {
            resultInfo = "Error";
            errMsg = err.getMsg();
        }
        adtLogCont_IF.setOperationResult(resultInfo);
        adtLogCont_IF.setOperationErrorCode(errMsg);
        SJcLogger2.putLog(adtLogCont_IF);
        SJcLogUty.getLogger().info("[ENC]", "SJctrAutoBackupKeysToServerAC", "createCreateKeysAuditLog", "AuditLog Output end.");
    }

    private SJctrCreateKMSInfo setCreateKMSInfo(SJkmsCreateInfo data, SJcException err) {
        SJctrCreateKMSInfo info = new SJctrCreateKMSInfo();
        if (data != null) {
            info.setStrUuid(data.getUUID());
        }
        if (err != null) {
            int md_ID = Integer.parseInt(err.getMsg().getModuleID());
            info.setStrResult("(" + err.getMsg().getFunctionID() + SJctrComUtility.toPaddingZeroString(md_ID, 2) + "-" + err.getMsg().getMsgID() + ")");
            String[] errMSG = err.getMsg().getMeansure_argument();
            String errServ_Msg = SJctrEncryptionKeysUtility.getErrMsg(errMSG);
            info.setStrServ_Reply(errServ_Msg);
        }
        return info;
    }
}

