/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.lunm.comdialog.changelunid;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import sanproject.sn2.base.session.inf.SJbaseUserSessionInterface;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.SJcMessage;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrDialogDataController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrPortUtility;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.com.model.SJctrTextBoxDataModel;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.lunm.com.SJctrLuPathLdevIndex;
import sanproject.sn2.controller.wizard.lunm.comdialog.changelunid.SJctrChangeLun;
import sanproject.sn2.controller.wizard.lunm.comdialog.changelunid.SJctrSelectPathLdev;
import sanproject.sn2.controller.wizard.lunm.mapluns.SJctrMapLUNsSubWizard;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetPortLunInfo;
import sanproject.sn2.model.data.device.SJmoPortIndex;
import sanproject.sn2.model.data.lu.SJmoPortLunDetail;
import sanproject.sn2.model.data.lu.SJmoPortLunInfo;
import sanproject.sn2.modelrc.util.SJmoRscUtilLun;

public class SJctrChangeLunIdDC
extends SJctrDialogDataController {
    private static final int DISP_ID = 33595396;
    private static final String KEY_LUN = "COM_LUN";
    private static final String KEY_FOOTER = "COM_FOOTER";
    private static final String KEY_LUN_HEX = "COM_LUN_HEX";
    public static int LUNID_MAX = SJctrPortUtility.PORT_LUN_MAX - 1;
    private boolean bLunIdDec;
    public static final Class<?> KEY_SELECTPATHLDEV = SJctrSelectPathLdev.class;
    public static final Class<?> KEY_CHANGELUNDATA = SJctrChangeLun.class;
    public static int CHANGELUNID_ERR1 = 107001;
    public static int CHANGELUNID_ERR2 = 105086;
    public static int CHANGELUNID_ERR3 = 105087;
    public static int CHANGELUNID_ERR4 = 109203;
    private List<SJctrLuPathLdevIndex> selectData = null;
    private List<SJctrLuPathLdevIndex> changeData = null;

    public SJctrChangeLunIdDC() throws SJcException {
        super(33595396);
        this.initDataModel();
    }

    private void initDataModel() {
        this.addDataObjectModel(KEY_LUN, new SJctrTextBoxDataModel());
        this.addDataObjectModel(KEY_FOOTER, new SJctrFooterDataModel(SJctrFooterDataModel.BGO_OKCANCEL));
    }

    @Override
    public void initGuidance(SJctrComUtility util) {
        super.initGuidance(util);
        String strLabel = "";
        SJctrTextBoxDataModel textBox = (SJctrTextBoxDataModel)this.getDataObjectModel(KEY_LUN);
        this.bLunIdDec = this.isLunIdNotationDec();
        strLabel = this.bLunIdDec ? "(" + util.getGuidance("LUNM", "DISP_LUN_MIN_DEC") + SJctrPortUtility.STR_HYPHEN + util.getGuidance("LUNM", "DISP_LUN_MAX_DEC") + ", " + util.getGuidance("COMMON", "DECIMAL_INPUT") + ")" : "(" + util.getGuidance("LUNM", "DISP_LUN_MIN") + SJctrPortUtility.STR_HYPHEN + util.getGuidance("LUNM", "DISP_LUN_MAX") + ", " + util.getGuidance("COMMON", "HEXADECIMAL_INPUT") + ")";
        textBox.setLabel(strLabel);
        this.getManageData().setData(KEY_LUN_HEX, !this.bLunIdDec);
    }

    @Override
    public boolean checkStartData() {
        boolean ret = true;
        List<?> targetList = this.getCache(KEY_SELECTPATHLDEV);
        if (targetList == null) {
            ret = false;
        } else if (targetList.size() == 0) {
            ret = false;
        } else {
            for (Object targetData : targetList) {
                if (targetData instanceof SJctrLuPathLdevIndex) continue;
                ret = false;
                break;
            }
        }
        if (!ret) {
            SJctrError err = new SJctrError(10, 22, CHANGELUNID_ERR1);
            SJcException exp = err.createException();
            throw exp;
        }
        this.selectData = targetList;
        SJctrTextBoxDataModel textBox = (SJctrTextBoxDataModel)this.getDataObjectModel(KEY_LUN);
        textBox.setValue(this.getDefaultStartLun());
        return ret;
    }

    @Override
    public boolean checkEndData() {
        boolean ret = true;
        boolean continuousFlg = true;
        SJctrTextBoxDataModel textbox = (SJctrTextBoxDataModel)this.getDataObjectModel(KEY_LUN);
        String startLunStr = textbox.getValue();
        int startLun = -1;
        try {
            startLun = this.bLunIdDec ? Integer.parseInt(startLunStr, 10) : Integer.parseInt(startLunStr, 16);
        }
        catch (NumberFormatException e) {
            ret = false;
            SJctrError err = new SJctrError(10, 22, CHANGELUNID_ERR3);
            SJcException exp = err.createException();
            throw exp;
        }
        if (startLun < 0 || LUNID_MAX < startLun) {
            ret = false;
            SJctrError err = new SJctrError(10, 22, CHANGELUNID_ERR2);
            SJcException exp = err.createException();
            throw exp;
        }
        if (ret) {
            this.changeData = new ArrayList<SJctrLuPathLdevIndex>(this.selectData.size());
            List<List<SJctrLuPathLdevIndex>> targetList = this.divisionPathLdevIndex(this.selectData);
            List<?> portLunList = this.getCache(SJmoGetPortLunInfo.class);
            for (List<SJctrLuPathLdevIndex> pathLdevList : targetList) {
                short port = pathLdevList.get(0).getPort();
                short hg = pathLdevList.get(0).getHostGroup();
                SJmoPortIndex portIndex = new SJmoPortIndex();
                portIndex.setSPort(port);
                int index = Collections.binarySearch(portLunList, portIndex);
                SJmoPortLunInfo portLun = (SJmoPortLunInfo)portLunList.get(index);
                ArrayList portLunDtlList = portLun.getAlHostGroupLun(hg);
                BitSet lunBitSet = this.getLunBitSet(portLunDtlList, pathLdevList);
                int changeNum = pathLdevList.size();
                BitSet bit = lunBitSet.get(startLun, startLun + changeNum);
                continuousFlg &= bit.cardinality() == changeNum;
                List<?> lunUtilList = this.getCache(SJctrMapLUNsSubWizard.KEY_LUN_UTIL_DATA);
                SJmoRscUtilLun rscUtilLun = (SJmoRscUtilLun)lunUtilList.get(0);
                this.resetRscUtil();
                rscUtilLun.clearRsvData();
                int lunIndex = 0;
                for (SJctrLuPathLdevIndex pathLdev : pathLdevList) {
                    int checkRet = 3;
                    lunIndex = startLun;
                    while (true) {
                        if ((lunIndex = lunBitSet.nextSetBit(lunIndex)) == -1 || lunIndex >= SJctrPortUtility.PORT_LUN_MAX) {
                            ret = false;
                            SJctrError err = new SJctrError(10, 22, CHANGELUNID_ERR3);
                            SJcException exp = err.createException();
                            throw exp;
                        }
                        checkRet = rscUtilLun.chkLunID(pathLdev.getPort(), pathLdev.getHostGroup(), (short)lunIndex);
                        if (checkRet == 0) break;
                        if (checkRet == 3) {
                            continuousFlg = false;
                        }
                        ++lunIndex;
                    }
                    SJctrLuPathLdevIndex changeLun = new SJctrLuPathLdevIndex(pathLdev.getPort(), pathLdev.getHostGroup(), (short)lunIndex, pathLdev.getLdkc(), pathLdev.getCu(), pathLdev.getLdev());
                    lunBitSet.clear(lunIndex);
                    this.changeData.add(changeLun);
                }
            }
        }
        if (ret) {
            this.putCache(KEY_CHANGELUNDATA, this.changeData);
        }
        if (!continuousFlg) {
            SJcMessage msg = new SJcMessage(Integer.toString(10), Integer.toString(22), Integer.toString(CHANGELUNID_ERR4));
            SJctrRelatedDispDataObject related = this.createMsgDialog(msg);
            this.addUpdateDisp(related);
        }
        return ret;
    }

    private BitSet getLunBitSet(List<SJmoPortLunDetail> portLunDtlList, List<SJctrLuPathLdevIndex> targetList) {
        BitSet lunBitSet = new BitSet(SJctrPortUtility.PORT_LUN_MAX);
        lunBitSet.set(0, SJctrPortUtility.PORT_LUN_MAX);
        for (SJmoPortLunDetail portLunDtl : portLunDtlList) {
            lunBitSet.clear(portLunDtl.getSLUN());
        }
        for (SJctrLuPathLdevIndex target : targetList) {
            lunBitSet.set(target.getLun());
        }
        return lunBitSet;
    }

    private List<List<SJctrLuPathLdevIndex>> divisionPathLdevIndex(List<SJctrLuPathLdevIndex> portLdevList) {
        ArrayList<List<SJctrLuPathLdevIndex>> retList = new ArrayList<List<SJctrLuPathLdevIndex>>(portLdevList.size());
        ArrayList<SJctrLuPathLdevIndex> tmpList = new ArrayList<SJctrLuPathLdevIndex>(portLdevList.size());
        tmpList.addAll(portLdevList);
        int index = 0;
        HashMap portHgmap = new HashMap();
        while (index < tmpList.size()) {
            SJctrLuPathLdevIndex pathLdev;
            ArrayList<SJctrLuPathLdevIndex> pathLdevList;
            short hg;
            SJctrLuPathLdevIndex tmp = (SJctrLuPathLdevIndex)tmpList.get(index);
            short port = tmp.getPort();
            Integer key = new Integer(port << 16 | (hg = tmp.getHostGroup()));
            Object pathLdevObject = portHgmap.get(key);
            if (pathLdevObject == null) {
                pathLdevList = new ArrayList<SJctrLuPathLdevIndex>(tmpList.size() - index);
                portHgmap.put(key, pathLdevList);
            } else {
                pathLdevList = (ArrayList<SJctrLuPathLdevIndex>)pathLdevObject;
            }
            for (int i = index; i < tmpList.size() && (pathLdev = (SJctrLuPathLdevIndex)tmpList.get(i)).getPort() == port && pathLdev.getHostGroup() == hg; ++i) {
                pathLdevList.add(pathLdev);
                ++index;
            }
            pathLdevList.trimToSize();
            retList.add(pathLdevList);
        }
        retList.trimToSize();
        return retList;
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        Set<SJctrGetDirectWrapper> set = super.getModelDirect();
        SJmoGetPortLunInfo kind = new SJmoGetPortLunInfo();
        SJmoGetRange_IF range = null;
        ArrayList filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        return set;
    }

    private String getDefaultStartLun() {
        String start = "";
        if (this.selectData.size() > 0) {
            short lun = this.selectData.get(0).getLun();
            for (SJctrLuPathLdevIndex pathLdev : this.selectData) {
                short nextLun = pathLdev.getLun();
                if (lun <= nextLun) continue;
                lun = nextLun;
            }
            if (this.bLunIdDec) {
                this.getComUtility();
                start = SJctrComUtility.toDecString(lun);
            } else {
                this.getComUtility();
                start = SJctrComUtility.toHexString(lun, 4, true);
            }
        }
        return start;
    }

    private boolean isLunIdNotationDec() {
        boolean bRet = false;
        SJbaseUserSessionInterface userSession = this.getOwner().getUserSession();
        bRet = SJctrPortUtility.isLunIdDecimal(userSession);
        return bRet;
    }
}

