/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.lunm.createhgs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrNotifyState;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.SJctrTableDataModel;
import sanproject.sn2.controller.com.model.event.SJctrMessageEvent;
import sanproject.sn2.controller.com.model.event.SJctrMessageEventListener;
import sanproject.sn2.controller.wizard.SJctrConfirmDataController;
import sanproject.sn2.controller.wizard.lunm.com.SJctrPortHostGroupTableKey;
import sanproject.sn2.controller.wizard.lunm.comdialog.hgproperty.SJctrHGPropertyDC;
import sanproject.sn2.controller.wizard.lunm.comdialog.hgproperty.SJctrHGPropertySelectData;
import sanproject.sn2.controller.wizard.lunm.createhgs.SJctrCreateHostGroupConfirmTableModel;
import sanproject.sn2.controller.wizard.lunm.createhgs.SJctrCreateHostGroupDC;
import sanproject.sn2.controller.wizard.lunm.createhgs.SJctrCreateHostGroupData;
import sanproject.sn2.model.data.device.SJmoPortAttributeInfo;
import sanproject.sn2.model.data.device.SJmoPortDetail;
import sanproject.sn2.modelrc.util.SJmoRscUtil;

public class SJctrCreateHostGroupConfirmDC
extends SJctrConfirmDataController {
    protected static final int DISP_ID = 16781839;
    public static final String KEY_TABLE = "COM_TABLE";
    public static final int EC_START_MODEL_DATA_ERROR = 107005;
    public static final int EC_NOT_SELECT_DETAIL_DATA = 105044;
    public static final int EC_TOO_MANY_SELECT_DETAIL_DATA = 105045;
    public static final int EC_DETAIL_MODEL_NOT_FOUND = 107004;

    public SJctrCreateHostGroupConfirmDC() throws SJcException {
        super(16781839);
        this.initDataModel();
        this.initListener();
    }

    @Override
    public boolean checkStartData() {
        boolean ret = true;
        List<?> confirmDataList = this.getCache("SJctrCreateHostGroupData");
        if (confirmDataList != null && confirmDataList.size() == 1) {
            SJctrCreateHostGroupData confirmData = (SJctrCreateHostGroupData)confirmDataList.get(0);
            List<SJctrPortHostGroupTableKey> portHg = confirmData.getCreateHostGroup();
            List<SJmoPortDetail> portDetail = confirmData.getPortDetail();
            List<SJmoPortAttributeInfo> portAttr = confirmData.getPortAttributeInfo();
            if (portHg == null || portHg.size() <= 0 || portDetail == null || portDetail.size() <= 0 || portAttr == null || portAttr.size() <= 0) {
                SJctrError err = new SJctrError(10, 22, 107005);
                SJcException exp = err.createException();
                throw exp;
            }
        } else {
            SJctrError err = new SJctrError(10, 22, 107005);
            SJcException exp = err.createException();
            throw exp;
        }
        return ret;
    }

    private void initDataModel() {
        SJctrCreateHostGroupConfirmTableModel table = new SJctrCreateHostGroupConfirmTableModel();
        table.setPaging(false);
        this.addDataObjectModel(KEY_TABLE, table);
    }

    private void initListener() {
        this.addMessageEventListener(CONFIRM_MSG.DETAIL, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrPortHostGroupTableKey selectPtHg;
                SJctrTableDataModel targetTable = (SJctrTableDataModel)SJctrCreateHostGroupConfirmDC.this.getDataObjectModel(SJctrCreateHostGroupConfirmDC.KEY_TABLE);
                List<Object> selectedRows = targetTable.getSelectedRowData();
                if (selectedRows.size() == 0) {
                    SJctrLogUty.info(this.getClass().getSimpleName(), "initListener(DETAIL Message)", "Port isn't selected.");
                    SJctrError err = new SJctrError(10, 22, 105044);
                    SJcException exp = err.createException();
                    throw exp;
                }
                if (selectedRows.size() > 1) {
                    SJctrLogUty.info(this.getClass().getSimpleName(), "initListener(DETAIL Message)", "too many Port is selected. Num = " + selectedRows.size());
                    SJctrError err = new SJctrError(10, 22, 105045);
                    SJcException exp = err.createException();
                    throw exp;
                }
                List<?> confirmDataList = SJctrCreateHostGroupConfirmDC.this.getCache("SJctrCreateHostGroupData");
                SJctrCreateHostGroupData confirmData = (SJctrCreateHostGroupData)confirmDataList.get(0);
                List<SJmoPortDetail> ptDtList = confirmData.getPortDetail();
                int index = Collections.binarySearch(ptDtList, (selectPtHg = (SJctrPortHostGroupTableKey)selectedRows.get(0)).getPortHostGroupInfo());
                if (index < 0) {
                    SJctrLogUty.warn(this.getClass().getSimpleName(), "initListener(DETAIL Message)", "Port# Not Found in SJmoPortDetail Class.");
                    SJctrError err = new SJctrError(10, 22, 107004);
                    SJcException exp = err.createException();
                    throw exp;
                }
                SJctrHGPropertySelectData dialogData = new SJctrHGPropertySelectData();
                dialogData.setData(ptDtList.get(index), selectPtHg.getHostGroupInfo());
                ArrayList<SJctrHGPropertySelectData> dialogList = new ArrayList<SJctrHGPropertySelectData>();
                dialogList.add(dialogData);
                HashMap map = new HashMap();
                map.put("HG_PROPERTY_SELECT_DATA", dialogList);
                map.put("CONFIRM_PORTATTR", confirmData.getPortAttributeInfo());
                map.put("CONFIRM_RSG", confirmData.getAllRsgList());
                SJctrRelatedDispDataObject relatedObj = SJctrCreateHostGroupConfirmDC.this.createDialog(SJctrHGPropertyDC.class, map);
                SJctrCreateHostGroupConfirmDC.this.addUpdateDisp(relatedObj);
            }
        });
    }

    @Override
    public Map<String, List<?>> getConfirmData() {
        HashMap retMap = new HashMap();
        retMap.put("SJctrCreateHostGroupData", this.getCache("SJctrCreateHostGroupData"));
        return retMap;
    }

    @Override
    public List<SJmoRscUtil> getRscUtil() {
        List<SJmoRscUtil> rscUtilList = this.getCache(SJctrCreateHostGroupDC.KEY_CLASS_HG_UTIL);
        return rscUtilList;
    }

    public static enum CONFIRM_MSG implements SJctrNotifyState
    {
        DETAIL;

    }
}

