/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.lunm.editaluastate;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrErrorColumnData;
import sanproject.sn2.controller.com.SJctrErrorDataController;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrPortUtility;
import sanproject.sn2.controller.com.SJctrResourceGroupUtility;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.com.model.SJctrRadioButtonGroupDataModel;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.SJctrWizardDataController;
import sanproject.sn2.controller.wizard.lunm.com.SJctrPortHostGroupTableKey;
import sanproject.sn2.controller.wizard.lunm.com.SJctrPortLunTableKey;
import sanproject.sn2.controller.wizard.lunm.editaluastate.SJctrEditALUAStateConfirmData;
import sanproject.sn2.controller.wizard.lunm.editaluastate.SJctrErrorTableModel;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetLdevDetail;
import sanproject.sn2.model.connector.kind.SJmoGetLdevLuseInfo;
import sanproject.sn2.model.connector.kind.SJmoGetLdevNicknameInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortAttributeInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortDetail;
import sanproject.sn2.model.connector.kind.SJmoGetPortHostGroupInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortLunInfo;
import sanproject.sn2.model.connector.kind.SJmoGetRSGgetAllRsgs;
import sanproject.sn2.model.data.device.SJmoPortDetail;
import sanproject.sn2.model.data.device.SJmoPortIndex;
import sanproject.sn2.model.data.lu.SJmoHostGroupIndex;
import sanproject.sn2.model.data.lu.SJmoHostGroupInfo;
import sanproject.sn2.model.data.lu.SJmoPortHostGroupInfo;
import sanproject.sn2.model.data.lu.SJmoPortLunDetail;
import sanproject.sn2.model.data.lu.SJmoPortLunInfo;
import sanproject.sn2.model.data.rsg.SJmoRSGgetAllRsgs;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;
import sanproject.sn2.model.data.volume.SJmoLdevLuseInfo;
import sanproject.sn2.model.data.volume.SJmoLdevNicknameInfo;

public class SJctrEditALUAStateDC
extends SJctrWizardDataController {
    private static final int DISP_ID = 17838161;
    private static final String KEY_ALUA_STATE = "COM_ASYM_ACC_STATE";
    private static final String KEY_OPT = "COM_ACT_OPT";
    private static final String KEY_NON_OPT = "COM_ACT_NON_OPT";
    public static final String TITLE = "DISP_DI305S_TITLE";
    public static final Class KEY_CLASS_PORTHGFROMLV = SJctrPortHostGroupTableKey.class;
    public static final Class KEY_CLASS_PORTLUNFROMLV = SJctrPortLunTableKey.class;
    public static final Class KEY_CLASS_PORTLUN = SJmoGetPortLunInfo.class;
    public static final Class KEY_CLASS_PORTHG = SJmoGetPortHostGroupInfo.class;
    public static final Class KEY_CLASS_PORTATTRIBUTE = SJmoGetPortAttributeInfo.class;
    public static final Class KEY_CLASS_PORTDETAIL = SJmoGetPortDetail.class;
    public static final Class KEY_CLASS_LDEVDETAL = SJmoGetLdevDetail.class;
    public static final Class KEY_CLASS_LDEVLUSE = SJmoGetLdevLuseInfo.class;
    public static final Class KEY_CLASS_LDEVNAME = SJmoGetLdevNicknameInfo.class;
    public static final Class KEY_CLASS_RSG = SJmoGetRSGgetAllRsgs.class;
    public static final Class KEY_CLASS_CONFIRM_DATA = SJctrEditALUAStateConfirmData.class;
    public static int ERR_EDIT_ALUASTATE_NOSELECT = 107001;
    public static int ERR_INTERNAL_ERROR = 107002;
    public static int ERR_EDIT_ALUASTATE_NOEQUIPHG = 106502;
    public static int ERR_EDIT_ALUASTATE_NORADIOSELECT = 105083;
    public static int ERR_EDIT_ALUASTATE_RSGNOPERM = 105297;
    public static int ERR_EDIT_ALUASTATE_NOLUN = 105505;
    public static int ERR_EDIT_ALUASTATE_SysRSG_HG = 205164;
    private SJctrRadioButtonGroupDataModel radio = null;
    private List<SJctrPortHostGroupTableKey> selectHGList;
    private List<SJctrPortLunTableKey> selectPTList;
    private List<SJmoPortHostGroupInfo> portHostGroupInfoList;
    private List<SJmoPortLunInfo> portLunInfoList;
    private List<SJmoPortDetail> portDetailList;
    private List<SJmoLdevDetail> ldevDetailList;
    private List<SJmoLdevLuseInfo> ldevLuseList;
    private List<SJmoLdevNicknameInfo> ldevNicknameList;
    private List<SJmoPortLunInfo> selectPortLunInfoList;
    private List<SJmoPortLunInfo> confirmPortLunList;
    private List<SJmoPortHostGroupInfo> confirmPortHgList;
    private List<SJmoPortDetail> confirmPortDetailList;
    private List<SJmoLdevDetail> confirmLdevDetailList;
    private List<SJmoLdevLuseInfo> confirmLdevLuseList;
    private List<SJmoLdevNicknameInfo> confirmLdevNicknameList;
    private byte aluaStateInit = (byte)-1;
    private byte aluaStateSelect = 0;

    public SJctrEditALUAStateDC() throws SJcException {
        super(17838161);
        this.initDataModel();
    }

    @Override
    public String getDispName() {
        return this.getComUtility().getGuidance(TITLE);
    }

    private void initDataModel() {
        this.radio = new SJctrRadioButtonGroupDataModel();
        this.radio.add(KEY_OPT);
        this.radio.add(KEY_NON_OPT);
        this.addDataObjectModel(KEY_ALUA_STATE, this.radio);
        this.addDataObjectModel("COM_FOOTER", new SJctrFooterDataModel());
    }

    @Override
    public boolean checkStartData() {
        this.selectHGList = this.getCache(KEY_CLASS_PORTHGFROMLV);
        if (this.selectHGList == null || this.selectHGList.size() == 0) {
            SJctrError err = new SJctrError(10, 22, ERR_EDIT_ALUASTATE_NOSELECT);
            SJcException exp = err.createException();
            throw exp;
        }
        return true;
    }

    @Override
    public boolean checkConstructData() {
        boolean ret = true;
        this.portHostGroupInfoList = this.getCache(KEY_CLASS_PORTHG);
        if (this.portHostGroupInfoList == null) {
            SJctrError err = new SJctrError(10, 22, ERR_INTERNAL_ERROR);
            SJcException exp = err.createException();
            throw exp;
        }
        this.portLunInfoList = this.getCache(KEY_CLASS_PORTLUN);
        if (this.portLunInfoList == null) {
            SJctrError err = new SJctrError(10, 22, ERR_INTERNAL_ERROR);
            SJcException exp = err.createException();
            throw exp;
        }
        this.portDetailList = this.getCache(KEY_CLASS_PORTDETAIL);
        if (this.portDetailList == null) {
            SJctrError err = new SJctrError(10, 22, ERR_INTERNAL_ERROR);
            SJcException exp = err.createException();
            throw exp;
        }
        this.ldevDetailList = this.getCache(KEY_CLASS_LDEVDETAL);
        if (this.ldevDetailList == null) {
            SJctrError err = new SJctrError(10, 22, ERR_INTERNAL_ERROR);
            SJcException exp = err.createException();
            throw exp;
        }
        this.ldevLuseList = this.getCache(KEY_CLASS_LDEVLUSE);
        if (this.ldevLuseList == null) {
            SJctrError err = new SJctrError(10, 22, ERR_INTERNAL_ERROR);
            SJcException exp = err.createException();
            throw exp;
        }
        this.ldevNicknameList = this.getCache(KEY_CLASS_LDEVNAME);
        if (this.ldevNicknameList == null) {
            SJctrError err = new SJctrError(10, 22, ERR_INTERNAL_ERROR);
            SJcException exp = err.createException();
            throw exp;
        }
        ArrayList<SJctrError> errlist = new ArrayList<SJctrError>(this.selectHGList.size());
        for (int errpos = 0; errpos < this.selectHGList.size(); ++errpos) {
            SJctrError oneError = new SJctrError(0, 0, 0);
            errlist.add(oneError);
        }
        ret = this.checkEquipHg(this.selectHGList, errlist);
        if (ret) {
            ret = this.checkLunNum(this.selectHGList, this.portLunInfoList, errlist);
        }
        if (!ret) {
            ArrayList<SJctrErrorColumnData> errColumnList = new ArrayList<SJctrErrorColumnData>(this.selectHGList.size());
            ArrayList<SJctrPortHostGroupTableKey> tableKeyList = new ArrayList<SJctrPortHostGroupTableKey>(this.selectHGList.size());
            for (int errpos = 0; errpos < this.selectHGList.size(); ++errpos) {
                SJctrError oneError = errlist.get(errpos);
                if (oneError.getError() == 0) continue;
                SJctrErrorColumnData errColumn = new SJctrErrorColumnData(this.selectHGList.get(errpos), oneError);
                errColumnList.add(errColumn);
                tableKeyList.add(this.selectHGList.get(errpos));
            }
            SJctrError errInfo = ((SJctrErrorColumnData)errColumnList.get(0)).getError();
            SJctrErrorTableModel errTable = new SJctrErrorTableModel(tableKeyList);
            errTable.setDataController(this);
            errTable.initGuidance(this.getComUtility());
            errTable.createModelDirect();
            errTable.divideModelData(this.getProxy().getModelDataMap());
            errTable.makeDataModel();
            SJctrRelatedDispDataObject rel = this.createDialog(SJctrErrorDataController.class, null);
            SJctrErrorDataController errDc = (SJctrErrorDataController)this.getOwner().getDataController(rel);
            errDc.setParameter(errTable, errColumnList);
            SJcException exp = errInfo.createException();
            exp.setErrDisp(rel);
            throw exp;
        }
        this.getConfirmPortInfo();
        this.getConfirmLdevInfo();
        SJctrEditALUAStateConfirmData confirmData = new SJctrEditALUAStateConfirmData();
        confirmData.setAllRsgList(this.getCache(KEY_CLASS_RSG));
        confirmData.setPortHGTableKey(this.selectHGList);
        confirmData.setPortLunTableKey(this.selectPTList);
        confirmData.setPortHgList(this.confirmPortHgList);
        confirmData.setPortLunList(this.confirmPortLunList);
        confirmData.setPortDetailList(this.confirmPortDetailList);
        confirmData.setLdevDetailList(this.confirmLdevDetailList);
        confirmData.setLdevLuseInfoList(this.confirmLdevLuseList);
        confirmData.setLdevNicknameInfoList(this.confirmLdevNicknameList);
        ArrayList<SJctrEditALUAStateConfirmData> confirmDataList = new ArrayList<SJctrEditALUAStateConfirmData>();
        confirmDataList.add(confirmData);
        this.putCache(KEY_CLASS_CONFIRM_DATA, confirmDataList);
        return ret;
    }

    private boolean checkEquipHg(List<SJctrPortHostGroupTableKey> portHg, List<SJctrError> errList) {
        boolean ret = true;
        List<?> rsgDetailList = this.getCache(KEY_CLASS_RSG);
        if (rsgDetailList == null || rsgDetailList.size() == 0) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkEquipHg", "SJmoRSGgetAllRsgs Not Found in the Cache.");
            SJctrError err = new SJctrError(10, 22, ERR_INTERNAL_ERROR);
            SJcException exp = err.createException();
            throw exp;
        }
        SJctrResourceGroupUtility rsgUtil = new SJctrResourceGroupUtility(this.getOwner(), (SJmoRSGgetAllRsgs)rsgDetailList.get(0));
        SJmoHostGroupIndex hgIndex = new SJmoHostGroupIndex();
        for (int index = 0; index < portHg.size(); ++index) {
            SJctrPortHostGroupTableKey onePtHgKey = portHg.get(index);
            boolean includeInfo = false;
            int searchRet = Collections.binarySearch(this.portHostGroupInfoList, onePtHgKey.getPortHostGroupInfo());
            if (searchRet >= 0) {
                SJmoPortHostGroupInfo oneModelPt = this.portHostGroupInfoList.get(searchRet);
                ArrayList hgArray = oneModelPt.getAlPortHostGroup();
                for (SJmoHostGroupInfo oneModelHg : hgArray) {
                    if (oneModelHg.getSHostGroup() != onePtHgKey.getHostGroupInfo().getSHostGroup()) continue;
                    includeInfo = true;
                    hgIndex.setSPort(oneModelHg.getSPort());
                    hgIndex.setSHostGroup(oneModelHg.getSHostGroup());
                    boolean rsgFlg = SJctrPortUtility.isRsgHostGroupIndex(hgIndex, rsgUtil);
                    if (!rsgFlg) {
                        ret = false;
                        SJctrError errElement = errList.get(index);
                        errElement.setFunc(10);
                        errElement.setModule(22);
                        errElement.setError(ERR_EDIT_ALUASTATE_RSGNOPERM);
                        continue;
                    }
                    boolean sysRsgFlg = rsgUtil.isSelRscHgInSysRsg(hgIndex);
                    if (!sysRsgFlg) continue;
                    ret = false;
                    SJctrError errElement = errList.get(index);
                    errElement.setFunc(10);
                    errElement.setModule(22);
                    errElement.setError(ERR_EDIT_ALUASTATE_SysRSG_HG);
                }
            }
            if (includeInfo) continue;
            ret = false;
            SJctrError errElement = errList.get(index);
            errElement.setFunc(10);
            errElement.setModule(22);
            errElement.setError(ERR_EDIT_ALUASTATE_NOEQUIPHG);
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkEquipHg", "Port# = " + onePtHgKey.getPortHostGroupInfo().getSPort() + ", HostGroup # = " + onePtHgKey.getHostGroupInfo().getSHostGroup() + " Not Found.");
        }
        return ret;
    }

    private boolean checkLunNum(List<SJctrPortHostGroupTableKey> portHg, List<SJmoPortLunInfo> portLun, List<SJctrError> errList) {
        boolean ret = true;
        boolean aluaStateFirst = true;
        byte aluaState = -1;
        this.selectPTList = new ArrayList<SJctrPortLunTableKey>();
        for (int index = 0; index < portHg.size(); ++index) {
            SJctrPortHostGroupTableKey onePtHgKey = portHg.get(index);
            int num = 0;
            for (SJmoPortLunInfo ptLun : portLun) {
                if (onePtHgKey.getPortHostGroupInfo().getSPort() != ptLun.getSPort()) continue;
                SJmoHostGroupInfo hgInfo = onePtHgKey.getHostGroupInfo();
                ArrayList ptLunDetailList = ptLun.getAlPortLun();
                for (SJmoPortLunDetail ptLunDetail : ptLunDetailList) {
                    if (hgInfo.getSHostGroup() != ptLunDetail.getSHostGroup()) continue;
                    ++num;
                    this.selectPTList.add(new SJctrPortLunTableKey(ptLun, ptLunDetail));
                    byte state = ptLunDetail.getByAsymmetricAccessState();
                    if (aluaStateFirst) {
                        aluaState = state;
                        this.aluaStateInit = state;
                        aluaStateFirst = false;
                        continue;
                    }
                    if (aluaState == state) continue;
                    this.aluaStateInit = (byte)-1;
                }
            }
            if (num != 0) continue;
            ret = false;
            SJctrError errElement = errList.get(index);
            errElement.setFunc(10);
            errElement.setModule(22);
            errElement.setError(ERR_EDIT_ALUASTATE_NOLUN);
        }
        Collections.sort(this.selectPTList);
        return ret;
    }

    private void getConfirmPortInfo() {
        this.confirmPortHgList = new ArrayList<SJmoPortHostGroupInfo>();
        this.confirmPortLunList = new ArrayList<SJmoPortLunInfo>();
        this.confirmPortDetailList = new ArrayList<SJmoPortDetail>();
        for (SJctrPortHostGroupTableKey ptHgKey : this.selectHGList) {
            int searchResult = Collections.binarySearch(this.portHostGroupInfoList, ptHgKey.getPortHostGroupInfo());
            if (searchResult >= 0) {
                SJmoPortHostGroupInfo portHg = this.portHostGroupInfoList.get(searchResult);
                try {
                    this.confirmPortHgList.add((SJmoPortHostGroupInfo)portHg.clone());
                }
                catch (CloneNotSupportedException e) {
                    this.getLogUty().putlog("editAluaState", "SJmoPortHostGroupInfo clone fail", e, 40000);
                }
            }
            if ((searchResult = Collections.binarySearch(this.portLunInfoList, ptHgKey.getPortHostGroupInfo())) >= 0) {
                SJmoPortLunInfo portLun = this.portLunInfoList.get(searchResult);
                try {
                    this.confirmPortLunList.add((SJmoPortLunInfo)portLun.clone());
                }
                catch (CloneNotSupportedException e) {
                    this.getLogUty().putlog("editAluaState", "SJmoPortLunInfo clone fail", e, 40000);
                }
            }
            if ((searchResult = Collections.binarySearch(this.portDetailList, ptHgKey.getPortHostGroupInfo())) < 0) continue;
            SJmoPortDetail portDetail = this.portDetailList.get(searchResult);
            try {
                this.confirmPortDetailList.add((SJmoPortDetail)portDetail.clone());
            }
            catch (CloneNotSupportedException e) {
                this.getLogUty().putlog("editAluaState", "SJmoPortDetail clone fail", e, 40000);
            }
        }
        Collections.sort(this.confirmPortHgList);
        Collections.sort(this.confirmPortLunList);
        Collections.sort(this.confirmPortDetailList);
    }

    private void getConfirmLdevInfo() {
        ArrayList<SJmoLdevDetail> detailList = new ArrayList<SJmoLdevDetail>();
        ArrayList<SJmoLdevLuseInfo> luseList = new ArrayList<SJmoLdevLuseInfo>();
        ArrayList<SJmoLdevNicknameInfo> nicknameList = new ArrayList<SJmoLdevNicknameInfo>();
        SJmoPortIndex searchPortIndex = new SJmoPortIndex();
        for (SJctrPortHostGroupTableKey ptHgKey : this.selectHGList) {
            ArrayList alPort = ptHgKey.getPortHostGroupInfo().getAlPortHostGroup();
            for (SJmoHostGroupInfo hgInfo : alPort) {
                searchPortIndex.setSPort(hgInfo.getSPort());
                int portLunIndex = Collections.binarySearch(this.portLunInfoList, searchPortIndex);
                if (portLunIndex < 0) continue;
                SJmoPortLunInfo portLun = this.portLunInfoList.get(portLunIndex);
                ArrayList alHGLun = portLun.getAlHostGroupLun(hgInfo.getSHostGroup());
                for (SJmoPortLunDetail portLunDetail : alHGLun) {
                    SJmoLdevNicknameInfo ldevNickname;
                    SJmoLdevLuseInfo ldevLuse;
                    SJmoLdevDetail ldevDetail;
                    SJmoLdevIndex ldevIndex = new SJmoLdevIndex();
                    ldevIndex.setLdevIndex(portLunDetail.getSLDKC(), portLunDetail.getSCU(), portLunDetail.getSLDEV());
                    int searchResult = Collections.binarySearch(this.ldevDetailList, ldevIndex);
                    if (searchResult >= 0 && detailList.indexOf(ldevDetail = this.ldevDetailList.get(searchResult)) < 0) {
                        detailList.add(ldevDetail);
                    }
                    if ((searchResult = Collections.binarySearch(this.ldevLuseList, ldevIndex)) >= 0 && luseList.indexOf(ldevLuse = this.ldevLuseList.get(searchResult)) < 0) {
                        luseList.add(ldevLuse);
                    }
                    if ((searchResult = Collections.binarySearch(this.ldevNicknameList, ldevIndex)) < 0 || nicknameList.indexOf(ldevNickname = this.ldevNicknameList.get(searchResult)) >= 0) continue;
                    nicknameList.add(ldevNickname);
                }
            }
        }
        this.confirmLdevDetailList = new ArrayList<SJmoLdevDetail>(detailList.size());
        this.confirmLdevLuseList = new ArrayList<SJmoLdevLuseInfo>(luseList.size());
        this.confirmLdevNicknameList = new ArrayList<SJmoLdevNicknameInfo>(nicknameList.size());
        for (SJmoLdevDetail detail : detailList) {
            try {
                SJmoLdevDetail ldevDetailClone = (SJmoLdevDetail)detail.clone();
                this.confirmLdevDetailList.add(ldevDetailClone);
            }
            catch (CloneNotSupportedException e) {
                this.getLogUty().putlog("editAluaState", "SJmoLdevDetail clone fail", e, 40000);
            }
        }
        for (SJmoLdevLuseInfo luse : luseList) {
            try {
                SJmoLdevLuseInfo ldevLuseClone = (SJmoLdevLuseInfo)luse.clone();
                this.confirmLdevLuseList.add(ldevLuseClone);
            }
            catch (CloneNotSupportedException e) {
                this.getLogUty().putlog("editAluaState", "SJmoLdevLuseInfo clone fail", e, 40000);
            }
        }
        for (SJmoLdevNicknameInfo nickname : nicknameList) {
            try {
                SJmoLdevNicknameInfo ldevNicknameClone = (SJmoLdevNicknameInfo)nickname.clone();
                this.confirmLdevNicknameList.add(ldevNicknameClone);
            }
            catch (CloneNotSupportedException e) {
                this.getLogUty().putlog("editAluaState", "SJmoLdevNicknameInfo clone fail", e, 40000);
            }
        }
        Collections.sort(this.confirmLdevDetailList);
        Collections.sort(this.confirmLdevLuseList);
        Collections.sort(this.confirmLdevNicknameList);
    }

    @Override
    public void makeDataModel() {
        super.makeDataModel();
        if (this.aluaStateInit == 0) {
            this.radio.setSelect(KEY_OPT);
        } else if (this.aluaStateInit == 1) {
            this.radio.setSelect(KEY_NON_OPT);
        }
    }

    @Override
    public boolean checkEndData() {
        if (this.radio.isSelect(KEY_OPT)) {
            this.aluaStateSelect = 0;
        } else if (this.radio.isSelect(KEY_NON_OPT)) {
            this.aluaStateSelect = 1;
        } else {
            SJctrError err = new SJctrError(10, 22, ERR_EDIT_ALUASTATE_NORADIOSELECT);
            SJcException exp = err.createException();
            throw exp;
        }
        List<?> confirmDataList = this.getCache(KEY_CLASS_CONFIRM_DATA);
        if (confirmDataList == null || confirmDataList.isEmpty()) {
            return false;
        }
        SJctrEditALUAStateConfirmData confirmData = (SJctrEditALUAStateConfirmData)confirmDataList.get(0);
        List<SJctrPortLunTableKey> portLunTableKeyList = confirmData.getPortLunTableKey();
        ArrayList<SJctrPortLunTableKey> newPortLunTableKeyList = new ArrayList<SJctrPortLunTableKey>(portLunTableKeyList.size());
        for (SJctrPortLunTableKey portLunTableKey : portLunTableKeyList) {
            try {
                SJmoPortLunDetail portLunDetail = (SJmoPortLunDetail)portLunTableKey.getPortLunDetail().clone();
                portLunDetail.setByAsymmetricAccessState(this.aluaStateSelect);
                newPortLunTableKeyList.add(new SJctrPortLunTableKey(portLunTableKey.getPortLunInfo(), portLunDetail));
            }
            catch (CloneNotSupportedException e) {
                this.getLogUty().putlog("editAluaState", "SJmoPortLunDetail clone fail", e, 40000);
            }
        }
        Collections.sort(newPortLunTableKeyList);
        confirmData.setPortLunTableKey(newPortLunTableKeyList);
        ArrayList<SJctrEditALUAStateConfirmData> newConfirmDataList = new ArrayList<SJctrEditALUAStateConfirmData>(1);
        newConfirmDataList.add(confirmData);
        this.putCache(KEY_CLASS_CONFIRM_DATA, newConfirmDataList);
        return true;
    }

    protected Set<SJmoGetKind_IF> getKindSet() {
        HashSet<SJmoGetKind_IF> kindSet = new HashSet<SJmoGetKind_IF>();
        kindSet.add(new SJmoGetPortLunInfo());
        kindSet.add(new SJmoGetPortHostGroupInfo());
        kindSet.add(new SJmoGetPortDetail());
        kindSet.add(new SJmoGetLdevDetail());
        kindSet.add(new SJmoGetLdevLuseInfo());
        kindSet.add(new SJmoGetLdevNicknameInfo());
        kindSet.add(new SJmoGetRSGgetAllRsgs());
        return kindSet;
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        Set<SJctrGetDirectWrapper> set = super.getModelDirect();
        SJmoGetRange_IF range = null;
        ArrayList filterList = new ArrayList();
        Set<SJmoGetKind_IF> kindSet = this.getKindSet();
        for (SJmoGetKind_IF kind : kindSet) {
            SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
            set.add(new SJctrGetDirectWrapper(direct));
        }
        return set;
    }
}

